/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.Arrays;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/UIIntranetNotificationsPortlet.gtmpl")
public class UIIntranetNotificationsPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIIntranetNotificationsPortlet.class);
    private final WebNotificationService webNotifService = (WebNotificationService)this.getApplicationComponent(WebNotificationService.class);
    private static final String EXO_NOTIFICATION_MARK_ALL_READ = "MarkAllAsReadLink";
    private static final String LOAD_MORE_KEY = "loadMoreNotif";
    private static final String REMOVE_ITEM_KEY = "removeNotif";
    private static final String ADD_ITEM_KEY = "addNotif";
    private static final int ITEMS_LOADED_NUM = 21;
    private static final int ITEMS_PER_PAGE = 20;
    private String currentUser = "";
    private int offset = 0;
    private boolean hasMore = false;

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.currentUser = context.getRemoteUser();
        this.offset = 0;
        this.hasMore = false;
        super.processRender(app, context);
    }

    public void serveResource(WebuiRequestContext context) throws Exception {
        super.serveResource(context);
        ResourceRequest req = (ResourceRequest)context.getRequest();
        String resourceId = req.getResourceID();
        if (LOAD_MORE_KEY.equals(resourceId) && this.hasMore) {
            List moreNotifications = this.getNotifications();
            StringBuffer sb = new StringBuffer();
            for (String notif : moreNotifications) {
                sb.append(notif);
            }
            MimeResponse res = (MimeResponse)context.getResponse();
            res.setContentType("application/json");
            JSONObject object = new JSONObject();
            object.put("context", (Object)sb.toString());
            object.put("hasMore", (Object)String.valueOf(this.hasMore));
            res.getWriter().write(object.toString());
        }
        if (REMOVE_ITEM_KEY.equals(resourceId) && this.offset > 0) {
            --this.offset;
        }
        if (ADD_ITEM_KEY.equals(resourceId)) {
            ++this.offset;
        }
        if (EXO_NOTIFICATION_MARK_ALL_READ.equals(resourceId)) {
            this.webNotifService.markAllRead(this.currentUser);
            this.webNotifService.resetNumberOnBadge(this.currentUser);
        }
    }

    protected String getLoadMoreURL() {
        return this.buildResourceURL(LOAD_MORE_KEY);
    }

    protected String buildResourceURL(String key) {
        try {
            WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            MimeResponse res = (MimeResponse)ctx.getResponse();
            ResourceURL rsURL = res.createResourceURL();
            rsURL.setResourceID(key);
            return rsURL.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isAnyUnreadNotification() {
        WebNotificationFilter filter = new WebNotificationFilter(this.currentUser);
        List notifsInfos = this.webNotifService.getNotificationInfos(filter, this.offset, filter.getLimitDay());
        if (notifsInfos != null) {
            return notifsInfos.stream().anyMatch(notificationInfo -> !notificationInfo.isRead());
        }
        return false;
    }

    protected List<String> getNotifications() throws Exception {
        WebNotificationFilter filter = new WebNotificationFilter(this.currentUser);
        if (this.hasMore) {
            this.offset += 20;
        }
        LOG.debug((Object)("Current offset of page: " + this.offset));
        List notificationContents = this.webNotifService.get(filter, this.offset, 21);
        this.hasMore = notificationContents.size() > 20;
        return this.hasMore ? notificationContents.subList(0, 20) : notificationContents;
    }

    protected String getUserNotificationSettingUrl() {
        return LinkProvider.getUserNotificationSettingUri((String)this.currentUser);
    }

    protected List<String> getActions() {
        return Arrays.asList(ADD_ITEM_KEY, REMOVE_ITEM_KEY, EXO_NOTIFICATION_MARK_ALL_READ);
    }
}

