/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;

public class SpaceMenuPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(SpaceMenuPortlet.class);
    private String viewDispatchedPath;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.viewDispatchedPath = config.getInitParameter("portlet-view-dispatched-file-path");
        if (StringUtils.isBlank((String)this.viewDispatchedPath)) {
            throw new IllegalStateException("Portlet init parameter 'portlet-view-dispatched-file-path' is mandatory");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Space space = SpaceUtils.getSpaceByContext();
        if (space == null) {
            return;
        }
        HttpServletRequest httpRequest = Util.getPortalRequestContext().getRequest();
        httpRequest.setAttribute("SPACE_MENU_DISPLAYED", (Object)true);
        Locale locale = request.getLocale();
        String currentUser = request.getRemoteUser();
        try {
            List navigations = SpaceUtils.getSpaceNavigations((Space)space, (Locale)locale, (String)currentUser);
            request.setAttribute("navigations", (Object)navigations);
            Map<String, String> navigationMap = navigations.stream().collect(Collectors.toMap(UserNode::getId, userNode -> SpaceUtils.getUri((UserNode)userNode)));
            request.setAttribute("navigationsUri", navigationMap);
            UserNode selectedUserNode = Util.getUIPortal().getSelectedUserNode();
            request.setAttribute("selectedUri", (Object)navigationMap.get(selectedUserNode.getId()));
            request.setAttribute("isSpaceHome", (Object)SpaceUtils.isHomeNavigation((UserNode)selectedUserNode));
            SpaceUtils.setPageTitle((List)navigations, (RenderRequest)request, (Space)space, (Locale)locale);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error displaying space menu", (Throwable)e);
        }
        PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(this.viewDispatchedPath);
        requestDispatcher.include(request, response);
    }
}

