/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swf.sonar.plugin.rules;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="WebUiCsrfCheck", name="WebUI CSRF protection check", description="This rule checks that all the WebUI action listeners have CSRF protection activated", tags={"security"}, priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class WebUiCsrfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String EVENT_CONFIG = "EventConfig";
    private static final String ISSUE_MESSAGE = "WebUI CSRF protection must be activated";
    private static final String PHASE = "phase";
    private static final String CSRF_CHECK = "csrfCheck";
    private static final String DECODE = "DECODE";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        if (EVENT_CONFIG.equals(this.getAnnotationName((ExpressionTree)annotationTree)) && this.isProcessWebUIPhase(annotationTree) && !this.isCsrfTrue(annotationTree)) {
            this.context.reportIssue((JavaCheck)this, (Tree)annotationTree, ISSUE_MESSAGE);
        }
        super.visitAnnotation(annotationTree);
    }

    private boolean isCsrfTrue(AnnotationTree annotationTree) {
        for (ExpressionTree argument : annotationTree.arguments()) {
            LiteralTree expression;
            IdentifierTree variable;
            AssignmentExpressionTree assExpTree;
            if (!argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !(assExpTree = (AssignmentExpressionTree)argument).variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !CSRF_CHECK.equalsIgnoreCase((variable = (IdentifierTree)assExpTree.variable()).name()) || !assExpTree.expression().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL}) || !Boolean.valueOf((expression = (LiteralTree)assExpTree.expression()).value()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isProcessWebUIPhase(AnnotationTree annotationTree) {
        for (ExpressionTree argument : annotationTree.arguments()) {
            IdentifierTree variable;
            AssignmentExpressionTree assExpTree;
            if (!argument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) || !(assExpTree = (AssignmentExpressionTree)argument).variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !PHASE.equalsIgnoreCase((variable = (IdentifierTree)assExpTree.variable()).name())) continue;
            String phaseValue = ((MemberSelectExpressionTree)assExpTree.expression()).identifier().name();
            return !DECODE.equalsIgnoreCase(phaseValue);
        }
        return true;
    }

    private String getAnnotationName(ExpressionTree initializer) {
        String result = "";
        if (initializer.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            TypeTree annotationType = ((AnnotationTree)initializer).annotationType();
            if (annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                result = ((IdentifierTree)annotationType).name();
            } else if (annotationType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                result = this.fullName((MemberSelectExpressionTree)annotationType);
            }
        }
        return result;
    }

    private String fullName(MemberSelectExpressionTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree.expression()).name() + "." + tree.identifier().name();
        }
        return this.fullName((MemberSelectExpressionTree)tree.expression()) + "." + tree.identifier().name();
    }
}

