/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseFunctionInfo {
    String path = "";
    String relatedFunction = "";
    String priority = "";
    String id = "";
    Set<String> testCases = new HashSet<String>();
    Set<String> comments = new HashSet<String>();
    Map<String, RunResultAggregator> resultsPerBrowser = new HashMap<String, RunResultAggregator>();

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public Set<String> getComments() {
        return this.comments;
    }

    public TestCaseFunctionInfo(String path, String relatedFunction, String priority) {
        this.path = path;
        this.id = relatedFunction;
        this.priority = priority;
    }

    public void incrementTestCaseCount(String caseId) {
        this.testCases.add(caseId);
    }

    public boolean incrementTestResult(String browser, String tester, String caseId, String value) {
        RunResultAggregator runResultCount = this.resultsPerBrowser.get(browser);
        if (runResultCount == null) {
            runResultCount = new RunResultAggregator();
            this.resultsPerBrowser.put(browser, runResultCount);
        }
        return runResultCount.registerTesterResult(tester, caseId, value);
    }

    public int getTestNotRunCount(String browser) {
        return this.resultsPerBrowser.get(browser).getTestNotRunCount();
    }

    public int getTestPassedCount(String browser) {
        return this.resultsPerBrowser.get(browser).getTestPassedCount();
    }

    public int getTestFailedCount(String browser) {
        return this.resultsPerBrowser.get(browser).getTestFailedCount();
    }

    public int getTestBlockedCount(String browser) {
        return this.resultsPerBrowser.get(browser).getTestBlockedCount();
    }

    public int getTestCaseCount() {
        return this.testCases.size();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelatedFunction() {
        return this.relatedFunction;
    }

    public void setRelatedFunction(String relatedFunction) {
        this.relatedFunction = relatedFunction;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCaseFunctionInfo other = (TestCaseFunctionInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    class TesterResultAggregator {
        int testNotRunCount;
        int testPassedCount;
        int testFailedCount;
        int testBlockedCount;

        TesterResultAggregator() {
        }

        public void incrementTestNotRunCount() {
            ++this.testNotRunCount;
        }

        public void incrementTestPassedCount() {
            ++this.testPassedCount;
        }

        public void incrementTestFailedCount() {
            ++this.testFailedCount;
        }

        public void incrementTestBlockedCount() {
            ++this.testBlockedCount;
        }
    }

    class RunResultAggregator {
        int STATUS_NOT_RUN = 0;
        int STATUS_PASSED = 1;
        int STATUS_BLOCKED = 2;
        int STATUS_FAILED = 3;
        String[] statusTable = new String[]{"", "PASSED", "BLOCKED", "FAILED"};
        Map<String, Integer> testCount = new HashMap<String, Integer>();

        RunResultAggregator() {
        }

        public boolean registerTesterResult(String tester, String caseId, String value) {
            String key = caseId;
            Integer runResultCount = this.testCount.get(key);
            if (runResultCount == null) {
                runResultCount = 0;
            }
            int level = this.STATUS_NOT_RUN;
            String cleanValue = value.trim();
            if ("PASSED".equalsIgnoreCase(cleanValue) || "OK".equalsIgnoreCase(cleanValue) || "PASS".equalsIgnoreCase(cleanValue)) {
                level = this.STATUS_PASSED;
            } else if ("BLOCKED".equalsIgnoreCase(cleanValue) || "N/A".equalsIgnoreCase(cleanValue) || "NA".equalsIgnoreCase(cleanValue)) {
                level = this.STATUS_BLOCKED;
            } else if ("FAILED".equalsIgnoreCase(cleanValue) || "FAIL".equalsIgnoreCase(cleanValue)) {
                level = this.STATUS_FAILED;
            } else if ("".equals(cleanValue) || "Untested".equals(cleanValue)) {
                level = this.STATUS_NOT_RUN;
            } else {
                return false;
            }
            if (level >= runResultCount) {
                this.testCount.put(key, level);
            }
            return true;
        }

        private int countStatus(int status) {
            int count = 0;
            Set<String> keySet = this.testCount.keySet();
            for (String tester : keySet) {
                int statusValue = this.testCount.get(tester);
                if (statusValue != status) continue;
                ++count;
            }
            return count;
        }

        public int getTestNotRunCount() {
            return this.countStatus(this.STATUS_NOT_RUN);
        }

        public int getTestPassedCount() {
            return this.countStatus(this.STATUS_PASSED);
        }

        public int getTestBlockedCount() {
            return this.countStatus(this.STATUS_BLOCKED);
        }

        public int getTestFailedCount() {
            return this.countStatus(this.STATUS_FAILED);
        }
    }
}

