/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.xml.sax.SAXException;

public class SheetTest
extends TestCase {
    static final DefaultTableModel tm = new DefaultTableModel();
    private Sheet sheet;
    private Sheet realSheet;

    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, NS.getOOo()).getSheet(0);
        this.realSheet = SpreadSheet.create(new ODPackage(this.getClass().getResourceAsStream("test.ods"))).getSheet(0);
    }

    protected void tearDown() throws Exception {
        this.sheet = null;
        this.realSheet = null;
    }

    public void testSetValueAt() {
        SheetTest.assertEquals((Object)"col1", this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        SheetTest.assertEquals((Object)"test", this.sheet.getValueAt(0, 0));
        Calendar calendar = Calendar.getInstance();
        this.sheet.setValueAt(calendar.getTime(), 0, 0);
        Object object = this.sheet.getValueAt(0, 0);
        SheetTest.assertEquals(calendar.getTime(), object);
    }

    public void testGetValueAtIntInt() {
        SheetTest.assertEquals(new Float(123.0f), this.sheet.getValueAt(2, 1));
    }

    public void testGetValueAtString() {
        SheetTest.assertEquals(new Float(123.0f), this.sheet.getValueAt("C2"));
        SheetTest.assertFalse(new Integer(123).equals(this.sheet.getValueAt("C2")));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2008, 11, 25);
        SheetTest.assertEquals(calendar.getTime(), this.realSheet.getValueAt("F3"));
    }

    public void testGetRowCount() {
        SheetTest.assertEquals(2, this.sheet.getRowCount());
    }

    public void testGetColumnCount() {
        SheetTest.assertEquals(3, this.sheet.getColumnCount());
    }

    public void testEnsureColumnCount() {
        int n = this.sheet.getColumnCount();
        int n2 = n - 2;
        this.sheet.ensureColumnCount(n2);
        SheetTest.assertEquals(n, this.sheet.getColumnCount());
    }

    public void testSetColumnCount() throws Exception {
        int n = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", n - 1, 0);
            SheetTest.fail("should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.sheet.setColumnCount(n);
        this.sheet.setValueAt("test", n - 1, 0);
        int n2 = this.realSheet.getColumnCount();
        try {
            this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
            SheetTest.fail("should throw exn since we try to write past the limit");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.realSheet.setColumnCount(n2 + 10);
        this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(15360);
        this.realSheet.getSpreadSheet().getPackage().save(byteArrayOutputStream);
        SpreadSheet spreadSheet = SpreadSheet.create(new ODPackage(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        SheetTest.assertEquals((Object)"over", spreadSheet.getSheet(0).getValueAt(n2 + 10 - 1, 1));
        SheetTest.assertNull(this.isValidXML(this.realSheet.getSpreadSheet()));
    }

    public void testSetRowCount() throws IOException {
        this.realSheet.setRowCount(3);
        SpreadSheet spreadSheet = new SpreadSheet(((SpreadSheet)this.realSheet.getODDocument()).getContent(), null);
        SheetTest.assertEquals(3, spreadSheet.getSheet(0).getRowCount());
    }

    public void testGetTableModel() {
        TableModel tableModel = this.sheet.getTableModel(1, 0);
        SheetTest.assertEquals(tm.getColumnCount() - 1, tableModel.getColumnCount());
        SheetTest.assertEquals(tm.getRowCount() + 1, tableModel.getRowCount());
        SheetTest.assertEquals(new Float(-5.32), tableModel.getValueAt(1, 0));
    }

    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        SheetTest.assertEquals((Object)"test", this.sheet.getCellAt("C1").getValue());
    }

    public void testMerge() {
    }

    public void testIsCellRef() {
        SheetTest.assertTrue(Sheet.isCellRef("A23"));
        SheetTest.assertFalse(Sheet.isCellRef("A23A"));
        SheetTest.assertFalse(Sheet.isCellRef("test"));
        SheetTest.assertFalse(Sheet.isCellRef("23"));
    }

    public void testResolve() {
        SheetTest.assertEquals(Sheet.resolve("AA34"), new Point(26, 33));
    }

    public void testToInt() {
        SheetTest.assertEquals(0, Sheet.toInt("A"));
        SheetTest.assertEquals(26, Sheet.toInt("AA"));
        SheetTest.assertEquals(77, Sheet.toInt("BZ"));
    }

    public void testDuplicateRows() throws Exception {
        this.realSheet.duplicateRows(8, 3, 2);
        SheetTest.assertEquals(this.realSheet.getValueAt("B11"), this.realSheet.getValueAt("B14"));
        SheetTest.assertEquals((Object)"Comptabilit\u00c3\u00a9", this.realSheet.getValueAt("H9"));
        SheetTest.assertEquals(this.realSheet.getValueAt("H9"), this.realSheet.getValueAt("H12"));
        SheetTest.assertEquals(this.realSheet.getValueAt("H9"), this.realSheet.getValueAt("H15"));
    }

    public void testXY() throws Exception {
        MutableCell mutableCell = this.realSheet.getCellAt(2, 35);
        SheetTest.assertEquals((Object)"LECTURE SEULE", mutableCell.getValue());
        SheetTest.assertEquals(2, mutableCell.getX());
        SheetTest.assertEquals(35, mutableCell.getY());
        this.realSheet.duplicateRows(8, 3, 2);
        mutableCell = this.realSheet.getCellAt(2, 41);
        SheetTest.assertEquals((Object)"LECTURE SEULE", mutableCell.getValue());
        SheetTest.assertEquals(2, mutableCell.getX());
        SheetTest.assertEquals(41, mutableCell.getY());
    }

    public void testStyle() throws Exception {
        SheetTest.assertNull(this.realSheet.getImmutableCellAt(2, 10).getStyleAttr());
        String string = this.realSheet.getStyleNameAt(2, 10);
        SheetTest.assertNotNull(string);
        SheetTest.assertEquals("#00ffff", ((CellStyle)this.realSheet.getCellAt(2, 10).getStyle()).getBackgroundColor());
        SheetTest.assertEquals(string, this.realSheet.getCellAt(2, 10).getStyleName());
        SheetTest.assertEquals(Float.valueOf(54.38f), Float.valueOf(this.realSheet.getColumn(1).getWidth()));
        SpreadSheet spreadSheet = SpreadSheet.create(new ODPackage(this.getClass().getResourceAsStream("test.sxc")));
        SheetTest.assertEquals(Float.valueOf(33.85f), Float.valueOf(spreadSheet.getSheet(0).getColumn(1).getWidth()));
    }

    private String isValidXML(SpreadSheet spreadSheet) throws UnsupportedEncodingException, SAXException {
        return OOXML.get("OpenDocument").isValid(spreadSheet.getContent());
    }

    static {
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");
        tm.addRow(new Object[]{"un1", new Float(-5.32), new Integer(123)});
    }
}

