/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Parsed;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.JDOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor<E> {
    public static final String OO_XML = "OOXML:";
    public static final String ENCODE = "%enc:";
    public static final String AS_STR = "%str:";
    private static Logger logger = Logger.getLogger(Processor.class.getName());
    private final Parsed<E> parsed;
    private final NS ns;
    private final XPath xp;
    private final DataModel model;
    private Material<E> material;

    Processor(Parsed<E> parsed, DataModel dataModel) throws TemplateException {
        this.parsed = parsed;
        this.model = dataModel;
        this.ns = this.parsed.getSource().getNS();
        try {
            this.xp = OOUtils.getXPath(".//text:span", this.ns.getVersion());
        }
        catch (JDOMException jDOMException) {
            throw ExceptionUtils.createExn(TemplateException.class, "xpath error", jDOMException);
        }
        this.material = null;
    }

    public final Parsed<E> getParsed() {
        return this.parsed;
    }

    public Material<E> getMaterial() {
        return this.material;
    }

    public Material<E> process() throws TemplateException {
        this.material = this.parsed.getSource().clone();
        this.transform(this.material.getRoot());
        Material<E> material = this.material;
        this.material = null;
        return material;
    }

    public void transform(Element element) throws TemplateException {
        String string = element.getName();
        if (string.equals("text-input")) {
            this.replaceField(element);
        } else if (element.getNamespace().equals(Statement.stmtNS)) {
            Statement statement = this.parsed.getStatement(string);
            if (statement != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("executing tag " + string);
                    }
                    statement.execute(this, element, this.model);
                }
                catch (Exception exception) {
                    throw new TemplateException("pb at " + JDOMUtils.output(element), exception);
                }
            } else {
                logger.warning("unknown tag: " + string);
            }
        } else {
            for (Element element2 : new ArrayList(element.getChildren())) {
                this.transform(element2);
            }
        }
    }

    private void replaceField(Element element) throws TemplateException {
        boolean bl;
        boolean bl2;
        String string = element.getAttributeValue("description", this.ns.getTEXT());
        boolean bl3 = string.startsWith(AS_STR);
        if (bl3) {
            string = string.substring(AS_STR.length());
        }
        if (bl2 = string.startsWith(OO_XML)) {
            string = string.substring(OO_XML.length());
        }
        if (bl = string.startsWith(ENCODE)) {
            string = string.substring(ENCODE.length());
        }
        element.setName("span");
        element.setNamespace(this.ns.getTEXT());
        Object object = this.model.eval(string);
        if (object != null) {
            if (bl) {
                object = OOXML.get(this.ns.getVersion()).encodeWS(object.toString());
            } else if (bl2) {
                try {
                    object = this.parse(object.toString());
                }
                catch (JDOMException jDOMException) {
                    throw ExceptionUtils.createExn(IllegalArgumentException.class, "invalid xml for : " + object, jDOMException);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("replacing field \"" + string + "\" with \"" + object + "\"");
            }
            if (!bl3 && object instanceof Element) {
                element.setContent(this.getChildren((Element)object));
            } else {
                element.setText(this.display(object));
            }
        } else {
            logger.warning("missing value for field: " + string);
            element.setText("");
        }
    }

    private String display(Object object) {
        String string = object instanceof Element ? JDOMUtils.output((Element)object) : object.toString();
        return string;
    }

    private List getChildren(Element element) {
        ListIterator listIterator;
        try {
            listIterator = this.xp.selectNodes(element).listIterator();
        }
        catch (JDOMException jDOMException) {
            throw ExceptionUtils.createExn(RuntimeException.class, "xpath error", jDOMException);
        }
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            List list = element2.getParent().getContent();
            list.add(list.indexOf(element2) + 1, new Text("\n"));
        }
        return element.removeContent();
    }

    private Element parse(String string) throws JDOMException {
        return JDOMUtils.parseElementString("<dummy>" + string + "</dummy>", this.ns.getALL());
    }
}

