/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.Stack;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StyleMasterPage;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleTextProperties;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxStylesUnmarshaller
extends DefaultHandler {
    private OfficeStyles styles = new OfficeStyles();
    private OfficeAutomaticStyles autoStyles = new OfficeAutomaticStyles();
    private OfficeMasterStyles masterStyles = new OfficeMasterStyles();
    private Stack<Object> stack = new Stack();
    private Object current;

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("office:styles")) {
            this.styles = new OfficeStyles();
            this.push(this.styles);
        } else if (string3.equals("style:default-style")) {
            StyleDefaultStyle styleDefaultStyle = new StyleDefaultStyle();
            styleDefaultStyle.setStyleFamily(attributes.getValue("style:family"));
            if (this.current instanceof OfficeStyles) {
                ((OfficeStyles)this.current).addDefaultStyle(styleDefaultStyle);
            } else {
                System.err.println("Not OfficeStyles:" + this.current);
            }
            this.push(styleDefaultStyle);
        } else if (string3.equals("style:text-properties")) {
            StyleTextProperties styleTextProperties = new StyleTextProperties();
            styleTextProperties.setFontName(attributes.getValue("style:font-name"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setStyleTextProperties(styleTextProperties);
            } else {
                System.err.println("Not StyleDefaultStyle:" + this.current);
            }
            this.push(styleTextProperties);
        } else if (string3.equals("office:automatic-styles")) {
            this.autoStyles = new OfficeAutomaticStyles();
            this.push(this.autoStyles);
        } else if (string3.equals("style:page-layout")) {
            StylePageLayout stylePageLayout = new StylePageLayout();
            stylePageLayout.setStyleName(attributes.getValue("style:name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autoStyles.addPageLayout(stylePageLayout);
            } else {
                System.err.println("Not OfficeAutomaticStyles:" + this.current);
            }
            this.push(stylePageLayout);
        } else if (string3.equals("style:page-layout-properties")) {
            StylePageLayoutProperties stylePageLayoutProperties = new StylePageLayoutProperties();
            stylePageLayoutProperties.setPageWidth(attributes.getValue("fo:page-width"));
            stylePageLayoutProperties.setPageHeight(attributes.getValue("fo:page-height"));
            stylePageLayoutProperties.setMarginTop(attributes.getValue("fo:margin-top"));
            stylePageLayoutProperties.setMarginBottom(attributes.getValue("fo:margin-bottom"));
            stylePageLayoutProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            stylePageLayoutProperties.setMarginRight(attributes.getValue("fo:margin-right"));
            stylePageLayoutProperties.setShadow(attributes.getValue("style:shadow"));
            stylePageLayoutProperties.setBackgroundColor(attributes.getValue("fo:background-color"));
            stylePageLayoutProperties.setScaleTo(attributes.getValue("style:scale-to"));
            stylePageLayoutProperties.setTableCentering(attributes.getValue("style:table-centering"));
            stylePageLayoutProperties.setWritingMode(attributes.getValue("style:writing-mode"));
            if (this.current instanceof StylePageLayout) {
                ((StylePageLayout)this.current).setPageLayoutProperties(stylePageLayoutProperties);
            } else {
                System.err.println("Not StylePageLayout:" + this.current);
            }
            this.push(stylePageLayoutProperties);
        } else if (string3.equals("office:master-styles")) {
            this.masterStyles = new OfficeMasterStyles();
            this.push(this.masterStyles);
        } else if (string3.equals("style:master-page")) {
            StyleMasterPage styleMasterPage = new StyleMasterPage();
            styleMasterPage.setStyleName(attributes.getValue("style:name"));
            styleMasterPage.setStylePageLayoutName(attributes.getValue("style:page-layout-name"));
            if (this.current instanceof OfficeMasterStyles) {
                this.masterStyles.addMasterPage(styleMasterPage);
            } else {
                System.err.println("Not OfficeMasterStyles:" + this.current);
            }
            this.push(styleMasterPage);
        } else {
            System.err.println("style.xml : ignoring :" + string3);
            this.push(string);
        }
    }

    private void push(Object object) {
        this.current = object;
        this.stack.push(object);
    }

    public void endElement(String string, String string2, String string3) {
        this.pop();
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
    }

    public OfficeStyles getStyles() {
        return this.styles;
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }
}

