/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.RepaintManager;
import org.jopendocument.renderer.ODTRenderer;

public class ImageUtilities {
    private ODTRenderer renderer;

    public ImageUtilities(ODTRenderer oDTRenderer) {
        this.renderer = oDTRenderer;
    }

    public void saveAsPng(String string) {
        try {
            File file = new File(string);
            int n = 1000;
            int n2 = 1000;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            ImageUtilities.disableDoubleBuffering(this.renderer);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            this.renderer.print(graphics2D);
            graphics2D.setColor(Color.red);
            graphics2D.drawLine(10, 10, 30, 30);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            ImageUtilities.enableDoubleBuffering(this.renderer);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

