package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestCaseFunctionInfo {
	String path = "";
	String relatedFunction = "";
	String priority = "";
	String id = "";
	Set<String> testCases = new HashSet<String>();
	Set<String> comments = new HashSet<String>();
	
	Map<String, RunResultAggregator> resultsPerBrowser = new HashMap<String, RunResultAggregator>();
	
	class RunResultAggregator {

		int STATUS_NOT_RUN = 0;
		int STATUS_PASSED = 1;
		int STATUS_BLOCKED = 2;
		int STATUS_FAILED = 3;
		
		String[] statusTable = new String[]{"", "PASSED", "BLOCKED","FAILED" };
		Map<String, Integer> testCount = new HashMap<String, Integer>();

		public boolean registerTesterResult(String tester, String caseId, String value) {
			String key = caseId;
			Integer runResultCount = testCount.get(key);
			if (runResultCount==null)
				runResultCount=0;
			
			int level = STATUS_NOT_RUN;
			String cleanValue = value.trim();
			if ("PASSED".equalsIgnoreCase(cleanValue)||"OK".equalsIgnoreCase(cleanValue)||"PASS".equalsIgnoreCase(cleanValue)) {
				level=STATUS_PASSED;
			} else if ("BLOCKED".equalsIgnoreCase(cleanValue) || "N/A".equalsIgnoreCase(cleanValue) || "NA".equalsIgnoreCase(cleanValue)) {
				level=STATUS_BLOCKED;
			} else if ("FAILED".equalsIgnoreCase(cleanValue) ||"FAIL".equalsIgnoreCase(cleanValue)) {
				level=STATUS_FAILED;
			} else if ("".equals(cleanValue) || "Untested".equals(cleanValue)){
				level=STATUS_NOT_RUN;
			} else {
				return false;
			}
			if (level >= runResultCount)//FIXME Weird comparison
				testCount.put(key, level);
			return true;
		}

		private int countStatus(int status){
			int count=0;
			Set<String> keySet = testCount.keySet();
			for (String tester : keySet) {
				int statusValue = testCount.get(tester);
				if (statusValue==status)
					count++;
			}
			return count;
		}
		public int getTestNotRunCount() {
			return countStatus(STATUS_NOT_RUN);
		}

		public int getTestPassedCount() {
			return countStatus(STATUS_PASSED);
		}

		public int getTestBlockedCount() {
			return countStatus(STATUS_BLOCKED);
		}		

		public int getTestFailedCount() {
			return countStatus(STATUS_FAILED);
		}

	}

	class TesterResultAggregator {
		
		int testNotRunCount;
		int testPassedCount;
		int testFailedCount;
		int testBlockedCount;

		public void incrementTestNotRunCount() {
			testNotRunCount++;
		}
	
		public void incrementTestPassedCount() {
			testPassedCount++;
		}
		
		public void incrementTestFailedCount() {
			testFailedCount++;
		}
	
		public void incrementTestBlockedCount() {
			testBlockedCount++;
		}
	}
	
	public String getPriority() {
		return priority;
	}

	public void setPriority(String priority) {
		this.priority = priority;
	}

	public void addComment(String comment){
		comments.add(comment);
	}
	
	public Set<String> getComments(){
		return comments;
	}
	
	public TestCaseFunctionInfo(String path, String relatedFunction, String priority) {
		super();
		this.path = path;
		this.id = relatedFunction;
		this.priority = priority;
	}

	public void incrementTestCaseCount(String caseId) {
		testCases.add(caseId);
	}

	public boolean incrementTestResult(String browser, String tester, String caseId, String value) {
		RunResultAggregator runResultCount = resultsPerBrowser.get(browser);
		if (runResultCount == null) {
			runResultCount = new RunResultAggregator();
			resultsPerBrowser.put(browser, runResultCount);
		}
		return runResultCount.registerTesterResult(tester, caseId, value);
	}

	public int getTestNotRunCount(String browser) {
		return resultsPerBrowser.get(browser).getTestNotRunCount();
	}

	public int getTestPassedCount(String browser) {
		return resultsPerBrowser.get(browser).getTestPassedCount();
	}
	
	public int getTestFailedCount(String browser) {
		return resultsPerBrowser.get(browser).getTestFailedCount();
	}

	public int getTestBlockedCount(String browser) {
		return resultsPerBrowser.get(browser).getTestBlockedCount();
	}

	
	public int getTestCaseCount() {
		return testCases.size();
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getRelatedFunction() {
		return relatedFunction;
	}

	public void setRelatedFunction(String relatedFunction) {
		this.relatedFunction = relatedFunction;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TestCaseFunctionInfo other = (TestCaseFunctionInfo) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

}
