/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.tcm.TestCaseFunctionInfo;

public class RunResultAggregator {
    int STATUS_NOT_RUN = 1;
    int STATUS_PASSED = 2;
    int STATUS_NA = 3;
    int STATUS_BLOCKED = 4;
    int STATUS_FAILED = 5;
    Map<String, Integer> testCount = new HashMap<String, Integer>();
    Map<String, String> testCasePriority = new HashMap<String, String>();
    Map<String, String> rowDescriptionMap = new HashMap<String, String>();
    Map<String, String> browserResultDescription = new HashMap<String, String>();

    public boolean registerTesterResult(String caseId, String value, String priority, TestCaseFunctionInfo functionInfo, String message, String browser, String browserResult) {
        String key = caseId;
        int level = this.STATUS_NOT_RUN;
        String cleanValue = value.trim();
        if ("PASSED".equalsIgnoreCase(cleanValue) || "OK".equalsIgnoreCase(cleanValue) || "PASS".equalsIgnoreCase(cleanValue)) {
            level = this.STATUS_PASSED;
        } else if ("FAILED".equalsIgnoreCase(cleanValue) || "FAIL".equalsIgnoreCase(cleanValue)) {
            level = this.STATUS_FAILED;
        } else if ("BLOCKED".equalsIgnoreCase(cleanValue) || "BLOCK".equalsIgnoreCase(cleanValue)) {
            level = this.STATUS_BLOCKED;
        } else if ("N/A".equalsIgnoreCase(cleanValue) || "NA".equalsIgnoreCase(cleanValue)) {
            level = this.STATUS_NA;
        } else if ("".equals(cleanValue) || "Untested".equalsIgnoreCase(cleanValue) || "UNTEST".equalsIgnoreCase(cleanValue)) {
            level = this.STATUS_NOT_RUN;
        } else {
            return false;
        }
        Set<String> keySet = this.testCount.keySet();
        for (String id : keySet) {
            if (!id.equalsIgnoreCase(key)) continue;
            int oldLevel = this.testCount.get(id);
            if (oldLevel < level) {
                this.testCount.put(key, level);
                if (oldLevel > this.STATUS_NOT_RUN) {
                    String description = this.rowDescriptionMap.get(id) + this.browserResultDescription.get(id) + "\n\t  " + message + " : Browser is " + browser + " || Result is " + browserResult;
                    System.out.println("[ERROR] More than one tester run the same testcase and they have a conflict between test results for this testcase \n\tat:\n\t  " + description + "\n");
                }
            } else if (oldLevel > level && level > this.STATUS_NOT_RUN) {
                String description = this.rowDescriptionMap.get(id) + this.browserResultDescription.get(id) + "\n\t  " + message + " : Browser is " + browser + " || Result is " + browserResult;
                System.out.println("[ERROR] More than one tester run the same testcase and they have a conflict between test results for this testcase \n\tat:\n\t  " + description + "\n");
            }
            return true;
        }
        this.browserResultDescription.put(key, " : Browser is " + browser + " || Result is " + browserResult);
        this.rowDescriptionMap.put(key, message);
        this.testCount.put(key, level);
        this.testCasePriority.put(key, priority);
        return true;
    }

    private int countStatus(int status, String priorityType) {
        int count = 0;
        Set<String> keySet = this.testCount.keySet();
        for (String caseId : keySet) {
            int statusValue = this.testCount.get(caseId);
            String priorityValue = this.testCasePriority.get(caseId);
            if (statusValue != status || !priorityValue.equalsIgnoreCase(priorityType)) continue;
            ++count;
        }
        return count;
    }

    public int getTestPassedCount(String priorityType) {
        return this.countStatus(this.STATUS_PASSED, priorityType);
    }

    public int getTestFailedCount(String priorityType) {
        return this.countStatus(this.STATUS_FAILED, priorityType);
    }

    public int getTestBlockedCount(String priorityType) {
        return this.countStatus(this.STATUS_BLOCKED, priorityType);
    }

    public int getTestNACount(String priorityType) {
        return this.countStatus(this.STATUS_NA, priorityType);
    }

    public int getTestNotRunCount(String priorityType) {
        return this.countStatus(this.STATUS_NOT_RUN, priorityType);
    }
}

