/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.spreadsheet.CalcNode;

public class ODFrame
extends CalcNode {
    public static final String UNIT = "mm";
    private static final Pattern lenghPattern = Pattern.compile("(\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
    private final float width = ODFrame.parseLength(this.getSVGAttr("width"));
    private final float height = ODFrame.parseLength(this.getSVGAttr("height"));

    private static final String[] parseLength2String(String string) {
        Matcher matcher = lenghPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalStateException("unable to parse " + string);
        }
        return new String[]{matcher.group(1), matcher.group(3)};
    }

    public static final float parseLength(String string) {
        float f;
        String[] stringArray = ODFrame.parseLength2String(string);
        String string2 = stringArray[1];
        if (string2.equals("cm")) {
            f = 10.0f;
        } else if (string2.equals(UNIT)) {
            f = 1.0f;
        } else if (string2.equals("in")) {
            f = 25.4f;
        } else {
            throw new IllegalStateException("unknown unit " + string2);
        }
        return Float.parseFloat(stringArray[0]) * f;
    }

    public ODFrame(Element element) {
        super(element);
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    private Namespace getSVG() {
        return this.getElement().getNamespace("svg");
    }

    public String getSVGAttr(String string) {
        return this.getElement().getAttributeValue(string, this.getSVG());
    }

    public void setSVGAttr(String string, String string2) {
        this.getElement().setAttribute(string, string2, this.getSVG());
    }

    public void setSVGAttr(String string, double d) {
        this.setSVGAttr(string, d + this.getUnit());
    }

    public final float getRatio() {
        return this.width / this.height;
    }

    public final float getX() {
        return ODFrame.parseLength(this.getSVGAttr("x"));
    }

    public final float getY() {
        return ODFrame.parseLength(this.getSVGAttr("y"));
    }

    public final String getUnit() {
        return UNIT;
    }
}

