/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import junit.framework.TestCase;
import org.jdom.Element;
import org.jopendocument.dom.ChildCreator;
import org.jopendocument.dom.NS;

public class ChildCreatorTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreate() throws Exception {
        NS nS = NS.getOD();
        Element element = new Element("p", nS.getTEXT());
        ChildCreator childCreator = new ChildCreator(element, new Element("un", nS.getTEXT()), new Element("deux", nS.getTEXT()), new Element("trois", nS.getSTYLE()), new Element("quatre", nS.getOFFICE()));
        try {
            childCreator.getChild(nS.getOFFICE(), "un", true);
            ChildCreatorTest.fail("un is not in office namespace");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Element element2 = childCreator.getChild(nS.getSTYLE(), "trois", true);
        ChildCreatorTest.assertEquals(nS.getSTYLE(), element2.getNamespace());
        ChildCreatorTest.assertEquals("trois", element2.getName());
        ChildCreatorTest.assertSame(element2, element.getChildren().get(0));
        ChildCreatorTest.assertSame(element2, childCreator.getChild(nS.getSTYLE(), "trois", true));
        ChildCreatorTest.assertEquals(1, element.getContentSize());
        Element element3 = childCreator.addChild(nS.getSTYLE(), "trois");
        ChildCreatorTest.assertNotSame(element2, element3);
        ChildCreatorTest.assertSame(element3, element.getChildren().get(1));
        ChildCreatorTest.assertEquals(2, element.getContentSize());
        element.getChildren().remove(1);
        childCreator.getChild(nS.getTEXT(), "deux", true);
        ChildCreatorTest.assertSame(element2, element.getChildren().get(1));
        ChildCreatorTest.assertEquals(2, element.getContentSize());
        ChildCreatorTest.assertSame(childCreator.getChild(nS.getOFFICE(), "quatre", true), element.getChildren().get(2));
        ChildCreatorTest.assertEquals(3, element.getContentSize());
        ChildCreatorTest.assertSame(element2, element.getChildren().get(1));
        ChildCreatorTest.assertSame(childCreator.getChild(nS.getTEXT(), "un", true), element.getChildren().get(0));
        ChildCreatorTest.assertEquals(4, element.getContentSize());
    }
}

