/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jopendocument.dom.OOXML;
import org.jopendocument.util.JDOMUtils;

public class OOXMLTest
extends TestCase {
    private static final OOXML xml = OOXML.get("OpenOffice.org");

    public void testGetLineBreak() {
        Element element = xml.getLineBreak();
        OOXMLTest.assertEquals(OOXML.getLineBreakS(), "<" + element.getNamespacePrefix() + ":" + element.getName() + "/>");
    }

    public void testGetTab() {
        Element element = xml.getTab();
        OOXMLTest.assertEquals(OOXML.getTabS(), "<" + element.getNamespacePrefix() + ":" + element.getName() + "/>");
    }

    public void testEncodeRT() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("b", "Gras");
        hashMap.put("gris", "Gris");
        OOXMLTest.assertEquals("<text:span xmlns:text=\"http://openoffice.org/2000/text\">4 &lt; <text:span text:style-name=\"Gras\">5</text:span></text:span>", JDOMUtils.output(xml.encodeRT("4 < [b]5[/b]", hashMap)));
    }

    public void testEncodeWS() {
        String string = "hi<text:tab-stop/>how are<text:s text:c=\"3\"/>you ?<text:line-break/>[That] was &gt;= 3 and &lt;=3 spaces";
        OOXMLTest.assertEquals(string, OOXML.encodeOOWS("hi\thow are   you ?\n[That] was >= 3 and <=3 spaces"));
        string = "<text:span xmlns:text=\"http://openoffice.org/2000/text\">hi<text:tab-stop />how are<text:s text:c=\"3\" />you ?<text:line-break />[That] was &gt;= 3 and &lt;=3 spaces</text:span>";
        OOXMLTest.assertEquals(string, JDOMUtils.output(xml.encodeWS("hi\thow are   you ?\n[That] was >= 3 and <=3 spaces")));
    }
}

