package org.exoplatform.tcm;

public class SummaryAggregator {
    int passed = 0;
    int blocked = 0;
    int failed = 0;
    int notrun = 0;
    int notavailable = 0;
    int testcase = 0;
    String name;

    public SummaryAggregator(String name) {
        this.name = name;
    }

    public int getTestcase() {
        return testcase;
    }

    public void addTestcase(int testcase) {
        this.testcase += testcase;
    }

    public int getPassed() {
        return passed;
    }

    public void addPassed(int passed) {
        this.passed += passed;
    }

    public int getBlocked() {
        return blocked;
    }

    public void addBlocked(int blocked) {
        this.blocked += blocked;
    }

    public int getFailed() {
        return failed;
    }

    public void addFailed(int failed) {
        this.failed += failed;
    }

    public int getNotrun() {
        return notrun;
    }

    public void addNotrun(int notrun) {
        this.notrun += notrun;
    }

    public void addNA(int notavailable) {
        this.notavailable += notavailable;
    }

    public int getNA() {
        return notavailable;
    }

    public int getTotalRun() {
        return blocked + failed + passed;
    }

    public String getProgress(){
        if (getTotalRun() == 0)
            return "(off) NOT STARTED";
        if (notrun == 0 && blocked == 0)
            return "(/) COMPLETED";
        if (notrun == 0 && blocked > 0)
            return "(/) BLOCKED";
        return "(on) PARTIAL (" + Math.floor(100 * (testcase - notrun - notavailable) / testcase) + "%)" ;
    }

    public String getStatus(){
        if (failed + blocked > 0)
            return " (x) ERROR (" + (failed + blocked) + ")";
        if (blocked > 0)
            return " (x) BLOCKED (" + (blocked) + ")";
        if (failed + blocked == 0 && notrun > 0)
            return "(on) NO BAD NEWS";
        if (testcase == 0)
            return "N/A";
        return "(/) SUCCESS";
    }
    public String getSummary() {
        return  "|" + name
                + " | " + getProgress()
                + " | " + getStatus()
                + " | " + failed
                + " | " + blocked
                + " | " + notrun
                + " | " + notavailable
                + " | " + passed
                + " | " + testcase
                + " | ";
    }

    public static String getSummaryHeader() {
        return "|| TC Name "
                + " || Progress " 
                + " || Status "
                + " || Failed "
                + " || Blocked "
                + " || Not run "
                + " || N/A "
                + " || Passed "
                + " || Total "
                + " || ";

    }
}
