package org.exoplatform.tcm;

import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * @author Dimitri BAELI, CanhBX
 *
 */
public class TestCaseManager {
	public static final String GENERATE_TEST_PLAN = "generateTestPlan";
	public static final String GENERATE_TEST_RUN = "generateTestRun";
    public static final String GENERATE_TEST_RESULTS = "generateTestResults";
    public static final String LIST_FAILURES = "listFailures";
	public static TestCaseHelper testCaseHelper = new TestCaseHelper();
	public static void main(String[] args) throws FileNotFoundException, IOException {
		boolean executed = false;
		if (args.length > 0) {
			String goal = args[0];
			if (goal.equals(GENERATE_TEST_PLAN)){
				//generate testplan step
				if (args.length > 1) {
					testCaseHelper.generateTestPlan(args[1]);
					executed = true;
				}
			} else if (goal.equals(GENERATE_TEST_RUN)){
				//generate testcase run step
				if (args.length > 2) {
					String testCampaignDir = args[1];
					String testPlanFile = args[2];
					testCaseHelper.generateTestCaseRun(testCampaignDir, testPlanFile);
					executed = true;
				}
            } else if (goal.equals(GENERATE_TEST_RESULTS)){
                //generate testplan result step
                if (args.length > 1) {
                    String testCampaignDir = args[1];
                    String testCampaignName = args.length > 2 ? args[2]:"TC Result ";
                    testCaseHelper.generateTestPlanResult(testCampaignDir, testCampaignName);
                    executed = true;
                }
            } else if (goal.equals(LIST_FAILURES)){
				//generate testplan result step
				if (args.length > 1) {
                    String testCampaignDir = args[1];
                    String testCampaignName = args.length > 2 ? args[2]:"TC Failures ";
					testCaseHelper.listFailures(testCampaignDir, testCampaignName);
					executed = true;
				}
			}


		}
		if (!executed) {
			usage();
		}
	}

	public static void usage(){
		System.out.println("Usage :");
		System.out.println("\t" + TestCaseManager.class.getName() + " " + GENERATE_TEST_PLAN + " testCampaignDirName");
		System.out.println("\t" + TestCaseManager.class.getName() + " " + GENERATE_TEST_RUN + " testCaseDefinitionDir testPlanFile");
		System.out.println("\t" + TestCaseManager.class.getName() + " " + GENERATE_TEST_RESULTS + " testCampaignDirName");
	}
}
