/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tcm;

public class SummaryAggregator {
    int passed = 0;
    int blocked = 0;
    int failed = 0;
    int notrun = 0;
    int notavailable = 0;
    int testcase = 0;
    String name;

    public SummaryAggregator(String name) {
        this.name = name;
    }

    public int getTestcase() {
        return this.testcase;
    }

    public void addTestcase(int testcase) {
        this.testcase += testcase;
    }

    public int getPassed() {
        return this.passed;
    }

    public void addPassed(int passed) {
        this.passed += passed;
    }

    public int getBlocked() {
        return this.blocked;
    }

    public void addBlocked(int blocked) {
        this.blocked += blocked;
    }

    public int getFailed() {
        return this.failed;
    }

    public void addFailed(int failed) {
        this.failed += failed;
    }

    public int getNotrun() {
        return this.notrun;
    }

    public void addNotrun(int notrun) {
        this.notrun += notrun;
    }

    public void addNA(int notavailable) {
        this.notavailable += notavailable;
    }

    public int getNA() {
        return this.notavailable;
    }

    public int getTotalRun() {
        return this.blocked + this.failed + this.passed;
    }

    public String getProgress() {
        if (this.getTotalRun() == 0) {
            return "(off) NOT STARTED";
        }
        if (this.notrun == 0 && this.blocked == 0) {
            return "(/) COMPLETED";
        }
        if (this.notrun == 0 && this.blocked > 0) {
            return "(/) BLOCKED";
        }
        return "(on) PARTIAL (" + Math.floor(100 * (this.testcase - this.notrun - this.notavailable) / this.testcase) + "%)";
    }

    public String getStatus() {
        if (this.failed + this.blocked > 0) {
            return " (x) ERROR (" + (this.failed + this.blocked) + ")";
        }
        if (this.blocked > 0) {
            return " (x) BLOCKED (" + this.blocked + ")";
        }
        if (this.failed + this.blocked == 0 && this.notrun > 0) {
            return "(on) NO BAD NEWS";
        }
        if (this.testcase == 0) {
            return "N/A";
        }
        return "(/) SUCCESS";
    }

    public String getSummary() {
        return "|" + this.name + " | " + this.getProgress() + " | " + this.getStatus() + " | " + this.failed + " | " + this.blocked + " | " + this.notrun + " | " + this.notavailable + " | " + this.passed + " | " + this.testcase + " | ";
    }

    public static String getSummaryHeader() {
        return "|| TC Name  || Progress  || Status  || Failed  || Blocked  || Not run  || N/A  || Passed  || Total  || ";
    }
}

