/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.tcm.RunResultAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseFunctionInfo {
    String id = "";
    String relatedFunction = "";
    Set<String> priorityList = new HashSet<String>();
    String path = "";
    Integer highPriorityNumber = 0;
    Integer mediumPriorityNumber = 0;
    Integer lowPriorityNumber = 0;
    String comments = "";
    Map<Integer, String> commentMap = new HashMap<Integer, String>();
    Map<String, RunResultAggregator> resultsPerBrowser = new HashMap<String, RunResultAggregator>();

    public TestCaseFunctionInfo(String path, String relatedFunction) {
        this.path = path;
        this.id = relatedFunction;
    }

    public void addComment(Integer caseId, String comment) {
        String commentData = this.commentMap.get(caseId);
        if (commentData != null && !"".equals(commentData) && !commentData.contains(comment)) {
            commentData = commentData + (commentData.length() > 0 ? " " : "") + comment;
            this.commentMap.put(caseId, commentData);
        } else {
            this.commentMap.put(caseId, comment);
        }
    }

    public boolean increaseTestResult(String browser, String id, String browserResult, String priorityType, TestCaseFunctionInfo functionInfo, String message) {
        RunResultAggregator runResultCount = this.resultsPerBrowser.get(browser);
        if (runResultCount == null) {
            runResultCount = new RunResultAggregator();
            this.resultsPerBrowser.put(browser, runResultCount);
        }
        return runResultCount.registerTesterResult(id, browserResult, priorityType, functionInfo, message, browser, browserResult);
    }

    public int getTestPassedCount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestPassedCount(priorityType);
    }

    public int getTestFailedCount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestFailedCount(priorityType);
    }

    public int getTestBlockedCount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestBlockedCount(priorityType);
    }

    public int getTestNACount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestNACount(priorityType);
    }

    public int getTestNotRunCount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestNotRunCount(priorityType);
    }

    public int getTestCount(String browser, String priorityType) {
        return this.resultsPerBrowser.get(browser).getTestCount(priorityType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCaseFunctionInfo other = (TestCaseFunctionInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRelatedFunction() {
        return this.relatedFunction;
    }

    public void setRelatedFunction(String relatedFunction) {
        this.relatedFunction = relatedFunction;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setComments(String comment) {
        this.comments = comment;
    }

    public String getComments() {
        return this.comments;
    }

    public Integer getHighPriorityNumber() {
        return this.highPriorityNumber;
    }

    public void increaseHighPriorityNumber() {
        TestCaseFunctionInfo testCaseFunctionInfo = this;
        Integer n = testCaseFunctionInfo.highPriorityNumber;
        Integer n2 = testCaseFunctionInfo.highPriorityNumber = Integer.valueOf(testCaseFunctionInfo.highPriorityNumber + 1);
    }

    public Integer getMediumPriorityNumber() {
        return this.mediumPriorityNumber;
    }

    public void increaseMediumPriorityNumber() {
        TestCaseFunctionInfo testCaseFunctionInfo = this;
        Integer n = testCaseFunctionInfo.mediumPriorityNumber;
        Integer n2 = testCaseFunctionInfo.mediumPriorityNumber = Integer.valueOf(testCaseFunctionInfo.mediumPriorityNumber + 1);
    }

    public Integer getLowPriorityNumber() {
        return this.lowPriorityNumber;
    }

    public void increaseLowPriorityNumber() {
        TestCaseFunctionInfo testCaseFunctionInfo = this;
        Integer n = testCaseFunctionInfo.lowPriorityNumber;
        Integer n2 = testCaseFunctionInfo.lowPriorityNumber = Integer.valueOf(testCaseFunctionInfo.lowPriorityNumber + 1);
    }

    public Set<String> getPriorityList() {
        return this.priorityList;
    }

    public Map<Integer, String> getCommentMap() {
        return this.commentMap;
    }
}

