/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.res.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parameters {
    private static final Log log = LogFactory.getLog(Parameters.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.http");
    private final HashMap<String, ArrayList<String>> paramHashValues = new HashMap();
    private boolean didQueryParameters = false;
    MessageBytes queryMB;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    String encoding = null;
    String queryStringEncoding = null;
    private int limit = -1;
    private int parameterCount = 0;
    private boolean parseFailed = false;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    private ByteChunk origName = new ByteChunk();
    private ByteChunk origValue = new ByteChunk();
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String s) {
        this.encoding = s;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set encoding to " + s));
        }
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set query string encoding to " + s));
        }
    }

    public boolean isParseFailed() {
        return this.parseFailed;
    }

    public void setParseFailed(boolean parseFailed) {
        this.parseFailed = parseFailed;
    }

    public void recycle() {
        this.parameterCount = 0;
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.encoding = null;
        this.decodedQuery.recycle();
        this.parseFailed = false;
    }

    public void addParameterValues(String key, String[] newValues) {
        if (key == null) {
            return;
        }
        ArrayList<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList(newValues.length);
            this.paramHashValues.put(key, values);
        } else {
            values.ensureCapacity(values.size() + newValues.length);
        }
        for (String newValue : newValues) {
            values.add(newValue);
        }
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        return Collections.enumeration(this.paramHashValues.keySet());
    }

    public String getParameter(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.size() == 0) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoding query " + this.decodedQuery + " " + this.queryStringEncoding));
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    private void addParam(String key, String value) {
        if (key == null) {
            return;
        }
        ArrayList<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList(1);
            this.paramHashValues.put(key, values);
        }
        values.add(value);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.getCharset(this.encoding));
    }

    private void processParameters(byte[] bytes, int start, int len, Charset charset) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)sm.getString("parameters.bytes", new String(bytes, start, len, DEFAULT_CHARSET.name())));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        int decodeFailCount = 0;
        int pos = start;
        int end = start + len;
        while (pos < end) {
            block45: {
                ++this.parameterCount;
                if (this.limit > -1 && this.parameterCount > this.limit) {
                    this.parseFailed = true;
                    log.info((Object)sm.getString("parameters.maxCountFail", this.limit));
                    break;
                }
                int nameStart = pos;
                int nameEnd = -1;
                int valueStart = -1;
                int valueEnd = -1;
                boolean parsingName = true;
                boolean decodeName = false;
                boolean decodeValue = false;
                boolean parameterComplete = false;
                do {
                    switch (bytes[pos]) {
                        case 61: {
                            if (parsingName) {
                                nameEnd = pos++;
                                parsingName = false;
                                valueStart = pos;
                                break;
                            }
                            ++pos;
                            break;
                        }
                        case 38: {
                            if (parsingName) {
                                nameEnd = pos;
                            } else {
                                valueEnd = pos;
                            }
                            parameterComplete = true;
                            ++pos;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (parsingName) {
                                decodeName = true;
                            } else {
                                decodeValue = true;
                            }
                            ++pos;
                            break;
                        }
                        default: {
                            ++pos;
                        }
                    }
                } while (!parameterComplete && pos < end);
                if (pos == end) {
                    if (nameEnd == -1) {
                        nameEnd = pos;
                    } else if (valueStart > -1 && valueEnd == -1) {
                        valueEnd = pos;
                    }
                }
                if (log.isDebugEnabled() && valueStart == -1) {
                    try {
                        log.debug((Object)sm.getString("parameters.noequal", nameStart, nameEnd, new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_CHARSET.name())));
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                }
                if (nameEnd <= nameStart) {
                    if (valueStart == -1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)sm.getString("parameters.emptyChunk"));
                        continue;
                    }
                    if (log.isInfoEnabled()) {
                        if (valueEnd >= nameStart && log.isDebugEnabled()) {
                            String extract = null;
                            try {
                                extract = new String(bytes, nameStart, valueEnd - nameStart, DEFAULT_CHARSET.name());
                            }
                            catch (UnsupportedEncodingException uee) {
                                // empty catch block
                            }
                            log.info((Object)sm.getString("parameters.invalidChunk", nameStart, valueEnd, extract));
                        } else {
                            log.info((Object)sm.getString("parameters.invalidChunk", nameStart, nameEnd, null));
                        }
                    }
                    this.parseFailed = true;
                    continue;
                }
                this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
                if (valueStart >= 0) {
                    this.tmpValue.setBytes(bytes, valueStart, valueEnd - valueStart);
                } else {
                    this.tmpValue.setBytes(bytes, 0, 0);
                }
                if (log.isDebugEnabled()) {
                    try {
                        this.origName.append(bytes, nameStart, nameEnd - nameStart);
                        if (valueStart >= 0) {
                            this.origValue.append(bytes, valueStart, valueEnd - valueStart);
                        } else {
                            this.origValue.append(bytes, 0, 0);
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)sm.getString("parameters.copyFail"), (Throwable)ioe);
                    }
                }
                try {
                    String value;
                    if (decodeName) {
                        this.urlDecode(this.tmpName);
                    }
                    this.tmpName.setCharset(charset);
                    String name = this.tmpName.toString();
                    if (valueStart >= 0) {
                        if (decodeValue) {
                            this.urlDecode(this.tmpValue);
                        }
                        this.tmpValue.setCharset(charset);
                        value = this.tmpValue.toString();
                    } else {
                        value = "";
                    }
                    this.addParam(name, value);
                }
                catch (IOException e) {
                    this.parseFailed = true;
                    if (++decodeFailCount != 1 && !log.isDebugEnabled()) break block45;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("parameters.decodeFail.debug", this.origName.toString(), this.origValue.toString()), (Throwable)e);
                    }
                    if (!log.isInfoEnabled()) break block45;
                    log.info((Object)sm.getString("parameters.decodeFail.info", this.tmpName.toString(), this.tmpValue.toString()), (Throwable)e);
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
            if (!log.isDebugEnabled()) continue;
            this.origName.recycle();
            this.origValue.recycle();
        }
        if (decodeFailCount > 1 && !log.isDebugEnabled()) {
            log.info((Object)sm.getString("parameters.multipleDecodingFail", decodeFailCount));
        }
    }

    private void urlDecode(ByteChunk bc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc);
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), this.getCharset(encoding));
    }

    private Charset getCharset(String encoding) {
        if (encoding == null) {
            return DEFAULT_CHARSET;
        }
        try {
            return B2CConverter.getCharset(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return DEFAULT_CHARSET;
        }
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> e : this.paramHashValues.entrySet()) {
            sb.append(e.getKey()).append('=');
            ArrayList<String> values = e.getValue();
            for (String value : values) {
                sb.append(value).append(',');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

