/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ConnectingIdType;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class ImpersonatedUserId {
    private ConnectingIdType idType;
    private String id;

    public ImpersonatedUserId() {
    }

    public ImpersonatedUserId(ConnectingIdType idType, String id) {
        this();
        this.idType = idType;
        this.id = id;
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.id == null || this.id.isEmpty()) {
            throw new Exception(Strings.IdPropertyMustBeSet);
        }
        writer.writeStartElement(XmlNamespace.Types, "ExchangeImpersonation");
        writer.writeStartElement(XmlNamespace.Types, "ConnectingSID");
        String connectingIdTypeLocalName = this.idType == ConnectingIdType.SmtpAddress && writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1 ? "PrimarySmtpAddress" : this.getIdType().toString();
        writer.writeElementValue(XmlNamespace.Types, connectingIdTypeLocalName, this.id);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public ConnectingIdType getIdType() {
        return this.idType;
    }

    public void setIdType(ConnectingIdType idType) {
        this.idType = idType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

