/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.AutodiscoverResponseType;
import microsoft.exchange.webservices.data.ConfigurationSettingsBase;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.OutlookAccount;
import microsoft.exchange.webservices.data.OutlookProtocol;
import microsoft.exchange.webservices.data.OutlookUser;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserSettingError;
import microsoft.exchange.webservices.data.UserSettingName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutlookConfigurationSettings
extends ConfigurationSettingsBase {
    private static LazyMember<List<UserSettingName>> allOutlookProviderSettings = new LazyMember<List<UserSettingName>>(new ILazyMember<List<UserSettingName>>(){

        @Override
        public List<UserSettingName> createInstance() {
            ArrayList<UserSettingName> results = new ArrayList<UserSettingName>();
            for (UserSettingName userSettingName : OutlookUser.getAvailableUserSettings()) {
                results.add(userSettingName);
            }
            results.addAll(OutlookProtocol.getAvailableUserSettings());
            results.add(UserSettingName.AlternateMailboxes);
            return results;
        }
    });
    private OutlookUser user = new OutlookUser();
    private OutlookAccount account = new OutlookAccount();

    protected static boolean isAvailableUserSetting(UserSettingName setting) {
        return allOutlookProviderSettings.getMember().contains((Object)setting);
    }

    @Override
    protected String getNamespace() {
        return "http://schemas.microsoft.com/exchange/autodiscover/outlook/responseschema/2006a";
    }

    @Override
    protected void makeRedirectionResponse(URI redirectUrl) {
        this.account = new OutlookAccount();
        this.account.setRedirectTarget(redirectUrl.toString());
        this.account.setResponseType(AutodiscoverResponseType.RedirectUrl);
    }

    @Override
    protected boolean tryReadCurrentXmlElement(EwsXmlReader reader) throws ServiceXmlDeserializationException, XMLStreamException, Exception {
        if (!super.tryReadCurrentXmlElement(reader)) {
            if (reader.getLocalName().equals("User")) {
                this.user.loadFromXml(reader);
                return true;
            }
            if (reader.getLocalName().equals("Account")) {
                this.account.loadFromXml(reader);
                return true;
            }
            reader.skipCurrentElement();
            return false;
        }
        return true;
    }

    @Override
    protected GetUserSettingsResponse convertSettings(String smtpAddress, List<UserSettingName> requestedSettings) {
        GetUserSettingsResponse response = new GetUserSettingsResponse();
        response.setSmtpAddress(smtpAddress);
        if (this.getError() != null) {
            response.setErrorCode(AutodiscoverErrorCode.InternalServerError);
            response.setErrorMessage(this.getError().getMessage());
        } else {
            switch (this.getResponseType()) {
                case Success: {
                    response.setErrorCode(AutodiscoverErrorCode.NoError);
                    response.setErrorMessage("");
                    this.user.convertToUserSettings(requestedSettings, response);
                    this.account.convertToUserSettings(requestedSettings, response);
                    this.reportUnsupportedSettings(requestedSettings, response);
                    break;
                }
                case Error: {
                    response.setErrorCode(AutodiscoverErrorCode.InternalServerError);
                    response.setErrorMessage(Strings.InvalidAutodiscoverServiceResponse);
                    break;
                }
                case RedirectAddress: {
                    response.setErrorCode(AutodiscoverErrorCode.RedirectAddress);
                    response.setErrorMessage("");
                    response.setRedirectTarget(this.getRedirectTarget());
                    break;
                }
                case RedirectUrl: {
                    response.setErrorCode(AutodiscoverErrorCode.RedirectUrl);
                    response.setErrorMessage("");
                    response.setRedirectTarget(this.getRedirectTarget());
                    break;
                }
                default: {
                    EwsUtilities.EwsAssert(false, "OutlookConfigurationSettings.ConvertSettings", "An unexpected error has occured. This code path should never be reached.");
                }
            }
        }
        return response;
    }

    private void reportUnsupportedSettings(List<UserSettingName> requestedSettings, GetUserSettingsResponse response) {
        ArrayList<UserSettingName> invalidSettingQuery = new ArrayList<UserSettingName>();
        for (UserSettingName userSettingName : requestedSettings) {
            if (OutlookConfigurationSettings.isAvailableUserSetting(userSettingName)) continue;
            invalidSettingQuery.add(userSettingName);
        }
        for (UserSettingName invalidSetting : invalidSettingQuery) {
            UserSettingError settingError = new UserSettingError();
            settingError.setErrorCode(AutodiscoverErrorCode.InvalidSetting);
            settingError.setSettingName(invalidSetting.toString());
            settingError.setErrorMessage(String.format(Strings.AutodiscoverInvalidSettingForOutlookProvider, invalidSetting.toString()));
            response.getUserSettingErrors().add(settingError);
        }
    }

    @Override
    protected AutodiscoverResponseType getResponseType() {
        if (this.account != null) {
            return this.account.getResponseType();
        }
        return AutodiscoverResponseType.Error;
    }

    @Override
    protected String getRedirectTarget() {
        return this.account.getRedirectTarget();
    }
}

