/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.ItemIdWrapperList;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SyncFolderItemsResponse;
import microsoft.exchange.webservices.data.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyncFolderItemsRequest
extends MultiResponseServiceRequest<SyncFolderItemsResponse> {
    private PropertySet propertySet;
    private FolderId syncFolderId;
    private SyncFolderItemsScope syncScope;
    private String syncState;
    private ItemIdWrapperList ignoredItemIds = new ItemIdWrapperList();
    private int maxChangesReturned = 100;

    protected SyncFolderItemsRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected SyncFolderItemsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new SyncFolderItemsResponse(this.getPropertySet());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "SyncFolderItems";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SyncFolderItemsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SyncFolderItemsResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getPropertySet(), "PropertySet");
        EwsUtilities.validateParam(this.getSyncFolderId(), "SyncFolderId");
        this.getSyncFolderId().validate(this.getService().getRequestedServerVersion());
        if (this.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010) < 0 && this.syncScope != SyncFolderItemsScope.NormalItems) {
            throw new ServiceVersionException(String.format(Strings.EnumValueIncompatibleWithRequestVersion, new Object[]{this.getSyncScope().toString(), this.getSyncScope().name(), ExchangeVersion.Exchange2010}));
        }
        this.getPropertySet().validateForRequest(this, true);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertySet().writeToXml(writer, ServiceObjectType.Item);
        writer.writeStartElement(XmlNamespace.Messages, "SyncFolderId");
        this.getSyncFolderId().writeToXml(writer);
        writer.writeEndElement();
        writer.writeElementValue(XmlNamespace.Messages, "SyncState", this.getSyncState());
        this.getIgnoredItemIds().writeToXml(writer, XmlNamespace.Messages, "Ignore");
        writer.writeElementValue(XmlNamespace.Messages, "MaxChangesReturned", this.getMaxChangesReturned());
        if (this.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010) >= 0) {
            writer.writeElementValue(XmlNamespace.Messages, "SyncScope", (Object)this.syncScope);
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    public FolderId getSyncFolderId() {
        return this.syncFolderId;
    }

    public void setSyncFolderId(FolderId syncFolderId) {
        this.syncFolderId = syncFolderId;
    }

    public SyncFolderItemsScope getSyncScope() {
        return this.syncScope;
    }

    public void setSyncScope(SyncFolderItemsScope syncScope) {
        this.syncScope = syncScope;
    }

    public String getSyncState() {
        return this.syncState;
    }

    public void setSyncState(String syncState) {
        this.syncState = syncState;
    }

    public ItemIdWrapperList getIgnoredItemIds() {
        return this.ignoredItemIds;
    }

    public int getMaxChangesReturned() {
        return this.maxChangesReturned;
    }

    public void setMaxChangesReturned(int maxChangesReturned) throws ArgumentException {
        if (maxChangesReturned < 1 || maxChangesReturned > 512) {
            throw new ArgumentException(Strings.MaxChangesMustBeBetween1And512);
        }
        this.maxChangesReturned = maxChangesReturned;
    }
}

