/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.RuleOperation;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResult;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.UpdateInboxRulesException;
import microsoft.exchange.webservices.data.UpdateInboxRulesResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateInboxRulesRequest
extends SimpleServiceRequestBase {
    private String mailboxSmtpAddress;
    private boolean removeOutlookRuleBlob;
    private Iterable<RuleOperation> inboxRuleOperations;

    protected UpdateInboxRulesRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected String getXmlElementName() {
        return "UpdateInboxRules";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.mailboxSmtpAddress != null && !this.mailboxSmtpAddress.isEmpty()) {
            writer.writeElementValue(XmlNamespace.Messages, "MailboxSmtpAddress", this.mailboxSmtpAddress);
        }
        writer.writeElementValue(XmlNamespace.Messages, "RemoveOutlookRuleBlob", this.removeOutlookRuleBlob);
        writer.writeStartElement(XmlNamespace.Messages, "Operations");
        for (RuleOperation operation : this.inboxRuleOperations) {
            operation.writeToXml(writer, operation.getXmlElementName());
        }
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateInboxRulesResponse";
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        UpdateInboxRulesResponse response = new UpdateInboxRulesResponse();
        response.loadFromXml(reader, "UpdateInboxRulesResponse");
        return response;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    @Override
    protected void validate() throws Exception {
        if (this.inboxRuleOperations == null) {
            throw new IllegalArgumentException("RuleOperations cannot be null.Operations");
        }
        int operationCount = 0;
        for (RuleOperation operation : this.inboxRuleOperations) {
            EwsUtilities.validateParam(operation, "RuleOperation");
            ++operationCount;
        }
        if (operationCount == 0) {
            throw new IllegalArgumentException("RuleOperations cannot be empty.Operations");
        }
        this.getService().validate();
    }

    protected UpdateInboxRulesResponse execute() throws ServiceLocalException, Exception {
        UpdateInboxRulesResponse serviceResponse = (UpdateInboxRulesResponse)this.internalExecute();
        if (serviceResponse.getResult() == ServiceResult.Error) {
            throw new UpdateInboxRulesException(serviceResponse, this.inboxRuleOperations);
        }
        return serviceResponse;
    }

    protected String getMailboxSmtpAddress() {
        return this.mailboxSmtpAddress;
    }

    protected void setMailboxSmtpAddress(String value) {
        this.mailboxSmtpAddress = value;
    }

    protected boolean getRemoveOutlookRuleBlob() {
        return this.removeOutlookRuleBlob;
    }

    protected void setRemoveOutlookRuleBlob(boolean value) {
        this.removeOutlookRuleBlob = value;
    }

    protected Iterable<RuleOperation> getInboxRuleOperations() {
        return this.inboxRuleOperations;
    }

    protected void setInboxRuleOperations(Iterable<RuleOperation> value) {
        this.inboxRuleOperations = value;
    }
}

