/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;

public final class AppointmentOccurrenceId
extends ItemId {
    private int occurrenceIndex;

    public AppointmentOccurrenceId(String recurringMasterUniqueId, int occurrenceIndex) throws Exception {
        super(recurringMasterUniqueId);
        this.occurrenceIndex = occurrenceIndex;
    }

    public int getOccurrenceIndex() {
        return this.occurrenceIndex;
    }

    public void setOccurrenceIndex(int occurrenceIndex) {
        if (occurrenceIndex < 1) {
            throw new IllegalArgumentException(Strings.OccurrenceIndexMustBeGreaterThanZero);
        }
        this.occurrenceIndex = occurrenceIndex;
    }

    protected String getXmlElementName() {
        return "OccurrenceItemId";
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("RecurringMasterId", this.getUniqueId());
        writer.writeAttributeValue("InstanceIndex", this.getOccurrenceIndex());
    }
}

