/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.AlternateId;
import microsoft.exchange.webservices.data.AlternateIdBase;
import microsoft.exchange.webservices.data.AlternatePublicFolderId;
import microsoft.exchange.webservices.data.AlternatePublicFolderItemId;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class ConvertIdResponse
extends ServiceResponse {
    private AlternateIdBase convertedId;

    protected ConvertIdResponse() {
    }

    protected void readElementsFromXml(EwsServiceXmlReader reader) throws InstantiationException, IllegalAccessException, ServiceLocalException, Exception {
        super.readElementsFromXml(reader);
        reader.readStartElement(XmlNamespace.Messages, "AlternateId");
        String alternateIdClass = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "type");
        int aliasSeparatorIndex = alternateIdClass.indexOf(58);
        if (aliasSeparatorIndex > -1) {
            alternateIdClass = alternateIdClass.substring(aliasSeparatorIndex + 1);
        }
        if (alternateIdClass.equals("AlternateIdType")) {
            this.convertedId = new AlternateId();
        } else if (alternateIdClass.equals("AlternatePublicFolderIdType")) {
            this.convertedId = new AlternatePublicFolderId();
        } else if (alternateIdClass.equals("AlternatePublicFolderItemIdType")) {
            this.convertedId = new AlternatePublicFolderItemId();
        } else {
            EwsUtilities.EwsAssert(false, "ConvertIdResponse.ReadElementsFromXml", String.format("Unknown alternate Id class: %s", alternateIdClass));
        }
        this.convertedId.loadAttributesFromXml(reader);
        reader.readEndElement(XmlNamespace.Messages, "AlternateId");
    }

    public AlternateIdBase getConvertedId() {
        return this.convertedId;
    }
}

