/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.TrustManager;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.HttpErrorException;
import microsoft.exchange.webservices.data.IAsyncResult;
import microsoft.exchange.webservices.data.WebAsyncCallStateAnchor;
import microsoft.exchange.webservices.data.WebProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class HttpWebRequest {
    private URL url;
    private boolean preAuthenticate;
    private int timeout;
    private String contentType = "text/xml; charset=utf-8";
    private String accept = "text/xml";
    private String userAgent = "EWS SDK";
    private boolean allowAutoRedirect;
    private boolean keepAlive = true;
    private boolean acceptGzipEncoding;
    private boolean useDefaultCredentials;
    private String userName;
    private String password;
    private String domain;
    private String requestMethod = "POST";
    private Map<String, String> headers;
    private WebProxy proxy;

    HttpWebRequest() {
    }

    public WebProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(WebProxy proxy) {
        this.proxy = proxy;
    }

    public boolean isHttpScheme() {
        return this.getUrl().getProtocol().equalsIgnoreCase("http");
    }

    public boolean isHttpsScheme() {
        return this.getUrl().getProtocol().equalsIgnoreCase("https");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean isPreAuthenticate() {
        return this.preAuthenticate;
    }

    public void setPreAuthenticate(boolean preAuthenticate) {
        this.preAuthenticate = preAuthenticate;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isAllowAutoRedirect() {
        return this.allowAutoRedirect;
    }

    public void setAllowAutoRedirect(boolean allowAutoRedirect) {
        this.allowAutoRedirect = allowAutoRedirect;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isAcceptGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
        this.acceptGzipEncoding = acceptGzipEncoding;
    }

    public boolean isUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public void setUseDefaultCredentials(boolean useDefaultCredentials) {
        this.useDefaultCredentials = useDefaultCredentials;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setCredentails(String domain, String user, String pwd) {
        this.domain = domain;
        this.userName = user;
        this.password = pwd;
    }

    public abstract InputStream getInputStream() throws EWSHttpException, IOException;

    public abstract InputStream getErrorStream() throws EWSHttpException;

    public abstract OutputStream getOutputStream() throws EWSHttpException;

    public abstract void close();

    public abstract void prepareConnection() throws EWSHttpException;

    public abstract Map<String, String> getResponseHeaders() throws EWSHttpException;

    public abstract String getContentEncoding() throws EWSHttpException;

    public abstract String getResponseContentType() throws EWSHttpException;

    public abstract int getResponseCode() throws EWSHttpException;

    public abstract String getResponseText() throws EWSHttpException;

    public abstract String getResponseHeaderField(String var1) throws EWSHttpException;

    public abstract void prepareAsyncConnection() throws EWSHttpException, UnsupportedEncodingException;

    public abstract Map<String, String> getRequestProperty() throws EWSHttpException;

    public abstract void setClientCertificates(TrustManager var1) throws EWSHttpException;

    public abstract int executeRequest() throws EWSHttpException, HttpErrorException, IOException;

    public IAsyncResult beginGetResponse(Object webRequestAsyncCallback, WebAsyncCallStateAnchor wrappedState) {
        return null;
    }

    public ByteArrayOutputStream endGetRequestStream(IAsyncResult result) {
        return new ByteArrayOutputStream();
    }
}

