eXo.require("eXo.core.IOUtil");

function LCF() { }

LCF.prototype.modifyPortalWebXml = function(webappsDir, product) {
  eXo.System.info("INFO", "------------Patch web.xml------------------------");
  eXo.System.info("INFO", "Start patching web.xml within " + product.portalwar);
  var warFile = webappsDir + "/" + product.portalwar;
  var file = new java.io.File(warFile);
  if (!file.exists()) {
    eXo.System.info("IO", warFile + " file not found" ) ;
    return null;
  }

  var webXmlEntry = "WEB-INF/web.xml";
  var webXML = eXo.core.IOUtil.getJarEntryAsText(warFile, webXmlEntry);

  var b = new java.lang.StringBuilder();
  /*
   * LeadCaptionFilter filter declaration
   */
  eXo.System.info("INFO", "Add LeadCaptionFilter filter declaration");

  b.append("  <!-- LeadCaptionFilter filter -->\n");
  b.append("  <filter>\n");
  b.append("    <filter-name>LeadCaptionFilter</filter-name>\n");
  b.append("    <filter-class>org.exoplatform.capture.client.LeadCaptionFilter</filter-class>\n");
  b.append("  </filter>\n");
  b.append("\n");
  b.append("  <filter-mapping>");
  webXML = webXML.replaceFirst("<filter-mapping>", b.toString());
  
  b = new java.lang.StringBuilder();
  /*
   * LeadCaptionFilter mapping declaration
   */
  eXo.System.info("INFO", "Add LeadCaptionFilter mapping declaration");
  b.append("  <!-- LeadCaptionFilter filter-mapping -->\n");
  b.append("  <filter-mapping>\n");
  b.append("    <filter-name>LeadCaptionFilter</filter-name>\n");
  b.append("    <url-pattern>/*</url-pattern>\n");
  b.append("  </filter-mapping>\n");
  b.append("\n");
  b.append("  <listener>");
  webXML = webXML.replaceFirst("<listener>", b.toString());
  
  var replaceMap = new java.util.HashMap() ;

  replaceMap.put(webXmlEntry, webXML.getBytes()) ;               
  eXo.core.IOUtil.modifyJar(warFile, replaceMap, null) ;
  
  eXo.System.info("INFO", "Finished Patching web.xml within " + product.portalwar);
}

LCF.prototype.modifyConfigurationFileTomcat = function(webappsDir, product){
  eXo.System.info("INFO", "------------Patch configuration.xml------------------------");
  eXo.System.info("INFO", "Start patching configuration.xml within folder /WEB-INF/conf/ of " + product.portalwar);

  var warFile = webappsDir + "/" + product.portalwar;
  var file = new java.io.File(warFile);
  if (!file.exists()) {
    eXo.System.info("IO", warFile + " file not found" ) ;
    return null;
  }

  var webXmlEntry = "WEB-INF/conf/configuration.xml";
  var webXML = eXo.core.IOUtil.getJarEntryAsText(warFile, webXmlEntry);

  var b = new java.lang.StringBuilder();
  b.append("<configuration>\n");
  b.append("  <component>\n");
  b.append("    <type>org.exoplatform.capture.client.LeadCaptureInitializer</type>\n");
  b.append("    <init-params>\n");
  b.append("      <value-param>\n");
  b.append("        <name>productNameAndVersion</name>\n");
  b.append("        <value>portal 2.5.3</value>\n");
  b.append("      </value-param>\n");
  b.append("      <value-param>\n");
  b.append("        <name>leadCaptureServerURL</name>\n");
  b.append("        <value>http://localhost:8080/</value>\n");
  b.append("      </value-param>\n");
  b.append("      <value-param>\n");
  b.append("        <name>pingServerURL</name>\n");
  b.append("        <value>http://www.exoplatform.org/</value>\n");
  b.append("      </value-param>\n");
  b.append("      <value-param>\n");
  b.append("        <name>KeyContent</name>\n");
  b.append("        <value>2.5.3</value>\n");
  b.append("      </value-param>\n");
  b.append("    </init-params>\n");
  b.append("  </component>\n");
  b.append("\n");
  webXML = webXML.replaceFirst("<configuration>", b.toString());

  var replaceMap = new java.util.HashMap() ;

  replaceMap.put(webXmlEntry, webXML.getBytes()) ;               
  eXo.core.IOUtil.modifyJar(warFile, replaceMap, null) ;
  
  eXo.System.info("INFO", "Finished patching configuration.xml within folder /WEB-INF/conf/ of " + product.portalwar);
}

LCF.prototype.modifyApplicationFileJBoss = function(deployWebappDir){
  eXo.System.info("INFO", "------------Patch application.xml----------------------------");
  eXo.System.info("INFO", "Start patching application.xml within " + deployWebappDir + "/META-INF/");
  
  var webXmlEntry = deployWebappDir + "/META-INF/application.xml"
  var webXML = eXo.core.IOUtil.openFileAsText(webXmlEntry);

  var b = new java.lang.StringBuilder();
  b.append("  <module>\n");
  b.append("    <web>\n");
  b.append("      <web-uri>capture.war</web-uri>\n");
  b.append("      <context-root>capture</context-root>\n");
  b.append("    </web>\n");
  b.append("  </module>\n");

  //get the version of leadcapture.client & leadcapture.common
  var folder = new java.io.File(deployWebappDir);
  if(folder.exists() &&  folder.isDirectory()) {
      var child =  folder.listFiles();
      for(var i = 0; i < child.length; i++) {
        var file =  child[i];
        if(file.getName().indexOf("exo.leadcapture.client")>-1){
           b.append("  <module>\n");
	   b.append("    <ejb>").append(file.getName()).append("</ejb>\n");
           b.append("  </module>\n");
      	}else if(file.getName().indexOf("exo.leadcapture.common")>-1){
           b.append("  <module>\n");
	   b.append("    <ejb>").append(file.getName()).append("</ejb>\n");
           b.append("  </module>\n");
	}
      }
  }

  b.append("</application>")
  b.append("\n");
  webXML = webXML.replaceFirst("</application>", b.toString());  

  var out = new java.io.FileOutputStream(deployWebappDir + "/META-INF/application.xml");
  out.write(webXML.getBytes(), 0, webXML.length());
  out.close();
   
  eXo.System.info("INFO", "Finished patching application.xml within " + deployWebappDir + "/META-INF/"); 
}

LCF.prototype.downloadFile = function(downloadURL, destinationFolder, newFileName) {   
   var bis = null;
   var bos = null;
   try{
     var fileName = downloadURL.substring(downloadURL.lastIndexOf("/")+1);     
     var url = new java.net.URL(downloadURL);
     var urlc = url.openConnection();

     eXo.System.info("INFO", "Start downloading file : " +fileName + " from server");

     bis = new java.io.BufferedInputStream( urlc.getInputStream() );

     if(newFileName.replace(/\s/g,"") == ""){//no need to rename downloaded file
       bos = new java.io.BufferedOutputStream( new java.io.FileOutputStream(destinationFolder+ "/" + fileName));
     }else{//need to rename downloaded file
       bos = new java.io.BufferedOutputStream( new java.io.FileOutputStream(destinationFolder+ "/" + newFileName));
     }     
     var i;
     while ((i = bis.read()) != -1)
     {
        bos.write( i );
     }
     eXo.System.info("INFO", "Finished download file : " +fileName + " from server");
   }catch (e) {
       eXo.System.info("ERROR",e.toString());
       eXo.System.info("ERROR", "Can not download file : " +fileName + " from server");
   }
   finally{
      if (bis != null)
        try{
          bis.close();
        }
        catch (e) {eXo.System.info("ERROR",e.toString());}
      if (bos != null)
        try
        {
           bos.close();
        }
        catch (e){
          eXo.System.info("ERROR",e.toString());
        }
   }
}

LCF.prototype.downloadLCFJarFiles = function(deployWebappDir, deployLibDir) {
  eXo.System.info("INFO", "------------Download LCF Jar Files--------------------------");
  eXo.System.info("INFO", "Downloading LCF Jar Files");

  //download exo.leadcapture.client-x.y.z.jar to Tomcat\lib or \exo-jboss\server\default\deploy\exoplatform.ear (for jboss)
  var downloadURL = "http://repository.exoplatform.org/service/local/repositories/exo-releases/content/org/exoplatform/leadcapture/exo.leadcapture.client/2.1.1/exo.leadcapture.client-2.1.1.jar";
  var newFileName = "";
  this.downloadFile(downloadURL, deployLibDir, newFileName);

  //download exo.leadcapture.common-x.y.z.jar to Tomcat\lib or \exo-jboss\server\default\deploy\exoplatform.ear (for jboss)
  downloadURL = "http://repository.exoplatform.org/service/local/repositories/exo-releases/content/org/exoplatform/leadcapture/exo.leadcapture.common/2.1.1/exo.leadcapture.common-2.1.1.jar";
  newFileName = "";
  this.downloadFile(downloadURL, deployLibDir, newFileName);

  //download capture.war into Tomcat\webapps or \exo-jboss\server\default\deploy\exoplatform.ear
  downloadURL = "http://repository.exoplatform.org/service/local/repositories/exo-releases/content/org/exoplatform/leadcapture/exo.leadcapture.web.client.application/2.1.1/exo.leadcapture.web.client.application-2.1.1.war";
  newFileName = "capture.war";
  this.downloadFile(downloadURL, deployWebappDir, newFileName);

  eXo.System.info("INFO", "Finished download LCF Jar Files");
}

LCF.prototype.modifyCaptureWebXML = function(deployWebappDir, product, captureWarName){
  eXo.System.info("INFO", "------------Patch web.xml---------------------------------");
  eXo.System.info("INFO", "Start patching web.xml in capture.war file");

  var warFile = deployWebappDir + "/" + captureWarName;
  var file = new java.io.File(warFile);
  if (!file.exists()) {
    eXo.System.info("IO", warFile + " file not found" ) ;
    return null;
  }

  var webXmlEntry = "WEB-INF/web.xml";
  var webXML = eXo.core.IOUtil.getJarEntryAsText(warFile, webXmlEntry);

  eXo.System.info("INFO", "Product Name = "+product.name + " Product version = "+product.version ) ;
  
  //change product name  
  var b = new java.lang.StringBuilder();
  b.append("<!--<param-value>");
  webXML = webXML.replaceFirst("<param-value>", b.toString());
  
  b = new java.lang.StringBuilder();
  b.append("</param-value>-->");
  webXML = webXML.replaceFirst("</param-value>", b.toString());
  b = new java.lang.StringBuilder();

  b = new java.lang.StringBuilder();
  b.append("</param-value>-->\n\t <param-value>"+product.name+"</param-value>");
  webXML = webXML.replaceFirst("</param-value>-->", b.toString());

  //change product version
  b = new java.lang.StringBuilder();
  b.append("<!--Replace this variable's value by th correct product's version--><!--");
  webXML = webXML.replaceFirst("<!--Replace this variable's value by th correct product's version-->", b.toString());
  
  b = new java.lang.StringBuilder();
  b.append("-->\n\t <param-value>"+product.version+"</param-value>\n\t <description>Product version</description>");
  webXML = webXML.replaceFirst("<description>Product version</description>", b.toString());
  
  //change registration form url
  b = new java.lang.StringBuilder();
  b.append("<param-value>http://www.exoplatform.org/portal/public/website/RegistrationForm</param-value>");
  webXML = webXML.replaceFirst("<param-value>http://www-int.exoplatform.org/portal/public/website/RegistrationForm</param-value>", b.toString());

  var replaceMap = new java.util.HashMap() ;

  replaceMap.put(webXmlEntry, webXML.getBytes()) ;               
  eXo.core.IOUtil.modifyJar(warFile, replaceMap, null) ;
  
  eXo.System.info("INFO", "Finished patching web.xml in capture.war file");
}

eXo.server.LCF = new LCF();
