/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.utils.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropsToXML {
    private static boolean isLeafNode(Node node) {
        return node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3;
    }

    public static boolean parse(String propsFilePath, CrowdinFile.Type type) throws Exception {
        XPath xpath;
        File propsFile = new File(propsFilePath);
        if (!propsFile.exists() || !propsFile.isFile()) {
            return false;
        }
        String fullFileName = propsFile.getName();
        String fileName = fullFileName;
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        String outputPath = propsFile.getParent();
        outputPath = outputPath + (outputPath.endsWith("/") ? "" : "/");
        String outputFile = outputPath + fileName + ".xml";
        String masterFile = "";
        if (type.equals((Object)CrowdinFile.Type.PORTLET)) {
            String origFileName = fileName.substring(0, fileName.lastIndexOf("_"));
            masterFile = outputPath + origFileName + ".xml";
            if (!new File(masterFile).exists()) {
                masterFile = outputPath + origFileName + "_en.xml";
            }
            if (!new File(masterFile).exists()) {
                origFileName = origFileName.substring(0, origFileName.lastIndexOf("_"));
                masterFile = outputPath + origFileName + ".xml";
                if (!new File(masterFile).exists()) {
                    masterFile = outputPath + origFileName + "_en.xml";
                }
            }
            if (!new File(masterFile).exists()) {
                throw new FileNotFoundException("Cannot create or update " + outputFile + " as the master file " + origFileName + ".xml (or " + origFileName + "_en.xml) does not exist!");
            }
        } else if (type.equals((Object)CrowdinFile.Type.GADGET)) {
            masterFile = outputPath + "default.xml";
            if (!new File(masterFile).exists()) {
                masterFile = outputPath + "ALL_ALL.xml";
            }
            if (!new File(masterFile).exists()) {
                masterFile = outputPath + "en_ALL.xml";
            }
            if (!new File(masterFile).exists()) {
                throw new FileNotFoundException("Cannot create or update " + outputFile + " as the master file default.xml (or ALL_ALL.xml, en_ALL.xml) does not exist!");
            }
        }
        FileUtils.replaceCharactersInFile(masterFile, "config/special_character_processing.properties", "PropertiesToXMLSpecialCharacters");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(masterFile);
        doc.setXmlStandalone(true);
        XPathFactory factory = XPathFactory.newInstance();
        Properties props = new Properties();
        props.load(new FileInputStream(propsFile));
        Enumeration<?> e = props.propertyNames();
        String key = "";
        if (type.equals((Object)CrowdinFile.Type.PORTLET)) {
            block4: while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                xpath = factory.newXPath();
                NodeList nodes = null;
                try {
                    nodes = (NodeList)xpath.evaluate("//" + key.replace(".", "/"), doc, XPathConstants.NODESET);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        if (!PropsToXML.isLeafNode(node)) continue;
                        node.setTextContent(props.getProperty(key).trim());
                        continue block4;
                    }
                }
                catch (XPathExpressionException xpe) {
                    System.out.println("[WARNING] XPath exception when looking for key '" + key + "' in '" + masterFile + "' : " + xpe.getCause().getMessage());
                }
            }
        } else if (type.equals((Object)CrowdinFile.Type.GADGET)) {
            while (e.hasMoreElements()) {
                try {
                    key = (String)e.nextElement();
                    xpath = factory.newXPath();
                    Node node = (Node)xpath.evaluate("//messagebundle/msg[@name='" + key + "']", doc, XPathConstants.NODE);
                    if (null == node) {
                        node = (Node)xpath.evaluate("//messageBundle/msg[@name='" + key + "']", doc, XPathConstants.NODE);
                    }
                    if (null == node) {
                        System.out.println("[WARNING] Cannot get the node for key '" + key + "' in '" + masterFile);
                        continue;
                    }
                    node.setTextContent(props.getProperty(key).trim());
                }
                catch (XPathExpressionException xpe) {
                    System.out.println("[WARNING] XPath exception when looking for key '" + key + "' in '" + masterFile + "' : " + xpe.getCause().getMessage());
                }
            }
        }
        TransformerFactory transformFactory = TransformerFactory.newInstance();
        Transformer transformer = transformFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        File fout = new File(outputFile);
        if (propsFilePath.endsWith("en.properties") || propsFilePath.equalsIgnoreCase("en_ALL.properties")) {
            transformer.transform(source, new StreamResult(new File(masterFile)));
            FileUtils.replaceCharactersInFile(masterFile, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
            if (fout.exists()) {
                transformer.transform(source, new StreamResult(fout));
                FileUtils.replaceCharactersInFile(outputFile, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
            }
        } else {
            transformer.transform(source, new StreamResult(fout));
            FileUtils.replaceCharactersInFile(outputFile, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
            FileUtils.replaceCharactersInFile(masterFile, "config/special_character_processing.properties", "UpdateSourceSpecialCharacters");
        }
        return true;
    }

    public static void execShellCommand(String cmd) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
            int n = pr.waitFor();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

