/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.model;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.model.CrowdinTranslation;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;
import org.exoplatform.crowdin.utils.XMLToProps;

public class CrowdinFileFactory {
    private AbstractCrowdinMojo currentMojo;
    private Pattern translationFilePattern = Pattern.compile("^([a-zA-Z_0-9-]*)_([a-z]*)(_[A-Z]*)?.([a-z]*)$");

    public CrowdinFileFactory(AbstractCrowdinMojo _mojo) {
        this.currentMojo = _mojo;
    }

    public CrowdinFile prepareCrowdinFile(String _path, String _name, String _project) {
        File file = new File(_path);
        String type = _path.substring(_path.lastIndexOf(46) + 1);
        boolean shouldBeCleaned = false;
        if (type.equals("xml") && !_project.contains("mobile")) {
            file = this.fromXMLToProps(file);
            _path = file.getPath();
            type = "properties";
            shouldBeCleaned = true;
        } else if (_project.contains("android")) {
            type = "xml";
        } else if (_project.contains("ios")) {
            type = "strings";
        }
        _project = CrowdinFileFactory.encodeMinusCharacterInPath(_project, true);
        _name = CrowdinFileFactory.encodeMinusCharacterInPath(_name, true);
        if (this.currentMojo.getLog().isDebugEnabled()) {
            this.currentMojo.getLog().debug((CharSequence)("*** Creating CrowdinFile with path: " + _path));
            this.currentMojo.getLog().debug((CharSequence)("*** Creating CrowdinFile with name: " + _name));
            this.currentMojo.getLog().debug((CharSequence)("*** Creating CrowdinFile with type: " + type));
            this.currentMojo.getLog().debug((CharSequence)("*** Creating CrowdinFile in project: " + _project));
        }
        return new CrowdinFile(file, _name, type, _project, shouldBeCleaned);
    }

    public boolean isTranslation(String _filename) {
        return this.matchTranslation(_filename).matches();
    }

    public Matcher matchTranslation(String _filename) {
        Matcher m = this.translationFilePattern.matcher(_filename);
        m.matches();
        if (this.currentMojo.getLog().isDebugEnabled()) {
            this.currentMojo.getLog().debug((CharSequence)("*** Does " + _filename + " Matches? " + m.matches() + "; " + m));
        }
        return m;
    }

    private File fromXMLToProps(File _xmlFile) {
        String path = _xmlFile.getPath();
        try {
            CrowdinFile.Type type;
            CrowdinFile.Type type2 = type = path.contains("gadget") && !path.contains("GadgetPortlet") ? CrowdinFile.Type.GADGET : CrowdinFile.Type.PORTLET;
            if (XMLToProps.parse(path, type)) {
                path = path.replaceAll(".xml", ".properties");
                return new File(path);
            }
        }
        catch (Exception e) {
            this.currentMojo.getLog().error((CharSequence)("Cannot transform " + path + " into a properties file. Reason:\n"), (Throwable)e);
        }
        return _xmlFile;
    }

    public CrowdinTranslation prepareCrowdinTranslation(CrowdinFile _master, File _translationFile) {
        String type = _translationFile.getName().substring(_translationFile.getName().lastIndexOf(46) + 1);
        boolean shouldBeCleaned = false;
        if (type.equals("xml") && !_master.getProject().contains("mobile")) {
            _translationFile = this.fromXMLToProps(_translationFile);
            shouldBeCleaned = true;
        }
        Object lang = "";
        if (_master.getProject().contains("mobile")) {
            String[] values_language;
            List<String> fileSplitTempo = Arrays.asList(_translationFile.getPath().split("/"));
            if (_translationFile.getPath().contains("android")) {
                for (String matchValue : fileSplitTempo) {
                    if (!matchValue.contains("values-")) continue;
                    values_language = matchValue.split("values-");
                    lang = values_language[1];
                }
            }
            if (_translationFile.getPath().contains("ios")) {
                for (String matchValue : fileSplitTempo) {
                    if (!matchValue.contains("lproj") || matchValue.contains("en")) continue;
                    values_language = matchValue.split(".lproj");
                    lang = values_language[0];
                }
            }
        } else if (_translationFile.getPath().contains("gadget") && !_translationFile.getPath().contains("GadgetPortlet")) {
            lang = _translationFile.getName().substring(0, _translationFile.getName().lastIndexOf(46));
            if ("default".equals(lang)) {
                lang = "en";
            } else if (((String)lang).indexOf("_ALL") > 0) {
                lang = ((String)lang).substring(0, ((String)lang).indexOf("_ALL"));
            }
        } else {
            Matcher m = this.matchTranslation(_translationFile.getName());
            lang = m.group(2);
            if (m.group(3) != null) {
                lang = (String)lang + m.group(3);
            }
        }
        String name = CrowdinFileFactory.encodeMinusCharacterInPath(_translationFile.getName(), true);
        return new CrowdinTranslation(_translationFile, name, _master.getType(), _master.getProject(), (String)lang, _master, shouldBeCleaned);
    }

    public static String encodeMinusCharacterInPath(String path, boolean isEncode) {
        if (isEncode) {
            return path == null || path.isEmpty() ? path : path.replace("-", "__");
        }
        return path == null || path.isEmpty() ? path : path.replace("__", "-");
    }
}

