#!/bin/bash
#
# $Id: cleardb-eppsp.sh 8180 2010-09-22 09:34:02Z hgomez $
#
# Copyright (C) 2003-2010 eXo Platform SAS.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see<http://www.gnu.org/licenses/>.#
#
#
# Purpose : Clear Data and SQL DB for EPP-SP for QA teams with/without WCM
#
#
echo CARGOSH-EPPSP-CLEARDB cargosh-binaries 0.4

JBOSS_DISTR_NAME=jboss-epp
DB_HOST=localhost
DB_LOGIN=root
DB_PASSWORD=
MYSQL=false
VERBOSE=false
SETUP_NAME=eppsp

#
# help / usage about program
#
usage()
{
cat << EOF
usage: $0 options

This script clear Gatein Datas (JCR/SQL).

OPTIONS:
   -h      Show this message
   -c      Clear gatein data
   -s      setup name (default: $SETUP_NAME)
   -m      MySQL DB (used in Clear gatein data)
   -l      db login (default: $DB_LOGIN)
   -p      db password (default: $DB_PASSWORD)
   -d      db host (default: $DB_HOST)
   -v      Verbose
EOF
}

#
# Prepare dirs
#
prepare()
{
    INSTALL_DIR=`pwd`/target/install

    # fix location provided by Master to Agents
    if [ ! -z "$WORKSPACE" ]; then
       INSTALL_DIR="$WORKSPACE/../../../$SETUP_NAME"
    else

	    if [ ! -z "$HUDSON_HOME" ]; then
	        if [ -d $HUDSON_HOME ]; then
	            INSTALL_DIR=$HUDSON_HOME/$SETUP_NAME
	        fi
        fi
    fi

    if [ ! -z "$EXO_INSTALL_HOME" ]; then

        if [ -d $EXO_INSTALL_HOME ]; then
            INSTALL_DIR=$EXO_INSTALL_HOME
        fi

    fi

    echo "using $INSTALL_DIR as working eppsp"

    JBOSS_DISTR_NAME=jboss-epp

    # directory where JBossAS will be installed (if not defined outside)
    if [ -z "$JBOSS_BASE" ]; then
        JBOSS_BASE=$INSTALL_DIR/$JBOSS_DISTR_NAME
    fi

    # define jboss.server.data.dir since gatein.data.dir=${jboss.server.data.dir}/gatein (if not defined outside)
    if [ -z "$GATEIN_DATA_DIR" ]; then
        GATEIN_DATA_DIR=$INSTALL_DIR/jboss-data/gatein-data
    fi

    if [ ! -d $GATEIN_DATA_DIR ]; then
        mkdir -p $GATEIN_DATA_DIR
    fi
}

    #
# Clear Gatein data and DB
#
clear_gatein_data()
{
    if [ -d $GATEIN_DATA_DIR ]; then
        echo "clearing gatein datadir"
        rm -rf $GATEIN_DATA_DIR
    fi

#
# Handle OS/X - Linux mysql location
#
    if [ -x /usr/local/mysql/bin/mysqladmin ]; then
      MYSQLADMIN=/usr/local/mysql/bin/mysqladmin
    fi

    if [ -x /Applications/MAMP/Library/bin/mysqladmin ]; then
        MYSQLADMIN=/Applications/MAMP/Library/bin/mysqladmin
    fi

    if [ -x /usr/bin/mysqladmin ]; then
      MYSQLADMIN=/usr/bin/mysqladmin
    fi

    if $MYSQL; then
      echo "clearing MySQLDB"

        $MYSQLADMIN drop $SETUP_NAME-portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN create $SETUP_NAME-portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

        $MYSQLADMIN drop $SETUP_NAME-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN create $SETUP_NAME-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN drop $SETUP_NAME-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN create $SETUP_NAME-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

        $MYSQLADMIN drop $SETUP_NAME-idm_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN create $SETUP_NAME-idm_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN drop $SETUP_NAME-jcr_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
        $MYSQLADMIN create $SETUP_NAME-jcr_ecmdemo -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

    fi
}


#
# Decode command line parameters
#
init()
{
    while getopts "n:i:l:p:d:s:hcmvu" OPTION
    do
         case $OPTION in
             h)
                 usage
                 exit 1
                 ;;
             m)
                 MYSQL=true
                 ;;
             d)
                 DB_HOST=$OPTARG
                 ;;
             l)
                 DB_LOGIN=$OPTARG
                 ;;
             p)
                 DB_PASSWORD=$OPTARG
                 ;;
             s)
                 SETUP_NAME=$OPTARG
                 ;;
             ?)
                 usage
                 exit
                 ;;
         esac
    done
}

#
# MAIN HERE
#

init $@
prepare
clear_gatein_data


