#!/bin/bash
#
# $Id: cargosh-setup-plf-tomcat.sh 8959 2010-10-22 11:10:53Z hgomez $
#
# Copyright (C) 2003-2010 eXo Platform SAS.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see<http://www.gnu.org/licenses/>.#
#
#
# Purpose : Setup a Tomcat PLF single or clustering environnement for QA teams
#

echo CARGOSH-SETUP cargosh-eppsp 0.2

#
# Default vars
#
ARTIFACT="org.exoplatform.platform.assembly"
VERSION="3.0.2"
MYSQL_VERSION=5.1.13

CLEARDATA=false
CLUSTERING=false
MYSQL=false

DB_HOST="localhost"
DB_LOGIN="root"
DB_PASSWORD=""

USER_LOGIN=
USER_PASSWORD=

MIN_IN_POOL=
MAX_IN_POOL=
MAX_WAIT_IN_POOL=
MAX_HTTPAJP_CONNS=

SETUP_NAME=plf

#
# Decode command line parameters
#
usage()
{
cat << EOF
usage: $0 options

This script setup GateIn clustering for QA teams.

OPTIONS:
   -h      Show this message
   -a      artifact (default: $ARTIFACT)
   -v      version (default: $VERSION)
   -r      revision (default: $REVISION)
   -m      select mysql (default: keep package sql settings)
   -u      activate clustering (default: $CLUSTERING)
   -c      clear gatein data directory (default: $CLEARDATA)
   -l      db login (default: $DB_LOGIN)
   -p      db password (default: $DB_PASSWORD)
   -d     db hostl (default: $DB_HOST)
   -s      setup name (default: $SETUP_NAME)
   -I      min idle entries in DataSources pool (default: keep distribution default)
   -A      max entries in DataSources pool (default: keep distribution default)
   -W      max wait in DataSources pool in millis (default: keep distribution default)
   -H      max HTTP/AJP connections (default: keep distribution default)

EOF
}

#
# Decode command line parameters
#
init()
{
    cygwin=false;
    linux=false;
    darwin=false;
    case "`uname`" in
    CYGWIN*) cygwin=true;;
    Linux*) linux=true;;
    Darwin*) darwin=true;;
    esac

    #
    # without parameters, provide help
    #
    if [ $# = 0 ]; then
      usage
      exit 1;
    fi

    while getopts "hmus:cl:p:v:r:b:d:I:A:U:P:W:H:" OPTION
    do
         case $OPTION in
             h)
                 usage
                 exit 1
                 ;;
             m)
                 MYSQL=true
                 ;;
             u)
                 CLUSTERING=true
                 ;;
             s)
                 SETUP_NAME=$OPTARG
                 ;;
              c)
                 CLEARDATA=true
                 ;;
             l)
                 DB_LOGIN=$OPTARG
                 ;;
             p)
                 DB_PASSWORD=$OPTARG
                 ;;
             d)
                 DB_HOST=$OPTARG
                 ;;
             I)
                 MIN_IN_POOL=$OPTARG
                 ;;
             A)
                 MAX_IN_POOL=$OPTARG
                 ;;
             W)
                 MAX_WAIT_IN_POOL=$OPTARG
                 ;;
             H)
                 MAX_HTTPAJP_CONNS=$OPTARG
                 ;;
             ?)
                 usage
                 exit
                 ;;
         esac
    done
}


#
# Prepare dirs
#
prepare()
{
    INSTALL_DIR=`pwd`/target/install

    if [ ! -z "$HUDSON_HOME" ]; then

        if [ -d $HUDSON_HOME ]; then
            INSTALL_DIR=$HUDSON_HOME/$SETUP_NAME
        fi

    fi

    if [ ! -z "$EXO_INSTALL_HOME" ]; then

        if [ -d $EXO_INSTALL_HOME ]; then
            INSTALL_DIR=$EXO_INSTALL_HOME
        fi

    fi

    echo "using $INSTALL_DIR to setup Tomcat PLF"

    # directory where all jars/wars are stored (if not defined outside, set to ./addons)
    if [ -z "$REF_BINARIES_DIR" ]; then
        REF_BINARIES_DIR=`pwd`/target/binaries
    fi

    # data directory
    if [ -z "$DATA_DIR" ]; then
        DATA_DIR=$INSTALL_DIR/datas
    fi

    mkdir -p $REF_BINARIES_DIR
    mkdir -p $DATA_DIR
    mkdir -p $INSTALL_DIR
}

#
# setup common parts
#
setup_common()
{
    if $CLEARDATA; then

        echo "clearing datadir"
        rm -rf $DATA_DIR/*

        #
        # Handle OS/X - Linux mysql location
        #
        if [ -x /usr/local/mysql/bin/mysqladmin ]; then
            MYSQLADMIN=/usr/local/mysql/bin/mysqladmin
        fi

        if [ -x /Applications/MAMP/Library/bin/mysqladmin ]; then
            MYSQLADMIN=/Applications/MAMP/Library/bin/mysqladmin
        fi

        if [ -x /usr/bin/mysqladmin ]; then
            MYSQLADMIN=/usr/bin/mysqladmin
        fi

        if $MYSQL; then
            echo "clearing MySQL DataBases"

            $MYSQLADMIN drop exo-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
            $MYSQLADMIN drop exo-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

            echo "creating MySQL Databases"

            $MYSQLADMIN create exo-idm_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD
            $MYSQLADMIN create exo-jcr_portal -f --host=$DB_HOST --user=$DB_LOGIN --password=$DB_PASSWORD

         fi

     fi


    if [ ! -f $REF_BINARIES_DIR/$PACKAGE_NAME-$VERSION-$REVISION.zip ]; then

        unzip -t $REF_BINARIES_DIR/$PACKAGE_NAME-$VERSION-$REVISION.zip >/dev/null

        if [ $? != "0" ]; then
            echo "couldn't unzip $REF_BINARIES_DIR/$PACKAGE_NAME-$VERSION-$REVISION.zip, aborting"
            exit -1
        fi

     fi

    echo "cleaning install directory"

    rm -rf $INSTALL_DIR/*
    pushd $INSTALL_DIR
    echo "unziping package..."
    unzip $REF_BINARIES_DIR/$PACKAGE_NAME-$VERSION-$REVISION.zip >>/dev/null
    echo "PLF package unziped"
    popd

    GATEIN_CONF=$INSTALL_DIR/bin/tomcat6-bundle/gatein/conf/configuration.properties
    TOMCAT_CONF=$INSTALL_DIR/bin/tomcat6-bundle/conf/server.xml
    TOMCAT_LIB=$INSTALL_DIR/bin/tomcat6-bundle/lib

    # gatein.data.dir=../gatein/data -> gatein.data.dir=DATA_DIR
    sed -i -e "s|../gatein/data|$DATA_DIR|g" $GATEIN_CONF


    if $CLUSTERING; then

        # Set jcr configuration for clustering
        sed -i -e "s|gatein.jcr.config.type=local|gatein.jcr.config.type=cluster|g" $GATEIN_CONF
        # Update ChangeFilterClass
        sed -i -e "s|gatein.jcr.index.changefilterclass=org.exoplatform.services.jcr.impl.core.query.DefaultChangesFilter|gatein.jcr.index.changefilterclass=org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter|g" $GATEIN_CONF

    fi

    # update Datasource settings if needed

    if [ ! -z "$MIN_IN_POOL" ]; then
        sed -i -e "s|maxIdle=\"10\"|maxIdle=\"$MIN_IN_POOL\"|g" $TOMCAT_CONF
    fi

    if [ ! -z "$MAX_IN_POOL" ]; then
        sed -i -e "s|maxActive=\"20\"|maxActive=\"$MAX_IN_POOL\"|g" $TOMCAT_CONF
    fi

    if [ ! -z "$MAX_WAIT_IN_POOL" ]; then
        sed -i -e "s|maxWait=\"10000\"|maxWait=\"$MAX_WAIT_IN_POOL\"|g" $TOMCAT_CONF
    fi


    if $MYSQL; then

        # change log/pwd
        sed -i -e "s|username=\"sa\"|username=\"$DB_LOGIN\"|g" $TOMCAT_CONF
        sed -i -e "s|password=\"\"|password=\"$DB_PASSWORD\"|g" $TOMCAT_CONF
        # change driver
        sed -i -e "s|org.hsqldb.jdbcDriver|com.mysql.jdbc.Driver|g" $TOMCAT_CONF
        # change urls (jcr/idm)
        sed -i -e "s|jdbc:hsqldb:file:../gatein/data/hsql/exo-jcr_portal|jdbc:mysql://$DB_HOST/exo-jcr_portal|g" $TOMCAT_CONF
        sed -i -e "s|jdbc:hsqldb:file:../gatein/data/hsql/exo-idm_portal|jdbc:mysql://$DB_HOST/exo-idm_portal|g" $TOMCAT_CONF

        rm -f $TOMCAT_LIB/mysql-connector*.jar
        cp $REF_BINARIES_DIR/mysql-connector-java-*.jar $TOMCAT_LIB

    fi


    # fix sed -e under OS/X
    rm -f $GATEIN_CONF-e
    rm -f $TOMCAT_CONF-e
}

#
# MAIN HERE
#

init $@
prepare
setup_common

echo "PLF ready to use :"
echo "cd $INSTALL_DIR/bin/tomcat6-bundle/bin"
echo "./gatein.sh run"
