/* eslint-disable */
var assert = require('chai').assert;
var encodeParams = require('../index.js').encodeParams;
var BigNumber = require('bignumber.js');
var BN = require('bn.js');

describe('encodeParam', function () {
          var test = function test(t) {
              it('should turn type ' + t.type + ' ' + t.value + ' to 0x' + t.expected, function () {
                  assert.equal(encodeParams([t.type], [t.value]), '0x' + t.expected);
              });
          };

          test({ type: 'address', value: '0x407d73d8a49eeb85d32cf465507dd71d507100c1',
                    expected: '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c1' });
          test({ type: 'address[2]', value: ['0x407d73d8a49eeb85d32cf465507dd71d507100c1', '0x407d73d8a49eeb85d32cf465507dd71d507100c3'],
                    expected: '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c1' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' });
          test({ type: 'address[]', value: ['0x407d73d8a49eeb85d32cf465507dd71d507100c1', '0x407d73d8a49eeb85d32cf465507dd71d507100c3'],
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000002' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c1' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' });
          /* test({ type: 'address[][2]', value: [['0x407d73d8a49eeb85d32cf465507dd71d507100c1', '0x407d73d8a49eeb85d32cf465507dd71d507100c2'],
                                                 ['0x407d73d8a49eeb85d32cf465507dd71d507100c3', '0x407d73d8a49eeb85d32cf465507dd71d507100c4']],
                                                      expected: '0000000000000000000000000000000000000000000000000000000000000040' +
                                                                '00000000000000000000000000000000000000000000000000000000000000a0' +
                                                                '0000000000000000000000000000000000000000000000000000000000000002' +
                                                                '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c1' +
                                                                '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c2' +
                                                                '0000000000000000000000000000000000000000000000000000000000000002' +
                                                                '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' +
                                                                '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c4' }); */
          test({ type: 'address[2][]', value: [['0x407d73d8a49eeb85d32cf465507dd71d507100c1', '0x407d73d8a49eeb85d32cf465507dd71d507100c2'], ['0x407d73d8a49eeb85d32cf465507dd71d507100c3', '0x407d73d8a49eeb85d32cf465507dd71d507100c4']],
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000002' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c1' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c2' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' + '000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c4' });
          //test({ type: 'address[][]', value: [['0x407d73d8a49eeb85d32cf465507dd71d507100c5'],
          //['0x407d73d8a49eeb85d32cf465507dd71d507100c3']],
          //expected: '0000000000000000000000000000000000000000000000000000000000000020' +
          //'0000000000000000000000000000000000000000000000000000000000000002' +
          //'0000000000000000000000000000000000000000000000000000000000000080' +
          //'00000000000000000000000000000000000000000000000000000000000000c0' +
          //'0000000000000000000000000000000000000000000000000000000000000001' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c5' +
          //'0000000000000000000000000000000000000000000000000000000000000001' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' });
          //test({ type: 'address[][]', value: [['0x407d73d8a49eeb85d32cf465507dd71d507100cf', '0x407d73d8a49eeb85d32cf465507dd71d507100c2'],
          //['0x407d73d8a49eeb85d32cf465507dd71d507100c3', '0x407d73d8a49eeb85d32cf465507dd71d507100c4']],
          //expected: '0000000000000000000000000000000000000000000000000000000000000020' +
          //'0000000000000000000000000000000000000000000000000000000000000002' +
          //'0000000000000000000000000000000000000000000000000000000000000080' +
          //'00000000000000000000000000000000000000000000000000000000000000e0' +
          //'0000000000000000000000000000000000000000000000000000000000000002' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100cf' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c2' +
          //'0000000000000000000000000000000000000000000000000000000000000002' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c3' +
          //'000000000000000000000000407d73d8a49eeb85d32cf465507dd71d507100c4' });
          test({ type: 'bool', value: true, expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'bool', value: false, expected: '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'bool[1][2]', value: [[false], [false]],
                    expected: '0000000000000000000000000000000000000000000000000000000000000000' + '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'bool[2]', value: [true, false],
                    expected: '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'bool[]', value: [true, true, false],
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000003' + '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000000' });

          test({ type: 'int', value: new BigNumber(1), expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'int', value: new BN(1), expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'int', value: 1, expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'int', value: new BigNumber(16), expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'int', value: new BN(16), expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'int', value: 16, expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'int', value: -1, expected: 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' });
          test({ type: 'int', value: new BigNumber('0'), expected: '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'int', value: 0.1, expected: '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'int', value: 3.9, expected: '0000000000000000000000000000000000000000000000000000000000000003' });
          test({ type: 'int256', value: 1, expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'int256', value: 16, expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'int256', value: -1, expected: 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' });

          test({ type: 'uint', value: 1, expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'uint', value: 16, expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'uint', value: 0.1, expected: '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'uint', value: 3.9, expected: '0000000000000000000000000000000000000000000000000000000000000003' });
          test({ type: 'uint256', value: 1, expected: '0000000000000000000000000000000000000000000000000000000000000001' });
          test({ type: 'uint256', value: 16, expected: '0000000000000000000000000000000000000000000000000000000000000010' });
          test({ type: 'uint256', value: '0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff',
                    expected: 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' });
          // need further investigation
          test({ type: 'bytes32', value: '0x6761766f66796f726b',
                    expected: '6761766f66796f726b0000000000000000000000000000000000000000000000' });
          test({ type: 'bytes32', value: '0x731a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b',
                    expected: '731a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' });
          test({ type: 'bytes32', value: '0x02838654a83c213dae3698391eabbd54a5b6e1fb3452bc7fa4ea0dd5c8ce7e29',
                    expected: '02838654a83c213dae3698391eabbd54a5b6e1fb3452bc7fa4ea0dd5c8ce7e29' });
          // need further investigation
          test({ type: 'bytes', value: '0x6761766f66796f726b',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000009' + '6761766f66796f726b0000000000000000000000000000000000000000000000' });
          test({ type: 'bytes', value: '0x731a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000020' + '731a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' });
          test({ type: 'bytes', value: '0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff1',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '000000000000000000000000000000000000000000000000000000000000009f' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff' + 'fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff100' });
          test({ type: 'string', value: 'gavofyork', expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000009' + '6761766f66796f726b0000000000000000000000000000000000000000000000' });
          // require further investigation
          // test({ type: 'bytes', value: '0xc3a40000c3a4',
          //                                             expected: '0000000000000000000000000000000000000000000000000000000000000020' +
          //                                                       '0000000000000000000000000000000000000000000000000000000000000006' +
          //                                                       'c3a40000c3a40000000000000000000000000000000000000000000000000000'});
          // test({ type: 'bytes32', value: '0xc3a40000c3a4',
          //                                            expected: 'c3a40000c3a40000000000000000000000000000000000000000000000000000'});
          /* test({ type: 'bytes64', value: '0xc3a40000c3a40000000000000000000000000000000000000000000000000000' +
                                           'c3a40000c3a40000000000000000000000000000000000000000000000000000',
                                                      expected: 'c3a40000c3a40000000000000000000000000000000000000000000000000000' +
                                                                'c3a40000c3a40000000000000000000000000000000000000000000000000000'}); */
          test({ type: 'string', value: 'Ã¤Ã¤',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000008' + 'c383c2a4c383c2a4000000000000000000000000000000000000000000000000' });
          test({ type: 'string', value: 'ü',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000002' + 'c3bc000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'string', value: 'Ã',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000002' + 'c383000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'int[]', value: [], expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000000' });
          test({ type: 'int[]', value: [3], expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000003' });
          test({ type: 'int256[]', value: [3], expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000003' });
          test({ type: 'int[]', value: [1, 2, 3], expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000003' + '0000000000000000000000000000000000000000000000000000000000000001' + '0000000000000000000000000000000000000000000000000000000000000002' + '0000000000000000000000000000000000000000000000000000000000000003' });
          test({ type: 'bytes1[4]', value: ['0xcf', '0x68', '0x4d', '0xfb'],
                    expected: 'cf00000000000000000000000000000000000000000000000000000000000000' + '6800000000000000000000000000000000000000000000000000000000000000' + '4d00000000000000000000000000000000000000000000000000000000000000' + 'fb00000000000000000000000000000000000000000000000000000000000000' });

          // test({ type: 'real', value: 1,              expected: '0000000000000000000000000000000100000000000000000000000000000000'});
          // test({ type: 'real', value: 2.125,          expected: '0000000000000000000000000000000220000000000000000000000000000000'});
          // test({ type: 'real', value: 8.5,            expected: '0000000000000000000000000000000880000000000000000000000000000000'});
          // test({ type: 'real', value: -1,             expected: 'ffffffffffffffffffffffffffffffff00000000000000000000000000000000'});
          // test({ type: 'ureal', value: 1,             expected: '0000000000000000000000000000000100000000000000000000000000000000'});
          // test({ type: 'ureal', value: 2.125,         expected: '0000000000000000000000000000000220000000000000000000000000000000'});
          // test({ type: 'ureal', value: 8.5,           expected: '0000000000000000000000000000000880000000000000000000000000000000'});
          test({ type: 'bytes', value: '0x131a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '231a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000040' + '131a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '231a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' });
          test({ type: 'bytes', value: '0x131a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '231a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '331a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '0000000000000000000000000000000000000000000000000000000000000060' + '131a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '231a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' + '331a3afc00d1b1e3461b955e53fc866dcf303b3eb9f4c16f89e388930f48134b' });
          test({ type: 'string', value: 'welcome to ethereum. welcome to ethereum. welcome to ethereum.',
                    expected: '0000000000000000000000000000000000000000000000000000000000000020' + '000000000000000000000000000000000000000000000000000000000000003e' + '77656c636f6d6520746f20657468657265756d2e2077656c636f6d6520746f20' + '657468657265756d2e2077656c636f6d6520746f20657468657265756d2e0000' });
});
