#!/usr/bin/env node

/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1152);
/******/ })
/************************************************************************/
/******/ ({

/***/ 0:
/***/ (function(module, exports) {

module.exports = require("path");

/***/ }),

/***/ 1:
/***/ (function(module, exports) {

module.exports = require("fs");

/***/ }),

/***/ 106:
/***/ (function(module, exports) {

module.exports = require("module");

/***/ }),

/***/ 11:
/***/ (function(module, exports) {

module.exports = require("assert");

/***/ }),

/***/ 1152:
/***/ (function(module, exports, __webpack_require__) {


var IPC = __webpack_require__(179).IPC;
var TestRPC = __webpack_require__(178);
var path = __webpack_require__(0);
var debug = __webpack_require__(142);

/*
 * Loggers
 */
var ipcDebug = debug("chain:ipc");


/*
 * Options
 */

// This script takes one argument: A strinified JSON object meant
// to be parsed and then passed to TestRPC.server().
var ipcNetwork;
var options;

var args = process.argv.slice(2);
if (args.length == 2) {
  ipcNetwork = args[0];
  options = args[1];
} else if (args.length == 1) {
  ipcNetwork = "develop";
  options = args[0];
} else {
  ipcNetwork = "develop";
  options = "{}";
}

try {
  options = JSON.parse(options);
} catch (e) {
  throw new Error("Fatal: Error parsing arguments; please contact the Truffle developers for help.");
}

options.host = options.host || "127.0.0.1";
options.port = options.port || 9545;
options.network_id = options.network_id || 4447;
options.mnemonic = options.mnemonic || "candy maple cake sugar pudding cream honey rich smooth crumble sweet treat";
options.gasLimit = options.gasLimit || 0x47e7c4;


/*
 * Logging
 */

// constructor
function Logger() {
  this.messages = [];

  this.nextSubscriberID = 1;
  this.subscribers = {};
}

// subscribe to log events with provided callback
// sends prior unsent messages, as well as new messages
// returns `unsubscribe` cleanup function
Logger.prototype.subscribe = function(callback) {
  var self = this;

  // flush messages
  var messages = this.messages;
  this.messages = [];
  messages.forEach(function(message) {
    callback(message);
  });

  // save subscriber
  var subscriberID = this.nextSubscriberID++;
  this.subscribers[subscriberID] = callback;

  // return cleanup func
  var unsubscribe = function() {
    delete self.subscribers[subscriberID];
  };

  return unsubscribe;
};

// log a message to be sent to all active subscribers
// buffers if there are no active subscribers (to send on first subscribe)
Logger.prototype.log = function(message) {
  var self = this;

  var subscriberIDs = Object.keys(this.subscribers)
  if (subscriberIDs.length == 0) {
    this.messages.push(message);

    return;
  }

  subscriberIDs.forEach(function(subscriberID) {
    var callback = self.subscribers[subscriberID];

    callback(message);
  });
};


/*
 * Supervisor
 */

// constructor - accepts an object to assign to `ipc.config`
function Supervisor(ipcConfig) {
  var self = this;

  // init IPC
  this.ipc = new IPC();
  // set config
  Object.keys(ipcConfig).forEach(function(key) {
    self.ipc.config[key] = ipcConfig[key];
  });

  this.mixins = [];
}

// include mixin
Supervisor.prototype.use = function(mixin) {
  this.mixins.push(mixin);
};

// dispatch event to all relevant mixins (ones that define `event` method)
Supervisor.prototype.handle = function(event, args) {
  var self = this;

  args = Array.prototype.slice.call(args);

  this.mixins.forEach(function(mixin) {
    if (mixin[event]) {
      mixin[event].apply(mixin, [self].concat(args));
    }
  });
};

// start the IPC server and hook up all the mixins
Supervisor.prototype.start = function() {
  var self = this;

  var ipc = this.ipc;

  // socket filename
  var dirname = ipc.config.socketRoot;
  var basename = `${ipc.config.appspace}${ipc.config.id}`;
  var servePath = path.join(dirname, basename);

  ipc.serve(servePath, function() {
    self.handle('start', arguments);

    ipc.server.on('connect', function() {
      self.handle('connect', arguments);
    });

    ipc.server.on('socket.disconnected', function() {
      self.handle('disconnect', arguments);
    });
  });

  ipc.server.start();
}

// external interface for mixin to emit socket events
Supervisor.prototype.emit = function(socket, message, data, options) {
  options = options || {};
  options.silent = options.silent || false;

  // possibly override silent
  var currentlySilent = this.ipc.config.silent;
  if (options.silent) {
    this.ipc.config.silent = true;
  }

  this.ipc.server.emit(socket, message, data);

  // reset
  this.ipc.config.silent = currentlySilent;
};

// external interface for mixin to exit
Supervisor.prototype.exit = function() {
  this.ipc.server.stop();
  this.handle('exit', arguments);
}


/*
 * Lifecycle
 * (quit on last connection)
 */
function LifecycleMixin() {
  var self = this;
}

// start counting active connections
LifecycleMixin.prototype.start = function(supervisor) {
  this.connections = 0;
};

// increment
LifecycleMixin.prototype.connect = function(supervisor) {
  this.connections++;
};

// decrement - invoke supervisor exit if no connections remain
LifecycleMixin.prototype.disconnect = function(supervisor) {
  this.connections--;

  if (this.connections <= 0) {
    supervisor.exit();
  }
};


/*
 * TestRPC Server
 */

// constructor - accepts options for TestRPC
function TestRPCMixin(options) {
  this.testrpc = TestRPC.server(options);
}

// start TestRPC and capture promise that resolves when ready
TestRPCMixin.prototype.start = function(supervisor) {
  var self = this;

  this.ready = new Promise(function(accept, reject) {
    self.testrpc.listen(options.port, options.hostname, function(err, state) {
      if (err) {
        reject(err);
      }

      accept(state);
    });
  });
};

// wait for TestRPC to be ready then emit signal to client socket
TestRPCMixin.prototype.connect = function(supervisor, socket) {
  var self = this;
  this.ready.then(function() {
    supervisor.emit(socket, 'truffle.ready');
  });
}

// cleanup TestRPC process on exit
TestRPCMixin.prototype.exit = function(supervisor) {
  this.testrpc.close(function(err) {
    if (err) {
      console.error(err.stack || err);
      process.exit(1);
    } else {
      process.exit();
    }
  });
};


/*
 * Logging over IPC
 */

// constructor - takes Logger instance and message key (e.g. `truffle.ipc.log`)
function LoggerMixin(logger, message) {
  this.logger = logger;
  this.message = message;
}

// on connect, subscribe client socket to logger
LoggerMixin.prototype.connect = function(supervisor, socket) {
  var self = this;

  var unsubscribe = this.logger.subscribe(function(data) {
    supervisor.emit(socket, self.message, data, {silent: true});
  });

  socket.on('close', unsubscribe);
};


/*
 * Process event handling
 */
process.on('uncaughtException', function(e) {
  console.error(e.stack);
  process.exit(1);
})


/*
 * Main
 */
var ipcLogger = new Logger();
var testrpcLogger = new Logger();

var supervisor = new Supervisor({
  appspace: "truffle.",
  id: ipcNetwork,
  retry: 1500,
  logger: ipcLogger.log.bind(ipcLogger)
});

ipcLogger.subscribe(ipcDebug);

options.logger = {log: testrpcLogger.log.bind(testrpcLogger)};

supervisor.use(new LifecycleMixin());
supervisor.use(new TestRPCMixin(options));
supervisor.use(new LoggerMixin(ipcLogger, 'truffle.ipc.log'));
supervisor.use(new LoggerMixin(testrpcLogger, 'truffle.testrpc.log'));
supervisor.start();


/***/ }),

/***/ 123:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


let EventPubSub = __webpack_require__(79);
if(process.version[1]>5){
    EventPubSub = __webpack_require__(215);
}

module.exports=EventPubSub;


/***/ }),

/***/ 125:
/***/ (function(module, exports) {

function Message() {
    Object.defineProperties(
        this, {
            data: {
                enumerable: true,
                get: getData,
                set: setData
            },
            type: {
                enumerable: true,
                get: getType,
                set: setType
            },
            load:{
                enumarable:true,
                writable:false,
                value:parse
            },
            JSON: {
                enumerable: true,
                get: getJSON
            }
        }
    );

    var type = '';
    var data = {};

    function getType() {
        return type;
    }

    function getData() {
        return data;
    }

    function getJSON() {
        return JSON.stringify(
            {
                type: type,
                data: data
            }
        );
    }

    function setType(value) {
        type = value;
    }

    function setData(value) {
        data = value;
    }

    function parse(message){
        try{
            var message=JSON.parse(message);
            type=message.type;
            data=message.data;
        }catch(err){
            var badMessage=message;
            type='error',
            data={
                message:'Invalid JSON response format',
                err:err,
                response:badMessage
            }
        }
    }
}

module.exports=Message;


/***/ }),

/***/ 127:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*eslint no-magic-numbers: ["error", { "ignore": [ 0] }]*/

/**
 * @module entities
 */

const os = __webpack_require__(5);

/**
 * @class Defaults
 * @description Defaults Entity
 */
class Defaults{

    /**
     * @constructor
     * @method constructor
     * @return {void}
     */
    constructor(){

        this.appspace='app.';
        this.socketRoot='/tmp/';
        this.id=os.hostname();

        this.encoding='utf8';
        this.rawBuffer=false;
        this.sync=false;
        this.unlink=true;

        this.delimiter='\f';

        this.silent=false;
        this.logDepth=5;
        this.logInColor=true;
        this.logger=console.log.bind(console);

        this.maxConnections=100;
        this.retry=500;
        this.maxRetries=Infinity;
        this.stopRetrying=false;

        this.IPType=getIPType();
        this.tls=false;
        this.networkHost = (this.IPType == 'IPv6') ? '::1' : '127.0.0.1';
        this.networkPort = 8000;

        this.interface={
            localAddress:false,
            localPort:false,
            family:false,
            hints:false,
            lookup:false
        }
    }
}

/**
 * method to get ip type
 *
 * @method getIPType
 * @return {string} ip type
 */
function getIPType() {
    const networkInterfaces = os.networkInterfaces();
    let IPType = '';
    if (networkInterfaces
        && Array.isArray(networkInterfaces)
        && networkInterfaces.length > 0) {
        // getting the family of first network interface available
        IPType = networkInterfaces [
            Object.keys( networkInterfaces )[0]
        ][0].family;
    }
    return IPType;
}

module.exports=Defaults;


/***/ }),

/***/ 128:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


const Defaults = __webpack_require__(127);

class Parser{
  constructor(config){
    if(!config){
      config=new Defaults;
    }
    this.delimiter=config.delimiter;
  }

  format(message){
    if(!message.data && message.data!==false && message.data!==0){
        message.data={};
    }
    if(message.data['_maxListeners']){
        message.data={};
    }

    message=message.JSON+this.delimiter;
    return message;
  }

  parse(data){
    let events=data.split(this.delimiter);
    events.pop();
    return events;
  }
}

module.exports=Parser;


/***/ }),

/***/ 140:
/***/ (function(module, exports, __webpack_require__) {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 *
 * Expose `debug()` as the module.
 */

exports = module.exports = createDebug.debug = createDebug['default'] = createDebug;
exports.coerce = coerce;
exports.disable = disable;
exports.enable = enable;
exports.enabled = enabled;
exports.humanize = __webpack_require__(42);

/**
 * Active `debug` instances.
 */
exports.instances = [];

/**
 * The currently active debug mode names, and names to skip.
 */

exports.names = [];
exports.skips = [];

/**
 * Map of special "%n" handling functions, for the debug "format" argument.
 *
 * Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
 */

exports.formatters = {};

/**
 * Select a color.
 * @param {String} namespace
 * @return {Number}
 * @api private
 */

function selectColor(namespace) {
  var hash = 0, i;

  for (i in namespace) {
    hash  = ((hash << 5) - hash) + namespace.charCodeAt(i);
    hash |= 0; // Convert to 32bit integer
  }

  return exports.colors[Math.abs(hash) % exports.colors.length];
}

/**
 * Create a debugger with the given `namespace`.
 *
 * @param {String} namespace
 * @return {Function}
 * @api public
 */

function createDebug(namespace) {

  var prevTime;

  function debug() {
    // disabled?
    if (!debug.enabled) return;

    var self = debug;

    // set `diff` timestamp
    var curr = +new Date();
    var ms = curr - (prevTime || curr);
    self.diff = ms;
    self.prev = prevTime;
    self.curr = curr;
    prevTime = curr;

    // turn the `arguments` into a proper Array
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }

    args[0] = exports.coerce(args[0]);

    if ('string' !== typeof args[0]) {
      // anything else let's inspect with %O
      args.unshift('%O');
    }

    // apply any `formatters` transformations
    var index = 0;
    args[0] = args[0].replace(/%([a-zA-Z%])/g, function(match, format) {
      // if we encounter an escaped % then don't increase the array index
      if (match === '%%') return match;
      index++;
      var formatter = exports.formatters[format];
      if ('function' === typeof formatter) {
        var val = args[index];
        match = formatter.call(self, val);

        // now we need to remove `args[index]` since it's inlined in the `format`
        args.splice(index, 1);
        index--;
      }
      return match;
    });

    // apply env-specific formatting (colors, etc.)
    exports.formatArgs.call(self, args);

    var logFn = debug.log || exports.log || console.log.bind(console);
    logFn.apply(self, args);
  }

  debug.namespace = namespace;
  debug.enabled = exports.enabled(namespace);
  debug.useColors = exports.useColors();
  debug.color = selectColor(namespace);
  debug.destroy = destroy;

  // env-specific initialization logic for debug instances
  if ('function' === typeof exports.init) {
    exports.init(debug);
  }

  exports.instances.push(debug);

  return debug;
}

function destroy () {
  var index = exports.instances.indexOf(this);
  if (index !== -1) {
    exports.instances.splice(index, 1);
    return true;
  } else {
    return false;
  }
}

/**
 * Enables a debug mode by namespaces. This can include modes
 * separated by a colon and wildcards.
 *
 * @param {String} namespaces
 * @api public
 */

function enable(namespaces) {
  exports.save(namespaces);

  exports.names = [];
  exports.skips = [];

  var i;
  var split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
  var len = split.length;

  for (i = 0; i < len; i++) {
    if (!split[i]) continue; // ignore empty strings
    namespaces = split[i].replace(/\*/g, '.*?');
    if (namespaces[0] === '-') {
      exports.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
    } else {
      exports.names.push(new RegExp('^' + namespaces + '$'));
    }
  }

  for (i = 0; i < exports.instances.length; i++) {
    var instance = exports.instances[i];
    instance.enabled = exports.enabled(instance.namespace);
  }
}

/**
 * Disable debug output.
 *
 * @api public
 */

function disable() {
  exports.enable('');
}

/**
 * Returns true if the given mode name is enabled, false otherwise.
 *
 * @param {String} name
 * @return {Boolean}
 * @api public
 */

function enabled(name) {
  if (name[name.length - 1] === '*') {
    return true;
  }
  var i, len;
  for (i = 0, len = exports.skips.length; i < len; i++) {
    if (exports.skips[i].test(name)) {
      return false;
    }
  }
  for (i = 0, len = exports.names.length; i < len; i++) {
    if (exports.names[i].test(name)) {
      return true;
    }
  }
  return false;
}

/**
 * Coerce `val`.
 *
 * @param {Mixed} val
 * @return {Mixed}
 * @api private
 */

function coerce(val) {
  if (val instanceof Error) return val.stack || val.message;
  return val;
}


/***/ }),

/***/ 141:
/***/ (function(module, exports) {

module.exports = require("constants");

/***/ }),

/***/ 142:
/***/ (function(module, exports, __webpack_require__) {

/**
 * Detect Electron renderer process, which is node, but we should
 * treat as a browser.
 */

if (typeof process === 'undefined' || process.type === 'renderer') {
  module.exports = __webpack_require__(250);
} else {
  module.exports = __webpack_require__(251);
}


/***/ }),

/***/ 178:
/***/ (function(module, exports, __webpack_require__) {

!function(e,a){ true?module.exports=a():"function"==typeof define&&define.amd?define("ganache",[],a):"object"==typeof exports?exports.ganache=a():e.ganache=a()}(global,function(){return function(e){var a={};function t(r){if(a[r])return a[r].exports;var c=a[r]={i:r,l:!1,exports:{}};return e[r].call(c.exports,c,c.exports,t),c.l=!0,c.exports}return t.m=e,t.c=a,t.d=function(e,a,r){t.o(e,a)||Object.defineProperty(e,a,{enumerable:!0,get:r})},t.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},t.t=function(e,a){if(1&a&&(e=t(e)),8&a)return e;if(4&a&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(t.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&a&&"string"!=typeof e)for(var c in e)t.d(r,c,function(a){return e[a]}.bind(null,c));return r},t.n=function(e){var a=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(a,"a",a),a},t.o=function(e,a){return Object.prototype.hasOwnProperty.call(e,a)},t.p="",t(t.s=1037)}([function(e,a,t){try{var r=t(1);if("function"!=typeof r.inherits)throw"";e.exports=r.inherits}catch(a){e.exports=t(1021)}},function(e,a){e.exports=__webpack_require__(2)},function(e,a){e.exports=__webpack_require__(0)},function(e,a,t){"use strict";var r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},c=t(1024),n=t(91),i=t(11),f=t(52),o=t(9),d=t(30),s=t(7).Buffer;Object.assign(a,t(379)),a.MAX_INTEGER=new o("ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",16),a.TWO_POW256=new o("10000000000000000000000000000000000000000000000000000000000000000",16),a.KECCAK256_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",a.SHA3_NULL_S=a.KECCAK256_NULL_S,a.KECCAK256_NULL=s.from(a.KECCAK256_NULL_S,"hex"),a.SHA3_NULL=a.KECCAK256_NULL,a.KECCAK256_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",a.SHA3_RLP_ARRAY_S=a.KECCAK256_RLP_ARRAY_S,a.KECCAK256_RLP_ARRAY=s.from(a.KECCAK256_RLP_ARRAY_S,"hex"),a.SHA3_RLP_ARRAY=a.KECCAK256_RLP_ARRAY,a.KECCAK256_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",a.SHA3_RLP_S=a.KECCAK256_RLP_S,a.KECCAK256_RLP=s.from(a.KECCAK256_RLP_S,"hex"),a.SHA3_RLP=a.KECCAK256_RLP,a.BN=o,a.rlp=f,a.secp256k1=n,a.zeros=function(e){return s.allocUnsafe(e).fill(0)},a.zeroAddress=function(){var e=a.zeros(20);return a.bufferToHex(e)},a.setLengthLeft=a.setLength=function(e,t,r){var c=a.zeros(t);return e=a.toBuffer(e),r?e.length<t?(e.copy(c),c):e.slice(0,t):e.length<t?(e.copy(c,t-e.length),c):e.slice(-t)},a.setLengthRight=function(e,t){return a.setLength(e,t,!0)},a.unpad=a.stripZeros=function(e){for(var t=(e=a.stripHexPrefix(e))[0];e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e},a.toBuffer=function(e){if(!s.isBuffer(e))if(Array.isArray(e))e=s.from(e);else if("string"==typeof e)e=a.isHexString(e)?s.from(a.padToEven(a.stripHexPrefix(e)),"hex"):s.from(e);else if("number"==typeof e)e=a.intToBuffer(e);else if(null===e||void 0===e)e=s.allocUnsafe(0);else if(o.isBN(e))e=e.toArrayLike(s);else{if(!e.toArray)throw new Error("invalid type");e=s.from(e.toArray())}return e},a.bufferToInt=function(e){return new o(a.toBuffer(e)).toNumber()},a.bufferToHex=function(e){return"0x"+(e=a.toBuffer(e)).toString("hex")},a.fromSigned=function(e){return new o(e).fromTwos(256)},a.toUnsigned=function(e){return s.from(e.toTwos(256).toArray())},a.keccak=function(e,t){return e=a.toBuffer(e),t||(t=256),c("keccak"+t).update(e).digest()},a.keccak256=function(e){return a.keccak(e)},a.sha3=a.keccak,a.sha256=function(e){return e=a.toBuffer(e),d("sha256").update(e).digest()},a.ripemd160=function(e,t){e=a.toBuffer(e);var r=d("rmd160").update(e).digest();return!0===t?a.setLength(r,32):r},a.rlphash=function(e){return a.keccak(f.encode(e))},a.isValidPrivate=function(e){return n.privateKeyVerify(e)},a.isValidPublic=function(e,a){return 64===e.length?n.publicKeyVerify(s.concat([s.from([4]),e])):!!a&&n.publicKeyVerify(e)},a.pubToAddress=a.publicToAddress=function(e,t){return e=a.toBuffer(e),t&&64!==e.length&&(e=n.publicKeyConvert(e,!1).slice(1)),i(64===e.length),a.keccak(e).slice(-20)};var b=a.privateToPublic=function(e){return e=a.toBuffer(e),n.publicKeyCreate(e,!1).slice(1)};a.importPublic=function(e){return 64!==(e=a.toBuffer(e)).length&&(e=n.publicKeyConvert(e,!1).slice(1)),e},a.ecsign=function(e,a){var t=n.sign(e,a),r={};return r.r=t.signature.slice(0,32),r.s=t.signature.slice(32,64),r.v=t.recovery+27,r},a.hashPersonalMessage=function(e){var t=a.toBuffer("Ethereum Signed Message:\n"+e.length.toString());return a.keccak(s.concat([t,e]))},a.ecrecover=function(e,t,r,c){var i=s.concat([a.setLength(r,32),a.setLength(c,32)],64),f=t-27;if(0!==f&&1!==f)throw new Error("Invalid signature v value");var o=n.recover(e,i,f);return n.publicKeyConvert(o,!1).slice(1)},a.toRpcSig=function(e,t,r){if(27!==e&&28!==e)throw new Error("Invalid recovery id");return a.bufferToHex(s.concat([a.setLengthLeft(t,32),a.setLengthLeft(r,32),a.toBuffer(e-27)]))},a.fromRpcSig=function(e){if(65!==(e=a.toBuffer(e)).length)throw new Error("Invalid signature length");var t=e[64];return t<27&&(t+=27),{v:t,r:e.slice(0,32),s:e.slice(32,64)}},a.privateToAddress=function(e){return a.publicToAddress(b(e))},a.isValidAddress=function(e){return/^0x[0-9a-fA-F]{40}$/.test(e)},a.isZeroAddress=function(e){return a.zeroAddress()===a.addHexPrefix(e)},a.toChecksumAddress=function(e){e=a.stripHexPrefix(e).toLowerCase();for(var t=a.keccak(e).toString("hex"),r="0x",c=0;c<e.length;c++)parseInt(t[c],16)>=8?r+=e[c].toUpperCase():r+=e[c];return r},a.isValidChecksumAddress=function(e){return a.isValidAddress(e)&&a.toChecksumAddress(e)===e},a.generateAddress=function(e,t){return e=a.toBuffer(e),t=(t=new o(t)).isZero()?null:s.from(t.toArray()),a.rlphash([e,t]).slice(-20)},a.isPrecompiled=function(e){var t=a.unpad(e);return 1===t.length&&t[0]>=1&&t[0]<=8},a.addHexPrefix=function(e){return"string"!=typeof e?e:a.isHexPrefixed(e)?e:"0x"+e},a.isValidSignature=function(e,a,t,r){var c=new o("7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe92f46681b20a0",16),n=new o("fffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141",16);return 32===a.length&&32===t.length&&((27===e||28===e)&&(a=new o(a),t=new o(t),!(a.isZero()||a.gt(n)||t.isZero()||t.gt(n))&&(!1!==r||1!==new o(t).cmp(c))))},a.baToJSON=function(e){if(s.isBuffer(e))return"0x"+e.toString("hex");if(e instanceof Array){for(var t=[],r=0;r<e.length;r++)t.push(a.baToJSON(e[r]));return t}},a.defineProperties=function(e,t,c){if(e.raw=[],e._fields=[],e.toJSON=function(t){if(t){var r={};return e._fields.forEach(function(a){r[a]="0x"+e[a].toString("hex")}),r}return a.baToJSON(this.raw)},e.serialize=function(){return f.encode(e.raw)},t.forEach(function(t,r){function c(){return e.raw[r]}function n(c){"00"!==(c=a.toBuffer(c)).toString("hex")||t.allowZero||(c=s.allocUnsafe(0)),t.allowLess&&t.length?(c=a.stripZeros(c),i(t.length>=c.length,"The field "+t.name+" must not have more "+t.length+" bytes")):t.allowZero&&0===c.length||!t.length||i(t.length===c.length,"The field "+t.name+" must have byte length of "+t.length),e.raw[r]=c}e._fields.push(t.name),Object.defineProperty(e,t.name,{enumerable:!0,configurable:!0,get:c,set:n}),t.default&&(e[t.name]=t.default),t.alias&&Object.defineProperty(e,t.alias,{enumerable:!1,configurable:!0,set:n,get:c})}),c)if("string"==typeof c&&(c=s.from(a.stripHexPrefix(c),"hex")),s.isBuffer(c)&&(c=f.decode(c)),Array.isArray(c)){if(c.length>e._fields.length)throw new Error("wrong number of fields in data");c.forEach(function(t,r){e[e._fields[r]]=a.toBuffer(t)})}else{if("object"!==(void 0===c?"undefined":r(c)))throw new Error("invalid data");var n=Object.keys(c);t.forEach(function(a){-1!==n.indexOf(a.name)&&(e[a.name]=c[a.name]),-1!==n.indexOf(a.alias)&&(e[a.alias]=c[a.alias])})}}},function(e,a){e.exports=function(e){return null==e?"":e.toString()}},function(e,a){e.exports=__webpack_require__(18)},function(e,a){e.exports=__webpack_require__(22)},function(e,a,t){var r=t(24),c=r.Buffer;function n(e,a){for(var t in e)a[t]=e[t]}function i(e,a,t){return c(e,a,t)}c.from&&c.alloc&&c.allocUnsafe&&c.allocUnsafeSlow?e.exports=r:(n(r,a),a.Buffer=i),n(c,i),i.from=function(e,a,t){if("number"==typeof e)throw new TypeError("Argument must not be a number");return c(e,a,t)},i.alloc=function(e,a,t){if("number"!=typeof e)throw new TypeError("Argument must be a number");var r=c(e);return void 0!==a?"string"==typeof t?r.fill(a,t):r.fill(a):r.fill(0),r},i.allocUnsafe=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return c(e)},i.allocUnsafeSlow=function(e){if("number"!=typeof e)throw new TypeError("Argument must be a number");return r.SlowBuffer(e)}},function(e,a,t){var r=t(15),c=t(735),n=t(734),i=[],f=t(1);var o=function(){};function d(e){c(e),e.gracefulify=d,e.FileReadStream=p,e.FileWriteStream=h,e.createReadStream=function(e,a){return new p(e,a)},e.createWriteStream=function(e,a){return new h(e,a)};var a=e.readFile;e.readFile=function(e,t,r){"function"==typeof t&&(r=t,t=null);return function e(t,r,c){return a(t,r,function(a){!a||"EMFILE"!==a.code&&"ENFILE"!==a.code?("function"==typeof c&&c.apply(this,arguments),b()):s([e,[t,r,c]])})}(e,t,r)};var t=e.writeFile;e.writeFile=function(e,a,r,c){"function"==typeof r&&(c=r,r=null);return function e(a,r,c,n){return t(a,r,c,function(t){!t||"EMFILE"!==t.code&&"ENFILE"!==t.code?("function"==typeof n&&n.apply(this,arguments),b()):s([e,[a,r,c,n]])})}(e,a,r,c)};var r=e.appendFile;r&&(e.appendFile=function(e,a,t,c){"function"==typeof t&&(c=t,t=null);return function e(a,t,c,n){return r(a,t,c,function(r){!r||"EMFILE"!==r.code&&"ENFILE"!==r.code?("function"==typeof n&&n.apply(this,arguments),b()):s([e,[a,t,c,n]])})}(e,a,t,c)});var i=e.readdir;function f(a){return i.apply(e,a)}if(e.readdir=function(e,a,t){var r=[e];"function"!=typeof a?r.push(a):t=a;return r.push(function(e,a){a&&a.sort&&a.sort(),!e||"EMFILE"!==e.code&&"ENFILE"!==e.code?("function"==typeof t&&t.apply(this,arguments),b()):s([f,[r]])}),f(r)},"v0.8"===process.version.substr(0,4)){var o=n(e);p=o.ReadStream,h=o.WriteStream}var u=e.ReadStream;p.prototype=Object.create(u.prototype),p.prototype.open=function(){var e=this;g(e.path,e.flags,e.mode,function(a,t){a?(e.autoClose&&e.destroy(),e.emit("error",a)):(e.fd=t,e.emit("open",t),e.read())})};var l=e.WriteStream;function p(e,a){return this instanceof p?(u.apply(this,arguments),this):p.apply(Object.create(p.prototype),arguments)}function h(e,a){return this instanceof h?(l.apply(this,arguments),this):h.apply(Object.create(h.prototype),arguments)}h.prototype=Object.create(l.prototype),h.prototype.open=function(){var e=this;g(e.path,e.flags,e.mode,function(a,t){a?(e.destroy(),e.emit("error",a)):(e.fd=t,e.emit("open",t))})},e.ReadStream=p,e.WriteStream=h;var m=e.open;function g(e,a,t,r){return"function"==typeof t&&(r=t,t=null),function e(a,t,r,c){return m(a,t,r,function(n,i){!n||"EMFILE"!==n.code&&"ENFILE"!==n.code?("function"==typeof c&&c.apply(this,arguments),b()):s([e,[a,t,r,c]])})}(e,a,t,r)}return e.open=g,e}function s(e){o("ENQUEUE",e[0].name,e[1]),i.push(e)}function b(){var e=i.shift();e&&(o("RETRY",e[0].name,e[1]),e[0].apply(null,e[1]))}f.debuglog?o=f.debuglog("gfs4"):/\bgfs4\b/i.test(process.env.NODE_DEBUG||"")&&(o=function(){var e=f.format.apply(f,arguments);e="GFS4: "+e.split(/\n/).join("\nGFS4: "),console.error(e)}),/\bgfs4\b/i.test(process.env.NODE_DEBUG||"")&&process.on("exit",function(){o(i),t(11).equal(i.length,0)}),e.exports=d(t(291)),process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH&&(e.exports=d(r)),e.exports.close=r.close=function(e){return function(a,t){return e.call(r,a,function(e){e||b(),"function"==typeof t&&t.apply(this,arguments)})}}(r.close),e.exports.closeSync=r.closeSync=function(e){return function(a){var t=e.apply(r,arguments);return b(),t}}(r.closeSync)},function(e,a,t){(function(e){!function(e,a){"use strict";function r(e,a){if(!e)throw new Error(a||"Assertion failed")}function c(e,a){e.super_=a;var t=function(){};t.prototype=a.prototype,e.prototype=new t,e.prototype.constructor=e}function n(e,a,t){if(n.isBN(e))return e;this.negative=0,this.words=null,this.length=0,this.red=null,null!==e&&("le"!==a&&"be"!==a||(t=a,a=10),this._init(e||0,a||10,t||"be"))}var i;"object"==typeof e?e.exports=n:a.BN=n,n.BN=n,n.wordSize=26;try{i=t(24).Buffer}catch(e){}function f(e,a,t){for(var r=0,c=Math.min(e.length,t),n=a;n<c;n++){var i=e.charCodeAt(n)-48;r<<=4,r|=i>=49&&i<=54?i-49+10:i>=17&&i<=22?i-17+10:15&i}return r}function o(e,a,t,r){for(var c=0,n=Math.min(e.length,t),i=a;i<n;i++){var f=e.charCodeAt(i)-48;c*=r,c+=f>=49?f-49+10:f>=17?f-17+10:f}return c}n.isBN=function(e){return e instanceof n||null!==e&&"object"==typeof e&&e.constructor.wordSize===n.wordSize&&Array.isArray(e.words)},n.max=function(e,a){return e.cmp(a)>0?e:a},n.min=function(e,a){return e.cmp(a)<0?e:a},n.prototype._init=function(e,a,t){if("number"==typeof e)return this._initNumber(e,a,t);if("object"==typeof e)return this._initArray(e,a,t);"hex"===a&&(a=16),r(a===(0|a)&&a>=2&&a<=36);var c=0;"-"===(e=e.toString().replace(/\s+/g,""))[0]&&c++,16===a?this._parseHex(e,c):this._parseBase(e,a,c),"-"===e[0]&&(this.negative=1),this.strip(),"le"===t&&this._initArray(this.toArray(),a,t)},n.prototype._initNumber=function(e,a,t){e<0&&(this.negative=1,e=-e),e<67108864?(this.words=[67108863&e],this.length=1):e<4503599627370496?(this.words=[67108863&e,e/67108864&67108863],this.length=2):(r(e<9007199254740992),this.words=[67108863&e,e/67108864&67108863,1],this.length=3),"le"===t&&this._initArray(this.toArray(),a,t)},n.prototype._initArray=function(e,a,t){if(r("number"==typeof e.length),e.length<=0)return this.words=[0],this.length=1,this;this.length=Math.ceil(e.length/3),this.words=new Array(this.length);for(var c=0;c<this.length;c++)this.words[c]=0;var n,i,f=0;if("be"===t)for(c=e.length-1,n=0;c>=0;c-=3)i=e[c]|e[c-1]<<8|e[c-2]<<16,this.words[n]|=i<<f&67108863,this.words[n+1]=i>>>26-f&67108863,(f+=24)>=26&&(f-=26,n++);else if("le"===t)for(c=0,n=0;c<e.length;c+=3)i=e[c]|e[c+1]<<8|e[c+2]<<16,this.words[n]|=i<<f&67108863,this.words[n+1]=i>>>26-f&67108863,(f+=24)>=26&&(f-=26,n++);return this.strip()},n.prototype._parseHex=function(e,a){this.length=Math.ceil((e.length-a)/6),this.words=new Array(this.length);for(var t=0;t<this.length;t++)this.words[t]=0;var r,c,n=0;for(t=e.length-6,r=0;t>=a;t-=6)c=f(e,t,t+6),this.words[r]|=c<<n&67108863,this.words[r+1]|=c>>>26-n&4194303,(n+=24)>=26&&(n-=26,r++);t+6!==a&&(c=f(e,a,t+6),this.words[r]|=c<<n&67108863,this.words[r+1]|=c>>>26-n&4194303),this.strip()},n.prototype._parseBase=function(e,a,t){this.words=[0],this.length=1;for(var r=0,c=1;c<=67108863;c*=a)r++;r--,c=c/a|0;for(var n=e.length-t,i=n%r,f=Math.min(n,n-i)+t,d=0,s=t;s<f;s+=r)d=o(e,s,s+r,a),this.imuln(c),this.words[0]+d<67108864?this.words[0]+=d:this._iaddn(d);if(0!==i){var b=1;for(d=o(e,s,e.length,a),s=0;s<i;s++)b*=a;this.imuln(b),this.words[0]+d<67108864?this.words[0]+=d:this._iaddn(d)}},n.prototype.copy=function(e){e.words=new Array(this.length);for(var a=0;a<this.length;a++)e.words[a]=this.words[a];e.length=this.length,e.negative=this.negative,e.red=this.red},n.prototype.clone=function(){var e=new n(null);return this.copy(e),e},n.prototype._expand=function(e){for(;this.length<e;)this.words[this.length++]=0;return this},n.prototype.strip=function(){for(;this.length>1&&0===this.words[this.length-1];)this.length--;return this._normSign()},n.prototype._normSign=function(){return 1===this.length&&0===this.words[0]&&(this.negative=0),this},n.prototype.inspect=function(){return(this.red?"<BN-R: ":"<BN: ")+this.toString(16)+">"};var d=["","0","00","000","0000","00000","000000","0000000","00000000","000000000","0000000000","00000000000","000000000000","0000000000000","00000000000000","000000000000000","0000000000000000","00000000000000000","000000000000000000","0000000000000000000","00000000000000000000","000000000000000000000","0000000000000000000000","00000000000000000000000","000000000000000000000000","0000000000000000000000000"],s=[0,0,25,16,12,11,10,9,8,8,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5],b=[0,0,33554432,43046721,16777216,48828125,60466176,40353607,16777216,43046721,1e7,19487171,35831808,62748517,7529536,11390625,16777216,24137569,34012224,47045881,64e6,4084101,5153632,6436343,7962624,9765625,11881376,14348907,17210368,20511149,243e5,28629151,33554432,39135393,45435424,52521875,60466176];function u(e,a,t){t.negative=a.negative^e.negative;var r=e.length+a.length|0;t.length=r,r=r-1|0;var c=0|e.words[0],n=0|a.words[0],i=c*n,f=67108863&i,o=i/67108864|0;t.words[0]=f;for(var d=1;d<r;d++){for(var s=o>>>26,b=67108863&o,u=Math.min(d,a.length-1),l=Math.max(0,d-e.length+1);l<=u;l++){var p=d-l|0;s+=(i=(c=0|e.words[p])*(n=0|a.words[l])+b)/67108864|0,b=67108863&i}t.words[d]=0|b,o=0|s}return 0!==o?t.words[d]=0|o:t.length--,t.strip()}n.prototype.toString=function(e,a){var t;if(e=e||10,a=0|a||1,16===e||"hex"===e){t="";for(var c=0,n=0,i=0;i<this.length;i++){var f=this.words[i],o=(16777215&(f<<c|n)).toString(16);t=0!==(n=f>>>24-c&16777215)||i!==this.length-1?d[6-o.length]+o+t:o+t,(c+=2)>=26&&(c-=26,i--)}for(0!==n&&(t=n.toString(16)+t);t.length%a!=0;)t="0"+t;return 0!==this.negative&&(t="-"+t),t}if(e===(0|e)&&e>=2&&e<=36){var u=s[e],l=b[e];t="";var p=this.clone();for(p.negative=0;!p.isZero();){var h=p.modn(l).toString(e);t=(p=p.idivn(l)).isZero()?h+t:d[u-h.length]+h+t}for(this.isZero()&&(t="0"+t);t.length%a!=0;)t="0"+t;return 0!==this.negative&&(t="-"+t),t}r(!1,"Base should be between 2 and 36")},n.prototype.toNumber=function(){var e=this.words[0];return 2===this.length?e+=67108864*this.words[1]:3===this.length&&1===this.words[2]?e+=4503599627370496+67108864*this.words[1]:this.length>2&&r(!1,"Number can only safely store up to 53 bits"),0!==this.negative?-e:e},n.prototype.toJSON=function(){return this.toString(16)},n.prototype.toBuffer=function(e,a){return r(void 0!==i),this.toArrayLike(i,e,a)},n.prototype.toArray=function(e,a){return this.toArrayLike(Array,e,a)},n.prototype.toArrayLike=function(e,a,t){var c=this.byteLength(),n=t||Math.max(1,c);r(c<=n,"byte array longer than desired length"),r(n>0,"Requested array length <= 0"),this.strip();var i,f,o="le"===a,d=new e(n),s=this.clone();if(o){for(f=0;!s.isZero();f++)i=s.andln(255),s.iushrn(8),d[f]=i;for(;f<n;f++)d[f]=0}else{for(f=0;f<n-c;f++)d[f]=0;for(f=0;!s.isZero();f++)i=s.andln(255),s.iushrn(8),d[n-f-1]=i}return d},Math.clz32?n.prototype._countBits=function(e){return 32-Math.clz32(e)}:n.prototype._countBits=function(e){var a=e,t=0;return a>=4096&&(t+=13,a>>>=13),a>=64&&(t+=7,a>>>=7),a>=8&&(t+=4,a>>>=4),a>=2&&(t+=2,a>>>=2),t+a},n.prototype._zeroBits=function(e){if(0===e)return 26;var a=e,t=0;return 0==(8191&a)&&(t+=13,a>>>=13),0==(127&a)&&(t+=7,a>>>=7),0==(15&a)&&(t+=4,a>>>=4),0==(3&a)&&(t+=2,a>>>=2),0==(1&a)&&t++,t},n.prototype.bitLength=function(){var e=this.words[this.length-1],a=this._countBits(e);return 26*(this.length-1)+a},n.prototype.zeroBits=function(){if(this.isZero())return 0;for(var e=0,a=0;a<this.length;a++){var t=this._zeroBits(this.words[a]);if(e+=t,26!==t)break}return e},n.prototype.byteLength=function(){return Math.ceil(this.bitLength()/8)},n.prototype.toTwos=function(e){return 0!==this.negative?this.abs().inotn(e).iaddn(1):this.clone()},n.prototype.fromTwos=function(e){return this.testn(e-1)?this.notn(e).iaddn(1).ineg():this.clone()},n.prototype.isNeg=function(){return 0!==this.negative},n.prototype.neg=function(){return this.clone().ineg()},n.prototype.ineg=function(){return this.isZero()||(this.negative^=1),this},n.prototype.iuor=function(e){for(;this.length<e.length;)this.words[this.length++]=0;for(var a=0;a<e.length;a++)this.words[a]=this.words[a]|e.words[a];return this.strip()},n.prototype.ior=function(e){return r(0==(this.negative|e.negative)),this.iuor(e)},n.prototype.or=function(e){return this.length>e.length?this.clone().ior(e):e.clone().ior(this)},n.prototype.uor=function(e){return this.length>e.length?this.clone().iuor(e):e.clone().iuor(this)},n.prototype.iuand=function(e){var a;a=this.length>e.length?e:this;for(var t=0;t<a.length;t++)this.words[t]=this.words[t]&e.words[t];return this.length=a.length,this.strip()},n.prototype.iand=function(e){return r(0==(this.negative|e.negative)),this.iuand(e)},n.prototype.and=function(e){return this.length>e.length?this.clone().iand(e):e.clone().iand(this)},n.prototype.uand=function(e){return this.length>e.length?this.clone().iuand(e):e.clone().iuand(this)},n.prototype.iuxor=function(e){var a,t;this.length>e.length?(a=this,t=e):(a=e,t=this);for(var r=0;r<t.length;r++)this.words[r]=a.words[r]^t.words[r];if(this!==a)for(;r<a.length;r++)this.words[r]=a.words[r];return this.length=a.length,this.strip()},n.prototype.ixor=function(e){return r(0==(this.negative|e.negative)),this.iuxor(e)},n.prototype.xor=function(e){return this.length>e.length?this.clone().ixor(e):e.clone().ixor(this)},n.prototype.uxor=function(e){return this.length>e.length?this.clone().iuxor(e):e.clone().iuxor(this)},n.prototype.inotn=function(e){r("number"==typeof e&&e>=0);var a=0|Math.ceil(e/26),t=e%26;this._expand(a),t>0&&a--;for(var c=0;c<a;c++)this.words[c]=67108863&~this.words[c];return t>0&&(this.words[c]=~this.words[c]&67108863>>26-t),this.strip()},n.prototype.notn=function(e){return this.clone().inotn(e)},n.prototype.setn=function(e,a){r("number"==typeof e&&e>=0);var t=e/26|0,c=e%26;return this._expand(t+1),this.words[t]=a?this.words[t]|1<<c:this.words[t]&~(1<<c),this.strip()},n.prototype.iadd=function(e){var a,t,r;if(0!==this.negative&&0===e.negative)return this.negative=0,a=this.isub(e),this.negative^=1,this._normSign();if(0===this.negative&&0!==e.negative)return e.negative=0,a=this.isub(e),e.negative=1,a._normSign();this.length>e.length?(t=this,r=e):(t=e,r=this);for(var c=0,n=0;n<r.length;n++)a=(0|t.words[n])+(0|r.words[n])+c,this.words[n]=67108863&a,c=a>>>26;for(;0!==c&&n<t.length;n++)a=(0|t.words[n])+c,this.words[n]=67108863&a,c=a>>>26;if(this.length=t.length,0!==c)this.words[this.length]=c,this.length++;else if(t!==this)for(;n<t.length;n++)this.words[n]=t.words[n];return this},n.prototype.add=function(e){var a;return 0!==e.negative&&0===this.negative?(e.negative=0,a=this.sub(e),e.negative^=1,a):0===e.negative&&0!==this.negative?(this.negative=0,a=e.sub(this),this.negative=1,a):this.length>e.length?this.clone().iadd(e):e.clone().iadd(this)},n.prototype.isub=function(e){if(0!==e.negative){e.negative=0;var a=this.iadd(e);return e.negative=1,a._normSign()}if(0!==this.negative)return this.negative=0,this.iadd(e),this.negative=1,this._normSign();var t,r,c=this.cmp(e);if(0===c)return this.negative=0,this.length=1,this.words[0]=0,this;c>0?(t=this,r=e):(t=e,r=this);for(var n=0,i=0;i<r.length;i++)n=(a=(0|t.words[i])-(0|r.words[i])+n)>>26,this.words[i]=67108863&a;for(;0!==n&&i<t.length;i++)n=(a=(0|t.words[i])+n)>>26,this.words[i]=67108863&a;if(0===n&&i<t.length&&t!==this)for(;i<t.length;i++)this.words[i]=t.words[i];return this.length=Math.max(this.length,i),t!==this&&(this.negative=1),this.strip()},n.prototype.sub=function(e){return this.clone().isub(e)};var l=function(e,a,t){var r,c,n,i=e.words,f=a.words,o=t.words,d=0,s=0|i[0],b=8191&s,u=s>>>13,l=0|i[1],p=8191&l,h=l>>>13,m=0|i[2],g=8191&m,v=m>>>13,y=0|i[3],_=8191&y,w=y>>>13,A=0|i[4],k=8191&A,x=A>>>13,E=0|i[5],S=8191&E,T=E>>>13,j=0|i[6],C=8191&j,R=j>>>13,O=0|i[7],B=8191&O,M=O>>>13,N=0|i[8],I=8191&N,P=N>>>13,F=0|i[9],L=8191&F,D=F>>>13,z=0|f[0],q=8191&z,U=z>>>13,H=0|f[1],V=8191&H,G=H>>>13,W=0|f[2],Y=8191&W,K=W>>>13,Q=0|f[3],Z=8191&Q,J=Q>>>13,X=0|f[4],$=8191&X,ee=X>>>13,ae=0|f[5],te=8191&ae,re=ae>>>13,ce=0|f[6],ne=8191&ce,ie=ce>>>13,fe=0|f[7],oe=8191&fe,de=fe>>>13,se=0|f[8],be=8191&se,ue=se>>>13,le=0|f[9],pe=8191&le,he=le>>>13;t.negative=e.negative^a.negative,t.length=19;var me=(d+(r=Math.imul(b,q))|0)+((8191&(c=(c=Math.imul(b,U))+Math.imul(u,q)|0))<<13)|0;d=((n=Math.imul(u,U))+(c>>>13)|0)+(me>>>26)|0,me&=67108863,r=Math.imul(p,q),c=(c=Math.imul(p,U))+Math.imul(h,q)|0,n=Math.imul(h,U);var ge=(d+(r=r+Math.imul(b,V)|0)|0)+((8191&(c=(c=c+Math.imul(b,G)|0)+Math.imul(u,V)|0))<<13)|0;d=((n=n+Math.imul(u,G)|0)+(c>>>13)|0)+(ge>>>26)|0,ge&=67108863,r=Math.imul(g,q),c=(c=Math.imul(g,U))+Math.imul(v,q)|0,n=Math.imul(v,U),r=r+Math.imul(p,V)|0,c=(c=c+Math.imul(p,G)|0)+Math.imul(h,V)|0,n=n+Math.imul(h,G)|0;var ve=(d+(r=r+Math.imul(b,Y)|0)|0)+((8191&(c=(c=c+Math.imul(b,K)|0)+Math.imul(u,Y)|0))<<13)|0;d=((n=n+Math.imul(u,K)|0)+(c>>>13)|0)+(ve>>>26)|0,ve&=67108863,r=Math.imul(_,q),c=(c=Math.imul(_,U))+Math.imul(w,q)|0,n=Math.imul(w,U),r=r+Math.imul(g,V)|0,c=(c=c+Math.imul(g,G)|0)+Math.imul(v,V)|0,n=n+Math.imul(v,G)|0,r=r+Math.imul(p,Y)|0,c=(c=c+Math.imul(p,K)|0)+Math.imul(h,Y)|0,n=n+Math.imul(h,K)|0;var ye=(d+(r=r+Math.imul(b,Z)|0)|0)+((8191&(c=(c=c+Math.imul(b,J)|0)+Math.imul(u,Z)|0))<<13)|0;d=((n=n+Math.imul(u,J)|0)+(c>>>13)|0)+(ye>>>26)|0,ye&=67108863,r=Math.imul(k,q),c=(c=Math.imul(k,U))+Math.imul(x,q)|0,n=Math.imul(x,U),r=r+Math.imul(_,V)|0,c=(c=c+Math.imul(_,G)|0)+Math.imul(w,V)|0,n=n+Math.imul(w,G)|0,r=r+Math.imul(g,Y)|0,c=(c=c+Math.imul(g,K)|0)+Math.imul(v,Y)|0,n=n+Math.imul(v,K)|0,r=r+Math.imul(p,Z)|0,c=(c=c+Math.imul(p,J)|0)+Math.imul(h,Z)|0,n=n+Math.imul(h,J)|0;var _e=(d+(r=r+Math.imul(b,$)|0)|0)+((8191&(c=(c=c+Math.imul(b,ee)|0)+Math.imul(u,$)|0))<<13)|0;d=((n=n+Math.imul(u,ee)|0)+(c>>>13)|0)+(_e>>>26)|0,_e&=67108863,r=Math.imul(S,q),c=(c=Math.imul(S,U))+Math.imul(T,q)|0,n=Math.imul(T,U),r=r+Math.imul(k,V)|0,c=(c=c+Math.imul(k,G)|0)+Math.imul(x,V)|0,n=n+Math.imul(x,G)|0,r=r+Math.imul(_,Y)|0,c=(c=c+Math.imul(_,K)|0)+Math.imul(w,Y)|0,n=n+Math.imul(w,K)|0,r=r+Math.imul(g,Z)|0,c=(c=c+Math.imul(g,J)|0)+Math.imul(v,Z)|0,n=n+Math.imul(v,J)|0,r=r+Math.imul(p,$)|0,c=(c=c+Math.imul(p,ee)|0)+Math.imul(h,$)|0,n=n+Math.imul(h,ee)|0;var we=(d+(r=r+Math.imul(b,te)|0)|0)+((8191&(c=(c=c+Math.imul(b,re)|0)+Math.imul(u,te)|0))<<13)|0;d=((n=n+Math.imul(u,re)|0)+(c>>>13)|0)+(we>>>26)|0,we&=67108863,r=Math.imul(C,q),c=(c=Math.imul(C,U))+Math.imul(R,q)|0,n=Math.imul(R,U),r=r+Math.imul(S,V)|0,c=(c=c+Math.imul(S,G)|0)+Math.imul(T,V)|0,n=n+Math.imul(T,G)|0,r=r+Math.imul(k,Y)|0,c=(c=c+Math.imul(k,K)|0)+Math.imul(x,Y)|0,n=n+Math.imul(x,K)|0,r=r+Math.imul(_,Z)|0,c=(c=c+Math.imul(_,J)|0)+Math.imul(w,Z)|0,n=n+Math.imul(w,J)|0,r=r+Math.imul(g,$)|0,c=(c=c+Math.imul(g,ee)|0)+Math.imul(v,$)|0,n=n+Math.imul(v,ee)|0,r=r+Math.imul(p,te)|0,c=(c=c+Math.imul(p,re)|0)+Math.imul(h,te)|0,n=n+Math.imul(h,re)|0;var Ae=(d+(r=r+Math.imul(b,ne)|0)|0)+((8191&(c=(c=c+Math.imul(b,ie)|0)+Math.imul(u,ne)|0))<<13)|0;d=((n=n+Math.imul(u,ie)|0)+(c>>>13)|0)+(Ae>>>26)|0,Ae&=67108863,r=Math.imul(B,q),c=(c=Math.imul(B,U))+Math.imul(M,q)|0,n=Math.imul(M,U),r=r+Math.imul(C,V)|0,c=(c=c+Math.imul(C,G)|0)+Math.imul(R,V)|0,n=n+Math.imul(R,G)|0,r=r+Math.imul(S,Y)|0,c=(c=c+Math.imul(S,K)|0)+Math.imul(T,Y)|0,n=n+Math.imul(T,K)|0,r=r+Math.imul(k,Z)|0,c=(c=c+Math.imul(k,J)|0)+Math.imul(x,Z)|0,n=n+Math.imul(x,J)|0,r=r+Math.imul(_,$)|0,c=(c=c+Math.imul(_,ee)|0)+Math.imul(w,$)|0,n=n+Math.imul(w,ee)|0,r=r+Math.imul(g,te)|0,c=(c=c+Math.imul(g,re)|0)+Math.imul(v,te)|0,n=n+Math.imul(v,re)|0,r=r+Math.imul(p,ne)|0,c=(c=c+Math.imul(p,ie)|0)+Math.imul(h,ne)|0,n=n+Math.imul(h,ie)|0;var ke=(d+(r=r+Math.imul(b,oe)|0)|0)+((8191&(c=(c=c+Math.imul(b,de)|0)+Math.imul(u,oe)|0))<<13)|0;d=((n=n+Math.imul(u,de)|0)+(c>>>13)|0)+(ke>>>26)|0,ke&=67108863,r=Math.imul(I,q),c=(c=Math.imul(I,U))+Math.imul(P,q)|0,n=Math.imul(P,U),r=r+Math.imul(B,V)|0,c=(c=c+Math.imul(B,G)|0)+Math.imul(M,V)|0,n=n+Math.imul(M,G)|0,r=r+Math.imul(C,Y)|0,c=(c=c+Math.imul(C,K)|0)+Math.imul(R,Y)|0,n=n+Math.imul(R,K)|0,r=r+Math.imul(S,Z)|0,c=(c=c+Math.imul(S,J)|0)+Math.imul(T,Z)|0,n=n+Math.imul(T,J)|0,r=r+Math.imul(k,$)|0,c=(c=c+Math.imul(k,ee)|0)+Math.imul(x,$)|0,n=n+Math.imul(x,ee)|0,r=r+Math.imul(_,te)|0,c=(c=c+Math.imul(_,re)|0)+Math.imul(w,te)|0,n=n+Math.imul(w,re)|0,r=r+Math.imul(g,ne)|0,c=(c=c+Math.imul(g,ie)|0)+Math.imul(v,ne)|0,n=n+Math.imul(v,ie)|0,r=r+Math.imul(p,oe)|0,c=(c=c+Math.imul(p,de)|0)+Math.imul(h,oe)|0,n=n+Math.imul(h,de)|0;var xe=(d+(r=r+Math.imul(b,be)|0)|0)+((8191&(c=(c=c+Math.imul(b,ue)|0)+Math.imul(u,be)|0))<<13)|0;d=((n=n+Math.imul(u,ue)|0)+(c>>>13)|0)+(xe>>>26)|0,xe&=67108863,r=Math.imul(L,q),c=(c=Math.imul(L,U))+Math.imul(D,q)|0,n=Math.imul(D,U),r=r+Math.imul(I,V)|0,c=(c=c+Math.imul(I,G)|0)+Math.imul(P,V)|0,n=n+Math.imul(P,G)|0,r=r+Math.imul(B,Y)|0,c=(c=c+Math.imul(B,K)|0)+Math.imul(M,Y)|0,n=n+Math.imul(M,K)|0,r=r+Math.imul(C,Z)|0,c=(c=c+Math.imul(C,J)|0)+Math.imul(R,Z)|0,n=n+Math.imul(R,J)|0,r=r+Math.imul(S,$)|0,c=(c=c+Math.imul(S,ee)|0)+Math.imul(T,$)|0,n=n+Math.imul(T,ee)|0,r=r+Math.imul(k,te)|0,c=(c=c+Math.imul(k,re)|0)+Math.imul(x,te)|0,n=n+Math.imul(x,re)|0,r=r+Math.imul(_,ne)|0,c=(c=c+Math.imul(_,ie)|0)+Math.imul(w,ne)|0,n=n+Math.imul(w,ie)|0,r=r+Math.imul(g,oe)|0,c=(c=c+Math.imul(g,de)|0)+Math.imul(v,oe)|0,n=n+Math.imul(v,de)|0,r=r+Math.imul(p,be)|0,c=(c=c+Math.imul(p,ue)|0)+Math.imul(h,be)|0,n=n+Math.imul(h,ue)|0;var Ee=(d+(r=r+Math.imul(b,pe)|0)|0)+((8191&(c=(c=c+Math.imul(b,he)|0)+Math.imul(u,pe)|0))<<13)|0;d=((n=n+Math.imul(u,he)|0)+(c>>>13)|0)+(Ee>>>26)|0,Ee&=67108863,r=Math.imul(L,V),c=(c=Math.imul(L,G))+Math.imul(D,V)|0,n=Math.imul(D,G),r=r+Math.imul(I,Y)|0,c=(c=c+Math.imul(I,K)|0)+Math.imul(P,Y)|0,n=n+Math.imul(P,K)|0,r=r+Math.imul(B,Z)|0,c=(c=c+Math.imul(B,J)|0)+Math.imul(M,Z)|0,n=n+Math.imul(M,J)|0,r=r+Math.imul(C,$)|0,c=(c=c+Math.imul(C,ee)|0)+Math.imul(R,$)|0,n=n+Math.imul(R,ee)|0,r=r+Math.imul(S,te)|0,c=(c=c+Math.imul(S,re)|0)+Math.imul(T,te)|0,n=n+Math.imul(T,re)|0,r=r+Math.imul(k,ne)|0,c=(c=c+Math.imul(k,ie)|0)+Math.imul(x,ne)|0,n=n+Math.imul(x,ie)|0,r=r+Math.imul(_,oe)|0,c=(c=c+Math.imul(_,de)|0)+Math.imul(w,oe)|0,n=n+Math.imul(w,de)|0,r=r+Math.imul(g,be)|0,c=(c=c+Math.imul(g,ue)|0)+Math.imul(v,be)|0,n=n+Math.imul(v,ue)|0;var Se=(d+(r=r+Math.imul(p,pe)|0)|0)+((8191&(c=(c=c+Math.imul(p,he)|0)+Math.imul(h,pe)|0))<<13)|0;d=((n=n+Math.imul(h,he)|0)+(c>>>13)|0)+(Se>>>26)|0,Se&=67108863,r=Math.imul(L,Y),c=(c=Math.imul(L,K))+Math.imul(D,Y)|0,n=Math.imul(D,K),r=r+Math.imul(I,Z)|0,c=(c=c+Math.imul(I,J)|0)+Math.imul(P,Z)|0,n=n+Math.imul(P,J)|0,r=r+Math.imul(B,$)|0,c=(c=c+Math.imul(B,ee)|0)+Math.imul(M,$)|0,n=n+Math.imul(M,ee)|0,r=r+Math.imul(C,te)|0,c=(c=c+Math.imul(C,re)|0)+Math.imul(R,te)|0,n=n+Math.imul(R,re)|0,r=r+Math.imul(S,ne)|0,c=(c=c+Math.imul(S,ie)|0)+Math.imul(T,ne)|0,n=n+Math.imul(T,ie)|0,r=r+Math.imul(k,oe)|0,c=(c=c+Math.imul(k,de)|0)+Math.imul(x,oe)|0,n=n+Math.imul(x,de)|0,r=r+Math.imul(_,be)|0,c=(c=c+Math.imul(_,ue)|0)+Math.imul(w,be)|0,n=n+Math.imul(w,ue)|0;var Te=(d+(r=r+Math.imul(g,pe)|0)|0)+((8191&(c=(c=c+Math.imul(g,he)|0)+Math.imul(v,pe)|0))<<13)|0;d=((n=n+Math.imul(v,he)|0)+(c>>>13)|0)+(Te>>>26)|0,Te&=67108863,r=Math.imul(L,Z),c=(c=Math.imul(L,J))+Math.imul(D,Z)|0,n=Math.imul(D,J),r=r+Math.imul(I,$)|0,c=(c=c+Math.imul(I,ee)|0)+Math.imul(P,$)|0,n=n+Math.imul(P,ee)|0,r=r+Math.imul(B,te)|0,c=(c=c+Math.imul(B,re)|0)+Math.imul(M,te)|0,n=n+Math.imul(M,re)|0,r=r+Math.imul(C,ne)|0,c=(c=c+Math.imul(C,ie)|0)+Math.imul(R,ne)|0,n=n+Math.imul(R,ie)|0,r=r+Math.imul(S,oe)|0,c=(c=c+Math.imul(S,de)|0)+Math.imul(T,oe)|0,n=n+Math.imul(T,de)|0,r=r+Math.imul(k,be)|0,c=(c=c+Math.imul(k,ue)|0)+Math.imul(x,be)|0,n=n+Math.imul(x,ue)|0;var je=(d+(r=r+Math.imul(_,pe)|0)|0)+((8191&(c=(c=c+Math.imul(_,he)|0)+Math.imul(w,pe)|0))<<13)|0;d=((n=n+Math.imul(w,he)|0)+(c>>>13)|0)+(je>>>26)|0,je&=67108863,r=Math.imul(L,$),c=(c=Math.imul(L,ee))+Math.imul(D,$)|0,n=Math.imul(D,ee),r=r+Math.imul(I,te)|0,c=(c=c+Math.imul(I,re)|0)+Math.imul(P,te)|0,n=n+Math.imul(P,re)|0,r=r+Math.imul(B,ne)|0,c=(c=c+Math.imul(B,ie)|0)+Math.imul(M,ne)|0,n=n+Math.imul(M,ie)|0,r=r+Math.imul(C,oe)|0,c=(c=c+Math.imul(C,de)|0)+Math.imul(R,oe)|0,n=n+Math.imul(R,de)|0,r=r+Math.imul(S,be)|0,c=(c=c+Math.imul(S,ue)|0)+Math.imul(T,be)|0,n=n+Math.imul(T,ue)|0;var Ce=(d+(r=r+Math.imul(k,pe)|0)|0)+((8191&(c=(c=c+Math.imul(k,he)|0)+Math.imul(x,pe)|0))<<13)|0;d=((n=n+Math.imul(x,he)|0)+(c>>>13)|0)+(Ce>>>26)|0,Ce&=67108863,r=Math.imul(L,te),c=(c=Math.imul(L,re))+Math.imul(D,te)|0,n=Math.imul(D,re),r=r+Math.imul(I,ne)|0,c=(c=c+Math.imul(I,ie)|0)+Math.imul(P,ne)|0,n=n+Math.imul(P,ie)|0,r=r+Math.imul(B,oe)|0,c=(c=c+Math.imul(B,de)|0)+Math.imul(M,oe)|0,n=n+Math.imul(M,de)|0,r=r+Math.imul(C,be)|0,c=(c=c+Math.imul(C,ue)|0)+Math.imul(R,be)|0,n=n+Math.imul(R,ue)|0;var Re=(d+(r=r+Math.imul(S,pe)|0)|0)+((8191&(c=(c=c+Math.imul(S,he)|0)+Math.imul(T,pe)|0))<<13)|0;d=((n=n+Math.imul(T,he)|0)+(c>>>13)|0)+(Re>>>26)|0,Re&=67108863,r=Math.imul(L,ne),c=(c=Math.imul(L,ie))+Math.imul(D,ne)|0,n=Math.imul(D,ie),r=r+Math.imul(I,oe)|0,c=(c=c+Math.imul(I,de)|0)+Math.imul(P,oe)|0,n=n+Math.imul(P,de)|0,r=r+Math.imul(B,be)|0,c=(c=c+Math.imul(B,ue)|0)+Math.imul(M,be)|0,n=n+Math.imul(M,ue)|0;var Oe=(d+(r=r+Math.imul(C,pe)|0)|0)+((8191&(c=(c=c+Math.imul(C,he)|0)+Math.imul(R,pe)|0))<<13)|0;d=((n=n+Math.imul(R,he)|0)+(c>>>13)|0)+(Oe>>>26)|0,Oe&=67108863,r=Math.imul(L,oe),c=(c=Math.imul(L,de))+Math.imul(D,oe)|0,n=Math.imul(D,de),r=r+Math.imul(I,be)|0,c=(c=c+Math.imul(I,ue)|0)+Math.imul(P,be)|0,n=n+Math.imul(P,ue)|0;var Be=(d+(r=r+Math.imul(B,pe)|0)|0)+((8191&(c=(c=c+Math.imul(B,he)|0)+Math.imul(M,pe)|0))<<13)|0;d=((n=n+Math.imul(M,he)|0)+(c>>>13)|0)+(Be>>>26)|0,Be&=67108863,r=Math.imul(L,be),c=(c=Math.imul(L,ue))+Math.imul(D,be)|0,n=Math.imul(D,ue);var Me=(d+(r=r+Math.imul(I,pe)|0)|0)+((8191&(c=(c=c+Math.imul(I,he)|0)+Math.imul(P,pe)|0))<<13)|0;d=((n=n+Math.imul(P,he)|0)+(c>>>13)|0)+(Me>>>26)|0,Me&=67108863;var Ne=(d+(r=Math.imul(L,pe))|0)+((8191&(c=(c=Math.imul(L,he))+Math.imul(D,pe)|0))<<13)|0;return d=((n=Math.imul(D,he))+(c>>>13)|0)+(Ne>>>26)|0,Ne&=67108863,o[0]=me,o[1]=ge,o[2]=ve,o[3]=ye,o[4]=_e,o[5]=we,o[6]=Ae,o[7]=ke,o[8]=xe,o[9]=Ee,o[10]=Se,o[11]=Te,o[12]=je,o[13]=Ce,o[14]=Re,o[15]=Oe,o[16]=Be,o[17]=Me,o[18]=Ne,0!==d&&(o[19]=d,t.length++),t};function p(e,a,t){return(new h).mulp(e,a,t)}function h(e,a){this.x=e,this.y=a}Math.imul||(l=u),n.prototype.mulTo=function(e,a){var t=this.length+e.length;return 10===this.length&&10===e.length?l(this,e,a):t<63?u(this,e,a):t<1024?function(e,a,t){t.negative=a.negative^e.negative,t.length=e.length+a.length;for(var r=0,c=0,n=0;n<t.length-1;n++){var i=c;c=0;for(var f=67108863&r,o=Math.min(n,a.length-1),d=Math.max(0,n-e.length+1);d<=o;d++){var s=n-d,b=(0|e.words[s])*(0|a.words[d]),u=67108863&b;f=67108863&(u=u+f|0),c+=(i=(i=i+(b/67108864|0)|0)+(u>>>26)|0)>>>26,i&=67108863}t.words[n]=f,r=i,i=c}return 0!==r?t.words[n]=r:t.length--,t.strip()}(this,e,a):p(this,e,a)},h.prototype.makeRBT=function(e){for(var a=new Array(e),t=n.prototype._countBits(e)-1,r=0;r<e;r++)a[r]=this.revBin(r,t,e);return a},h.prototype.revBin=function(e,a,t){if(0===e||e===t-1)return e;for(var r=0,c=0;c<a;c++)r|=(1&e)<<a-c-1,e>>=1;return r},h.prototype.permute=function(e,a,t,r,c,n){for(var i=0;i<n;i++)r[i]=a[e[i]],c[i]=t[e[i]]},h.prototype.transform=function(e,a,t,r,c,n){this.permute(n,e,a,t,r,c);for(var i=1;i<c;i<<=1)for(var f=i<<1,o=Math.cos(2*Math.PI/f),d=Math.sin(2*Math.PI/f),s=0;s<c;s+=f)for(var b=o,u=d,l=0;l<i;l++){var p=t[s+l],h=r[s+l],m=t[s+l+i],g=r[s+l+i],v=b*m-u*g;g=b*g+u*m,m=v,t[s+l]=p+m,r[s+l]=h+g,t[s+l+i]=p-m,r[s+l+i]=h-g,l!==f&&(v=o*b-d*u,u=o*u+d*b,b=v)}},h.prototype.guessLen13b=function(e,a){var t=1|Math.max(a,e),r=1&t,c=0;for(t=t/2|0;t;t>>>=1)c++;return 1<<c+1+r},h.prototype.conjugate=function(e,a,t){if(!(t<=1))for(var r=0;r<t/2;r++){var c=e[r];e[r]=e[t-r-1],e[t-r-1]=c,c=a[r],a[r]=-a[t-r-1],a[t-r-1]=-c}},h.prototype.normalize13b=function(e,a){for(var t=0,r=0;r<a/2;r++){var c=8192*Math.round(e[2*r+1]/a)+Math.round(e[2*r]/a)+t;e[r]=67108863&c,t=c<67108864?0:c/67108864|0}return e},h.prototype.convert13b=function(e,a,t,c){for(var n=0,i=0;i<a;i++)n+=0|e[i],t[2*i]=8191&n,n>>>=13,t[2*i+1]=8191&n,n>>>=13;for(i=2*a;i<c;++i)t[i]=0;r(0===n),r(0==(-8192&n))},h.prototype.stub=function(e){for(var a=new Array(e),t=0;t<e;t++)a[t]=0;return a},h.prototype.mulp=function(e,a,t){var r=2*this.guessLen13b(e.length,a.length),c=this.makeRBT(r),n=this.stub(r),i=new Array(r),f=new Array(r),o=new Array(r),d=new Array(r),s=new Array(r),b=new Array(r),u=t.words;u.length=r,this.convert13b(e.words,e.length,i,r),this.convert13b(a.words,a.length,d,r),this.transform(i,n,f,o,r,c),this.transform(d,n,s,b,r,c);for(var l=0;l<r;l++){var p=f[l]*s[l]-o[l]*b[l];o[l]=f[l]*b[l]+o[l]*s[l],f[l]=p}return this.conjugate(f,o,r),this.transform(f,o,u,n,r,c),this.conjugate(u,n,r),this.normalize13b(u,r),t.negative=e.negative^a.negative,t.length=e.length+a.length,t.strip()},n.prototype.mul=function(e){var a=new n(null);return a.words=new Array(this.length+e.length),this.mulTo(e,a)},n.prototype.mulf=function(e){var a=new n(null);return a.words=new Array(this.length+e.length),p(this,e,a)},n.prototype.imul=function(e){return this.clone().mulTo(e,this)},n.prototype.imuln=function(e){r("number"==typeof e),r(e<67108864);for(var a=0,t=0;t<this.length;t++){var c=(0|this.words[t])*e,n=(67108863&c)+(67108863&a);a>>=26,a+=c/67108864|0,a+=n>>>26,this.words[t]=67108863&n}return 0!==a&&(this.words[t]=a,this.length++),this},n.prototype.muln=function(e){return this.clone().imuln(e)},n.prototype.sqr=function(){return this.mul(this)},n.prototype.isqr=function(){return this.imul(this.clone())},n.prototype.pow=function(e){var a=function(e){for(var a=new Array(e.bitLength()),t=0;t<a.length;t++){var r=t/26|0,c=t%26;a[t]=(e.words[r]&1<<c)>>>c}return a}(e);if(0===a.length)return new n(1);for(var t=this,r=0;r<a.length&&0===a[r];r++,t=t.sqr());if(++r<a.length)for(var c=t.sqr();r<a.length;r++,c=c.sqr())0!==a[r]&&(t=t.mul(c));return t},n.prototype.iushln=function(e){r("number"==typeof e&&e>=0);var a,t=e%26,c=(e-t)/26,n=67108863>>>26-t<<26-t;if(0!==t){var i=0;for(a=0;a<this.length;a++){var f=this.words[a]&n,o=(0|this.words[a])-f<<t;this.words[a]=o|i,i=f>>>26-t}i&&(this.words[a]=i,this.length++)}if(0!==c){for(a=this.length-1;a>=0;a--)this.words[a+c]=this.words[a];for(a=0;a<c;a++)this.words[a]=0;this.length+=c}return this.strip()},n.prototype.ishln=function(e){return r(0===this.negative),this.iushln(e)},n.prototype.iushrn=function(e,a,t){var c;r("number"==typeof e&&e>=0),c=a?(a-a%26)/26:0;var n=e%26,i=Math.min((e-n)/26,this.length),f=67108863^67108863>>>n<<n,o=t;if(c-=i,c=Math.max(0,c),o){for(var d=0;d<i;d++)o.words[d]=this.words[d];o.length=i}if(0===i);else if(this.length>i)for(this.length-=i,d=0;d<this.length;d++)this.words[d]=this.words[d+i];else this.words[0]=0,this.length=1;var s=0;for(d=this.length-1;d>=0&&(0!==s||d>=c);d--){var b=0|this.words[d];this.words[d]=s<<26-n|b>>>n,s=b&f}return o&&0!==s&&(o.words[o.length++]=s),0===this.length&&(this.words[0]=0,this.length=1),this.strip()},n.prototype.ishrn=function(e,a,t){return r(0===this.negative),this.iushrn(e,a,t)},n.prototype.shln=function(e){return this.clone().ishln(e)},n.prototype.ushln=function(e){return this.clone().iushln(e)},n.prototype.shrn=function(e){return this.clone().ishrn(e)},n.prototype.ushrn=function(e){return this.clone().iushrn(e)},n.prototype.testn=function(e){r("number"==typeof e&&e>=0);var a=e%26,t=(e-a)/26,c=1<<a;return!(this.length<=t)&&!!(this.words[t]&c)},n.prototype.imaskn=function(e){r("number"==typeof e&&e>=0);var a=e%26,t=(e-a)/26;if(r(0===this.negative,"imaskn works only with positive numbers"),this.length<=t)return this;if(0!==a&&t++,this.length=Math.min(t,this.length),0!==a){var c=67108863^67108863>>>a<<a;this.words[this.length-1]&=c}return this.strip()},n.prototype.maskn=function(e){return this.clone().imaskn(e)},n.prototype.iaddn=function(e){return r("number"==typeof e),r(e<67108864),e<0?this.isubn(-e):0!==this.negative?1===this.length&&(0|this.words[0])<e?(this.words[0]=e-(0|this.words[0]),this.negative=0,this):(this.negative=0,this.isubn(e),this.negative=1,this):this._iaddn(e)},n.prototype._iaddn=function(e){this.words[0]+=e;for(var a=0;a<this.length&&this.words[a]>=67108864;a++)this.words[a]-=67108864,a===this.length-1?this.words[a+1]=1:this.words[a+1]++;return this.length=Math.max(this.length,a+1),this},n.prototype.isubn=function(e){if(r("number"==typeof e),r(e<67108864),e<0)return this.iaddn(-e);if(0!==this.negative)return this.negative=0,this.iaddn(e),this.negative=1,this;if(this.words[0]-=e,1===this.length&&this.words[0]<0)this.words[0]=-this.words[0],this.negative=1;else for(var a=0;a<this.length&&this.words[a]<0;a++)this.words[a]+=67108864,this.words[a+1]-=1;return this.strip()},n.prototype.addn=function(e){return this.clone().iaddn(e)},n.prototype.subn=function(e){return this.clone().isubn(e)},n.prototype.iabs=function(){return this.negative=0,this},n.prototype.abs=function(){return this.clone().iabs()},n.prototype._ishlnsubmul=function(e,a,t){var c,n,i=e.length+t;this._expand(i);var f=0;for(c=0;c<e.length;c++){n=(0|this.words[c+t])+f;var o=(0|e.words[c])*a;f=((n-=67108863&o)>>26)-(o/67108864|0),this.words[c+t]=67108863&n}for(;c<this.length-t;c++)f=(n=(0|this.words[c+t])+f)>>26,this.words[c+t]=67108863&n;if(0===f)return this.strip();for(r(-1===f),f=0,c=0;c<this.length;c++)f=(n=-(0|this.words[c])+f)>>26,this.words[c]=67108863&n;return this.negative=1,this.strip()},n.prototype._wordDiv=function(e,a){var t=(this.length,e.length),r=this.clone(),c=e,i=0|c.words[c.length-1];0!==(t=26-this._countBits(i))&&(c=c.ushln(t),r.iushln(t),i=0|c.words[c.length-1]);var f,o=r.length-c.length;if("mod"!==a){(f=new n(null)).length=o+1,f.words=new Array(f.length);for(var d=0;d<f.length;d++)f.words[d]=0}var s=r.clone()._ishlnsubmul(c,1,o);0===s.negative&&(r=s,f&&(f.words[o]=1));for(var b=o-1;b>=0;b--){var u=67108864*(0|r.words[c.length+b])+(0|r.words[c.length+b-1]);for(u=Math.min(u/i|0,67108863),r._ishlnsubmul(c,u,b);0!==r.negative;)u--,r.negative=0,r._ishlnsubmul(c,1,b),r.isZero()||(r.negative^=1);f&&(f.words[b]=u)}return f&&f.strip(),r.strip(),"div"!==a&&0!==t&&r.iushrn(t),{div:f||null,mod:r}},n.prototype.divmod=function(e,a,t){return r(!e.isZero()),this.isZero()?{div:new n(0),mod:new n(0)}:0!==this.negative&&0===e.negative?(f=this.neg().divmod(e,a),"mod"!==a&&(c=f.div.neg()),"div"!==a&&(i=f.mod.neg(),t&&0!==i.negative&&i.iadd(e)),{div:c,mod:i}):0===this.negative&&0!==e.negative?(f=this.divmod(e.neg(),a),"mod"!==a&&(c=f.div.neg()),{div:c,mod:f.mod}):0!=(this.negative&e.negative)?(f=this.neg().divmod(e.neg(),a),"div"!==a&&(i=f.mod.neg(),t&&0!==i.negative&&i.isub(e)),{div:f.div,mod:i}):e.length>this.length||this.cmp(e)<0?{div:new n(0),mod:this}:1===e.length?"div"===a?{div:this.divn(e.words[0]),mod:null}:"mod"===a?{div:null,mod:new n(this.modn(e.words[0]))}:{div:this.divn(e.words[0]),mod:new n(this.modn(e.words[0]))}:this._wordDiv(e,a);var c,i,f},n.prototype.div=function(e){return this.divmod(e,"div",!1).div},n.prototype.mod=function(e){return this.divmod(e,"mod",!1).mod},n.prototype.umod=function(e){return this.divmod(e,"mod",!0).mod},n.prototype.divRound=function(e){var a=this.divmod(e);if(a.mod.isZero())return a.div;var t=0!==a.div.negative?a.mod.isub(e):a.mod,r=e.ushrn(1),c=e.andln(1),n=t.cmp(r);return n<0||1===c&&0===n?a.div:0!==a.div.negative?a.div.isubn(1):a.div.iaddn(1)},n.prototype.modn=function(e){r(e<=67108863);for(var a=(1<<26)%e,t=0,c=this.length-1;c>=0;c--)t=(a*t+(0|this.words[c]))%e;return t},n.prototype.idivn=function(e){r(e<=67108863);for(var a=0,t=this.length-1;t>=0;t--){var c=(0|this.words[t])+67108864*a;this.words[t]=c/e|0,a=c%e}return this.strip()},n.prototype.divn=function(e){return this.clone().idivn(e)},n.prototype.egcd=function(e){r(0===e.negative),r(!e.isZero());var a=this,t=e.clone();a=0!==a.negative?a.umod(e):a.clone();for(var c=new n(1),i=new n(0),f=new n(0),o=new n(1),d=0;a.isEven()&&t.isEven();)a.iushrn(1),t.iushrn(1),++d;for(var s=t.clone(),b=a.clone();!a.isZero();){for(var u=0,l=1;0==(a.words[0]&l)&&u<26;++u,l<<=1);if(u>0)for(a.iushrn(u);u-- >0;)(c.isOdd()||i.isOdd())&&(c.iadd(s),i.isub(b)),c.iushrn(1),i.iushrn(1);for(var p=0,h=1;0==(t.words[0]&h)&&p<26;++p,h<<=1);if(p>0)for(t.iushrn(p);p-- >0;)(f.isOdd()||o.isOdd())&&(f.iadd(s),o.isub(b)),f.iushrn(1),o.iushrn(1);a.cmp(t)>=0?(a.isub(t),c.isub(f),i.isub(o)):(t.isub(a),f.isub(c),o.isub(i))}return{a:f,b:o,gcd:t.iushln(d)}},n.prototype._invmp=function(e){r(0===e.negative),r(!e.isZero());var a=this,t=e.clone();a=0!==a.negative?a.umod(e):a.clone();for(var c,i=new n(1),f=new n(0),o=t.clone();a.cmpn(1)>0&&t.cmpn(1)>0;){for(var d=0,s=1;0==(a.words[0]&s)&&d<26;++d,s<<=1);if(d>0)for(a.iushrn(d);d-- >0;)i.isOdd()&&i.iadd(o),i.iushrn(1);for(var b=0,u=1;0==(t.words[0]&u)&&b<26;++b,u<<=1);if(b>0)for(t.iushrn(b);b-- >0;)f.isOdd()&&f.iadd(o),f.iushrn(1);a.cmp(t)>=0?(a.isub(t),i.isub(f)):(t.isub(a),f.isub(i))}return(c=0===a.cmpn(1)?i:f).cmpn(0)<0&&c.iadd(e),c},n.prototype.gcd=function(e){if(this.isZero())return e.abs();if(e.isZero())return this.abs();var a=this.clone(),t=e.clone();a.negative=0,t.negative=0;for(var r=0;a.isEven()&&t.isEven();r++)a.iushrn(1),t.iushrn(1);for(;;){for(;a.isEven();)a.iushrn(1);for(;t.isEven();)t.iushrn(1);var c=a.cmp(t);if(c<0){var n=a;a=t,t=n}else if(0===c||0===t.cmpn(1))break;a.isub(t)}return t.iushln(r)},n.prototype.invm=function(e){return this.egcd(e).a.umod(e)},n.prototype.isEven=function(){return 0==(1&this.words[0])},n.prototype.isOdd=function(){return 1==(1&this.words[0])},n.prototype.andln=function(e){return this.words[0]&e},n.prototype.bincn=function(e){r("number"==typeof e);var a=e%26,t=(e-a)/26,c=1<<a;if(this.length<=t)return this._expand(t+1),this.words[t]|=c,this;for(var n=c,i=t;0!==n&&i<this.length;i++){var f=0|this.words[i];n=(f+=n)>>>26,f&=67108863,this.words[i]=f}return 0!==n&&(this.words[i]=n,this.length++),this},n.prototype.isZero=function(){return 1===this.length&&0===this.words[0]},n.prototype.cmpn=function(e){var a,t=e<0;if(0!==this.negative&&!t)return-1;if(0===this.negative&&t)return 1;if(this.strip(),this.length>1)a=1;else{t&&(e=-e),r(e<=67108863,"Number is too big");var c=0|this.words[0];a=c===e?0:c<e?-1:1}return 0!==this.negative?0|-a:a},n.prototype.cmp=function(e){if(0!==this.negative&&0===e.negative)return-1;if(0===this.negative&&0!==e.negative)return 1;var a=this.ucmp(e);return 0!==this.negative?0|-a:a},n.prototype.ucmp=function(e){if(this.length>e.length)return 1;if(this.length<e.length)return-1;for(var a=0,t=this.length-1;t>=0;t--){var r=0|this.words[t],c=0|e.words[t];if(r!==c){r<c?a=-1:r>c&&(a=1);break}}return a},n.prototype.gtn=function(e){return 1===this.cmpn(e)},n.prototype.gt=function(e){return 1===this.cmp(e)},n.prototype.gten=function(e){return this.cmpn(e)>=0},n.prototype.gte=function(e){return this.cmp(e)>=0},n.prototype.ltn=function(e){return-1===this.cmpn(e)},n.prototype.lt=function(e){return-1===this.cmp(e)},n.prototype.lten=function(e){return this.cmpn(e)<=0},n.prototype.lte=function(e){return this.cmp(e)<=0},n.prototype.eqn=function(e){return 0===this.cmpn(e)},n.prototype.eq=function(e){return 0===this.cmp(e)},n.red=function(e){return new A(e)},n.prototype.toRed=function(e){return r(!this.red,"Already a number in reduction context"),r(0===this.negative,"red works only with positives"),e.convertTo(this)._forceRed(e)},n.prototype.fromRed=function(){return r(this.red,"fromRed works only with numbers in reduction context"),this.red.convertFrom(this)},n.prototype._forceRed=function(e){return this.red=e,this},n.prototype.forceRed=function(e){return r(!this.red,"Already a number in reduction context"),this._forceRed(e)},n.prototype.redAdd=function(e){return r(this.red,"redAdd works only with red numbers"),this.red.add(this,e)},n.prototype.redIAdd=function(e){return r(this.red,"redIAdd works only with red numbers"),this.red.iadd(this,e)},n.prototype.redSub=function(e){return r(this.red,"redSub works only with red numbers"),this.red.sub(this,e)},n.prototype.redISub=function(e){return r(this.red,"redISub works only with red numbers"),this.red.isub(this,e)},n.prototype.redShl=function(e){return r(this.red,"redShl works only with red numbers"),this.red.shl(this,e)},n.prototype.redMul=function(e){return r(this.red,"redMul works only with red numbers"),this.red._verify2(this,e),this.red.mul(this,e)},n.prototype.redIMul=function(e){return r(this.red,"redMul works only with red numbers"),this.red._verify2(this,e),this.red.imul(this,e)},n.prototype.redSqr=function(){return r(this.red,"redSqr works only with red numbers"),this.red._verify1(this),this.red.sqr(this)},n.prototype.redISqr=function(){return r(this.red,"redISqr works only with red numbers"),this.red._verify1(this),this.red.isqr(this)},n.prototype.redSqrt=function(){return r(this.red,"redSqrt works only with red numbers"),this.red._verify1(this),this.red.sqrt(this)},n.prototype.redInvm=function(){return r(this.red,"redInvm works only with red numbers"),this.red._verify1(this),this.red.invm(this)},n.prototype.redNeg=function(){return r(this.red,"redNeg works only with red numbers"),this.red._verify1(this),this.red.neg(this)},n.prototype.redPow=function(e){return r(this.red&&!e.red,"redPow(normalNum)"),this.red._verify1(this),this.red.pow(this,e)};var m={k256:null,p224:null,p192:null,p25519:null};function g(e,a){this.name=e,this.p=new n(a,16),this.n=this.p.bitLength(),this.k=new n(1).iushln(this.n).isub(this.p),this.tmp=this._tmp()}function v(){g.call(this,"k256","ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f")}function y(){g.call(this,"p224","ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001")}function _(){g.call(this,"p192","ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff")}function w(){g.call(this,"25519","7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed")}function A(e){if("string"==typeof e){var a=n._prime(e);this.m=a.p,this.prime=a}else r(e.gtn(1),"modulus must be greater than 1"),this.m=e,this.prime=null}function k(e){A.call(this,e),this.shift=this.m.bitLength(),this.shift%26!=0&&(this.shift+=26-this.shift%26),this.r=new n(1).iushln(this.shift),this.r2=this.imod(this.r.sqr()),this.rinv=this.r._invmp(this.m),this.minv=this.rinv.mul(this.r).isubn(1).div(this.m),this.minv=this.minv.umod(this.r),this.minv=this.r.sub(this.minv)}g.prototype._tmp=function(){var e=new n(null);return e.words=new Array(Math.ceil(this.n/13)),e},g.prototype.ireduce=function(e){var a,t=e;do{this.split(t,this.tmp),a=(t=(t=this.imulK(t)).iadd(this.tmp)).bitLength()}while(a>this.n);var r=a<this.n?-1:t.ucmp(this.p);return 0===r?(t.words[0]=0,t.length=1):r>0?t.isub(this.p):t.strip(),t},g.prototype.split=function(e,a){e.iushrn(this.n,0,a)},g.prototype.imulK=function(e){return e.imul(this.k)},c(v,g),v.prototype.split=function(e,a){for(var t=Math.min(e.length,9),r=0;r<t;r++)a.words[r]=e.words[r];if(a.length=t,e.length<=9)return e.words[0]=0,void(e.length=1);var c=e.words[9];for(a.words[a.length++]=4194303&c,r=10;r<e.length;r++){var n=0|e.words[r];e.words[r-10]=(4194303&n)<<4|c>>>22,c=n}c>>>=22,e.words[r-10]=c,0===c&&e.length>10?e.length-=10:e.length-=9},v.prototype.imulK=function(e){e.words[e.length]=0,e.words[e.length+1]=0,e.length+=2;for(var a=0,t=0;t<e.length;t++){var r=0|e.words[t];a+=977*r,e.words[t]=67108863&a,a=64*r+(a/67108864|0)}return 0===e.words[e.length-1]&&(e.length--,0===e.words[e.length-1]&&e.length--),e},c(y,g),c(_,g),c(w,g),w.prototype.imulK=function(e){for(var a=0,t=0;t<e.length;t++){var r=19*(0|e.words[t])+a,c=67108863&r;r>>>=26,e.words[t]=c,a=r}return 0!==a&&(e.words[e.length++]=a),e},n._prime=function(e){if(m[e])return m[e];var a;if("k256"===e)a=new v;else if("p224"===e)a=new y;else if("p192"===e)a=new _;else{if("p25519"!==e)throw new Error("Unknown prime "+e);a=new w}return m[e]=a,a},A.prototype._verify1=function(e){r(0===e.negative,"red works only with positives"),r(e.red,"red works only with red numbers")},A.prototype._verify2=function(e,a){r(0==(e.negative|a.negative),"red works only with positives"),r(e.red&&e.red===a.red,"red works only with red numbers")},A.prototype.imod=function(e){return this.prime?this.prime.ireduce(e)._forceRed(this):e.umod(this.m)._forceRed(this)},A.prototype.neg=function(e){return e.isZero()?e.clone():this.m.sub(e)._forceRed(this)},A.prototype.add=function(e,a){this._verify2(e,a);var t=e.add(a);return t.cmp(this.m)>=0&&t.isub(this.m),t._forceRed(this)},A.prototype.iadd=function(e,a){this._verify2(e,a);var t=e.iadd(a);return t.cmp(this.m)>=0&&t.isub(this.m),t},A.prototype.sub=function(e,a){this._verify2(e,a);var t=e.sub(a);return t.cmpn(0)<0&&t.iadd(this.m),t._forceRed(this)},A.prototype.isub=function(e,a){this._verify2(e,a);var t=e.isub(a);return t.cmpn(0)<0&&t.iadd(this.m),t},A.prototype.shl=function(e,a){return this._verify1(e),this.imod(e.ushln(a))},A.prototype.imul=function(e,a){return this._verify2(e,a),this.imod(e.imul(a))},A.prototype.mul=function(e,a){return this._verify2(e,a),this.imod(e.mul(a))},A.prototype.isqr=function(e){return this.imul(e,e.clone())},A.prototype.sqr=function(e){return this.mul(e,e)},A.prototype.sqrt=function(e){if(e.isZero())return e.clone();var a=this.m.andln(3);if(r(a%2==1),3===a){var t=this.m.add(new n(1)).iushrn(2);return this.pow(e,t)}for(var c=this.m.subn(1),i=0;!c.isZero()&&0===c.andln(1);)i++,c.iushrn(1);r(!c.isZero());var f=new n(1).toRed(this),o=f.redNeg(),d=this.m.subn(1).iushrn(1),s=this.m.bitLength();for(s=new n(2*s*s).toRed(this);0!==this.pow(s,d).cmp(o);)s.redIAdd(o);for(var b=this.pow(s,c),u=this.pow(e,c.addn(1).iushrn(1)),l=this.pow(e,c),p=i;0!==l.cmp(f);){for(var h=l,m=0;0!==h.cmp(f);m++)h=h.redSqr();r(m<p);var g=this.pow(b,new n(1).iushln(p-m-1));u=u.redMul(g),b=g.redSqr(),l=l.redMul(b),p=m}return u},A.prototype.invm=function(e){var a=e._invmp(this.m);return 0!==a.negative?(a.negative=0,this.imod(a).redNeg()):this.imod(a)},A.prototype.pow=function(e,a){if(a.isZero())return new n(1);if(0===a.cmpn(1))return e.clone();var t=new Array(16);t[0]=new n(1).toRed(this),t[1]=e;for(var r=2;r<t.length;r++)t[r]=this.mul(t[r-1],e);var c=t[0],i=0,f=0,o=a.bitLength()%26;for(0===o&&(o=26),r=a.length-1;r>=0;r--){for(var d=a.words[r],s=o-1;s>=0;s--){var b=d>>s&1;c!==t[0]&&(c=this.sqr(c)),0!==b||0!==i?(i<<=1,i|=b,(4===++f||0===r&&0===s)&&(c=this.mul(c,t[i]),f=0,i=0)):f=0}o=26}return c},A.prototype.convertTo=function(e){var a=e.umod(this.m);return a===e?a.clone():a},A.prototype.convertFrom=function(e){var a=e.clone();return a.red=null,a},n.mont=function(e){return new k(e)},c(k,A),k.prototype.convertTo=function(e){return this.imod(e.ushln(this.shift))},k.prototype.convertFrom=function(e){var a=this.imod(e.mul(this.rinv));return a.red=null,a},k.prototype.imul=function(e,a){if(e.isZero()||a.isZero())return e.words[0]=0,e.length=1,e;var t=e.imul(a),r=t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m),c=t.isub(r).iushrn(this.shift),n=c;return c.cmp(this.m)>=0?n=c.isub(this.m):c.cmpn(0)<0&&(n=c.iadd(this.m)),n._forceRed(this)},k.prototype.mul=function(e,a){if(e.isZero()||a.isZero())return new n(0)._forceRed(this);var t=e.mul(a),r=t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m),c=t.isub(r).iushrn(this.shift),i=c;return c.cmp(this.m)>=0?i=c.isub(this.m):c.cmpn(0)<0&&(i=c.iadd(this.m)),i._forceRed(this)},k.prototype.invm=function(e){return this.imod(e._invmp(this.m).mul(this.r2))._forceRed(this)}}(void 0===e||e,this)}).call(this,t(25)(e))},function(e,a){e.exports=__webpack_require__(7)},function(e,a){e.exports=__webpack_require__(11)},function(e,a,t){"use strict";var r=t(67),c="undefined"==typeof navigator,n=function(){try{var e={};return r.defineProperty(e,"f",{get:function(){return 3}}),3===e.f}catch(e){return!1}}(),i={e:{}},f;function o(){try{var e=f;return f=null,e.apply(this,arguments)}catch(e){return i.e=e,i}}function d(e){return f=e,o}var s=function(e,a){var t={}.hasOwnProperty;function r(){for(var r in this.constructor=e,this.constructor$=a,a.prototype)t.call(a.prototype,r)&&"$"!==r.charAt(r.length-1)&&(this[r+"$"]=a.prototype[r])}return r.prototype=a.prototype,e.prototype=new r,e.prototype};function b(e){return null==e||!0===e||!1===e||"string"==typeof e||"number"==typeof e}function u(e){return!b(e)}function l(e){return b(e)?new Error(E(e)):e}function p(e,a){var t,r=e.length,c=new Array(r+1);for(t=0;t<r;++t)c[t]=e[t];return c[t]=a,c}function h(e,a,t){if(!r.isES5)return{}.hasOwnProperty.call(e,a)?e[a]:void 0;var c=Object.getOwnPropertyDescriptor(e,a);return null!=c?null==c.get&&null==c.set?c.value:t:void 0}function m(e,a,t){if(b(e))return e;var c={value:t,configurable:!0,enumerable:!1,writable:!0};return r.defineProperty(e,a,c),e}function g(e){throw e}var v=function(){var e=[Array.prototype,Object.prototype,Function.prototype],a=function(a){for(var t=0;t<e.length;++t)if(e[t]===a)return!0;return!1};if(r.isES5){var t=Object.getOwnPropertyNames;return function(e){for(var c=[],n=Object.create(null);null!=e&&!a(e);){var i;try{i=t(e)}catch(e){return c}for(var f=0;f<i.length;++f){var o=i[f];if(!n[o]){n[o]=!0;var d=Object.getOwnPropertyDescriptor(e,o);null!=d&&null==d.get&&null==d.set&&c.push(o)}}e=r.getPrototypeOf(e)}return c}}var c={}.hasOwnProperty;return function(t){if(a(t))return[];var r=[];e:for(var n in t)if(c.call(t,n))r.push(n);else{for(var i=0;i<e.length;++i)if(c.call(e[i],n))continue e;r.push(n)}return r}}(),y=/this\s*\.\s*\S+\s*=/;function _(e){try{if("function"==typeof e){var a=r.names(e.prototype),t=r.isES5&&a.length>1,c=a.length>0&&!(1===a.length&&"constructor"===a[0]),n=y.test(e+"")&&r.names(e).length>0;if(t||c||n)return!0}return!1}catch(e){return!1}}function w(e){function a(){}a.prototype=e;for(var t=8;t--;)new a;return e}var A=/^[a-z$_][a-z$_0-9]*$/i;function k(e){return A.test(e)}function x(e,a,t){for(var r=new Array(e),c=0;c<e;++c)r[c]=a+c+t;return r}function E(e){try{return e+""}catch(e){return"[no string representation]"}}function S(e){try{m(e,"isOperational",!0)}catch(e){}}function T(e){return null!=e&&(e instanceof Error.__BluebirdErrorTypes__.OperationalError||!0===e.isOperational)}function j(e){return e instanceof Error&&r.propertyIsWritable(e,"stack")}var C="stack"in new Error?function(e){return j(e)?e:new Error(E(e))}:function(e){if(j(e))return e;try{throw new Error(E(e))}catch(e){return e}};function R(e){return{}.toString.call(e)}function O(e,a,t){for(var c=r.names(e),n=0;n<c.length;++n){var i=c[n];if(t(i))try{r.defineProperty(a,i,r.getDescriptor(e,i))}catch(e){}}}var B={isClass:_,isIdentifier:k,inheritedDataKeys:v,getDataPropertyOrDefault:h,thrower:g,isArray:r.isArray,haveGetters:n,notEnumerableProp:m,isPrimitive:b,isObject:u,canEvaluate:c,errorObj:i,tryCatch:d,inherits:s,withAppended:p,maybeWrapAsError:l,toFastProperties:w,filledRange:x,toString:E,canAttachTrace:j,ensureErrorObject:C,originatesFromRejection:T,markAsOriginatingFromRejection:S,classString:R,copyDescriptors:O,hasDevTools:"undefined"!=typeof chrome&&chrome&&"function"==typeof chrome.loadTimes,isNode:"undefined"!=typeof process&&"[object process]"===R(process).toLowerCase()};B.isRecentNode=B.isNode&&function(){var e=process.versions.node.split(".").map(Number);return 0===e[0]&&e[1]>10||e[0]>0}(),B.isNode&&B.toFastProperties(process);try{throw new Error}catch(e){B.lastLineError=e}e.exports=B},function(e,a,t){"use strict";var r=t(57),c="undefined"==typeof navigator,n={e:{}},i,f="undefined"!=typeof self?self:"undefined"!=typeof window?window:"undefined"!=typeof global?global:void 0!==this?this:null;function o(){try{var e=i;return i=null,e.apply(this,arguments)}catch(e){return n.e=e,n}}function d(e){return i=e,o}var s=function(e,a){var t={}.hasOwnProperty;function r(){for(var r in this.constructor=e,this.constructor$=a,a.prototype)t.call(a.prototype,r)&&"$"!==r.charAt(r.length-1)&&(this[r+"$"]=a.prototype[r])}return r.prototype=a.prototype,e.prototype=new r,e.prototype};function b(e){return null==e||!0===e||!1===e||"string"==typeof e||"number"==typeof e}function u(e){return"function"==typeof e||"object"==typeof e&&null!==e}function l(e){return b(e)?new Error(E(e)):e}function p(e,a){var t,r=e.length,c=new Array(r+1);for(t=0;t<r;++t)c[t]=e[t];return c[t]=a,c}function h(e,a,t){if(!r.isES5)return{}.hasOwnProperty.call(e,a)?e[a]:void 0;var c=Object.getOwnPropertyDescriptor(e,a);return null!=c?null==c.get&&null==c.set?c.value:t:void 0}function m(e,a,t){if(b(e))return e;var c={value:t,configurable:!0,enumerable:!1,writable:!0};return r.defineProperty(e,a,c),e}function g(e){throw e}var v=function(){var e=[Array.prototype,Object.prototype,Function.prototype],a=function(a){for(var t=0;t<e.length;++t)if(e[t]===a)return!0;return!1};if(r.isES5){var t=Object.getOwnPropertyNames;return function(e){for(var c=[],n=Object.create(null);null!=e&&!a(e);){var i;try{i=t(e)}catch(e){return c}for(var f=0;f<i.length;++f){var o=i[f];if(!n[o]){n[o]=!0;var d=Object.getOwnPropertyDescriptor(e,o);null!=d&&null==d.get&&null==d.set&&c.push(o)}}e=r.getPrototypeOf(e)}return c}}var c={}.hasOwnProperty;return function(t){if(a(t))return[];var r=[];e:for(var n in t)if(c.call(t,n))r.push(n);else{for(var i=0;i<e.length;++i)if(c.call(e[i],n))continue e;r.push(n)}return r}}(),y=/this\s*\.\s*\S+\s*=/;function _(e){try{if("function"==typeof e){var a=r.names(e.prototype),t=r.isES5&&a.length>1,c=a.length>0&&!(1===a.length&&"constructor"===a[0]),n=y.test(e+"")&&r.names(e).length>0;if(t||c||n)return!0}return!1}catch(e){return!1}}function w(e){function a(){}a.prototype=e;for(var t=8;t--;)new a;return e}var A=/^[a-z$_][a-z$_0-9]*$/i;function k(e){return A.test(e)}function x(e,a,t){for(var r=new Array(e),c=0;c<e;++c)r[c]=a+c+t;return r}function E(e){try{return e+""}catch(e){return"[no string representation]"}}function S(e){return e instanceof Error||null!==e&&"object"==typeof e&&"string"==typeof e.message&&"string"==typeof e.name}function T(e){try{m(e,"isOperational",!0)}catch(e){}}function j(e){return null!=e&&(e instanceof Error.__BluebirdErrorTypes__.OperationalError||!0===e.isOperational)}function C(e){return S(e)&&r.propertyIsWritable(e,"stack")}var R="stack"in new Error?function(e){return C(e)?e:new Error(E(e))}:function(e){if(C(e))return e;try{throw new Error(E(e))}catch(e){return e}};function O(e){return{}.toString.call(e)}function B(e,a,t){for(var c=r.names(e),n=0;n<c.length;++n){var i=c[n];if(t(i))try{r.defineProperty(a,i,r.getDescriptor(e,i))}catch(e){}}}var M=function(e){return r.isArray(e)?e:null};if("undefined"!=typeof Symbol&&Symbol.iterator){var N="function"==typeof Array.from?function(e){return Array.from(e)}:function(e){for(var a,t=[],r=e[Symbol.iterator]();!(a=r.next()).done;)t.push(a.value);return t};M=function(e){return r.isArray(e)?e:null!=e&&"function"==typeof e[Symbol.iterator]?N(e):null}}var I="undefined"!=typeof process&&"[object process]"===O(process).toLowerCase(),P="undefined"!=typeof process&&void 0!==process.env;function F(e){return P?process.env[e]:void 0}function L(){if("function"==typeof Promise)try{var e=new Promise(function(){});if("[object Promise]"==={}.toString.call(e))return Promise}catch(e){}}function D(e,a){return e.bind(a)}var z={isClass:_,isIdentifier:k,inheritedDataKeys:v,getDataPropertyOrDefault:h,thrower:g,isArray:r.isArray,asArray:M,notEnumerableProp:m,isPrimitive:b,isObject:u,isError:S,canEvaluate:c,errorObj:n,tryCatch:d,inherits:s,withAppended:p,maybeWrapAsError:l,toFastProperties:w,filledRange:x,toString:E,canAttachTrace:C,ensureErrorObject:R,originatesFromRejection:j,markAsOriginatingFromRejection:T,classString:O,copyDescriptors:B,hasDevTools:"undefined"!=typeof chrome&&chrome&&"function"==typeof chrome.loadTimes,isNode:I,hasEnvVariables:P,env:F,global:f,getNativePromise:L,domainBind:D};z.isRecentNode=z.isNode&&function(){var e=process.versions.node.split(".").map(Number);return 0===e[0]&&e[1]>10||e[0]>0}(),z.isNode&&z.toFastProperties(process);try{throw new Error}catch(e){z.lastLineError=e}e.exports=z},function(e,a,t){var r=t(154),c=t(153),n=t(262);e.exports=function(e,a){if(null==e)return r;switch(typeof e){case"function":return void 0!==a?function(t,r,c){return e.call(a,t,r,c)}:e;case"object":return function(a){return n(a,e)};case"string":case"number":return c(e)}}},function(e,a){e.exports=__webpack_require__(1)},function(e,a,t){var r=t(55),c=t(152);e.exports=function(e,a,t){c(e,function(c,n){if(r(e,n))return a.call(t,e[n],n,e)})}},function(e,a){function t(e){return Object.prototype.toString.call(e)}a.isArray=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===t(e)},a.isBoolean=function(e){return"boolean"==typeof e},a.isNull=function(e){return null===e},a.isNullOrUndefined=function(e){return null==e},a.isNumber=function(e){return"number"==typeof e},a.isString=function(e){return"string"==typeof e},a.isSymbol=function(e){return"symbol"==typeof e},a.isUndefined=function(e){return void 0===e},a.isRegExp=function(e){return"[object RegExp]"===t(e)},a.isObject=function(e){return"object"==typeof e&&null!==e},a.isDate=function(e){return"[object Date]"===t(e)},a.isError=function(e){return"[object Error]"===t(e)||e instanceof Error},a.isFunction=function(e){return"function"==typeof e},a.isPrimitive=function(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||"symbol"==typeof e||void 0===e},a.isBuffer=Buffer.isBuffer},function(e,a,t){(function(e){!function(e,t){t(a)}(0,function(a){"use strict";function t(e,a){a|=0;for(var t=Math.max(e.length-a,0),r=Array(t),c=0;c<t;c++)r[c]=e[a+c];return r}var r=function(e){var a=t(arguments,1);return function(){var r=t(arguments);return e.apply(null,a.concat(r))}},c=function(e){return function(){var a=t(arguments),r=a.pop();e.call(this,a,r)}};function n(e){var a=typeof e;return null!=e&&("object"==a||"function"==a)}var i="function"==typeof setImmediate&&setImmediate,f="object"==typeof process&&"function"==typeof process.nextTick;function o(e){setTimeout(e,0)}function d(e){return function(a){var r=t(arguments,1);e(function(){a.apply(null,r)})}}var s=d(i?setImmediate:f?process.nextTick:o);function b(e){return c(function(a,t){var r;try{r=e.apply(this,a)}catch(e){return t(e)}n(r)&&"function"==typeof r.then?r.then(function(e){u(t,null,e)},function(e){u(t,e.message?e:new Error(e))}):t(null,r)})}function u(e,a,t){try{e(a,t)}catch(e){s(l,e)}}function l(e){throw e}var p="function"==typeof Symbol;function h(e){return p&&"AsyncFunction"===e[Symbol.toStringTag]}function m(e){return h(e)?b(e):e}function g(e){return function(a){var r=t(arguments,1),n=c(function(t,r){var c=this;return e(a,function(e,a){m(e).apply(c,t.concat(a))},r)});return r.length?n.apply(this,r):n}}var v="object"==typeof global&&global&&global.Object===Object&&global,y="object"==typeof self&&self&&self.Object===Object&&self,_=v||y||Function("return this")(),w=_.Symbol,A=Object.prototype,k=A.hasOwnProperty,x=A.toString,E=w?w.toStringTag:void 0;var S=Object.prototype.toString;var T="[object Null]",j="[object Undefined]",C=w?w.toStringTag:void 0;function R(e){return null==e?void 0===e?j:T:C&&C in Object(e)?function(e){var a=k.call(e,E),t=e[E];try{e[E]=void 0;var r=!0}catch(e){}var c=x.call(e);return r&&(a?e[E]=t:delete e[E]),c}(e):function(e){return S.call(e)}(e)}var O="[object AsyncFunction]",B="[object Function]",M="[object GeneratorFunction]",N="[object Proxy]";var I=9007199254740991;function P(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=I}function F(e){return null!=e&&P(e.length)&&!function(e){if(!n(e))return!1;var a=R(e);return a==B||a==M||a==O||a==N}(e)}var L={};function D(){}function z(e){return function(){if(null!==e){var a=e;e=null,a.apply(this,arguments)}}}var q="function"==typeof Symbol&&Symbol.iterator,U=function(e){return q&&e[q]&&e[q]()};function H(e){return null!=e&&"object"==typeof e}var V="[object Arguments]";function G(e){return H(e)&&R(e)==V}var W=Object.prototype,Y=W.hasOwnProperty,K=W.propertyIsEnumerable,Q=G(function(){return arguments}())?G:function(e){return H(e)&&Y.call(e,"callee")&&!K.call(e,"callee")},Z=Array.isArray;var J="object"==typeof a&&a&&!a.nodeType&&a,X=J&&"object"==typeof e&&e&&!e.nodeType&&e,$=X&&X.exports===J?_.Buffer:void 0,ee=($?$.isBuffer:void 0)||function(){return!1},ae=9007199254740991,te=/^(?:0|[1-9]\d*)$/;function re(e,a){var t=typeof e;return!!(a=null==a?ae:a)&&("number"==t||"symbol"!=t&&te.test(e))&&e>-1&&e%1==0&&e<a}var ce={};ce["[object Float32Array]"]=ce["[object Float64Array]"]=ce["[object Int8Array]"]=ce["[object Int16Array]"]=ce["[object Int32Array]"]=ce["[object Uint8Array]"]=ce["[object Uint8ClampedArray]"]=ce["[object Uint16Array]"]=ce["[object Uint32Array]"]=!0,ce["[object Arguments]"]=ce["[object Array]"]=ce["[object ArrayBuffer]"]=ce["[object Boolean]"]=ce["[object DataView]"]=ce["[object Date]"]=ce["[object Error]"]=ce["[object Function]"]=ce["[object Map]"]=ce["[object Number]"]=ce["[object Object]"]=ce["[object RegExp]"]=ce["[object Set]"]=ce["[object String]"]=ce["[object WeakMap]"]=!1;var ne="object"==typeof a&&a&&!a.nodeType&&a,ie=ne&&"object"==typeof e&&e&&!e.nodeType&&e,fe=ie&&ie.exports===ne&&v.process,oe=function(){try{var e=ie&&ie.require&&ie.require("util").types;return e||fe&&fe.binding&&fe.binding("util")}catch(e){}}(),de=oe&&oe.isTypedArray,se=de?function(e){return function(a){return e(a)}}(de):function(e){return H(e)&&P(e.length)&&!!ce[R(e)]},be=Object.prototype.hasOwnProperty;function ue(e,a){var t=Z(e),r=!t&&Q(e),c=!t&&!r&&ee(e),n=!t&&!r&&!c&&se(e),i=t||r||c||n,f=i?function(e,a){for(var t=-1,r=Array(e);++t<e;)r[t]=a(t);return r}(e.length,String):[],o=f.length;for(var d in e)!a&&!be.call(e,d)||i&&("length"==d||c&&("offset"==d||"parent"==d)||n&&("buffer"==d||"byteLength"==d||"byteOffset"==d)||re(d,o))||f.push(d);return f}var le=Object.prototype;var pe=function(e,a){return function(t){return e(a(t))}}(Object.keys,Object),he=Object.prototype.hasOwnProperty;function me(e){if(!function(e){var a=e&&e.constructor;return e===("function"==typeof a&&a.prototype||le)}(e))return pe(e);var a=[];for(var t in Object(e))he.call(e,t)&&"constructor"!=t&&a.push(t);return a}function ge(e){return F(e)?ue(e):me(e)}function ve(e){if(F(e))return function(e){var a=-1,t=e.length;return function(){return++a<t?{value:e[a],key:a}:null}}(e);var a=U(e);return a?function(e){var a=-1;return function(){var t=e.next();return t.done?null:(a++,{value:t.value,key:a})}}(a):function(e){var a=ge(e),t=-1,r=a.length;return function(){var c=a[++t];return t<r?{value:e[c],key:c}:null}}(e)}function ye(e){return function(){if(null===e)throw new Error("Callback was already called.");var a=e;e=null,a.apply(this,arguments)}}function _e(e){return function(a,t,r){if(r=z(r||D),e<=0||!a)return r(null);var c=ve(a),n=!1,i=0,f=!1;function o(e,a){if(i-=1,e)n=!0,r(e);else{if(a===L||n&&i<=0)return n=!0,r(null);f||d()}}function d(){for(f=!0;i<e&&!n;){var a=c();if(null===a)return n=!0,void(i<=0&&r(null));i+=1,t(a.value,a.key,ye(o))}f=!1}d()}}function we(e,a,t,r){_e(a)(e,m(t),r)}function Ae(e,a){return function(t,r,c){return e(t,a,r,c)}}function ke(e,a,t){t=z(t||D);var r=0,c=0,n=e.length;function i(e,a){e?t(e):++c!==n&&a!==L||t(null)}for(0===n&&t(null);r<n;r++)a(e[r],r,ye(i))}var xe=Ae(we,1/0),Ee=function(e,a,t){(F(e)?ke:xe)(e,m(a),t)};function Se(e){return function(a,t,r){return e(Ee,a,m(t),r)}}function Te(e,a,t,r){r=r||D,a=a||[];var c=[],n=0,i=m(t);e(a,function(e,a,t){var r=n++;i(e,function(e,a){c[r]=a,t(e)})},function(e){r(e,c)})}var je=Se(Te),Ce=g(je);function Re(e){return function(a,t,r,c){return e(_e(t),a,m(r),c)}}var Oe=Re(Te),Be=Ae(Oe,1),Me=g(Be);function Ne(e,a){for(var t=-1,r=null==e?0:e.length;++t<r&&!1!==a(e[t],t,e););return e}var Ie=function(e){return function(a,t,r){for(var c=-1,n=Object(a),i=r(a),f=i.length;f--;){var o=i[e?f:++c];if(!1===t(n[o],o,n))break}return a}}();function Pe(e,a){return e&&Ie(e,a,ge)}function Fe(e){return e!=e}function Le(e,a,t){return a==a?function(e,a,t){for(var r=t-1,c=e.length;++r<c;)if(e[r]===a)return r;return-1}(e,a,t):function(e,a,t,r){for(var c=e.length,n=t+(r?1:-1);r?n--:++n<c;)if(a(e[n],n,e))return n;return-1}(e,Fe,t)}var De=function(e,a,r){"function"==typeof a&&(r=a,a=null),r=z(r||D);var c=ge(e).length;if(!c)return r(null);a||(a=c);var n={},i=0,f=!1,o=Object.create(null),d=[],s=[],b={};function u(e,a){d.push(function(){!function(e,a){if(f)return;var c=ye(function(a,c){if(i--,arguments.length>2&&(c=t(arguments,1)),a){var d={};Pe(n,function(e,a){d[a]=e}),d[e]=c,f=!0,o=Object.create(null),r(a,d)}else n[e]=c,function(e){Ne(o[e]||[],function(e){e()}),l()}(e)});i++;var d=m(a[a.length-1]);a.length>1?d(n,c):d(c)}(e,a)})}function l(){if(0===d.length&&0===i)return r(null,n);for(;d.length&&i<a;){d.shift()()}}function p(a){var t=[];return Pe(e,function(e,r){Z(e)&&Le(e,a,0)>=0&&t.push(r)}),t}Pe(e,function(a,t){if(!Z(a))return u(t,[a]),void s.push(t);var r=a.slice(0,a.length-1),c=r.length;if(0===c)return u(t,a),void s.push(t);b[t]=c,Ne(r,function(n){if(!e[n])throw new Error("async.auto task `"+t+"` has a non-existent dependency `"+n+"` in "+r.join(", "));!function(e,a){var t=o[e];t||(t=o[e]=[]);t.push(a)}(n,function(){0===--c&&u(t,a)})})}),function(){var e,a=0;for(;s.length;)e=s.pop(),a++,Ne(p(e),function(e){0==--b[e]&&s.push(e)});if(a!==c)throw new Error("async.auto cannot execute tasks due to a recursive dependency")}(),l()};function ze(e,a){for(var t=-1,r=null==e?0:e.length,c=Array(r);++t<r;)c[t]=a(e[t],t,e);return c}var qe="[object Symbol]";var Ue=1/0,He=w?w.prototype:void 0,Ve=He?He.toString:void 0;function Ge(e){if("string"==typeof e)return e;if(Z(e))return ze(e,Ge)+"";if(function(e){return"symbol"==typeof e||H(e)&&R(e)==qe}(e))return Ve?Ve.call(e):"";var a=e+"";return"0"==a&&1/e==-Ue?"-0":a}function We(e,a,t){var r=e.length;return t=void 0===t?r:t,!a&&t>=r?e:function(e,a,t){var r=-1,c=e.length;a<0&&(a=-a>c?0:c+a),(t=t>c?c:t)<0&&(t+=c),c=a>t?0:t-a>>>0,a>>>=0;for(var n=Array(c);++r<c;)n[r]=e[r+a];return n}(e,a,t)}var Ye=RegExp("[\\u200d\\ud800-\\udfff\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff\\ufe0e\\ufe0f]");var Ke="[\\ud800-\\udfff]",Qe="[\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff]",Ze="\\ud83c[\\udffb-\\udfff]",Je="[^\\ud800-\\udfff]",Xe="(?:\\ud83c[\\udde6-\\uddff]){2}",$e="[\\ud800-\\udbff][\\udc00-\\udfff]",ea="(?:"+Qe+"|"+Ze+")"+"?",aa="[\\ufe0e\\ufe0f]?"+ea+("(?:\\u200d(?:"+[Je,Xe,$e].join("|")+")[\\ufe0e\\ufe0f]?"+ea+")*"),ta="(?:"+[Je+Qe+"?",Qe,Xe,$e,Ke].join("|")+")",ra=RegExp(Ze+"(?="+Ze+")|"+ta+aa,"g");function ca(e){return function(e){return Ye.test(e)}(e)?function(e){return e.match(ra)||[]}(e):function(e){return e.split("")}(e)}var na=/^\s+|\s+$/g;function ia(e,a,t){if((e=function(e){return null==e?"":Ge(e)}(e))&&(t||void 0===a))return e.replace(na,"");if(!e||!(a=Ge(a)))return e;var r=ca(e),c=ca(a);return We(r,function(e,a){for(var t=-1,r=e.length;++t<r&&Le(a,e[t],0)>-1;);return t}(r,c),function(e,a){for(var t=e.length;t--&&Le(a,e[t],0)>-1;);return t}(r,c)+1).join("")}var fa=/^(?:async\s+)?(function)?\s*[^\(]*\(\s*([^\)]*)\)/m,oa=/,/,da=/(=.+)?(\s*)$/,sa=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm;function ba(e,a){var t={};Pe(e,function(e,a){var r,c=h(e),n=!c&&1===e.length||c&&0===e.length;if(Z(e))r=e.slice(0,-1),e=e[e.length-1],t[a]=r.concat(r.length>0?i:e);else if(n)t[a]=e;else{if(r=function(e){return e=(e=(e=(e=e.toString().replace(sa,"")).match(fa)[2].replace(" ",""))?e.split(oa):[]).map(function(e){return ia(e.replace(da,""))})}(e),0===e.length&&!c&&0===r.length)throw new Error("autoInject task functions require explicit parameters.");c||r.pop(),t[a]=r.concat(i)}function i(a,t){var c=ze(r,function(e){return a[e]});c.push(t),m(e).apply(null,c)}}),De(t,a)}function ua(){this.head=this.tail=null,this.length=0}function la(e,a){e.length=1,e.head=e.tail=a}function pa(e,a,t){if(null==a)a=1;else if(0===a)throw new Error("Concurrency must not be zero");var r=m(e),c=0,n=[],i=!1;function f(e,a,t){if(null!=t&&"function"!=typeof t)throw new Error("task callback must be a function");if(b.started=!0,Z(e)||(e=[e]),0===e.length&&b.idle())return s(function(){b.drain()});for(var r=0,c=e.length;r<c;r++){var n={data:e[r],callback:t||D};a?b._tasks.unshift(n):b._tasks.push(n)}i||(i=!0,s(function(){i=!1,b.process()}))}function o(e){return function(a){c-=1;for(var t=0,r=e.length;t<r;t++){var i=e[t],f=Le(n,i,0);0===f?n.shift():f>0&&n.splice(f,1),i.callback.apply(i,arguments),null!=a&&b.error(a,i.data)}c<=b.concurrency-b.buffer&&b.unsaturated(),b.idle()&&b.drain(),b.process()}}var d=!1,b={_tasks:new ua,concurrency:a,payload:t,saturated:D,unsaturated:D,buffer:a/4,empty:D,drain:D,error:D,started:!1,paused:!1,push:function(e,a){f(e,!1,a)},kill:function(){b.drain=D,b._tasks.empty()},unshift:function(e,a){f(e,!0,a)},remove:function(e){b._tasks.remove(e)},process:function(){if(!d){for(d=!0;!b.paused&&c<b.concurrency&&b._tasks.length;){var e=[],a=[],t=b._tasks.length;b.payload&&(t=Math.min(t,b.payload));for(var i=0;i<t;i++){var f=b._tasks.shift();e.push(f),n.push(f),a.push(f.data)}c+=1,0===b._tasks.length&&b.empty(),c===b.concurrency&&b.saturated();var s=ye(o(e));r(a,s)}d=!1}},length:function(){return b._tasks.length},running:function(){return c},workersList:function(){return n},idle:function(){return b._tasks.length+c===0},pause:function(){b.paused=!0},resume:function(){!1!==b.paused&&(b.paused=!1,s(b.process))}};return b}function ha(e,a){return pa(e,1,a)}ua.prototype.removeLink=function(e){return e.prev?e.prev.next=e.next:this.head=e.next,e.next?e.next.prev=e.prev:this.tail=e.prev,e.prev=e.next=null,this.length-=1,e},ua.prototype.empty=function(){for(;this.head;)this.shift();return this},ua.prototype.insertAfter=function(e,a){a.prev=e,a.next=e.next,e.next?e.next.prev=a:this.tail=a,e.next=a,this.length+=1},ua.prototype.insertBefore=function(e,a){a.prev=e.prev,a.next=e,e.prev?e.prev.next=a:this.head=a,e.prev=a,this.length+=1},ua.prototype.unshift=function(e){this.head?this.insertBefore(this.head,e):la(this,e)},ua.prototype.push=function(e){this.tail?this.insertAfter(this.tail,e):la(this,e)},ua.prototype.shift=function(){return this.head&&this.removeLink(this.head)},ua.prototype.pop=function(){return this.tail&&this.removeLink(this.tail)},ua.prototype.toArray=function(){for(var e=Array(this.length),a=this.head,t=0;t<this.length;t++)e[t]=a.data,a=a.next;return e},ua.prototype.remove=function(e){for(var a=this.head;a;){var t=a.next;e(a)&&this.removeLink(a),a=t}return this};var ma=Ae(we,1);function ga(e,a,t,r){r=z(r||D);var c=m(t);ma(e,function(e,t,r){c(a,e,function(e,t){a=t,r(e)})},function(e){r(e,a)})}function va(){var e=ze(arguments,m);return function(){var a=t(arguments),r=this,c=a[a.length-1];"function"==typeof c?a.pop():c=D,ga(e,a,function(e,a,c){a.apply(r,e.concat(function(e){var a=t(arguments,1);c(e,a)}))},function(e,a){c.apply(r,[e].concat(a))})}}var ya=function(){return va.apply(null,t(arguments).reverse())},_a=Array.prototype.concat,wa=function(e,a,r,c){c=c||D;var n=m(r);Oe(e,a,function(e,a){n(e,function(e){return e?a(e):a(null,t(arguments,1))})},function(e,a){for(var t=[],r=0;r<a.length;r++)a[r]&&(t=_a.apply(t,a[r]));return c(e,t)})},Aa=Ae(wa,1/0),ka=Ae(wa,1),xa=function(){var e=t(arguments),a=[null].concat(e);return function(){return arguments[arguments.length-1].apply(this,a)}};function Ea(e){return e}function Sa(e,a){return function(t,r,c,n){n=n||D;var i,f=!1;t(r,function(t,r,n){c(t,function(r,c){r?n(r):e(c)&&!i?(f=!0,i=a(!0,t),n(null,L)):n()})},function(e){e?n(e):n(null,f?i:a(!1))})}}function Ta(e,a){return a}var ja=Se(Sa(Ea,Ta)),Ca=Re(Sa(Ea,Ta)),Ra=Ae(Ca,1);function Oa(e){return function(a){var r=t(arguments,1);r.push(function(a){var r=t(arguments,1);"object"==typeof console&&(a?console.error&&console.error(a):console[e]&&Ne(r,function(a){console[e](a)}))}),m(a).apply(null,r)}}var Ba=Oa("dir");function Ma(e,a,r){r=ye(r||D);var c=m(e),n=m(a);function i(e){if(e)return r(e);var a=t(arguments,1);a.push(f),n.apply(this,a)}function f(e,a){return e?r(e):a?void c(i):r(null)}f(null,!0)}function Na(e,a,r){r=ye(r||D);var c=m(e),n=function(e){if(e)return r(e);var i=t(arguments,1);if(a.apply(this,i))return c(n);r.apply(null,[null].concat(i))};c(n)}function Ia(e,a,t){Na(e,function(){return!a.apply(this,arguments)},t)}function Pa(e,a,t){t=ye(t||D);var r=m(a),c=m(e);function n(e){if(e)return t(e);c(i)}function i(e,a){return e?t(e):a?void r(n):t(null)}c(i)}function Fa(e){return function(a,t,r){return e(a,r)}}function La(e,a,t){Ee(e,Fa(m(a)),t)}function Da(e,a,t,r){_e(a)(e,Fa(m(t)),r)}var za=Ae(Da,1);function qa(e){return h(e)?e:c(function(a,t){var r=!0;a.push(function(){var e=arguments;r?s(function(){t.apply(null,e)}):t.apply(null,e)}),e.apply(this,a),r=!1})}function Ua(e){return!e}var Ha=Se(Sa(Ua,Ua)),Va=Re(Sa(Ua,Ua)),Ga=Ae(Va,1);function Wa(e){return function(a){return null==a?void 0:a[e]}}function Ya(e,a,t,r){var c=new Array(a.length);e(a,function(e,a,r){t(e,function(e,t){c[a]=!!t,r(e)})},function(e){if(e)return r(e);for(var t=[],n=0;n<a.length;n++)c[n]&&t.push(a[n]);r(null,t)})}function Ka(e,a,t,r){var c=[];e(a,function(e,a,r){t(e,function(t,n){t?r(t):(n&&c.push({index:a,value:e}),r())})},function(e){e?r(e):r(null,ze(c.sort(function(e,a){return e.index-a.index}),Wa("value")))})}function Qa(e,a,t,r){(F(a)?Ya:Ka)(e,a,m(t),r||D)}var Za=Se(Qa),Ja=Re(Qa),Xa=Ae(Ja,1);function $a(e,a){var t=ye(a||D),r=m(qa(e));!function e(a){if(a)return t(a);r(e)}()}var et=function(e,a,t,r){r=r||D;var c=m(t);Oe(e,a,function(e,a){c(e,function(t,r){return t?a(t):a(null,{key:r,val:e})})},function(e,a){for(var t={},c=Object.prototype.hasOwnProperty,n=0;n<a.length;n++)if(a[n]){var i=a[n].key,f=a[n].val;c.call(t,i)?t[i].push(f):t[i]=[f]}return r(e,t)})},at=Ae(et,1/0),tt=Ae(et,1),rt=Oa("log");function ct(e,a,t,r){r=z(r||D);var c={},n=m(t);we(e,a,function(e,a,t){n(e,a,function(e,r){if(e)return t(e);c[a]=r,t()})},function(e){r(e,c)})}var nt=Ae(ct,1/0),it=Ae(ct,1);function ft(e,a){return a in e}function ot(e,a){var r=Object.create(null),n=Object.create(null);a=a||Ea;var i=m(e),f=c(function(e,c){var f=a.apply(null,e);ft(r,f)?s(function(){c.apply(null,r[f])}):ft(n,f)?n[f].push(c):(n[f]=[c],i.apply(null,e.concat(function(){var e=t(arguments);r[f]=e;var a=n[f];delete n[f];for(var c=0,i=a.length;c<i;c++)a[c].apply(null,e)})))});return f.memo=r,f.unmemoized=e,f}var dt=d(f?process.nextTick:i?setImmediate:o);function st(e,a,r){r=r||D;var c=F(a)?[]:{};e(a,function(e,a,r){m(e)(function(e,n){arguments.length>2&&(n=t(arguments,1)),c[a]=n,r(e)})},function(e){r(e,c)})}function bt(e,a){st(Ee,e,a)}function ut(e,a,t){st(_e(a),e,t)}var lt=function(e,a){var t=m(e);return pa(function(e,a){t(e[0],a)},a,1)},pt=function(e,a){var t=lt(e,a);return t.push=function(e,a,r){if(null==r&&(r=D),"function"!=typeof r)throw new Error("task callback must be a function");if(t.started=!0,Z(e)||(e=[e]),0===e.length)return s(function(){t.drain()});a=a||0;for(var c=t._tasks.head;c&&a>=c.priority;)c=c.next;for(var n=0,i=e.length;n<i;n++){var f={data:e[n],priority:a,callback:r};c?t._tasks.insertBefore(c,f):t._tasks.push(f)}s(t.process)},delete t.unshift,t};function ht(e,a){if(a=z(a||D),!Z(e))return a(new TypeError("First argument to race must be an array of functions"));if(!e.length)return a();for(var t=0,r=e.length;t<r;t++)m(e[t])(a)}function mt(e,a,r,c){ga(t(e).reverse(),a,r,c)}function gt(e){var a=m(e);return c(function(e,r){return e.push(function(e,a){var c;e?r(null,{error:e}):(c=arguments.length<=2?a:t(arguments,1),r(null,{value:c}))}),a.apply(this,e)})}function vt(e){var a;return Z(e)?a=ze(e,gt):(a={},Pe(e,function(e,t){a[t]=gt.call(this,e)})),a}function yt(e,a,t,r){Qa(e,a,function(e,a){t(e,function(e,t){a(e,!t)})},r)}var _t=Se(yt),wt=Re(yt),At=Ae(wt,1);function kt(e){return function(){return e}}function xt(e,a,t){var r=5,c=0,n={times:r,intervalFunc:kt(c)};if(arguments.length<3&&"function"==typeof e?(t=a||D,a=e):(!function(e,a){if("object"==typeof a)e.times=+a.times||r,e.intervalFunc="function"==typeof a.interval?a.interval:kt(+a.interval||c),e.errorFilter=a.errorFilter;else{if("number"!=typeof a&&"string"!=typeof a)throw new Error("Invalid arguments for async.retry");e.times=+a||r}}(n,e),t=t||D),"function"!=typeof a)throw new Error("Invalid arguments for async.retry");var i=m(a),f=1;!function e(){i(function(a){a&&f++<n.times&&("function"!=typeof n.errorFilter||n.errorFilter(a))?setTimeout(e,n.intervalFunc(f)):t.apply(null,arguments)})}()}var Et=function(e,a){a||(a=e,e=null);var t=m(a);return c(function(a,r){function c(e){t.apply(null,a.concat(e))}e?xt(e,c,r):xt(c,r)})};function St(e,a){st(ma,e,a)}var Tt=Se(Sa(Boolean,Ea)),jt=Re(Sa(Boolean,Ea)),Ct=Ae(jt,1);function Rt(e,a,t){var r=m(a);function c(e,a){var t=e.criteria,r=a.criteria;return t<r?-1:t>r?1:0}je(e,function(e,a){r(e,function(t,r){if(t)return a(t);a(null,{value:e,criteria:r})})},function(e,a){if(e)return t(e);t(null,ze(a.sort(c),Wa("value")))})}function Ot(e,a,t){var r=m(e);return c(function(c,n){var i,f=!1;c.push(function(){f||(n.apply(null,arguments),clearTimeout(i))}),i=setTimeout(function(){var a=e.name||"anonymous",r=new Error('Callback function "'+a+'" timed out.');r.code="ETIMEDOUT",t&&(r.info=t),f=!0,n(r)},a),r.apply(null,c)})}var Bt=Math.ceil,Mt=Math.max;function Nt(e,a,t,r){var c=m(t);Oe(function(e,a,t,r){for(var c=-1,n=Mt(Bt((a-e)/(t||1)),0),i=Array(n);n--;)i[r?n:++c]=e,e+=t;return i}(0,e,1),a,c,r)}var It=Ae(Nt,1/0),Pt=Ae(Nt,1);function Ft(e,a,t,r){arguments.length<=3&&(r=t,t=a,a=Z(e)?[]:{}),r=z(r||D);var c=m(t);Ee(e,function(e,t,r){c(a,e,t,r)},function(e){r(e,a)})}function Lt(e,a){var r,c=null;a=a||D,za(e,function(e,a){m(e)(function(e,n){r=arguments.length>2?t(arguments,1):n,c=e,a(!e)})},function(){a(c,r)})}function Dt(e){return function(){return(e.unmemoized||e).apply(null,arguments)}}function zt(e,a,r){r=ye(r||D);var c=m(a);if(!e())return r(null);var n=function(a){if(a)return r(a);if(e())return c(n);var i=t(arguments,1);r.apply(null,[null].concat(i))};c(n)}function qt(e,a,t){zt(function(){return!e.apply(this,arguments)},a,t)}var Ut=function(e,a){if(a=z(a||D),!Z(e))return a(new Error("First argument to waterfall must be an array of functions"));if(!e.length)return a();var r=0;function c(a){var t=m(e[r++]);a.push(ye(n)),t.apply(null,a)}function n(n){if(n||r===e.length)return a.apply(null,arguments);c(t(arguments,1))}c([])},Ht={apply:r,applyEach:Ce,applyEachSeries:Me,asyncify:b,auto:De,autoInject:ba,cargo:ha,compose:ya,concat:Aa,concatLimit:wa,concatSeries:ka,constant:xa,detect:ja,detectLimit:Ca,detectSeries:Ra,dir:Ba,doDuring:Ma,doUntil:Ia,doWhilst:Na,during:Pa,each:La,eachLimit:Da,eachOf:Ee,eachOfLimit:we,eachOfSeries:ma,eachSeries:za,ensureAsync:qa,every:Ha,everyLimit:Va,everySeries:Ga,filter:Za,filterLimit:Ja,filterSeries:Xa,forever:$a,groupBy:at,groupByLimit:et,groupBySeries:tt,log:rt,map:je,mapLimit:Oe,mapSeries:Be,mapValues:nt,mapValuesLimit:ct,mapValuesSeries:it,memoize:ot,nextTick:dt,parallel:bt,parallelLimit:ut,priorityQueue:pt,queue:lt,race:ht,reduce:ga,reduceRight:mt,reflect:gt,reflectAll:vt,reject:_t,rejectLimit:wt,rejectSeries:At,retry:xt,retryable:Et,seq:va,series:St,setImmediate:s,some:Tt,someLimit:jt,someSeries:Ct,sortBy:Rt,timeout:Ot,times:It,timesLimit:Nt,timesSeries:Pt,transform:Ft,tryEach:Lt,unmemoize:Dt,until:qt,waterfall:Ut,whilst:zt,all:Ha,allLimit:Va,allSeries:Ga,any:Tt,anyLimit:jt,anySeries:Ct,find:ja,findLimit:Ca,findSeries:Ra,forEach:La,forEachSeries:za,forEachLimit:Da,forEachOf:Ee,forEachOfSeries:ma,forEachOfLimit:we,inject:ga,foldl:ga,foldr:mt,select:Za,selectLimit:Ja,selectSeries:Xa,wrapSync:b};a.default=Ht,a.apply=r,a.applyEach=Ce,a.applyEachSeries=Me,a.asyncify=b,a.auto=De,a.autoInject=ba,a.cargo=ha,a.compose=ya,a.concat=Aa,a.concatLimit=wa,a.concatSeries=ka,a.constant=xa,a.detect=ja,a.detectLimit=Ca,a.detectSeries=Ra,a.dir=Ba,a.doDuring=Ma,a.doUntil=Ia,a.doWhilst=Na,a.during=Pa,a.each=La,a.eachLimit=Da,a.eachOf=Ee,a.eachOfLimit=we,a.eachOfSeries=ma,a.eachSeries=za,a.ensureAsync=qa,a.every=Ha,a.everyLimit=Va,a.everySeries=Ga,a.filter=Za,a.filterLimit=Ja,a.filterSeries=Xa,a.forever=$a,a.groupBy=at,a.groupByLimit=et,a.groupBySeries=tt,a.log=rt,a.map=je,a.mapLimit=Oe,a.mapSeries=Be,a.mapValues=nt,a.mapValuesLimit=ct,a.mapValuesSeries=it,a.memoize=ot,a.nextTick=dt,a.parallel=bt,a.parallelLimit=ut,a.priorityQueue=pt,a.queue=lt,a.race=ht,a.reduce=ga,a.reduceRight=mt,a.reflect=gt,a.reflectAll=vt,a.reject=_t,a.rejectLimit=wt,a.rejectSeries=At,a.retry=xt,a.retryable=Et,a.seq=va,a.series=St,a.setImmediate=s,a.some=Tt,a.someLimit=jt,a.someSeries=Ct,a.sortBy=Rt,a.timeout=Ot,a.times=It,a.timesLimit=Nt,a.timesSeries=Pt,a.transform=Ft,a.tryEach=Lt,a.unmemoize=Dt,a.until=qt,a.waterfall=Ut,a.whilst=zt,a.all=Ha,a.allLimit=Va,a.allSeries=Ga,a.any=Tt,a.anyLimit=jt,a.anySeries=Ct,a.find=ja,a.findLimit=Ca,a.findSeries=Ra,a.forEach=La,a.forEachSeries=za,a.forEachLimit=Da,a.forEachOf=Ee,a.forEachOfSeries=ma,a.forEachOfLimit=we,a.inject=ga,a.foldl=ga,a.foldr=mt,a.select=Za,a.selectLimit=Ja,a.selectSeries=Xa,a.wrapSync=b,Object.defineProperty(a,"__esModule",{value:!0})})}).call(this,t(25)(e))},function(e,a,t){var r=t(3);e.exports={hex:function(e){if("string"==typeof e){if("0x"===e)return"0x0";if(0==e.indexOf("0x"))return e;e=new r.BN(e)}return"boolean"==typeof e&&(e=e?1:0),"number"==typeof e&&(e=r.intToHex(e)),"object"==typeof e&&""==(e=e.toString("hex"))&&(e="0"),r.addHexPrefix(e)},rpcQuantityHexString:function(e){return"0x"==(e="0x"+(e=this.hex(e)).replace("0x","").replace(/^0+/,""))&&(e="0x0"),e},rpcDataHexString:function(e,a){if("number"==typeof a)e=this.hex(e).replace("0x",""),e=new Array(a-e.length).fill("0").join("")+e;else{if(0==e.length)return"0x";(e=this.hex(e).replace("0x","")).length%2!=0&&(e="0"+e)}return"0x"+e},hexWithZeroPadding:function(e){const a=(e=this.hex(e)).replace("0x","");return 1&a.length?"0x0"+a:e},number:function(e){return"number"==typeof e?e:"string"==typeof e&&0!=e.indexOf("0x")?parseInt(e):r.bufferToInt(r.toBuffer(e))}}},function(e,a,t){var r;(function(){var t=this,c=t._,n=Array.prototype,i=Object.prototype,f=Function.prototype,o=n.push,d=n.slice,s=i.toString,b=i.hasOwnProperty,u=Array.isArray,l=Object.keys,p=f.bind,h=Object.create,m=function(){},g=function(e){return e instanceof g?e:this instanceof g?void(this._wrapped=e):new g(e)};void 0!==e&&e.exports&&(a=e.exports=g),a._=g,g.VERSION="1.8.3";var v=function(e,a,t){if(void 0===a)return e;switch(null==t?3:t){case 1:return function(t){return e.call(a,t)};case 2:return function(t,r){return e.call(a,t,r)};case 3:return function(t,r,c){return e.call(a,t,r,c)};case 4:return function(t,r,c,n){return e.call(a,t,r,c,n)}}return function(){return e.apply(a,arguments)}},y=function(e,a,t){return null==e?g.identity:g.isFunction(e)?v(e,a,t):g.isObject(e)?g.matcher(e):g.property(e)};g.iteratee=function(e,a){return y(e,a,1/0)};var _=function(e,a){return function(t){var r=arguments.length;if(r<2||null==t)return t;for(var c=1;c<r;c++)for(var n=arguments[c],i=e(n),f=i.length,o=0;o<f;o++){var d=i[o];a&&void 0!==t[d]||(t[d]=n[d])}return t}},w=function(e){if(!g.isObject(e))return{};if(h)return h(e);m.prototype=e;var a=new m;return m.prototype=null,a},A=function(e){return function(a){return null==a?void 0:a[e]}},k=Math.pow(2,53)-1,x=A("length"),E=function(e){var a=x(e);return"number"==typeof a&&a>=0&&a<=k};function S(e){return function(a,t,r,c){t=v(t,c,4);var n=!E(a)&&g.keys(a),i=(n||a).length,f=e>0?0:i-1;return arguments.length<3&&(r=a[n?n[f]:f],f+=e),function(a,t,r,c,n,i){for(;n>=0&&n<i;n+=e){var f=c?c[n]:n;r=t(r,a[f],f,a)}return r}(a,t,r,n,f,i)}}g.each=g.forEach=function(e,a,t){var r,c;if(a=v(a,t),E(e))for(r=0,c=e.length;r<c;r++)a(e[r],r,e);else{var n=g.keys(e);for(r=0,c=n.length;r<c;r++)a(e[n[r]],n[r],e)}return e},g.map=g.collect=function(e,a,t){a=y(a,t);for(var r=!E(e)&&g.keys(e),c=(r||e).length,n=Array(c),i=0;i<c;i++){var f=r?r[i]:i;n[i]=a(e[f],f,e)}return n},g.reduce=g.foldl=g.inject=S(1),g.reduceRight=g.foldr=S(-1),g.find=g.detect=function(e,a,t){var r;if(void 0!==(r=E(e)?g.findIndex(e,a,t):g.findKey(e,a,t))&&-1!==r)return e[r]},g.filter=g.select=function(e,a,t){var r=[];return a=y(a,t),g.each(e,function(e,t,c){a(e,t,c)&&r.push(e)}),r},g.reject=function(e,a,t){return g.filter(e,g.negate(y(a)),t)},g.every=g.all=function(e,a,t){a=y(a,t);for(var r=!E(e)&&g.keys(e),c=(r||e).length,n=0;n<c;n++){var i=r?r[n]:n;if(!a(e[i],i,e))return!1}return!0},g.some=g.any=function(e,a,t){a=y(a,t);for(var r=!E(e)&&g.keys(e),c=(r||e).length,n=0;n<c;n++){var i=r?r[n]:n;if(a(e[i],i,e))return!0}return!1},g.contains=g.includes=g.include=function(e,a,t,r){return E(e)||(e=g.values(e)),("number"!=typeof t||r)&&(t=0),g.indexOf(e,a,t)>=0},g.invoke=function(e,a){var t=d.call(arguments,2),r=g.isFunction(a);return g.map(e,function(e){var c=r?a:e[a];return null==c?c:c.apply(e,t)})},g.pluck=function(e,a){return g.map(e,g.property(a))},g.where=function(e,a){return g.filter(e,g.matcher(a))},g.findWhere=function(e,a){return g.find(e,g.matcher(a))},g.max=function(e,a,t){var r,c,n=-1/0,i=-1/0;if(null==a&&null!=e)for(var f=0,o=(e=E(e)?e:g.values(e)).length;f<o;f++)(r=e[f])>n&&(n=r);else a=y(a,t),g.each(e,function(e,t,r){((c=a(e,t,r))>i||c===-1/0&&n===-1/0)&&(n=e,i=c)});return n},g.min=function(e,a,t){var r,c,n=1/0,i=1/0;if(null==a&&null!=e)for(var f=0,o=(e=E(e)?e:g.values(e)).length;f<o;f++)(r=e[f])<n&&(n=r);else a=y(a,t),g.each(e,function(e,t,r){((c=a(e,t,r))<i||c===1/0&&n===1/0)&&(n=e,i=c)});return n},g.shuffle=function(e){for(var a,t=E(e)?e:g.values(e),r=t.length,c=Array(r),n=0;n<r;n++)(a=g.random(0,n))!==n&&(c[n]=c[a]),c[a]=t[n];return c},g.sample=function(e,a,t){return null==a||t?(E(e)||(e=g.values(e)),e[g.random(e.length-1)]):g.shuffle(e).slice(0,Math.max(0,a))},g.sortBy=function(e,a,t){return a=y(a,t),g.pluck(g.map(e,function(e,t,r){return{value:e,index:t,criteria:a(e,t,r)}}).sort(function(e,a){var t=e.criteria,r=a.criteria;if(t!==r){if(t>r||void 0===t)return 1;if(t<r||void 0===r)return-1}return e.index-a.index}),"value")};var T=function(e){return function(a,t,r){var c={};return t=y(t,r),g.each(a,function(r,n){var i=t(r,n,a);e(c,r,i)}),c}};g.groupBy=T(function(e,a,t){g.has(e,t)?e[t].push(a):e[t]=[a]}),g.indexBy=T(function(e,a,t){e[t]=a}),g.countBy=T(function(e,a,t){g.has(e,t)?e[t]++:e[t]=1}),g.toArray=function(e){return e?g.isArray(e)?d.call(e):E(e)?g.map(e,g.identity):g.values(e):[]},g.size=function(e){return null==e?0:E(e)?e.length:g.keys(e).length},g.partition=function(e,a,t){a=y(a,t);var r=[],c=[];return g.each(e,function(e,t,n){(a(e,t,n)?r:c).push(e)}),[r,c]},g.first=g.head=g.take=function(e,a,t){if(null!=e)return null==a||t?e[0]:g.initial(e,e.length-a)},g.initial=function(e,a,t){return d.call(e,0,Math.max(0,e.length-(null==a||t?1:a)))},g.last=function(e,a,t){if(null!=e)return null==a||t?e[e.length-1]:g.rest(e,Math.max(0,e.length-a))},g.rest=g.tail=g.drop=function(e,a,t){return d.call(e,null==a||t?1:a)},g.compact=function(e){return g.filter(e,g.identity)};var j=function(e,a,t,r){for(var c=[],n=0,i=r||0,f=x(e);i<f;i++){var o=e[i];if(E(o)&&(g.isArray(o)||g.isArguments(o))){a||(o=j(o,a,t));var d=0,s=o.length;for(c.length+=s;d<s;)c[n++]=o[d++]}else t||(c[n++]=o)}return c};function C(e){return function(a,t,r){t=y(t,r);for(var c=x(a),n=e>0?0:c-1;n>=0&&n<c;n+=e)if(t(a[n],n,a))return n;return-1}}function R(e,a,t){return function(r,c,n){var i=0,f=x(r);if("number"==typeof n)e>0?i=n>=0?n:Math.max(n+f,i):f=n>=0?Math.min(n+1,f):n+f+1;else if(t&&n&&f)return r[n=t(r,c)]===c?n:-1;if(c!=c)return(n=a(d.call(r,i,f),g.isNaN))>=0?n+i:-1;for(n=e>0?i:f-1;n>=0&&n<f;n+=e)if(r[n]===c)return n;return-1}}g.flatten=function(e,a){return j(e,a,!1)},g.without=function(e){return g.difference(e,d.call(arguments,1))},g.uniq=g.unique=function(e,a,t,r){g.isBoolean(a)||(r=t,t=a,a=!1),null!=t&&(t=y(t,r));for(var c=[],n=[],i=0,f=x(e);i<f;i++){var o=e[i],d=t?t(o,i,e):o;a?(i&&n===d||c.push(o),n=d):t?g.contains(n,d)||(n.push(d),c.push(o)):g.contains(c,o)||c.push(o)}return c},g.union=function(){return g.uniq(j(arguments,!0,!0))},g.intersection=function(e){for(var a=[],t=arguments.length,r=0,c=x(e);r<c;r++){var n=e[r];if(!g.contains(a,n)){for(var i=1;i<t&&g.contains(arguments[i],n);i++);i===t&&a.push(n)}}return a},g.difference=function(e){var a=j(arguments,!0,!0,1);return g.filter(e,function(e){return!g.contains(a,e)})},g.zip=function(){return g.unzip(arguments)},g.unzip=function(e){for(var a=e&&g.max(e,x).length||0,t=Array(a),r=0;r<a;r++)t[r]=g.pluck(e,r);return t},g.object=function(e,a){for(var t={},r=0,c=x(e);r<c;r++)a?t[e[r]]=a[r]:t[e[r][0]]=e[r][1];return t},g.findIndex=C(1),g.findLastIndex=C(-1),g.sortedIndex=function(e,a,t,r){for(var c=(t=y(t,r,1))(a),n=0,i=x(e);n<i;){var f=Math.floor((n+i)/2);t(e[f])<c?n=f+1:i=f}return n},g.indexOf=R(1,g.findIndex,g.sortedIndex),g.lastIndexOf=R(-1,g.findLastIndex),g.range=function(e,a,t){null==a&&(a=e||0,e=0),t=t||1;for(var r=Math.max(Math.ceil((a-e)/t),0),c=Array(r),n=0;n<r;n++,e+=t)c[n]=e;return c};var O=function(e,a,t,r,c){if(!(r instanceof a))return e.apply(t,c);var n=w(e.prototype),i=e.apply(n,c);return g.isObject(i)?i:n};g.bind=function(e,a){if(p&&e.bind===p)return p.apply(e,d.call(arguments,1));if(!g.isFunction(e))throw new TypeError("Bind must be called on a function");var t=d.call(arguments,2),r=function(){return O(e,r,a,this,t.concat(d.call(arguments)))};return r},g.partial=function(e){var a=d.call(arguments,1),t=function(){for(var r=0,c=a.length,n=Array(c),i=0;i<c;i++)n[i]=a[i]===g?arguments[r++]:a[i];for(;r<arguments.length;)n.push(arguments[r++]);return O(e,t,this,this,n)};return t},g.bindAll=function(e){var a,t,r=arguments.length;if(r<=1)throw new Error("bindAll must be passed function names");for(a=1;a<r;a++)e[t=arguments[a]]=g.bind(e[t],e);return e},g.memoize=function(e,a){var t=function(r){var c=t.cache,n=""+(a?a.apply(this,arguments):r);return g.has(c,n)||(c[n]=e.apply(this,arguments)),c[n]};return t.cache={},t},g.delay=function(e,a){var t=d.call(arguments,2);return setTimeout(function(){return e.apply(null,t)},a)},g.defer=g.partial(g.delay,g,1),g.throttle=function(e,a,t){var r,c,n,i=null,f=0;t||(t={});var o=function(){f=!1===t.leading?0:g.now(),i=null,n=e.apply(r,c),i||(r=c=null)};return function(){var d=g.now();f||!1!==t.leading||(f=d);var s=a-(d-f);return r=this,c=arguments,s<=0||s>a?(i&&(clearTimeout(i),i=null),f=d,n=e.apply(r,c),i||(r=c=null)):i||!1===t.trailing||(i=setTimeout(o,s)),n}},g.debounce=function(e,a,t){var r,c,n,i,f,o=function(){var d=g.now()-i;d<a&&d>=0?r=setTimeout(o,a-d):(r=null,t||(f=e.apply(n,c),r||(n=c=null)))};return function(){n=this,c=arguments,i=g.now();var d=t&&!r;return r||(r=setTimeout(o,a)),d&&(f=e.apply(n,c),n=c=null),f}},g.wrap=function(e,a){return g.partial(a,e)},g.negate=function(e){return function(){return!e.apply(this,arguments)}},g.compose=function(){var e=arguments,a=e.length-1;return function(){for(var t=a,r=e[a].apply(this,arguments);t--;)r=e[t].call(this,r);return r}},g.after=function(e,a){return function(){if(--e<1)return a.apply(this,arguments)}},g.before=function(e,a){var t;return function(){return--e>0&&(t=a.apply(this,arguments)),e<=1&&(a=null),t}},g.once=g.partial(g.before,2);var B=!{toString:null}.propertyIsEnumerable("toString"),M=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"];function N(e,a){var t=M.length,r=e.constructor,c=g.isFunction(r)&&r.prototype||i,n="constructor";for(g.has(e,n)&&!g.contains(a,n)&&a.push(n);t--;)(n=M[t])in e&&e[n]!==c[n]&&!g.contains(a,n)&&a.push(n)}g.keys=function(e){if(!g.isObject(e))return[];if(l)return l(e);var a=[];for(var t in e)g.has(e,t)&&a.push(t);return B&&N(e,a),a},g.allKeys=function(e){if(!g.isObject(e))return[];var a=[];for(var t in e)a.push(t);return B&&N(e,a),a},g.values=function(e){for(var a=g.keys(e),t=a.length,r=Array(t),c=0;c<t;c++)r[c]=e[a[c]];return r},g.mapObject=function(e,a,t){a=y(a,t);for(var r,c=g.keys(e),n=c.length,i={},f=0;f<n;f++)i[r=c[f]]=a(e[r],r,e);return i},g.pairs=function(e){for(var a=g.keys(e),t=a.length,r=Array(t),c=0;c<t;c++)r[c]=[a[c],e[a[c]]];return r},g.invert=function(e){for(var a={},t=g.keys(e),r=0,c=t.length;r<c;r++)a[e[t[r]]]=t[r];return a},g.functions=g.methods=function(e){var a=[];for(var t in e)g.isFunction(e[t])&&a.push(t);return a.sort()},g.extend=_(g.allKeys),g.extendOwn=g.assign=_(g.keys),g.findKey=function(e,a,t){a=y(a,t);for(var r,c=g.keys(e),n=0,i=c.length;n<i;n++)if(a(e[r=c[n]],r,e))return r},g.pick=function(e,a,t){var r,c,n={},i=e;if(null==i)return n;g.isFunction(a)?(c=g.allKeys(i),r=v(a,t)):(c=j(arguments,!1,!1,1),r=function(e,a,t){return a in t},i=Object(i));for(var f=0,o=c.length;f<o;f++){var d=c[f],s=i[d];r(s,d,i)&&(n[d]=s)}return n},g.omit=function(e,a,t){if(g.isFunction(a))a=g.negate(a);else{var r=g.map(j(arguments,!1,!1,1),String);a=function(e,a){return!g.contains(r,a)}}return g.pick(e,a,t)},g.defaults=_(g.allKeys,!0),g.create=function(e,a){var t=w(e);return a&&g.extendOwn(t,a),t},g.clone=function(e){return g.isObject(e)?g.isArray(e)?e.slice():g.extend({},e):e},g.tap=function(e,a){return a(e),e},g.isMatch=function(e,a){var t=g.keys(a),r=t.length;if(null==e)return!r;for(var c=Object(e),n=0;n<r;n++){var i=t[n];if(a[i]!==c[i]||!(i in c))return!1}return!0};var I=function(e,a,t,r){if(e===a)return 0!==e||1/e==1/a;if(null==e||null==a)return e===a;e instanceof g&&(e=e._wrapped),a instanceof g&&(a=a._wrapped);var c=s.call(e);if(c!==s.call(a))return!1;switch(c){case"[object RegExp]":case"[object String]":return""+e==""+a;case"[object Number]":return+e!=+e?+a!=+a:0==+e?1/+e==1/a:+e==+a;case"[object Date]":case"[object Boolean]":return+e==+a}var n="[object Array]"===c;if(!n){if("object"!=typeof e||"object"!=typeof a)return!1;var i=e.constructor,f=a.constructor;if(i!==f&&!(g.isFunction(i)&&i instanceof i&&g.isFunction(f)&&f instanceof f)&&"constructor"in e&&"constructor"in a)return!1}t=t||[],r=r||[];for(var o=t.length;o--;)if(t[o]===e)return r[o]===a;if(t.push(e),r.push(a),n){if((o=e.length)!==a.length)return!1;for(;o--;)if(!I(e[o],a[o],t,r))return!1}else{var d,b=g.keys(e);if(o=b.length,g.keys(a).length!==o)return!1;for(;o--;)if(d=b[o],!g.has(a,d)||!I(e[d],a[d],t,r))return!1}return t.pop(),r.pop(),!0};g.isEqual=function(e,a){return I(e,a)},g.isEmpty=function(e){return null==e||(E(e)&&(g.isArray(e)||g.isString(e)||g.isArguments(e))?0===e.length:0===g.keys(e).length)},g.isElement=function(e){return!(!e||1!==e.nodeType)},g.isArray=u||function(e){return"[object Array]"===s.call(e)},g.isObject=function(e){var a=typeof e;return"function"===a||"object"===a&&!!e},g.each(["Arguments","Function","String","Number","Date","RegExp","Error"],function(e){g["is"+e]=function(a){return s.call(a)==="[object "+e+"]"}}),g.isArguments(arguments)||(g.isArguments=function(e){return g.has(e,"callee")}),"function"!=typeof/./&&"object"!=typeof Int8Array&&(g.isFunction=function(e){return"function"==typeof e||!1}),g.isFinite=function(e){return isFinite(e)&&!isNaN(parseFloat(e))},g.isNaN=function(e){return g.isNumber(e)&&e!==+e},g.isBoolean=function(e){return!0===e||!1===e||"[object Boolean]"===s.call(e)},g.isNull=function(e){return null===e},g.isUndefined=function(e){return void 0===e},g.has=function(e,a){return null!=e&&b.call(e,a)},g.noConflict=function(){return t._=c,this},g.identity=function(e){return e},g.constant=function(e){return function(){return e}},g.noop=function(){},g.property=A,g.propertyOf=function(e){return null==e?function(){}:function(a){return e[a]}},g.matcher=g.matches=function(e){return e=g.extendOwn({},e),function(a){return g.isMatch(a,e)}},g.times=function(e,a,t){var r=Array(Math.max(0,e));a=v(a,t,1);for(var c=0;c<e;c++)r[c]=a(c);return r},g.random=function(e,a){return null==a&&(a=e,e=0),e+Math.floor(Math.random()*(a-e+1))},g.now=Date.now||function(){return(new Date).getTime()};var P={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},F=g.invert(P),L=function(e){var a=function(a){return e[a]},t="(?:"+g.keys(e).join("|")+")",r=RegExp(t),c=RegExp(t,"g");return function(e){return e=null==e?"":""+e,r.test(e)?e.replace(c,a):e}};g.escape=L(P),g.unescape=L(F),g.result=function(e,a,t){var r=null==e?void 0:e[a];return void 0===r&&(r=t),g.isFunction(r)?r.call(e):r};var D=0;g.uniqueId=function(e){var a=++D+"";return e?e+a:a},g.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var z=/(.)^/,q={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},U=/\\|'|\r|\n|\u2028|\u2029/g,H=function(e){return"\\"+q[e]};g.template=function(e,a,t){!a&&t&&(a=t),a=g.defaults({},a,g.templateSettings);var r=RegExp([(a.escape||z).source,(a.interpolate||z).source,(a.evaluate||z).source].join("|")+"|$","g"),c=0,n="__p+='";e.replace(r,function(a,t,r,i,f){return n+=e.slice(c,f).replace(U,H),c=f+a.length,t?n+="'+\n((__t=("+t+"))==null?'':_.escape(__t))+\n'":r?n+="'+\n((__t=("+r+"))==null?'':__t)+\n'":i&&(n+="';\n"+i+"\n__p+='"),a}),n+="';\n",a.variable||(n="with(obj||{}){\n"+n+"}\n"),n="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+n+"return __p;\n";try{var i=new Function(a.variable||"obj","_",n)}catch(e){throw e.source=n,e}var f=function(e){return i.call(this,e,g)},o=a.variable||"obj";return f.source="function("+o+"){\n"+n+"}",f},g.chain=function(e){var a=g(e);return a._chain=!0,a};var V=function(e,a){return e._chain?g(a).chain():a};g.mixin=function(e){g.each(g.functions(e),function(a){var t=g[a]=e[a];g.prototype[a]=function(){var e=[this._wrapped];return o.apply(e,arguments),V(this,t.apply(g,e))}})},g.mixin(g),g.each(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var a=n[e];g.prototype[e]=function(){var t=this._wrapped;return a.apply(t,arguments),"shift"!==e&&"splice"!==e||0!==t.length||delete t[0],V(this,t)}}),g.each(["concat","join","slice"],function(e){var a=n[e];g.prototype[e]=function(){return V(this,a.apply(this._wrapped,arguments))}}),g.prototype.value=function(){return this._wrapped},g.prototype.valueOf=g.prototype.toJSON=g.prototype.value,g.prototype.toString=function(){return""+this._wrapped},void 0===(r=function(){return g}.apply(a,[]))||(e.exports=r)}).call(this)},function(e,a,t){"use strict";var r=t(825),c=t(824);e.exports={errors:r,formatters:c}},function(e,a){e.exports=function(e,a,t){var r=e.length;a=null==a?0:a<0?Math.max(r+a,0):Math.min(a,r),t=null==t?r:t<0?Math.max(r+t,0):Math.min(t,r);for(var c=[];a<t;)c.push(e[a++]);return c}},function(e,a,t){"use strict";var r=a;r.version=t(1010).version,r.utils=t(1009),r.rand=t(1008),r.curve=t(119),r.curves=t(1003),r.ec=t(995),r.eddsa=t(991)},function(e,a){e.exports=__webpack_require__(70)},function(e,a){e.exports=function(e){return e.webpackPolyfill||(e.deprecate=function(){},e.paths=[],e.children||(e.children=[]),Object.defineProperty(e,"loaded",{enumerable:!0,get:function(){return e.l}}),Object.defineProperty(e,"id",{enumerable:!0,get:function(){return e.i}}),e.webpackPolyfill=1),e}},function(e,a,t){e.exports={mkdirs:t(163),mkdirsSync:t(162),mkdirp:t(163),mkdirpSync:t(162),ensureDir:t(163),ensureDirSync:t(162)}},function(e,a,t){var r=t(20),c=t(823),n=t(320),i=t(821),f=t(820),o=function(e){if(!n.isHexStrict(e))throw new Error("The parameter must be a valid HEX string.");var a="",t=0,r=e.length;for("0x"===e.substring(0,2)&&(t=2);t<r;t+=2){var c=parseInt(e.substr(t,2),16);a+=String.fromCharCode(c)}return a},d=function(e){if(!e)return"0x00";for(var a="",t=0;t<e.length;t++){var r=e.charCodeAt(t).toString(16);a+=r.length<2?"0"+r:r}return"0x"+a},s=function(e){if(e=e?e.toLowerCase():"ether",!c.unitMap[e])throw new Error('This unit "'+e+"\" doesn't exist, please use the one of the following units"+JSON.stringify(c.unitMap,null,2));return e};e.exports={_fireError:function(e,a,t,c){return!r.isObject(e)||e instanceof Error||!e.data||((r.isObject(e.data)||r.isArray(e.data))&&(e.data=JSON.stringify(e.data,null,2)),e=e.message+"\n"+e.data),r.isString(e)&&(e=new Error(e)),r.isFunction(c)&&c(e),r.isFunction(t)&&((a&&r.isFunction(a.listeners)&&a.listeners("error").length||r.isFunction(c))&&a.catch(function(){}),setTimeout(function(){t(e)},1)),a&&r.isFunction(a.emit)&&setTimeout(function(){a.emit("error",e),a.removeAllListeners()},1),a},_jsonInterfaceMethodToString:function(e){if(r.isObject(e)&&e.name&&-1!==e.name.indexOf("("))return e.name;var a=e.inputs.map(function(e){return e.type}).join(",");return e.name+"("+a+")"},randomHex:f,_:r,BN:n.BN,isBN:n.isBN,isBigNumber:n.isBigNumber,isHex:n.isHex,isHexStrict:n.isHexStrict,sha3:n.sha3,keccak256:n.sha3,soliditySha3:i,isAddress:n.isAddress,checkAddressChecksum:n.checkAddressChecksum,toChecksumAddress:function(e){if(void 0===e)return"";if(!/^(0x)?[0-9a-f]{40}$/i.test(e))throw new Error('Given address "'+e+'" is not a valid Ethereum address.');e=e.toLowerCase().replace(/^0x/i,"");for(var a=n.sha3(e).replace(/^0x/i,""),t="0x",r=0;r<e.length;r++)parseInt(a[r],16)>7?t+=e[r].toUpperCase():t+=e[r];return t},toHex:n.toHex,toBN:n.toBN,bytesToHex:n.bytesToHex,hexToBytes:n.hexToBytes,hexToNumberString:n.hexToNumberString,hexToNumber:n.hexToNumber,toDecimal:n.hexToNumber,numberToHex:n.numberToHex,fromDecimal:n.numberToHex,hexToUtf8:n.hexToUtf8,hexToString:n.hexToUtf8,toUtf8:n.hexToUtf8,utf8ToHex:n.utf8ToHex,stringToHex:n.utf8ToHex,fromUtf8:n.utf8ToHex,hexToAscii:o,toAscii:o,asciiToHex:d,fromAscii:d,unitMap:c.unitMap,toWei:function(e,a){if(a=s(a),!n.isBN(e)&&!r.isString(e))throw new Error("Please pass numbers as strings or BigNumber objects to avoid precision errors.");return n.isBN(e)?c.toWei(e,a):c.toWei(e,a).toString(10)},fromWei:function(e,a){if(a=s(a),!n.isBN(e)&&!r.isString(e))throw new Error("Please pass numbers as strings or BigNumber objects to avoid precision errors.");return n.isBN(e)?c.fromWei(e,a):c.fromWei(e,a).toString(10)},padLeft:n.leftPad,leftPad:n.leftPad,padRight:n.rightPad,rightPad:n.rightPad,toTwosComplement:n.toTwosComplement}},function(e,a){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,a,t){var r=t(173);r.genesisState=t(890),r.bootstrapNodes=t(889),e.exports=r},function(e,a,t){e.exports=t(10).createHash},function(e,a,t){var r=t(35),c=Array.isArray||function(e){return r(e,"Array")};e.exports=c},function(e,a){e.exports=__webpack_require__(8)},function(e,a,t){"use strict";e.exports={ERROR:{OUT_OF_GAS:"out of gas",STACK_UNDERFLOW:"stack underflow",STACK_OVERFLOW:"stack overflow",INVALID_JUMP:"invalid JUMP",INVALID_OPCODE:"invalid opcode",REVERT:"revert",STATIC_STATE_CHANGE:"static state change",INTERNAL_ERROR:"internal error"},VmError:function(e){this.error=e}}},function(e,a,t){"use strict";var r,c,n=t(67),i=n.freeze,f=t(12),o=f.inherits,d=f.notEnumerableProp;function s(e,a){function t(r){if(!(this instanceof t))return new t(r);d(this,"message","string"==typeof r?r:a),d(this,"name",e),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):Error.call(this)}return o(t,Error),t}var b=s("Warning","warning"),u=s("CancellationError","cancellation error"),l=s("TimeoutError","timeout error"),p=s("AggregateError","aggregate error");try{r=TypeError,c=RangeError}catch(e){r=s("TypeError","type error"),c=s("RangeError","range error")}for(var h="join pop push shift unshift slice filter forEach some every map indexOf lastIndexOf reduce reduceRight sort reverse".split(" "),m=0;m<h.length;++m)"function"==typeof Array.prototype[h[m]]&&(p.prototype[h[m]]=Array.prototype[h[m]]);n.defineProperty(p.prototype,"length",{value:0,configurable:!1,writable:!0,enumerable:!0}),p.prototype.isOperational=!0;var g=0;function v(e){if(!(this instanceof v))return new v(e);d(this,"name","OperationalError"),d(this,"message",e),this.cause=e,this.isOperational=!0,e instanceof Error?(d(this,"message",e.message),d(this,"stack",e.stack)):Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}p.prototype.toString=function(){var e=Array(4*g+1).join(" "),a="\n"+e+"AggregateError of:\n";g++,e=Array(4*g+1).join(" ");for(var t=0;t<this.length;++t){for(var r=this[t]===this?"[Circular AggregateError]":this[t]+"",c=r.split("\n"),n=0;n<c.length;++n)c[n]=e+c[n];a+=(r=c.join("\n"))+"\n"}return g--,a},o(v,Error);var y=Error.__BluebirdErrorTypes__;y||(y=i({CancellationError:u,TimeoutError:l,OperationalError:v,RejectionError:v,AggregateError:p}),d(Error,"__BluebirdErrorTypes__",y)),e.exports={Error:Error,TypeError:r,RangeError:c,CancellationError:y.CancellationError,OperationalError:y.OperationalError,TimeoutError:y.TimeoutError,AggregateError:y.AggregateError,Warning:b}},function(e,a,t){var r=t(76);e.exports=function(e,a){return r(e)===a}},function(e,a,t){var r=t(20),c=t(27),n=t(9),i=t(306),f=function(e){return r.isNumber(e)&&(e=Math.trunc(e)),new i(c.toTwosComplement(e).replace("0x",""))};e.exports={formatInputInt:f,formatInputBytes:function(e){if(!c.isHexStrict(e))throw new Error('Given parameter is not bytes: "'+e+'"');var a=e.replace(/^0x/i,"");if(a.length%2!=0)throw new Error('Given parameter bytes has an invalid length: "'+e+'"');if(a.length>64)throw new Error('Given parameter bytes is too long: "'+e+'"');var t=Math.floor((a.length+63)/64);return a=c.padRight(a,64*t),new i(a)},formatInputDynamicBytes:function(e){if(!c.isHexStrict(e))throw new Error('Given parameter is not bytes: "'+e+'"');var a=e.replace(/^0x/i,"");if(a.length%2!=0)throw new Error('Given parameter bytes has an invalid length: "'+e+'"');var t=a.length/2,r=Math.floor((a.length+63)/64);return a=c.padRight(a,64*r),new i(f(t).value+a)},formatInputString:function(e){if(!r.isString(e))throw new Error("Given parameter is not a valid string: "+e);var a=c.utf8ToHex(e).replace(/^0x/i,""),t=a.length/2,n=Math.floor((a.length+63)/64);return a=c.padRight(a,64*n),new i(f(t).value+a)},formatInputBool:function(e){return new i("000000000000000000000000000000000000000000000000000000000000000"+(e?"1":"0"))},formatOutputInt:function(e){var a=e.staticPart();if(!a&&!e.rawValue)throw new Error("Couldn't decode "+name+" from ABI: 0x"+e.rawValue);return function(e){return"1"===new n(e.substr(0,1),16).toString(2).substr(0,1)}(a)?new n(a,16).fromTwos(256).toString(10):new n(a,16).toString(10)},formatOutputUInt:function(e,a){var t=e.staticPart();if(!t&&!e.rawValue)throw new Error("Couldn't decode "+a+" from ABI: 0x"+e.rawValue);return new n(t,16).toString(10)},formatOutputBool:function(e,a){var t=e.staticPart();if(!t&&!e.rawValue)throw new Error("Couldn't decode "+a+" from ABI: 0x"+e.rawValue);return"0000000000000000000000000000000000000000000000000000000000000001"===t},formatOutputBytes:function(e,a){var t=a.match(/^bytes([0-9]*)/),r=parseInt(t[1]);if(e.staticPart().slice(0,2*r).length!==2*r)throw new Error("Couldn't decode "+a+" from ABI: 0x"+e.rawValue+" The size doesn't match.");return"0x"+e.staticPart().slice(0,2*r)},formatOutputDynamicBytes:function(e,a){var t=e.dynamicPart().slice(0,64);if(!t)throw new Error("Couldn't decode "+a+" from ABI: 0x"+e.rawValue);var r=2*new n(t,16).toNumber();return"0x"+e.dynamicPart().substr(64,r)},formatOutputString:function(e){var a=e.dynamicPart().slice(0,64);if(!a)throw new Error("ERROR: The returned value is not a convertible string:"+a);var t=2*new n(a,16).toNumber();return t?c.hexToUtf8("0x"+e.dynamicPart().substr(64,t).replace(/^0x/i,"")):""},formatOutputAddress:function(e,a){var t=e.staticPart();if(!t)throw new Error("Couldn't decode "+a+" from ABI: 0x"+e.rawValue);return c.toChecksumAddress("0x"+t.slice(t.length-40,t.length))},toTwosComplement:c.toTwosComplement}},function(e,a,t){"use strict";var r=t(46),c=t(0);function n(e){return(e>>>24|e>>>8&65280|e<<8&16711680|(255&e)<<24)>>>0}function i(e){return 1===e.length?"0"+e:e}function f(e){return 7===e.length?"0"+e:6===e.length?"00"+e:5===e.length?"000"+e:4===e.length?"0000"+e:3===e.length?"00000"+e:2===e.length?"000000"+e:1===e.length?"0000000"+e:e}a.inherits=c,a.toArray=function(e,a){if(Array.isArray(e))return e.slice();if(!e)return[];var t=[];if("string"==typeof e)if(a){if("hex"===a)for((e=e.replace(/[^a-z0-9]+/gi,"")).length%2!=0&&(e="0"+e),r=0;r<e.length;r+=2)t.push(parseInt(e[r]+e[r+1],16))}else for(var r=0;r<e.length;r++){var c=e.charCodeAt(r),n=c>>8,i=255&c;n?t.push(n,i):t.push(i)}else for(r=0;r<e.length;r++)t[r]=0|e[r];return t},a.toHex=function(e){for(var a="",t=0;t<e.length;t++)a+=i(e[t].toString(16));return a},a.htonl=n,a.toHex32=function(e,a){for(var t="",r=0;r<e.length;r++){var c=e[r];"little"===a&&(c=n(c)),t+=f(c.toString(16))}return t},a.zero2=i,a.zero8=f,a.join32=function(e,a,t,c){var n=t-a;r(n%4==0);for(var i=new Array(n/4),f=0,o=a;f<i.length;f++,o+=4){var d;d="big"===c?e[o]<<24|e[o+1]<<16|e[o+2]<<8|e[o+3]:e[o+3]<<24|e[o+2]<<16|e[o+1]<<8|e[o],i[f]=d>>>0}return i},a.split32=function(e,a){for(var t=new Array(4*e.length),r=0,c=0;r<e.length;r++,c+=4){var n=e[r];"big"===a?(t[c]=n>>>24,t[c+1]=n>>>16&255,t[c+2]=n>>>8&255,t[c+3]=255&n):(t[c+3]=n>>>24,t[c+2]=n>>>16&255,t[c+1]=n>>>8&255,t[c]=255&n)}return t},a.rotr32=function(e,a){return e>>>a|e<<32-a},a.rotl32=function(e,a){return e<<a|e>>>32-a},a.sum32=function(e,a){return e+a>>>0},a.sum32_3=function(e,a,t){return e+a+t>>>0},a.sum32_4=function(e,a,t,r){return e+a+t+r>>>0},a.sum32_5=function(e,a,t,r,c){return e+a+t+r+c>>>0},a.sum64=function(e,a,t,r){var c=e[a],n=r+e[a+1]>>>0,i=(n<r?1:0)+t+c;e[a]=i>>>0,e[a+1]=n},a.sum64_hi=function(e,a,t,r){return(a+r>>>0<a?1:0)+e+t>>>0},a.sum64_lo=function(e,a,t,r){return a+r>>>0},a.sum64_4_hi=function(e,a,t,r,c,n,i,f){var o=0,d=a;return o+=(d=d+r>>>0)<a?1:0,o+=(d=d+n>>>0)<n?1:0,e+t+c+i+(o+=(d=d+f>>>0)<f?1:0)>>>0},a.sum64_4_lo=function(e,a,t,r,c,n,i,f){return a+r+n+f>>>0},a.sum64_5_hi=function(e,a,t,r,c,n,i,f,o,d){var s=0,b=a;return s+=(b=b+r>>>0)<a?1:0,s+=(b=b+n>>>0)<n?1:0,s+=(b=b+f>>>0)<f?1:0,e+t+c+i+o+(s+=(b=b+d>>>0)<d?1:0)>>>0},a.sum64_5_lo=function(e,a,t,r,c,n,i,f,o,d){return a+r+n+f+d>>>0},a.rotr64_hi=function(e,a,t){return(a<<32-t|e>>>t)>>>0},a.rotr64_lo=function(e,a,t){return(e<<32-t|a>>>t)>>>0},a.shr64_hi=function(e,a,t){return e>>>t},a.shr64_lo=function(e,a,t){return(e<<32-t|a>>>t)>>>0}},function(e,a,t){var r=t(22);e.exports=function(e,a,t){return function(){var c=r(arguments);return null==c[0]?t:"number"==typeof c[0].length?e.apply(null,c):a.apply(null,c)}}},function(e,a){e.exports=function(){for(var e={},a=0;a<arguments.length;a++){var r=arguments[a];for(var c in r)t.call(r,c)&&(e[c]=r[c])}return e};var t=Object.prototype.hasOwnProperty},function(e,a,t){"use strict";var r;try{throw new Error}catch(e){r=e}var c=t(498),n=t(497),i=t(12);function f(){this._isTickUsed=!1,this._lateQueue=new n(16),this._normalQueue=new n(16),this._trampolineEnabled=!0;var e=this;this.drainQueues=function(){e._drainQueues()},this._schedule=c.isStatic?c(this.drainQueues):c}function o(e,a,t){this._lateQueue.push(e,a,t),this._queueTick()}function d(e,a,t){this._normalQueue.push(e,a,t),this._queueTick()}function s(e){this._normalQueue._pushOne(e),this._queueTick()}f.prototype.disableTrampolineIfNecessary=function(){i.hasDevTools&&(this._trampolineEnabled=!1)},f.prototype.enableTrampoline=function(){this._trampolineEnabled||(this._trampolineEnabled=!0,this._schedule=function(e){setTimeout(e,0)})},f.prototype.haveItemsQueued=function(){return this._normalQueue.length()>0},f.prototype.throwLater=function(e,a){if(1===arguments.length&&(a=e,e=function(){throw a}),"undefined"!=typeof setTimeout)setTimeout(function(){e(a)},0);else try{this._schedule(function(){e(a)})}catch(e){throw new Error("No async scheduler available\n\n    See http://goo.gl/m3OTXk\n")}},i.hasDevTools?(c.isStatic&&(c=function(e){setTimeout(e,0)}),f.prototype.invokeLater=function(e,a,t){this._trampolineEnabled?o.call(this,e,a,t):this._schedule(function(){setTimeout(function(){e.call(a,t)},100)})},f.prototype.invoke=function(e,a,t){this._trampolineEnabled?d.call(this,e,a,t):this._schedule(function(){e.call(a,t)})},f.prototype.settlePromises=function(e){this._trampolineEnabled?s.call(this,e):this._schedule(function(){e._settlePromises()})}):(f.prototype.invokeLater=o,f.prototype.invoke=d,f.prototype.settlePromises=s),f.prototype.invokeFirst=function(e,a,t){this._normalQueue.unshift(e,a,t),this._queueTick()},f.prototype._drainQueue=function(e){for(;e.length()>0;){var a=e.shift();if("function"==typeof a){var t=e.shift(),r=e.shift();a.call(t,r)}else a._settlePromises()}},f.prototype._drainQueues=function(){this._drainQueue(this._normalQueue),this._reset(),this._drainQueue(this._lateQueue)},f.prototype._queueTick=function(){this._isTickUsed||(this._isTickUsed=!0,this._schedule(this.drainQueues))},f.prototype._reset=function(){this._isTickUsed=!1},e.exports=new f,e.exports.firstLineError=r},function(e,a,t){var r=0,c={},n=c.path=r++,i=c.mode=r++,f=c.uid=r++,o=c.gid=r++,d=c.size=r++,s=c.mtime=r++,b=c.cksum=r++,u=c.type=r++,l=c.linkpath=r++,p=[];p[n]=100,p[i]=8,p[f]=8,p[o]=8,p[d]=12,p[s]=12,p[b]=8,p[u]=1,p[l]=100;var h=c.ustar=r++,m=c.ustarver=r++,g=c.uname=r++,v=c.gname=r++,y=c.devmaj=r++,_=c.devmin=r++,w=c.prefix=r++,A=c.fill=r++;c[r]=null,p[h]=6,p[m]=2,p[g]=32,p[v]=32,p[y]=8,p[_]=8,p[w]=155,p[A]=12;for(var k={},x={},E=0,S=0;S<r;S++)x[S]=E,k[S]=E+=p[S];Object.keys(c).forEach(function(e){null!==c[e]&&(c[c[e]]=e)});var T={0:"File","\0":"OldFile","":"OldFile",1:"Link",2:"SymbolicLink",3:"CharacterDevice",4:"BlockDevice",5:"Directory",6:"FIFO",7:"ContiguousFile",g:"GlobalExtendedHeader",x:"ExtendedHeader",A:"SolarisACL",D:"GNUDumpDir",I:"Inode",K:"NextFileHasLongLinkpath",L:"NextFileHasLongPath",M:"ContinuationFile",N:"OldGnuLongPath",S:"SparseFile",V:"TapeVolumeHeader",X:"OldExtendedHeader"};Object.keys(T).forEach(function(e){T[T[e]]=T[T[e]]||e});var j={suid:2048,sgid:1024,svtx:512,uread:256,uwrite:128,uexec:64,gread:32,gwrite:16,gexec:8,oread:4,owrite:2,oexec:1,all:4095};Object.keys(j).forEach(function(e){j[j[e]]=j[j[e]]||e});a.fields=c,a.fieldSize=p,a.fieldOffs=x,a.fieldEnds=k,a.types=T,a.modes=j,a.numeric={mode:!0,uid:!0,gid:!0,size:!0,mtime:!0,devmaj:!0,devmin:!0,cksum:!0,atime:!0,ctime:!0,dev:!0,ino:!0,nlink:!0},a.headerSize=512,a.blockSize=512,a.knownExtended={atime:!0,charset:!0,comment:!0,ctime:!0,gid:!0,gname:!0,linkpath:!0,mtime:!0,path:!0,realtime:!0,security:!0,size:!0,uid:!0,uname:!0},a.Pack=t(657),a.Parse=t(648),a.Extract=t(645)},function(e,a,t){"use strict";var r,c,n=t(57),i=n.freeze,f=t(13),o=f.inherits,d=f.notEnumerableProp;function s(e,a){function t(r){if(!(this instanceof t))return new t(r);d(this,"message","string"==typeof r?r:a),d(this,"name",e),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):Error.call(this)}return o(t,Error),t}var b=s("Warning","warning"),u=s("CancellationError","cancellation error"),l=s("TimeoutError","timeout error"),p=s("AggregateError","aggregate error");try{r=TypeError,c=RangeError}catch(e){r=s("TypeError","type error"),c=s("RangeError","range error")}for(var h="join pop push shift unshift slice filter forEach some every map indexOf lastIndexOf reduce reduceRight sort reverse".split(" "),m=0;m<h.length;++m)"function"==typeof Array.prototype[h[m]]&&(p.prototype[h[m]]=Array.prototype[h[m]]);n.defineProperty(p.prototype,"length",{value:0,configurable:!1,writable:!0,enumerable:!0}),p.prototype.isOperational=!0;var g=0;function v(e){if(!(this instanceof v))return new v(e);d(this,"name","OperationalError"),d(this,"message",e),this.cause=e,this.isOperational=!0,e instanceof Error?(d(this,"message",e.message),d(this,"stack",e.stack)):Error.captureStackTrace&&Error.captureStackTrace(this,this.constructor)}p.prototype.toString=function(){var e=Array(4*g+1).join(" "),a="\n"+e+"AggregateError of:\n";g++,e=Array(4*g+1).join(" ");for(var t=0;t<this.length;++t){for(var r=this[t]===this?"[Circular AggregateError]":this[t]+"",c=r.split("\n"),n=0;n<c.length;++n)c[n]=e+c[n];a+=(r=c.join("\n"))+"\n"}return g--,a},o(v,Error);var y=Error.__BluebirdErrorTypes__;y||(y=i({CancellationError:u,TimeoutError:l,OperationalError:v,RejectionError:v,AggregateError:p}),n.defineProperty(Error,"__BluebirdErrorTypes__",{value:y,writable:!1,enumerable:!1,configurable:!1})),e.exports={Error:Error,TypeError:r,RangeError:c,CancellationError:y.CancellationError,OperationalError:y.OperationalError,TimeoutError:y.TimeoutError,AggregateError:y.AggregateError,Warning:b}},function(e,a){e.exports=__webpack_require__(27)},function(e,a,t){const r=t(933),c=t(909),n=t(1).inherits,i=t(899);function f(){r.apply(this,arguments),c(this)}e.exports=f,n(f,r),f.prove=i.prove,f.verifyProof=i.verifyProof},function(e,a,t){const r=t(3),c=t(52),n=t(7).Buffer;var i=e.exports=function(e){var a=[{name:"nonce",default:n.alloc(0)},{name:"balance",default:n.alloc(0)},{name:"stateRoot",length:32,default:r.SHA3_RLP},{name:"codeHash",length:32,default:r.SHA3_NULL}];r.defineProperties(this,a,e)};i.prototype.serialize=function(){return c.encode(this.raw)},i.prototype.isContract=function(){return this.codeHash.toString("hex")!==r.SHA3_NULL_S},i.prototype.getCode=function(e,a){this.isContract()?e.getRaw(this.codeHash,a):a(null,n.alloc(0))},i.prototype.setCode=function(e,a,t){var c=this;this.codeHash=r.sha3(a),this.codeHash.toString("hex")!==r.SHA3_NULL_S?e.putRaw(this.codeHash,a,function(e){t(e,c.codeHash)}):t(null,n.alloc(0))},i.prototype.getStorage=function(e,a,t){var r=e.copy();r.root=this.stateRoot,r.get(a,t)},i.prototype.setStorage=function(e,a,t,r){var c=this,n=e.copy();n.root=c.stateRoot,n.put(a,t,function(e){if(e)return r();c.stateRoot=n.root,r()})},i.prototype.isEmpty=function(){return""===this.balance.toString("hex")&&""===this.nonce.toString("hex")&&this.stateRoot.toString("hex")===r.SHA3_RLP_S&&this.codeHash.toString("hex")===r.SHA3_NULL_S}},function(e,a){function t(e,a){if(!e)throw new Error(a||"Assertion failed")}e.exports=t,t.equal=function(e,a,t){if(e!=a)throw new Error(t||"Assertion failed: "+e+" != "+a)}},function(e,a){e.exports=function(e,a,t){if(null!=e)for(var r=-1,c=e.length;++r<c&&!1!==a.call(t,e[r],r,e););}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){a=r(a,t);var c=[];if(null==e)return c;for(var n,i=-1,f=e.length;++i<f;)a(n=e[i],i,e)&&c.push(n);return c}},function(e,a,t){var r=t(36),c=t(306),n=function(e){this._inputFormatter=e.inputFormatter,this._outputFormatter=e.outputFormatter};n.prototype.isType=function(e){throw"This method should be overwritten for type "+e},n.prototype.staticPartLength=function(e){return(this.nestedTypes(e)||["[1]"]).map(function(e){return parseInt(e.slice(1,-1),10)||1}).reduce(function(e,a){return e*a},32)},n.prototype.isDynamicArray=function(e){var a=this.nestedTypes(e);return!!a&&!a[a.length-1].match(/[0-9]{1,}/g)},n.prototype.isStaticArray=function(e){var a=this.nestedTypes(e);return!!a&&!!a[a.length-1].match(/[0-9]{1,}/g)},n.prototype.staticArrayLength=function(e){var a=this.nestedTypes(e);return a?parseInt(a[a.length-1].match(/[0-9]{1,}/g)||1):1},n.prototype.nestedName=function(e){var a=this.nestedTypes(e);return a?e.substr(0,e.length-a[a.length-1].length):e},n.prototype.isDynamicType=function(){return!1},n.prototype.nestedTypes=function(e){return e.match(/(\[[0-9]*\])/g)},n.prototype.encode=function(e,a){var t=this;return this.isDynamicArray(a)?function(){var c=e.length,n=t.nestedName(a),i=[];return i.push(r.formatInputInt(c).encode()),e.forEach(function(e){i.push(t.encode(e,n))}),i}():this.isStaticArray(a)?function(){for(var r=t.staticArrayLength(a),c=t.nestedName(a),n=[],i=0;i<r;i++)n.push(t.encode(e[i],c));return n}():this._inputFormatter(e,a).encode()},n.prototype.decode=function(e,a,t){var r=this;if(this.isDynamicArray(t))return function(){for(var c=parseInt("0x"+e.substr(2*a,64)),n=parseInt("0x"+e.substr(2*c,64)),i=c+32,f=r.nestedName(t),o=r.staticPartLength(f),d=32*Math.floor((o+31)/32),s=[],b=0;b<n*d;b+=d)s.push(r.decode(e,i+b,f));return s}();if(this.isStaticArray(t))return function(){for(var c=r.staticArrayLength(t),n=a,i=r.nestedName(t),f=r.staticPartLength(i),o=32*Math.floor((f+31)/32),d=[],s=0;s<c*o;s+=o)d.push(r.decode(e,n+s,i));return d}();if(this.isDynamicType(t))return function(){var n=parseInt("0x"+e.substr(2*a,64)),i=parseInt("0x"+e.substr(2*n,64)),f=Math.floor((i+31)/32),o=new c(e.substr(2*n,64*(1+f)),0,e);return r._outputFormatter(o,t)}();var n=this.staticPartLength(t),i=new c(e.substr(2*a,2*n),void 0,e);return this._outputFormatter(i,t)},e.exports=n},function(e,a,t){"use strict";var r=t(20),c=t(21).errors,n=t(21).formatters,i=t(27),f=t(310),o=t(114).subscriptions,d=function(e){if(!e.call||!e.name)throw new Error('When creating a method you need to provide at least the "name" and "call" property.');this.name=e.name,this.call=e.call,this.params=e.params||0,this.inputFormatter=e.inputFormatter,this.outputFormatter=e.outputFormatter,this.transformPayload=e.transformPayload,this.extraFormatters=e.extraFormatters,this.requestManager=e.requestManager,this.accounts=e.accounts,this.defaultBlock=e.defaultBlock||"latest",this.defaultAccount=e.defaultAccount||null};d.prototype.setRequestManager=function(e,a){this.requestManager=e,a&&(this.accounts=a)},d.prototype.createFunction=function(e,a){var t=this.buildCall();return t.call=this.call,this.setRequestManager(e||this.requestManager,a||this.accounts),t},d.prototype.attachToObject=function(e){var a=this.buildCall();a.call=this.call;var t=this.name.split(".");t.length>1?(e[t[0]]=e[t[0]]||{},e[t[0]][t[1]]=a):e[t[0]]=a},d.prototype.getCall=function(e){return r.isFunction(this.call)?this.call(e):this.call},d.prototype.extractCallback=function(e){if(r.isFunction(e[e.length-1]))return e.pop()},d.prototype.validateArgs=function(e){if(e.length!==this.params)throw c.InvalidNumberOfParams(e.length,this.params,this.name)},d.prototype.formatInput=function(e){var a=this;return this.inputFormatter?this.inputFormatter.map(function(t,r){return t?t.call(a,e[r]):e[r]}):e},d.prototype.formatOutput=function(e){var a=this;return r.isArray(e)?e.map(function(e){return a.outputFormatter&&e?a.outputFormatter(e):e}):this.outputFormatter&&e?this.outputFormatter(e):e},d.prototype.toPayload=function(e){var a=this.getCall(e),t=this.extractCallback(e),r=this.formatInput(e);this.validateArgs(r);var c={method:a,params:r,callback:t};return this.transformPayload&&(c=this.transformPayload(c)),c},d.prototype._confirmTransaction=function(e,a,t){var c=this,s=!1,b=!0,u=0,l=0,p=null,h=r.isObject(t.params[0])&&t.params[0].gas?t.params[0].gas:null,m=r.isObject(t.params[0])&&t.params[0].data&&t.params[0].from&&!t.params[0].to,g=[new d({name:"getTransactionReceipt",call:"eth_getTransactionReceipt",params:1,inputFormatter:[null],outputFormatter:n.outputTransactionReceiptFormatter}),new d({name:"getCode",call:"eth_getCode",params:2,inputFormatter:[n.inputAddressFormatter,n.inputDefaultBlockNumberFormatter]}),new o({name:"subscribe",type:"eth",subscriptions:{newBlockHeaders:{subscriptionName:"newHeads",params:0,outputFormatter:n.outputBlockFormatter}}})],v={};r.each(g,function(e){e.attachToObject(v),e.requestManager=c.requestManager});var y=function(t,r,n,o,d){if(!n)return d||(d={unsubscribe:function(){clearInterval(p)}}),(t?f.resolve(t):v.getTransactionReceipt(a)).catch(function(a){d.unsubscribe(),s=!0,i._fireError({message:"Failed to check for transaction receipt:",data:a},e.eventEmitter,e.reject)}).then(function(a){if(!a||!a.blockHash)throw new Error("Receipt missing or blockHash null");return c.extraFormatters&&c.extraFormatters.receiptFormatter&&(a=c.extraFormatters.receiptFormatter(a)),e.eventEmitter.listeners("confirmation").length>0&&(void 0!==t&&0===l||e.eventEmitter.emit("confirmation",l,a),b=!1,25===++l&&(d.unsubscribe(),e.eventEmitter.removeAllListeners())),a}).then(function(a){if(m&&!s){if(!a.contractAddress)return b&&(d.unsubscribe(),s=!0),void i._fireError(new Error("The transaction receipt didn't contain a contract address."),e.eventEmitter,e.reject);v.getCode(a.contractAddress,function(t,r){r&&(r.length>2?(e.eventEmitter.emit("receipt",a),c.extraFormatters&&c.extraFormatters.contractDeployFormatter?e.resolve(c.extraFormatters.contractDeployFormatter(a)):e.resolve(a),b&&e.eventEmitter.removeAllListeners()):i._fireError(new Error("The contract code couldn't be stored, please check your gas limit."),e.eventEmitter,e.reject),b&&d.unsubscribe(),s=!0)})}return a}).then(function(a){m||s||(a.outOfGas||h&&h===a.gasUsed||!0!==a.status&&"0x1"!==a.status&&void 0!==a.status?(a&&(a=JSON.stringify(a,null,2)),!1===a.status||"0x0"===a.status?i._fireError(new Error("Transaction has been reverted by the EVM:\n"+a),e.eventEmitter,e.reject):i._fireError(new Error("Transaction ran out of gas. Please provide more gas:\n"+a),e.eventEmitter,e.reject)):(e.eventEmitter.emit("receipt",a),e.resolve(a),b&&e.eventEmitter.removeAllListeners()),b&&d.unsubscribe(),s=!0)}).catch(function(){u++,r?u-1>=750&&(d.unsubscribe(),s=!0,i._fireError(new Error("Transaction was not mined within750 seconds, please make sure your transaction was properly sent. Be aware that it might still be mined!"),e.eventEmitter,e.reject)):u-1>=50&&(d.unsubscribe(),s=!0,i._fireError(new Error("Transaction was not mined within 50 blocks, please make sure your transaction was properly sent. Be aware that it might still be mined!"),e.eventEmitter,e.reject))});d.unsubscribe(),s=!0,i._fireError({message:"Failed to subscribe to new newBlockHeaders to confirm the transaction receipts.",data:n},e.eventEmitter,e.reject)},_=function(e){r.isFunction(this.requestManager.provider.on)?v.subscribe("newBlockHeaders",y.bind(null,e,!1)):p=setInterval(y.bind(null,e,!0),1e3)}.bind(this);v.getTransactionReceipt(a).then(function(a){a&&a.blockHash?(e.eventEmitter.listeners("confirmation").length>0&&_(a),y(a,!1)):s||_()}).catch(function(){s||_()})};var s=function(e,a){return r.isNumber(e)?a.wallet[e]:r.isObject(e)&&e.address&&e.privateKey?e:a.wallet[e.toLowerCase()]};d.prototype.buildCall=function(){var e=this,a="eth_sendTransaction"===e.call||"eth_sendRawTransaction"===e.call,t=function(){var t=f(!a),c=e.toPayload(Array.prototype.slice.call(arguments)),n=function(r,n){try{n=e.formatOutput(n)}catch(e){r=e}if(n instanceof Error&&(r=n),r)return r.error&&(r=r.error),i._fireError(r,t.eventEmitter,t.reject,c.callback);c.callback&&c.callback(null,n),a?(t.eventEmitter.emit("transactionHash",n),e._confirmTransaction(t,n,c)):r||t.resolve(n)},o=function(a){var t=r.extend({},c,{method:"eth_sendRawTransaction",params:[a.rawTransaction]});e.requestManager.send(t,n)},b=function(e,a){var c;if(a&&a.accounts&&a.accounts.wallet&&a.accounts.wallet.length)if("eth_sendTransaction"===e.method){var i=e.params[0];if((c=s(r.isObject(i)?i.from:null,a.accounts))&&c.privateKey)return a.accounts.signTransaction(r.omit(i,"from"),c.privateKey).then(o)}else if("eth_sign"===e.method){var f=e.params[1];if((c=s(e.params[0],a.accounts))&&c.privateKey){var d=a.accounts.sign(f,c.privateKey);return e.callback&&e.callback(null,d.signature),void t.resolve(d.signature)}}return a.requestManager.send(e,n)};a&&r.isObject(c.params[0])&&!c.params[0].gasPrice?new d({name:"getGasPrice",call:"eth_gasPrice",params:0}).createFunction(e.requestManager)(function(a,t){t&&(c.params[0].gasPrice=t),b(c,e)}):b(c,e);return t.eventEmitter};return t.method=e,t.request=this.request.bind(this),t},d.prototype.request=function(){var e=this.toPayload(Array.prototype.slice.call(arguments));return e.format=this.formatOutput.bind(this),e},e.exports=d},function(e,a,t){"use strict";var r=t(826),c=t(788);e.exports={packageInit:function(e,a){if(a=Array.prototype.slice.call(a),!e)throw new Error('You need to instantiate using the "new" keyword.');Object.defineProperty(e,"currentProvider",{get:function(){return e._provider},set:function(a){return e.setProvider(a)},enumerable:!0,configurable:!0}),a[0]&&a[0]._requestManager?e._requestManager=new r.Manager(a[0].currentProvider):(e._requestManager=new r.Manager,e._requestManager.setProvider(a[0],a[1])),e.givenProvider=r.Manager.givenProvider,e.providers=r.Manager.providers,e._provider=e._requestManager.provider,e.setProvider||(e.setProvider=function(a,t){return e._requestManager.setProvider(a,t),e._provider=e._requestManager.provider,!0}),e.BatchRequest=r.BatchManager.bind(null,e._requestManager),e.extend=c(e)},addProviders:function(e){e.givenProvider=r.Manager.givenProvider,e.providers=r.Manager.providers}}},function(e,a,t){const r=t(11);function c(e,a){if("00"===e.slice(0,2))throw new Error("invalid RLP: extra zeros");return parseInt(e,a)}function n(e,a){if(e<56)return new Buffer([e+a]);var t=f(e),r=f(a+55+t.length/2);return new Buffer(r+t,"hex")}function i(e){return"0x"===e.slice(0,2)}function f(e){var a=e.toString(16);return a.length%2&&(a="0"+a),a}function o(e){if(!Buffer.isBuffer(e))if("string"==typeof e)e=i(e)?new Buffer(function(e){return e.length%2&&(e="0"+e),e}(function(e){return"string"!=typeof e?e:i(e)?e.slice(2):e}(e)),"hex"):new Buffer(e);else if("number"==typeof e)e=e?function(e){var a=f(e);return new Buffer(a,"hex")}(e):new Buffer([]);else if(null===e||void 0===e)e=new Buffer([]);else{if(!e.toArray)throw new Error("invalid type");e=new Buffer(e.toArray())}return e}a.encode=function(e){if(e instanceof Array){for(var t=[],r=0;r<e.length;r++)t.push(a.encode(e[r]));var c=Buffer.concat(t);return Buffer.concat([n(c.length,192),c])}return 1===(e=o(e)).length&&e[0]<128?e:Buffer.concat([n(e.length,128),e])},a.decode=function(e,a){if(!e||0===e.length)return new Buffer([]);var t=function e(a){var t,r,n,i,f;var o=[];var d=a[0];if(d<=127)return{data:a.slice(0,1),remainder:a.slice(1)};if(d<=183){if(t=d-127,n=128===d?new Buffer([]):a.slice(1,t),2===t&&n[0]<128)throw new Error("invalid rlp encoding: byte must be less 0x80");return{data:n,remainder:a.slice(t)}}if(d<=191){if(r=d-182,t=c(a.slice(1,r).toString("hex"),16),(n=a.slice(r,t+r)).length<t)throw new Error("invalid RLP");return{data:n,remainder:a.slice(t+r)}}if(d<=247){for(t=d-191,i=a.slice(1,t);i.length;)f=e(i),o.push(f.data),i=f.remainder;return{data:o,remainder:a.slice(t)}}r=d-246,t=c(a.slice(1,r).toString("hex"),16);var s=r+t;if(s>a.length)throw new Error("invalid rlp: total length is larger than the data");if(0===(i=a.slice(r,s)).length)throw new Error("invalid rlp, List has a invalid length");for(;i.length;)f=e(i),o.push(f.data),i=f.remainder;return{data:o,remainder:a.slice(s)}}(e=o(e));return a?t:(r.equal(t.remainder.length,0,"invalid remainder"),t.data)},a.getLength=function(e){if(!e||0===e.length)return new Buffer([]);var a=(e=o(e))[0];if(a<=127)return e.length;if(a<=183)return a-127;if(a<=191)return a-182;if(a<=247)return a-191;var t=a-246;return t+c(e.slice(1,t).toString("hex"),16)}},function(e,a){e.exports=function(e){return!!e&&"object"==typeof e&&e.constructor===Object}},function(e,a,t){var r=t(75);e.exports=function(e,a){return-1!==r(e,a)}},function(e,a){e.exports=function(e,a){return Object.prototype.hasOwnProperty.call(e,a)}},function(e,a,t){e.exports=b;var r=t(8),c=t(6).Stream,n=t(0),i=t(2),f=t(109),o=b.hardLinks={},d=t(159);n(b,d);var s=t(277);function b(e,a){var r,c;if(!(this instanceof b))return new b(e,a);switch("string"==typeof e&&(e={path:e}),e.type&&"function"==typeof e.type?c=r=e.type:(r=f(e),c=b),a&&!r&&(e[r=f(a)]=!0,e.type=r),r){case"Directory":c=t(276);break;case"Link":case"File":c=t(275);break;case"SymbolicLink":c=s;break;case"Socket":c=t(656);break;case null:c=t(274)}if(!(this instanceof c))return new c(e);d.call(this),e.path||this.error("Must provide a path",null,!0),this.readable=!0,this.writable=!1,this.type=r,this.props=e,this.depth=e.depth=e.depth||0,this.parent=e.parent||null,this.root=e.root||e.parent&&e.parent.root||this,this._path=this.path=i.resolve(e.path),"win32"===process.platform&&(this.path=this._path=this.path.replace(/\?/g,"_"),this._path.length>=260&&(this._swallowErrors=!0,this._path="\\\\?\\"+this.path.replace(/\//g,"\\"))),this.basename=e.basename=i.basename(this.path),this.dirname=e.dirname=i.dirname(this.path),e.parent=e.root=null,this.size=e.size,this.filter="function"==typeof e.filter?e.filter:null,"alpha"===e.sort&&(e.sort=u),this._stat(a)}function u(e,a){return e===a?0:e.toLowerCase()>a.toLowerCase()?1:e.toLowerCase()<a.toLowerCase()?-1:e>a?1:-1}b.prototype._stat=function(e){var a=this,t=a.props,c=t.follow?"stat":"lstat";function n(e,r){if(e)return a.error(e);if(Object.keys(r).forEach(function(e){t[e]=r[e]}),void 0!==a.size&&t.size!==a.size)return a.error("incorrect size");a.size=t.size;var c=f(t);if(!1!==t.hardlinks&&"Directory"!==c&&t.nlink&&t.nlink>1){var n=t.dev+":"+t.ino;o[n]!==a._path&&o[n]?(c=a.type=a.props.type="Link",a.Link=a.props.Link=!0,a.linkpath=a.props.linkpath=o[n],a._stat=a._read=s.prototype._read):o[n]=a._path}if(a.type&&a.type!==c&&a.error("Unexpected type: "+c),a.filter){var i=a._proxy||a;if(!a.filter.call(i,i,t))return void(a._disowned||(a.abort(),a.emit("end"),a.emit("close")))}var d=["_stat","stat","ready"],b=0;!function e(){if(a._aborted)return a.emit("end"),void a.emit("close");if(a._paused&&"Directory"!==a.type)a.once("resume",e);else{var r=d[b++];if(!r)return a._read();a.emit(r,t),e()}}()}e?process.nextTick(n.bind(null,null,e)):r[c](a._path,n)},b.prototype.pipe=function(e){var a=this;return"function"==typeof e.add&&a.on("entry",function(t){!1===e.add(t)&&a.pause()}),c.prototype.pipe.apply(this,arguments)},b.prototype.pause=function(e){this._paused=!0,e=e||this,this.emit("pause",e),this._stream&&this._stream.pause(e)},b.prototype.resume=function(e){this._paused=!1,e=e||this,this.emit("resume",e),this._stream&&this._stream.resume(e),this._read()},b.prototype._read=function(){this.error("Cannot read unknown type: "+this.type)}},function(e,a){var t=function(){"use strict";return void 0===this}();if(t)e.exports={freeze:Object.freeze,defineProperty:Object.defineProperty,getDescriptor:Object.getOwnPropertyDescriptor,keys:Object.keys,names:Object.getOwnPropertyNames,getPrototypeOf:Object.getPrototypeOf,isArray:Array.isArray,isES5:t,propertyIsWritable:function(e,a){var t=Object.getOwnPropertyDescriptor(e,a);return!(t&&!t.writable&&!t.set)}};else{var r={}.hasOwnProperty,c={}.toString,n={}.constructor.prototype,i=function(e){var a=[];for(var t in e)r.call(e,t)&&a.push(t);return a};e.exports={isArray:function(e){try{return"[object Array]"===c.call(e)}catch(e){return!1}},keys:i,names:i,defineProperty:function(e,a,t){return e[a]=t.value,e},getDescriptor:function(e,a){return{value:e[a]}},freeze:function(e){return e},getPrototypeOf:function(e){try{return Object(e).constructor.prototype}catch(e){return n}},isES5:t,propertyIsWritable:function(){return!0}}}},function(e,a){e.exports=__webpack_require__(141)},function(e,a){e.exports=__webpack_require__(45)},function(e,a){(function(a){e.exports=a}).call(this,{})},function(e,a,t){const r=t(177);function c(e,a){for(var t=0;e[t]===a[t]&&e.length>t;)t++;return t}e.exports={matchingNibbleLength:c,callTogether:function(){var e=arguments,a=e.length,t=a;if(!a)return function(){};return function(){for(a=t;a--;){var r=e[a];if("function"==typeof r)var c=e[a].apply(this,arguments)}return c}},asyncFirstSeries:function(e,a,t){var c=!1;r.eachSeries(e,function(e,r){if(c)return r;a(e,function(e,a){a&&(c=!0,process.nextTick(t.bind(null,null,a))),r(e)})},function(){c||t()})},doKeysMatch:function(e,a){var t=c(e,a);return t===e.length&&t===a.length}}},function(e,a,t){"use strict";var r=t(118),c=Object.keys||function(e){var a=[];for(var t in e)a.push(t);return a};e.exports=b;var n=t(17);n.inherits=t(0);var i=t(342),f=t(339);n.inherits(b,i);for(var o=c(f.prototype),d=0;d<o.length;d++){var s=o[d];b.prototype[s]||(b.prototype[s]=f.prototype[s])}function b(e){if(!(this instanceof b))return new b(e);i.call(this,e),f.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",u)}function u(){this.allowHalfOpen||this._writableState.ended||r.nextTick(l,this)}function l(e){e.end()}Object.defineProperty(b.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),Object.defineProperty(b.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&void 0!==this._writableState&&(this._readableState.destroyed&&this._writableState.destroyed)},set:function(e){void 0!==this._readableState&&void 0!==this._writableState&&(this._readableState.destroyed=e,this._writableState.destroyed=e)}}),b.prototype._destroy=function(e,a){this.push(null),this.end(),r.nextTick(a,e)}},function(e,a,t){var r=t(24).Buffer,c=r.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};var n=a.StringDecoder=function(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),function(e){if(e&&!c(e))throw new Error("Unknown encoding: "+e)}(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=f;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=o;break;default:return void(this.write=i)}this.charBuffer=new r(6),this.charReceived=0,this.charLength=0};function i(e){return e.toString(this.encoding)}function f(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function o(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}n.prototype.write=function(e){for(var a="";this.charLength;){var t=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,t),this.charReceived+=t,this.charReceived<this.charLength)return"";if(e=e.slice(t,e.length),!((c=(a=this.charBuffer.slice(0,this.charLength).toString(this.encoding)).charCodeAt(a.length-1))>=55296&&c<=56319)){if(this.charReceived=this.charLength=0,0===e.length)return a;break}this.charLength+=this.surrogateSize,a=""}this.detectIncompleteChar(e);var r=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,r),r-=this.charReceived);var c;r=(a+=e.toString(this.encoding,0,r)).length-1;if((c=a.charCodeAt(r))>=55296&&c<=56319){var n=this.surrogateSize;return this.charLength+=n,this.charReceived+=n,this.charBuffer.copy(this.charBuffer,n,0,n),e.copy(this.charBuffer,0,0,n),a.substring(0,r)}return a},n.prototype.detectIncompleteChar=function(e){for(var a=e.length>=3?3:e.length;a>0;a--){var t=e[e.length-a];if(1==a&&t>>5==6){this.charLength=2;break}if(a<=2&&t>>4==14){this.charLength=3;break}if(a<=3&&t>>3==30){this.charLength=4;break}}this.charReceived=a},n.prototype.end=function(e){var a="";if(e&&e.length&&(a=this.write(e)),this.charReceived){var t=this.charReceived,r=this.charBuffer,c=this.encoding;a+=r.slice(0,t).toString(c)}return a}},function(e,a,t){e.exports=f;var r=Object.keys||function(e){var a=[];for(var t in e)a.push(t);return a},c=t(17);c.inherits=t(0);var n=t(354),i=t(353);function f(e){if(!(this instanceof f))return new f(e);n.call(this,e),i.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",o)}function o(){this.allowHalfOpen||this._writableState.ended||process.nextTick(this.end.bind(this))}c.inherits(f,n),function(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}(r(i.prototype),function(e){f.prototype[e]||(f.prototype[e]=i.prototype[e])})},function(e,a,t){var r=a.noop=function(){};function c(e,a,t){this.logFunction=t,this.identifier=e,this.uniqueID=a,this.buffer=[]}a.extend=function(e,a){for(var t in a)e[t]=a[t]},a.eventEmitterListenerCount=t(5).EventEmitter.listenerCount||function(e,a){return e.listeners(a).length},a.BufferingLogger=function(e,a){var n=t(115)(e);if(n.enabled){var i=new c(e,a,n),f=i.log.bind(i);return f.printOutput=i.printOutput.bind(i),f.enabled=n.enabled,f}return n.printOutput=r,n},c.prototype.log=function(){return this.buffer.push([new Date,Array.prototype.slice.call(arguments)]),this},c.prototype.clear=function(){return this.buffer=[],this},c.prototype.printOutput=function(e){e||(e=this.logFunction);var a=this.uniqueID;this.buffer.forEach(function(t){var r=t[0].toLocaleString(),c=t[1].slice(),n=c[0];void 0!==n&&null!==n&&(n="%s - %s - "+n.toString(),c.splice(0,1,n,r,a),e.apply(global,c))})}},function(e,a,t){(function(e){var r;
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright JS Foundation and other contributors <https://js.foundation/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */(function(){var c,n=200,i="Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",f="Expected a function",o="__lodash_hash_undefined__",d=500,s="__lodash_placeholder__",b=1,u=2,l=4,p=1,h=2,m=1,g=2,v=4,y=8,_=16,w=32,A=64,k=128,x=256,E=512,S=30,T="...",j=800,C=16,R=1,O=2,B=1/0,M=9007199254740991,N=1.7976931348623157e308,I=NaN,P=4294967295,F=P-1,L=P>>>1,D=[["ary",k],["bind",m],["bindKey",g],["curry",y],["curryRight",_],["flip",E],["partial",w],["partialRight",A],["rearg",x]],z="[object Arguments]",q="[object Array]",U="[object AsyncFunction]",H="[object Boolean]",V="[object Date]",G="[object DOMException]",W="[object Error]",Y="[object Function]",K="[object GeneratorFunction]",Q="[object Map]",Z="[object Number]",J="[object Null]",X="[object Object]",$="[object Proxy]",ee="[object RegExp]",ae="[object Set]",te="[object String]",re="[object Symbol]",ce="[object Undefined]",ne="[object WeakMap]",ie="[object WeakSet]",fe="[object ArrayBuffer]",oe="[object DataView]",de="[object Float32Array]",se="[object Float64Array]",be="[object Int8Array]",ue="[object Int16Array]",le="[object Int32Array]",pe="[object Uint8Array]",he="[object Uint8ClampedArray]",me="[object Uint16Array]",ge="[object Uint32Array]",ve=/\b__p \+= '';/g,ye=/\b(__p \+=) '' \+/g,_e=/(__e\(.*?\)|\b__t\)) \+\n'';/g,we=/&(?:amp|lt|gt|quot|#39);/g,Ae=/[&<>"']/g,ke=RegExp(we.source),xe=RegExp(Ae.source),Ee=/<%-([\s\S]+?)%>/g,Se=/<%([\s\S]+?)%>/g,Te=/<%=([\s\S]+?)%>/g,je=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,Ce=/^\w*$/,Re=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,Oe=/[\\^$.*+?()[\]{}|]/g,Be=RegExp(Oe.source),Me=/^\s+|\s+$/g,Ne=/^\s+/,Ie=/\s+$/,Pe=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,Fe=/\{\n\/\* \[wrapped with (.+)\] \*/,Le=/,? & /,De=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ze=/\\(\\)?/g,qe=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,Ue=/\w*$/,He=/^[-+]0x[0-9a-f]+$/i,Ve=/^0b[01]+$/i,Ge=/^\[object .+?Constructor\]$/,We=/^0o[0-7]+$/i,Ye=/^(?:0|[1-9]\d*)$/,Ke=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,Qe=/($^)/,Ze=/['\n\r\u2028\u2029\\]/g,Je="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",Xe="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",$e="[\\ud800-\\udfff]",ea="["+Xe+"]",aa="["+Je+"]",ta="\\d+",ra="[\\u2700-\\u27bf]",ca="[a-z\\xdf-\\xf6\\xf8-\\xff]",na="[^\\ud800-\\udfff"+Xe+ta+"\\u2700-\\u27bfa-z\\xdf-\\xf6\\xf8-\\xffA-Z\\xc0-\\xd6\\xd8-\\xde]",ia="\\ud83c[\\udffb-\\udfff]",fa="[^\\ud800-\\udfff]",oa="(?:\\ud83c[\\udde6-\\uddff]){2}",da="[\\ud800-\\udbff][\\udc00-\\udfff]",sa="[A-Z\\xc0-\\xd6\\xd8-\\xde]",ba="(?:"+ca+"|"+na+")",ua="(?:"+sa+"|"+na+")",la="(?:"+aa+"|"+ia+")"+"?",pa="[\\ufe0e\\ufe0f]?"+la+("(?:\\u200d(?:"+[fa,oa,da].join("|")+")[\\ufe0e\\ufe0f]?"+la+")*"),ha="(?:"+[ra,oa,da].join("|")+")"+pa,ma="(?:"+[fa+aa+"?",aa,oa,da,$e].join("|")+")",ga=RegExp("['’]","g"),va=RegExp(aa,"g"),ya=RegExp(ia+"(?="+ia+")|"+ma+pa,"g"),_a=RegExp([sa+"?"+ca+"+(?:['’](?:d|ll|m|re|s|t|ve))?(?="+[ea,sa,"$"].join("|")+")",ua+"+(?:['’](?:D|LL|M|RE|S|T|VE))?(?="+[ea,sa+ba,"$"].join("|")+")",sa+"?"+ba+"+(?:['’](?:d|ll|m|re|s|t|ve))?",sa+"+(?:['’](?:D|LL|M|RE|S|T|VE))?","\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",ta,ha].join("|"),"g"),wa=RegExp("[\\u200d\\ud800-\\udfff"+Je+"\\ufe0e\\ufe0f]"),Aa=/[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,ka=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],xa=-1,Ea={};Ea[de]=Ea[se]=Ea[be]=Ea[ue]=Ea[le]=Ea[pe]=Ea[he]=Ea[me]=Ea[ge]=!0,Ea[z]=Ea[q]=Ea[fe]=Ea[H]=Ea[oe]=Ea[V]=Ea[W]=Ea[Y]=Ea[Q]=Ea[Z]=Ea[X]=Ea[ee]=Ea[ae]=Ea[te]=Ea[ne]=!1;var Sa={};Sa[z]=Sa[q]=Sa[fe]=Sa[oe]=Sa[H]=Sa[V]=Sa[de]=Sa[se]=Sa[be]=Sa[ue]=Sa[le]=Sa[Q]=Sa[Z]=Sa[X]=Sa[ee]=Sa[ae]=Sa[te]=Sa[re]=Sa[pe]=Sa[he]=Sa[me]=Sa[ge]=!0,Sa[W]=Sa[Y]=Sa[ne]=!1;var Ta={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},ja=parseFloat,Ca=parseInt,Ra="object"==typeof global&&global&&global.Object===Object&&global,Oa="object"==typeof self&&self&&self.Object===Object&&self,Ba=Ra||Oa||Function("return this")(),Ma="object"==typeof a&&a&&!a.nodeType&&a,Na=Ma&&"object"==typeof e&&e&&!e.nodeType&&e,Ia=Na&&Na.exports===Ma,Pa=Ia&&Ra.process,Fa=function(){try{var e=Na&&Na.require&&Na.require("util").types;return e||Pa&&Pa.binding&&Pa.binding("util")}catch(e){}}(),La=Fa&&Fa.isArrayBuffer,Da=Fa&&Fa.isDate,za=Fa&&Fa.isMap,qa=Fa&&Fa.isRegExp,Ua=Fa&&Fa.isSet,Ha=Fa&&Fa.isTypedArray;function Va(e,a,t){switch(t.length){case 0:return e.call(a);case 1:return e.call(a,t[0]);case 2:return e.call(a,t[0],t[1]);case 3:return e.call(a,t[0],t[1],t[2])}return e.apply(a,t)}function Ga(e,a,t,r){for(var c=-1,n=null==e?0:e.length;++c<n;){var i=e[c];a(r,i,t(i),e)}return r}function Wa(e,a){for(var t=-1,r=null==e?0:e.length;++t<r&&!1!==a(e[t],t,e););return e}function Ya(e,a){for(var t=null==e?0:e.length;t--&&!1!==a(e[t],t,e););return e}function Ka(e,a){for(var t=-1,r=null==e?0:e.length;++t<r;)if(!a(e[t],t,e))return!1;return!0}function Qa(e,a){for(var t=-1,r=null==e?0:e.length,c=0,n=[];++t<r;){var i=e[t];a(i,t,e)&&(n[c++]=i)}return n}function Za(e,a){return!!(null==e?0:e.length)&&it(e,a,0)>-1}function Ja(e,a,t){for(var r=-1,c=null==e?0:e.length;++r<c;)if(t(a,e[r]))return!0;return!1}function Xa(e,a){for(var t=-1,r=null==e?0:e.length,c=Array(r);++t<r;)c[t]=a(e[t],t,e);return c}function $a(e,a){for(var t=-1,r=a.length,c=e.length;++t<r;)e[c+t]=a[t];return e}function et(e,a,t,r){var c=-1,n=null==e?0:e.length;for(r&&n&&(t=e[++c]);++c<n;)t=a(t,e[c],c,e);return t}function at(e,a,t,r){var c=null==e?0:e.length;for(r&&c&&(t=e[--c]);c--;)t=a(t,e[c],c,e);return t}function tt(e,a){for(var t=-1,r=null==e?0:e.length;++t<r;)if(a(e[t],t,e))return!0;return!1}var rt=st("length");function ct(e,a,t){var r;return t(e,function(e,t,c){if(a(e,t,c))return r=t,!1}),r}function nt(e,a,t,r){for(var c=e.length,n=t+(r?1:-1);r?n--:++n<c;)if(a(e[n],n,e))return n;return-1}function it(e,a,t){return a==a?function(e,a,t){var r=t-1,c=e.length;for(;++r<c;)if(e[r]===a)return r;return-1}(e,a,t):nt(e,ot,t)}function ft(e,a,t,r){for(var c=t-1,n=e.length;++c<n;)if(r(e[c],a))return c;return-1}function ot(e){return e!=e}function dt(e,a){var t=null==e?0:e.length;return t?lt(e,a)/t:I}function st(e){return function(a){return null==a?c:a[e]}}function bt(e){return function(a){return null==e?c:e[a]}}function ut(e,a,t,r,c){return c(e,function(e,c,n){t=r?(r=!1,e):a(t,e,c,n)}),t}function lt(e,a){for(var t,r=-1,n=e.length;++r<n;){var i=a(e[r]);i!==c&&(t=t===c?i:t+i)}return t}function pt(e,a){for(var t=-1,r=Array(e);++t<e;)r[t]=a(t);return r}function ht(e){return function(a){return e(a)}}function mt(e,a){return Xa(a,function(a){return e[a]})}function gt(e,a){return e.has(a)}function vt(e,a){for(var t=-1,r=e.length;++t<r&&it(a,e[t],0)>-1;);return t}function yt(e,a){for(var t=e.length;t--&&it(a,e[t],0)>-1;);return t}var _t=bt({"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss","Ā":"A","Ă":"A","Ą":"A","ā":"a","ă":"a","ą":"a","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","ć":"c","ĉ":"c","ċ":"c","č":"c","Ď":"D","Đ":"D","ď":"d","đ":"d","Ē":"E","Ĕ":"E","Ė":"E","Ę":"E","Ě":"E","ē":"e","ĕ":"e","ė":"e","ę":"e","ě":"e","Ĝ":"G","Ğ":"G","Ġ":"G","Ģ":"G","ĝ":"g","ğ":"g","ġ":"g","ģ":"g","Ĥ":"H","Ħ":"H","ĥ":"h","ħ":"h","Ĩ":"I","Ī":"I","Ĭ":"I","Į":"I","İ":"I","ĩ":"i","ī":"i","ĭ":"i","į":"i","ı":"i","Ĵ":"J","ĵ":"j","Ķ":"K","ķ":"k","ĸ":"k","Ĺ":"L","Ļ":"L","Ľ":"L","Ŀ":"L","Ł":"L","ĺ":"l","ļ":"l","ľ":"l","ŀ":"l","ł":"l","Ń":"N","Ņ":"N","Ň":"N","Ŋ":"N","ń":"n","ņ":"n","ň":"n","ŋ":"n","Ō":"O","Ŏ":"O","Ő":"O","ō":"o","ŏ":"o","ő":"o","Ŕ":"R","Ŗ":"R","Ř":"R","ŕ":"r","ŗ":"r","ř":"r","Ś":"S","Ŝ":"S","Ş":"S","Š":"S","ś":"s","ŝ":"s","ş":"s","š":"s","Ţ":"T","Ť":"T","Ŧ":"T","ţ":"t","ť":"t","ŧ":"t","Ũ":"U","Ū":"U","Ŭ":"U","Ů":"U","Ű":"U","Ų":"U","ũ":"u","ū":"u","ŭ":"u","ů":"u","ű":"u","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","Ż":"Z","Ž":"Z","ź":"z","ż":"z","ž":"z","Ĳ":"IJ","ĳ":"ij","Œ":"Oe","œ":"oe","ŉ":"'n","ſ":"s"}),wt=bt({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function At(e){return"\\"+Ta[e]}function kt(e){return wa.test(e)}function xt(e){var a=-1,t=Array(e.size);return e.forEach(function(e,r){t[++a]=[r,e]}),t}function Et(e,a){return function(t){return e(a(t))}}function St(e,a){for(var t=-1,r=e.length,c=0,n=[];++t<r;){var i=e[t];i!==a&&i!==s||(e[t]=s,n[c++]=t)}return n}function Tt(e,a){return"__proto__"==a?c:e[a]}function jt(e){var a=-1,t=Array(e.size);return e.forEach(function(e){t[++a]=e}),t}function Ct(e){var a=-1,t=Array(e.size);return e.forEach(function(e){t[++a]=[e,e]}),t}function Rt(e){return kt(e)?function(e){var a=ya.lastIndex=0;for(;ya.test(e);)++a;return a}(e):rt(e)}function Ot(e){return kt(e)?function(e){return e.match(ya)||[]}(e):function(e){return e.split("")}(e)}var Bt=bt({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"});var Mt=function e(a){var t=(a=null==a?Ba:Mt.defaults(Ba.Object(),a,Mt.pick(Ba,ka))).Array,r=a.Date,Je=a.Error,Xe=a.Function,$e=a.Math,ea=a.Object,aa=a.RegExp,ta=a.String,ra=a.TypeError,ca=t.prototype,na=Xe.prototype,ia=ea.prototype,fa=a["__core-js_shared__"],oa=na.toString,da=ia.hasOwnProperty,sa=0,ba=function(){var e=/[^.]+$/.exec(fa&&fa.keys&&fa.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}(),ua=ia.toString,la=oa.call(ea),pa=Ba._,ha=aa("^"+oa.call(da).replace(Oe,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),ma=Ia?a.Buffer:c,ya=a.Symbol,wa=a.Uint8Array,Ta=ma?ma.allocUnsafe:c,Ra=Et(ea.getPrototypeOf,ea),Oa=ea.create,Ma=ia.propertyIsEnumerable,Na=ca.splice,Pa=ya?ya.isConcatSpreadable:c,Fa=ya?ya.iterator:c,rt=ya?ya.toStringTag:c,bt=function(){try{var e=Ln(ea,"defineProperty");return e({},"",{}),e}catch(e){}}(),Nt=a.clearTimeout!==Ba.clearTimeout&&a.clearTimeout,It=r&&r.now!==Ba.Date.now&&r.now,Pt=a.setTimeout!==Ba.setTimeout&&a.setTimeout,Ft=$e.ceil,Lt=$e.floor,Dt=ea.getOwnPropertySymbols,zt=ma?ma.isBuffer:c,qt=a.isFinite,Ut=ca.join,Ht=Et(ea.keys,ea),Vt=$e.max,Gt=$e.min,Wt=r.now,Yt=a.parseInt,Kt=$e.random,Qt=ca.reverse,Zt=Ln(a,"DataView"),Jt=Ln(a,"Map"),Xt=Ln(a,"Promise"),$t=Ln(a,"Set"),er=Ln(a,"WeakMap"),ar=Ln(ea,"create"),tr=er&&new er,rr={},cr=di(Zt),nr=di(Jt),ir=di(Xt),fr=di($t),or=di(er),dr=ya?ya.prototype:c,sr=dr?dr.valueOf:c,br=dr?dr.toString:c;function ur(e){if(Tf(e)&&!mf(e)&&!(e instanceof mr)){if(e instanceof hr)return e;if(da.call(e,"__wrapped__"))return si(e)}return new hr(e)}var lr=function(){function e(){}return function(a){if(!Sf(a))return{};if(Oa)return Oa(a);e.prototype=a;var t=new e;return e.prototype=c,t}}();function pr(){}function hr(e,a){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!a,this.__index__=0,this.__values__=c}function mr(e){this.__wrapped__=e,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=P,this.__views__=[]}function gr(e){var a=-1,t=null==e?0:e.length;for(this.clear();++a<t;){var r=e[a];this.set(r[0],r[1])}}function vr(e){var a=-1,t=null==e?0:e.length;for(this.clear();++a<t;){var r=e[a];this.set(r[0],r[1])}}function yr(e){var a=-1,t=null==e?0:e.length;for(this.clear();++a<t;){var r=e[a];this.set(r[0],r[1])}}function _r(e){var a=-1,t=null==e?0:e.length;for(this.__data__=new yr;++a<t;)this.add(e[a])}function wr(e){var a=this.__data__=new vr(e);this.size=a.size}function Ar(e,a){var t=mf(e),r=!t&&hf(e),c=!t&&!r&&_f(e),n=!t&&!r&&!c&&If(e),i=t||r||c||n,f=i?pt(e.length,ta):[],o=f.length;for(var d in e)!a&&!da.call(e,d)||i&&("length"==d||c&&("offset"==d||"parent"==d)||n&&("buffer"==d||"byteLength"==d||"byteOffset"==d)||Gn(d,o))||f.push(d);return f}function kr(e){var a=e.length;return a?e[_c(0,a-1)]:c}function xr(e,a){return ii(an(e),Mr(a,0,e.length))}function Er(e){return ii(an(e))}function Sr(e,a,t){(t===c||uf(e[a],t))&&(t!==c||a in e)||Or(e,a,t)}function Tr(e,a,t){var r=e[a];da.call(e,a)&&uf(r,t)&&(t!==c||a in e)||Or(e,a,t)}function jr(e,a){for(var t=e.length;t--;)if(uf(e[t][0],a))return t;return-1}function Cr(e,a,t,r){return Lr(e,function(e,c,n){a(r,e,t(e),n)}),r}function Rr(e,a){return e&&tn(a,ro(a),e)}function Or(e,a,t){"__proto__"==a&&bt?bt(e,a,{configurable:!0,enumerable:!0,value:t,writable:!0}):e[a]=t}function Br(e,a){for(var r=-1,n=a.length,i=t(n),f=null==e;++r<n;)i[r]=f?c:Xf(e,a[r]);return i}function Mr(e,a,t){return e==e&&(t!==c&&(e=e<=t?e:t),a!==c&&(e=e>=a?e:a)),e}function Nr(e,a,t,r,n,i){var f,o=a&b,d=a&u,s=a&l;if(t&&(f=n?t(e,r,n,i):t(e)),f!==c)return f;if(!Sf(e))return e;var p=mf(e);if(p){if(f=function(e){var a=e.length,t=new e.constructor(a);return a&&"string"==typeof e[0]&&da.call(e,"index")&&(t.index=e.index,t.input=e.input),t}(e),!o)return an(e,f)}else{var h=qn(e),m=h==Y||h==K;if(_f(e))return Qc(e,o);if(h==X||h==z||m&&!n){if(f=d||m?{}:Hn(e),!o)return d?function(e,a){return tn(e,zn(e),a)}(e,function(e,a){return e&&tn(a,co(a),e)}(f,e)):function(e,a){return tn(e,Dn(e),a)}(e,Rr(f,e))}else{if(!Sa[h])return n?e:{};f=function(e,a,t){var r=e.constructor;switch(a){case fe:return Zc(e);case H:case V:return new r(+e);case oe:return function(e,a){var t=a?Zc(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.byteLength)}(e,t);case de:case se:case be:case ue:case le:case pe:case he:case me:case ge:return Jc(e,t);case Q:return new r;case Z:case te:return new r(e);case ee:return function(e){var a=new e.constructor(e.source,Ue.exec(e));return a.lastIndex=e.lastIndex,a}(e);case ae:return new r;case re:return function(e){return sr?ea(sr.call(e)):{}}(e)}}(e,h,o)}}i||(i=new wr);var g=i.get(e);if(g)return g;if(i.set(e,f),Bf(e))return e.forEach(function(r){f.add(Nr(r,a,t,r,e,i))}),f;if(jf(e))return e.forEach(function(r,c){f.set(c,Nr(r,a,t,c,e,i))}),f;var v=p?c:(s?d?On:Rn:d?co:ro)(e);return Wa(v||e,function(r,c){v&&(r=e[c=r]),Tr(f,c,Nr(r,a,t,c,e,i))}),f}function Ir(e,a,t){var r=t.length;if(null==e)return!r;for(e=ea(e);r--;){var n=t[r],i=a[n],f=e[n];if(f===c&&!(n in e)||!i(f))return!1}return!0}function Pr(e,a,t){if("function"!=typeof e)throw new ra(f);return ti(function(){e.apply(c,t)},a)}function Fr(e,a,t,r){var c=-1,i=Za,f=!0,o=e.length,d=[],s=a.length;if(!o)return d;t&&(a=Xa(a,ht(t))),r?(i=Ja,f=!1):a.length>=n&&(i=gt,f=!1,a=new _r(a));e:for(;++c<o;){var b=e[c],u=null==t?b:t(b);if(b=r||0!==b?b:0,f&&u==u){for(var l=s;l--;)if(a[l]===u)continue e;d.push(b)}else i(a,u,r)||d.push(b)}return d}ur.templateSettings={escape:Ee,evaluate:Se,interpolate:Te,variable:"",imports:{_:ur}},ur.prototype=pr.prototype,ur.prototype.constructor=ur,hr.prototype=lr(pr.prototype),hr.prototype.constructor=hr,mr.prototype=lr(pr.prototype),mr.prototype.constructor=mr,gr.prototype.clear=function(){this.__data__=ar?ar(null):{},this.size=0},gr.prototype.delete=function(e){var a=this.has(e)&&delete this.__data__[e];return this.size-=a?1:0,a},gr.prototype.get=function(e){var a=this.__data__;if(ar){var t=a[e];return t===o?c:t}return da.call(a,e)?a[e]:c},gr.prototype.has=function(e){var a=this.__data__;return ar?a[e]!==c:da.call(a,e)},gr.prototype.set=function(e,a){var t=this.__data__;return this.size+=this.has(e)?0:1,t[e]=ar&&a===c?o:a,this},vr.prototype.clear=function(){this.__data__=[],this.size=0},vr.prototype.delete=function(e){var a=this.__data__,t=jr(a,e);return!(t<0||(t==a.length-1?a.pop():Na.call(a,t,1),--this.size,0))},vr.prototype.get=function(e){var a=this.__data__,t=jr(a,e);return t<0?c:a[t][1]},vr.prototype.has=function(e){return jr(this.__data__,e)>-1},vr.prototype.set=function(e,a){var t=this.__data__,r=jr(t,e);return r<0?(++this.size,t.push([e,a])):t[r][1]=a,this},yr.prototype.clear=function(){this.size=0,this.__data__={hash:new gr,map:new(Jt||vr),string:new gr}},yr.prototype.delete=function(e){var a=Pn(this,e).delete(e);return this.size-=a?1:0,a},yr.prototype.get=function(e){return Pn(this,e).get(e)},yr.prototype.has=function(e){return Pn(this,e).has(e)},yr.prototype.set=function(e,a){var t=Pn(this,e),r=t.size;return t.set(e,a),this.size+=t.size==r?0:1,this},_r.prototype.add=_r.prototype.push=function(e){return this.__data__.set(e,o),this},_r.prototype.has=function(e){return this.__data__.has(e)},wr.prototype.clear=function(){this.__data__=new vr,this.size=0},wr.prototype.delete=function(e){var a=this.__data__,t=a.delete(e);return this.size=a.size,t},wr.prototype.get=function(e){return this.__data__.get(e)},wr.prototype.has=function(e){return this.__data__.has(e)},wr.prototype.set=function(e,a){var t=this.__data__;if(t instanceof vr){var r=t.__data__;if(!Jt||r.length<n-1)return r.push([e,a]),this.size=++t.size,this;t=this.__data__=new yr(r)}return t.set(e,a),this.size=t.size,this};var Lr=nn(Wr),Dr=nn(Yr,!0);function zr(e,a){var t=!0;return Lr(e,function(e,r,c){return t=!!a(e,r,c)}),t}function qr(e,a,t){for(var r=-1,n=e.length;++r<n;){var i=e[r],f=a(i);if(null!=f&&(o===c?f==f&&!Nf(f):t(f,o)))var o=f,d=i}return d}function Ur(e,a){var t=[];return Lr(e,function(e,r,c){a(e,r,c)&&t.push(e)}),t}function Hr(e,a,t,r,c){var n=-1,i=e.length;for(t||(t=Vn),c||(c=[]);++n<i;){var f=e[n];a>0&&t(f)?a>1?Hr(f,a-1,t,r,c):$a(c,f):r||(c[c.length]=f)}return c}var Vr=fn(),Gr=fn(!0);function Wr(e,a){return e&&Vr(e,a,ro)}function Yr(e,a){return e&&Gr(e,a,ro)}function Kr(e,a){return Qa(a,function(a){return kf(e[a])})}function Qr(e,a){for(var t=0,r=(a=Gc(a,e)).length;null!=e&&t<r;)e=e[oi(a[t++])];return t&&t==r?e:c}function Zr(e,a,t){var r=a(e);return mf(e)?r:$a(r,t(e))}function Jr(e){return null==e?e===c?ce:J:rt&&rt in ea(e)?function(e){var a=da.call(e,rt),t=e[rt];try{e[rt]=c;var r=!0}catch(e){}var n=ua.call(e);return r&&(a?e[rt]=t:delete e[rt]),n}(e):function(e){return ua.call(e)}(e)}function Xr(e,a){return e>a}function $r(e,a){return null!=e&&da.call(e,a)}function ec(e,a){return null!=e&&a in ea(e)}function ac(e,a,r){for(var n=r?Ja:Za,i=e[0].length,f=e.length,o=f,d=t(f),s=1/0,b=[];o--;){var u=e[o];o&&a&&(u=Xa(u,ht(a))),s=Gt(u.length,s),d[o]=!r&&(a||i>=120&&u.length>=120)?new _r(o&&u):c}u=e[0];var l=-1,p=d[0];e:for(;++l<i&&b.length<s;){var h=u[l],m=a?a(h):h;if(h=r||0!==h?h:0,!(p?gt(p,m):n(b,m,r))){for(o=f;--o;){var g=d[o];if(!(g?gt(g,m):n(e[o],m,r)))continue e}p&&p.push(m),b.push(h)}}return b}function tc(e,a,t){var r=null==(e=ei(e,a=Gc(a,e)))?e:e[oi(wi(a))];return null==r?c:Va(r,e,t)}function rc(e){return Tf(e)&&Jr(e)==z}function cc(e,a,t,r,n){return e===a||(null==e||null==a||!Tf(e)&&!Tf(a)?e!=e&&a!=a:function(e,a,t,r,n,i){var f=mf(e),o=mf(a),d=f?q:qn(e),s=o?q:qn(a),b=(d=d==z?X:d)==X,u=(s=s==z?X:s)==X,l=d==s;if(l&&_f(e)){if(!_f(a))return!1;f=!0,b=!1}if(l&&!b)return i||(i=new wr),f||If(e)?jn(e,a,t,r,n,i):function(e,a,t,r,c,n,i){switch(t){case oe:if(e.byteLength!=a.byteLength||e.byteOffset!=a.byteOffset)return!1;e=e.buffer,a=a.buffer;case fe:return!(e.byteLength!=a.byteLength||!n(new wa(e),new wa(a)));case H:case V:case Z:return uf(+e,+a);case W:return e.name==a.name&&e.message==a.message;case ee:case te:return e==a+"";case Q:var f=xt;case ae:var o=r&p;if(f||(f=jt),e.size!=a.size&&!o)return!1;var d=i.get(e);if(d)return d==a;r|=h,i.set(e,a);var s=jn(f(e),f(a),r,c,n,i);return i.delete(e),s;case re:if(sr)return sr.call(e)==sr.call(a)}return!1}(e,a,d,t,r,n,i);if(!(t&p)){var m=b&&da.call(e,"__wrapped__"),g=u&&da.call(a,"__wrapped__");if(m||g){var v=m?e.value():e,y=g?a.value():a;return i||(i=new wr),n(v,y,t,r,i)}}return!!l&&(i||(i=new wr),function(e,a,t,r,n,i){var f=t&p,o=Rn(e),d=o.length,s=Rn(a).length;if(d!=s&&!f)return!1;for(var b=d;b--;){var u=o[b];if(!(f?u in a:da.call(a,u)))return!1}var l=i.get(e);if(l&&i.get(a))return l==a;var h=!0;i.set(e,a),i.set(a,e);for(var m=f;++b<d;){u=o[b];var g=e[u],v=a[u];if(r)var y=f?r(v,g,u,a,e,i):r(g,v,u,e,a,i);if(!(y===c?g===v||n(g,v,t,r,i):y)){h=!1;break}m||(m="constructor"==u)}if(h&&!m){var _=e.constructor,w=a.constructor;_!=w&&"constructor"in e&&"constructor"in a&&!("function"==typeof _&&_ instanceof _&&"function"==typeof w&&w instanceof w)&&(h=!1)}return i.delete(e),i.delete(a),h}(e,a,t,r,n,i))}(e,a,t,r,cc,n))}function nc(e,a,t,r){var n=t.length,i=n,f=!r;if(null==e)return!i;for(e=ea(e);n--;){var o=t[n];if(f&&o[2]?o[1]!==e[o[0]]:!(o[0]in e))return!1}for(;++n<i;){var d=(o=t[n])[0],s=e[d],b=o[1];if(f&&o[2]){if(s===c&&!(d in e))return!1}else{var u=new wr;if(r)var l=r(s,b,d,e,a,u);if(!(l===c?cc(b,s,p|h,r,u):l))return!1}}return!0}function ic(e){return!(!Sf(e)||function(e){return!!ba&&ba in e}(e))&&(kf(e)?ha:Ge).test(di(e))}function fc(e){return"function"==typeof e?e:null==e?Ro:"object"==typeof e?mf(e)?lc(e[0],e[1]):uc(e):Do(e)}function oc(e){if(!Zn(e))return Ht(e);var a=[];for(var t in ea(e))da.call(e,t)&&"constructor"!=t&&a.push(t);return a}function dc(e){if(!Sf(e))return function(e){var a=[];if(null!=e)for(var t in ea(e))a.push(t);return a}(e);var a=Zn(e),t=[];for(var r in e)("constructor"!=r||!a&&da.call(e,r))&&t.push(r);return t}function sc(e,a){return e<a}function bc(e,a){var r=-1,c=vf(e)?t(e.length):[];return Lr(e,function(e,t,n){c[++r]=a(e,t,n)}),c}function uc(e){var a=Fn(e);return 1==a.length&&a[0][2]?Xn(a[0][0],a[0][1]):function(t){return t===e||nc(t,e,a)}}function lc(e,a){return Yn(e)&&Jn(a)?Xn(oi(e),a):function(t){var r=Xf(t,e);return r===c&&r===a?$f(t,e):cc(a,r,p|h)}}function pc(e,a,t,r,n){e!==a&&Vr(a,function(i,f){if(Sf(i))n||(n=new wr),function(e,a,t,r,n,i,f){var o=Tt(e,t),d=Tt(a,t),s=f.get(d);if(s)Sr(e,t,s);else{var b=i?i(o,d,t+"",e,a,f):c,u=b===c;if(u){var l=mf(d),p=!l&&_f(d),h=!l&&!p&&If(d);b=d,l||p||h?mf(o)?b=o:yf(o)?b=an(o):p?(u=!1,b=Qc(d,!0)):h?(u=!1,b=Jc(d,!0)):b=[]:Rf(d)||hf(d)?(b=o,hf(o)?b=Hf(o):(!Sf(o)||r&&kf(o))&&(b=Hn(d))):u=!1}u&&(f.set(d,b),n(b,d,r,i,f),f.delete(d)),Sr(e,t,b)}}(e,a,f,t,pc,r,n);else{var o=r?r(Tt(e,f),i,f+"",e,a,n):c;o===c&&(o=i),Sr(e,f,o)}},co)}function hc(e,a){var t=e.length;if(t)return Gn(a+=a<0?t:0,t)?e[a]:c}function mc(e,a,t){var r=-1;return a=Xa(a.length?a:[Ro],ht(In())),function(e,a){var t=e.length;for(e.sort(a);t--;)e[t]=e[t].value;return e}(bc(e,function(e,t,c){return{criteria:Xa(a,function(a){return a(e)}),index:++r,value:e}}),function(e,a){return function(e,a,t){for(var r=-1,c=e.criteria,n=a.criteria,i=c.length,f=t.length;++r<i;){var o=Xc(c[r],n[r]);if(o){if(r>=f)return o;var d=t[r];return o*("desc"==d?-1:1)}}return e.index-a.index}(e,a,t)})}function gc(e,a,t){for(var r=-1,c=a.length,n={};++r<c;){var i=a[r],f=Qr(e,i);t(f,i)&&Ec(n,Gc(i,e),f)}return n}function vc(e,a,t,r){var c=r?ft:it,n=-1,i=a.length,f=e;for(e===a&&(a=an(a)),t&&(f=Xa(e,ht(t)));++n<i;)for(var o=0,d=a[n],s=t?t(d):d;(o=c(f,s,o,r))>-1;)f!==e&&Na.call(f,o,1),Na.call(e,o,1);return e}function yc(e,a){for(var t=e?a.length:0,r=t-1;t--;){var c=a[t];if(t==r||c!==n){var n=c;Gn(c)?Na.call(e,c,1):Fc(e,c)}}return e}function _c(e,a){return e+Lt(Kt()*(a-e+1))}function wc(e,a){var t="";if(!e||a<1||a>M)return t;do{a%2&&(t+=e),(a=Lt(a/2))&&(e+=e)}while(a);return t}function Ac(e,a){return ri($n(e,a,Ro),e+"")}function kc(e){return kr(lo(e))}function xc(e,a){var t=lo(e);return ii(t,Mr(a,0,t.length))}function Ec(e,a,t,r){if(!Sf(e))return e;for(var n=-1,i=(a=Gc(a,e)).length,f=i-1,o=e;null!=o&&++n<i;){var d=oi(a[n]),s=t;if(n!=f){var b=o[d];(s=r?r(b,d,o):c)===c&&(s=Sf(b)?b:Gn(a[n+1])?[]:{})}Tr(o,d,s),o=o[d]}return e}var Sc=tr?function(e,a){return tr.set(e,a),e}:Ro,Tc=bt?function(e,a){return bt(e,"toString",{configurable:!0,enumerable:!1,value:To(a),writable:!0})}:Ro;function jc(e){return ii(lo(e))}function Cc(e,a,r){var c=-1,n=e.length;a<0&&(a=-a>n?0:n+a),(r=r>n?n:r)<0&&(r+=n),n=a>r?0:r-a>>>0,a>>>=0;for(var i=t(n);++c<n;)i[c]=e[c+a];return i}function Rc(e,a){var t;return Lr(e,function(e,r,c){return!(t=a(e,r,c))}),!!t}function Oc(e,a,t){var r=0,c=null==e?r:e.length;if("number"==typeof a&&a==a&&c<=L){for(;r<c;){var n=r+c>>>1,i=e[n];null!==i&&!Nf(i)&&(t?i<=a:i<a)?r=n+1:c=n}return c}return Bc(e,a,Ro,t)}function Bc(e,a,t,r){a=t(a);for(var n=0,i=null==e?0:e.length,f=a!=a,o=null===a,d=Nf(a),s=a===c;n<i;){var b=Lt((n+i)/2),u=t(e[b]),l=u!==c,p=null===u,h=u==u,m=Nf(u);if(f)var g=r||h;else g=s?h&&(r||l):o?h&&l&&(r||!p):d?h&&l&&!p&&(r||!m):!p&&!m&&(r?u<=a:u<a);g?n=b+1:i=b}return Gt(i,F)}function Mc(e,a){for(var t=-1,r=e.length,c=0,n=[];++t<r;){var i=e[t],f=a?a(i):i;if(!t||!uf(f,o)){var o=f;n[c++]=0===i?0:i}}return n}function Nc(e){return"number"==typeof e?e:Nf(e)?I:+e}function Ic(e){if("string"==typeof e)return e;if(mf(e))return Xa(e,Ic)+"";if(Nf(e))return br?br.call(e):"";var a=e+"";return"0"==a&&1/e==-B?"-0":a}function Pc(e,a,t){var r=-1,c=Za,i=e.length,f=!0,o=[],d=o;if(t)f=!1,c=Ja;else if(i>=n){var s=a?null:An(e);if(s)return jt(s);f=!1,c=gt,d=new _r}else d=a?[]:o;e:for(;++r<i;){var b=e[r],u=a?a(b):b;if(b=t||0!==b?b:0,f&&u==u){for(var l=d.length;l--;)if(d[l]===u)continue e;a&&d.push(u),o.push(b)}else c(d,u,t)||(d!==o&&d.push(u),o.push(b))}return o}function Fc(e,a){return null==(e=ei(e,a=Gc(a,e)))||delete e[oi(wi(a))]}function Lc(e,a,t,r){return Ec(e,a,t(Qr(e,a)),r)}function Dc(e,a,t,r){for(var c=e.length,n=r?c:-1;(r?n--:++n<c)&&a(e[n],n,e););return t?Cc(e,r?0:n,r?n+1:c):Cc(e,r?n+1:0,r?c:n)}function zc(e,a){var t=e;return t instanceof mr&&(t=t.value()),et(a,function(e,a){return a.func.apply(a.thisArg,$a([e],a.args))},t)}function qc(e,a,r){var c=e.length;if(c<2)return c?Pc(e[0]):[];for(var n=-1,i=t(c);++n<c;)for(var f=e[n],o=-1;++o<c;)o!=n&&(i[n]=Fr(i[n]||f,e[o],a,r));return Pc(Hr(i,1),a,r)}function Uc(e,a,t){for(var r=-1,n=e.length,i=a.length,f={};++r<n;){var o=r<i?a[r]:c;t(f,e[r],o)}return f}function Hc(e){return yf(e)?e:[]}function Vc(e){return"function"==typeof e?e:Ro}function Gc(e,a){return mf(e)?e:Yn(e,a)?[e]:fi(Vf(e))}var Wc=Ac;function Yc(e,a,t){var r=e.length;return t=t===c?r:t,!a&&t>=r?e:Cc(e,a,t)}var Kc=Nt||function(e){return Ba.clearTimeout(e)};function Qc(e,a){if(a)return e.slice();var t=e.length,r=Ta?Ta(t):new e.constructor(t);return e.copy(r),r}function Zc(e){var a=new e.constructor(e.byteLength);return new wa(a).set(new wa(e)),a}function Jc(e,a){var t=a?Zc(e.buffer):e.buffer;return new e.constructor(t,e.byteOffset,e.length)}function Xc(e,a){if(e!==a){var t=e!==c,r=null===e,n=e==e,i=Nf(e),f=a!==c,o=null===a,d=a==a,s=Nf(a);if(!o&&!s&&!i&&e>a||i&&f&&d&&!o&&!s||r&&f&&d||!t&&d||!n)return 1;if(!r&&!i&&!s&&e<a||s&&t&&n&&!r&&!i||o&&t&&n||!f&&n||!d)return-1}return 0}function $c(e,a,r,c){for(var n=-1,i=e.length,f=r.length,o=-1,d=a.length,s=Vt(i-f,0),b=t(d+s),u=!c;++o<d;)b[o]=a[o];for(;++n<f;)(u||n<i)&&(b[r[n]]=e[n]);for(;s--;)b[o++]=e[n++];return b}function en(e,a,r,c){for(var n=-1,i=e.length,f=-1,o=r.length,d=-1,s=a.length,b=Vt(i-o,0),u=t(b+s),l=!c;++n<b;)u[n]=e[n];for(var p=n;++d<s;)u[p+d]=a[d];for(;++f<o;)(l||n<i)&&(u[p+r[f]]=e[n++]);return u}function an(e,a){var r=-1,c=e.length;for(a||(a=t(c));++r<c;)a[r]=e[r];return a}function tn(e,a,t,r){var n=!t;t||(t={});for(var i=-1,f=a.length;++i<f;){var o=a[i],d=r?r(t[o],e[o],o,t,e):c;d===c&&(d=e[o]),n?Or(t,o,d):Tr(t,o,d)}return t}function rn(e,a){return function(t,r){var c=mf(t)?Ga:Cr,n=a?a():{};return c(t,e,In(r,2),n)}}function cn(e){return Ac(function(a,t){var r=-1,n=t.length,i=n>1?t[n-1]:c,f=n>2?t[2]:c;for(i=e.length>3&&"function"==typeof i?(n--,i):c,f&&Wn(t[0],t[1],f)&&(i=n<3?c:i,n=1),a=ea(a);++r<n;){var o=t[r];o&&e(a,o,r,i)}return a})}function nn(e,a){return function(t,r){if(null==t)return t;if(!vf(t))return e(t,r);for(var c=t.length,n=a?c:-1,i=ea(t);(a?n--:++n<c)&&!1!==r(i[n],n,i););return t}}function fn(e){return function(a,t,r){for(var c=-1,n=ea(a),i=r(a),f=i.length;f--;){var o=i[e?f:++c];if(!1===t(n[o],o,n))break}return a}}function on(e){return function(a){var t=kt(a=Vf(a))?Ot(a):c,r=t?t[0]:a.charAt(0),n=t?Yc(t,1).join(""):a.slice(1);return r[e]()+n}}function dn(e){return function(a){return et(xo(mo(a).replace(ga,"")),e,"")}}function sn(e){return function(){var a=arguments;switch(a.length){case 0:return new e;case 1:return new e(a[0]);case 2:return new e(a[0],a[1]);case 3:return new e(a[0],a[1],a[2]);case 4:return new e(a[0],a[1],a[2],a[3]);case 5:return new e(a[0],a[1],a[2],a[3],a[4]);case 6:return new e(a[0],a[1],a[2],a[3],a[4],a[5]);case 7:return new e(a[0],a[1],a[2],a[3],a[4],a[5],a[6])}var t=lr(e.prototype),r=e.apply(t,a);return Sf(r)?r:t}}function bn(e){return function(a,t,r){var n=ea(a);if(!vf(a)){var i=In(t,3);a=ro(a),t=function(e){return i(n[e],e,n)}}var f=e(a,t,r);return f>-1?n[i?a[f]:f]:c}}function un(e){return Cn(function(a){var t=a.length,r=t,n=hr.prototype.thru;for(e&&a.reverse();r--;){var i=a[r];if("function"!=typeof i)throw new ra(f);if(n&&!o&&"wrapper"==Mn(i))var o=new hr([],!0)}for(r=o?r:t;++r<t;){var d=Mn(i=a[r]),s="wrapper"==d?Bn(i):c;o=s&&Kn(s[0])&&s[1]==(k|y|w|x)&&!s[4].length&&1==s[9]?o[Mn(s[0])].apply(o,s[3]):1==i.length&&Kn(i)?o[d]():o.thru(i)}return function(){var e=arguments,r=e[0];if(o&&1==e.length&&mf(r))return o.plant(r).value();for(var c=0,n=t?a[c].apply(this,e):r;++c<t;)n=a[c].call(this,n);return n}})}function ln(e,a,r,n,i,f,o,d,s,b){var u=a&k,l=a&m,p=a&g,h=a&(y|_),v=a&E,w=p?c:sn(e);return function m(){for(var g=arguments.length,y=t(g),_=g;_--;)y[_]=arguments[_];if(h)var A=Nn(m),k=function(e,a){for(var t=e.length,r=0;t--;)e[t]===a&&++r;return r}(y,A);if(n&&(y=$c(y,n,i,h)),f&&(y=en(y,f,o,h)),g-=k,h&&g<b){var x=St(y,A);return _n(e,a,ln,m.placeholder,r,y,x,d,s,b-g)}var E=l?r:this,S=p?E[e]:e;return g=y.length,d?y=function(e,a){for(var t=e.length,r=Gt(a.length,t),n=an(e);r--;){var i=a[r];e[r]=Gn(i,t)?n[i]:c}return e}(y,d):v&&g>1&&y.reverse(),u&&s<g&&(y.length=s),this&&this!==Ba&&this instanceof m&&(S=w||sn(S)),S.apply(E,y)}}function pn(e,a){return function(t,r){return function(e,a,t,r){return Wr(e,function(e,c,n){a(r,t(e),c,n)}),r}(t,e,a(r),{})}}function hn(e,a){return function(t,r){var n;if(t===c&&r===c)return a;if(t!==c&&(n=t),r!==c){if(n===c)return r;"string"==typeof t||"string"==typeof r?(t=Ic(t),r=Ic(r)):(t=Nc(t),r=Nc(r)),n=e(t,r)}return n}}function mn(e){return Cn(function(a){return a=Xa(a,ht(In())),Ac(function(t){var r=this;return e(a,function(e){return Va(e,r,t)})})})}function gn(e,a){var t=(a=a===c?" ":Ic(a)).length;if(t<2)return t?wc(a,e):a;var r=wc(a,Ft(e/Rt(a)));return kt(a)?Yc(Ot(r),0,e).join(""):r.slice(0,e)}function vn(e){return function(a,r,n){return n&&"number"!=typeof n&&Wn(a,r,n)&&(r=n=c),a=Df(a),r===c?(r=a,a=0):r=Df(r),function(e,a,r,c){for(var n=-1,i=Vt(Ft((a-e)/(r||1)),0),f=t(i);i--;)f[c?i:++n]=e,e+=r;return f}(a,r,n=n===c?a<r?1:-1:Df(n),e)}}function yn(e){return function(a,t){return"string"==typeof a&&"string"==typeof t||(a=Uf(a),t=Uf(t)),e(a,t)}}function _n(e,a,t,r,n,i,f,o,d,s){var b=a&y;a|=b?w:A,(a&=~(b?A:w))&v||(a&=~(m|g));var u=[e,a,n,b?i:c,b?f:c,b?c:i,b?c:f,o,d,s],l=t.apply(c,u);return Kn(e)&&ai(l,u),l.placeholder=r,ci(l,e,a)}function wn(e){var a=$e[e];return function(e,t){if(e=Uf(e),t=null==t?0:Gt(zf(t),292)){var r=(Vf(e)+"e").split("e");return+((r=(Vf(a(r[0]+"e"+(+r[1]+t)))+"e").split("e"))[0]+"e"+(+r[1]-t))}return a(e)}}var An=$t&&1/jt(new $t([,-0]))[1]==B?function(e){return new $t(e)}:Io;function kn(e){return function(a){var t=qn(a);return t==Q?xt(a):t==ae?Ct(a):function(e,a){return Xa(a,function(a){return[a,e[a]]})}(a,e(a))}}function xn(e,a,r,n,i,o,d,b){var u=a&g;if(!u&&"function"!=typeof e)throw new ra(f);var l=n?n.length:0;if(l||(a&=~(w|A),n=i=c),d=d===c?d:Vt(zf(d),0),b=b===c?b:zf(b),l-=i?i.length:0,a&A){var p=n,h=i;n=i=c}var E=u?c:Bn(e),S=[e,a,r,n,i,p,h,o,d,b];if(E&&function(e,a){var t=e[1],r=a[1],c=t|r,n=c<(m|g|k),i=r==k&&t==y||r==k&&t==x&&e[7].length<=a[8]||r==(k|x)&&a[7].length<=a[8]&&t==y;if(!n&&!i)return e;r&m&&(e[2]=a[2],c|=t&m?0:v);var f=a[3];if(f){var o=e[3];e[3]=o?$c(o,f,a[4]):f,e[4]=o?St(e[3],s):a[4]}(f=a[5])&&(o=e[5],e[5]=o?en(o,f,a[6]):f,e[6]=o?St(e[5],s):a[6]),(f=a[7])&&(e[7]=f),r&k&&(e[8]=null==e[8]?a[8]:Gt(e[8],a[8])),null==e[9]&&(e[9]=a[9]),e[0]=a[0],e[1]=c}(S,E),e=S[0],a=S[1],r=S[2],n=S[3],i=S[4],!(b=S[9]=S[9]===c?u?0:e.length:Vt(S[9]-l,0))&&a&(y|_)&&(a&=~(y|_)),a&&a!=m)T=a==y||a==_?function(e,a,r){var n=sn(e);return function i(){for(var f=arguments.length,o=t(f),d=f,s=Nn(i);d--;)o[d]=arguments[d];var b=f<3&&o[0]!==s&&o[f-1]!==s?[]:St(o,s);return(f-=b.length)<r?_n(e,a,ln,i.placeholder,c,o,b,c,c,r-f):Va(this&&this!==Ba&&this instanceof i?n:e,this,o)}}(e,a,b):a!=w&&a!=(m|w)||i.length?ln.apply(c,S):function(e,a,r,c){var n=a&m,i=sn(e);return function a(){for(var f=-1,o=arguments.length,d=-1,s=c.length,b=t(s+o),u=this&&this!==Ba&&this instanceof a?i:e;++d<s;)b[d]=c[d];for(;o--;)b[d++]=arguments[++f];return Va(u,n?r:this,b)}}(e,a,r,n);else var T=function(e,a,t){var r=a&m,c=sn(e);return function a(){return(this&&this!==Ba&&this instanceof a?c:e).apply(r?t:this,arguments)}}(e,a,r);return ci((E?Sc:ai)(T,S),e,a)}function En(e,a,t,r){return e===c||uf(e,ia[t])&&!da.call(r,t)?a:e}function Sn(e,a,t,r,n,i){return Sf(e)&&Sf(a)&&(i.set(a,e),pc(e,a,c,Sn,i),i.delete(a)),e}function Tn(e){return Rf(e)?c:e}function jn(e,a,t,r,n,i){var f=t&p,o=e.length,d=a.length;if(o!=d&&!(f&&d>o))return!1;var s=i.get(e);if(s&&i.get(a))return s==a;var b=-1,u=!0,l=t&h?new _r:c;for(i.set(e,a),i.set(a,e);++b<o;){var m=e[b],g=a[b];if(r)var v=f?r(g,m,b,a,e,i):r(m,g,b,e,a,i);if(v!==c){if(v)continue;u=!1;break}if(l){if(!tt(a,function(e,a){if(!gt(l,a)&&(m===e||n(m,e,t,r,i)))return l.push(a)})){u=!1;break}}else if(m!==g&&!n(m,g,t,r,i)){u=!1;break}}return i.delete(e),i.delete(a),u}function Cn(e){return ri($n(e,c,mi),e+"")}function Rn(e){return Zr(e,ro,Dn)}function On(e){return Zr(e,co,zn)}var Bn=tr?function(e){return tr.get(e)}:Io;function Mn(e){for(var a=e.name+"",t=rr[a],r=da.call(rr,a)?t.length:0;r--;){var c=t[r],n=c.func;if(null==n||n==e)return c.name}return a}function Nn(e){return(da.call(ur,"placeholder")?ur:e).placeholder}function In(){var e=ur.iteratee||Oo;return e=e===Oo?fc:e,arguments.length?e(arguments[0],arguments[1]):e}function Pn(e,a){var t=e.__data__;return function(e){var a=typeof e;return"string"==a||"number"==a||"symbol"==a||"boolean"==a?"__proto__"!==e:null===e}(a)?t["string"==typeof a?"string":"hash"]:t.map}function Fn(e){for(var a=ro(e),t=a.length;t--;){var r=a[t],c=e[r];a[t]=[r,c,Jn(c)]}return a}function Ln(e,a){var t=function(e,a){return null==e?c:e[a]}(e,a);return ic(t)?t:c}var Dn=Dt?function(e){return null==e?[]:(e=ea(e),Qa(Dt(e),function(a){return Ma.call(e,a)}))}:Uo,zn=Dt?function(e){for(var a=[];e;)$a(a,Dn(e)),e=Ra(e);return a}:Uo,qn=Jr;function Un(e,a,t){for(var r=-1,c=(a=Gc(a,e)).length,n=!1;++r<c;){var i=oi(a[r]);if(!(n=null!=e&&t(e,i)))break;e=e[i]}return n||++r!=c?n:!!(c=null==e?0:e.length)&&Ef(c)&&Gn(i,c)&&(mf(e)||hf(e))}function Hn(e){return"function"!=typeof e.constructor||Zn(e)?{}:lr(Ra(e))}function Vn(e){return mf(e)||hf(e)||!!(Pa&&e&&e[Pa])}function Gn(e,a){var t=typeof e;return!!(a=null==a?M:a)&&("number"==t||"symbol"!=t&&Ye.test(e))&&e>-1&&e%1==0&&e<a}function Wn(e,a,t){if(!Sf(t))return!1;var r=typeof a;return!!("number"==r?vf(t)&&Gn(a,t.length):"string"==r&&a in t)&&uf(t[a],e)}function Yn(e,a){if(mf(e))return!1;var t=typeof e;return!("number"!=t&&"symbol"!=t&&"boolean"!=t&&null!=e&&!Nf(e))||Ce.test(e)||!je.test(e)||null!=a&&e in ea(a)}function Kn(e){var a=Mn(e),t=ur[a];if("function"!=typeof t||!(a in mr.prototype))return!1;if(e===t)return!0;var r=Bn(t);return!!r&&e===r[0]}(Zt&&qn(new Zt(new ArrayBuffer(1)))!=oe||Jt&&qn(new Jt)!=Q||Xt&&"[object Promise]"!=qn(Xt.resolve())||$t&&qn(new $t)!=ae||er&&qn(new er)!=ne)&&(qn=function(e){var a=Jr(e),t=a==X?e.constructor:c,r=t?di(t):"";if(r)switch(r){case cr:return oe;case nr:return Q;case ir:return"[object Promise]";case fr:return ae;case or:return ne}return a});var Qn=fa?kf:Ho;function Zn(e){var a=e&&e.constructor;return e===("function"==typeof a&&a.prototype||ia)}function Jn(e){return e==e&&!Sf(e)}function Xn(e,a){return function(t){return null!=t&&t[e]===a&&(a!==c||e in ea(t))}}function $n(e,a,r){return a=Vt(a===c?e.length-1:a,0),function(){for(var c=arguments,n=-1,i=Vt(c.length-a,0),f=t(i);++n<i;)f[n]=c[a+n];n=-1;for(var o=t(a+1);++n<a;)o[n]=c[n];return o[a]=r(f),Va(e,this,o)}}function ei(e,a){return a.length<2?e:Qr(e,Cc(a,0,-1))}var ai=ni(Sc),ti=Pt||function(e,a){return Ba.setTimeout(e,a)},ri=ni(Tc);function ci(e,a,t){var r=a+"";return ri(e,function(e,a){var t=a.length;if(!t)return e;var r=t-1;return a[r]=(t>1?"& ":"")+a[r],a=a.join(t>2?", ":" "),e.replace(Pe,"{\n/* [wrapped with "+a+"] */\n")}(r,function(e,a){return Wa(D,function(t){var r="_."+t[0];a&t[1]&&!Za(e,r)&&e.push(r)}),e.sort()}(function(e){var a=e.match(Fe);return a?a[1].split(Le):[]}(r),t)))}function ni(e){var a=0,t=0;return function(){var r=Wt(),n=C-(r-t);if(t=r,n>0){if(++a>=j)return arguments[0]}else a=0;return e.apply(c,arguments)}}function ii(e,a){var t=-1,r=e.length,n=r-1;for(a=a===c?r:a;++t<a;){var i=_c(t,n),f=e[i];e[i]=e[t],e[t]=f}return e.length=a,e}var fi=function(e){var a=nf(e,function(e){return t.size===d&&t.clear(),e}),t=a.cache;return a}(function(e){var a=[];return 46===e.charCodeAt(0)&&a.push(""),e.replace(Re,function(e,t,r,c){a.push(r?c.replace(ze,"$1"):t||e)}),a});function oi(e){if("string"==typeof e||Nf(e))return e;var a=e+"";return"0"==a&&1/e==-B?"-0":a}function di(e){if(null!=e){try{return oa.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function si(e){if(e instanceof mr)return e.clone();var a=new hr(e.__wrapped__,e.__chain__);return a.__actions__=an(e.__actions__),a.__index__=e.__index__,a.__values__=e.__values__,a}var bi=Ac(function(e,a){return yf(e)?Fr(e,Hr(a,1,yf,!0)):[]}),ui=Ac(function(e,a){var t=wi(a);return yf(t)&&(t=c),yf(e)?Fr(e,Hr(a,1,yf,!0),In(t,2)):[]}),li=Ac(function(e,a){var t=wi(a);return yf(t)&&(t=c),yf(e)?Fr(e,Hr(a,1,yf,!0),c,t):[]});function pi(e,a,t){var r=null==e?0:e.length;if(!r)return-1;var c=null==t?0:zf(t);return c<0&&(c=Vt(r+c,0)),nt(e,In(a,3),c)}function hi(e,a,t){var r=null==e?0:e.length;if(!r)return-1;var n=r-1;return t!==c&&(n=zf(t),n=t<0?Vt(r+n,0):Gt(n,r-1)),nt(e,In(a,3),n,!0)}function mi(e){return null!=e&&e.length?Hr(e,1):[]}function gi(e){return e&&e.length?e[0]:c}var vi=Ac(function(e){var a=Xa(e,Hc);return a.length&&a[0]===e[0]?ac(a):[]}),yi=Ac(function(e){var a=wi(e),t=Xa(e,Hc);return a===wi(t)?a=c:t.pop(),t.length&&t[0]===e[0]?ac(t,In(a,2)):[]}),_i=Ac(function(e){var a=wi(e),t=Xa(e,Hc);return(a="function"==typeof a?a:c)&&t.pop(),t.length&&t[0]===e[0]?ac(t,c,a):[]});function wi(e){var a=null==e?0:e.length;return a?e[a-1]:c}var Ai=Ac(ki);function ki(e,a){return e&&e.length&&a&&a.length?vc(e,a):e}var xi=Cn(function(e,a){var t=null==e?0:e.length,r=Br(e,a);return yc(e,Xa(a,function(e){return Gn(e,t)?+e:e}).sort(Xc)),r});function Ei(e){return null==e?e:Qt.call(e)}var Si=Ac(function(e){return Pc(Hr(e,1,yf,!0))}),Ti=Ac(function(e){var a=wi(e);return yf(a)&&(a=c),Pc(Hr(e,1,yf,!0),In(a,2))}),ji=Ac(function(e){var a=wi(e);return a="function"==typeof a?a:c,Pc(Hr(e,1,yf,!0),c,a)});function Ci(e){if(!e||!e.length)return[];var a=0;return e=Qa(e,function(e){if(yf(e))return a=Vt(e.length,a),!0}),pt(a,function(a){return Xa(e,st(a))})}function Ri(e,a){if(!e||!e.length)return[];var t=Ci(e);return null==a?t:Xa(t,function(e){return Va(a,c,e)})}var Oi=Ac(function(e,a){return yf(e)?Fr(e,a):[]}),Bi=Ac(function(e){return qc(Qa(e,yf))}),Mi=Ac(function(e){var a=wi(e);return yf(a)&&(a=c),qc(Qa(e,yf),In(a,2))}),Ni=Ac(function(e){var a=wi(e);return a="function"==typeof a?a:c,qc(Qa(e,yf),c,a)}),Ii=Ac(Ci);var Pi=Ac(function(e){var a=e.length,t=a>1?e[a-1]:c;return Ri(e,t="function"==typeof t?(e.pop(),t):c)});function Fi(e){var a=ur(e);return a.__chain__=!0,a}function Li(e,a){return a(e)}var Di=Cn(function(e){var a=e.length,t=a?e[0]:0,r=this.__wrapped__,n=function(a){return Br(a,e)};return!(a>1||this.__actions__.length)&&r instanceof mr&&Gn(t)?((r=r.slice(t,+t+(a?1:0))).__actions__.push({func:Li,args:[n],thisArg:c}),new hr(r,this.__chain__).thru(function(e){return a&&!e.length&&e.push(c),e})):this.thru(n)});var zi=rn(function(e,a,t){da.call(e,t)?++e[t]:Or(e,t,1)});var qi=bn(pi),Ui=bn(hi);function Hi(e,a){return(mf(e)?Wa:Lr)(e,In(a,3))}function Vi(e,a){return(mf(e)?Ya:Dr)(e,In(a,3))}var Gi=rn(function(e,a,t){da.call(e,t)?e[t].push(a):Or(e,t,[a])});var Wi=Ac(function(e,a,r){var c=-1,n="function"==typeof a,i=vf(e)?t(e.length):[];return Lr(e,function(e){i[++c]=n?Va(a,e,r):tc(e,a,r)}),i}),Yi=rn(function(e,a,t){Or(e,t,a)});function Ki(e,a){return(mf(e)?Xa:bc)(e,In(a,3))}var Qi=rn(function(e,a,t){e[t?0:1].push(a)},function(){return[[],[]]});var Zi=Ac(function(e,a){if(null==e)return[];var t=a.length;return t>1&&Wn(e,a[0],a[1])?a=[]:t>2&&Wn(a[0],a[1],a[2])&&(a=[a[0]]),mc(e,Hr(a,1),[])}),Ji=It||function(){return Ba.Date.now()};function Xi(e,a,t){return a=t?c:a,a=e&&null==a?e.length:a,xn(e,k,c,c,c,c,a)}function $i(e,a){var t;if("function"!=typeof a)throw new ra(f);return e=zf(e),function(){return--e>0&&(t=a.apply(this,arguments)),e<=1&&(a=c),t}}var ef=Ac(function(e,a,t){var r=m;if(t.length){var c=St(t,Nn(ef));r|=w}return xn(e,r,a,t,c)}),af=Ac(function(e,a,t){var r=m|g;if(t.length){var c=St(t,Nn(af));r|=w}return xn(a,r,e,t,c)});function tf(e,a,t){var r,n,i,o,d,s,b=0,u=!1,l=!1,p=!0;if("function"!=typeof e)throw new ra(f);function h(a){var t=r,i=n;return r=n=c,b=a,o=e.apply(i,t)}function m(e){var t=e-s;return s===c||t>=a||t<0||l&&e-b>=i}function g(){var e=Ji();if(m(e))return v(e);d=ti(g,function(e){var t=a-(e-s);return l?Gt(t,i-(e-b)):t}(e))}function v(e){return d=c,p&&r?h(e):(r=n=c,o)}function y(){var e=Ji(),t=m(e);if(r=arguments,n=this,s=e,t){if(d===c)return function(e){return b=e,d=ti(g,a),u?h(e):o}(s);if(l)return d=ti(g,a),h(s)}return d===c&&(d=ti(g,a)),o}return a=Uf(a)||0,Sf(t)&&(u=!!t.leading,i=(l="maxWait"in t)?Vt(Uf(t.maxWait)||0,a):i,p="trailing"in t?!!t.trailing:p),y.cancel=function(){d!==c&&Kc(d),b=0,r=s=n=d=c},y.flush=function(){return d===c?o:v(Ji())},y}var rf=Ac(function(e,a){return Pr(e,1,a)}),cf=Ac(function(e,a,t){return Pr(e,Uf(a)||0,t)});function nf(e,a){if("function"!=typeof e||null!=a&&"function"!=typeof a)throw new ra(f);var t=function(){var r=arguments,c=a?a.apply(this,r):r[0],n=t.cache;if(n.has(c))return n.get(c);var i=e.apply(this,r);return t.cache=n.set(c,i)||n,i};return t.cache=new(nf.Cache||yr),t}function ff(e){if("function"!=typeof e)throw new ra(f);return function(){var a=arguments;switch(a.length){case 0:return!e.call(this);case 1:return!e.call(this,a[0]);case 2:return!e.call(this,a[0],a[1]);case 3:return!e.call(this,a[0],a[1],a[2])}return!e.apply(this,a)}}nf.Cache=yr;var of=Wc(function(e,a){var t=(a=1==a.length&&mf(a[0])?Xa(a[0],ht(In())):Xa(Hr(a,1),ht(In()))).length;return Ac(function(r){for(var c=-1,n=Gt(r.length,t);++c<n;)r[c]=a[c].call(this,r[c]);return Va(e,this,r)})}),df=Ac(function(e,a){var t=St(a,Nn(df));return xn(e,w,c,a,t)}),sf=Ac(function(e,a){var t=St(a,Nn(sf));return xn(e,A,c,a,t)}),bf=Cn(function(e,a){return xn(e,x,c,c,c,a)});function uf(e,a){return e===a||e!=e&&a!=a}var lf=yn(Xr),pf=yn(function(e,a){return e>=a}),hf=rc(function(){return arguments}())?rc:function(e){return Tf(e)&&da.call(e,"callee")&&!Ma.call(e,"callee")},mf=t.isArray,gf=La?ht(La):function(e){return Tf(e)&&Jr(e)==fe};function vf(e){return null!=e&&Ef(e.length)&&!kf(e)}function yf(e){return Tf(e)&&vf(e)}var _f=zt||Ho,wf=Da?ht(Da):function(e){return Tf(e)&&Jr(e)==V};function Af(e){if(!Tf(e))return!1;var a=Jr(e);return a==W||a==G||"string"==typeof e.message&&"string"==typeof e.name&&!Rf(e)}function kf(e){if(!Sf(e))return!1;var a=Jr(e);return a==Y||a==K||a==U||a==$}function xf(e){return"number"==typeof e&&e==zf(e)}function Ef(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=M}function Sf(e){var a=typeof e;return null!=e&&("object"==a||"function"==a)}function Tf(e){return null!=e&&"object"==typeof e}var jf=za?ht(za):function(e){return Tf(e)&&qn(e)==Q};function Cf(e){return"number"==typeof e||Tf(e)&&Jr(e)==Z}function Rf(e){if(!Tf(e)||Jr(e)!=X)return!1;var a=Ra(e);if(null===a)return!0;var t=da.call(a,"constructor")&&a.constructor;return"function"==typeof t&&t instanceof t&&oa.call(t)==la}var Of=qa?ht(qa):function(e){return Tf(e)&&Jr(e)==ee};var Bf=Ua?ht(Ua):function(e){return Tf(e)&&qn(e)==ae};function Mf(e){return"string"==typeof e||!mf(e)&&Tf(e)&&Jr(e)==te}function Nf(e){return"symbol"==typeof e||Tf(e)&&Jr(e)==re}var If=Ha?ht(Ha):function(e){return Tf(e)&&Ef(e.length)&&!!Ea[Jr(e)]};var Pf=yn(sc),Ff=yn(function(e,a){return e<=a});function Lf(e){if(!e)return[];if(vf(e))return Mf(e)?Ot(e):an(e);if(Fa&&e[Fa])return function(e){for(var a,t=[];!(a=e.next()).done;)t.push(a.value);return t}(e[Fa]());var a=qn(e);return(a==Q?xt:a==ae?jt:lo)(e)}function Df(e){return e?(e=Uf(e))===B||e===-B?(e<0?-1:1)*N:e==e?e:0:0===e?e:0}function zf(e){var a=Df(e),t=a%1;return a==a?t?a-t:a:0}function qf(e){return e?Mr(zf(e),0,P):0}function Uf(e){if("number"==typeof e)return e;if(Nf(e))return I;if(Sf(e)){var a="function"==typeof e.valueOf?e.valueOf():e;e=Sf(a)?a+"":a}if("string"!=typeof e)return 0===e?e:+e;e=e.replace(Me,"");var t=Ve.test(e);return t||We.test(e)?Ca(e.slice(2),t?2:8):He.test(e)?I:+e}function Hf(e){return tn(e,co(e))}function Vf(e){return null==e?"":Ic(e)}var Gf=cn(function(e,a){if(Zn(a)||vf(a))tn(a,ro(a),e);else for(var t in a)da.call(a,t)&&Tr(e,t,a[t])}),Wf=cn(function(e,a){tn(a,co(a),e)}),Yf=cn(function(e,a,t,r){tn(a,co(a),e,r)}),Kf=cn(function(e,a,t,r){tn(a,ro(a),e,r)}),Qf=Cn(Br);var Zf=Ac(function(e,a){e=ea(e);var t=-1,r=a.length,n=r>2?a[2]:c;for(n&&Wn(a[0],a[1],n)&&(r=1);++t<r;)for(var i=a[t],f=co(i),o=-1,d=f.length;++o<d;){var s=f[o],b=e[s];(b===c||uf(b,ia[s])&&!da.call(e,s))&&(e[s]=i[s])}return e}),Jf=Ac(function(e){return e.push(c,Sn),Va(io,c,e)});function Xf(e,a,t){var r=null==e?c:Qr(e,a);return r===c?t:r}function $f(e,a){return null!=e&&Un(e,a,ec)}var eo=pn(function(e,a,t){null!=a&&"function"!=typeof a.toString&&(a=ua.call(a)),e[a]=t},To(Ro)),ao=pn(function(e,a,t){null!=a&&"function"!=typeof a.toString&&(a=ua.call(a)),da.call(e,a)?e[a].push(t):e[a]=[t]},In),to=Ac(tc);function ro(e){return vf(e)?Ar(e):oc(e)}function co(e){return vf(e)?Ar(e,!0):dc(e)}var no=cn(function(e,a,t){pc(e,a,t)}),io=cn(function(e,a,t,r){pc(e,a,t,r)}),fo=Cn(function(e,a){var t={};if(null==e)return t;var r=!1;a=Xa(a,function(a){return a=Gc(a,e),r||(r=a.length>1),a}),tn(e,On(e),t),r&&(t=Nr(t,b|u|l,Tn));for(var c=a.length;c--;)Fc(t,a[c]);return t});var oo=Cn(function(e,a){return null==e?{}:function(e,a){return gc(e,a,function(a,t){return $f(e,t)})}(e,a)});function so(e,a){if(null==e)return{};var t=Xa(On(e),function(e){return[e]});return a=In(a),gc(e,t,function(e,t){return a(e,t[0])})}var bo=kn(ro),uo=kn(co);function lo(e){return null==e?[]:mt(e,ro(e))}var po=dn(function(e,a,t){return a=a.toLowerCase(),e+(t?ho(a):a)});function ho(e){return ko(Vf(e).toLowerCase())}function mo(e){return(e=Vf(e))&&e.replace(Ke,_t).replace(va,"")}var go=dn(function(e,a,t){return e+(t?"-":"")+a.toLowerCase()}),vo=dn(function(e,a,t){return e+(t?" ":"")+a.toLowerCase()}),yo=on("toLowerCase");var _o=dn(function(e,a,t){return e+(t?"_":"")+a.toLowerCase()});var wo=dn(function(e,a,t){return e+(t?" ":"")+ko(a)});var Ao=dn(function(e,a,t){return e+(t?" ":"")+a.toUpperCase()}),ko=on("toUpperCase");function xo(e,a,t){return e=Vf(e),(a=t?c:a)===c?function(e){return Aa.test(e)}(e)?function(e){return e.match(_a)||[]}(e):function(e){return e.match(De)||[]}(e):e.match(a)||[]}var Eo=Ac(function(e,a){try{return Va(e,c,a)}catch(e){return Af(e)?e:new Je(e)}}),So=Cn(function(e,a){return Wa(a,function(a){a=oi(a),Or(e,a,ef(e[a],e))}),e});function To(e){return function(){return e}}var jo=un(),Co=un(!0);function Ro(e){return e}function Oo(e){return fc("function"==typeof e?e:Nr(e,b))}var Bo=Ac(function(e,a){return function(t){return tc(t,e,a)}}),Mo=Ac(function(e,a){return function(t){return tc(e,t,a)}});function No(e,a,t){var r=ro(a),c=Kr(a,r);null!=t||Sf(a)&&(c.length||!r.length)||(t=a,a=e,e=this,c=Kr(a,ro(a)));var n=!(Sf(t)&&"chain"in t&&!t.chain),i=kf(e);return Wa(c,function(t){var r=a[t];e[t]=r,i&&(e.prototype[t]=function(){var a=this.__chain__;if(n||a){var t=e(this.__wrapped__);return(t.__actions__=an(this.__actions__)).push({func:r,args:arguments,thisArg:e}),t.__chain__=a,t}return r.apply(e,$a([this.value()],arguments))})}),e}function Io(){}var Po=mn(Xa),Fo=mn(Ka),Lo=mn(tt);function Do(e){return Yn(e)?st(oi(e)):function(e){return function(a){return Qr(a,e)}}(e)}var zo=vn(),qo=vn(!0);function Uo(){return[]}function Ho(){return!1}var Vo=hn(function(e,a){return e+a},0),Go=wn("ceil"),Wo=hn(function(e,a){return e/a},1),Yo=wn("floor");var Ko=hn(function(e,a){return e*a},1),Qo=wn("round"),Zo=hn(function(e,a){return e-a},0);return ur.after=function(e,a){if("function"!=typeof a)throw new ra(f);return e=zf(e),function(){if(--e<1)return a.apply(this,arguments)}},ur.ary=Xi,ur.assign=Gf,ur.assignIn=Wf,ur.assignInWith=Yf,ur.assignWith=Kf,ur.at=Qf,ur.before=$i,ur.bind=ef,ur.bindAll=So,ur.bindKey=af,ur.castArray=function(){if(!arguments.length)return[];var e=arguments[0];return mf(e)?e:[e]},ur.chain=Fi,ur.chunk=function(e,a,r){a=(r?Wn(e,a,r):a===c)?1:Vt(zf(a),0);var n=null==e?0:e.length;if(!n||a<1)return[];for(var i=0,f=0,o=t(Ft(n/a));i<n;)o[f++]=Cc(e,i,i+=a);return o},ur.compact=function(e){for(var a=-1,t=null==e?0:e.length,r=0,c=[];++a<t;){var n=e[a];n&&(c[r++]=n)}return c},ur.concat=function(){var e=arguments.length;if(!e)return[];for(var a=t(e-1),r=arguments[0],c=e;c--;)a[c-1]=arguments[c];return $a(mf(r)?an(r):[r],Hr(a,1))},ur.cond=function(e){var a=null==e?0:e.length,t=In();return e=a?Xa(e,function(e){if("function"!=typeof e[1])throw new ra(f);return[t(e[0]),e[1]]}):[],Ac(function(t){for(var r=-1;++r<a;){var c=e[r];if(Va(c[0],this,t))return Va(c[1],this,t)}})},ur.conforms=function(e){return function(e){var a=ro(e);return function(t){return Ir(t,e,a)}}(Nr(e,b))},ur.constant=To,ur.countBy=zi,ur.create=function(e,a){var t=lr(e);return null==a?t:Rr(t,a)},ur.curry=function e(a,t,r){var n=xn(a,y,c,c,c,c,c,t=r?c:t);return n.placeholder=e.placeholder,n},ur.curryRight=function e(a,t,r){var n=xn(a,_,c,c,c,c,c,t=r?c:t);return n.placeholder=e.placeholder,n},ur.debounce=tf,ur.defaults=Zf,ur.defaultsDeep=Jf,ur.defer=rf,ur.delay=cf,ur.difference=bi,ur.differenceBy=ui,ur.differenceWith=li,ur.drop=function(e,a,t){var r=null==e?0:e.length;return r?Cc(e,(a=t||a===c?1:zf(a))<0?0:a,r):[]},ur.dropRight=function(e,a,t){var r=null==e?0:e.length;return r?Cc(e,0,(a=r-(a=t||a===c?1:zf(a)))<0?0:a):[]},ur.dropRightWhile=function(e,a){return e&&e.length?Dc(e,In(a,3),!0,!0):[]},ur.dropWhile=function(e,a){return e&&e.length?Dc(e,In(a,3),!0):[]},ur.fill=function(e,a,t,r){var n=null==e?0:e.length;return n?(t&&"number"!=typeof t&&Wn(e,a,t)&&(t=0,r=n),function(e,a,t,r){var n=e.length;for((t=zf(t))<0&&(t=-t>n?0:n+t),(r=r===c||r>n?n:zf(r))<0&&(r+=n),r=t>r?0:qf(r);t<r;)e[t++]=a;return e}(e,a,t,r)):[]},ur.filter=function(e,a){return(mf(e)?Qa:Ur)(e,In(a,3))},ur.flatMap=function(e,a){return Hr(Ki(e,a),1)},ur.flatMapDeep=function(e,a){return Hr(Ki(e,a),B)},ur.flatMapDepth=function(e,a,t){return t=t===c?1:zf(t),Hr(Ki(e,a),t)},ur.flatten=mi,ur.flattenDeep=function(e){return null!=e&&e.length?Hr(e,B):[]},ur.flattenDepth=function(e,a){return null!=e&&e.length?Hr(e,a=a===c?1:zf(a)):[]},ur.flip=function(e){return xn(e,E)},ur.flow=jo,ur.flowRight=Co,ur.fromPairs=function(e){for(var a=-1,t=null==e?0:e.length,r={};++a<t;){var c=e[a];r[c[0]]=c[1]}return r},ur.functions=function(e){return null==e?[]:Kr(e,ro(e))},ur.functionsIn=function(e){return null==e?[]:Kr(e,co(e))},ur.groupBy=Gi,ur.initial=function(e){return null!=e&&e.length?Cc(e,0,-1):[]},ur.intersection=vi,ur.intersectionBy=yi,ur.intersectionWith=_i,ur.invert=eo,ur.invertBy=ao,ur.invokeMap=Wi,ur.iteratee=Oo,ur.keyBy=Yi,ur.keys=ro,ur.keysIn=co,ur.map=Ki,ur.mapKeys=function(e,a){var t={};return a=In(a,3),Wr(e,function(e,r,c){Or(t,a(e,r,c),e)}),t},ur.mapValues=function(e,a){var t={};return a=In(a,3),Wr(e,function(e,r,c){Or(t,r,a(e,r,c))}),t},ur.matches=function(e){return uc(Nr(e,b))},ur.matchesProperty=function(e,a){return lc(e,Nr(a,b))},ur.memoize=nf,ur.merge=no,ur.mergeWith=io,ur.method=Bo,ur.methodOf=Mo,ur.mixin=No,ur.negate=ff,ur.nthArg=function(e){return e=zf(e),Ac(function(a){return hc(a,e)})},ur.omit=fo,ur.omitBy=function(e,a){return so(e,ff(In(a)))},ur.once=function(e){return $i(2,e)},ur.orderBy=function(e,a,t,r){return null==e?[]:(mf(a)||(a=null==a?[]:[a]),mf(t=r?c:t)||(t=null==t?[]:[t]),mc(e,a,t))},ur.over=Po,ur.overArgs=of,ur.overEvery=Fo,ur.overSome=Lo,ur.partial=df,ur.partialRight=sf,ur.partition=Qi,ur.pick=oo,ur.pickBy=so,ur.property=Do,ur.propertyOf=function(e){return function(a){return null==e?c:Qr(e,a)}},ur.pull=Ai,ur.pullAll=ki,ur.pullAllBy=function(e,a,t){return e&&e.length&&a&&a.length?vc(e,a,In(t,2)):e},ur.pullAllWith=function(e,a,t){return e&&e.length&&a&&a.length?vc(e,a,c,t):e},ur.pullAt=xi,ur.range=zo,ur.rangeRight=qo,ur.rearg=bf,ur.reject=function(e,a){return(mf(e)?Qa:Ur)(e,ff(In(a,3)))},ur.remove=function(e,a){var t=[];if(!e||!e.length)return t;var r=-1,c=[],n=e.length;for(a=In(a,3);++r<n;){var i=e[r];a(i,r,e)&&(t.push(i),c.push(r))}return yc(e,c),t},ur.rest=function(e,a){if("function"!=typeof e)throw new ra(f);return Ac(e,a=a===c?a:zf(a))},ur.reverse=Ei,ur.sampleSize=function(e,a,t){return a=(t?Wn(e,a,t):a===c)?1:zf(a),(mf(e)?xr:xc)(e,a)},ur.set=function(e,a,t){return null==e?e:Ec(e,a,t)},ur.setWith=function(e,a,t,r){return r="function"==typeof r?r:c,null==e?e:Ec(e,a,t,r)},ur.shuffle=function(e){return(mf(e)?Er:jc)(e)},ur.slice=function(e,a,t){var r=null==e?0:e.length;return r?(t&&"number"!=typeof t&&Wn(e,a,t)?(a=0,t=r):(a=null==a?0:zf(a),t=t===c?r:zf(t)),Cc(e,a,t)):[]},ur.sortBy=Zi,ur.sortedUniq=function(e){return e&&e.length?Mc(e):[]},ur.sortedUniqBy=function(e,a){return e&&e.length?Mc(e,In(a,2)):[]},ur.split=function(e,a,t){return t&&"number"!=typeof t&&Wn(e,a,t)&&(a=t=c),(t=t===c?P:t>>>0)?(e=Vf(e))&&("string"==typeof a||null!=a&&!Of(a))&&!(a=Ic(a))&&kt(e)?Yc(Ot(e),0,t):e.split(a,t):[]},ur.spread=function(e,a){if("function"!=typeof e)throw new ra(f);return a=null==a?0:Vt(zf(a),0),Ac(function(t){var r=t[a],c=Yc(t,0,a);return r&&$a(c,r),Va(e,this,c)})},ur.tail=function(e){var a=null==e?0:e.length;return a?Cc(e,1,a):[]},ur.take=function(e,a,t){return e&&e.length?Cc(e,0,(a=t||a===c?1:zf(a))<0?0:a):[]},ur.takeRight=function(e,a,t){var r=null==e?0:e.length;return r?Cc(e,(a=r-(a=t||a===c?1:zf(a)))<0?0:a,r):[]},ur.takeRightWhile=function(e,a){return e&&e.length?Dc(e,In(a,3),!1,!0):[]},ur.takeWhile=function(e,a){return e&&e.length?Dc(e,In(a,3)):[]},ur.tap=function(e,a){return a(e),e},ur.throttle=function(e,a,t){var r=!0,c=!0;if("function"!=typeof e)throw new ra(f);return Sf(t)&&(r="leading"in t?!!t.leading:r,c="trailing"in t?!!t.trailing:c),tf(e,a,{leading:r,maxWait:a,trailing:c})},ur.thru=Li,ur.toArray=Lf,ur.toPairs=bo,ur.toPairsIn=uo,ur.toPath=function(e){return mf(e)?Xa(e,oi):Nf(e)?[e]:an(fi(Vf(e)))},ur.toPlainObject=Hf,ur.transform=function(e,a,t){var r=mf(e),c=r||_f(e)||If(e);if(a=In(a,4),null==t){var n=e&&e.constructor;t=c?r?new n:[]:Sf(e)&&kf(n)?lr(Ra(e)):{}}return(c?Wa:Wr)(e,function(e,r,c){return a(t,e,r,c)}),t},ur.unary=function(e){return Xi(e,1)},ur.union=Si,ur.unionBy=Ti,ur.unionWith=ji,ur.uniq=function(e){return e&&e.length?Pc(e):[]},ur.uniqBy=function(e,a){return e&&e.length?Pc(e,In(a,2)):[]},ur.uniqWith=function(e,a){return a="function"==typeof a?a:c,e&&e.length?Pc(e,c,a):[]},ur.unset=function(e,a){return null==e||Fc(e,a)},ur.unzip=Ci,ur.unzipWith=Ri,ur.update=function(e,a,t){return null==e?e:Lc(e,a,Vc(t))},ur.updateWith=function(e,a,t,r){return r="function"==typeof r?r:c,null==e?e:Lc(e,a,Vc(t),r)},ur.values=lo,ur.valuesIn=function(e){return null==e?[]:mt(e,co(e))},ur.without=Oi,ur.words=xo,ur.wrap=function(e,a){return df(Vc(a),e)},ur.xor=Bi,ur.xorBy=Mi,ur.xorWith=Ni,ur.zip=Ii,ur.zipObject=function(e,a){return Uc(e||[],a||[],Tr)},ur.zipObjectDeep=function(e,a){return Uc(e||[],a||[],Ec)},ur.zipWith=Pi,ur.entries=bo,ur.entriesIn=uo,ur.extend=Wf,ur.extendWith=Yf,No(ur,ur),ur.add=Vo,ur.attempt=Eo,ur.camelCase=po,ur.capitalize=ho,ur.ceil=Go,ur.clamp=function(e,a,t){return t===c&&(t=a,a=c),t!==c&&(t=(t=Uf(t))==t?t:0),a!==c&&(a=(a=Uf(a))==a?a:0),Mr(Uf(e),a,t)},ur.clone=function(e){return Nr(e,l)},ur.cloneDeep=function(e){return Nr(e,b|l)},ur.cloneDeepWith=function(e,a){return Nr(e,b|l,a="function"==typeof a?a:c)},ur.cloneWith=function(e,a){return Nr(e,l,a="function"==typeof a?a:c)},ur.conformsTo=function(e,a){return null==a||Ir(e,a,ro(a))},ur.deburr=mo,ur.defaultTo=function(e,a){return null==e||e!=e?a:e},ur.divide=Wo,ur.endsWith=function(e,a,t){e=Vf(e),a=Ic(a);var r=e.length,n=t=t===c?r:Mr(zf(t),0,r);return(t-=a.length)>=0&&e.slice(t,n)==a},ur.eq=uf,ur.escape=function(e){return(e=Vf(e))&&xe.test(e)?e.replace(Ae,wt):e},ur.escapeRegExp=function(e){return(e=Vf(e))&&Be.test(e)?e.replace(Oe,"\\$&"):e},ur.every=function(e,a,t){var r=mf(e)?Ka:zr;return t&&Wn(e,a,t)&&(a=c),r(e,In(a,3))},ur.find=qi,ur.findIndex=pi,ur.findKey=function(e,a){return ct(e,In(a,3),Wr)},ur.findLast=Ui,ur.findLastIndex=hi,ur.findLastKey=function(e,a){return ct(e,In(a,3),Yr)},ur.floor=Yo,ur.forEach=Hi,ur.forEachRight=Vi,ur.forIn=function(e,a){return null==e?e:Vr(e,In(a,3),co)},ur.forInRight=function(e,a){return null==e?e:Gr(e,In(a,3),co)},ur.forOwn=function(e,a){return e&&Wr(e,In(a,3))},ur.forOwnRight=function(e,a){return e&&Yr(e,In(a,3))},ur.get=Xf,ur.gt=lf,ur.gte=pf,ur.has=function(e,a){return null!=e&&Un(e,a,$r)},ur.hasIn=$f,ur.head=gi,ur.identity=Ro,ur.includes=function(e,a,t,r){e=vf(e)?e:lo(e),t=t&&!r?zf(t):0;var c=e.length;return t<0&&(t=Vt(c+t,0)),Mf(e)?t<=c&&e.indexOf(a,t)>-1:!!c&&it(e,a,t)>-1},ur.indexOf=function(e,a,t){var r=null==e?0:e.length;if(!r)return-1;var c=null==t?0:zf(t);return c<0&&(c=Vt(r+c,0)),it(e,a,c)},ur.inRange=function(e,a,t){return a=Df(a),t===c?(t=a,a=0):t=Df(t),function(e,a,t){return e>=Gt(a,t)&&e<Vt(a,t)}(e=Uf(e),a,t)},ur.invoke=to,ur.isArguments=hf,ur.isArray=mf,ur.isArrayBuffer=gf,ur.isArrayLike=vf,ur.isArrayLikeObject=yf,ur.isBoolean=function(e){return!0===e||!1===e||Tf(e)&&Jr(e)==H},ur.isBuffer=_f,ur.isDate=wf,ur.isElement=function(e){return Tf(e)&&1===e.nodeType&&!Rf(e)},ur.isEmpty=function(e){if(null==e)return!0;if(vf(e)&&(mf(e)||"string"==typeof e||"function"==typeof e.splice||_f(e)||If(e)||hf(e)))return!e.length;var a=qn(e);if(a==Q||a==ae)return!e.size;if(Zn(e))return!oc(e).length;for(var t in e)if(da.call(e,t))return!1;return!0},ur.isEqual=function(e,a){return cc(e,a)},ur.isEqualWith=function(e,a,t){var r=(t="function"==typeof t?t:c)?t(e,a):c;return r===c?cc(e,a,c,t):!!r},ur.isError=Af,ur.isFinite=function(e){return"number"==typeof e&&qt(e)},ur.isFunction=kf,ur.isInteger=xf,ur.isLength=Ef,ur.isMap=jf,ur.isMatch=function(e,a){return e===a||nc(e,a,Fn(a))},ur.isMatchWith=function(e,a,t){return t="function"==typeof t?t:c,nc(e,a,Fn(a),t)},ur.isNaN=function(e){return Cf(e)&&e!=+e},ur.isNative=function(e){if(Qn(e))throw new Je(i);return ic(e)},ur.isNil=function(e){return null==e},ur.isNull=function(e){return null===e},ur.isNumber=Cf,ur.isObject=Sf,ur.isObjectLike=Tf,ur.isPlainObject=Rf,ur.isRegExp=Of,ur.isSafeInteger=function(e){return xf(e)&&e>=-M&&e<=M},ur.isSet=Bf,ur.isString=Mf,ur.isSymbol=Nf,ur.isTypedArray=If,ur.isUndefined=function(e){return e===c},ur.isWeakMap=function(e){return Tf(e)&&qn(e)==ne},ur.isWeakSet=function(e){return Tf(e)&&Jr(e)==ie},ur.join=function(e,a){return null==e?"":Ut.call(e,a)},ur.kebabCase=go,ur.last=wi,ur.lastIndexOf=function(e,a,t){var r=null==e?0:e.length;if(!r)return-1;var n=r;return t!==c&&(n=(n=zf(t))<0?Vt(r+n,0):Gt(n,r-1)),a==a?function(e,a,t){for(var r=t+1;r--;)if(e[r]===a)return r;return r}(e,a,n):nt(e,ot,n,!0)},ur.lowerCase=vo,ur.lowerFirst=yo,ur.lt=Pf,ur.lte=Ff,ur.max=function(e){return e&&e.length?qr(e,Ro,Xr):c},ur.maxBy=function(e,a){return e&&e.length?qr(e,In(a,2),Xr):c},ur.mean=function(e){return dt(e,Ro)},ur.meanBy=function(e,a){return dt(e,In(a,2))},ur.min=function(e){return e&&e.length?qr(e,Ro,sc):c},ur.minBy=function(e,a){return e&&e.length?qr(e,In(a,2),sc):c},ur.stubArray=Uo,ur.stubFalse=Ho,ur.stubObject=function(){return{}},ur.stubString=function(){return""},ur.stubTrue=function(){return!0},ur.multiply=Ko,ur.nth=function(e,a){return e&&e.length?hc(e,zf(a)):c},ur.noConflict=function(){return Ba._===this&&(Ba._=pa),this},ur.noop=Io,ur.now=Ji,ur.pad=function(e,a,t){e=Vf(e);var r=(a=zf(a))?Rt(e):0;if(!a||r>=a)return e;var c=(a-r)/2;return gn(Lt(c),t)+e+gn(Ft(c),t)},ur.padEnd=function(e,a,t){e=Vf(e);var r=(a=zf(a))?Rt(e):0;return a&&r<a?e+gn(a-r,t):e},ur.padStart=function(e,a,t){e=Vf(e);var r=(a=zf(a))?Rt(e):0;return a&&r<a?gn(a-r,t)+e:e},ur.parseInt=function(e,a,t){return t||null==a?a=0:a&&(a=+a),Yt(Vf(e).replace(Ne,""),a||0)},ur.random=function(e,a,t){if(t&&"boolean"!=typeof t&&Wn(e,a,t)&&(a=t=c),t===c&&("boolean"==typeof a?(t=a,a=c):"boolean"==typeof e&&(t=e,e=c)),e===c&&a===c?(e=0,a=1):(e=Df(e),a===c?(a=e,e=0):a=Df(a)),e>a){var r=e;e=a,a=r}if(t||e%1||a%1){var n=Kt();return Gt(e+n*(a-e+ja("1e-"+((n+"").length-1))),a)}return _c(e,a)},ur.reduce=function(e,a,t){var r=mf(e)?et:ut,c=arguments.length<3;return r(e,In(a,4),t,c,Lr)},ur.reduceRight=function(e,a,t){var r=mf(e)?at:ut,c=arguments.length<3;return r(e,In(a,4),t,c,Dr)},ur.repeat=function(e,a,t){return a=(t?Wn(e,a,t):a===c)?1:zf(a),wc(Vf(e),a)},ur.replace=function(){var e=arguments,a=Vf(e[0]);return e.length<3?a:a.replace(e[1],e[2])},ur.result=function(e,a,t){var r=-1,n=(a=Gc(a,e)).length;for(n||(n=1,e=c);++r<n;){var i=null==e?c:e[oi(a[r])];i===c&&(r=n,i=t),e=kf(i)?i.call(e):i}return e},ur.round=Qo,ur.runInContext=e,ur.sample=function(e){return(mf(e)?kr:kc)(e)},ur.size=function(e){if(null==e)return 0;if(vf(e))return Mf(e)?Rt(e):e.length;var a=qn(e);return a==Q||a==ae?e.size:oc(e).length},ur.snakeCase=_o,ur.some=function(e,a,t){var r=mf(e)?tt:Rc;return t&&Wn(e,a,t)&&(a=c),r(e,In(a,3))},ur.sortedIndex=function(e,a){return Oc(e,a)},ur.sortedIndexBy=function(e,a,t){return Bc(e,a,In(t,2))},ur.sortedIndexOf=function(e,a){var t=null==e?0:e.length;if(t){var r=Oc(e,a);if(r<t&&uf(e[r],a))return r}return-1},ur.sortedLastIndex=function(e,a){return Oc(e,a,!0)},ur.sortedLastIndexBy=function(e,a,t){return Bc(e,a,In(t,2),!0)},ur.sortedLastIndexOf=function(e,a){if(null!=e&&e.length){var t=Oc(e,a,!0)-1;if(uf(e[t],a))return t}return-1},ur.startCase=wo,ur.startsWith=function(e,a,t){return e=Vf(e),t=null==t?0:Mr(zf(t),0,e.length),a=Ic(a),e.slice(t,t+a.length)==a},ur.subtract=Zo,ur.sum=function(e){return e&&e.length?lt(e,Ro):0},ur.sumBy=function(e,a){return e&&e.length?lt(e,In(a,2)):0},ur.template=function(e,a,t){var r=ur.templateSettings;t&&Wn(e,a,t)&&(a=c),e=Vf(e),a=Yf({},a,r,En);var n,i,f=Yf({},a.imports,r.imports,En),o=ro(f),d=mt(f,o),s=0,b=a.interpolate||Qe,u="__p += '",l=aa((a.escape||Qe).source+"|"+b.source+"|"+(b===Te?qe:Qe).source+"|"+(a.evaluate||Qe).source+"|$","g"),p="//# sourceURL="+("sourceURL"in a?a.sourceURL:"lodash.templateSources["+ ++xa+"]")+"\n";e.replace(l,function(a,t,r,c,f,o){return r||(r=c),u+=e.slice(s,o).replace(Ze,At),t&&(n=!0,u+="' +\n__e("+t+") +\n'"),f&&(i=!0,u+="';\n"+f+";\n__p += '"),r&&(u+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),s=o+a.length,a}),u+="';\n";var h=a.variable;h||(u="with (obj) {\n"+u+"\n}\n"),u=(i?u.replace(ve,""):u).replace(ye,"$1").replace(_e,"$1;"),u="function("+(h||"obj")+") {\n"+(h?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(n?", __e = _.escape":"")+(i?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+u+"return __p\n}";var m=Eo(function(){return Xe(o,p+"return "+u).apply(c,d)});if(m.source=u,Af(m))throw m;return m},ur.times=function(e,a){if((e=zf(e))<1||e>M)return[];var t=P,r=Gt(e,P);a=In(a),e-=P;for(var c=pt(r,a);++t<e;)a(t);return c},ur.toFinite=Df,ur.toInteger=zf,ur.toLength=qf,ur.toLower=function(e){return Vf(e).toLowerCase()},ur.toNumber=Uf,ur.toSafeInteger=function(e){return e?Mr(zf(e),-M,M):0===e?e:0},ur.toString=Vf,ur.toUpper=function(e){return Vf(e).toUpperCase()},ur.trim=function(e,a,t){if((e=Vf(e))&&(t||a===c))return e.replace(Me,"");if(!e||!(a=Ic(a)))return e;var r=Ot(e),n=Ot(a);return Yc(r,vt(r,n),yt(r,n)+1).join("")},ur.trimEnd=function(e,a,t){if((e=Vf(e))&&(t||a===c))return e.replace(Ie,"");if(!e||!(a=Ic(a)))return e;var r=Ot(e);return Yc(r,0,yt(r,Ot(a))+1).join("")},ur.trimStart=function(e,a,t){if((e=Vf(e))&&(t||a===c))return e.replace(Ne,"");if(!e||!(a=Ic(a)))return e;var r=Ot(e);return Yc(r,vt(r,Ot(a))).join("")},ur.truncate=function(e,a){var t=S,r=T;if(Sf(a)){var n="separator"in a?a.separator:n;t="length"in a?zf(a.length):t,r="omission"in a?Ic(a.omission):r}var i=(e=Vf(e)).length;if(kt(e)){var f=Ot(e);i=f.length}if(t>=i)return e;var o=t-Rt(r);if(o<1)return r;var d=f?Yc(f,0,o).join(""):e.slice(0,o);if(n===c)return d+r;if(f&&(o+=d.length-o),Of(n)){if(e.slice(o).search(n)){var s,b=d;for(n.global||(n=aa(n.source,Vf(Ue.exec(n))+"g")),n.lastIndex=0;s=n.exec(b);)var u=s.index;d=d.slice(0,u===c?o:u)}}else if(e.indexOf(Ic(n),o)!=o){var l=d.lastIndexOf(n);l>-1&&(d=d.slice(0,l))}return d+r},ur.unescape=function(e){return(e=Vf(e))&&ke.test(e)?e.replace(we,Bt):e},ur.uniqueId=function(e){var a=++sa;return Vf(e)+a},ur.upperCase=Ao,ur.upperFirst=ko,ur.each=Hi,ur.eachRight=Vi,ur.first=gi,No(ur,function(){var e={};return Wr(ur,function(a,t){da.call(ur.prototype,t)||(e[t]=a)}),e}(),{chain:!1}),ur.VERSION="4.17.10",Wa(["bind","bindKey","curry","curryRight","partial","partialRight"],function(e){ur[e].placeholder=ur}),Wa(["drop","take"],function(e,a){mr.prototype[e]=function(t){t=t===c?1:Vt(zf(t),0);var r=this.__filtered__&&!a?new mr(this):this.clone();return r.__filtered__?r.__takeCount__=Gt(t,r.__takeCount__):r.__views__.push({size:Gt(t,P),type:e+(r.__dir__<0?"Right":"")}),r},mr.prototype[e+"Right"]=function(a){return this.reverse()[e](a).reverse()}}),Wa(["filter","map","takeWhile"],function(e,a){var t=a+1,r=t==R||3==t;mr.prototype[e]=function(e){var a=this.clone();return a.__iteratees__.push({iteratee:In(e,3),type:t}),a.__filtered__=a.__filtered__||r,a}}),Wa(["head","last"],function(e,a){var t="take"+(a?"Right":"");mr.prototype[e]=function(){return this[t](1).value()[0]}}),Wa(["initial","tail"],function(e,a){var t="drop"+(a?"":"Right");mr.prototype[e]=function(){return this.__filtered__?new mr(this):this[t](1)}}),mr.prototype.compact=function(){return this.filter(Ro)},mr.prototype.find=function(e){return this.filter(e).head()},mr.prototype.findLast=function(e){return this.reverse().find(e)},mr.prototype.invokeMap=Ac(function(e,a){return"function"==typeof e?new mr(this):this.map(function(t){return tc(t,e,a)})}),mr.prototype.reject=function(e){return this.filter(ff(In(e)))},mr.prototype.slice=function(e,a){e=zf(e);var t=this;return t.__filtered__&&(e>0||a<0)?new mr(t):(e<0?t=t.takeRight(-e):e&&(t=t.drop(e)),a!==c&&(t=(a=zf(a))<0?t.dropRight(-a):t.take(a-e)),t)},mr.prototype.takeRightWhile=function(e){return this.reverse().takeWhile(e).reverse()},mr.prototype.toArray=function(){return this.take(P)},Wr(mr.prototype,function(e,a){var t=/^(?:filter|find|map|reject)|While$/.test(a),r=/^(?:head|last)$/.test(a),n=ur[r?"take"+("last"==a?"Right":""):a],i=r||/^find/.test(a);n&&(ur.prototype[a]=function(){var a=this.__wrapped__,f=r?[1]:arguments,o=a instanceof mr,d=f[0],s=o||mf(a),b=function(e){var a=n.apply(ur,$a([e],f));return r&&u?a[0]:a};s&&t&&"function"==typeof d&&1!=d.length&&(o=s=!1);var u=this.__chain__,l=!!this.__actions__.length,p=i&&!u,h=o&&!l;if(!i&&s){a=h?a:new mr(this);var m=e.apply(a,f);return m.__actions__.push({func:Li,args:[b],thisArg:c}),new hr(m,u)}return p&&h?e.apply(this,f):(m=this.thru(b),p?r?m.value()[0]:m.value():m)})}),Wa(["pop","push","shift","sort","splice","unshift"],function(e){var a=ca[e],t=/^(?:push|sort|unshift)$/.test(e)?"tap":"thru",r=/^(?:pop|shift)$/.test(e);ur.prototype[e]=function(){var e=arguments;if(r&&!this.__chain__){var c=this.value();return a.apply(mf(c)?c:[],e)}return this[t](function(t){return a.apply(mf(t)?t:[],e)})}}),Wr(mr.prototype,function(e,a){var t=ur[a];if(t){var r=t.name+"";(rr[r]||(rr[r]=[])).push({name:a,func:t})}}),rr[ln(c,g).name]=[{name:"wrapper",func:c}],mr.prototype.clone=function(){var e=new mr(this.__wrapped__);return e.__actions__=an(this.__actions__),e.__dir__=this.__dir__,e.__filtered__=this.__filtered__,e.__iteratees__=an(this.__iteratees__),e.__takeCount__=this.__takeCount__,e.__views__=an(this.__views__),e},mr.prototype.reverse=function(){if(this.__filtered__){var e=new mr(this);e.__dir__=-1,e.__filtered__=!0}else(e=this.clone()).__dir__*=-1;return e},mr.prototype.value=function(){var e=this.__wrapped__.value(),a=this.__dir__,t=mf(e),r=a<0,c=t?e.length:0,n=function(e,a,t){for(var r=-1,c=t.length;++r<c;){var n=t[r],i=n.size;switch(n.type){case"drop":e+=i;break;case"dropRight":a-=i;break;case"take":a=Gt(a,e+i);break;case"takeRight":e=Vt(e,a-i)}}return{start:e,end:a}}(0,c,this.__views__),i=n.start,f=n.end,o=f-i,d=r?f:i-1,s=this.__iteratees__,b=s.length,u=0,l=Gt(o,this.__takeCount__);if(!t||!r&&c==o&&l==o)return zc(e,this.__actions__);var p=[];e:for(;o--&&u<l;){for(var h=-1,m=e[d+=a];++h<b;){var g=s[h],v=g.iteratee,y=g.type,_=v(m);if(y==O)m=_;else if(!_){if(y==R)continue e;break e}}p[u++]=m}return p},ur.prototype.at=Di,ur.prototype.chain=function(){return Fi(this)},ur.prototype.commit=function(){return new hr(this.value(),this.__chain__)},ur.prototype.next=function(){this.__values__===c&&(this.__values__=Lf(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?c:this.__values__[this.__index__++]}},ur.prototype.plant=function(e){for(var a,t=this;t instanceof pr;){var r=si(t);r.__index__=0,r.__values__=c,a?n.__wrapped__=r:a=r;var n=r;t=t.__wrapped__}return n.__wrapped__=e,a},ur.prototype.reverse=function(){var e=this.__wrapped__;if(e instanceof mr){var a=e;return this.__actions__.length&&(a=new mr(this)),(a=a.reverse()).__actions__.push({func:Li,args:[Ei],thisArg:c}),new hr(a,this.__chain__)}return this.thru(Ei)},ur.prototype.toJSON=ur.prototype.valueOf=ur.prototype.value=function(){return zc(this.__wrapped__,this.__actions__)},ur.prototype.first=ur.prototype.head,Fa&&(ur.prototype[Fa]=function(){return this}),ur}();Ba._=Mt,(r=function(){return Mt}.call(a,t,a,e))===c||(e.exports=r)}).call(this)}).call(this,t(25)(e))},function(e,a){var t=function(){"use strict";return void 0===this}();if(t)e.exports={freeze:Object.freeze,defineProperty:Object.defineProperty,getDescriptor:Object.getOwnPropertyDescriptor,keys:Object.keys,names:Object.getOwnPropertyNames,getPrototypeOf:Object.getPrototypeOf,isArray:Array.isArray,isES5:t,propertyIsWritable:function(e,a){var t=Object.getOwnPropertyDescriptor(e,a);return!(t&&!t.writable&&!t.set)}};else{var r={}.hasOwnProperty,c={}.toString,n={}.constructor.prototype,i=function(e){var a=[];for(var t in e)r.call(e,t)&&a.push(t);return a};e.exports={isArray:function(e){try{return"[object Array]"===c.call(e)}catch(e){return!1}},keys:i,names:i,defineProperty:function(e,a,t){return e[a]=t.value,e},getDescriptor:function(e,a){return{value:e[a]}},freeze:function(e){return e},getPrototypeOf:function(e){try{return Object(e).constructor.prototype}catch(e){return n}},isES5:t,propertyIsWritable:function(){return!0}}}},function(e,a,t){var r=t(4);e.exports=function(e){return(e=r(e)).toUpperCase()}},function(e,a,t){var r=t(35);e.exports=function(e){return r(e,"Number")}},function(e,a,t){var r=t(31);e.exports=function(e){return"number"==typeof e?e:e?"string"==typeof e?parseFloat(e):r(e)?NaN:Number(e):0}},function(e,a,t){var r=t(35);e.exports=function(e){return r(e,"Object")}},function(e,a,t){var r=t(149),c=t(104),n=t(256);e.exports=function(e,a){return e=null==e?r:~~e,a=null==a?c:~~a,Math.round(n(e-.5,a+.499999999999))}},function(e,a){e.exports=function(e,a){return e===a?0!==e||1/e==1/a:e!=e&&a!=a}},function(e,a,t){var r=t(48);function c(e,a){return e===a}e.exports=function(e,a){return a=a||c,r(e,function(e,t,r){for(var c=r.length;++t<c;)if(a(e,r[t]))return!1;return!0})}},function(e,a){e.exports=function(e,a,t){if(t=t||0,null==e)return-1;for(var r=e.length,c=t<0?r+t:t;c<r;){if(e[c]===a)return c;c++}return-1}},function(e,a){var t,r=/^\[object (.*)\]$/,c=Object.prototype.toString;e.exports=function(e){return null===e?"Null":e===t?"Undefined":r.exec(c.call(e))[1]}},function(e,a){e.exports=function(e,a){if(null==a)return e;for(var t=e.length,r=-1,c=a.length;++r<c;)e[t+r]=a[r];return e}},function(e,a,t){e.exports=h;var r=t(8),c=t(0),n=t(273),i=t(160),f=t(2),o="win32"===process.platform?0:process.umask(),d=t(109),s=t(159);c(h,s),h.dirmode=parseInt("0777",8)&~o,h.filemode=parseInt("0666",8)&~o;var b=t(268),u=t(267),l=t(266),p=t(265);function h(e,a){"string"==typeof e&&(e={path:e});var t=h;switch(d(e)){case"Directory":t=b;break;case"File":t=l;break;case"Link":case"SymbolicLink":t=u;break;case null:default:t=p}if(!(this instanceof t))return new t(e);s.call(this),e.path||this.error("Must provide a path",null,!0),this.type=e.type,this.props=e,this.depth=e.depth||0,this.clobber=!1!==e.clobber||e.clobber,this.parent=e.parent||null,this.root=e.root||e.parent&&e.parent.root||this,this._path=this.path=f.resolve(e.path),"win32"===process.platform&&(this.path=this._path=this.path.replace(/\?/g,"_"),this._path.length>=260&&(this._swallowErrors=!0,this._path="\\\\?\\"+this.path.replace(/\//g,"\\"))),this.basename=f.basename(e.path),this.dirname=f.dirname(e.path),this.linkpath=e.linkpath||null,e.parent=e.root=null,this.size=e.size,"string"==typeof e.mode&&(e.mode=parseInt(e.mode,8)),this.readable=!1,this.writable=!0,this._buffer=[],this.ready=!1,this.filter="function"==typeof e.filter?e.filter:null,this._stat(a)}function m(e){i(f.dirname(e._path),h.dirmode,function(a,t){return a?e.error(a):(e._madeDir=t,e._create())})}function g(e,a,t,c,n){var i=a.mode,f=a.follow||"SymbolicLink"!==e.type?"chmod":"lchmod";if(!r[f])return n();if("number"!=typeof i)return n();var o=t.mode&parseInt("0777",8);if((i&=parseInt("0777",8))===o)return n();r[f](c,i,n)}function v(e,a,t,c,n){if("win32"===process.platform)return n();if(!process.getuid||0!==process.getuid())return n();if("number"!=typeof a.uid&&"number"!=typeof a.gid)return n();if(t.uid===a.uid&&t.gid===a.gid)return n();var i=e.props.follow||"SymbolicLink"!==e.type?"chown":"lchown";if(!r[i])return n();"number"!=typeof a.uid&&(a.uid=t.uid),"number"!=typeof a.gid&&(a.gid=t.gid),r[i](c,a.uid,a.gid,n)}function y(e,a,t,c,n){if(!r.utimes||"win32"===process.platform)return n();var i=a.follow||"SymbolicLink"!==e.type?"utimes":"lutimes";if("lutimes"!==i||r[i]||(i="utimes"),!r[i])return n();var f=t.atime,o=t.mtime,d=a.atime,s=a.mtime;if(void 0===d&&(d=f),void 0===s&&(s=o),_(d)||(d=new Date(d)),_(s)||(d=new Date(s)),d.getTime()===f.getTime()&&s.getTime()===o.getTime())return n();r[i](c,d,s,n)}function _(e){return"object"==typeof e&&"[object Date]"===function(e){return Object.prototype.toString.call(e)}(e)}h.prototype._create=function(){var e=this;r[e.props.follow?"stat":"lstat"](e._path,function(a){if(a)return e.warn("Cannot create "+e._path+"\nUnsupported type: "+e.type,"ENOTSUP");e._finish()})},h.prototype._stat=function(e){var a=this,t=a.props.follow?"stat":"lstat",c=a._proxy||a;function i(e,t){return a.filter&&!a.filter.call(c,c,t)?(a._aborted=!0,a.emit("end"),void a.emit("close")):e||!t?m(a):(a._old=t,d(t)!==a.type?n(a._path,function(e){if(e)return a.error(e);a._old=null,m(a)}):void m(a))}e?i(null,e):r[t](a._path,i)},h.prototype._finish=function(){var e=this;if(e._finishing);else{e._finishing=!0;var a=0,t=null,c=!1;if(e._old)e._old.atime=new Date(0),e._old.mtime=new Date(0),i(e._old);else{var n=e.props.follow?"stat":"lstat";r[n](e._path,function(a,t){if(a)return"ENOENT"!==a.code||"Link"!==e.type&&"SymbolicLink"!==e.type||"win32"!==process.platform?e.error(a):(e.ready=!0,e.emit("ready"),e.emit("end"),e.emit("close"),void(e.end=e._finish=function(){}));i(e._old=t)})}}function i(t){a+=3,g(e,e.props,t,e._path,o("chmod")),v(e,e.props,t,e._path,o("chown")),y(e,e.props,t,e._path,o("utimes"))}function o(n){return function(i){if(!t){if(i)return i.fstream_finish_call=n,e.error(t=i);if(!(--a>0||c)){if(c=!0,!e._madeDir)return o();!function e(a,t,c){var n=a._madeDir;var i=f.dirname(t);!function(e,a,t){var c={};Object.keys(e.props).forEach(function(a){c[a]=e.props[a],"mode"===a&&"Directory"!==e.type&&(c[a]=c[a]|parseInt("0111",8))});var n=3,i=null;function f(e){if(!i)return e?t(i=e):0==--n?t():void 0}r.stat(a,function(r,n){if(r)return t(i=r);g(e,c,n,a,f),v(e,c,n,a,f),y(e,c,n,a,f)})}(a,i,function(t){return t?c(t):i===n?c():void e(a,i,c)})}(e,e._path,o)}}function o(a){if(a)return a.fstream_finish_call="setupMadeDir",e.error(a);e.emit("end"),e.emit("close")}}}},h.prototype.pipe=function(){this.error("Can't pipe from writable stream")},h.prototype.add=function(){this.error("Can't add to non-Directory type")},h.prototype.write=function(){return!0}},function(e,a,t){a.Abstract=t(159),a.Reader=t(56),a.Writer=t(78),a.File={Reader:t(275),Writer:t(266)},a.Dir={Reader:t(276),Writer:t(268)},a.Link={Reader:t(277),Writer:t(267)},a.Proxy={Reader:t(274),Writer:t(265)},a.Reader.Dir=a.DirReader=a.Dir.Reader,a.Reader.File=a.FileReader=a.File.Reader,a.Reader.Link=a.LinkReader=a.Link.Reader,a.Reader.Proxy=a.ProxyReader=a.Proxy.Reader,a.Writer.Dir=a.DirWriter=a.Dir.Writer,a.Writer.File=a.FileWriter=a.File.Writer,a.Writer.Link=a.LinkWriter=a.Link.Writer,a.Writer.Proxy=a.ProxyWriter=a.Proxy.Writer,a.collect=t(155)},function(e,a,t){var r=a;r.Reporter=t(758).Reporter,r.DecoderBuffer=t(301).DecoderBuffer,r.EncoderBuffer=t(301).EncoderBuffer,r.Node=t(757)},function(e,a,t){var r=a;r.bignum=t(9),r.define=t(760).define,r.base=t(80),r.constants=t(300),r.decoders=t(755),r.encoders=t(753)},function(e,a,t){e.exports=t(787)().Promise},function(e,a,t){var r=a.noop=function(){};function c(e,a,t){this.logFunction=t,this.identifier=e,this.uniqueID=a,this.buffer=[]}a.extend=function(e,a){for(var t in a)e[t]=a[t]},a.eventEmitterListenerCount=t(5).EventEmitter.listenerCount||function(e,a){return e.listeners(a).length},a.BufferingLogger=function(e,a){var n=t(115)(e);if(n.enabled){var i=new c(e,a,n),f=i.log.bind(i);return f.printOutput=i.printOutput.bind(i),f.enabled=n.enabled,f}return n.printOutput=r,n},c.prototype.log=function(){return this.buffer.push([new Date,Array.prototype.slice.call(arguments)]),this},c.prototype.clear=function(){return this.buffer=[],this},c.prototype.printOutput=function(e){e||(e=this.logFunction);var a=this.uniqueID;this.buffer.forEach(function(t){var r=t[0].toLocaleString(),c=t[1].slice(),n=c[0];void 0!==n&&null!==n&&(n="%s - %s - "+n.toString(),c.splice(0,1,n,r,a),e.apply(global,c))})}},function(e,a){e.exports=__webpack_require__(5)},function(e,a,t){e.exports=t(10).randomBytes},function(e,a,t){var r=t(351).create,c=r("LevelUPError"),n=r("NotFoundError",c);n.prototype.notFound=!0,n.prototype.status=404,e.exports={LevelUPError:c,InitializationError:r("InitializationError",c),OpenError:r("OpenError",c),ReadError:r("ReadError",c),WriteError:r("WriteError",c),NotFoundError:n,EncodingError:r("EncodingError",c)}},function(e,a,t){const r=t(362),c=t(361),n=t(44),i=r.BN,f=r.rlp,o=t(898),d=t(897),s=t(333);var b=e.exports=function(e){var a,t;this.transactions=[],this.uncleHeaders=[],this._inBlockChain=!1,this.txTrie=new n,Object.defineProperty(this,"raw",{get:function(){return this.serialize(!1)}}),e||(e=[[],[],[]]),Buffer.isBuffer(e)&&(e=f.decode(e)),Array.isArray(e)?(this.header=new d(e[0]),a=e[1],t=e[2]):(this.header=new d(e.header),a=e.transactions,t=e.uncleHeaders);for(var r=0;r<t.length;r++)this.uncleHeaders.push(new d(t[r]));var i=this.isHomestead();for(r=0;r<a.length;r++){var o=new c(a[r]);o._homestead=i,this.transactions.push(o)}};function u(e){try{return e.reduce(function(e,a){return e&&(e+=" "),e+a})}catch(e){return""}}b.prototype.hash=function(){return this.header.hash()},b.prototype.isGenesis=function(){return this.header.isGenesis()},b.prototype.isHomestead=function(){return this.header.isHomestead()},b.prototype.setGenesisParams=function(){this.header.gasLimit=s.genesisGasLimit.v,this.header.difficulty=s.genesisDifficulty.v,this.header.extraData=s.genesisExtraData.v,this.header.nonce=s.genesisNonce.v,this.header.stateRoot=s.genesisStateRoot.v,this.header.number=new Buffer([])},b.prototype.serialize=function(e){var a=[this.header.raw,[],[]];return void 0===e&&(e=!0),this.transactions.forEach(function(e){a[1].push(e.raw)}),this.uncleHeaders.forEach(function(e){a[2].push(e.raw)}),e?f.encode(a):a},b.prototype.genTxTrie=function(e){var a=0,t=this;o.eachSeries(this.transactions,function(e,r){t.txTrie.put(f.encode(a),e.serialize(),r),a++},e)},b.prototype.validateTransactionsTrie=function(){var e=this.header.transactionsTrie.toString("hex");return this.transactions.length?e===this.txTrie.root.toString("hex"):e===r.SHA3_RLP.toString("hex")},b.prototype.validateTransactions=function(e){var a=[];return this.transactions.forEach(function(e,t){var r=e.validate(!0);r&&(r+=" at tx "+t),a.push(r)}),void 0===e||!1===e?0===a.length:u(a)},b.prototype.validate=function(e,a){var t=this,r=[];o.parallel([t.validateUncles.bind(t,e),t.header.validate.bind(t.header,e),t.genTxTrie.bind(t)],function(e){e&&r.push(e),t.validateTransactionsTrie()||r.push("invalid transaction true");var c=t.validateTransactions(!0);""!==c&&r.push(c),t.validateUnclesHash()||r.push("invild uncle hash"),a(u(r))})},b.prototype.validateUnclesHash=function(){var e=[];return this.uncleHeaders.forEach(function(a){e.push(a.raw)}),e=f.encode(e),r.sha3(e).toString("hex")===this.header.uncleHash.toString("hex")},b.prototype.validateUncles=function(e,a){if(this.isGenesis())return a();var t=this;if(t.uncleHeaders.length>2)return a("too many uncle headers");var r=t.uncleHeaders.map(function(e){return e.hash().toString("hex")});if(new Set(r).size!==r.length)return a("dublicate unlces");o.each(t.uncleHeaders,function(a,r){var c=new i(t.header.number);o.parallel([a.validate.bind(a,e,c),function(t){e.getDetails(a.hash(),function(e,a){a&&a.isUncle?t(e||"uncle already included"):t()})}],r)},a)},b.prototype.toJSON=function(e){if(e){var a={header:this.header.toJSON(!0),transactions:[],uncleHeaders:[]};return this.transactions.forEach(function(t){a.transactions.push(t.toJSON(e))}),this.uncleHeaders.forEach(function(e){a.uncleHeaders.push(e.toJSON())}),a}return r.baToJSON(this.raw)}},function(e,a,t){const r=t(363);function c(){}e.exports=c,c.prototype.setEngine=function(e){const a=this;a.engine=e,e.on("block",function(e){a.currentBlock=e})},c.prototype.handleRequest=function(e,a,t){throw new Error("Subproviders should override `handleRequest`.")},c.prototype.emitPayload=function(e,a){this.engine.sendAsync(r(e),a)}},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.isAsync=void 0;var r=function(e){return e&&e.__esModule?e:{default:e}}(t(957));var c="function"==typeof Symbol;function n(e){return c&&"AsyncFunction"===e[Symbol.toStringTag]}a.default=function(e){return n(e)?(0,r.default)(e):e},a.isAsync=n},function(e,a,t){"use strict";var r=t(37),c=t(46);function n(){this.pending=null,this.pendingTotal=0,this.blockSize=this.constructor.blockSize,this.outSize=this.constructor.outSize,this.hmacStrength=this.constructor.hmacStrength,this.padLength=this.constructor.padLength/8,this.endian="big",this._delta8=this.blockSize/8,this._delta32=this.blockSize/32}a.BlockHash=n,n.prototype.update=function(e,a){if(e=r.toArray(e,a),this.pending?this.pending=this.pending.concat(e):this.pending=e,this.pendingTotal+=e.length,this.pending.length>=this._delta8){var t=(e=this.pending).length%this._delta8;this.pending=e.slice(e.length-t,e.length),0===this.pending.length&&(this.pending=null),e=r.join32(e,0,e.length-t,this.endian);for(var c=0;c<e.length;c+=this._delta32)this._update(e,c,c+this._delta32)}return this},n.prototype.digest=function(e){return this.update(this._pad()),c(null===this.pending),this._digest(e)},n.prototype._pad=function(){var e=this.pendingTotal,a=this._delta8,t=a-(e+this.padLength)%a,r=new Array(t+this.padLength);r[0]=128;for(var c=1;c<t;c++)r[c]=0;if(e<<=3,"big"===this.endian){for(var n=8;n<this.padLength;n++)r[c++]=0;r[c++]=0,r[c++]=0,r[c++]=0,r[c++]=0,r[c++]=e>>>24&255,r[c++]=e>>>16&255,r[c++]=e>>>8&255,r[c++]=255&e}else for(r[c++]=255&e,r[c++]=e>>>8&255,r[c++]=e>>>16&255,r[c++]=e>>>24&255,r[c++]=0,r[c++]=0,r[c++]=0,r[c++]=0,n=8;n<this.padLength;n++)r[c++]=0;return r}},function(e,a,t){"use strict";e.exports=t(1015)(t(1011))},function(e,a){a.getArg=function(e,a,t){if(a in e)return e[a];if(3===arguments.length)return t;throw new Error('"'+a+'" is a required argument.')};var t=/^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/,r=/^data:.+\,.+$/;function c(e){var a=e.match(t);return a?{scheme:a[1],auth:a[2],host:a[3],port:a[4],path:a[5]}:null}function n(e){var a="";return e.scheme&&(a+=e.scheme+":"),a+="//",e.auth&&(a+=e.auth+"@"),e.host&&(a+=e.host),e.port&&(a+=":"+e.port),e.path&&(a+=e.path),a}function i(e){var t=e,r=c(e);if(r){if(!r.path)return e;t=r.path}for(var i,f=a.isAbsolute(t),o=t.split(/\/+/),d=0,s=o.length-1;s>=0;s--)"."===(i=o[s])?o.splice(s,1):".."===i?d++:d>0&&(""===i?(o.splice(s+1,d),d=0):(o.splice(s,2),d--));return""===(t=o.join("/"))&&(t=f?"/":"."),r?(r.path=t,n(r)):t}function f(e,a){""===e&&(e="."),""===a&&(a=".");var t=c(a),f=c(e);if(f&&(e=f.path||"/"),t&&!t.scheme)return f&&(t.scheme=f.scheme),n(t);if(t||a.match(r))return a;if(f&&!f.host&&!f.path)return f.host=a,n(f);var o="/"===a.charAt(0)?a:i(e.replace(/\/+$/,"")+"/"+a);return f?(f.path=o,n(f)):o}a.urlParse=c,a.urlGenerate=n,a.normalize=i,a.join=f,a.isAbsolute=function(e){return"/"===e.charAt(0)||t.test(e)},a.relative=function(e,a){""===e&&(e="."),e=e.replace(/\/$/,"");for(var t=0;0!==a.indexOf(e+"/");){var r=e.lastIndexOf("/");if(r<0)return a;if((e=e.slice(0,r)).match(/^([^\/]+:\/)?\/*$/))return a;++t}return Array(t+1).join("../")+a.substr(e.length+1)};var o=!("__proto__"in Object.create(null));function d(e){return e}function s(e){if(!e)return!1;var a=e.length;if(a<9)return!1;if(95!==e.charCodeAt(a-1)||95!==e.charCodeAt(a-2)||111!==e.charCodeAt(a-3)||116!==e.charCodeAt(a-4)||111!==e.charCodeAt(a-5)||114!==e.charCodeAt(a-6)||112!==e.charCodeAt(a-7)||95!==e.charCodeAt(a-8)||95!==e.charCodeAt(a-9))return!1;for(var t=a-10;t>=0;t--)if(36!==e.charCodeAt(t))return!1;return!0}function b(e,a){return e===a?0:null===e?1:null===a?-1:e>a?1:-1}a.toSetString=o?d:function(e){return s(e)?"$"+e:e},a.fromSetString=o?d:function(e){return s(e)?e.slice(1):e},a.compareByOriginalPositions=function(e,a,t){var r=b(e.source,a.source);return 0!==r?r:0!=(r=e.originalLine-a.originalLine)?r:0!=(r=e.originalColumn-a.originalColumn)||t?r:0!=(r=e.generatedColumn-a.generatedColumn)?r:0!=(r=e.generatedLine-a.generatedLine)?r:b(e.name,a.name)},a.compareByGeneratedPositionsDeflated=function(e,a,t){var r=e.generatedLine-a.generatedLine;return 0!==r?r:0!=(r=e.generatedColumn-a.generatedColumn)||t?r:0!==(r=b(e.source,a.source))?r:0!=(r=e.originalLine-a.originalLine)?r:0!=(r=e.originalColumn-a.originalColumn)?r:b(e.name,a.name)},a.compareByGeneratedPositionsInflated=function(e,a){var t=e.generatedLine-a.generatedLine;return 0!==t?t:0!=(t=e.generatedColumn-a.generatedColumn)?t:0!==(t=b(e.source,a.source))?t:0!=(t=e.originalLine-a.originalLine)?t:0!=(t=e.originalColumn-a.originalColumn)?t:b(e.name,a.name)},a.parseSourceMapInput=function(e){return JSON.parse(e.replace(/^\)]}'[^\n]*\n/,""))},a.computeSourceURL=function(e,a,t){if(a=a||"",e&&("/"!==e[e.length-1]&&"/"!==a[0]&&(e+="/"),a=e+a),t){var r=c(t);if(!r)throw new Error("sourceMapURL could not be parsed");if(r.path){var o=r.path.lastIndexOf("/");o>=0&&(r.path=r.path.substring(0,o+1))}a=f(n(r),a)}return i(a)}},function(e,a,t){var r=t(19),c=t(117),n=t(3);e.exports={toJSON:function(e,a){for(var t=0,c=0;c<a.transactions.length;c++){if(a.transactions[c].hash().equals(e.hash())){t=c;break}}var n={hash:r.hex(e.hash()),nonce:r.hex(e.nonce),blockHash:r.hex(a.hash()),blockNumber:r.hex(a.header.number),transactionIndex:r.hex(t),from:r.hex(e.from),to:r.hex(e.to),value:r.hex(e.value),gas:r.hex(e.gasLimit),gasPrice:r.hex(e.gasPrice),input:r.hex(e.data)};return e.v&&e.v.length>0&&e.r&&e.r.length>0&&e.s&&e.s.length>0&&(n.v=r.hex(e.v),n.r=r.hex(e.r),n.s=r.hex(e.s)),n},fromJSON:function(e){var a=new c({nonce:n.toBuffer(r.hex(e.nonce)),from:n.toBuffer(r.hex(e.from)),value:n.toBuffer(r.hex(e.value)),gasLimit:n.toBuffer(r.hex(e.gas)),gasPrice:n.toBuffer(r.hex(e.gasPrice)),data:n.toBuffer(r.hex(e.input))});if(e.v&&e.v.length>0&&e.r&&e.r.length>0&&e.s&&e.s.length>0&&(a.v=n.toBuffer(r.hex(e.v)),a.r=n.toBuffer(r.hex(e.r)),a.s=n.toBuffer(r.hex(e.s))),e.to){var t=n.toBuffer(r.hex(e.to));t.equals(n.toBuffer("0x0"))||(a.to=n.setLengthLeft(t,20))}return a}}},function(e,a){a.from=Buffer.from||function(e,a){return a?new Buffer(e,a):new Buffer(e)},a.alloc=Buffer.alloc||function(e){return new Buffer(e)}},function(e,a,t){var r=t(4);e.exports=function(e){return(e=r(e)).toLowerCase()}},function(e,a){e.exports=[" ","\n","\r","\t","\f","\v"," "," ","᠎"," "," "," "," "," "," "," "," "," "," "," ","\u2028","\u2029"," "," ","　"]},function(e,a){e.exports=function(e){e=e.replace(/#.*/,"");var a=/\?[a-zA-Z0-9\=\&\%\$\-\_\.\+\!\*\'\(\)\,]+/.exec(e);return a?decodeURIComponent(a[0].replace(/\+/g," ")):""}},function(e,a,t){var r=t(141),c=t(70);e.exports=function(e,a,t){return e=c(e),r(""+e,a,t||"0")}},function(e,a,t){var r=t(16);function c(e,a){this[a]=e}e.exports=function(e,a){for(var t,n=0,i=arguments.length;++n<i;)null!=(t=arguments[n])&&r(t,c,e);return e}},function(e,a,t){var r=t(35);e.exports=function(e){return r(e,"Date")}},function(e,a,t){var r=t(16);e.exports=function(e){var a=[];return r(e,function(e,t){a.push(e)}),a}},function(e,a,t){var r=t(16),c=t(14);e.exports=function(e,a,t){a=c(a,t);var n=!1;return r(e,function(t,r){if(a(t,r,e))return n=!0,!1}),n}},function(e,a){e.exports=function(e,a,t){return e=Math.floor(e/a),t?e%t:e}},function(e,a){e.exports=2147483647},function(e,a,t){var r=t(14);e.exports=function(e,a,t){if(null!=e&&e.length){if(e.length&&!a)return Math.max.apply(Math,e);a=r(a,t);for(var c,n,i,f=-1/0,o=-1,d=e.length;++o<d;)(i=a(n=e[o],o,e))>f&&(f=i,c=n);return c}return 1/0}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){a=r(a,t);var c=[];if(null==e)return c;for(var n=-1,i=e.length;++n<i;)c[n]=a(e[n],n,e);return c}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){a=r(a,t);var c=!0;if(null==e)return c;for(var n=-1,i=e.length;++n<i;)if(!a(e[n],n,e)){c=!1;break}return c}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){a=r(a,t);var c=!1;if(null==e)return c;for(var n=-1,i=e.length;++n<i;)if(a(e[n],n,e)){c=!0;break}return c}},function(e,a){e.exports=function(e){var a,t=["Directory","File","SymbolicLink","Link","BlockDevice","CharacterDevice","FIFO","Socket"];if(e.type&&-1!==t.indexOf(e.type))return e[e.type]=!0,e.type;for(var r=0,c=t.length;r<c;r++){a=t[r];var n=e[a]||e["is"+a];if("function"==typeof n&&(n=n.call(e)),n)return e[a]=!0,e.type=a,a}return null}},function(e,a,t){e.exports=f;t(111);var r=t(41),c=(t(11).ok,t(6).Stream),n=t(0),i=t(79).Abstract;function f(e,a,t){c.call(this),this.readable=!0,this.writable=!0,this._needDrain=!1,this._paused=!1,this._reading=!1,this._ending=!1,this._ended=!1,this._remaining=0,this._abort=!1,this._queue=[],this._index=0,this._queueLen=0,this._read=this._read.bind(this),this.props={},this._header=e,this._extended=a||{},this._global={};var r=this;Object.keys(t||{}).forEach(function(e){r._global[e]=t[e]}),this._setProps()}n(f,c),f.prototype.write=function(e){this._ending&&this.error("write() after end()",null,!0),0===this._remaining&&this.error("invalid bytes past eof"),e.length>this._remaining&&(e=e.slice(0,this._remaining)),this._remaining-=e.length;var a=this._queueLen;return this._queue.push(e),this._queueLen++,this._read(),!(this._paused||a>0)||(this._needDrain=!0,!1)},f.prototype.end=function(e){e&&this.write(e),this._ending=!0,this._read()},f.prototype.pause=function(){this._paused=!0,this.emit("pause")},f.prototype.resume=function(){return this.emit("resume"),this._paused=!1,this._read(),this._queueLen-this._index>1},f.prototype._read=function(){if(!(this._paused||this._reading||this._ended)){for(this._reading=!0;this._index<this._queueLen&&!this._paused;){var e=this._queue[this._index++];this.emit("data",e)}this._index>=this._queueLen&&(this._queue.length=this._queueLen=this._index=0,this._needDrain&&(this._needDrain=!1,this.emit("drain")),this._ending&&(this._ended=!0,this.emit("end")));var a=this._maxQueueLen;this._queueLen>a&&this._index>0&&(a=Math.min(this._index,a),this._index-=a,this._queueLen-=a,this._queue=this._queue.slice(a)),this._reading=!1}},f.prototype._setProps=function(){for(var e,a=this._header,t=this._extended,c=this._global,n=this.props,i=r.fields,f=0;null!==i[f];f++){var o=i[f],d=a[o];void 0!==d&&(n[o]=d)}switch([c,t].forEach(function(e){Object.keys(e).forEach(function(a){void 0!==e[a]&&(n[a]=e[a])})}),["path","linkpath"].forEach(function(e){n.hasOwnProperty(e)&&(n[e]=n[e].split("\0")[0])}),["mtime","ctime","atime"].forEach(function(e){n.hasOwnProperty(e)&&(n[e]=new Date(1e3*n[e]))}),r.types[n.type]){case"OldFile":case"ContiguousFile":e="File";break;case"GNUDumpDir":e="Directory";break;case void 0:e="Unknown";break;case"Link":case"SymbolicLink":case"CharacterDevice":case"BlockDevice":case"Directory":case"FIFO":default:e=r.types[n.type]}this.type=e,this.path=n.path,this.size=n.size,this._remaining=n.size},f.prototype.abort=function(){this._abort=!0},f.prototype.warn=i.warn,f.prototype.error=i.error},function(e,a,t){e.exports=l;var r=t(41),c=r.fields,n=r.fieldOffs,i=r.fieldEnds,f=r.fieldSize,o=r.numeric,d=t(11).ok,s=" ".charCodeAt(0),b="/".charCodeAt(0),u="win32"===process.platform?"\\".charCodeAt(0):null;function l(e){if(!(this instanceof l))return new l(e);e&&this.decode(e)}function p(e){if(!(e||this instanceof l))throw new Error("encode must be called on a TarHeader, or supplied an object");var a=(e=e||this).block=new Buffer(512);e.prefix&&(e.path=e.prefix+"/"+e.path,e.prefix=""),e.needExtended=!1,e.mode&&("string"==typeof e.mode&&(e.mode=parseInt(e.mode,8)),e.mode=511&e.mode);for(var t=0;null!==c[t];t++){var d,s=c[t],p=n[t],h=i[t];switch(s){case"cksum":case"prefix":break;case"type":var y=e.type||"0";y.length>1&&((y=r.types[e.type])||(y="0")),g(a,p,h,y);break;case"path":var _=Buffer.byteLength(e.path),w=f[c.path],A=f[c.prefix];if(_>w&&_<=w+A){for(var k=_-1-w,x=A,E=!1,S=new Buffer(e.path),T=k;T<=x;T++)if(S[T]===b||S[T]===u){E=T;break}if(!1!==E){prefix=S.slice(0,E).toString("utf8"),path=S.slice(E+1).toString("utf8"),d=g(a,p,h,path),d=g(a,p=n[c.prefix],h=i[c.prefix],prefix)||d;break}}g(a,n[c.prefix],i[c.prefix],"");default:d=o[s]?m(a,p,h,e[s]):g(a,p,h,e[s]||"")}e.needExtended=e.needExtended||d}return m(a,p=n[c.cksum],h=i[c.cksum],v.call(this,a)),a}l.prototype={decode:y,encode:p,calcSum:v,checkSum:function(e){var a=v.call(this,e),t=(e=e||this.block).slice(n[c.cksum],i[c.cksum]);return(t=_(t))===a}},l.parseNumeric=_,l.encode=p,l.decode=y;var h={12:8589934591,11:1073741823,8:2097151,7:262143};function m(e,a,t,r){var c=t-a,n=h[c]||0;if(((r=r||0)instanceof Date||"[object Date]"===Object.prototype.toString.call(r))&&(r=r.getTime()/1e3),r>n||r<0)return function(e,a,t,r){var c=e.slice(a,t),n=r>=0;c[0]=n?128:255,n||(r*=-1);var i=[];do{var f=r%256;i.push(f),r=(r-f)/256}while(r);for(var o=i.length,d=c.length-o,s=1;s<d;s++)c[s]=n?0:255;var b=!0;for(s=o;s>0;s--){var u=i[o-s];n?c[d+s]=u:b&&0===u?c[d+s]=0:b?(b=!1,c[d+s]=256-u):c[d+s]=255-u}}(e,a,t,r),!0;var i=Math.floor(r).toString(8);if(r<h[c-1]&&(i+=" "),i.length<c&&(i=new Array(c-i.length).join("0")+i),i.length!==c-1)throw new Error("invalid length: "+JSON.stringify(i)+"\nexpected: "+c);e.write(i,a,c,"utf8"),e[t-1]=0}function g(e,a,t,r){var c=Buffer.byteLength(r),n=Math.min(c,t-a),i=c!==r.length||c>n;n>0&&e.write(r,a,n,"utf8");for(var f=a+n;f<t;f++)e[f]=0;return i}function v(e){if(e=e||this.block,d(Buffer.isBuffer(e)&&512===e.length),!e)throw new Error("Need block to checksum");for(var a=0,t=n[c.cksum],r=i[c.cksum],f=0;f<n[c.cksum];f++)a+=e[f];for(f=t;f<r;f++)a+=s;for(f=r;f<512;f++)a+=e[f];return a}function y(e){e=e||this.block,d(Buffer.isBuffer(e)&&512===e.length),this.block=e,this.cksumValid=this.checkSum();for(var a=null,t=0;null!==c[t];t++){var r=c[t],f=e.slice(n[t],i[t]);switch(r){case"ustar":if("ustar\0"!==f.toString())return void(this.ustar=!1);this.ustar=f.toString();break;case"prefix":var b=_(f.slice(131,143)),u=_(f.slice(143,155));0!==f[130]&&f[130]!==s||"number"!=typeof b||"number"!=typeof u||f[143]!==s||f[155]!==s||(this.atime=b,this.ctime=u,f=f.slice(0,130)),a=f.toString("utf8").replace(/\0+$/,"");break;default:o[r]?this[r]=_(f):this[r]=f.toString("utf8").replace(/\0+$/,"")}}a&&(this.path=a+"/"+this.path)}function _(e){if(128&e[0])return function(e){var a;if(128===e[0])a=!0;else{if(255!==e[0])return null;a=!1}for(var t=!1,r=[],c=e.length-1;c>0;c--){var n=e[c];a?r.push(n):t&&0===n?r.push(0):t?(t=!1,r.push(256-n)):r.push(255-n)}for(var i=0,f=(c=0,r.length);c<f;c++)i+=r[c]*Math.pow(256,c);return a?i:-1*i}(e);var a=e.toString("utf8").split("\0")[0].trim(),t=parseInt(a,8);return isNaN(t)?null:t}},function(e,a,t){"use strict";const r=t(725);e.exports={remove:function(e,a){const t={disableGlob:!0};return r(e,t,a||function(){})},removeSync:function(e){return r.sync(e,{disableGlob:!0})}}},function(e,a,t){"use strict";var r=t(51),c=t(50),n=t(27),i=function(){var e=this;r.packageInit(this,arguments),[new c({name:"getId",call:"net_version",params:0,outputFormatter:n.hexToNumber}),new c({name:"isListening",call:"net_listening",params:0}),new c({name:"getPeerCount",call:"net_peerCount",params:0,outputFormatter:n.hexToNumber})].forEach(function(a){a.attachToObject(e),a.setRequestManager(e._requestManager)})};r.addProviders(i),e.exports=i},function(e,a,t){"use strict";var r=t(784),c=function(e){this.name=e.name,this.type=e.type,this.subscriptions=e.subscriptions||{},this.requestManager=null};c.prototype.setRequestManager=function(e){this.requestManager=e},c.prototype.attachToObject=function(e){var a=this.buildCall();a.call=this.call;var t=this.name.split(".");t.length>1?(e[t[0]]=e[t[0]]||{},e[t[0]][t[1]]=a):e[t[0]]=a},c.prototype.buildCall=function(){var e=this;return function(){e.subscriptions[arguments[0]]||console.warn("Subscription "+JSON.stringify(arguments[0])+" doesn't exist. Subscribing anyway.");var a=new r({subscription:e.subscriptions[arguments[0]],requestManager:e.requestManager,type:e.type});return a.subscribe.apply(a,arguments)}},e.exports={subscriptions:c,subscription:r}},function(e,a,t){"undefined"!=typeof process&&"renderer"===process.type?e.exports=t(812):e.exports=t(810)},function(e,a,t){"use strict";var r=t(827).version,c=t(51),n=t(783),i=t(113),f=t(308),o=t(739),d=t(738),s=t(27),b=function(){var e=this;c.packageInit(this,arguments),this.version=r,this.utils=s,this.eth=new n(this),this.shh=new o(this),this.bzz=new d(this);var a=this.setProvider;this.setProvider=function(t,r){return a.apply(e,arguments),this.eth.setProvider(t,r),this.shh.setProvider(t,r),this.bzz.setProvider(t),!0}};b.version=r,b.utils=s,b.modules={Eth:n,Net:i,Personal:f,Shh:o,Bzz:d},c.addProviders(b),e.exports=b},function(e,a,t){"use strict";const r=t(861),c=t(3);e.exports=class extends r{constructor(e){super(e);var a=this;Object.defineProperty(this,"from",{enumerable:!0,configurable:!0,get:this.getSenderAddress.bind(a),set:function(e){a._from=c.toBuffer(e)}}),e&&e.from&&(this.from=e.from)}hash(e){if(e&&this._from){let e=Buffer.concat([this._from,this._from.slice(0,12)]);this.sign(e)}return super.hash(e)}}},function(e,a,t){"use strict";!process.version||0===process.version.indexOf("v0.")||0===process.version.indexOf("v1.")&&0!==process.version.indexOf("v1.8.")?e.exports={nextTick:function(e,a,t,r){if("function"!=typeof e)throw new TypeError('"callback" argument must be a function');var c,n,i=arguments.length;switch(i){case 0:case 1:return process.nextTick(e);case 2:return process.nextTick(function(){e.call(null,a)});case 3:return process.nextTick(function(){e.call(null,a,t)});case 4:return process.nextTick(function(){e.call(null,a,t,r)});default:for(c=new Array(i-1),n=0;n<c.length;)c[n++]=arguments[n];return process.nextTick(function(){e.apply(null,c)})}}}:e.exports=process},function(e,a,t){"use strict";var r=a;r.base=t(1007),r.short=t(1006),r.mont=t(1005),r.edwards=t(1004)},function(e,a,t){var r=t(1),c=t(65),n=t(5).EventEmitter,i=t(187),f=t(400),o=t(399).Validation;const d="open";var s="setImmediate"in global?global.setImmediate.bind(global):process.nextTick.bind(process),b=0;function u(e,a,t,r,o){if(this._debug=c.BufferingLogger("websocket:connection",++b),this._debug("constructor"),this._debug.enabled&&function(e,a){if(!e._debug.enabled)return;var t=a.emit;for(var r in a.emit=function(a){e._debug("||| Socket Event  '%s'",a),t.apply(this,arguments)},a)"function"==typeof a[r]&&-1===["emit"].indexOf(r)&&function(t){var r=a[t];a[t]="on"!==t?function(){return e._debug("||| Socket method called:  %s",t),r.apply(this,arguments)}:function(){return e._debug("||| Socket method called:  %s (%s)",t,arguments[0]),r.apply(this,arguments)}}(r)}(this,e),n.call(this),this._pingListenerCount=0,this.on("newListener",function(e){"ping"===e&&this._pingListenerCount++}).on("removeListener",function(e){"ping"===e&&this._pingListenerCount--}),this.config=o,this.socket=e,this.protocol=t,this.extensions=a,this.remoteAddress=e.remoteAddress,this.closeReasonCode=-1,this.closeDescription=null,this.closeEventEmitted=!1,this.maskOutgoingPackets=r,this.maskBytes=new Buffer(4),this.frameHeader=new Buffer(10),this.bufferList=new f,this.currentFrame=new i(this.maskBytes,this.frameHeader,this.config),this.fragmentationSize=0,this.frameQueue=[],this.connected=!0,this.state=d,this.waitingForCloseResponse=!1,this.receivedEnd=!1,this.closeTimeout=this.config.closeTimeout,this.assembleFragments=this.config.assembleFragments,this.maxReceivedMessageSize=this.config.maxReceivedMessageSize,this.outputBufferFull=!1,this.inputPaused=!1,this.receivedDataHandler=this.processReceivedData.bind(this),this._closeTimerHandler=this.handleCloseTimer.bind(this),this.socket.setNoDelay(this.config.disableNagleAlgorithm),this.socket.setTimeout(0),this.config.keepalive&&!this.config.useNativeKeepalive){if("number"!=typeof this.config.keepaliveInterval)throw new Error("keepaliveInterval must be specified and numeric if keepalive is true.");if(this._keepaliveTimerHandler=this.handleKeepaliveTimer.bind(this),this.setKeepaliveTimer(),this.config.dropConnectionOnKeepaliveTimeout){if("number"!=typeof this.config.keepaliveGracePeriod)throw new Error("keepaliveGracePeriod  must be specified and numeric if dropConnectionOnKeepaliveTimeout is true.");this._gracePeriodTimerHandler=this.handleGracePeriodTimer.bind(this)}}else if(this.config.keepalive&&this.config.useNativeKeepalive){if(!("setKeepAlive"in this.socket))throw new Error("Unable to use native keepalive: unsupported by this version of Node.");this.socket.setKeepAlive(!0,this.config.keepaliveInterval)}this.socket.removeAllListeners("error")}function l(e){return!(e<1e3)&&(e>=1e3&&e<=2999?-1!==[1e3,1001,1002,1003,1007,1008,1009,1010,1011,1012,1013,1014].indexOf(e):e>=3e3&&e<=3999||(e>=4e3&&e<=4999||!(e>=5e3)&&void 0))}u.CLOSE_REASON_NORMAL=1e3,u.CLOSE_REASON_GOING_AWAY=1001,u.CLOSE_REASON_PROTOCOL_ERROR=1002,u.CLOSE_REASON_UNPROCESSABLE_INPUT=1003,u.CLOSE_REASON_RESERVED=1004,u.CLOSE_REASON_NOT_PROVIDED=1005,u.CLOSE_REASON_ABNORMAL=1006,u.CLOSE_REASON_INVALID_DATA=1007,u.CLOSE_REASON_POLICY_VIOLATION=1008,u.CLOSE_REASON_MESSAGE_TOO_BIG=1009,u.CLOSE_REASON_EXTENSION_REQUIRED=1010,u.CLOSE_REASON_INTERNAL_SERVER_ERROR=1011,u.CLOSE_REASON_TLS_HANDSHAKE_FAILED=1015,u.CLOSE_DESCRIPTIONS={1000:"Normal connection closure",1001:"Remote peer is going away",1002:"Protocol error",1003:"Unprocessable input",1004:"Reserved",1005:"Reason not provided",1006:"Abnormal closure, no further detail available",1007:"Invalid data received",1008:"Policy violation",1009:"Message too big",1010:"Extension requested by client is required",1011:"Internal Server Error",1015:"TLS Handshake Failed"},r.inherits(u,n),u.prototype._addSocketEventListeners=function(){this.socket.on("error",this.handleSocketError.bind(this)),this.socket.on("end",this.handleSocketEnd.bind(this)),this.socket.on("close",this.handleSocketClose.bind(this)),this.socket.on("drain",this.handleSocketDrain.bind(this)),this.socket.on("pause",this.handleSocketPause.bind(this)),this.socket.on("resume",this.handleSocketResume.bind(this)),this.socket.on("data",this.handleSocketData.bind(this))},u.prototype.setKeepaliveTimer=function(){this._debug("setKeepaliveTimer"),this.config.keepalive&&!this.config.useNativeKeepalive&&(this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this._keepaliveTimeoutID=setTimeout(this._keepaliveTimerHandler,this.config.keepaliveInterval))},u.prototype.clearKeepaliveTimer=function(){this._keepaliveTimeoutID&&clearTimeout(this._keepaliveTimeoutID)},u.prototype.handleKeepaliveTimer=function(){this._debug("handleKeepaliveTimer"),this._keepaliveTimeoutID=null,this.ping(),this.config.dropConnectionOnKeepaliveTimeout?this.setGracePeriodTimer():this.setKeepaliveTimer()},u.prototype.setGracePeriodTimer=function(){this._debug("setGracePeriodTimer"),this.clearGracePeriodTimer(),this._gracePeriodTimeoutID=setTimeout(this._gracePeriodTimerHandler,this.config.keepaliveGracePeriod)},u.prototype.clearGracePeriodTimer=function(){this._gracePeriodTimeoutID&&clearTimeout(this._gracePeriodTimeoutID)},u.prototype.handleGracePeriodTimer=function(){this._debug("handleGracePeriodTimer"),this._gracePeriodTimeoutID=null,this.drop(u.CLOSE_REASON_ABNORMAL,"Peer not responding.",!0)},u.prototype.handleSocketData=function(e){this._debug("handleSocketData"),this.setKeepaliveTimer(),this.bufferList.write(e),this.processReceivedData()},u.prototype.processReceivedData=function(){if(this._debug("processReceivedData"),this.connected&&!this.inputPaused){var e=this.currentFrame;if(e.addData(this.bufferList)){var a=this;if(e.protocolError)return this._debug("-- protocol error"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_PROTOCOL_ERROR,e.dropReason)});if(e.frameTooLarge)return this._debug("-- frame too large"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_MESSAGE_TOO_BIG,e.dropReason)});if(e.rsv1||e.rsv2||e.rsv3)return this._debug("-- illegal rsv flag"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unsupported usage of rsv bits without negotiated extension.")});this.assembleFragments||(this._debug("-- emitting frame"),process.nextTick(function(){a.emit("frame",e)})),process.nextTick(function(){a.processFrame(e)}),this.currentFrame=new i(this.maskBytes,this.frameHeader,this.config),this.bufferList.length>0&&s(this.receivedDataHandler)}else this._debug("-- insufficient data for frame")}},u.prototype.handleSocketError=function(e){this._debug("handleSocketError: %j",e),"closed"!==this.state?(this.closeReasonCode=u.CLOSE_REASON_ABNORMAL,this.closeDescription="Socket Error: "+e.syscall+" "+e.code,this.connected=!1,this.state="closed",this.fragmentationSize=0,c.eventEmitterListenerCount(this,"error")>0&&this.emit("error",e),this.socket.destroy(e),this._debug.printOutput()):this._debug("  --- Socket 'error' after 'close'")},u.prototype.handleSocketEnd=function(){this._debug("handleSocketEnd: received socket end.  state = %s",this.state),this.receivedEnd=!0,"closed"!==this.state?"peer_requested_close"!==this.state&&"ending"!==this.state&&(this._debug("  --- UNEXPECTED socket end."),this.socket.end()):this._debug("  --- Socket 'end' after 'close'")},u.prototype.handleSocketClose=function(e){this._debug("handleSocketClose: received socket close"),this.socketHadError=e,this.connected=!1,this.state="closed",-1===this.closeReasonCode&&(this.closeReasonCode=u.CLOSE_REASON_ABNORMAL,this.closeDescription="Connection dropped by remote peer."),this.clearCloseTimer(),this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this.closeEventEmitted||(this.closeEventEmitted=!0,this._debug("-- Emitting WebSocketConnection close event"),this.emit("close",this.closeReasonCode,this.closeDescription))},u.prototype.handleSocketDrain=function(){this._debug("handleSocketDrain: socket drain event"),this.outputBufferFull=!1,this.emit("drain")},u.prototype.handleSocketPause=function(){this._debug("handleSocketPause: socket pause event"),this.inputPaused=!0,this.emit("pause")},u.prototype.handleSocketResume=function(){this._debug("handleSocketResume: socket resume event"),this.inputPaused=!1,this.emit("resume"),this.processReceivedData()},u.prototype.pause=function(){this._debug("pause: pause requested"),this.socket.pause()},u.prototype.resume=function(){this._debug("resume: resume requested"),this.socket.resume()},u.prototype.close=function(e,a){if(this.connected){if(this._debug("close: Initating clean WebSocket close sequence."),"number"!=typeof e&&(e=u.CLOSE_REASON_NORMAL),!l(e))throw new Error("Close code "+e+" is not valid.");"string"!=typeof a&&(a=u.CLOSE_DESCRIPTIONS[e]),this.closeReasonCode=e,this.closeDescription=a,this.setCloseTimer(),this.sendCloseFrame(this.closeReasonCode,this.closeDescription),this.state="ending",this.connected=!1}},u.prototype.drop=function(e,a,t){this._debug("drop"),"number"!=typeof e&&(e=u.CLOSE_REASON_PROTOCOL_ERROR),"string"!=typeof a&&(a=u.CLOSE_DESCRIPTIONS[e]),this._debug("Forcefully dropping connection. skipCloseFrame: %s, code: %d, description: %s",t,e,a),this.closeReasonCode=e,this.closeDescription=a,this.frameQueue=[],this.fragmentationSize=0,t||this.sendCloseFrame(e,a),this.connected=!1,this.state="closed",this.clearCloseTimer(),this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this.closeEventEmitted||(this.closeEventEmitted=!0,this._debug("Emitting WebSocketConnection close event"),this.emit("close",this.closeReasonCode,this.closeDescription)),this._debug("Drop: destroying socket"),this.socket.destroy()},u.prototype.setCloseTimer=function(){this._debug("setCloseTimer"),this.clearCloseTimer(),this._debug("Setting close timer"),this.waitingForCloseResponse=!0,this.closeTimer=setTimeout(this._closeTimerHandler,this.closeTimeout)},u.prototype.clearCloseTimer=function(){this._debug("clearCloseTimer"),this.closeTimer&&(this._debug("Clearing close timer"),clearTimeout(this.closeTimer),this.waitingForCloseResponse=!1,this.closeTimer=null)},u.prototype.handleCloseTimer=function(){this._debug("handleCloseTimer"),this.closeTimer=null,this.waitingForCloseResponse&&(this._debug("Close response not received from client.  Forcing socket end."),this.waitingForCloseResponse=!1,this.state="closed",this.socket.end())},u.prototype.processFrame=function(e){if(this._debug("processFrame"),this._debug(" -- frame: %s",e),0!==this.frameQueue.length&&e.opcode>0&&e.opcode<8)this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Illegal frame opcode 0x"+e.opcode.toString(16)+" received in middle of fragmented message.");else switch(e.opcode){case 2:this._debug("-- Binary Frame"),this.assembleFragments&&(e.fin?(this._debug("---- Emitting 'message' event"),this.emit("message",{type:"binary",binaryData:e.binaryPayload})):(this.frameQueue.push(e),this.fragmentationSize=e.length));break;case 1:if(this._debug("-- Text Frame"),this.assembleFragments)if(e.fin){if(!o.isValidUTF8(e.binaryPayload))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this._debug("---- Emitting 'message' event"),this.emit("message",{type:"utf8",utf8Data:e.binaryPayload.toString("utf8")})}else this.frameQueue.push(e),this.fragmentationSize=e.length;break;case 0:if(this._debug("-- Continuation Frame"),this.assembleFragments){if(0===this.frameQueue.length)return void this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unexpected Continuation Frame");if(this.fragmentationSize+=e.length,this.fragmentationSize>this.maxReceivedMessageSize)return void this.drop(u.CLOSE_REASON_MESSAGE_TOO_BIG,"Maximum message size exceeded.");if(this.frameQueue.push(e),e.fin){var a=0,t=new Buffer(this.fragmentationSize),r=this.frameQueue[0].opcode;switch(this.frameQueue.forEach(function(e){e.binaryPayload.copy(t,a),a+=e.binaryPayload.length}),this.frameQueue=[],this.fragmentationSize=0,r){case 2:this.emit("message",{type:"binary",binaryData:t});break;case 1:if(!o.isValidUTF8(t))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this.emit("message",{type:"utf8",utf8Data:t.toString("utf8")});break;default:return void this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unexpected first opcode in fragmentation sequence: 0x"+r.toString(16))}}}break;case 9:if(this._debug("-- Ping Frame"),this._pingListenerCount>0){var c=!1;this.emit("ping",function(){c=!0},e.binaryPayload),c||this.pong(e.binaryPayload)}else this.pong(e.binaryPayload);break;case 10:this._debug("-- Pong Frame"),this.emit("pong",e.binaryPayload);break;case 8:if(this._debug("-- Close Frame"),this.waitingForCloseResponse)return this._debug("---- Got close response from peer.  Completing closing handshake."),this.clearCloseTimer(),this.waitingForCloseResponse=!1,this.state="closed",void this.socket.end();var n;if(this._debug("---- Closing handshake initiated by peer."),this.state="peer_requested_close",e.invalidCloseFrameLength?(this.closeReasonCode=1005,n=u.CLOSE_REASON_PROTOCOL_ERROR):-1===e.closeStatus||l(e.closeStatus)?(this.closeReasonCode=e.closeStatus,n=u.CLOSE_REASON_NORMAL):(this.closeReasonCode=e.closeStatus,n=u.CLOSE_REASON_PROTOCOL_ERROR),e.binaryPayload.length>1){if(!o.isValidUTF8(e.binaryPayload))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this.closeDescription=e.binaryPayload.toString("utf8")}else this.closeDescription=u.CLOSE_DESCRIPTIONS[this.closeReasonCode];this._debug("------ Remote peer %s - code: %d - %s - close frame payload length: %d",this.remoteAddress,this.closeReasonCode,this.closeDescription,e.length),this._debug("------ responding to remote peer's close request."),this.sendCloseFrame(n,null),this.connected=!1;break;default:this._debug("-- Unrecognized Opcode %d",e.opcode),this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unrecognized Opcode: 0x"+e.opcode.toString(16))}},u.prototype.send=function(e,a){if(this._debug("send"),Buffer.isBuffer(e))this.sendBytes(e,a);else{if("function"!=typeof e.toString)throw new Error("Data provided must either be a Node Buffer or implement toString()");this.sendUTF(e,a)}},u.prototype.sendUTF=function(e,a){e=new Buffer(e.toString(),"utf8"),this._debug("sendUTF: %d bytes",e.length);var t=new i(this.maskBytes,this.frameHeader,this.config);t.opcode=1,t.binaryPayload=e,this.fragmentAndSend(t,a)},u.prototype.sendBytes=function(e,a){if(this._debug("sendBytes"),!Buffer.isBuffer(e))throw new Error("You must pass a Node Buffer object to WebSocketConnection.prototype.sendBytes()");var t=new i(this.maskBytes,this.frameHeader,this.config);t.opcode=2,t.binaryPayload=e,this.fragmentAndSend(t,a)},u.prototype.ping=function(e){this._debug("ping");var a=new i(this.maskBytes,this.frameHeader,this.config);a.opcode=9,a.fin=!0,e&&(Buffer.isBuffer(e)||(e=new Buffer(e.toString(),"utf8")),e.length>125&&(this._debug("WebSocket: Data for ping is longer than 125 bytes.  Truncating."),e=e.slice(0,124)),a.binaryPayload=e),this.sendFrame(a)},u.prototype.pong=function(e){this._debug("pong");var a=new i(this.maskBytes,this.frameHeader,this.config);a.opcode=10,Buffer.isBuffer(e)&&e.length>125&&(this._debug("WebSocket: Data for pong is longer than 125 bytes.  Truncating."),e=e.slice(0,124)),a.binaryPayload=e,a.fin=!0,this.sendFrame(a)},u.prototype.fragmentAndSend=function(e,a){if(this._debug("fragmentAndSend"),e.opcode>7)throw new Error("You cannot fragment control frames.");var t=this.config.fragmentationThreshold,r=e.binaryPayload.length;if(!this.config.fragmentOutgoingMessages||e.binaryPayload&&r<=t)return e.fin=!0,void this.sendFrame(e,a);for(var c=Math.ceil(r/t),n=0,f=function(e){e?"function"==typeof a&&(a(e),a=null):++n===c&&"function"==typeof a&&a()},o=1;o<=c;o++){var d=new i(this.maskBytes,this.frameHeader,this.config);d.opcode=1===o?e.opcode:0,d.fin=o===c;var s=o===c?r-t*(o-1):t,b=t*(o-1);d.binaryPayload=e.binaryPayload.slice(b,b+s),this.sendFrame(d,f)}},u.prototype.sendCloseFrame=function(e,a,t){if("number"!=typeof e&&(e=u.CLOSE_REASON_NORMAL),this._debug("sendCloseFrame state: %s, reasonCode: %d, description: %s",this.state,e,a),this.state===d||"peer_requested_close"===this.state){var r=new i(this.maskBytes,this.frameHeader,this.config);r.fin=!0,r.opcode=8,r.closeStatus=e,"string"==typeof a&&(r.binaryPayload=new Buffer(a,"utf8")),this.sendFrame(r,t),this.socket.end()}},u.prototype.sendFrame=function(e,a){this._debug("sendFrame"),e.mask=this.maskOutgoingPackets;var t=this.socket.write(e.toBuffer(),a);return this.outputBufferFull=!t,t},e.exports=u},function(e,a,t){e.exports=f;var r=Object.keys||function(e){var a=[];for(var t in e)a.push(t);return a},c=t(17);c.inherits=t(0);var n=t(201),i=t(200);function f(e){if(!(this instanceof f))return new f(e);n.call(this,e),i.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",o)}function o(){this.allowHalfOpen||this._writableState.ended||process.nextTick(this.end.bind(this))}c.inherits(f,n),function(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}(r(i.prototype),function(e){f.prototype[e]||(f.prototype[e]=i.prototype[e])})},function(e,a,t){var r=t(351).create,c=r("LevelUPError"),n=r("NotFoundError",c);n.prototype.notFound=!0,n.prototype.status=404,e.exports={LevelUPError:c,InitializationError:r("InitializationError",c),OpenError:r("OpenError",c),ReadError:r("ReadError",c),WriteError:r("WriteError",c),NotFoundError:n,EncodingError:r("EncodingError",c)}},function(e,a,t){"use strict";var r=t(441),c=t(439),n=t(437),i=t(436),f=t(39),o=t(435);e.exports=function(e,a){return"function"==typeof e.sublevel&&"function"==typeof e.clone?e.clone(a):function(e,a){return a=f(e.options,a),c(r(e,n,i),[],o,a)}(e,a)}},function(e,a,t){"use strict";var r={UNKNOWN:{errno:-1,message:"unknown error"},OK:{errno:0,message:"success"},EOF:{errno:1,message:"end of file"},EADDRINFO:{errno:2,message:"getaddrinfo error"},EACCES:{errno:3,message:"permission denied"},EAGAIN:{errno:4,message:"resource temporarily unavailable"},EADDRINUSE:{errno:5,message:"address already in use"},EADDRNOTAVAIL:{errno:6,message:"address not available"},EAFNOSUPPORT:{errno:7,message:"address family not supported"},EALREADY:{errno:8,message:"connection already in progress"},EBADF:{errno:9,message:"bad file descriptor"},EBUSY:{errno:10,message:"resource busy or locked"},ECONNABORTED:{errno:11,message:"software caused connection abort"},ECONNREFUSED:{errno:12,message:"connection refused"},ECONNRESET:{errno:13,message:"connection reset by peer"},EDESTADDRREQ:{errno:14,message:"destination address required"},EFAULT:{errno:15,message:"bad address in system call argument"},EHOSTUNREACH:{errno:16,message:"host is unreachable"},EINTR:{errno:17,message:"interrupted system call"},EINVAL:{errno:18,message:"invalid argument"},EISCONN:{errno:19,message:"socket is already connected"},EMFILE:{errno:20,message:"too many open files"},EMSGSIZE:{errno:21,message:"message too long"},ENETDOWN:{errno:22,message:"network is down"},ENETUNREACH:{errno:23,message:"network is unreachable"},ENFILE:{errno:24,message:"file table overflow"},ENOBUFS:{errno:25,message:"no buffer space available"},ENOMEM:{errno:26,message:"not enough memory"},ENOTDIR:{errno:27,message:"not a directory"},EISDIR:{errno:28,message:"illegal operation on a directory"},ENONET:{errno:29,message:"machine is not on the network"},ENOTCONN:{errno:31,message:"socket is not connected"},ENOTSOCK:{errno:32,message:"socket operation on non-socket"},ENOTSUP:{errno:33,message:"operation not supported on socket"},ENOENT:{errno:34,message:"no such file or directory"},ENOSYS:{errno:35,message:"function not implemented"},EPIPE:{errno:36,message:"broken pipe"},EPROTO:{errno:37,message:"protocol error"},EPROTONOSUPPORT:{errno:38,message:"protocol not supported"},EPROTOTYPE:{errno:39,message:"protocol wrong type for socket"},ETIMEDOUT:{errno:40,message:"connection timed out"},ECHARSET:{errno:41,message:"invalid Unicode character"},EAIFAMNOSUPPORT:{errno:42,message:"address family for hostname not supported"},EAISERVICE:{errno:44,message:"servname not supported for ai_socktype"},EAISOCKTYPE:{errno:45,message:"ai_socktype not supported"},ESHUTDOWN:{errno:46,message:"cannot send after transport endpoint shutdown"},EEXIST:{errno:47,message:"file already exists"},ESRCH:{errno:48,message:"no such process"},ENAMETOOLONG:{errno:49,message:"name too long"},EPERM:{errno:50,message:"operation not permitted"},ELOOP:{errno:51,message:"too many symbolic links encountered"},EXDEV:{errno:52,message:"cross-device link not permitted"},ENOTEMPTY:{errno:53,message:"directory not empty"},ENOSPC:{errno:54,message:"no space left on device"},EIO:{errno:55,message:"i/o error"},EROFS:{errno:56,message:"read-only file system"},ENODEV:{errno:57,message:"no such device"},ESPIPE:{errno:58,message:"invalid seek"},ECANCELED:{errno:59,message:"peration canceled"}};function c(e,a){if(!r.hasOwnProperty(e))throw new Error("Programmer error, invalid error code: "+e);Error.call(this);var t=r[e],n=e+", "+t.message;a&&(n+=" '"+a+"'"),this.message=n,this.code=e,this.errno=t.errno,void 0!==a&&(this.path=a),Error.captureStackTrace(this,c)}c.prototype=new Error,e.exports=c},function(e,a,t){"use strict";var r=0,c=256,n=128,i=64,f=32,o=16,d=8,s=4,b=2,u=1;function l(){return process.getuid&&process.getuid()}function p(){return process.getgid&&process.getgid()}function h(){var e=Date.now();this._atime=new Date(e),this._ctime=new Date(e),this._birthtime=new Date(e),this._mtime=new Date(e),this._mode=438,this._uid=l(),this._gid=p(),this._id=++r,this.links=0}h.prototype.canRead=function(){var e=l(),a=p();return 0===e||(e===this._uid?(c&this._mode)===c:a===this._gid?(f&this._mode)===f:(s&this._mode)===s)},h.prototype.canWrite=function(){var e=l(),a=p();return 0===e||(e===this._uid?(n&this._mode)===n:a===this._gid?(o&this._mode)===o:(b&this._mode)===b)},h.prototype.canExecute=function(){var e=l(),a=p();return 0===e||(e===this._uid?(i&this._mode)===i:a===this._gid?(d&this._mode)===d:(u&this._mode)===u)},h.prototype.getATime=function(){return this._atime},h.prototype.setATime=function(e){this._atime=e},h.prototype.getCTime=function(){return this._ctime},h.prototype.setCTime=function(e){this._ctime=e},h.prototype.getBirthtime=function(){return this._birthtime},h.prototype.setBirthtime=function(e){this._birthtime=e},h.prototype.getMTime=function(){return this._mtime},h.prototype.setMTime=function(e){this._mtime=e},h.prototype.getMode=function(){return this._mode},h.prototype.setMode=function(e){this.setCTime(new Date),this._mode=e},h.prototype.getUid=function(){return this._uid},h.prototype.setUid=function(e){this.setCTime(new Date),this._uid=e},h.prototype.getGid=function(){return this._gid},h.prototype.setGid=function(e){this.setCTime(new Date),this._gid=e},h.prototype.getStats=function(){return{dev:8675309,nlink:this.links,uid:this.getUid(),gid:this.getGid(),rdev:0,blksize:4096,ino:this._id,atime:this.getATime(),mtime:this.getMTime(),ctime:this.getCTime(),birthtime:this.getBirthtime()}},h.prototype.toString=function(){return"["+this.constructor.name+"]"},e.exports=h},function(e,a,t){var r=t(4),c=/([a-z\xE0-\xFF])([A-Z\xC0\xDF])/g;e.exports=function(e,a){return null==a&&(a=" "),e=(e=(e=r(e)).replace(c,function(e,t,r){return t+a+r})).toLowerCase()}},function(e,a,t){var r=t(4),c=t(130),n=t(129),i=t(128);e.exports=function(e,a){return e=r(e),null==a&&(a="-"),e=c(e),e=n(e),e=i(e).replace(/ +/g,a).toLowerCase()}},function(e,a,t){var r=t(4),c=t(96),n=t(214),i=t(213);e.exports=function(e,a){return e=r(e),n(i(e,a=a||c),a)}},function(e,a,t){var r=t(4),c=/[^\x20\x2D0-9A-Z\x5Fa-z\xC0-\xD6\xD8-\xF6\xF8-\xFF]/g;e.exports=function(e){return(e=r(e)).replace(c,"")}},function(e,a,t){var r=t(4);e.exports=function(e){return(e=r(e)).search(/[\xC0-\xFF]/g)>-1&&(e=e.replace(/[\xC0-\xC5]/g,"A").replace(/[\xC6]/g,"AE").replace(/[\xC7]/g,"C").replace(/[\xC8-\xCB]/g,"E").replace(/[\xCC-\xCF]/g,"I").replace(/[\xD0]/g,"D").replace(/[\xD1]/g,"N").replace(/[\xD2-\xD6\xD8]/g,"O").replace(/[\xD9-\xDC]/g,"U").replace(/[\xDD]/g,"Y").replace(/[\xDE]/g,"P").replace(/[\xE0-\xE5]/g,"a").replace(/[\xE6]/g,"ae").replace(/[\xE7]/g,"c").replace(/[\xE8-\xEB]/g,"e").replace(/[\xEC-\xEF]/g,"i").replace(/[\xF1]/g,"n").replace(/[\xF2-\xF6\xF8]/g,"o").replace(/[\xF9-\xFC]/g,"u").replace(/[\xFE]/g,"p").replace(/[\xFD\xFF]/g,"y")),e}},function(e,a,t){var r=t(148);e.exports=function(){return r()>=.5}},function(e,a,t){var r=t(72),c=t(31);e.exports=function(e){var a=1===arguments.length&&c(e)?e:arguments;return a[r(0,a.length-1)]}},function(e,a){var t;e.exports=function(e){return null===e||"null"===e?null:"true"===e||"false"!==e&&(e===t||"undefined"===e?t:""===e||isNaN(e)?e:parseFloat(e))}},function(e,a,t){t(230);e.exports=function(e,a){for(var t=a.split("."),r=t.pop();a=t.shift();)if(null==(e=e[a]))return;return e[r]}},function(e,a,t){var r=t(76),c=t(136);e.exports=function(e){var a,t=[],n=r(e);if(null!=e)if(null==e.length||"String"===n||"Function"===n||"RegExp"===n||e===c)t[t.length]=e;else for(a=e.length;a--;)t[a]=e[a];return t}},function(e,a){e.exports=Function("return this")()},function(e,a){function t(){return t.get()}t.get="function"==typeof Date.now?Date.now:function(){return+new Date},e.exports=t},function(e,a,t){var r=t(98);e.exports=function(e){var a=e.getTimezoneOffset(),t=Math.abs(a),c=r(Math.floor(t/60),2),n=r(t%60,2);return(a>0?"-":"+")+c+n}},function(e,a){e.exports=function(e){return~~e}},function(e,a,t){var r=t(4),c=t(139);e.exports=function(e,a){var t="";if(e=r(e),(a=c(a))<1)return"";for(;a>0;)a%2&&(t+=e),a=Math.floor(a/2),e+=e;return t}},function(e,a,t){var r=t(4),c=t(140);e.exports=function(e,a,t){return e=r(e),t=t||" ",e.length<a?c(t,a-e.length)+e:e}},function(e,a,t){var r=t(76),c=t(53),n=t(99);e.exports=function(e){switch(r(e)){case"Object":return function(e){return c(e)?n({},e):e}(e);case"Array":return function(e){return e.slice()}(e);case"RegExp":return function(e){var a="";return a+=e.multiline?"m":"",a+=e.global?"g":"",a+=e.ignoreCase?"i":"",new RegExp(e.source,a)}(e);case"Date":return function(e){return new Date(+e)}(e);default:return e}}},function(e,a,t){var r=t(100);e.exports=function(e){return r(e)&&(e=e.getFullYear()),e%400==0||e%100!=0&&e%4==0}},function(e,a,t){t(100);e.exports=function(e){return(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate())-Date.UTC(e.getFullYear(),0,1))/864e5+1}},function(e,a,t){var r=t(16);e.exports=function(e){var a=0;return r(e,function(){a++}),a}},function(e,a,t){var r=t(16),c=t(14);e.exports=function(e,a,t){a=c(a,t);var n=!0;return r(e,function(t,r){if(!a(t,r,e))return n=!1,!1}),n}},function(e,a,t){var r=t(35);e.exports=function(e){return r(e,"Function")}},function(e,a){function t(){return t.get()}t.get=Math.random,e.exports=t},function(e,a){e.exports=-2147483648},function(e,a,t){var r=t(14);e.exports=function(e,a,t){if(null!=e&&e.length){if(e.length&&!a)return Math.min.apply(Math,e);a=r(a,t);for(var c,n,i,f=1/0,o=-1,d=e.length;++o<d;)(i=a(n=e[o],o,e))<f&&(f=i,c=n);return c}return-1/0}},function(e,a,t){var r=t(259);e.exports=function(e,a,t){var c=r(e,a,t);return c>=0?e[c]:void 0}},function(e,a,t){var r,c,n=t(55);function i(e,a,t,r){return e.call(r,a[t],t,a)}e.exports=function(e,a,t){var f,o=0;for(f in null==r&&function(){for(var e in c=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],r=!0,{toString:null})r=!1}(),e)if(!1===i(a,e,f,t))break;if(r)for(var d=e.constructor,s=!!d&&e===d.prototype;(f=c[o++])&&("constructor"===f&&(s||!n(e,f))||e[f]===Object.prototype[f]||!1!==i(a,e,f,t)););}},function(e,a){e.exports=function(e){return function(a){return a[e]}}},function(e,a){e.exports=function(e){return e}},function(e,a){e.exports=function e(a){if(a._collected)return;if(a._paused)return a.on("resume",e.bind(null,a));a._collected=!0;a.pause();a.on("data",r);a.on("end",r);var t=[];function r(e){"string"==typeof e&&(e=new Buffer(e)),Buffer.isBuffer(e)&&!e.length||t.push(e)}a.on("entry",n);var c=[];function n(a){e(a),c.push(a)}a.on("proxy",function(e){e.pause()});a.pipe=function(e){return function(i){var f=0;return function o(){var d=c[f++];if(!d)return function(){a.removeListener("entry",n),a.removeListener("data",r),a.removeListener("end",r),a.pipe=e,i&&a.pipe(i);t.forEach(function(e){e?a.emit("data",e):a.emit("end")}),a.resume()}();d.on("end",o),i?i.add(d):a.emit("entry",d)}(),i}}(a.pipe)}},function(e,a,t){var r=t(269);function c(e){var a=function(){return a.called?a.value:(a.called=!0,a.value=e.apply(this,arguments))};return a.called=!1,a}function n(e){var a=function(){if(a.called)throw new Error(a.onceError);return a.called=!0,a.value=e.apply(this,arguments)},t=e.name||"Function wrapped with `once`";return a.onceError=t+" shouldn't be called more than once",a.called=!1,a}e.exports=r(c),e.exports.strict=r(n),c.proto=c(function(){Object.defineProperty(Function.prototype,"once",{value:function(){return c(this)},configurable:!0}),Object.defineProperty(Function.prototype,"onceStrict",{value:function(){return n(this)},configurable:!0})})},function(e,a,t){"use strict";function r(e){return"/"===e.charAt(0)}function c(e){var a=/^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/.exec(e),t=a[1]||"",r=Boolean(t&&":"!==t.charAt(1));return Boolean(a[2]||r)}e.exports="win32"===process.platform?c:r,e.exports.posix=r,e.exports.win32=c},function(e,a,t){e.exports=p,p.Minimatch=h;var r={sep:"/"};try{r=t(2)}catch(e){}var c=p.GLOBSTAR=h.GLOBSTAR={},n=t(654),i={"!":{open:"(?:(?!(?:",close:"))[^/]*?)"},"?":{open:"(?:",close:")?"},"+":{open:"(?:",close:")+"},"*":{open:"(?:",close:")*"},"@":{open:"(?:",close:")"}},f="[^/]",o=f+"*?",d="(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?",s="(?:(?!(?:\\/|^)\\.).)*?",b=function(e){return e.split("").reduce(function(e,a){return e[a]=!0,e},{})}("().*{}+?[]^$\\!");var u=/\/+/;function l(e,a){e=e||{},a=a||{};var t={};return Object.keys(a).forEach(function(e){t[e]=a[e]}),Object.keys(e).forEach(function(a){t[a]=e[a]}),t}function p(e,a,t){if("string"!=typeof a)throw new TypeError("glob pattern string required");return t||(t={}),!(!t.nocomment&&"#"===a.charAt(0))&&(""===a.trim()?""===e:new h(a,t).match(e))}function h(e,a){if(!(this instanceof h))return new h(e,a);if("string"!=typeof e)throw new TypeError("glob pattern string required");a||(a={}),e=e.trim(),"/"!==r.sep&&(e=e.split(r.sep).join("/")),this.options=a,this.set=[],this.pattern=e,this.regexp=null,this.negate=!1,this.comment=!1,this.empty=!1,this.make()}function m(e,a){if(a||(a=this instanceof h?this.options:{}),void 0===(e=void 0===e?this.pattern:e))throw new TypeError("undefined pattern");return a.nobrace||!e.match(/\{.*\}/)?[e]:n(e)}p.filter=function(e,a){return a=a||{},function(t,r,c){return p(t,e,a)}},p.defaults=function(e){if(!e||!Object.keys(e).length)return p;var a=p,t=function(t,r,c){return a.minimatch(t,r,l(e,c))};return t.Minimatch=function(t,r){return new a.Minimatch(t,l(e,r))},t},h.defaults=function(e){return e&&Object.keys(e).length?p.defaults(e).Minimatch:h},h.prototype.debug=function(){},h.prototype.make=function(){if(this._made)return;var e=this.pattern,a=this.options;if(!a.nocomment&&"#"===e.charAt(0))return void(this.comment=!0);if(!e)return void(this.empty=!0);this.parseNegate();var t=this.globSet=this.braceExpand();a.debug&&(this.debug=console.error);this.debug(this.pattern,t),t=this.globParts=t.map(function(e){return e.split(u)}),this.debug(this.pattern,t),t=t.map(function(e,a,t){return e.map(this.parse,this)},this),this.debug(this.pattern,t),t=t.filter(function(e){return-1===e.indexOf(!1)}),this.debug(this.pattern,t),this.set=t},h.prototype.parseNegate=function(){var e=this.pattern,a=!1,t=0;if(this.options.nonegate)return;for(var r=0,c=e.length;r<c&&"!"===e.charAt(r);r++)a=!a,t++;t&&(this.pattern=e.substr(t));this.negate=a},p.braceExpand=function(e,a){return m(e,a)},h.prototype.braceExpand=m,h.prototype.parse=function(e,a){if(e.length>65536)throw new TypeError("pattern is too long");var t=this.options;if(!t.noglobstar&&"**"===e)return c;if(""===e)return"";var r,n="",d=!!t.nocase,s=!1,u=[],l=[],p=!1,h=-1,m=-1,v="."===e.charAt(0)?"":t.dot?"(?!(?:^|\\/)\\.{1,2}(?:$|\\/))":"(?!\\.)",y=this;function _(){if(r){switch(r){case"*":n+=o,d=!0;break;case"?":n+=f,d=!0;break;default:n+="\\"+r}y.debug("clearStateChar %j %j",r,n),r=!1}}for(var w,A=0,k=e.length;A<k&&(w=e.charAt(A));A++)if(this.debug("%s\t%s %s %j",e,A,n,w),s&&b[w])n+="\\"+w,s=!1;else switch(w){case"/":return!1;case"\\":_(),s=!0;continue;case"?":case"*":case"+":case"@":case"!":if(this.debug("%s\t%s %s %j <-- stateChar",e,A,n,w),p){this.debug("  in class"),"!"===w&&A===m+1&&(w="^"),n+=w;continue}y.debug("call clearStateChar %j",r),_(),r=w,t.noext&&_();continue;case"(":if(p){n+="(";continue}if(!r){n+="\\(";continue}u.push({type:r,start:A-1,reStart:n.length,open:i[r].open,close:i[r].close}),n+="!"===r?"(?:(?!(?:":"(?:",this.debug("plType %j %j",r,n),r=!1;continue;case")":if(p||!u.length){n+="\\)";continue}_(),d=!0;var x=u.pop();n+=x.close,"!"===x.type&&l.push(x),x.reEnd=n.length;continue;case"|":if(p||!u.length||s){n+="\\|",s=!1;continue}_(),n+="|";continue;case"[":if(_(),p){n+="\\"+w;continue}p=!0,m=A,h=n.length,n+=w;continue;case"]":if(A===m+1||!p){n+="\\"+w,s=!1;continue}if(p){var E=e.substring(m+1,A);try{RegExp("["+E+"]")}catch(e){var S=this.parse(E,g);n=n.substr(0,h)+"\\["+S[0]+"\\]",d=d||S[1],p=!1;continue}}d=!0,p=!1,n+=w;continue;default:_(),s?s=!1:!b[w]||"^"===w&&p||(n+="\\"),n+=w}p&&(E=e.substr(m+1),S=this.parse(E,g),n=n.substr(0,h)+"\\["+S[0],d=d||S[1]);for(x=u.pop();x;x=u.pop()){var T=n.slice(x.reStart+x.open.length);this.debug("setting tail",n,x),T=T.replace(/((?:\\{2}){0,64})(\\?)\|/g,function(e,a,t){return t||(t="\\"),a+a+t+"|"}),this.debug("tail=%j\n   %s",T,T,x,n);var j="*"===x.type?o:"?"===x.type?f:"\\"+x.type;d=!0,n=n.slice(0,x.reStart)+j+"\\("+T}_(),s&&(n+="\\\\");var C=!1;switch(n.charAt(0)){case".":case"[":case"(":C=!0}for(var R=l.length-1;R>-1;R--){var O=l[R],B=n.slice(0,O.reStart),M=n.slice(O.reStart,O.reEnd-8),N=n.slice(O.reEnd-8,O.reEnd),I=n.slice(O.reEnd);N+=I;var P=B.split("(").length-1,F=I;for(A=0;A<P;A++)F=F.replace(/\)[+*?]?/,"");var L="";""===(I=F)&&a!==g&&(L="$");var D=B+M+I+L+N;n=D}""!==n&&d&&(n="(?=.)"+n);C&&(n=v+n);if(a===g)return[n,d];if(!d)return function(e){return e.replace(/\\(.)/g,"$1")}(e);var z=t.nocase?"i":"";try{var q=new RegExp("^"+n+"$",z)}catch(e){return new RegExp("$.")}return q._glob=e,q._src=n,q};var g={};p.makeRe=function(e,a){return new h(e,a||{}).makeRe()},h.prototype.makeRe=function(){if(this.regexp||!1===this.regexp)return this.regexp;var e=this.set;if(!e.length)return this.regexp=!1,this.regexp;var a=this.options,t=a.noglobstar?o:a.dot?d:s,r=a.nocase?"i":"",n=e.map(function(e){return e.map(function(e){return e===c?t:"string"==typeof e?function(e){return e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&")}(e):e._src}).join("\\/")}).join("|");n="^(?:"+n+")$",this.negate&&(n="^(?!"+n+").*$");try{this.regexp=new RegExp(n,r)}catch(e){this.regexp=!1}return this.regexp},p.match=function(e,a,t){var r=new h(a,t=t||{});return e=e.filter(function(e){return r.match(e)}),r.options.nonull&&!e.length&&e.push(a),e},h.prototype.match=function(e,a){if(this.debug("match",e,this.pattern),this.comment)return!1;if(this.empty)return""===e;if("/"===e&&a)return!0;var t=this.options;"/"!==r.sep&&(e=e.split(r.sep).join("/"));e=e.split(u),this.debug(this.pattern,"split",e);var c,n,i=this.set;for(this.debug(this.pattern,"set",i),n=e.length-1;n>=0&&!(c=e[n]);n--);for(n=0;n<i.length;n++){var f=i[n],o=e;t.matchBase&&1===f.length&&(o=[c]);var d=this.matchOne(o,f,a);if(d)return!!t.flipNegate||!this.negate}return!t.flipNegate&&this.negate},h.prototype.matchOne=function(e,a,t){var r=this.options;this.debug("matchOne",{this:this,file:e,pattern:a}),this.debug("matchOne",e.length,a.length);for(var n=0,i=0,f=e.length,o=a.length;n<f&&i<o;n++,i++){this.debug("matchOne loop");var d,s=a[i],b=e[n];if(this.debug(a,s,b),!1===s)return!1;if(s===c){this.debug("GLOBSTAR",[a,s,b]);var u=n,l=i+1;if(l===o){for(this.debug("** at the end");n<f;n++)if("."===e[n]||".."===e[n]||!r.dot&&"."===e[n].charAt(0))return!1;return!0}for(;u<f;){var p=e[u];if(this.debug("\nglobstar while",e,u,a,l,p),this.matchOne(e.slice(u),a.slice(l),t))return this.debug("globstar found match!",u,f,p),!0;if("."===p||".."===p||!r.dot&&"."===p.charAt(0)){this.debug("dot detected!",e,u,a,l);break}this.debug("globstar swallow a segment, and continue"),u++}return!(!t||(this.debug("\n>>> no match, partial?",e,u,a,l),u!==f))}if("string"==typeof s?(d=r.nocase?b.toLowerCase()===s.toLowerCase():b===s,this.debug("string match",s,b,d)):(d=b.match(s),this.debug("pattern match",s,b,d)),!d)return!1}if(n===f&&i===o)return!0;if(n===f)return t;if(i===o)return n===f-1&&""===e[n];throw new Error("wtf?")}},function(e,a,t){e.exports=c;var r=t(6).Stream;function c(){r.call(this)}function n(e,a,t){return e instanceof Error||(e=new Error(e)),e.code=e.code||a,e.path=e.path||t.path,e.fstream_type=e.fstream_type||t.type,e.fstream_path=e.fstream_path||t.path,t._path!==t.path&&(e.fstream_unc_path=e.fstream_unc_path||t._path),t.linkpath&&(e.fstream_linkpath=e.fstream_linkpath||t.linkpath),e.fstream_class=e.fstream_class||t.constructor.name,e.fstream_stack=e.fstream_stack||(new Error).stack.split(/\n/).slice(3).map(function(e){return e.replace(/^ {4}at /,"")}),e}t(0)(c,r),c.prototype.on=function(e,a){return"ready"===e&&this.ready?process.nextTick(a.bind(this)):r.prototype.on.call(this,e,a),this},c.prototype.abort=function(){this._aborted=!0,this.emit("abort")},c.prototype.destroy=function(){},c.prototype.warn=function(e,a){var t=n(e,a,this);this.listeners("warn")?this.emit("warn",t):console.error("%s %s\npath = %s\nsyscall = %s\nfstream_type = %s\nfstream_path = %s\nfstream_unc_path = %s\nfstream_class = %s\nfstream_stack =\n%s\n",a||"UNKNOWN",t.stack,t.path,t.syscall,t.fstream_type,t.fstream_path,t.fstream_unc_path,t.fstream_class,t.fstream_stack.join("\n"))},c.prototype.info=function(e,a){this.emit("info",e,a)},c.prototype.error=function(e,a,t){var r=n(e,a,this);if(t)throw r;this.emit("error",r)}},function(e,a,t){var r=t(2),c=t(15),n=parseInt("0777",8);function i(e,a,t,f){"function"==typeof a?(t=a,a={}):a&&"object"==typeof a||(a={mode:a});var o=a.mode,d=a.fs||c;void 0===o&&(o=n&~process.umask()),f||(f=null);var s=t||function(){};e=r.resolve(e),d.mkdir(e,o,function(t){if(!t)return s(null,f=f||e);switch(t.code){case"ENOENT":i(r.dirname(e),a,function(t,r){t?s(t,r):i(e,a,s,r)});break;default:d.stat(e,function(e,a){e||!a.isDirectory()?s(t,f):s(null,f)})}})}e.exports=i.mkdirp=i.mkdirP=i,i.sync=function e(a,t,i){t&&"object"==typeof t||(t={mode:t});var f=t.mode,o=t.fs||c;void 0===f&&(f=n&~process.umask()),i||(i=null),a=r.resolve(a);try{o.mkdirSync(a,f),i=i||a}catch(c){switch(c.code){case"ENOENT":e(a,t,i=e(r.dirname(a),t,i));break;default:var d;try{d=o.statSync(a)}catch(e){throw c}if(!d.isDirectory())throw c}}return i}},function(e,a,t){"use strict";const r=t(723);e.exports={readJson:r.readFile,readJSON:r.readFile,readJsonSync:r.readFileSync,readJSONSync:r.readFileSync,writeJson:r.writeFile,writeJSON:r.writeFile,writeJsonSync:r.writeFileSync,writeJSONSync:r.writeFileSync,spaces:2}},function(e,a,t){"use strict";const r=t(8),c=t(2),n=t(288).invalidWin32Path,i=parseInt("0777",8);e.exports=function e(a,t,f){t&&"object"==typeof t||(t={mode:t});let o=t.mode;const d=t.fs||r;if("win32"===process.platform&&n(a)){const e=new Error(a+" contains invalid WIN32 path characters.");throw e.code="EINVAL",e}void 0===o&&(o=i&~process.umask()),f||(f=null),a=c.resolve(a);try{d.mkdirSync(a,o),f=f||a}catch(r){switch(r.code){case"ENOENT":if(c.dirname(a)===a)throw r;e(a,t,f=e(c.dirname(a),t,f));break;default:let n;try{n=d.statSync(a)}catch(e){throw r}if(!n.isDirectory())throw r}}return f}},function(e,a,t){"use strict";const r=t(8),c=t(2),n=t(288).invalidWin32Path,i=parseInt("0777",8);e.exports=function e(a,t,f,o){if("function"==typeof t?(f=t,t={}):t&&"object"==typeof t||(t={mode:t}),"win32"===process.platform&&n(a)){const e=new Error(a+" contains invalid WIN32 path characters.");return e.code="EINVAL",f(e)}let d=t.mode;const s=t.fs||r;void 0===d&&(d=i&~process.umask()),o||(o=null),f=f||function(){},a=c.resolve(a),s.mkdir(a,d,r=>{if(!r)return f(null,o=o||a);switch(r.code){case"ENOENT":if(c.dirname(a)===a)return f(r);e(c.dirname(a),t,(r,c)=>{r?f(r,c):e(a,t,f,c)});break;default:s.stat(a,(e,a)=>{e||!a.isDirectory()?f(r,o):f(null,o)})}})}},function(e,a,t){a.publicEncrypt=t(762),a.privateDecrypt=t(745),a.privateEncrypt=function(e,t){return a.publicEncrypt(e,t,!0)},a.publicDecrypt=function(e,t){return a.privateDecrypt(e,t,!0)}},function(e,a,t){t(772);var r=function(e,a){return parseInt(e.slice(2*a+2,2*a+4),16)},c=function(e){return(e.length-2)/2},n=function(e){for(var a=[],t=2,r=e.length;t<r;t+=2)a.push(parseInt(e.slice(t,t+2),16));return a},i=function(e){for(var a="0x",t=0,r=e.length;t<r;++t){var c=e[t];a+=(c<16?"0":"")+c.toString(16)}return a};e.exports={random:function(e){var a=void 0;a="undefined"!=typeof window&&window.crypto&&window.crypto.getRandomValues?window.crypto.getRandomValues(new Uint8Array(e)):t(10).randomBytes(e);for(var r="0x",c=0;c<e;++c)r+=("00"+a[c].toString(16)).slice(-2);return r},length:c,concat:function(e,a){return e.concat(a.slice(2))},flatten:function(e){return"0x"+e.reduce(function(e,a){return e+a.slice(2)},"")},slice:function(e,a,t){return"0x"+t.slice(2*e+2,2*a+2)},reverse:function(e){for(var a="0x",t=0,r=c(e);t<r;++t)a+=e.slice(2*(r-t),2*(r-t+1));return a},pad:function e(a,t){return t.length===2*a+2?t:e(a,"0x0"+t.slice(2))},padRight:function e(a,t){return t.length===2*a+2?t:e(a,t+"0")},fromAscii:function(e){for(var a="0x",t=0;t<e.length;++t)a+=("00"+e.charCodeAt(t).toString(16)).slice(-2);return a},toAscii:function(e){for(var a="",t=2;t<e.length;t+=2)a+=String.fromCharCode(parseInt(e.slice(t,t+2),16));return a},fromString:function(e){for(var a=function(e){var a=e.toString(16);return a.length<2?"0"+a:a},t="0x",r=0;r!=e.length;r++){var c=e.charCodeAt(r);if(c<128)t+=a(c);else{if(c<2048)t+=a(c>>6|192);else{if(c>55295&&c<56320){if(++r==e.length)return null;var n=e.charCodeAt(r);if(n<56320||n>57343)return null;t+=a((c=65536+((1023&c)<<10)+(1023&n))>>18|240),t+=a(c>>12&63|128)}else t+=a(c>>12|224);t+=a(c>>6&63|128)}t+=a(63&c|128)}}return t},toString:function(e){for(var a="",t=0,n=c(e);t<n;){var i=r(e,t++);if(i>127){if(i>191&&i<224){if(t>=n)return null;i=(31&i)<<6|63&r(e,t)}else if(i>223&&i<240){if(t+1>=n)return null;i=(15&i)<<12|(63&r(e,t))<<6|63&r(e,++t)}else{if(!(i>239&&i<248))return null;if(t+2>=n)return null;i=(7&i)<<18|(63&r(e,t))<<12|(63&r(e,++t))<<6|63&r(e,++t)}++t}if(i<=65535)a+=String.fromCharCode(i);else{if(!(i<=1114111))return null;i-=65536,a+=String.fromCharCode(i>>10|55296),a+=String.fromCharCode(1023&i|56320)}}return a},fromNumber:function(e){var a=e.toString(16);return a.length%2==0?"0x"+a:"0x0"+a},toNumber:function(e){return parseInt(e.slice(2),16)},fromNat:function(e){return"0x0"===e?"0x":e.length%2==0?e:"0x0"+e.slice(2)},toNat:function(e){return"0"===e[2]?"0x"+e.slice(3):e},fromArray:i,toArray:n,fromUint8Array:function(e){return i([].slice.call(e,0))},toUint8Array:function(e){return new Uint8Array(n(e))}}},function(e,a,t){var r=t(1),c=t(83),n=t(5).EventEmitter,i=t(314),f=t(805),o=t(804).Validation;const d="open";var s="setImmediate"in global?global.setImmediate.bind(global):process.nextTick.bind(process),b=0;function u(e,a,t,r,o){if(this._debug=c.BufferingLogger("websocket:connection",++b),this._debug("constructor"),this._debug.enabled&&function(e,a){if(!e._debug.enabled)return;var t=a.emit;for(var r in a.emit=function(a){e._debug("||| Socket Event  '%s'",a),t.apply(this,arguments)},a)"function"==typeof a[r]&&-1===["emit"].indexOf(r)&&function(t){var r=a[t];a[t]="on"!==t?function(){return e._debug("||| Socket method called:  %s",t),r.apply(this,arguments)}:function(){return e._debug("||| Socket method called:  %s (%s)",t,arguments[0]),r.apply(this,arguments)}}(r)}(this,e),n.call(this),this._pingListenerCount=0,this.on("newListener",function(e){"ping"===e&&this._pingListenerCount++}).on("removeListener",function(e){"ping"===e&&this._pingListenerCount--}),this.config=o,this.socket=e,this.protocol=t,this.extensions=a,this.remoteAddress=e.remoteAddress,this.closeReasonCode=-1,this.closeDescription=null,this.closeEventEmitted=!1,this.maskOutgoingPackets=r,this.maskBytes=new Buffer(4),this.frameHeader=new Buffer(10),this.bufferList=new f,this.currentFrame=new i(this.maskBytes,this.frameHeader,this.config),this.fragmentationSize=0,this.frameQueue=[],this.connected=!0,this.state=d,this.waitingForCloseResponse=!1,this.receivedEnd=!1,this.closeTimeout=this.config.closeTimeout,this.assembleFragments=this.config.assembleFragments,this.maxReceivedMessageSize=this.config.maxReceivedMessageSize,this.outputBufferFull=!1,this.inputPaused=!1,this.receivedDataHandler=this.processReceivedData.bind(this),this._closeTimerHandler=this.handleCloseTimer.bind(this),this.socket.setNoDelay(this.config.disableNagleAlgorithm),this.socket.setTimeout(0),this.config.keepalive&&!this.config.useNativeKeepalive){if("number"!=typeof this.config.keepaliveInterval)throw new Error("keepaliveInterval must be specified and numeric if keepalive is true.");if(this._keepaliveTimerHandler=this.handleKeepaliveTimer.bind(this),this.setKeepaliveTimer(),this.config.dropConnectionOnKeepaliveTimeout){if("number"!=typeof this.config.keepaliveGracePeriod)throw new Error("keepaliveGracePeriod  must be specified and numeric if dropConnectionOnKeepaliveTimeout is true.");this._gracePeriodTimerHandler=this.handleGracePeriodTimer.bind(this)}}else if(this.config.keepalive&&this.config.useNativeKeepalive){if(!("setKeepAlive"in this.socket))throw new Error("Unable to use native keepalive: unsupported by this version of Node.");this.socket.setKeepAlive(!0,this.config.keepaliveInterval)}this.socket.removeAllListeners("error")}function l(e){return!(e<1e3)&&(e>=1e3&&e<=2999?-1!==[1e3,1001,1002,1003,1007,1008,1009,1010,1011,1012,1013,1014].indexOf(e):e>=3e3&&e<=3999||(e>=4e3&&e<=4999||!(e>=5e3)&&void 0))}u.CLOSE_REASON_NORMAL=1e3,u.CLOSE_REASON_GOING_AWAY=1001,u.CLOSE_REASON_PROTOCOL_ERROR=1002,u.CLOSE_REASON_UNPROCESSABLE_INPUT=1003,u.CLOSE_REASON_RESERVED=1004,u.CLOSE_REASON_NOT_PROVIDED=1005,u.CLOSE_REASON_ABNORMAL=1006,u.CLOSE_REASON_INVALID_DATA=1007,u.CLOSE_REASON_POLICY_VIOLATION=1008,u.CLOSE_REASON_MESSAGE_TOO_BIG=1009,u.CLOSE_REASON_EXTENSION_REQUIRED=1010,u.CLOSE_REASON_INTERNAL_SERVER_ERROR=1011,u.CLOSE_REASON_TLS_HANDSHAKE_FAILED=1015,u.CLOSE_DESCRIPTIONS={1000:"Normal connection closure",1001:"Remote peer is going away",1002:"Protocol error",1003:"Unprocessable input",1004:"Reserved",1005:"Reason not provided",1006:"Abnormal closure, no further detail available",1007:"Invalid data received",1008:"Policy violation",1009:"Message too big",1010:"Extension requested by client is required",1011:"Internal Server Error",1015:"TLS Handshake Failed"},r.inherits(u,n),u.prototype._addSocketEventListeners=function(){this.socket.on("error",this.handleSocketError.bind(this)),this.socket.on("end",this.handleSocketEnd.bind(this)),this.socket.on("close",this.handleSocketClose.bind(this)),this.socket.on("drain",this.handleSocketDrain.bind(this)),this.socket.on("pause",this.handleSocketPause.bind(this)),this.socket.on("resume",this.handleSocketResume.bind(this)),this.socket.on("data",this.handleSocketData.bind(this))},u.prototype.setKeepaliveTimer=function(){this._debug("setKeepaliveTimer"),this.config.keepalive&&!this.config.useNativeKeepalive&&(this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this._keepaliveTimeoutID=setTimeout(this._keepaliveTimerHandler,this.config.keepaliveInterval))},u.prototype.clearKeepaliveTimer=function(){this._keepaliveTimeoutID&&clearTimeout(this._keepaliveTimeoutID)},u.prototype.handleKeepaliveTimer=function(){this._debug("handleKeepaliveTimer"),this._keepaliveTimeoutID=null,this.ping(),this.config.dropConnectionOnKeepaliveTimeout?this.setGracePeriodTimer():this.setKeepaliveTimer()},u.prototype.setGracePeriodTimer=function(){this._debug("setGracePeriodTimer"),this.clearGracePeriodTimer(),this._gracePeriodTimeoutID=setTimeout(this._gracePeriodTimerHandler,this.config.keepaliveGracePeriod)},u.prototype.clearGracePeriodTimer=function(){this._gracePeriodTimeoutID&&clearTimeout(this._gracePeriodTimeoutID)},u.prototype.handleGracePeriodTimer=function(){this._debug("handleGracePeriodTimer"),this._gracePeriodTimeoutID=null,this.drop(u.CLOSE_REASON_ABNORMAL,"Peer not responding.",!0)},u.prototype.handleSocketData=function(e){this._debug("handleSocketData"),this.setKeepaliveTimer(),this.bufferList.write(e),this.processReceivedData()},u.prototype.processReceivedData=function(){if(this._debug("processReceivedData"),this.connected&&!this.inputPaused){var e=this.currentFrame;if(e.addData(this.bufferList)){var a=this;if(e.protocolError)return this._debug("-- protocol error"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_PROTOCOL_ERROR,e.dropReason)});if(e.frameTooLarge)return this._debug("-- frame too large"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_MESSAGE_TOO_BIG,e.dropReason)});if(e.rsv1||e.rsv2||e.rsv3)return this._debug("-- illegal rsv flag"),void process.nextTick(function(){a.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unsupported usage of rsv bits without negotiated extension.")});this.assembleFragments||(this._debug("-- emitting frame"),process.nextTick(function(){a.emit("frame",e)})),process.nextTick(function(){a.processFrame(e)}),this.currentFrame=new i(this.maskBytes,this.frameHeader,this.config),this.bufferList.length>0&&s(this.receivedDataHandler)}else this._debug("-- insufficient data for frame")}},u.prototype.handleSocketError=function(e){this._debug("handleSocketError: %j",e),"closed"!==this.state?(this.closeReasonCode=u.CLOSE_REASON_ABNORMAL,this.closeDescription="Socket Error: "+e.syscall+" "+e.code,this.connected=!1,this.state="closed",this.fragmentationSize=0,c.eventEmitterListenerCount(this,"error")>0&&this.emit("error",e),this.socket.destroy(e),this._debug.printOutput()):this._debug("  --- Socket 'error' after 'close'")},u.prototype.handleSocketEnd=function(){this._debug("handleSocketEnd: received socket end.  state = %s",this.state),this.receivedEnd=!0,"closed"!==this.state?"peer_requested_close"!==this.state&&"ending"!==this.state&&(this._debug("  --- UNEXPECTED socket end."),this.socket.end()):this._debug("  --- Socket 'end' after 'close'")},u.prototype.handleSocketClose=function(e){this._debug("handleSocketClose: received socket close"),this.socketHadError=e,this.connected=!1,this.state="closed",-1===this.closeReasonCode&&(this.closeReasonCode=u.CLOSE_REASON_ABNORMAL,this.closeDescription="Connection dropped by remote peer."),this.clearCloseTimer(),this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this.closeEventEmitted||(this.closeEventEmitted=!0,this._debug("-- Emitting WebSocketConnection close event"),this.emit("close",this.closeReasonCode,this.closeDescription))},u.prototype.handleSocketDrain=function(){this._debug("handleSocketDrain: socket drain event"),this.outputBufferFull=!1,this.emit("drain")},u.prototype.handleSocketPause=function(){this._debug("handleSocketPause: socket pause event"),this.inputPaused=!0,this.emit("pause")},u.prototype.handleSocketResume=function(){this._debug("handleSocketResume: socket resume event"),this.inputPaused=!1,this.emit("resume"),this.processReceivedData()},u.prototype.pause=function(){this._debug("pause: pause requested"),this.socket.pause()},u.prototype.resume=function(){this._debug("resume: resume requested"),this.socket.resume()},u.prototype.close=function(e,a){if(this.connected){if(this._debug("close: Initating clean WebSocket close sequence."),"number"!=typeof e&&(e=u.CLOSE_REASON_NORMAL),!l(e))throw new Error("Close code "+e+" is not valid.");"string"!=typeof a&&(a=u.CLOSE_DESCRIPTIONS[e]),this.closeReasonCode=e,this.closeDescription=a,this.setCloseTimer(),this.sendCloseFrame(this.closeReasonCode,this.closeDescription),this.state="ending",this.connected=!1}},u.prototype.drop=function(e,a,t){this._debug("drop"),"number"!=typeof e&&(e=u.CLOSE_REASON_PROTOCOL_ERROR),"string"!=typeof a&&(a=u.CLOSE_DESCRIPTIONS[e]),this._debug("Forcefully dropping connection. skipCloseFrame: %s, code: %d, description: %s",t,e,a),this.closeReasonCode=e,this.closeDescription=a,this.frameQueue=[],this.fragmentationSize=0,t||this.sendCloseFrame(e,a),this.connected=!1,this.state="closed",this.clearCloseTimer(),this.clearKeepaliveTimer(),this.clearGracePeriodTimer(),this.closeEventEmitted||(this.closeEventEmitted=!0,this._debug("Emitting WebSocketConnection close event"),this.emit("close",this.closeReasonCode,this.closeDescription)),this._debug("Drop: destroying socket"),this.socket.destroy()},u.prototype.setCloseTimer=function(){this._debug("setCloseTimer"),this.clearCloseTimer(),this._debug("Setting close timer"),this.waitingForCloseResponse=!0,this.closeTimer=setTimeout(this._closeTimerHandler,this.closeTimeout)},u.prototype.clearCloseTimer=function(){this._debug("clearCloseTimer"),this.closeTimer&&(this._debug("Clearing close timer"),clearTimeout(this.closeTimer),this.waitingForCloseResponse=!1,this.closeTimer=null)},u.prototype.handleCloseTimer=function(){this._debug("handleCloseTimer"),this.closeTimer=null,this.waitingForCloseResponse&&(this._debug("Close response not received from client.  Forcing socket end."),this.waitingForCloseResponse=!1,this.state="closed",this.socket.end())},u.prototype.processFrame=function(e){if(this._debug("processFrame"),this._debug(" -- frame: %s",e),0!==this.frameQueue.length&&e.opcode>0&&e.opcode<8)this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Illegal frame opcode 0x"+e.opcode.toString(16)+" received in middle of fragmented message.");else switch(e.opcode){case 2:this._debug("-- Binary Frame"),this.assembleFragments&&(e.fin?(this._debug("---- Emitting 'message' event"),this.emit("message",{type:"binary",binaryData:e.binaryPayload})):(this.frameQueue.push(e),this.fragmentationSize=e.length));break;case 1:if(this._debug("-- Text Frame"),this.assembleFragments)if(e.fin){if(!o.isValidUTF8(e.binaryPayload))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this._debug("---- Emitting 'message' event"),this.emit("message",{type:"utf8",utf8Data:e.binaryPayload.toString("utf8")})}else this.frameQueue.push(e),this.fragmentationSize=e.length;break;case 0:if(this._debug("-- Continuation Frame"),this.assembleFragments){if(0===this.frameQueue.length)return void this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unexpected Continuation Frame");if(this.fragmentationSize+=e.length,this.fragmentationSize>this.maxReceivedMessageSize)return void this.drop(u.CLOSE_REASON_MESSAGE_TOO_BIG,"Maximum message size exceeded.");if(this.frameQueue.push(e),e.fin){var a=0,t=new Buffer(this.fragmentationSize),r=this.frameQueue[0].opcode;switch(this.frameQueue.forEach(function(e){e.binaryPayload.copy(t,a),a+=e.binaryPayload.length}),this.frameQueue=[],this.fragmentationSize=0,r){case 2:this.emit("message",{type:"binary",binaryData:t});break;case 1:if(!o.isValidUTF8(t))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this.emit("message",{type:"utf8",utf8Data:t.toString("utf8")});break;default:return void this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unexpected first opcode in fragmentation sequence: 0x"+r.toString(16))}}}break;case 9:if(this._debug("-- Ping Frame"),this._pingListenerCount>0){var c=!1;this.emit("ping",function(){c=!0},e.binaryPayload),c||this.pong(e.binaryPayload)}else this.pong(e.binaryPayload);break;case 10:this._debug("-- Pong Frame"),this.emit("pong",e.binaryPayload);break;case 8:if(this._debug("-- Close Frame"),this.waitingForCloseResponse)return this._debug("---- Got close response from peer.  Completing closing handshake."),this.clearCloseTimer(),this.waitingForCloseResponse=!1,this.state="closed",void this.socket.end();var n;if(this._debug("---- Closing handshake initiated by peer."),this.state="peer_requested_close",e.invalidCloseFrameLength?(this.closeReasonCode=1005,n=u.CLOSE_REASON_PROTOCOL_ERROR):-1===e.closeStatus||l(e.closeStatus)?(this.closeReasonCode=e.closeStatus,n=u.CLOSE_REASON_NORMAL):(this.closeReasonCode=e.closeStatus,n=u.CLOSE_REASON_PROTOCOL_ERROR),e.binaryPayload.length>1){if(!o.isValidUTF8(e.binaryPayload))return void this.drop(u.CLOSE_REASON_INVALID_DATA,"Invalid UTF-8 Data Received");this.closeDescription=e.binaryPayload.toString("utf8")}else this.closeDescription=u.CLOSE_DESCRIPTIONS[this.closeReasonCode];this._debug("------ Remote peer %s - code: %d - %s - close frame payload length: %d",this.remoteAddress,this.closeReasonCode,this.closeDescription,e.length),this._debug("------ responding to remote peer's close request."),this.sendCloseFrame(n,null),this.connected=!1;break;default:this._debug("-- Unrecognized Opcode %d",e.opcode),this.drop(u.CLOSE_REASON_PROTOCOL_ERROR,"Unrecognized Opcode: 0x"+e.opcode.toString(16))}},u.prototype.send=function(e,a){if(this._debug("send"),Buffer.isBuffer(e))this.sendBytes(e,a);else{if("function"!=typeof e.toString)throw new Error("Data provided must either be a Node Buffer or implement toString()");this.sendUTF(e,a)}},u.prototype.sendUTF=function(e,a){e=new Buffer(e.toString(),"utf8"),this._debug("sendUTF: %d bytes",e.length);var t=new i(this.maskBytes,this.frameHeader,this.config);t.opcode=1,t.binaryPayload=e,this.fragmentAndSend(t,a)},u.prototype.sendBytes=function(e,a){if(this._debug("sendBytes"),!Buffer.isBuffer(e))throw new Error("You must pass a Node Buffer object to WebSocketConnection.prototype.sendBytes()");var t=new i(this.maskBytes,this.frameHeader,this.config);t.opcode=2,t.binaryPayload=e,this.fragmentAndSend(t,a)},u.prototype.ping=function(e){this._debug("ping");var a=new i(this.maskBytes,this.frameHeader,this.config);a.opcode=9,a.fin=!0,e&&(Buffer.isBuffer(e)||(e=new Buffer(e.toString(),"utf8")),e.length>125&&(this._debug("WebSocket: Data for ping is longer than 125 bytes.  Truncating."),e=e.slice(0,124)),a.binaryPayload=e),this.sendFrame(a)},u.prototype.pong=function(e){this._debug("pong");var a=new i(this.maskBytes,this.frameHeader,this.config);a.opcode=10,Buffer.isBuffer(e)&&e.length>125&&(this._debug("WebSocket: Data for pong is longer than 125 bytes.  Truncating."),e=e.slice(0,124)),a.binaryPayload=e,a.fin=!0,this.sendFrame(a)},u.prototype.fragmentAndSend=function(e,a){if(this._debug("fragmentAndSend"),e.opcode>7)throw new Error("You cannot fragment control frames.");var t=this.config.fragmentationThreshold,r=e.binaryPayload.length;if(!this.config.fragmentOutgoingMessages||e.binaryPayload&&r<=t)return e.fin=!0,void this.sendFrame(e,a);for(var c=Math.ceil(r/t),n=0,f=function(e){e?"function"==typeof a&&(a(e),a=null):++n===c&&"function"==typeof a&&a()},o=1;o<=c;o++){var d=new i(this.maskBytes,this.frameHeader,this.config);d.opcode=1===o?e.opcode:0,d.fin=o===c;var s=o===c?r-t*(o-1):t,b=t*(o-1);d.binaryPayload=e.binaryPayload.slice(b,b+s),this.sendFrame(d,f)}},u.prototype.sendCloseFrame=function(e,a,t){if("number"!=typeof e&&(e=u.CLOSE_REASON_NORMAL),this._debug("sendCloseFrame state: %s, reasonCode: %d, description: %s",this.state,e,a),this.state===d||"peer_requested_close"===this.state){var r=new i(this.maskBytes,this.frameHeader,this.config);r.fin=!0,r.opcode=8,r.closeStatus=e,"string"==typeof a&&(r.binaryPayload=new Buffer(a,"utf8")),this.sendFrame(r,t),this.socket.end()}},u.prototype.sendFrame=function(e,a){this._debug("sendFrame"),e.mask=this.maskOutgoingPackets;var t=this.socket.write(e.toBuffer(),a);return this.outputBufferFull=!t,t},e.exports=u},function(e,a,t){var r=t(19);function c(e,a,t,r,c,n,i){this.tx=e,this.block=a,this.logs=t,this.gasUsed=r,this.contractAddress=c,this.status=n,this.logsBloom=i,this.transactionIndex=0;for(var f=0;f<a.transactions.length;f++){if(a.transactions[f].hash().equals(e.hash())){this.transactionIndex=f;break}}}c.prototype.toJSON=function(){return null!=this.data?data:{transactionHash:r.rpcDataHexString(this.tx.hash()),transactionIndex:r.rpcQuantityHexString(this.transactionIndex),blockHash:r.rpcDataHexString(this.block.hash()),blockNumber:r.rpcQuantityHexString(this.block.header.number),gasUsed:r.rpcQuantityHexString(this.gasUsed),cumulativeGasUsed:r.rpcQuantityHexString(this.block.header.gasUsed),contractAddress:null!=this.contractAddress?r.rpcDataHexString(this.contractAddress):null,logs:this.logs.map(function(e){return e.toJSON()}),status:r.rpcQuantityHexString(this.status),logsBloom:r.rpcDataHexString(this.logsBloom)}},e.exports=c},function(e,a,t){var r=t(19);function c(e){var a=this;Object.keys(e).forEach(function(t){a[t]=e[t]})}c.prototype.toJSON=function(){return{logIndex:r.rpcQuantityHexString(this.logIndex),transactionIndex:r.rpcQuantityHexString(this.transactionIndex),transactionHash:r.rpcDataHexString(this.transactionHash),blockHash:r.rpcDataHexString(this.block.hash()),blockNumber:r.rpcQuantityHexString(this.block.header.number),address:r.rpcDataHexString(this.address),data:r.rpcDataHexString(this.data),topics:this.topics,type:"mined"}},e.exports=c},function(e,a){var t=Math.pow(2,30)-1;function r(e,a){if("string"!=typeof e&&!Buffer.isBuffer(e))throw new TypeError(a+" must be a buffer or string")}e.exports=function(e,a,c,n){if(r(e,"Password"),r(a,"Salt"),"number"!=typeof c)throw new TypeError("Iterations not a number");if(c<0)throw new TypeError("Bad iterations");if("number"!=typeof n)throw new TypeError("Key length not a number");if(n<0||n>t||n!=n)throw new TypeError("Bad key length")}},function(e,a,t){var r=t(169),c=t(10);c.pbkdf2Sync&&-1!==c.pbkdf2Sync.toString().indexOf("keylen, digest")?(a.pbkdf2Sync=function(e,a,t,n,i){return r(e,a,t,n),i=i||"sha1",c.pbkdf2Sync(e,a,t,n,i)},a.pbkdf2=function(e,a,t,n,i,f){if(r(e,a,t,n),"function"==typeof i&&(f=i,i="sha1"),"function"!=typeof f)throw new Error("No callback provided to pbkdf2");return c.pbkdf2(e,a,t,n,i,f)}):(a.pbkdf2Sync=t(329),a.pbkdf2=t(851))},function(e,a,t){var r=t(1).inherits,c=t(19),n=t(330);function i(e,a){Error.captureStackTrace(this,this.constructor),this.name=this.constructor.name,this.results={},this.hashes=[],this.combine(e,a)}r(i,Error),i.prototype.combine=function(e,a){if(e instanceof i)for(var t=e,r=Object.keys(t.results),f=0;f<r.length;f++){var o=r[f];this.results[o]=t.results[o],Array.prototype.push.apply(this.hashes,t.hashes)}else{var d=a.results;for(f=0;f<e.length;f++){var s=e[f],b=d[f];if(1!=b.vm.exception){var u=c.hex(s.hash());this.hashes.push(u);var l=void 0,p=b.vm.return;p&&"08c379a0"===p.slice(0,4).toString("hex")&&(l=n.rawDecode(["string"],p.slice(4))[0]),this.results[u]={error:b.vm.exceptionError.error||b.vm.exceptionError,program_counter:b.vm.runState.programCounter,return:c.hex(b.vm.return),reason:l}}}}if(1==this.hashes.length){var h="VM Exception while processing transaction: "+(m=this.results[this.hashes[0]]).error;m.reason&&(h+=" "+m.reason),this.message=h}else{for(h="Multiple VM Exceptions while processing transactions: \n\n",f=0;f<this.hashes.length;f++){var m;h+=(u=this.hashes[f])+": "+(m=this.results[u]).error,m.reason&&(h+=" "+m.reason),h+="\n"}this.message=h}},i.prototype.count=function(){return Object.keys(this.results).length},i.fromResults=function(e,a){var t=new i(e,a);return 0==t.count()?null:t},e.exports=i},function(e,a,t){const r=t(878);e.exports=r},function(e){e.exports={genesisGasLimit:{v:5e3,d:"Gas limit of the Genesis block."},genesisDifficulty:{v:17179869184,d:"Difficulty of the Genesis block."},genesisNonce:{v:"0x0000000000000042",d:"the geneis nonce"},genesisExtraData:{v:"0x11bbe8db4e347b4e8c937c1c8370e4b5ed33adb3db69cbdb7a38e1e50b1b82fa",d:"extra data "},genesisHash:{v:"0xd4e56740f876aef8c010b86a40d5f56745a118d0906a34e69aec8c0db1cb8fa3",d:"genesis hash"},genesisStateRoot:{v:"0xd7f8974fb5ac78d9ac099b9ad5018bedc2ce0a72dad1827a1709da30580f0544",d:"the genesis state root"},minGasLimit:{v:5e3,d:"Minimum the gas limit may ever be."},gasLimitBoundDivisor:{v:1024,d:"The bound divisor of the gas limit, used in update calculations."},minimumDifficulty:{v:131072,d:"The minimum that the difficulty may ever be."},difficultyBoundDivisor:{v:2048,d:"The bound divisor of the difficulty, used in the update calculations."},durationLimit:{v:13,d:"The decision boundary on the blocktime duration used to determine whether difficulty should go up or not."},maximumExtraDataSize:{v:32,d:"Maximum size extra data may be after Genesis."},epochDuration:{v:3e4,d:"Duration between proof-of-work epochs."},stackLimit:{v:1024,d:"Maximum size of VM stack allowed."},callCreateDepth:{v:1024,d:"Maximum depth of call/create stack."},tierStepGas:{v:[0,2,3,5,8,10,20],d:"Once per operation, for a selection of them."},expGas:{v:10,d:"Once per EXP instuction."},expByteGas:{v:50,d:"Times ceil(log256(exponent)) for the EXP instruction."},sha3Gas:{v:30,d:"Once per SHA3 operation."},sha3WordGas:{v:6,d:"Once per word of the SHA3 operation's data."},sloadGas:{v:50,d:"Once per SLOAD operation."},sstoreSetGas:{v:2e4,d:"Once per SSTORE operation if the zeroness changes from zero."},sstoreResetGas:{v:5e3,d:"Once per SSTORE operation if the zeroness does not change from zero."},sstoreRefundGas:{v:15e3,d:"Once per SSTORE operation if the zeroness changes to zero."},jumpdestGas:{v:1,d:"Refunded gas, once per SSTORE operation if the zeroness changes to zero."},logGas:{v:375,d:"Per LOG* operation."},logDataGas:{v:8,d:"Per byte in a LOG* operation's data."},logTopicGas:{v:375,d:"Multiplied by the * of the LOG*, per LOG transaction. e.g. LOG0 incurs 0 * c_txLogTopicGas, LOG4 incurs 4 * c_txLogTopicGas."},createGas:{v:32e3,d:"Once per CREATE operation & contract-creation transaction."},callGas:{v:40,d:"Once per CALL operation & message call transaction."},callStipend:{v:2300,d:"Free gas given at beginning of call."},callValueTransferGas:{v:9e3,d:"Paid for CALL when the value transfor is non-zero."},callNewAccountGas:{v:25e3,d:"Paid for CALL when the destination address didn't exist prior."},suicideRefundGas:{v:24e3,d:"Refunded following a suicide operation."},memoryGas:{v:3,d:"Times the address of the (highest referenced byte in memory + 1). NOTE: referencing happens on read, write and in instructions such as RETURN and CALL."},quadCoeffDiv:{v:512,d:"Divisor for the quadratic particle of the memory cost equation."},createDataGas:{v:200,d:""},txGas:{v:21e3,d:"Per transaction. NOTE: Not payable on data of calls between transactions."},txCreation:{v:32e3,d:"the cost of creating a contract via tx"},txDataZeroGas:{v:4,d:"Per byte of data attached to a transaction that equals zero. NOTE: Not payable on data of calls between transactions."},txDataNonZeroGas:{v:68,d:"Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions."},copyGas:{v:3,d:"Multiplied by the number of 32-byte words that are copied (round up) for any *COPY operation and added."},ecrecoverGas:{v:3e3,d:""},sha256Gas:{v:60,d:""},sha256WordGas:{v:12,d:""},ripemd160Gas:{v:600,d:""},ripemd160WordGas:{v:120,d:""},identityGas:{v:15,d:""},identityWordGas:{v:3,d:""},modexpGquaddivisor:{v:20,d:"Gquaddivisor from modexp precompile for gas calculation."},ecAddGas:{v:500,d:"Gas costs for curve addition precompile."},ecMulGas:{v:4e4,d:"Gas costs for curve multiplication precompile."},ecPairingGas:{v:1e5,d:"Base gas costs for curve pairing precompile."},ecPairingWordGas:{v:8e4,d:"Gas costs regarding curve pairing precompile input length."},minerReward:{v:"3000000000000000000",d:"the amount a miner get rewarded for mining a block"},homeSteadForkNumber:{v:115e4,d:"the block that the Homestead fork started at"},homesteadRepriceForkNumber:{v:2463e3,d:"the block that the Homestead Reprice (EIP150) fork started at"},timebombPeriod:{v:1e5,d:"Exponential difficulty timebomb period"},freeBlockPeriod:{v:2}}},function(e,a,t){"use strict";var r=t(7).Buffer,c=t(1),n=t(3),i=t(893),f=t(45),o=t(886),d=n.BN,s=t(884),b=t(883),u=t(882),l=t(881),p=t(880),h=t(879),m=t(877),g=t(876);function v(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(this.opts=e,e.stateManager?this.stateManager=e.stateManager:this.stateManager=new i({trie:e.state,blockchain:e.blockchain}),this.allowUnlimitedContractSize=void 0!==e.allowUnlimitedContractSize&&e.allowUnlimitedContractSize,this.blockchain=this.stateManager.blockchain,this.trie=this.stateManager.trie,this._precompiled={},this._precompiled["0000000000000000000000000000000000000001"]=s,this._precompiled["0000000000000000000000000000000000000002"]=b,this._precompiled["0000000000000000000000000000000000000003"]=u,this._precompiled["0000000000000000000000000000000000000004"]=l,this._precompiled["0000000000000000000000000000000000000005"]=p,this._precompiled["0000000000000000000000000000000000000006"]=h,this._precompiled["0000000000000000000000000000000000000007"]=m,this._precompiled["0000000000000000000000000000000000000008"]=g,this.opts.activatePrecompiles)for(var a=1;a<=7;a++)this.trie.put(new d(a).toArrayLike(r,"be",20),(new f).serialize());o.call(this)}e.exports=v,v.deps={ethUtil:n,Account:t(45),Trie:t(44),rlp:t(3).rlp},c.inherits(v,o),v.prototype.runCode=t(875),v.prototype.runJIT=t(869),v.prototype.runBlock=t(867),v.prototype.runTx=t(866),v.prototype.runCall=t(865),v.prototype.runBlockchain=t(864),v.prototype.copy=function(){return new v({stateManager:this.stateManager.copy()})},v.prototype.loadCompiled=function(e,a,t){this.trie.db.put(e,a,t)},v.prototype.populateCache=function(e,a){this.stateManager.warmCache(e,a)}},function(e,a,t){e.exports=f;var r=Object.keys||function(e){var a=[];for(var t in e)a.push(t);return a},c=t(17);c.inherits=t(0);var n=t(336),i=t(335);function f(e){if(!(this instanceof f))return new f(e);n.call(this,e),i.call(this,e),e&&!1===e.readable&&(this.readable=!1),e&&!1===e.writable&&(this.writable=!1),this.allowHalfOpen=!0,e&&!1===e.allowHalfOpen&&(this.allowHalfOpen=!1),this.once("end",o)}function o(){this.allowHalfOpen||this._writableState.ended||process.nextTick(this.end.bind(this))}c.inherits(f,n),function(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}(r(i.prototype),function(e){f.prototype[e]||(f.prototype[e]=i.prototype[e])})},function(e,a,t){const r=t(52),c=t(3);function n(e,a,t){if(Array.isArray(e))this.parseNode(e);else if(this.type=e,"branch"===e){var r=a;this.raw=Array.apply(null,Array(17)),r&&r.forEach(function(e){this.set.apply(this,e)})}else this.raw=Array(2),this.setValue(t),this.setKey(a)}function i(e,a){return e.length%2?e.unshift(1):(e.unshift(0),e.unshift(0)),a&&(e[0]+=2),e}function f(e){return e=e[0]%2?e.slice(1):e.slice(2)}function o(e){return e[0]>1}function d(e){for(var a=new Buffer(e),t=[],r=0;r<a.length;r++){var c=2*r;t[c]=a[r]>>4,t[++c]=a[r]%16}return t}function s(e){for(var a=new Buffer(e.length/2),t=0;t<a.length;t++){var r=2*t;a[t]=(e[r]<<4)+e[++r]}return a}function b(e){return 17===e.length?"branch":2===e.length?o(d(e[0]))?"leaf":"extention":void 0}e.exports=n,n.isRawNode=function(e){return Array.isArray(e)&&!Buffer.isBuffer(e)},n.addHexPrefix=i,n.removeHexPrefix=f,n.isTerminator=o,n.stringToNibbles=d,n.nibblesToBuffer=s,n.getNodeType=b,Object.defineProperty(n.prototype,"value",{get:function(){return this.getValue()},set:function(e){this.setValue(e)}}),Object.defineProperty(n.prototype,"key",{get:function(){return this.getKey()},set:function(e){this.setKey(e)}}),n.prototype.parseNode=function(e){this.raw=e,this.type=b(e)},n.prototype.setValue=function(e,a){"branch"!==this.type?this.raw[1]=e:(1===arguments.length&&(a=e,e=16),this.raw[e]=a)},n.prototype.getValue=function(e){if("branch"!==this.type)return this.raw[1];0===arguments.length&&(e=16);var a=this.raw[e];return null!==a&&void 0!==a&&0!==a.length?a:void 0},n.prototype.setKey=function(e){"branch"!==this.type&&(e=i(e=Buffer.isBuffer(e)?d(e):e.slice(0),"leaf"===this.type),this.raw[0]=s(e))},n.prototype.getKey=function(){if("branch"!==this.type){var e=this.raw[0];return e=f(d(e))}},n.prototype.serialize=function(){return r.encode(this.raw)},n.prototype.hash=function(){return c.sha3(this.serialize())},n.prototype.toString=function(){var e=this.type;return e+=": [",this.raw.forEach(function(a){Buffer.isBuffer(a)?e+=a.toString("hex")+", ":e+=a?"object, ":"empty, "}),e=e.slice(0,-2),e+="]"},n.prototype.getChildren=function(){var e=[];switch(this.type){case"leaf":break;case"extention":e.push([this.key,this.getValue()]);break;case"branch":for(var a=0;a<16;a++){var t=this.getValue(a);t&&e.push([[a],t])}}return e}},function(e,a,t){var r;
/*!
 * async
 * https://github.com/caolan/async
 *
 * Copyright 2010-2014 Caolan McMahon
 * Released under the MIT license
 */
/*!
 * async
 * https://github.com/caolan/async
 *
 * Copyright 2010-2014 Caolan McMahon
 * Released under the MIT license
 */
!function(){var t,c={};function n(){}function i(e){return e}function f(e){return!!e}function o(e){return!e}var d="object"==typeof self&&self.self===self&&self||"object"==typeof global&&global.global===global&&global||this;function s(e){return function(){if(null===e)throw new Error("Callback was already called.");e.apply(this,arguments),e=null}}function b(e){return function(){null!==e&&(e.apply(this,arguments),e=null)}}null!=d&&(t=d.async),c.noConflict=function(){return d.async=t,c};var u=Object.prototype.toString,l=Array.isArray||function(e){return"[object Array]"===u.call(e)};function p(e){return l(e)||"number"==typeof e.length&&e.length>=0&&e.length%1==0}function h(e,a){for(var t=-1,r=e.length;++t<r;)a(e[t],t,e)}function m(e,a){for(var t=-1,r=e.length,c=Array(r);++t<r;)c[t]=a(e[t],t,e);return c}function g(e){return m(Array(e),function(e,a){return a})}function v(e,a){for(var t=0;t<e.length;t++)if(e[t]===a)return t;return-1}var y=Object.keys||function(e){var a=[];for(var t in e)e.hasOwnProperty(t)&&a.push(t);return a};function _(e){var a,t,r=-1;return p(e)?(a=e.length,function(){return++r<a?r:null}):(t=y(e),a=t.length,function(){return++r<a?t[r]:null})}function w(e,a){return a=null==a?e.length-1:+a,function(){for(var t=Math.max(arguments.length-a,0),r=Array(t),c=0;c<t;c++)r[c]=arguments[c+a];switch(a){case 0:return e.call(this,r);case 1:return e.call(this,arguments[0],r)}}}function A(e){return function(a,t,r){return e(a,r)}}var k="function"==typeof setImmediate&&setImmediate,x=k?function(e){k(e)}:function(e){setTimeout(e,0)};function E(e){return function(a,t,r){r=b(r||n);var c=_(a=a||[]);if(e<=0)return r(null);var i=!1,f=0,o=!1;!function n(){if(i&&f<=0)return r(null);for(;f<e&&!o;){var d=c();if(null===d)return i=!0,void(f<=0&&r(null));f+=1,t(a[d],d,s(function(e){f-=1,e?(r(e),o=!0):n()}))}}()}}function S(e){return function(a,t,r){return e(c.eachOf,a,t,r)}}function T(e){return function(a,t,r,c){return e(E(t),a,r,c)}}function j(e){return function(a,t,r){return e(c.eachOfSeries,a,t,r)}}function C(e,a,t,r){r=b(r||n);var c=p(a=a||[])?[]:{};e(a,function(e,a,r){t(e,function(e,t){c[a]=t,r(e)})},function(e){r(e,c)})}function R(e,a,t,r){var c=[];e(a,function(e,a,r){t(e,function(t){t&&c.push({index:a,value:e}),r()})},function(){r(m(c.sort(function(e,a){return e.index-a.index}),function(e){return e.value}))})}function O(e,a,t,r){R(e,a,function(e,a){t(e,function(e){a(!e)})},r)}function B(e,a,t){return function(r,c,n,i){function f(){i&&i(t(!1,void 0))}function o(e,r,c){if(!i)return c();n(e,function(r){i&&a(r)&&(i(t(!0,e)),i=n=!1),c()})}arguments.length>3?e(r,c,o,f):(i=n,n=c,e(r,o,f))}}function M(e,a){return a}function N(e,a,t){t=t||n;var r=p(a)?[]:{};e(a,function(e,a,t){e(w(function(e,c){c.length<=1&&(c=c[0]),r[a]=c,t(e)}))},function(e){t(e,r)})}function I(e,a,t,r){var c=[];e(a,function(e,a,r){t(e,function(e,a){c=c.concat(a||[]),r(e)})},function(e){r(e,c)})}function P(e,a,t){if(null==a)a=1;else if(0===a)throw new Error("Concurrency must not be zero");function r(e,a,t,r){if(null!=r&&"function"!=typeof r)throw new Error("task callback must be a function");if(e.started=!0,l(a)||(a=[a]),0===a.length&&e.idle())return c.setImmediate(function(){e.drain()});h(a,function(a){var c={data:a,callback:r||n};t?e.tasks.unshift(c):e.tasks.push(c),e.tasks.length===e.concurrency&&e.saturated()}),c.setImmediate(e.process)}function i(e,a){return function(){f-=1;var t=!1,r=arguments;h(a,function(e){h(o,function(a,r){a!==e||t||(o.splice(r,1),t=!0)}),e.callback.apply(e,r)}),e.tasks.length+f===0&&e.drain(),e.process()}}var f=0,o=[],d={tasks:[],concurrency:a,payload:t,saturated:n,empty:n,drain:n,started:!1,paused:!1,push:function(e,a){r(d,e,!1,a)},kill:function(){d.drain=n,d.tasks=[]},unshift:function(e,a){r(d,e,!0,a)},process:function(){for(;!d.paused&&f<d.concurrency&&d.tasks.length;){var a=d.payload?d.tasks.splice(0,d.payload):d.tasks.splice(0,d.tasks.length),t=m(a,function(e){return e.data});0===d.tasks.length&&d.empty(),f+=1,o.push(a[0]);var r=s(i(d,a));e(t,r)}},length:function(){return d.tasks.length},running:function(){return f},workersList:function(){return o},idle:function(){return d.tasks.length+f===0},pause:function(){d.paused=!0},resume:function(){if(!1!==d.paused){d.paused=!1;for(var e=Math.min(d.concurrency,d.tasks.length),a=1;a<=e;a++)c.setImmediate(d.process)}}};return d}function F(e){return w(function(a,t){a.apply(null,t.concat([w(function(a,t){"object"==typeof console&&(a?console.error&&console.error(a):console[e]&&h(t,function(a){console[e](a)}))})]))})}function L(e){return function(a,t,r){e(g(a),t,r)}}function D(e){return w(function(a,t){var r=w(function(t){var r=this,c=t.pop();return e(a,function(e,a,c){e.apply(r,t.concat([c]))},c)});return t.length?r.apply(this,t):r})}function z(e){return w(function(a){var t=a.pop();a.push(function(){var e=arguments;r?c.setImmediate(function(){t.apply(null,e)}):t.apply(null,e)});var r=!0;e.apply(this,a),r=!1})}"object"==typeof process&&"function"==typeof process.nextTick?c.nextTick=process.nextTick:c.nextTick=x,c.setImmediate=k?x:c.nextTick,c.forEach=c.each=function(e,a,t){return c.eachOf(e,A(a),t)},c.forEachSeries=c.eachSeries=function(e,a,t){return c.eachOfSeries(e,A(a),t)},c.forEachLimit=c.eachLimit=function(e,a,t,r){return E(a)(e,A(t),r)},c.forEachOf=c.eachOf=function(e,a,t){t=b(t||n);for(var r,c=_(e=e||[]),i=0;null!=(r=c());)i+=1,a(e[r],r,s(f));function f(e){i--,e?t(e):null===r&&i<=0&&t(null)}0===i&&t(null)},c.forEachOfSeries=c.eachOfSeries=function(e,a,t){t=b(t||n);var r=_(e=e||[]),i=r();!function n(){var f=!0;if(null===i)return t(null);a(e[i],i,s(function(e){if(e)t(e);else{if(null===(i=r()))return t(null);f?c.setImmediate(n):n()}})),f=!1}()},c.forEachOfLimit=c.eachOfLimit=function(e,a,t,r){E(a)(e,t,r)},c.map=S(C),c.mapSeries=j(C),c.mapLimit=T(C),c.inject=c.foldl=c.reduce=function(e,a,t,r){c.eachOfSeries(e,function(e,r,c){t(a,e,function(e,t){a=t,c(e)})},function(e){r(e,a)})},c.foldr=c.reduceRight=function(e,a,t,r){var n=m(e,i).reverse();c.reduce(n,a,t,r)},c.transform=function(e,a,t,r){3===arguments.length&&(r=t,t=a,a=l(e)?[]:{}),c.eachOf(e,function(e,r,c){t(a,e,r,c)},function(e){r(e,a)})},c.select=c.filter=S(R),c.selectLimit=c.filterLimit=T(R),c.selectSeries=c.filterSeries=j(R),c.reject=S(O),c.rejectLimit=T(O),c.rejectSeries=j(O),c.any=c.some=B(c.eachOf,f,i),c.someLimit=B(c.eachOfLimit,f,i),c.all=c.every=B(c.eachOf,o,o),c.everyLimit=B(c.eachOfLimit,o,o),c.detect=B(c.eachOf,i,M),c.detectSeries=B(c.eachOfSeries,i,M),c.detectLimit=B(c.eachOfLimit,i,M),c.sortBy=function(e,a,t){function r(e,a){var t=e.criteria,r=a.criteria;return t<r?-1:t>r?1:0}c.map(e,function(e,t){a(e,function(a,r){a?t(a):t(null,{value:e,criteria:r})})},function(e,a){if(e)return t(e);t(null,m(a.sort(r),function(e){return e.value}))})},c.auto=function(e,a,t){"function"==typeof arguments[1]&&(t=a,a=null),t=b(t||n);var r=y(e),i=r.length;if(!i)return t(null);a||(a=i);var f={},o=0,d=!1,s=[];function u(e){s.unshift(e)}function p(){i--,h(s.slice(0),function(e){e()})}u(function(){i||t(null,f)}),h(r,function(r){if(!d){for(var n,i=l(e[r])?e[r]:[e[r]],b=w(function(e,a){if(o--,a.length<=1&&(a=a[0]),e){var n={};!function(e,a){h(y(e),function(t){a(e[t],t)})}(f,function(e,a){n[a]=e}),n[r]=a,d=!0,t(e,n)}else f[r]=a,c.setImmediate(p)}),m=i.slice(0,i.length-1),g=m.length;g--;){if(!(n=e[m[g]]))throw new Error("Has nonexistent dependency in "+m.join(", "));if(l(n)&&v(n,r)>=0)throw new Error("Has cyclic dependencies")}_()?(o++,i[i.length-1](b,f)):u(function e(){_()&&(o++,function(e){var a=v(s,e);a>=0&&s.splice(a,1)}(e),i[i.length-1](b,f))})}function _(){return o<a&&function(e,a,t){return h(e,function(e,r,c){t=a(t,e,r,c)}),t}(m,function(e,a){return e&&f.hasOwnProperty(a)},!0)&&!f.hasOwnProperty(r)}})},c.retry=function(e,a,t){var r=5,n=0,i=[],f={times:r,interval:n};var o=arguments.length;if(o<1||o>3)throw new Error("Invalid arguments - must be either (task), (task, callback), (times, task) or (times, task, callback)");function d(e,a){function t(e,t){return function(r){e(function(e,a){r(!e||t,{err:e,result:a})},a)}}function r(e){return function(a){setTimeout(function(){a(null)},e)}}for(;f.times;){var n=!(f.times-=1);i.push(t(f.task,n)),!n&&f.interval>0&&i.push(r(f.interval))}c.series(i,function(a,t){t=t[t.length-1],(e||f.callback)(t.err,t.result)})}return o<=2&&"function"==typeof e&&(t=a,a=e),"function"!=typeof e&&function(e,a){if("number"==typeof a)e.times=parseInt(a,10)||r;else{if("object"!=typeof a)throw new Error("Unsupported argument type for 'times': "+typeof a);e.times=parseInt(a.times,10)||r,e.interval=parseInt(a.interval,10)||n}}(f,e),f.callback=t,f.task=a,f.callback?d():d},c.waterfall=function(e,a){if(a=b(a||n),!l(e)){var t=new Error("First argument to waterfall must be an array of functions");return a(t)}if(!e.length)return a();!function e(t){return w(function(r,c){if(r)a.apply(null,[r].concat(c));else{var n=t.next();n?c.push(e(n)):c.push(a),z(t).apply(null,c)}})}(c.iterator(e))()},c.parallel=function(e,a){N(c.eachOf,e,a)},c.parallelLimit=function(e,a,t){N(E(a),e,t)},c.series=function(e,a){N(c.eachOfSeries,e,a)},c.iterator=function(e){return function a(t){function r(){return e.length&&e[t].apply(null,arguments),r.next()}return r.next=function(){return t<e.length-1?a(t+1):null},r}(0)},c.apply=w(function(e,a){return w(function(t){return e.apply(null,a.concat(t))})}),c.concat=S(I),c.concatSeries=j(I),c.whilst=function(e,a,t){if(t=t||n,e()){var r=w(function(c,n){c?t(c):e.apply(this,n)?a(r):t.apply(null,[null].concat(n))});a(r)}else t(null)},c.doWhilst=function(e,a,t){var r=0;return c.whilst(function(){return++r<=1||a.apply(this,arguments)},e,t)},c.until=function(e,a,t){return c.whilst(function(){return!e.apply(this,arguments)},a,t)},c.doUntil=function(e,a,t){return c.doWhilst(e,function(){return!a.apply(this,arguments)},t)},c.during=function(e,a,t){t=t||n;var r=w(function(a,r){a?t(a):(r.push(c),e.apply(this,r))}),c=function(e,c){e?t(e):c?a(r):t(null)};e(c)},c.doDuring=function(e,a,t){var r=0;c.during(function(e){r++<1?e(null,!0):a.apply(this,arguments)},e,t)},c.queue=function(e,a){return P(function(a,t){e(a[0],t)},a,1)},c.priorityQueue=function(e,a){function t(e,a){return e.priority-a.priority}var r=c.queue(e,a);return r.push=function(e,a,i){!function(e,a,r,i){if(null!=i&&"function"!=typeof i)throw new Error("task callback must be a function");if(e.started=!0,l(a)||(a=[a]),0===a.length)return c.setImmediate(function(){e.drain()});h(a,function(a){var f={data:a,priority:r,callback:"function"==typeof i?i:n};e.tasks.splice(function(e,a,t){for(var r=-1,c=e.length-1;r<c;){var n=r+(c-r+1>>>1);t(a,e[n])>=0?r=n:c=n-1}return r}(e.tasks,f,t)+1,0,f),e.tasks.length===e.concurrency&&e.saturated(),c.setImmediate(e.process)})}(r,e,a,i)},delete r.unshift,r},c.cargo=function(e,a){return P(e,1,a)},c.log=F("log"),c.dir=F("dir"),c.memoize=function(e,a){var t={},r={},n=Object.prototype.hasOwnProperty;a=a||i;var f=w(function(i){var f=i.pop(),o=a.apply(null,i);n.call(t,o)?c.setImmediate(function(){f.apply(null,t[o])}):n.call(r,o)?r[o].push(f):(r[o]=[f],e.apply(null,i.concat([w(function(e){t[o]=e;var a=r[o];delete r[o];for(var c=0,n=a.length;c<n;c++)a[c].apply(null,e)})])))});return f.memo=t,f.unmemoized=e,f},c.unmemoize=function(e){return function(){return(e.unmemoized||e).apply(null,arguments)}},c.times=L(c.map),c.timesSeries=L(c.mapSeries),c.timesLimit=function(e,a,t,r){return c.mapLimit(g(e),a,t,r)},c.seq=function(){var e=arguments;return w(function(a){var t=this,r=a[a.length-1];"function"==typeof r?a.pop():r=n,c.reduce(e,a,function(e,a,r){a.apply(t,e.concat([w(function(e,a){r(e,a)})]))},function(e,a){r.apply(t,[e].concat(a))})})},c.compose=function(){return c.seq.apply(null,Array.prototype.reverse.call(arguments))},c.applyEach=D(c.eachOf),c.applyEachSeries=D(c.eachOfSeries),c.forever=function(e,a){var t=s(a||n),r=z(e);!function e(a){if(a)return t(a);r(e)}()},c.ensureAsync=z,c.constant=w(function(e){var a=[null].concat(e);return function(e){return e.apply(this,a)}}),c.wrapSync=c.asyncify=function(e){return w(function(a){var t,r=a.pop();try{t=e.apply(this,a)}catch(e){return r(e)}!function(e){var a=typeof e;return"function"===a||"object"===a&&!!e}(t)||"function"!=typeof t.then?r(null,t):t.then(function(e){r(null,e)}).catch(function(e){r(e.message?e:new Error(e))})})},"object"==typeof e&&e.exports?e.exports=c:void 0===(r=function(){return c}.apply(a,[]))||(e.exports=r)}()},function(e,a){e.exports=Array.isArray||function(e){return"[object Array]"==Object.prototype.toString.call(e)}},function(e,a,t){var r=t(5).EventEmitter,c=t(1).inherits,n=t(1).deprecate,i=t(39),f=t(359),o=t(932),d=t(929),s=t(925),b=t(924),u=t(922),l=t(86),p=t(350),h=l.WriteError,m=l.ReadError,g=l.NotFoundError,v=l.OpenError,y=l.EncodingError,_=l.InitializationError,w=l.LevelUPError,A=p.getOptions,k=p.defaultOptions,x=p.dispatchError;function E(e,a){return"function"==typeof e?e:a}function S(e,a,t){if(!(this instanceof S))return new S(e,a,t);var c;if(r.call(this),this.setMaxListeners(1/0),"function"==typeof e?((a="object"==typeof a?a:{}).db=e,e=null):"object"==typeof e&&"function"==typeof e.db&&(a=e,e=null),"function"==typeof a&&(t=a,a={}),(!a||"function"!=typeof a.db)&&"string"!=typeof e){if(c=new _("Must provide a location for the database"),t)return process.nextTick(function(){t(c)});throw c}a=A(a),this.options=i(k,a),this._codec=new b(this.options),this._status="new",f(this,"location",e,"e"),this.open(t)}function T(e,a,t){if(!e._isOpening()&&!e.isOpen())return x(e,new m("Database is not open"),t),!0}function j(e,a,t){x(e,new h(a),t)}function C(e,a,t){x(e,new m(a),t)}function R(e){return function(a,t){u()[e](a,t||function(){})}}c(S,r),S.prototype.open=function(e){var a,t,r=this;if(this.isOpen())return e&&process.nextTick(function(){e(null,r)}),this;if(this._isOpening())return e&&this.once("open",function(){e(null,r)});if(this.emit("opening"),this._status="opening",this.db=new o(this.location),"function"!=typeof this.options.db&&"function"!=typeof u)throw new w("missing db factory, you need to set options.db");a=this.options.db||u(),(t=a(this.location)).open(this.options,function(a){if(a)return x(r,new v(a),e);r.db.setDb(t),r.db=t,r._status="open",e&&e(null,r),r.emit("open"),r.emit("ready")})},S.prototype.close=function(e){var a=this;if(this.isOpen())this._status="closing",this.db.close(function(){a._status="closed",a.emit("closed"),e&&e.apply(null,arguments)}),this.emit("closing"),this.db=new o(this.location);else{if("closed"===this._status&&e)return process.nextTick(e);"closing"===this._status&&e?this.once("closed",e):this._isOpening()&&this.once("open",function(){a.close(e)})}},S.prototype.isOpen=function(){return"open"===this._status},S.prototype._isOpening=function(){return"opening"===this._status},S.prototype.isClosed=function(){return/^clos/.test(this._status)},S.prototype.get=function(e,a,t){var r,c=this;if(!T(this,0,t=E(a,t))){if(null===e||void 0===e||"function"!=typeof t)return C(this,"get() requires key and callback arguments",t);a=p.getOptions(a),r=this._codec.encodeKey(e,a),a.asBuffer=this._codec.valueAsBuffer(a),this.db.get(r,a,function(r,n){if(r)return r=/notfound/i.test(r)||r.notFound?new g("Key not found in database ["+e+"]",r):new m(r),x(c,r,t);if(t){try{n=c._codec.decodeValue(n,a)}catch(e){return t(new y(e))}t(null,n)}})}},S.prototype.put=function(e,a,t,r){var c,n,i=this;if(r=E(t,r),null===e||void 0===e)return j(this,"put() requires a key argument",r);T(this,0,r)||(t=A(t),c=this._codec.encodeKey(e,t),n=this._codec.encodeValue(a,t),this.db.put(c,n,t,function(t){if(t)return x(i,new h(t),r);i.emit("put",e,a),r&&r()}))},S.prototype.del=function(e,a,t){var r,c=this;if(t=E(a,t),null===e||void 0===e)return j(this,"del() requires a key argument",t);T(this,0,t)||(a=A(a),r=this._codec.encodeKey(e,a),this.db.del(r,a,function(a){if(a)return x(c,new h(a),t);c.emit("del",e),t&&t()}))},S.prototype.batch=function(e,a,t){var r,c=this;return arguments.length?(t=E(a,t),Array.isArray(e)?void(T(this,0,t)||(a=A(a),r=(r=c._codec.encodeBatch(e,a)).map(function(e){return e.type||void 0===e.key||void 0===e.value||(e.type="put"),e}),this.db.batch(r,a,function(a){if(a)return x(c,new h(a),t);c.emit("batch",e),t&&t()}))):j(this,"batch() requires an array argument",t)):new s(this,this._codec)},S.prototype.approximateSize=n(function(e,a,t,r){var c,n,i=this;if(r=E(t,r),t=A(t),null===e||void 0===e||null===a||void 0===a||"function"!=typeof r)return C(this,"approximateSize() requires start, end and callback arguments",r);c=this._codec.encodeKey(e,t),n=this._codec.encodeKey(a,t),this.db.approximateSize(c,n,function(e,a){if(e)return x(i,new v(e),r);r&&r(null,a)})},"db.approximateSize() is deprecated. Use db.db.approximateSize() instead"),S.prototype.readStream=S.prototype.createReadStream=function(e){return(e=i({keys:!0,values:!0},this.options,e)).keyEncoding=e.keyEncoding,e.valueEncoding=e.valueEncoding,(e=this._codec.encodeLtgt(e)).keyAsBuffer=this._codec.keyAsBuffer(e),e.valueAsBuffer=this._codec.valueAsBuffer(e),"number"!=typeof e.limit&&(e.limit=-1),new d(this.db.iterator(e),i(e,{decoder:this._codec.createStreamDecoder(e)}))},S.prototype.keyStream=S.prototype.createKeyStream=function(e){return this.createReadStream(i(e,{keys:!0,values:!1}))},S.prototype.valueStream=S.prototype.createValueStream=function(e){return this.createReadStream(i(e,{keys:!1,values:!0}))},S.prototype.toString=function(){return"LevelUP"},e.exports=S,e.exports.errors=t(86),e.exports.destroy=n(R("destroy"),"levelup.destroy() is deprecated. Use leveldown.destroy() instead"),e.exports.repair=n(R("repair"),"levelup.repair() is deprecated. Use leveldown.repair() instead")},function(e,a,t){try{e.exports=t(!function(){var e=new Error("Cannot find module 'sha3'");throw e.code="MODULE_NOT_FOUND",e}()).SHA3Hash}catch(a){e.exports=t(936)}},function(e,a){e.exports=function(e){return null!=e&&"object"==typeof e}},function(e,a){e.exports=function(){}},function(e,a,t){var r=t(376),c=t(979),n=t(978),i="[object Null]",f="[object Undefined]",o=r?r.toStringTag:void 0;e.exports=function(e){return null==e?void 0===e?f:i:o&&o in Object(e)?c(e):n(e)}},function(e,a,t){var r=t(980),c=t(372);e.exports=function(e){return null!=e&&c(e.length)&&!r(e)}},function(e,a,t){var r=a;r.utils=t(37),r.common=t(90),r.sha=t(1002),r.ripemd=t(998),r.hmac=t(997),r.sha1=r.sha.sha1,r.sha256=r.sha.sha256,r.sha224=r.sha.sha224,r.sha384=r.sha.sha384,r.sha512=r.sha.sha512,r.ripemd160=r.ripemd.ripemd160},function(e,a,t){var r=t(65),c=r.extend,n=t(1),i=t(5).EventEmitter,f=t(43),o=t(59),d=t(32),s=t(10),b=t(120),u=["(",")","<",">","@",",",";",":","\\",'"',"/","[","]","?","=","{","}"," ",String.fromCharCode(9)];function l(e){var a;(i.call(this),this.config={maxReceivedFrameSize:1048576,maxReceivedMessageSize:8388608,fragmentOutgoingMessages:!0,fragmentationThreshold:16384,webSocketVersion:13,assembleFragments:!0,disableNagleAlgorithm:!0,closeTimeout:5e3,tlsOptions:{}},e)&&(e.tlsOptions?(a=e.tlsOptions,delete e.tlsOptions):a={},c(this.config,e),c(this.config.tlsOptions,a));switch(this._req=null,this.config.webSocketVersion){case 8:case 13:break;default:throw new Error("Requested webSocketVersion is not supported. Allowed values are 8 and 13.")}}n.inherits(l,i),l.prototype.connect=function(e,a,t,n,i){var s=this;if("string"==typeof a&&(a=a.length>0?[a]:[]),a instanceof Array||(a=[]),this.protocols=a,this.origin=t,this.url="string"==typeof e?d.parse(e):e,!this.url.protocol)throw new Error("You must specify a full WebSocket URL, including protocol.");if(!this.url.host)throw new Error("You must specify a full WebSocket URL, including hostname. Relative URLs are not supported.");this.secure="wss:"===this.url.protocol,this.protocols.forEach(function(e){for(var a=0;a<e.length;a++){var t=e.charCodeAt(a),r=e.charAt(a);if(t<33||t>126||-1!==u.indexOf(r))throw new Error('Protocol list contains invalid character "'+String.fromCharCode(t)+'"')}});this.url.port||(this.url.port={"ws:":"80","wss:":"443"}[this.url.protocol]);for(var b=new Buffer(16),l=0;l<16;l++)b[l]=Math.round(255*Math.random());this.base64nonce=b.toString("base64");var p=this.url.hostname;("ws:"===this.url.protocol&&"80"!==this.url.port||"wss:"===this.url.protocol&&"443"!==this.url.port)&&(p+=":"+this.url.port);var h,m=n||{};function g(e){s._req=null,s.emit("connectFailed",e)}c(m,{Upgrade:"websocket",Connection:"Upgrade","Sec-WebSocket-Version":this.config.webSocketVersion.toString(10),"Sec-WebSocket-Key":this.base64nonce,Host:m.Host||p}),this.protocols.length>0&&(m["Sec-WebSocket-Protocol"]=this.protocols.join(", ")),this.origin&&(13===this.config.webSocketVersion?m.Origin=this.origin:8===this.config.webSocketVersion&&(m["Sec-WebSocket-Origin"]=this.origin)),h=this.url.pathname?this.url.path:this.url.path?"/"+this.url.path:"/";var v={agent:!1};if(i&&c(v,i),c(v,{hostname:this.url.hostname,port:this.url.port,method:"GET",path:h,headers:m}),this.secure)for(var y in s.config.tlsOptions)s.config.tlsOptions.hasOwnProperty(y)&&(v[y]=s.config.tlsOptions[y]);var _=this._req=(this.secure?o:f).request(v);_.on("upgrade",function(e,a,t){s._req=null,_.removeListener("error",g),s.socket=a,s.response=e,s.firstDataChunk=t,s.validateHandshake()}),_.on("error",g),_.on("response",function(e){if(s._req=null,r.eventEmitterListenerCount(s,"httpResponse")>0)s.emit("httpResponse",e,s),e.socket&&e.socket.end();else{var a=[];for(var t in e.headers)a.push(t+": "+e.headers[t]);s.failHandshake("Server responded with a non-101 status: "+e.statusCode+" "+e.statusMessage+"\nResponse Headers Follow:\n"+a.join("\n")+"\n")}}),_.end()},l.prototype.validateHandshake=function(){var e=this.response.headers;if(this.protocols.length>0){if(this.protocol=e["sec-websocket-protocol"],!this.protocol)return void this.failHandshake("Expected a Sec-WebSocket-Protocol header.");if(-1===this.protocols.indexOf(this.protocol))return void this.failHandshake("Server did not respond with a requested protocol.")}if(e.connection&&"upgrade"===e.connection.toLocaleLowerCase())if(e.upgrade&&"websocket"===e.upgrade.toLocaleLowerCase()){var a=s.createHash("sha1");a.update(this.base64nonce+"258EAFA5-E914-47DA-95CA-C5AB0DC85B11");var t=a.digest("base64");e["sec-websocket-accept"]?e["sec-websocket-accept"]===t?this.succeedHandshake():this.failHandshake("Sec-WebSocket-Accept header from server didn't match expected value of "+t):this.failHandshake("Expected Sec-WebSocket-Accept header from server")}else this.failHandshake("Expected an Upgrade: websocket header from the server");else this.failHandshake("Expected a Connection: Upgrade header from the server")},l.prototype.failHandshake=function(e){this.socket&&this.socket.writable&&this.socket.end(),this.emit("connectFailed",new Error(e))},l.prototype.succeedHandshake=function(){var e=new b(this.socket,[],this.protocol,!0,this.config);e.webSocketVersion=this.config.webSocketVersion,e._addSocketEventListeners(),this.emit("connect",e),this.firstDataChunk.length>0&&e.handleSocketData(this.firstDataChunk),this.firstDataChunk=null},l.prototype.abort=function(){this._req&&this._req.abort()},e.exports=l},function(e,a,t){var r=t(402).BufferUtil;const c=1;function n(e,a,t){this.maskBytes=e,this.frameHeader=a,this.config=t,this.maxReceivedFrameSize=t.maxReceivedFrameSize,this.protocolError=!1,this.frameTooLarge=!1,this.invalidCloseFrameLength=!1,this.parseState=c,this.closeStatus=-1}n.prototype.addData=function(e){if(this.parseState===c&&e.length>=2){e.joinInto(this.frameHeader,0,0,2),e.advance(2);var a=this.frameHeader[0],t=this.frameHeader[1];if(this.fin=Boolean(128&a),this.rsv1=Boolean(64&a),this.rsv2=Boolean(32&a),this.rsv3=Boolean(16&a),this.mask=Boolean(128&t),this.opcode=15&a,this.length=127&t,this.opcode>=8){if(this.length>125)return this.protocolError=!0,this.dropReason="Illegal control frame longer than 125 bytes.",!0;if(!this.fin)return this.protocolError=!0,this.dropReason="Control frames must not be fragmented.",!0}126===this.length?this.parseState=2:127===this.length?this.parseState=3:this.parseState=4}if(2===this.parseState)e.length>=2&&(e.joinInto(this.frameHeader,2,0,2),e.advance(2),this.length=this.frameHeader.readUInt16BE(2),this.parseState=4);else if(3===this.parseState&&e.length>=8){e.joinInto(this.frameHeader,2,0,8),e.advance(8);var n=[this.frameHeader.readUInt32BE(2),this.frameHeader.readUInt32BE(6)];if(0!==n[0])return this.protocolError=!0,this.dropReason="Unsupported 64-bit length frame received",!0;this.length=n[1],this.parseState=4}if(4===this.parseState&&(this.mask?e.length>=4&&(e.joinInto(this.maskBytes,0,0,4),e.advance(4),this.parseState=5):this.parseState=5),5===this.parseState){if(this.length>this.maxReceivedFrameSize)return this.frameTooLarge=!0,this.dropReason="Frame size of "+this.length.toString(10)+" bytes exceeds maximum accepted frame size",!0;if(0===this.length)return this.binaryPayload=new Buffer(0),this.parseState=6,!0;if(e.length>=this.length)return this.binaryPayload=e.take(this.length),e.advance(this.length),this.mask&&r.unmask(this.binaryPayload,this.maskBytes),8===this.opcode&&(1===this.length&&(this.binaryPayload=new Buffer(0),this.invalidCloseFrameLength=!0),this.length>=2&&(this.closeStatus=this.binaryPayload.readUInt16BE(0),this.binaryPayload=this.binaryPayload.slice(2))),this.parseState=6,!0}return!1},n.prototype.throwAwayPayload=function(e){return e.length>=this.length&&(e.advance(this.length),this.parseState=6,!0)},n.prototype.toBuffer=function(e){var a,t,c,n=2,i=0,f=0;this.fin&&(i|=128),this.rsv1&&(i|=64),this.rsv2&&(i|=32),this.rsv3&&(i|=16),this.mask&&(f|=128),i|=15&this.opcode,8===this.opcode?(this.length=2,this.binaryPayload&&(this.length+=this.binaryPayload.length),(t=new Buffer(this.length)).writeUInt16BE(this.closeStatus,0),this.length>2&&this.binaryPayload.copy(t,2)):this.binaryPayload?(t=this.binaryPayload,this.length=t.length):this.length=0,this.length<=125?f|=127&this.length:this.length>125&&this.length<=65535?(f|=126,n+=2):this.length>65535&&(f|=127,n+=8);var o=new Buffer(this.length+n+(this.mask?4:0));return o[0]=i,o[1]=f,c=2,this.length>125&&this.length<=65535?(o.writeUInt16BE(this.length,c),c+=2):this.length>65535&&(o.writeUInt32BE(0,c),o.writeUInt32BE(this.length,c+4),c+=8),this.mask?(a=e?0:4294967295*Math.random()>>>0,this.maskBytes.writeUInt32BE(a,0),this.maskBytes.copy(o,c),c+=4,t&&r.mask(t,this.maskBytes,o,c,this.length)):t&&t.copy(o,c),o},n.prototype.toString=function(){return"Opcode: "+this.opcode+", fin: "+this.fin+", length: "+this.length+", hasPayload: "+Boolean(this.binaryPayload)+", masked: "+this.mask},e.exports=n},function(e,a,t){for(var r=t(10),c=t(1),n=t(32),i=t(5).EventEmitter,f=t(120),o=/,\s*/,d=/;\s*/,s=/[\r\n]/g,b=/,\s*/,u=["(",")","<",">","@",",",";",":","\\",'"',"/","[","]","?","=","{","}"," ",String.fromCharCode(9)],l=[String.fromCharCode(127)],p=0;p<31;p++)l.push(String.fromCharCode(p));var h=/([\x00-\x20\x22\x28\x29\x2c\x2f\x3a-\x3f\x40\x5b-\x5e\x7b\x7d\x7f])/,m=/[^\x21\x23-\x2b\x2d-\x3a\x3c-\x5b\x5d-\x7e]/,g=/^"[^"]*"$/,v=/[\x00-\x20\x3b]/g,y=/[;,] */,_={100:"Continue",101:"Switching Protocols",200:"OK",201:"Created",203:"Non-Authoritative Information",204:"No Content",205:"Reset Content",206:"Partial Content",300:"Multiple Choices",301:"Moved Permanently",302:"Found",303:"See Other",304:"Not Modified",305:"Use Proxy",307:"Temporary Redirect",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",406:"Not Acceptable",407:"Proxy Authorization Required",408:"Request Timeout",409:"Conflict",410:"Gone",411:"Length Required",412:"Precondition Failed",413:"Request Entity Too Long",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Requested Range Not Satisfiable",417:"Expectation Failed",426:"Upgrade Required",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Gateway Timeout",505:"HTTP Version Not Supported"};function w(e,a,t){i.call(this),this.socket=e,this.httpRequest=a,this.resource=a.url,this.remoteAddress=e.remoteAddress,this.remoteAddresses=[this.remoteAddress],this.serverConfig=t,this._socketIsClosing=!1,this._socketCloseHandler=this._handleSocketCloseBeforeAccept.bind(this),this.socket.on("end",this._socketCloseHandler),this.socket.on("close",this._socketCloseHandler),this._resolved=!1}function A(e){process.nextTick(function(){e.drop(1006,"TCP connection lost before handshake completed.",!0)})}c.inherits(w,i),w.prototype.readHandshake=function(){var e=this,a=this.httpRequest;if(this.resourceURL=n.parse(this.resource,!0),this.host=a.headers.host,!this.host)throw new Error("Client must provide a Host header.");if(this.key=a.headers["sec-websocket-key"],!this.key)throw new Error("Client must provide a value for Sec-WebSocket-Key.");if(this.webSocketVersion=parseInt(a.headers["sec-websocket-version"],10),!this.webSocketVersion||isNaN(this.webSocketVersion))throw new Error("Client must provide a value for Sec-WebSocket-Version.");switch(this.webSocketVersion){case 8:case 13:break;default:var t=new Error("Unsupported websocket client version: "+this.webSocketVersion+"Only versions 8 and 13 are supported.");throw t.httpCode=426,t.headers={"Sec-WebSocket-Version":"13"},t}13===this.webSocketVersion?this.origin=a.headers.origin:8===this.webSocketVersion&&(this.origin=a.headers["sec-websocket-origin"]);var r=a.headers["sec-websocket-protocol"];(this.protocolFullCaseMap={},this.requestedProtocols=[],r)&&r.split(o).forEach(function(a){var t=a.toLocaleLowerCase();e.requestedProtocols.push(t),e.protocolFullCaseMap[t]=a});if(!this.serverConfig.ignoreXForwardedFor&&a.headers["x-forwarded-for"]){var c=this.remoteAddress;this.remoteAddresses=a.headers["x-forwarded-for"].split(b),this.remoteAddresses.push(c),this.remoteAddress=this.remoteAddresses[0]}var i=a.headers["sec-websocket-extensions"];this.requestedExtensions=this.parseExtensions(i);var f=a.headers.cookie;this.cookies=this.parseCookies(f)},w.prototype.parseExtensions=function(e){if(!e||0===e.length)return[];var a=e.toLocaleLowerCase().split(o);return a.forEach(function(e,a,t){var r=e.split(d),c=r[0],n=r.slice(1);n.forEach(function(e,a,t){var r=e.split("="),c={name:r[0],value:r[1]};t.splice(a,1,c)});var i={name:c,params:n};t.splice(a,1,i)}),a},w.prototype.parseCookies=function(e){if(!e||"string"!=typeof e)return[];var a=[];return e.split(y).forEach(function(e){var t=e.indexOf("=");if(-1!==t){var r=e.substr(0,t).trim(),c=e.substr(++t,e.length).trim();'"'===c[0]&&(c=c.slice(1,-1)),a.push({name:r,value:decodeURIComponent(c)})}else a.push({name:e,value:null})}),a},w.prototype.accept=function(e,a,t){var c;this._verifyResolution(),e?void 0===(c=this.protocolFullCaseMap[e.toLocaleLowerCase()])&&(c=e):c=e,this.protocolFullCaseMap=null;var n=r.createHash("sha1");n.update(this.key+"258EAFA5-E914-47DA-95CA-C5AB0DC85B11");var i="HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: "+n.digest("base64")+"\r\n";if(c){for(var o=0;o<c.length;o++){var d=c.charCodeAt(o),b=c.charAt(o);if(d<33||d>126||-1!==u.indexOf(b))throw this.reject(500),new Error('Illegal character "'+String.fromCharCode(b)+'" in subprotocol.')}if(-1===this.requestedProtocols.indexOf(e))throw this.reject(500),new Error("Specified protocol was not requested by the client.");c=c.replace(s,""),i+="Sec-WebSocket-Protocol: "+c+"\r\n"}if(this.requestedProtocols=null,a&&(a=a.replace(s,""),13===this.webSocketVersion?i+="Origin: "+a+"\r\n":8===this.webSocketVersion&&(i+="Sec-WebSocket-Origin: "+a+"\r\n")),t){if(!Array.isArray(t))throw this.reject(500),new Error('Value supplied for "cookies" argument must be an array.');var l={};t.forEach(function(e){if(!e.name||!e.value)throw this.reject(500),new Error('Each cookie to set must at least provide a "name" and "value"');if(e.name=e.name.replace(v,""),e.value=e.value.replace(v,""),l[e.name])throw this.reject(500),new Error("You may not specify the same cookie name twice.");l[e.name]=!0;var a=e.name.match(h);if(a)throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie name");if(a=e.value.match(g)?e.value.slice(1,-1).match(m):e.value.match(m))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie value");var t=[e.name+"="+e.value];if(e.path){if(a=e.path.match(v))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie path");t.push("Path="+e.path)}if(e.domain){if("string"!=typeof e.domain)throw this.reject(500),new Error("Domain must be specified and must be a string.");if(a=e.domain.match(v))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie domain");t.push("Domain="+e.domain.toLowerCase())}if(e.expires){if(!(e.expires instanceof Date))throw this.reject(500),new Error('Value supplied for cookie "expires" must be a vaild date object');t.push("Expires="+e.expires.toGMTString())}if(e.maxage){var r=e.maxage;if("string"==typeof r&&(r=parseInt(r,10)),isNaN(r)||r<=0)throw this.reject(500),new Error('Value supplied for cookie "maxage" must be a non-zero number');r=Math.round(r),t.push("Max-Age="+r.toString(10))}if(e.secure){if("boolean"!=typeof e.secure)throw this.reject(500),new Error('Value supplied for cookie "secure" must be of type boolean');t.push("Secure")}if(e.httponly){if("boolean"!=typeof e.httponly)throw this.reject(500),new Error('Value supplied for cookie "httponly" must be of type boolean');t.push("HttpOnly")}i+="Set-Cookie: "+t.join(";")+"\r\n"}.bind(this))}this._resolved=!0,this.emit("requestResolved",this),i+="\r\n";var p=new f(this.socket,[],e,!1,this.serverConfig);p.webSocketVersion=this.webSocketVersion,p.remoteAddress=this.remoteAddress,p.remoteAddresses=this.remoteAddresses;var y=this;return this._socketIsClosing?A(p):this.socket.write(i,"ascii",function(e){e?A(p):(y._removeSocketCloseListeners(),p._addSocketEventListeners())}),this.emit("requestAccepted",p),p},w.prototype.reject=function(e,a,t){this._verifyResolution(),this._resolved=!0,this.emit("requestResolved",this),"number"!=typeof e&&(e=403);var r="HTTP/1.1 "+e+" "+_[e]+"\r\nConnection: close\r\n";if(a&&(r+="X-WebSocket-Reject-Reason: "+(a=a.replace(s,""))+"\r\n"),t)for(var c in t){var n=t[c].toString().replace(s,"");r+=c.replace(s,"")+": "+n+"\r\n"}r+="\r\n",this.socket.end(r,"ascii"),this.emit("requestRejected",this)},w.prototype._handleSocketCloseBeforeAccept=function(){this._socketIsClosing=!0,this._removeSocketCloseListeners()},w.prototype._removeSocketCloseListeners=function(){this.socket.removeListener("end",this._socketCloseHandler),this.socket.removeListener("close",this._socketCloseHandler)},w.prototype._verifyResolution=function(){if(this._resolved)throw new Error("WebSocketRequest may only be accepted or rejected one time.")},e.exports=w},function(e,a,t){var r=t(19),c=t(93);e.exports={toJSON:function(e,a){return{number:r.rpcQuantityHexString(e.header.number),hash:r.hex(e.hash()),parentHash:r.hex(e.header.parentHash),mixHash:r.hex(e.header.mixHash),nonce:r.rpcDataHexString(r.hex(e.header.nonce),16),sha3Uncles:r.hex(e.header.uncleHash),logsBloom:r.hex(e.header.bloom),transactionsRoot:r.hex(e.header.transactionsTrie),stateRoot:r.hex(e.header.stateRoot),receiptsRoot:r.hex(e.header.receiptTrie),miner:r.hex(e.header.coinbase),difficulty:r.rpcQuantityHexString(e.header.difficulty),totalDifficulty:r.rpcQuantityHexString(e.header.difficulty),extraData:r.rpcDataHexString(e.header.extraData),size:r.hex(1e3),gasLimit:r.rpcQuantityHexString(e.header.gasLimit),gasUsed:r.rpcQuantityHexString(e.header.gasUsed),timestamp:r.rpcQuantityHexString(e.header.timestamp),transactions:e.transactions.map(function(t){return a?c.toJSON(t,e):r.hex(t.hash())}),uncles:[]}}}},function(e,a,t){t(19);var r=t(191),c=t(18),n=t(87);e.exports={encode:function(e,a){var t=e.toJSON(!0);c.map(e.transactions,function(e,a){r.encode(e,a)},function(e,r){if(e)return a(e);t.transactions=r,a(null,t)})},decode:function(e,a){var t=e.transactions;e.transactions=[];var i=new n(e);c.eachSeries(t,function(e,a){r.decode(e,function(e,t){if(e)return a(e);i.transactions.push(t),a()})},function(e){if(e)return a(e);a(null,i)})}}},function(e,a,t){var r=t(19),c=t(3),n=t(117);e.exports={encode:function(e,a){var t=e.toJSON(!0);t.from=r.hex(e.from),t.hash=r.hex(e.hash()),a(null,t)},decode:function(e,a){a(null,new n({nonce:c.toBuffer(e.nonce),value:c.toBuffer(e.value),to:c.toBuffer(e.to),from:c.toBuffer(e.from),gasLimit:c.toBuffer(e.gasLimit),gasPrice:c.toBuffer(e.gasPrice),data:c.toBuffer(e.data),v:c.toBuffer(e.v),r:c.toBuffer(e.r),s:c.toBuffer(e.s)}))}}},function(e,a){function t(e){this._db=e,this._operations=[],this._written=!1}t.prototype._serializeKey=function(e){return this._db._serializeKey(e)},t.prototype._serializeValue=function(e){return this._db._serializeValue(e)},t.prototype._checkWritten=function(){if(this._written)throw new Error("write() already called on this batch")},t.prototype.put=function(e,a){this._checkWritten();var t=this._db._checkKey(e,"key",this._db._isBuffer);if(t)throw t;return e=this._serializeKey(e),a=this._serializeValue(a),"function"==typeof this._put?this._put(e,a):this._operations.push({type:"put",key:e,value:a}),this},t.prototype.del=function(e){this._checkWritten();var a=this._db._checkKey(e,"key",this._db._isBuffer);if(a)throw a;return e=this._serializeKey(e),"function"==typeof this._del?this._del(e):this._operations.push({type:"del",key:e}),this},t.prototype.clear=function(){return this._checkWritten(),this._operations=[],"function"==typeof this._clear&&this._clear(),this},t.prototype.write=function(e,a){if(this._checkWritten(),"function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("write() requires a callback argument");return"object"!=typeof e&&(e={}),this._written=!0,"function"==typeof this._write?this._write(a):"function"==typeof this._db._batch?this._db._batch(this._operations,e,a):void process.nextTick(a)},e.exports=t},function(e,a){function t(e){this.db=e,this._ended=!1,this._nexting=!1}t.prototype.next=function(e){var a=this;if("function"!=typeof e)throw new Error("next() requires a callback argument");return a._ended?e(new Error("cannot call next() after end()")):a._nexting?e(new Error("cannot call next() before previous next() has completed")):(a._nexting=!0,"function"==typeof a._next?a._next(function(){a._nexting=!1,e.apply(null,arguments)}):void process.nextTick(function(){a._nexting=!1,e()}))},t.prototype.end=function(e){if("function"!=typeof e)throw new Error("end() requires a callback argument");return this._ended?e(new Error("end() already called on iterator")):(this._ended=!0,"function"==typeof this._end?this._end(e):void process.nextTick(e))},e.exports=t},function(e,a,t){var r=t(39),c=t(193),n=t(192);function i(e){if(!arguments.length||void 0===e)throw new Error("constructor requires at least a location argument");if("string"!=typeof e)throw new Error("constructor requires a location string argument");this.location=e,this.status="new"}i.prototype.open=function(e,a){var t=this,r=this.status;if("function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("open() requires a callback argument");"object"!=typeof e&&(e={}),e.createIfMissing=0!=e.createIfMissing,e.errorIfExists=!!e.errorIfExists,"function"==typeof this._open?(this.status="opening",this._open(e,function(e){if(e)return t.status=r,a(e);t.status="open",a()})):(this.status="open",process.nextTick(a))},i.prototype.close=function(e){var a=this,t=this.status;if("function"!=typeof e)throw new Error("close() requires a callback argument");"function"==typeof this._close?(this.status="closing",this._close(function(r){if(r)return a.status=t,e(r);a.status="closed",e()})):(this.status="closed",process.nextTick(e))},i.prototype.get=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("get() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),a.asBuffer=0!=a.asBuffer,"function"==typeof this._get?this._get(e,a,t):void process.nextTick(function(){t(new Error("NotFound"))}))},i.prototype.put=function(e,a,t,r){var c;if("function"==typeof t&&(r=t),"function"!=typeof r)throw new Error("put() requires a callback argument");return(c=this._checkKey(e,"key"))?r(c):(e=this._serializeKey(e),a=this._serializeValue(a),"object"!=typeof t&&(t={}),"function"==typeof this._put?this._put(e,a,t,r):void process.nextTick(r))},i.prototype.del=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("del() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),"function"==typeof this._del?this._del(e,a,t):void process.nextTick(t))},i.prototype.batch=function(e,a,t){if(!arguments.length)return this._chainedBatch();if("function"==typeof a&&(t=a),"function"==typeof e&&(t=e),"function"!=typeof t)throw new Error("batch(array) requires a callback argument");if(!Array.isArray(e))return t(new Error("batch(array) requires an array argument"));a&&"object"==typeof a||(a={});for(var r,c,n=0,i=e.length;n<i;n++)if("object"==typeof(r=e[n])){if(c=this._checkKey(r.type,"type"))return t(c);if(c=this._checkKey(r.key,"key"))return t(c)}if("function"==typeof this._batch)return this._batch(e,a,t);process.nextTick(t)},i.prototype.approximateSize=function(e,a,t){if(null==e||null==a||"function"==typeof e||"function"==typeof a)throw new Error("approximateSize() requires valid `start`, `end` and `callback` arguments");if("function"!=typeof t)throw new Error("approximateSize() requires a callback argument");if(e=this._serializeKey(e),a=this._serializeKey(a),"function"==typeof this._approximateSize)return this._approximateSize(e,a,t);process.nextTick(function(){t(null,0)})},i.prototype._setupIteratorOptions=function(e){var a=this;return e=r(e),["start","end","gt","gte","lt","lte"].forEach(function(t){e[t]&&a._isBuffer(e[t])&&0===e[t].length&&delete e[t]}),e.reverse=!!e.reverse,e.keys=0!=e.keys,e.values=0!=e.values,e.limit="limit"in e?e.limit:-1,e.keyAsBuffer=0!=e.keyAsBuffer,e.valueAsBuffer=0!=e.valueAsBuffer,e},i.prototype.iterator=function(e){return"object"!=typeof e&&(e={}),e=this._setupIteratorOptions(e),"function"==typeof this._iterator?this._iterator(e):new c(this)},i.prototype._chainedBatch=function(){return new n(this)},i.prototype._isBuffer=function(e){return Buffer.isBuffer(e)},i.prototype._serializeKey=function(e){return this._isBuffer(e)?e:String(e)},i.prototype._serializeValue=function(e){return null==e?"":this._isBuffer(e)||process.browser?e:String(e)},i.prototype._checkKey=function(e,a){return null===e||void 0===e?new Error(a+" cannot be `null` or `undefined`"):this._isBuffer(e)&&0===e.length?new Error(a+" cannot be an empty Buffer"):""===String(e)?new Error(a+" cannot be an empty String"):void 0},e.exports=i},function(e,a){function t(e){this._db=e,this._operations=[],this._written=!1}t.prototype._serializeKey=function(e){return this._db._serializeKey(e)},t.prototype._serializeValue=function(e){return this._db._serializeValue(e)},t.prototype._checkWritten=function(){if(this._written)throw new Error("write() already called on this batch")},t.prototype.put=function(e,a){this._checkWritten();var t=this._db._checkKey(e,"key",this._db._isBuffer);if(t)throw t;return e=this._serializeKey(e),a=this._serializeValue(a),"function"==typeof this._put?this._put(e,a):this._operations.push({type:"put",key:e,value:a}),this},t.prototype.del=function(e){this._checkWritten();var a=this._db._checkKey(e,"key",this._db._isBuffer);if(a)throw a;return e=this._serializeKey(e),"function"==typeof this._del?this._del(e):this._operations.push({type:"del",key:e}),this},t.prototype.clear=function(){return this._checkWritten(),this._operations=[],"function"==typeof this._clear&&this._clear(),this},t.prototype.write=function(e,a){if(this._checkWritten(),"function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("write() requires a callback argument");return"object"!=typeof e&&(e={}),this._written=!0,"function"==typeof this._write?this._write(a):"function"==typeof this._db._batch?this._db._batch(this._operations,e,a):void process.nextTick(a)},e.exports=t},function(e,a){function t(e){this.db=e,this._ended=!1,this._nexting=!1}t.prototype.next=function(e){var a=this;if("function"!=typeof e)throw new Error("next() requires a callback argument");return a._ended?e(new Error("cannot call next() after end()")):a._nexting?e(new Error("cannot call next() before previous next() has completed")):(a._nexting=!0,"function"==typeof a._next?a._next(function(){a._nexting=!1,e.apply(null,arguments)}):void process.nextTick(function(){a._nexting=!1,e()}))},t.prototype.end=function(e){if("function"!=typeof e)throw new Error("end() requires a callback argument");return this._ended?e(new Error("end() already called on iterator")):(this._ended=!0,"function"==typeof this._end?this._end(e):void process.nextTick(e))},e.exports=t},function(e,a,t){var r=t(39),c=t(196),n=t(195);function i(e){if(!arguments.length||void 0===e)throw new Error("constructor requires at least a location argument");if("string"!=typeof e)throw new Error("constructor requires a location string argument");this.location=e,this.status="new"}i.prototype.open=function(e,a){var t=this,r=this.status;if("function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("open() requires a callback argument");"object"!=typeof e&&(e={}),e.createIfMissing=0!=e.createIfMissing,e.errorIfExists=!!e.errorIfExists,"function"==typeof this._open?(this.status="opening",this._open(e,function(e){if(e)return t.status=r,a(e);t.status="open",a()})):(this.status="open",process.nextTick(a))},i.prototype.close=function(e){var a=this,t=this.status;if("function"!=typeof e)throw new Error("close() requires a callback argument");"function"==typeof this._close?(this.status="closing",this._close(function(r){if(r)return a.status=t,e(r);a.status="closed",e()})):(this.status="closed",process.nextTick(e))},i.prototype.get=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("get() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),a.asBuffer=0!=a.asBuffer,"function"==typeof this._get?this._get(e,a,t):void process.nextTick(function(){t(new Error("NotFound"))}))},i.prototype.put=function(e,a,t,r){var c;if("function"==typeof t&&(r=t),"function"!=typeof r)throw new Error("put() requires a callback argument");return(c=this._checkKey(e,"key"))?r(c):(e=this._serializeKey(e),a=this._serializeValue(a),"object"!=typeof t&&(t={}),"function"==typeof this._put?this._put(e,a,t,r):void process.nextTick(r))},i.prototype.del=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("del() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),"function"==typeof this._del?this._del(e,a,t):void process.nextTick(t))},i.prototype.batch=function(e,a,t){if(!arguments.length)return this._chainedBatch();if("function"==typeof a&&(t=a),"function"==typeof e&&(t=e),"function"!=typeof t)throw new Error("batch(array) requires a callback argument");if(!Array.isArray(e))return t(new Error("batch(array) requires an array argument"));a&&"object"==typeof a||(a={});for(var r,c,n=0,i=e.length;n<i;n++)if("object"==typeof(r=e[n])){if(c=this._checkKey(r.type,"type"))return t(c);if(c=this._checkKey(r.key,"key"))return t(c)}if("function"==typeof this._batch)return this._batch(e,a,t);process.nextTick(t)},i.prototype.approximateSize=function(e,a,t){if(null==e||null==a||"function"==typeof e||"function"==typeof a)throw new Error("approximateSize() requires valid `start`, `end` and `callback` arguments");if("function"!=typeof t)throw new Error("approximateSize() requires a callback argument");if(e=this._serializeKey(e),a=this._serializeKey(a),"function"==typeof this._approximateSize)return this._approximateSize(e,a,t);process.nextTick(function(){t(null,0)})},i.prototype._setupIteratorOptions=function(e){var a=this;return e=r(e),["start","end","gt","gte","lt","lte"].forEach(function(t){e[t]&&a._isBuffer(e[t])&&0===e[t].length&&delete e[t]}),e.reverse=!!e.reverse,e.keys=0!=e.keys,e.values=0!=e.values,e.limit="limit"in e?e.limit:-1,e.keyAsBuffer=0!=e.keyAsBuffer,e.valueAsBuffer=0!=e.valueAsBuffer,e},i.prototype.iterator=function(e){return"object"!=typeof e&&(e={}),e=this._setupIteratorOptions(e),"function"==typeof this._iterator?this._iterator(e):new c(this)},i.prototype._chainedBatch=function(){return new n(this)},i.prototype._isBuffer=function(e){return Buffer.isBuffer(e)},i.prototype._serializeKey=function(e){return this._isBuffer(e)?e:String(e)},i.prototype._serializeValue=function(e){return null==e?"":this._isBuffer(e)||process.browser?e:String(e)},i.prototype._checkKey=function(e,a){return null===e||void 0===e?new Error(a+" cannot be `null` or `undefined`"):this._isBuffer(e)&&0===e.length?new Error(a+" cannot be an empty Buffer"):""===String(e)?new Error(a+" cannot be an empty String"):void 0},e.exports=i},function(e,a){e.exports=function(){for(var e={},a=0;a<arguments.length;a++){var t=arguments[a];for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])}return e}},function(e,a,t){e.exports=i;var r=t(121),c=t(17);function n(e,a){this.afterTransform=function(e,t){return function(e,a,t){var r=e._transformState;r.transforming=!1;var c=r.writecb;if(!c)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,null!==t&&void 0!==t&&e.push(t);c&&c(a);var n=e._readableState;n.reading=!1,(n.needReadable||n.length<n.highWaterMark)&&e._read(n.highWaterMark)}(a,e,t)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null}function i(e){if(!(this instanceof i))return new i(e);r.call(this,e);this._transformState=new n(e,this);var a=this;this._readableState.needReadable=!0,this._readableState.sync=!1,this.once("finish",function(){"function"==typeof this._flush?this._flush(function(e){f(a,e)}):f(a)})}function f(e,a){if(a)return e.emit("error",a);var t=e._writableState,r=(e._readableState,e._transformState);if(t.length)throw new Error("calling transform done when ws.length != 0");if(r.transforming)throw new Error("calling transform done when still transforming");return e.push(null)}c.inherits=t(0),c.inherits(i,r),i.prototype.push=function(e,a){return this._transformState.needTransform=!1,r.prototype.push.call(this,e,a)},i.prototype._transform=function(e,a,t){throw new Error("not implemented")},i.prototype._write=function(e,a,t){var r=this._transformState;if(r.writecb=t,r.writechunk=e,r.writeencoding=a,!r.transforming){var c=this._readableState;(r.needTransform||c.needReadable||c.length<c.highWaterMark)&&this._read(c.highWaterMark)}},i.prototype._read=function(e){var a=this._transformState;null!==a.writechunk&&a.writecb&&!a.transforming?(a.transforming=!0,this._transform(a.writechunk,a.writeencoding,a.afterTransform)):a.needTransform=!0}},function(e,a,t){e.exports=f;var r=t(24).Buffer;f.WritableState=i;var c=t(17);c.inherits=t(0);var n=t(6);function i(e,a){var t=(e=e||{}).highWaterMark;this.highWaterMark=t||0===t?t:16384,this.objectMode=!!e.objectMode,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var r=!1===e.decodeStrings;this.decodeStrings=!r,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,a){var t=e._writableState,r=t.sync,c=t.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(t),a)!function(e,a,t,r,c){t?process.nextTick(function(){c(r)}):c(r);e._writableState.errorEmitted=!0,e.emit("error",r)}(e,0,r,a,c);else{var n=s(e,t);n||t.bufferProcessing||!t.buffer.length||function(e,a){a.bufferProcessing=!0;for(var t=0;t<a.buffer.length;t++){var r=a.buffer[t],c=r.chunk,n=r.encoding,i=r.callback,f=a.objectMode?1:c.length;if(o(e,a,f,c,n,i),a.writing){t++;break}}a.bufferProcessing=!1,t<a.buffer.length?a.buffer=a.buffer.slice(t):a.buffer.length=0}(e,t),r?process.nextTick(function(){d(e,t,n,c)}):d(e,t,n,c)}}(a,e)},this.writecb=null,this.writelen=0,this.buffer=[],this.errorEmitted=!1}function f(e){var a=t(121);if(!(this instanceof f||this instanceof a))return new f(e);this._writableState=new i(e,this),this.writable=!0,n.call(this)}function o(e,a,t,r,c,n){a.writelen=t,a.writecb=n,a.writing=!0,a.sync=!0,e._write(r,c,a.onwrite),a.sync=!1}function d(e,a,t,r){t||function(e,a){0===a.length&&a.needDrain&&(a.needDrain=!1,e.emit("drain"))}(e,a),r(),t&&b(e,a)}function s(e,a){return a.ending&&0===a.length&&!a.finished&&!a.writing}function b(e,a){var t=s(0,a);return t&&(a.finished=!0,e.emit("finish")),t}c.inherits(f,n),f.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))},f.prototype.write=function(e,a,t){var c=this._writableState,n=!1;return"function"==typeof a&&(t=a,a=null),r.isBuffer(e)?a="buffer":a||(a=c.defaultEncoding),"function"!=typeof t&&(t=function(){}),c.ended?function(e,a,t){var r=new Error("write after end");e.emit("error",r),process.nextTick(function(){t(r)})}(this,0,t):function(e,a,t,c){var n=!0;if(!r.isBuffer(t)&&"string"!=typeof t&&null!==t&&void 0!==t&&!a.objectMode){var i=new TypeError("Invalid non-string/buffer chunk");e.emit("error",i),process.nextTick(function(){c(i)}),n=!1}return n}(this,c,e,t)&&(n=function(e,a,t,c,n){t=function(e,a,t){return e.objectMode||!1===e.decodeStrings||"string"!=typeof a||(a=new r(a,t)),a}(a,t,c),r.isBuffer(t)&&(c="buffer");var i=a.objectMode?1:t.length;a.length+=i;var f=a.length<a.highWaterMark;f||(a.needDrain=!0);a.writing?a.buffer.push(new function(e,a,t){this.chunk=e,this.encoding=a,this.callback=t}(t,c,n)):o(e,a,i,t,c,n);return f}(this,c,e,a,t)),n},f.prototype._write=function(e,a,t){t(new Error("not implemented"))},f.prototype.end=function(e,a,t){var r=this._writableState;"function"==typeof e?(t=e,e=null,a=null):"function"==typeof a&&(t=a,a=null),void 0!==e&&null!==e&&this.write(e,a),r.ending||r.finished||function(e,a,t){a.ending=!0,b(e,a),t&&(a.finished?process.nextTick(t):e.once("finish",t));a.ended=!0}(this,r,t)}},function(e,a,t){e.exports=s;var r=t(178),c=t(24).Buffer;s.ReadableState=d;var n=t(5).EventEmitter;n.listenerCount||(n.listenerCount=function(e,a){return e.listeners(a).length});var i,f=t(6),o=t(17);function d(e,a){var r=(e=e||{}).highWaterMark;this.highWaterMark=r||0===r?r:16384,this.highWaterMark=~~this.highWaterMark,this.buffer=[],this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=!1,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.calledRead=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.objectMode=!!e.objectMode,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(i||(i=t(63).StringDecoder),this.decoder=new i(e.encoding),this.encoding=e.encoding)}function s(e){if(!(this instanceof s))return new s(e);this._readableState=new d(e,this),this.readable=!0,f.call(this)}function b(e,a,t,r,n){var i=function(e,a){var t=null;c.isBuffer(a)||"string"==typeof a||null===a||void 0===a||e.objectMode||(t=new TypeError("Invalid non-string/buffer chunk"));return t}(a,t);if(i)e.emit("error",i);else if(null===t||void 0===t)a.reading=!1,a.ended||function(e,a){if(a.decoder&&!a.ended){var t=a.decoder.end();t&&t.length&&(a.buffer.push(t),a.length+=a.objectMode?1:t.length)}a.ended=!0,a.length>0?p(e):_(e)}(e,a);else if(a.objectMode||t&&t.length>0)if(a.ended&&!n){var f=new Error("stream.push() after EOF");e.emit("error",f)}else if(a.endEmitted&&n){f=new Error("stream.unshift() after end event");e.emit("error",f)}else!a.decoder||n||r||(t=a.decoder.write(t)),a.length+=a.objectMode?1:t.length,n?a.buffer.unshift(t):(a.reading=!1,a.buffer.push(t)),a.needReadable&&p(e),function(e,a){a.readingMore||(a.readingMore=!0,process.nextTick(function(){!function(e,a){var t=a.length;for(;!a.reading&&!a.flowing&&!a.ended&&a.length<a.highWaterMark&&(e.read(0),t!==a.length);)t=a.length;a.readingMore=!1}(e,a)}))}(e,a);else n||(a.reading=!1);return function(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(a)}o.inherits=t(0),o.inherits(s,f),s.prototype.push=function(e,a){var t=this._readableState;return"string"!=typeof e||t.objectMode||(a=a||t.defaultEncoding)!==t.encoding&&(e=new c(e,a),a=""),b(this,t,e,a,!1)},s.prototype.unshift=function(e){return b(this,this._readableState,e,"",!0)},s.prototype.setEncoding=function(e){i||(i=t(63).StringDecoder),this._readableState.decoder=new i(e),this._readableState.encoding=e};var u=8388608;function l(e,a){return 0===a.length&&a.ended?0:a.objectMode?0===e?0:1:null===e||isNaN(e)?a.flowing&&a.buffer.length?a.buffer[0].length:a.length:e<=0?0:(e>a.highWaterMark&&(a.highWaterMark=function(e){if(e>=u)e=u;else{e--;for(var a=1;a<32;a<<=1)e|=e>>a;e++}return e}(e)),e>a.length?a.ended?a.length:(a.needReadable=!0,0):e)}function p(e){var a=e._readableState;a.needReadable=!1,a.emittedReadable||(a.emittedReadable=!0,a.sync?process.nextTick(function(){h(e)}):h(e))}function h(e){e.emit("readable")}function m(e){var a,t=e._readableState;function r(e,r,c){!1===e.write(a)&&t.awaitDrain++}for(t.awaitDrain=0;t.pipesCount&&null!==(a=e.read());)if(1===t.pipesCount?r(t.pipes):w(t.pipes,r),e.emit("data",a),t.awaitDrain>0)return;if(0===t.pipesCount)return t.flowing=!1,void(n.listenerCount(e,"data")>0&&v(e));t.ranOut=!0}function g(){this._readableState.ranOut&&(this._readableState.ranOut=!1,m(this))}function v(e,a){if(e._readableState.flowing)throw new Error("Cannot switch to old mode now.");var t=a||!1,r=!1;e.readable=!0,e.pipe=f.prototype.pipe,e.on=e.addListener=f.prototype.on,e.on("readable",function(){var a;for(r=!0;!t&&null!==(a=e.read());)e.emit("data",a);null===a&&(r=!1,e._readableState.needReadable=!0)}),e.pause=function(){t=!0,this.emit("pause")},e.resume=function(){t=!1,r?process.nextTick(function(){e.emit("readable")}):this.read(0),this.emit("resume")},e.emit("readable")}function y(e,a){var t,r=a.buffer,n=a.length,i=!!a.decoder,f=!!a.objectMode;if(0===r.length)return null;if(0===n)t=null;else if(f)t=r.shift();else if(!e||e>=n)t=i?r.join(""):c.concat(r,n),r.length=0;else{if(e<r[0].length)t=(b=r[0]).slice(0,e),r[0]=b.slice(e);else if(e===r[0].length)t=r.shift();else{t=i?"":new c(e);for(var o=0,d=0,s=r.length;d<s&&o<e;d++){var b=r[0],u=Math.min(e-o,b.length);i?t+=b.slice(0,u):b.copy(t,o,0,u),u<b.length?r[0]=b.slice(u):r.shift(),o+=u}}}return t}function _(e){var a=e._readableState;if(a.length>0)throw new Error("endReadable called on non-empty stream");!a.endEmitted&&a.calledRead&&(a.ended=!0,process.nextTick(function(){a.endEmitted||0!==a.length||(a.endEmitted=!0,e.readable=!1,e.emit("end"))}))}function w(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}s.prototype.read=function(e){var a=this._readableState;a.calledRead=!0;var t,r=e;if(("number"!=typeof e||e>0)&&(a.emittedReadable=!1),0===e&&a.needReadable&&(a.length>=a.highWaterMark||a.ended))return p(this),null;if(0===(e=l(e,a))&&a.ended)return t=null,a.length>0&&a.decoder&&(t=y(e,a),a.length-=t.length),0===a.length&&_(this),t;var c=a.needReadable;return a.length-e<=a.highWaterMark&&(c=!0),(a.ended||a.reading)&&(c=!1),c&&(a.reading=!0,a.sync=!0,0===a.length&&(a.needReadable=!0),this._read(a.highWaterMark),a.sync=!1),c&&!a.reading&&(e=l(r,a)),null===(t=e>0?y(e,a):null)&&(a.needReadable=!0,e=0),a.length-=e,0!==a.length||a.ended||(a.needReadable=!0),a.ended&&!a.endEmitted&&0===a.length&&_(this),t},s.prototype._read=function(e){this.emit("error",new Error("not implemented"))},s.prototype.pipe=function(e,a){var t=this,c=this._readableState;switch(c.pipesCount){case 0:c.pipes=e;break;case 1:c.pipes=[c.pipes,e];break;default:c.pipes.push(e)}c.pipesCount+=1;var i=(!a||!1!==a.end)&&e!==process.stdout&&e!==process.stderr?o:s;function f(e){e===t&&s()}function o(){e.end()}c.endEmitted?process.nextTick(i):t.once("end",i),e.on("unpipe",f);var d=function(e){return function(){var a=e._readableState;a.awaitDrain--,0===a.awaitDrain&&m(e)}}(t);function s(){e.removeListener("close",u),e.removeListener("finish",l),e.removeListener("drain",d),e.removeListener("error",b),e.removeListener("unpipe",f),t.removeListener("end",o),t.removeListener("end",s),e._writableState&&!e._writableState.needDrain||d()}function b(a){p(),e.removeListener("error",b),0===n.listenerCount(e,"error")&&e.emit("error",a)}function u(){e.removeListener("finish",l),p()}function l(){e.removeListener("close",u),p()}function p(){t.unpipe(e)}return e.on("drain",d),e._events&&e._events.error?r(e._events.error)?e._events.error.unshift(b):e._events.error=[b,e._events.error]:e.on("error",b),e.once("close",u),e.once("finish",l),e.emit("pipe",t),c.flowing||(this.on("readable",g),c.flowing=!0,process.nextTick(function(){m(t)})),e},s.prototype.unpipe=function(e){var a=this._readableState;if(0===a.pipesCount)return this;if(1===a.pipesCount)return e&&e!==a.pipes?this:(e||(e=a.pipes),a.pipes=null,a.pipesCount=0,this.removeListener("readable",g),a.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var t=a.pipes,r=a.pipesCount;a.pipes=null,a.pipesCount=0,this.removeListener("readable",g),a.flowing=!1;for(var c=0;c<r;c++)t[c].emit("unpipe",this);return this}return-1===(c=function(e,a){for(var t=0,r=e.length;t<r;t++)if(e[t]===a)return t;return-1}(a.pipes,e))?this:(a.pipes.splice(c,1),a.pipesCount-=1,1===a.pipesCount&&(a.pipes=a.pipes[0]),e.emit("unpipe",this),this)},s.prototype.on=function(e,a){var t=f.prototype.on.call(this,e,a);if("data"!==e||this._readableState.flowing||v(this),"readable"===e&&this.readable){var r=this._readableState;r.readableListening||(r.readableListening=!0,r.emittedReadable=!1,r.needReadable=!0,r.reading?r.length&&p(this):this.read(0))}return t},s.prototype.addListener=s.prototype.on,s.prototype.resume=function(){v(this),this.read(0),this.emit("resume")},s.prototype.pause=function(){v(this,!0),this.emit("pause")},s.prototype.wrap=function(e){var a=this._readableState,t=!1,r=this;for(var c in e.on("end",function(){if(a.decoder&&!a.ended){var e=a.decoder.end();e&&e.length&&r.push(e)}r.push(null)}),e.on("data",function(c){(a.decoder&&(c=a.decoder.write(c)),!a.objectMode||null!==c&&void 0!==c)&&((a.objectMode||c&&c.length)&&(r.push(c)||(t=!0,e.pause())))}),e)"function"==typeof e[c]&&void 0===this[c]&&(this[c]=function(a){return function(){return e[a].apply(e,arguments)}}(c));return w(["error","close","destroy","pause","resume"],function(a){e.on(a,r.emit.bind(r,a))}),r._read=function(a){t&&(t=!1,e.resume())},r},s._fromList=y},function(e,a){var t=["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le"];e.exports=function(){function e(e){return void 0===e||null===e||Buffer.isBuffer(e)}var a={};return a.utf8=a["utf-8"]={encode:function(a){return e(a)?a:String(a)},decode:function(e){return e},buffer:!1,type:"utf8"},a.json={encode:JSON.stringify,decode:JSON.parse,buffer:!1,type:"json"},a.binary={encode:function(a){return e(a)?a:new Buffer(a)},decode:function(e){return e},buffer:!0,type:"binary"},t.forEach(function(t){a[t]||(a[t]={encode:function(a){return e(a)?a:new Buffer(a,t)},decode:function(e){return e.toString(t)},buffer:!0,type:t})}),a}()},function(e,a){function t(e,a){return Object.hasOwnProperty.call(e,a)}function r(e){return void 0!==e&&""!==e}function t(e,a){return Object.hasOwnProperty.call(e,a)}function c(e,a){return Object.hasOwnProperty.call(e,a)&&a}a.compare=function(e,a){if(Buffer.isBuffer(e)){for(var t=Math.min(e.length,a.length),r=0;r<t;r++){var c=e[r]-a[r];if(c)return c}return e.length-a.length}return e<a?-1:e>a?1:0};var n=a.lowerBoundKey=function(e){return c(e,"gt")||c(e,"gte")||c(e,"min")||(e.reverse?c(e,"end"):c(e,"start"))||void 0},i=a.lowerBound=function(e){var a=n(e);return a&&e[a]},f=a.lowerBoundInclusive=function(e){return!t(e,"gt")},o=a.upperBoundInclusive=function(e){return!t(e,"lt")},d=a.lowerBoundExclusive=function(e){return!f(e)},s=a.upperBoundExclusive=function(e){return!o(e)},b=a.upperBoundKey=function(e){return c(e,"lt")||c(e,"lte")||c(e,"max")||(e.reverse?c(e,"start"):c(e,"end"))||void 0},u=a.upperBound=function(e){var a=b(e);return a&&e[a]};function l(e){return e}a.toLtgt=function(e,r,c,n,i){r=r||{},c=c||l;var f=arguments.length>3,o=a.lowerBoundKey(e),d=a.upperBoundKey(e);return o?"gt"===o?r.gt=c(e.gt,!1):r.gte=c(e[o],!1):f&&(r.gte=c(n,!1)),d?"lt"===d?r.lt=c(e.lt,!0):r.lte=c(e[d],!0):f&&(r.lte=c(i,!0)),null!=e.reverse&&(r.reverse=!!e.reverse),t(r,"max")&&delete r.max,t(r,"min")&&delete r.min,t(r,"start")&&delete r.start,t(r,"end")&&delete r.end,r},a.contains=function(e,t,c){c=c||a.compare;var n=i(e);if(r(n)&&((f=c(t,n))<0||0===f&&d(e)))return!1;var f,o=u(e);if(r(o)&&((f=c(t,o))>0||0===f&&s(e)))return!1;return!0},a.filter=function(e,t){return function(r){return a.contains(e,r,t)}}},function(e,a,t){var r=t(203);function c(e){return Array.isArray(e)||Buffer.isBuffer(e)}function n(e){return"string"==typeof e||"number"==typeof e}function i(e,a){return Object.hasOwnProperty.call(e,a)}function f(e,a){if(c(e)&&c(a)){for(var t=Math.min(e.length,a.length),r=0;r<t;r++){var i=f(e[r],a[r]);if(i)return i}return e.length-a.length}if(n(e)&&n(a))return e<a?-1:e>a?1:0;throw new Error("items not comparable:"+JSON.stringify(e)+" "+JSON.stringify(a))}function o(e,a){if(e.length>a.length)return!1;var t=e.length-1,r=e[t],n=a[t];if(typeof r!=typeof n)return!1;if("string"==typeof r&&0!=n.indexOf(r))return!1;for(1==e.length&&c(r)&&t++;t--;)if(f(e[t],a[t]))return!1;return!0}(a=e.exports=function(e,a,t){return t=t||f,c(e)?o(e,a):r.contains(e,a,t)}).compare=f,a.prefix=o,a.addPrefix=function(e,a){var t=r.toLtgt(a,null,function(a){return[e,a]});return i(t,"gte")||i(t,"lte")?t:[e]}},function(e,a,t){t(449);var r=function(e,a){return parseInt(e.slice(2*a+2,2*a+4),16)},c=function(e){return(e.length-2)/2},n=function(e){for(var a=[],t=2,r=e.length;t<r;t+=2)a.push(parseInt(e.slice(t,t+2),16));return a},i=function(e){for(var a="0x",t=0,r=e.length;t<r;++t){var c=e[t];a+=(c<16?"0":"")+c.toString(16)}return a};e.exports={random:function(e){var a=void 0;a="undefined"!=typeof window&&window.crypto&&window.crypto.getRandomValues?window.crypto.getRandomValues(new Uint8Array(e)):t(10).randomBytes(e);for(var r="0x",c=0;c<e;++c)r+=("00"+a[c].toString(16)).slice(-2);return r},length:c,concat:function(e,a){return e.concat(a.slice(2))},flatten:function(e){return"0x"+e.reduce(function(e,a){return e+a.slice(2)},"")},slice:function(e,a,t){return"0x"+t.slice(2*e+2,2*a+2)},reverse:function(e){for(var a="0x",t=0,r=c(e);t<r;++t)a+=e.slice(2*(r-t),2*(r-t+1));return a},pad:function e(a,t){return t.length===2*a+2?t:e(a,"0x0"+t.slice(2))},padRight:function e(a,t){return t.length===2*a+2?t:e(a,t+"0")},fromAscii:function(e){for(var a="0x",t=0;t<e.length;++t)a+=("00"+e.charCodeAt(t).toString(16)).slice(-2);return a},toAscii:function(e){for(var a="",t=2;t<e.length;t+=2)a+=String.fromCharCode(parseInt(e.slice(t,t+2),16));return a},fromString:function(e){for(var a=function(e){var a=e.toString(16);return a.length<2?"0"+a:a},t="0x",r=0;r!=e.length;r++){var c=e.charCodeAt(r);if(c<128)t+=a(c);else{if(c<2048)t+=a(c>>6|192);else{if(c>55295&&c<56320){if(++r==e.length)return null;var n=e.charCodeAt(r);if(n<56320||n>57343)return null;t+=a((c=65536+((1023&c)<<10)+(1023&n))>>18|240),t+=a(c>>12&63|128)}else t+=a(c>>12|224);t+=a(c>>6&63|128)}t+=a(63&c|128)}}return t},toString:function(e){for(var a="",t=0,n=c(e);t<n;){var i=r(e,t++);if(i>127){if(i>191&&i<224){if(t>=n)return null;i=(31&i)<<6|63&r(e,t)}else if(i>223&&i<240){if(t+1>=n)return null;i=(15&i)<<12|(63&r(e,t))<<6|63&r(e,++t)}else{if(!(i>239&&i<248))return null;if(t+2>=n)return null;i=(7&i)<<18|(63&r(e,t))<<12|(63&r(e,++t))<<6|63&r(e,++t)}++t}if(i<=65535)a+=String.fromCharCode(i);else{if(!(i<=1114111))return null;i-=65536,a+=String.fromCharCode(i>>10|55296),a+=String.fromCharCode(1023&i|56320)}}return a},fromNumber:function(e){var a=e.toString(16);return a.length%2==0?"0x"+a:"0x0"+a},toNumber:function(e){return parseInt(e.slice(2),16)},fromNat:function(e){return"0x0"===e?"0x":e.length%2==0?e:"0x0"+e.slice(2)},toNat:function(e){return"0"===e[2]?"0x"+e.slice(3):e},fromArray:i,toArray:n,fromUint8Array:function(e){return i([].slice.call(e,0))},toUint8Array:function(e){return new Uint8Array(n(e))}}},function(e,a){e.exports=function(e,a,t){var r=a.toLowerCase();e[a]||e[r]||(e[a]=t)}},function(e,a,t){"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/var r=Object.getOwnPropertySymbols,c=Object.prototype.hasOwnProperty,n=Object.prototype.propertyIsEnumerable;e.exports=function(){try{if(!Object.assign)return!1;var e=new String("abc");if(e[5]="de","5"===Object.getOwnPropertyNames(e)[0])return!1;for(var a={},t=0;t<10;t++)a["_"+String.fromCharCode(t)]=t;if("0123456789"!==Object.getOwnPropertyNames(a).map(function(e){return a[e]}).join(""))return!1;var r={};return"abcdefghijklmnopqrst".split("").forEach(function(e){r[e]=e}),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},r)).join("")}catch(e){return!1}}()?Object.assign:function(e,a){for(var t,i,f=function(e){if(null===e||void 0===e)throw new TypeError("Object.assign cannot be called with null or undefined");return Object(e)}(e),o=1;o<arguments.length;o++){for(var d in t=Object(arguments[o]))c.call(t,d)&&(f[d]=t[d]);if(r){i=r(t);for(var s=0;s<i.length;s++)n.call(t,i[s])&&(f[i[s]]=t[i[s]])}}return f}},function(e,a,t){"use strict";var r=t(84),c=t(2),n=t(210),i=t(211),f=t(124),o=t(209),d="win32"===process.platform;function s(e){var a=c._makeLong(c.resolve(e)).split(c.sep);if(a.shift(),d){a.shift();var t="\\\\"+a.shift()+"\\"+a.shift().toLowerCase();a.unshift(t)}return""===a[a.length-1]&&a.pop(),a}function b(e){var a=!("createCwd"in(e=e||{}))||e.createCwd,t=!("createTmp"in e)||e.createTmp,c=new n,i=[];a&&i.push(process.cwd()),t&&i.push(r.tmpdir&&r.tmpdir()||r.tmpDir()),i.forEach(function(e){var a,t,r,i,f=s(e),o=c;for(a=0,t=f.length;a<t;++a)if(r=f[a],i=o.getItem(r)){if(!(i instanceof n))throw new Error("Failed to create directory: "+e);o=i}else o=o.addItem(r,new n)}),this._root=c}function u(e,a,t){var r;if("string"==typeof t||Buffer.isBuffer(t))(r=new i).setContent(t);else if("function"==typeof t)r=t();else{if("object"!=typeof t)throw new Error("Unsupported type: "+typeof t+" of item "+a);for(var c in r=new n,t)u(r,c,t[c])}r instanceof n&&0===r.list().length&&e.getItem(a)instanceof n||e.addItem(a,r)}b.prototype.getRoot=function(){return this._root},b.prototype.getItem=function(e){for(var a,t=s(e),r=s(process.cwd()),i=this._root,d="/",b=0,u=t.length;b<u;++b){for(a=t[b];i instanceof o;)d=c.resolve(c.dirname(d),i.getPath()),i=this.getItem(d);if(i){if(i instanceof n&&a!==r[b]&&!i.canExecute())throw new f("EACCES",e);i=i.getItem(a)}if(!i)break;d=c.resolve(d,a)}return i},b.create=function(e,a){var t=new b(a);for(var r in e){var c,i,f,o,d=s(r),l=t._root;for(c=0,i=d.length-1;c<i;++c)if(f=d[c],o=l.getItem(f)){if(!(o instanceof n))throw new Error("Failed to create directory: "+r);l=o}else l=l.addItem(f,new n);u(l,d[c],e[r])}return t},b.file=function(e){return e=e||{},function(){var a=new i;return e.hasOwnProperty("content")&&a.setContent(e.content),e.hasOwnProperty("mode")?a.setMode(e.mode):a.setMode(438),e.hasOwnProperty("uid")&&a.setUid(e.uid),e.hasOwnProperty("gid")&&a.setGid(e.gid),e.hasOwnProperty("atime")&&a.setATime(e.atime),e.hasOwnProperty("ctime")&&a.setCTime(e.ctime),e.hasOwnProperty("mtime")&&a.setMTime(e.mtime),e.hasOwnProperty("birthtime")&&a.setBirthtime(e.birthtime),a}},b.symlink=function(e){return e=e||{},function(){var a=new o;if(e.hasOwnProperty("mode")?a.setMode(e.mode):a.setMode(438),e.hasOwnProperty("uid")&&a.setUid(e.uid),e.hasOwnProperty("gid")&&a.setGid(e.gid),!e.hasOwnProperty("path"))throw new Error('Missing "path" property');return a.setPath(e.path),e.hasOwnProperty("atime")&&a.setATime(e.atime),e.hasOwnProperty("ctime")&&a.setCTime(e.ctime),e.hasOwnProperty("mtime")&&a.setMTime(e.mtime),e.hasOwnProperty("birthtime")&&a.setBirthtime(e.birthtime),a}},b.directory=function(e){return e=e||{},function(){var a=new n;if(e.hasOwnProperty("mode")&&a.setMode(e.mode),e.hasOwnProperty("uid")&&a.setUid(e.uid),e.hasOwnProperty("gid")&&a.setGid(e.gid),e.hasOwnProperty("items"))for(var t in e.items)u(a,t,e.items[t]);return e.hasOwnProperty("atime")&&a.setATime(e.atime),e.hasOwnProperty("ctime")&&a.setCTime(e.ctime),e.hasOwnProperty("mtime")&&a.setMTime(e.mtime),e.hasOwnProperty("birthtime")&&a.setBirthtime(e.birthtime),a}},(e.exports=b).getPathParts=s},function(e,a,t){"use strict";var r=t(1),c=t(125),n=t(58);function i(){c.call(this),this._path=void 0}r.inherits(i,c),i.prototype.setPath=function(e){this._path=e},i.prototype.getPath=function(){return this._path},i.prototype.getStats=function(){var e=this._path.length,a=c.prototype.getStats.call(this);return a.mode=this.getMode()|n.S_IFLNK,a.size=e,a.blocks=Math.ceil(e/512),a},e.exports=i},function(e,a,t){"use strict";var r=t(1),c=t(125),n=t(58);function i(){c.call(this),this._items={},this._mode=511}r.inherits(i,c),i.prototype.addItem=function(e,a){if(this._items.hasOwnProperty(e))throw new Error("Item with the same name already exists: "+e);return this._items[e]=a,++a.links,a instanceof i&&(++a.links,++this.links),this.setMTime(new Date),a},i.prototype.getItem=function(e){var a=null;return this._items.hasOwnProperty(e)&&(a=this._items[e]),a},i.prototype.removeItem=function(e){if(!this._items.hasOwnProperty(e))throw new Error("Item does not exist in directory: "+e);var a=this._items[e];return delete this._items[e],--a.links,a instanceof i&&(--a.links,--this.links),this.setMTime(new Date),a},i.prototype.list=function(){return Object.keys(this._items).sort()},i.prototype.getStats=function(){var e=c.prototype.getStats.call(this);return e.mode=this.getMode()|n.S_IFDIR,e.size=1,e.blocks=1,e},e.exports=i},function(e,a,t){"use strict";var r=t(1),c=t(125),n=t(94).from,i=(0,t(94).alloc)(0),f=t(58);function o(){c.call(this),this._content=i}r.inherits(o,c),o.prototype.getContent=function(){return this.setATime(new Date),this._content},o.prototype.setContent=function(e){if("string"==typeof e)e=n(e);else if(!Buffer.isBuffer(e))throw new Error("File content must be a string or buffer");this._content=e;var a=Date.now();this.setCTime(new Date(a)),this.setMTime(new Date(a))},o.prototype.getStats=function(){var e=this._content.length,a=c.prototype.getStats.call(this);return a.mode=this.getMode()|f.S_IFREG,a.size=e,a.blocks=Math.ceil(e/512),a},e.exports=o},function(e,a,t){"use strict";var r=t(12),c=r.maybeWrapAsError,n=t(34),i=n.TimeoutError,f=n.OperationalError,o=r.haveGetters,d=t(67);var s,b=/^(?:name|message|stack|cause)$/;function u(e){var a;if(function(e){return e instanceof Error&&d.getPrototypeOf(e)===Error.prototype}(e)){(a=new f(e)).name=e.name,a.message=e.message,a.stack=e.stack;for(var t=d.keys(e),c=0;c<t.length;++c){var n=t[c];b.test(n)||(a[n]=e[n])}return a}return r.markAsOriginatingFromRejection(e),e}function l(e){return function(a,t){if(null!==e){if(a){var r=u(c(a));e._attachExtraTrace(r),e._reject(r)}else if(arguments.length>2){for(var n=arguments.length,i=new Array(n-1),f=1;f<n;++f)i[f-1]=arguments[f];e._fulfill(i)}else e._fulfill(t);e=null}}}if(s=o?function(e){this.promise=e}:function(e){this.promise=e,this.asCallback=l(e),this.callback=this.asCallback},o){var p={get:function(){return l(this.promise)}};d.defineProperty(s.prototype,"asCallback",p),d.defineProperty(s.prototype,"callback",p)}s._nodebackForPromise=l,s.prototype.toString=function(){return"[object PromiseResolver]"},s.prototype.resolve=s.prototype.fulfill=function(e){if(!(this instanceof s))throw new TypeError("Illegal invocation, resolver resolve/reject must be called within a resolver context. Consider using the promise constructor instead.\n\n    See http://goo.gl/sdkXL9\n");this.promise._resolveCallback(e)},s.prototype.reject=function(e){if(!(this instanceof s))throw new TypeError("Illegal invocation, resolver resolve/reject must be called within a resolver context. Consider using the promise constructor instead.\n\n    See http://goo.gl/sdkXL9\n");this.promise._rejectCallback(e)},s.prototype.progress=function(e){if(!(this instanceof s))throw new TypeError("Illegal invocation, resolver resolve/reject must be called within a resolver context. Consider using the promise constructor instead.\n\n    See http://goo.gl/sdkXL9\n");this.promise._progress(e)},s.prototype.cancel=function(e){this.promise.cancel(e)},s.prototype.timeout=function(){this.reject(new i("timeout"))},s.prototype.isResolved=function(){return this.promise.isResolved()},s.prototype.toJSON=function(){return this.promise.toJSON()},e.exports=s},function(e,a,t){var r=t(4),c=t(96);e.exports=function(e,a){e=r(e),a=a||c;for(var t,n,i=e.length-1,f=a.length,o=!0;o&&i>=0;)for(o=!1,t=-1,n=e.charAt(i);++t<f;)if(n===a[t]){o=!0,i--;break}return i>=0?e.substring(0,i+1):""}},function(e,a,t){var r=t(4),c=t(96);e.exports=function(e,a){e=r(e),a=a||c;for(var t,n,i=0,f=e.length,o=a.length,d=!0;d&&i<f;)for(d=!1,t=-1,n=e.charAt(i);++t<o;)if(n===a[t]){d=!0,i++;break}return i>=f?"":e.substr(i,f)}},function(e,a,t){var r=t(4),c=t(128);e.exports=function(e,a,t,n){return e=r(e),t=t||"...",a=n?a+1:a,(e=c(e)).length<=a?e:(e=e.substr(0,a-t.length),(e=n?e.substr(0,e.lastIndexOf(" ")):c(e))+t)}},function(e,a,t){var r=t(4),c=t(130),n=t(129),i=t(68),f=t(95);e.exports=function(e){return e=r(e),e=c(e),e=n(e).replace(/[\-_]/g," ").replace(/\s[a-z]/g,i).replace(/\s+/g,"").replace(/^[A-Z]/g,f)}},function(e,a,t){var r=t(132),c="0123456789abcdef".split("");e.exports=function(e){e=e&&e>0?e:6;for(var a="";e--;)a+=r(c);return a}},function(e,a,t){var r=t(133),c=t(31),n=t(55);e.exports=function(e,a){for(var t,i,f,o,d=(e||"").replace("?","").split("&"),s=-1,b={};i=d[++s];)t=i.indexOf("="),o=i.substring(0,t),f=decodeURIComponent(i.substring(t+1)),!1!==a&&(f=r(f)),n(b,o)?c(b[o])?b[o].push(f):b[o]=[b[o],f]:b[o]=f;return b}},function(e,a,t){var r=t(47);e.exports=function(e,a){return a?(r(a.split("."),function(a){e[a]||(e[a]={}),e=e[a]}),e):e}},function(e,a,t){var r=t(16),c=t(14);e.exports=function(e,a,t){a=c(a,t);var n={};return r(e,function(e,t,r){n[t]=a(e,t,r)}),n}},function(e,a,t){var r,c=t(134);e.exports=function(e,a){return c(e,a)!==r}},function(e,a,t){var r=t(16),c=t(14);e.exports=function(e,a,t){a=c(a,t);var n={};return r(e,function(e,t,r){a(e,t,r)&&(n[t]=e)}),n}},function(e,a,t){var r=t(152);e.exports=function(e){var a=[];return r(e,function(e,t){"function"==typeof e&&a.push(t)}),a.sort()}},function(e,a){e.exports=function(e){var a=e%100;if(a>=10&&a<=20)return"th";switch(e%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}}},function(e,a,t){var r=t(70);e.exports=function(e,a){e=r(e);var t=Math.pow(10,a);return+(Math.round(e*t)/t).toFixed(a)}},function(e,a){e.exports=function(e,a,t){if(e<a||e>t)throw new RangeError("value ("+e+") must be between "+a+" and "+t);return e===t?1:(e-a)/(t-a)}},function(e,a){e.exports=function(e,a,t){return a+(t-a)*e}},function(e,a){e.exports=function(e,a,t){return e<a?a:e>t?t:e}},function(e,a,t){var r=t(35);e.exports=function(e){return r(e,"String")}},function(e,a){e.exports=function(e){switch(typeof e){case"string":case"number":case"boolean":return!0}return null==e}},function(e,a){e.exports=function(e){return"number"==typeof e&&e!=e}},function(e,a,t){var r=t(55),c=t(146),n=t(71),i=t(73);function f(e,a){return r(this,a)}e.exports=function(e,a,t){return t=t||i,n(e)&&n(a)?c(e,function(e){return function(a,t){return r(this,t)&&e(a,this[t])}}(t),a)&&c(a,f,e):t(e,a)}},function(e,a,t){var r=t(142),c=t(16),n=t(76),i=t(53);function f(e,a){switch(n(e)){case"Object":return function(e,a){if(i(e)){var t={};return c(e,function(e,t){this[t]=f(e,a)},t),t}return a?a(e):e}(e,a);case"Array":return function(e,a){var t=[],r=-1,c=e.length;for(;++r<c;)t[r]=f(e[r],a);return t}(e,a);default:return r(e)}}e.exports=f},function(e,a,t){var r=t(99);e.exports=function(e,a){function t(){}return t.prototype=e,r(new t,a)}},function(e,a,t){var r=t(22);function c(e){var a=r(arguments,1);return function(){for(var t=a.concat(r(arguments)),n=t.length;n--;)t[n]===c._&&(t[n]=t.splice(-1)[0]);return e.apply(this,t)}}c._={},e.exports=c},function(e,a,t){var r=t(22);e.exports=function(e,a,t){var c=r(arguments,2);return function(){return e.apply(a,c.concat(r(arguments)))}}},function(e,a,t){var r=t(22);e.exports=function(e,a,t){var c=r(arguments,3);return setTimeout(function(){e.apply(t,c)},a)}},function(e,a,t){e.exports={awaitDelay:t(597),bind:t(236),compose:t(596),constant:t(595),debounce:t(594),func:t(593),identity:t(154),makeIterator_:t(14),partial:t(235),prop:t(153),series:t(592),throttle:t(591),timeout:t(237),times:t(590),wrap:t(589)}},function(e,a,t){var r=t(144);e.exports=function(e,a){a=null==a?0:a;var t=r(e),c=6-a-(7+e.getDay()-a)%7;return Math.floor((t+c)/7)}},function(e,a,t){var r=t(138);e.exports=function(e){var a=/\(([A-Z]{3,4})\)/.exec(e.toString());return a?a[1]:r(e)}},function(e,a,t){var r=t(142);e.exports=function(e,a){switch(e=r(e),a){case"year":e.setMonth(0);case"month":e.setDate(1);case"week":case"day":e.setHours(0);case"hour":e.setMinutes(0);case"minute":e.setSeconds(0);case"second":e.setMilliseconds(0);break;default:throw new Error('"'+a+'" is not a valid period')}if("week"===a){var t=e.getDay(),c=e.getDate();t&&(t>=c&&e.setDate(0),e.setDate(e.getDate()-e.getDay()))}return e}},function(e,a,t){var r=t(99),c=t(602),n=r({},c,{set:function(e){r(n,e)}});e.exports=n},function(e,a){function t(e){switch(e){case"ms":case"millisecond":return 1;case"s":case"second":return 1e3;case"m":case"minute":return 6e4;case"h":case"hour":return 36e5;case"d":case"day":return 864e5;case"w":case"week":return 6048e5;default:throw new Error('"'+e+'" is not a valid unit')}}e.exports=function(e,a,r){return r=r||"ms",e*t(a)/t(r)}},function(e,a,t){var r=t(143);e.exports=function(e){return r(e)?366:365}},function(e,a,t){var r=t(100),c=t(143),n=[31,28,31,30,31,30,31,31,30,31,30,31];e.exports=function(e,a){return r(e)&&(a=e.getMonth()),1===a&&c(e)?29:n[a]}},function(e,a,t){var r=t(16),c=t(145);e.exports=function(e,a,t,n){var i=arguments.length>2;if(!c(e)&&!i)throw new Error("reduce of empty object with no initial value");return r(e,function(e,r,c){i?t=a.call(n,t,e,r,c):(t=e,i=!0)}),t}},function(e,a,t){var r=t(150),c=t(101);e.exports=function(e,a){return r(c(e),a)}},function(e,a,t){var r=t(105),c=t(101);e.exports=function(e,a){return r(c(e),a)}},function(e,a,t){var r=t(71),c=t(101),n=t(106),i=t(14);e.exports=function(e,a,t){return a=i(a,t),r(e)&&null==e.length&&(e=c(e)),n(e,function(e,t,r){return a(e,t,r)})}},function(e,a,t){var r=t(102),c=t(14);e.exports=function(e,a,t){var n;return a=c(a,t),r(e,function(e,t,r){if(a(e,t,r))return n=e,!0}),n}},function(e,a,t){var r=t(38),c=t(47),n=t(16);e.exports=r(c,n)},function(e,a,t){var r=t(251),c=t(14);e.exports=function(e,a,t){a=c(a,t);var n=[];return e?(r(e,function(e,t,r){a(e,t,r)&&(n[n.length]=e)}),n):n}},function(e,a,t){var r=t(102);e.exports=function(e,a){return r(e,function(e){return e===a})}},function(e,a){function t(e,a){return e<a?-1:e>a?1:0}e.exports=function e(a,r){return null==a?[]:a.length<2?a:(null==r&&(r=t),c=~~(a.length/2),function(e,a,t){for(var r=[];e.length&&a.length;)t(e[0],a[0])<=0?r.push(e.shift()):r.push(a.shift());return e.length&&r.push.apply(r,e),a.length&&r.push.apply(r,a),r}(e(a.slice(0,c),r),e(a.slice(c,a.length),r),r));var c}},function(e,a){e.exports=function(e,a,t){var r=arguments.length>2,c=t;if(null==e||!e.length){if(r)return t;throw new Error("reduce of empty array with no initial value")}for(var n=-1,i=e.length;++n<i;)r?c=a(c,e[n],n,e):(c=e[n],r=!0);return c}},function(e,a,t){var r=t(148),c=t(149),n=t(104);e.exports=function(e,a){return(e=null==e?c:e)+((a=null==a?n:a)-e)*r()}},function(e,a,t){var r=t(48);function c(e){return null!=e&&""!==e}e.exports=function(e,a){return a=a||"",r(e,c).join(a)}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){if(a=r(a,t),null==e)return-1;for(var c=e.length;--c>=0;)if(a(e[c],c,e))return c;return-1}},function(e,a,t){var r=t(14);e.exports=function(e,a,t){if(a=r(a,t),null==e)return-1;for(var c=-1,n=e.length;++c<n;)if(a(e[c],c,e))return c;return-1}},function(e,a,t){var r=t(73),c=t(31),n=t(107);e.exports=function(e,a,t){return t=t||r,c(e)&&c(a)?e.length===a.length&&n(e,function(e){return function(a,t){return t in this&&e(a,this[t])}}(t),a):t(e,a)}},function(e,a,t){var r=t(74),c=t(48),n=t(108),i=t(54),f=t(22);e.exports=function(e){var a=f(arguments,1);return c(r(e),function(e){return!n(a,function(a){return i(a,e)})})}},function(e,a,t){var r=t(16),c=t(31);function n(e,a){for(var t=-1,r=e.length;++t<r;)if(i(e[t],a))return!0;return!1}function i(e,a){return e&&"object"==typeof e?c(e)&&c(a)?function(e,a){for(var t=-1,r=a.length;++t<r;)if(!n(e,a[t]))return!1;return!0}(e,a):function(e,a){var t=!0;return r(a,function(a,r){if(!i(e[r],a))return t=!1}),t}(e,a):e===a}e.exports=i},function(e,a,t){e.exports=o;var r=t(0),c=t(278);r(o,c);var n=t(41),i=t(2),f=t(111);function o(e){var a=this;if(!(a instanceof o))return new o(e);a.fields=e;var t={path:("PaxHeader"+i.join("/",e.path||"")).replace(/\\/g,"/").substr(0,100),mode:e.mode||438,uid:e.uid||0,gid:e.gid||0,size:0,mtime:e.mtime||Date.now()/1e3,type:"x",linkpath:"",ustar:"ustar\0",ustarver:"00",uname:e.uname||"",gname:e.gname||"",devmaj:e.devmaj||0,devmin:e.devmin||0};c.call(a,t),a.props=t,a._meta=!0}function d(e,a,t){if(e.charAt(0)===e.charAt(0).toLowerCase()){var r=e.split(".")[0];n.knownExtended[r]||(e="NODETAR."+e)}if(t&&e.charAt(0)!==e.charAt(0).toLowerCase())return[];"number"==typeof val&&(val=val.toString(10));var c=new Buffer(" "+e+"="+a+"\n"),i=Math.floor(Math.log(c.length)/Math.log(10))+1;c.length+i>=Math.pow(10,i)&&(i+=1);var f=i+c.length,o=new Buffer(""+f);if(o.length+c.length!==f)throw new Error("Bad length calculation\nlen="+f+"\nlenBuf="+JSON.stringify(o.toString())+"\nlenBuf.length="+o.length+"\ndigits="+i+"\ns="+JSON.stringify(c.toString())+"\ns.length="+c.length);return[o,c]}o.prototype.end=function(){var e=this;if(!e._ended){if(e._ended=!0,e._encodeFields(),0===e.props.size)return e._ready=!0,void e._stream.end();e._stream.write(f.encode(e.props)),e.body.forEach(function(a){e._stream.write(a)}),e._ready=!0,this._stream.end()}},o.prototype._encodeFields=function(){this.body=[],this.fields.prefix&&(this.fields.path=this.fields.prefix+"/"+this.fields.path,this.fields.prefix=""),function e(a,t,r,c){Object.keys(a).forEach(function(i){var f=a[i];n.numeric[i];if(t&&(i=t+"."+i),i!==a.type||!0!==f){switch(i){case"mode":case"cksum":case"ustar":case"ustarver":case"prefix":case"basename":case"dirname":case"needExtended":case"block":case"filter":return;case"rdev":if(0===f)return;break;case"nlink":case"dev":case"ino":i="SCHILY."+i}if(f&&"object"==typeof f&&!Buffer.isBuffer(f))e(f,i,r,c);else{if(null===f||void 0===f)return;r.push.apply(r,d(i,f,c))}}});return r}(this.fields,"",this.body,this.fields.noProprietary);var e=this;this.body.forEach(function(a){e.props.size+=a.length})}},function(e,a,t){e.exports=i;var r=t(6).Stream,c=t(0),n=t(11).ok;process.env.DEBUG&&console.error;function i(e,a){if(this.writable=this.readable=!0,this._opt=a||{},this._chunkSize=e||512,this._offset=0,this._buffer=[],this._bufferLength=0,this._opt.nopad)this._zeroes=!1;else{this._zeroes=new Buffer(this._chunkSize);for(var t=0;t<this._chunkSize;t++)this._zeroes[t]=0}}c(i,r),i.prototype.write=function(e){if(this._ended)throw new Error("BlockStream: write after end");if(e&&!Buffer.isBuffer(e)&&(e=new Buffer(e+"")),e.length&&(this._buffer.push(e),this._bufferLength+=e.length),this._bufferLength>=this._chunkSize){if(this._paused)return this._needDrain=!0,!1;this._emitChunk()}return!0},i.prototype.pause=function(){this._paused=!0},i.prototype.resume=function(){return this._paused=!1,this._emitChunk()},i.prototype.end=function(e){"function"==typeof e&&(cb=e,e=null),e&&this.write(e),this._ended=!0,this.flush()},i.prototype.flush=function(){this._emitChunk(!0)},i.prototype._emitChunk=function(e){if(e&&this._zeroes){var a=this._bufferLength%this._chunkSize;0!==a&&(a=this._chunkSize-a),a>0&&(this._buffer.push(this._zeroes.slice(0,a)),this._bufferLength+=a)}if(!this._emitting&&!this._paused){this._emitting=!0;for(var t=0;this._bufferLength>=this._chunkSize&&(e||!this._paused);){for(var r=0,c=this._chunkSize;c>0&&(e||!this._paused);){var i=(s=this._buffer[t]).length-this._offset;o||i<c?(o=o||new Buffer(this._chunkSize),s.copy(o,r,this._offset,this._offset+Math.min(i,c))):o=s.length===c&&0===this._offset?s:s.slice(this._offset,this._offset+c),i>c?(this._offset+=c,c=0):(c-=i,r+=i,t++,this._offset=0)}this._bufferLength-=this._chunkSize,n(o.length===this._chunkSize),this.emit("data",o),o=null}if(this._buffer=this._buffer.slice(t),this._paused)return this._needsDrain=!0,void(this._emitting=!1);var f=this._buffer.length;if(e&&!this._zeroes&&f){if(1===f)this._offset?this.emit("data",this._buffer[0].slice(this._offset)):this.emit("data",this._buffer[0]);else{c=this._bufferLength;for(var o=new Buffer(c),d=(r=0,0);d<f;d++){var s;i=(s=this._buffer[d]).length-this._offset;s.copy(o,r,this._offset),this._offset=0,r+=i,this._bufferLength-=i}this.emit("data",o)}this._buffer.length=0,this._bufferLength=0,this._offset=0}this._needDrain&&(this._needDrain=!1,this.emit("drain")),0===this._bufferLength&&this._ended&&!this._endEmitted&&(this._endEmitted=!0,this.emit("end")),this._emitting=!1}}},function(e,a,t){e.exports=o;var r=t(78),c=t(109),n=t(0),i=t(155),f=t(15);function o(e){if(!(this instanceof o))throw new Error("ProxyWriter must be called as constructor.");this.props=e,this._needDrain=!1,r.call(this,e)}n(o,r),o.prototype._stat=function(){var e=this,a=e.props,t=a.follow?"stat":"lstat";f[t](a.path,function(t,n){var i;i=t||!n?"File":c(n),a[i]=!0,a.type=e.type=i,e._old=n,e._addProxy(r(a,n))})},o.prototype._addProxy=function(e){var a=this;if(a._proxy)return a.error("proxy already set");a._proxy=e,["ready","error","close","pipe","drain","warn"].forEach(function(t){e.on(t,a.emit.bind(a,t))}),a.emit("proxy",e),a._buffer.forEach(function(a){e[a[0]].apply(e,a[1])}),a._buffer.length=0,a._needsDrain&&a.emit("drain")},o.prototype.add=function(e){return i(e),this._proxy?this._proxy.add(e):(this._buffer.push(["add",[e]]),this._needDrain=!0,!1)},o.prototype.write=function(e){return this._proxy?this._proxy.write(e):(this._buffer.push(["write",[e]]),this._needDrain=!0,!1)},o.prototype.end=function(e){return this._proxy?this._proxy.end(e):(this._buffer.push(["end",[e]]),!1)}},function(e,a,t){e.exports=i;var r=t(8),c=t(78),n={};function i(e){if(!(this instanceof i))throw new Error("FileWriter must be called as constructor.");if("File"!==e.type||!e.File)throw new Error("Non-file type "+e.type);this._buffer=[],this._bytesWritten=0,c.call(this,e)}t(0)(i,c),i.prototype._create=function(){var e=this;if(!e._stream){var a={};e.props.flags&&(a.flags=e.props.flags),a.mode=c.filemode,e._old&&e._old.blksize&&(a.bufferSize=e._old.blksize),e._stream=r.createWriteStream(e._path,a),e._stream.on("open",function(){e.ready=!0,e._buffer.forEach(function(a){a===n?e._stream.end():e._stream.write(a)}),e.emit("ready"),e.emit("drain")}),e._stream.on("error",function(a){e.emit("error",a)}),e._stream.on("drain",function(){e.emit("drain")}),e._stream.on("close",function(){e._finish()})}},i.prototype.write=function(e){if(this._bytesWritten+=e.length,!this.ready){if(!Buffer.isBuffer(e)&&"string"!=typeof e)throw new Error("invalid write data");return this._buffer.push(e),!1}var a=this._stream.write(e);return!1===a&&this._stream._queue?this._stream._queue.length<=2:a},i.prototype.end=function(e){return e&&this.write(e),this.ready?this._stream.end():(this._buffer.push(n),!1)},i.prototype._finish=function(){"number"==typeof this.size&&this._bytesWritten!==this.size&&this.error("Did not get expected byte count.\nexpect: "+this.size+"\nactual: "+this._bytesWritten),c.prototype._finish.call(this)}},function(e,a,t){e.exports=o;var r=t(8),c=t(78),n=t(0),i=t(2),f=t(273);function o(e){if(!(this instanceof o))throw new Error("LinkWriter must be called as constructor.");if(!("Link"===e.type&&e.Link||"SymbolicLink"===e.type&&e.SymbolicLink))throw new Error("Non-link type "+e.type);""===e.linkpath&&(e.linkpath="."),e.linkpath||this.error("Need linkpath property to create "+e.type),c.call(this,e)}function d(e,a,t){f(e._path,function(c){if(c)return e.error(c);!function(e,a,t){r[t](a,e._path,function(a){if(a){if("ENOENT"!==a.code&&"EACCES"!==a.code&&"EPERM"!==a.code||"win32"!==process.platform)return e.error(a);e.ready=!0,e.emit("ready"),e.emit("end"),e.emit("close"),e.end=e._finish=function(){}}s(e)})}(e,a,t)})}function s(e){e.ready=!0,e.emit("ready"),e._ended&&!e._finished&&e._finish()}n(o,c),o.prototype._create=function(){var e=this,a="Link"===e.type||"win32"===process.platform,t=a?"link":"symlink",c=a?i.resolve(e.dirname,e.linkpath):e.linkpath;if(a)return d(e,c,t);r.readlink(e._path,function(a,r){if(r&&r===c)return s(e);d(e,c,t)})},o.prototype.end=function(){this._ended=!0,this.ready&&(this._finished=!0,this._finish())}},function(e,a,t){e.exports=o;var r=t(78),c=t(0),n=t(160),i=t(2),f=t(155);function o(e){this instanceof o||this.error("DirWriter must be called as constructor.",null,!0),"Directory"===e.type&&e.Directory||this.error("Non-directory type "+e.type+" "+JSON.stringify(e),null,!0),r.call(this,e)}c(o,r),o.prototype._create=function(){var e=this;n(e._path,r.dirmode,function(a){if(a)return e.error(a);e.ready=!0,e.emit("ready"),e._process()})},o.prototype.write=function(){return!0},o.prototype.end=function(){this._ended=!0,this._process()},o.prototype.add=function(e){return f(e),!this.ready||this._currentEntry?(this._buffer.push(e),!1):this._ended?this.error("add after end"):(this._buffer.push(e),this._process(),0===this._buffer.length)},o.prototype._process=function(){var e=this;if(!e._processing){var a=e._buffer.shift();if(!a)return e.emit("drain"),void(e._ended&&e._finish());e._processing=!0,e.emit("entry",a);var t,c=a;do{if((t=c._path||c.path)===e.root._path||t===e._path||t&&0===t.indexOf(e._path))return e._processing=!1,a._collected&&a.pipe(),e._process();c=c.parent}while(c);var n={parent:e,root:e.root||e,type:a.type,depth:e.depth+1};t=a._path||a.path||a.props.path,a.parent&&(t=t.substr(a.parent._path.length+1)),n.path=i.join(e.path,i.join("/",t)),n.filter=e.filter,Object.keys(a.props).forEach(function(e){n.hasOwnProperty(e)||(n[e]=a.props[e])});var f=e._currentChild=new r(n);f.on("ready",function(){a.pipe(f),a.resume()}),f.on("error",function(a){f._swallowErrors?(e.warn(a),f.emit("end"),f.emit("close")):e.emit("error",a)}),f.on("close",function(){if(o)return;o=!0,e._currentChild=null,e._processing=!1,e._process()});var o=!1}}},function(e,a){e.exports=function e(a,t){if(a&&t)return e(a)(t);if("function"!=typeof a)throw new TypeError("need wrapper function");Object.keys(a).forEach(function(e){r[e]=a[e]});return r;function r(){for(var e=new Array(arguments.length),t=0;t<e.length;t++)e[t]=arguments[t];var r=a.apply(this,e),c=e[e.length-1];return"function"==typeof r&&r!==c&&Object.keys(c).forEach(function(e){r[e]=c[e]}),r}}},function(e,a,t){function r(e,a){return Object.prototype.hasOwnProperty.call(e,a)}a.alphasort=d,a.alphasorti=o,a.setopts=function(e,a,t){t||(t={});if(t.matchBase&&-1===a.indexOf("/")){if(t.noglobstar)throw new Error("base matching requires globstar");a="**/"+a}e.silent=!!t.silent,e.pattern=a,e.strict=!1!==t.strict,e.realpath=!!t.realpath,e.realpathCache=t.realpathCache||Object.create(null),e.follow=!!t.follow,e.dot=!!t.dot,e.mark=!!t.mark,e.nodir=!!t.nodir,e.nodir&&(e.mark=!0);e.sync=!!t.sync,e.nounique=!!t.nounique,e.nonull=!!t.nonull,e.nosort=!!t.nosort,e.nocase=!!t.nocase,e.stat=!!t.stat,e.noprocess=!!t.noprocess,e.absolute=!!t.absolute,e.maxLength=t.maxLength||1/0,e.cache=t.cache||Object.create(null),e.statCache=t.statCache||Object.create(null),e.symlinks=t.symlinks||Object.create(null),function(e,a){e.ignore=a.ignore||[],Array.isArray(e.ignore)||(e.ignore=[e.ignore]);e.ignore.length&&(e.ignore=e.ignore.map(s))}(e,t),e.changedCwd=!1;var n=process.cwd();r(t,"cwd")?(e.cwd=c.resolve(t.cwd),e.changedCwd=e.cwd!==n):e.cwd=n;e.root=t.root||c.resolve(e.cwd,"/"),e.root=c.resolve(e.root),"win32"===process.platform&&(e.root=e.root.replace(/\\/g,"/"));e.cwdAbs=i(e.cwd)?e.cwd:b(e,e.cwd),"win32"===process.platform&&(e.cwdAbs=e.cwdAbs.replace(/\\/g,"/"));e.nomount=!!t.nomount,t.nonegate=!0,t.nocomment=!0,e.minimatch=new f(a,t),e.options=e.minimatch.options},a.ownProp=r,a.makeAbs=b,a.finish=function(e){for(var a=e.nounique,t=a?[]:Object.create(null),r=0,c=e.matches.length;r<c;r++){var n=e.matches[r];if(n&&0!==Object.keys(n).length){var i=Object.keys(n);a?t.push.apply(t,i):i.forEach(function(e){t[e]=!0})}else if(e.nonull){var f=e.minimatch.globSet[r];a?t.push(f):t[f]=!0}}a||(t=Object.keys(t));e.nosort||(t=t.sort(e.nocase?o:d));if(e.mark){for(var r=0;r<t.length;r++)t[r]=e._mark(t[r]);e.nodir&&(t=t.filter(function(a){var t=!/\/$/.test(a),r=e.cache[a]||e.cache[b(e,a)];return t&&r&&(t="DIR"!==r&&!Array.isArray(r)),t}))}e.ignore.length&&(t=t.filter(function(a){return!u(e,a)}));e.found=t},a.mark=function(e,a){var t=b(e,a),r=e.cache[t],c=a;if(r){var n="DIR"===r||Array.isArray(r),i="/"===a.slice(-1);if(n&&!i?c+="/":!n&&i&&(c=c.slice(0,-1)),c!==a){var f=b(e,c);e.statCache[f]=e.statCache[t],e.cache[f]=e.cache[t]}}return c},a.isIgnored=u,a.childrenIgnored=function(e,a){return!!e.ignore.length&&e.ignore.some(function(e){return!(!e.gmatcher||!e.gmatcher.match(a))})};var c=t(2),n=t(158),i=t(157),f=n.Minimatch;function o(e,a){return e.toLowerCase().localeCompare(a.toLowerCase())}function d(e,a){return e.localeCompare(a)}function s(e){var a=null;if("/**"===e.slice(-3)){var t=e.replace(/(\/\*\*)+$/,"");a=new f(t,{dot:!0})}return{matcher:new f(e,{dot:!0}),gmatcher:a}}function b(e,a){var t=a;return t="/"===a.charAt(0)?c.join(e.root,a):i(a)||""===a?a:e.changedCwd?c.resolve(e.cwd,a):c.resolve(a),"win32"===process.platform&&(t=t.replace(/\\/g,"/")),t}function u(e,a){return!!e.ignore.length&&e.ignore.some(function(e){return e.matcher.match(a)||!(!e.gmatcher||!e.gmatcher.match(a))})}},function(e,a,t){e.exports=s,s.realpath=s,s.sync=b,s.realpathSync=b,s.monkeypatch=function(){r.realpath=s,r.realpathSync=b},s.unmonkeypatch=function(){r.realpath=c,r.realpathSync=n};var r=t(15),c=r.realpath,n=r.realpathSync,i=process.version,f=/^v[0-5]\./.test(i),o=t(655);function d(e){return e&&"realpath"===e.syscall&&("ELOOP"===e.code||"ENOMEM"===e.code||"ENAMETOOLONG"===e.code)}function s(e,a,t){if(f)return c(e,a,t);"function"==typeof a&&(t=a,a=null),c(e,a,function(r,c){d(r)?o.realpath(e,a,t):t(r,c)})}function b(e,a){if(f)return n(e,a);try{return n(e,a)}catch(t){if(d(t))return o.realpathSync(e,a);throw t}}},function(e,a,t){e.exports=y;var r=t(15),c=t(271),n=t(158),i=(n.Minimatch,t(0)),f=t(5).EventEmitter,o=t(2),d=t(11),s=t(157),b=t(651),u=t(270),l=(u.alphasort,u.alphasorti,u.setopts),p=u.ownProp,h=t(650),m=(t(1),u.childrenIgnored),g=u.isIgnored,v=t(156);function y(e,a,t){if("function"==typeof a&&(t=a,a={}),a||(a={}),a.sync){if(t)throw new TypeError("callback provided to sync glob");return b(e,a)}return new w(e,a,t)}y.sync=b;var _=y.GlobSync=b.GlobSync;function w(e,a,t){if("function"==typeof a&&(t=a,a=null),a&&a.sync){if(t)throw new TypeError("callback provided to sync glob");return new _(e,a)}if(!(this instanceof w))return new w(e,a,t);l(this,e,a),this._didRealPath=!1;var r=this.minimatch.set.length;this.matches=new Array(r),"function"==typeof t&&(t=v(t),this.on("error",t),this.on("end",function(e){t(null,e)}));var c=this;if(this._processing=0,this._emitQueue=[],this._processQueue=[],this.paused=!1,this.noprocess)return this;if(0===r)return f();for(var n=!0,i=0;i<r;i++)this._process(this.minimatch.set[i],i,!1,f);function f(){--c._processing,c._processing<=0&&(n?process.nextTick(function(){c._finish()}):c._finish())}n=!1}y.glob=y,y.hasMagic=function(e,a){var t=function(e,a){if(null===a||"object"!=typeof a)return e;for(var t=Object.keys(a),r=t.length;r--;)e[t[r]]=a[t[r]];return e}({},a);t.noprocess=!0;var r=new w(e,t).minimatch.set;if(!e)return!1;if(r.length>1)return!0;for(var c=0;c<r[0].length;c++)if("string"!=typeof r[0][c])return!0;return!1},y.Glob=w,i(w,f),w.prototype._finish=function(){if(d(this instanceof w),!this.aborted){if(this.realpath&&!this._didRealpath)return this._realpath();u.finish(this),this.emit("end",this.found)}},w.prototype._realpath=function(){if(!this._didRealpath){this._didRealpath=!0;var e=this.matches.length;if(0===e)return this._finish();for(var a=this,t=0;t<this.matches.length;t++)this._realpathSet(t,r)}function r(){0==--e&&a._finish()}},w.prototype._realpathSet=function(e,a){var t=this.matches[e];if(!t)return a();var r=Object.keys(t),n=this,i=r.length;if(0===i)return a();var f=this.matches[e]=Object.create(null);r.forEach(function(t,r){t=n._makeAbs(t),c.realpath(t,n.realpathCache,function(r,c){r?"stat"===r.syscall?f[t]=!0:n.emit("error",r):f[c]=!0,0==--i&&(n.matches[e]=f,a())})})},w.prototype._mark=function(e){return u.mark(this,e)},w.prototype._makeAbs=function(e){return u.makeAbs(this,e)},w.prototype.abort=function(){this.aborted=!0,this.emit("abort")},w.prototype.pause=function(){this.paused||(this.paused=!0,this.emit("pause"))},w.prototype.resume=function(){if(this.paused){if(this.emit("resume"),this.paused=!1,this._emitQueue.length){var e=this._emitQueue.slice(0);this._emitQueue.length=0;for(var a=0;a<e.length;a++){var t=e[a];this._emitMatch(t[0],t[1])}}if(this._processQueue.length){var r=this._processQueue.slice(0);this._processQueue.length=0;for(a=0;a<r.length;a++){var c=r[a];this._processing--,this._process(c[0],c[1],c[2],c[3])}}}},w.prototype._process=function(e,a,t,r){if(d(this instanceof w),d("function"==typeof r),!this.aborted)if(this._processing++,this.paused)this._processQueue.push([e,a,t,r]);else{for(var c,i=0;"string"==typeof e[i];)i++;switch(i){case e.length:return void this._processSimple(e.join("/"),a,r);case 0:c=null;break;default:c=e.slice(0,i).join("/")}var f,o=e.slice(i);null===c?f=".":s(c)||s(e.join("/"))?(c&&s(c)||(c="/"+c),f=c):f=c;var b=this._makeAbs(f);if(m(this,f))return r();o[0]===n.GLOBSTAR?this._processGlobStar(c,f,b,o,a,t,r):this._processReaddir(c,f,b,o,a,t,r)}},w.prototype._processReaddir=function(e,a,t,r,c,n,i){var f=this;this._readdir(t,n,function(o,d){return f._processReaddir2(e,a,t,r,c,n,d,i)})},w.prototype._processReaddir2=function(e,a,t,r,c,n,i,f){if(!i)return f();for(var d=r[0],s=!!this.minimatch.negate,b=d._glob,u=this.dot||"."===b.charAt(0),l=[],p=0;p<i.length;p++){if("."!==(m=i[p]).charAt(0)||u)(s&&!e?!m.match(d):m.match(d))&&l.push(m)}var h=l.length;if(0===h)return f();if(1===r.length&&!this.mark&&!this.stat){this.matches[c]||(this.matches[c]=Object.create(null));for(p=0;p<h;p++){var m=l[p];e&&(m="/"!==e?e+"/"+m:e+m),"/"!==m.charAt(0)||this.nomount||(m=o.join(this.root,m)),this._emitMatch(c,m)}return f()}r.shift();for(p=0;p<h;p++){m=l[p];e&&(m="/"!==e?e+"/"+m:e+m),this._process([m].concat(r),c,n,f)}f()},w.prototype._emitMatch=function(e,a){if(!this.aborted&&!g(this,a))if(this.paused)this._emitQueue.push([e,a]);else{var t=s(a)?a:this._makeAbs(a);if(this.mark&&(a=this._mark(a)),this.absolute&&(a=t),!this.matches[e][a]){if(this.nodir){var r=this.cache[t];if("DIR"===r||Array.isArray(r))return}this.matches[e][a]=!0;var c=this.statCache[t];c&&this.emit("stat",a,c),this.emit("match",a)}}},w.prototype._readdirInGlobStar=function(e,a){if(!this.aborted){if(this.follow)return this._readdir(e,!1,a);var t=this,c=h("lstat\0"+e,function(r,c){if(r&&"ENOENT"===r.code)return a();var n=c&&c.isSymbolicLink();t.symlinks[e]=n,n||!c||c.isDirectory()?t._readdir(e,!1,a):(t.cache[e]="FILE",a())});c&&r.lstat(e,c)}},w.prototype._readdir=function(e,a,t){if(!this.aborted&&(t=h("readdir\0"+e+"\0"+a,t))){if(a&&!p(this.symlinks,e))return this._readdirInGlobStar(e,t);if(p(this.cache,e)){var c=this.cache[e];if(!c||"FILE"===c)return t();if(Array.isArray(c))return t(null,c)}r.readdir(e,function(e,a,t){return function(r,c){r?e._readdirError(a,r,t):e._readdirEntries(a,c,t)}}(this,e,t))}},w.prototype._readdirEntries=function(e,a,t){if(!this.aborted){if(!this.mark&&!this.stat)for(var r=0;r<a.length;r++){var c=a[r];c="/"===e?e+c:e+"/"+c,this.cache[c]=!0}return this.cache[e]=a,t(null,a)}},w.prototype._readdirError=function(e,a,t){if(!this.aborted){switch(a.code){case"ENOTSUP":case"ENOTDIR":var r=this._makeAbs(e);if(this.cache[r]="FILE",r===this.cwdAbs){var c=new Error(a.code+" invalid cwd "+this.cwd);c.path=this.cwd,c.code=a.code,this.emit("error",c),this.abort()}break;case"ENOENT":case"ELOOP":case"ENAMETOOLONG":case"UNKNOWN":this.cache[this._makeAbs(e)]=!1;break;default:this.cache[this._makeAbs(e)]=!1,this.strict&&(this.emit("error",a),this.abort()),this.silent||console.error("glob error",a)}return t()}},w.prototype._processGlobStar=function(e,a,t,r,c,n,i){var f=this;this._readdir(t,n,function(o,d){f._processGlobStar2(e,a,t,r,c,n,d,i)})},w.prototype._processGlobStar2=function(e,a,t,r,c,n,i,f){if(!i)return f();var o=r.slice(1),d=e?[e]:[],s=d.concat(o);this._process(s,c,!1,f);var b=this.symlinks[t],u=i.length;if(b&&n)return f();for(var l=0;l<u;l++){if("."!==i[l].charAt(0)||this.dot){var p=d.concat(i[l],o);this._process(p,c,!0,f);var h=d.concat(i[l],r);this._process(h,c,!0,f)}}f()},w.prototype._processSimple=function(e,a,t){var r=this;this._stat(e,function(c,n){r._processSimple2(e,a,c,n,t)})},w.prototype._processSimple2=function(e,a,t,r,c){if(this.matches[a]||(this.matches[a]=Object.create(null)),!r)return c();if(e&&s(e)&&!this.nomount){var n=/[\/\\]$/.test(e);"/"===e.charAt(0)?e=o.join(this.root,e):(e=o.resolve(this.root,e),n&&(e+="/"))}"win32"===process.platform&&(e=e.replace(/\\/g,"/")),this._emitMatch(a,e),c()},w.prototype._stat=function(e,a){var t=this._makeAbs(e),c="/"===e.slice(-1);if(e.length>this.maxLength)return a();if(!this.stat&&p(this.cache,t)){var n=this.cache[t];if(Array.isArray(n)&&(n="DIR"),!c||"DIR"===n)return a(null,n);if(c&&"FILE"===n)return a()}var i=this.statCache[t];if(void 0!==i){if(!1===i)return a(null,i);var f=i.isDirectory()?"DIR":"FILE";return c&&"FILE"===f?a():a(null,f,i)}var o=this,d=h("stat\0"+t,function(c,n){if(n&&n.isSymbolicLink())return r.stat(t,function(r,c){r?o._stat2(e,t,null,n,a):o._stat2(e,t,r,c,a)});o._stat2(e,t,c,n,a)});d&&r.lstat(t,d)},w.prototype._stat2=function(e,a,t,r,c){if(t&&("ENOENT"===t.code||"ENOTDIR"===t.code))return this.statCache[a]=!1,c();var n="/"===e.slice(-1);if(this.statCache[a]=r,"/"===a.slice(-1)&&r&&!r.isDirectory())return c(null,!1,r);var i=!0;return r&&(i=r.isDirectory()?"DIR":"FILE"),this.cache[a]=this.cache[a]||i,n&&"FILE"===i?c():c(null,i,r)}},function(e,a,t){e.exports=u,u.sync=g;var r=t(11),c=t(2),n=t(15),i=t(272),f=parseInt("666",8),o={nosort:!0,silent:!0},d=0,s="win32"===process.platform;function b(e){["unlink","chmod","stat","lstat","rmdir","readdir"].forEach(function(a){e[a]=e[a]||n[a],e[a+="Sync"]=e[a]||n[a]}),e.maxBusyTries=e.maxBusyTries||3,e.emfileWait=e.emfileWait||1e3,!1===e.glob&&(e.disableGlob=!0),e.disableGlob=e.disableGlob||!1,e.glob=e.glob||o}function u(e,a,t){"function"==typeof a&&(t=a,a={}),r(e,"rimraf: missing path"),r.equal(typeof e,"string","rimraf: path should be a string"),r.equal(typeof t,"function","rimraf: callback function required"),r(a,"rimraf: invalid options argument provided"),r.equal(typeof a,"object","rimraf: options should be object"),b(a);var c=0,n=null,f=0;if(a.disableGlob||!i.hasMagic(e))return o(null,[e]);function o(e,r){return e?t(e):0===(f=r.length)?t():void r.forEach(function(e){l(e,a,function r(i){if(i){if(("EBUSY"===i.code||"ENOTEMPTY"===i.code||"EPERM"===i.code)&&c<a.maxBusyTries)return c++,setTimeout(function(){l(e,a,r)},100*c);if("EMFILE"===i.code&&d<a.emfileWait)return setTimeout(function(){l(e,a,r)},d++);"ENOENT"===i.code&&(i=null)}d=0,function(e){n=n||e,0==--f&&t(n)}(i)})})}a.lstat(e,function(t,r){if(!t)return o(null,[e]);i(e,a.glob,o)})}function l(e,a,t){r(e),r(a),r("function"==typeof t),a.lstat(e,function(r,c){return r&&"ENOENT"===r.code?t(null):(r&&"EPERM"===r.code&&s&&p(e,a,r,t),c&&c.isDirectory()?m(e,a,r,t):void a.unlink(e,function(r){if(r){if("ENOENT"===r.code)return t(null);if("EPERM"===r.code)return s?p(e,a,r,t):m(e,a,r,t);if("EISDIR"===r.code)return m(e,a,r,t)}return t(r)}))})}function p(e,a,t,c){r(e),r(a),r("function"==typeof c),t&&r(t instanceof Error),a.chmod(e,f,function(r){r?c("ENOENT"===r.code?null:t):a.stat(e,function(r,n){r?c("ENOENT"===r.code?null:t):n.isDirectory()?m(e,a,t,c):a.unlink(e,c)})})}function h(e,a,t){r(e),r(a),t&&r(t instanceof Error);try{a.chmodSync(e,f)}catch(e){if("ENOENT"===e.code)return;throw t}try{var c=a.statSync(e)}catch(e){if("ENOENT"===e.code)return;throw t}c.isDirectory()?v(e,a,t):a.unlinkSync(e)}function m(e,a,t,n){r(e),r(a),t&&r(t instanceof Error),r("function"==typeof n),a.rmdir(e,function(i){!i||"ENOTEMPTY"!==i.code&&"EEXIST"!==i.code&&"EPERM"!==i.code?i&&"ENOTDIR"===i.code?n(t):n(i):function(e,a,t){r(e),r(a),r("function"==typeof t),a.readdir(e,function(r,n){if(r)return t(r);var i,f=n.length;if(0===f)return a.rmdir(e,t);n.forEach(function(r){u(c.join(e,r),a,function(r){if(!i)return r?t(i=r):void(0==--f&&a.rmdir(e,t))})})})}(e,a,n)})}function g(e,a){var t;if(b(a=a||{}),r(e,"rimraf: missing path"),r.equal(typeof e,"string","rimraf: path should be a string"),r(a,"rimraf: missing options"),r.equal(typeof a,"object","rimraf: options should be object"),a.disableGlob||!i.hasMagic(e))t=[e];else try{a.lstatSync(e),t=[e]}catch(r){t=i.sync(e,a.glob)}if(t.length)for(var c=0;c<t.length;c++){e=t[c];try{var n=a.lstatSync(e)}catch(t){if("ENOENT"===t.code)return;"EPERM"===t.code&&s&&h(e,a,t)}try{n&&n.isDirectory()?v(e,a,null):a.unlinkSync(e)}catch(t){if("ENOENT"===t.code)return;if("EPERM"===t.code)return s?h(e,a,t):v(e,a,t);if("EISDIR"!==t.code)throw t;v(e,a,t)}}}function v(e,a,t){r(e),r(a),t&&r(t instanceof Error);try{a.rmdirSync(e)}catch(n){if("ENOENT"===n.code)return;if("ENOTDIR"===n.code)throw t;"ENOTEMPTY"!==n.code&&"EEXIST"!==n.code&&"EPERM"!==n.code||function(e,a){r(e),r(a),a.readdirSync(e).forEach(function(t){g(c.join(e,t),a)});var t=s?100:1,n=0;for(;;){var i=!0;try{var f=a.rmdirSync(e,a);return i=!1,f}finally{if(++n<t&&i)continue}}}(e,a)}}},function(e,a,t){e.exports=f;var r=t(56),c=t(109),n=t(0),i=t(8);function f(e){if(!(this instanceof f))throw new Error("ProxyReader must be called as constructor.");this.props=e,this._buffer=[],this.ready=!1,r.call(this,e)}n(f,r),f.prototype._stat=function(){var e=this,a=e.props,t=a.follow?"stat":"lstat";i[t](a.path,function(t,n){var i;i=t||!n?"File":c(n),a[i]=!0,a.type=e.type=i,e._old=n,e._addProxy(r(a,n))})},f.prototype._addProxy=function(e){var a=this;if(a._proxyTarget)return a.error("proxy already set");a._proxyTarget=e,e._proxy=a,["error","data","end","close","linkpath","entry","entryEnd","child","childEnd","warn","stat"].forEach(function(t){e.on(t,a.emit.bind(a,t))}),a.emit("proxy",e),e.on("ready",function(){a.ready=!0,a.emit("ready")});var t=a._buffer;a._buffer.length=0,t.forEach(function(a){e[a[0]].apply(e,a[1])})},f.prototype.pause=function(){return!!this._proxyTarget&&this._proxyTarget.pause()},f.prototype.resume=function(){return!!this._proxyTarget&&this._proxyTarget.resume()}},function(e,a,t){e.exports=o;var r=t(8),c=t(0),n=t(56),i={EOF:!0},f={CLOSE:!0};function o(e){if(!(this instanceof o))throw new Error("FileReader must be called as constructor.");if(!("Link"===e.type&&e.Link||"File"===e.type&&e.File))throw new Error("Non-file type "+e.type);this._buffer=[],this._bytesEmitted=0,n.call(this,e)}c(o,n),o.prototype._getStream=function(){var e=this,a=e._stream=r.createReadStream(e._path,e.props);e.props.blksize&&(a.bufferSize=e.props.blksize),a.on("open",e.emit.bind(e,"open")),a.on("data",function(a){e._bytesEmitted+=a.length,a.length&&(e._paused||e._buffer.length?(e._buffer.push(a),e._read()):e.emit("data",a))}),a.on("end",function(){e._paused||e._buffer.length?(e._buffer.push(i),e._read()):e.emit("end"),e._bytesEmitted!==e.props.size&&e.error("Didn't get expected byte count\nexpect: "+e.props.size+"\nactual: "+e._bytesEmitted)}),a.on("close",function(){e._paused||e._buffer.length?(e._buffer.push(f),e._read()):e.emit("close")}),a.on("error",function(a){e.emit("error",a)}),e._read()},o.prototype._read=function(){if(!this._paused){if(!this._stream)return this._getStream();if(this._buffer.length){for(var e=this._buffer,a=0,t=e.length;a<t;a++){var r=e[a];if(r===i?this.emit("end"):r===f?this.emit("close"):this.emit("data",r),this._paused)return void(this._buffer=e.slice(a))}this._buffer.length=0}}},o.prototype.pause=function(e){this._paused||(e=e||this,this._paused=!0,this._stream&&this._stream.pause(),this.emit("pause",e))},o.prototype.resume=function(e){this._paused&&(e=e||this,this.emit("resume",e),this._paused=!1,this._stream&&this._stream.resume(),this._read())}},function(e,a,t){e.exports=o;var r=t(8),c=t(0),n=t(2),i=t(56),f=t(11).ok;function o(e){if(!(this instanceof o))throw new Error("DirReader must be called as constructor.");if("Directory"!==e.type||!e.Directory)throw new Error("Non-directory type "+e.type);this.entries=null,this._index=-1,this._paused=!1,this._length=-1,e.sort&&(this.sort=e.sort),i.call(this,e)}c(o,i),o.prototype._getEntries=function(){var e=this;e._gotEntries||(e._gotEntries=!0,r.readdir(e._path,function(a,t){if(a)return e.error(a);function r(){e._length=e.entries.length,"function"==typeof e.sort&&(e.entries=e.entries.sort(e.sort.bind(e))),e._read()}e.entries=t,e.emit("entries",t),e._paused?e.once("resume",r):r()}))},o.prototype._read=function(){var e=this;if(!e.entries)return e._getEntries();if(!(e._paused||e._currentEntry||e._aborted))if(e._index++,e._index>=e.entries.length)e._ended||(e._ended=!0,e.emit("end"),e.emit("close"));else{var a=n.resolve(e._path,e.entries[e._index]);f(a!==e._path),f(e.entries[e._index]),e._currentEntry=a,r[e.props.follow?"stat":"lstat"](a,function(t,r){if(t)return e.error(t);var c=e._proxy||e;r.path=a,r.basename=n.basename(a),r.dirname=n.dirname(a);var f=e.getChildProps.call(c,r);f.path=a,f.basename=n.basename(a),f.dirname=n.dirname(a);var o=i(f,r);e._currentEntry=o,o.on("pause",function(a){e._paused||o._disowned||e.pause(a)}),o.on("resume",function(a){e._paused&&!o._disowned&&e.resume(a)}),o.on("stat",function(a){e.emit("_entryStat",o,a),o._aborted||(o._paused?o.once("resume",function(){e.emit("entryStat",o,a)}):e.emit("entryStat",o,a))}),o.on("ready",function a(){if(e._paused)return o.pause(e),e.once("resume",a);"Socket"===o.type?e.emit("socket",o):e.emitEntry(o)});var d=!1;function s(){d||(d=!0,e.emit("childEnd",o),e.emit("entryEnd",o),e._currentEntry=null,e._paused||e._read())}o.on("close",s),o.on("disown",s),o.on("error",function(a){o._swallowErrors?(e.warn(a),o.emit("end"),o.emit("close")):e.emit("error",a)}),["child","childEnd","warn"].forEach(function(a){o.on(a,e.emit.bind(e,a))})})}},o.prototype.disown=function(e){e.emit("beforeDisown"),e._disowned=!0,e.parent=e.root=null,e===this._currentEntry&&(this._currentEntry=null),e.emit("disown")},o.prototype.getChildProps=function(){return{depth:this.depth+1,root:this.root||this,parent:this,follow:this.follow,filter:this.filter,sort:this.props.sort,hardlinks:this.props.hardlinks}},o.prototype.pause=function(e){this._paused||(e=e||this,this._paused=!0,this._currentEntry&&this._currentEntry.pause&&this._currentEntry.pause(e),this.emit("pause",e))},o.prototype.resume=function(e){this._paused&&(e=e||this,this._paused=!1,this.emit("resume",e),this._paused||(this._currentEntry?this._currentEntry.resume&&this._currentEntry.resume(e):this._read()))},o.prototype.emitEntry=function(e){this.emit("entry",e),this.emit("child",e)}},function(e,a,t){e.exports=i;var r=t(8),c=t(0),n=t(56);function i(e){if(!(this instanceof i))throw new Error("LinkReader must be called as constructor.");if(!("Link"===e.type&&e.Link||"SymbolicLink"===e.type&&e.SymbolicLink))throw new Error("Non-link type "+e.type);n.call(this,e)}c(i,n),i.prototype._stat=function(e){var a=this;r.readlink(a._path,function(t,r){if(t)return a.error(t);a.linkpath=a.props.linkpath=r,a.emit("linkpath",r),n.prototype._stat.call(a,e)})},i.prototype._read=function(){this._paused||this._ended||(this.emit("end"),this.emit("close"),this._ended=!0)}},function(e,a,t){e.exports=d;t(41);var r,c=t(111),n=(t(110),t(0)),i=t(264),f=t(6).Stream,o={};function d(e){var a=this;if(!(a instanceof d))return new d(e);f.apply(this),a.writable=!0,a.readable=!0,a._stream=new i(512),a._stream.on("data",function(e){a.emit("data",e)}),a._stream.on("drain",function(){a.emit("drain")}),a._stream.on("end",function(){a.emit("end"),a.emit("close")}),a.props=e,"Directory"===e.type&&(e.size=0),e.ustar="ustar\0",e.ustarver="00",a.path=e.path,a._buffer=[],a._didHeader=!1,a._meta=!1,a.on("pipe",function(){a._process()})}n(d,f),d.prototype.write=function(e){return this._ended?this.emit("error",new Error("write after end")):(this._buffer.push(e),this._process(),this._needDrain=this._buffer.length>0,!this._needDrain)},d.prototype.end=function(e){e&&this._buffer.push(e),this._buffer.push(o),this._ended=!0,this._process(),this._needDrain=this._buffer.length>0},d.prototype.pause=function(){this._paused=!0,this.emit("pause")},d.prototype.resume=function(){this._paused=!1,this.emit("resume"),this._process()},d.prototype.add=function(e){return this.parent?(this._ended||this.end(),this.parent.add(e)):this.emit("error",new Error("no parent"))},d.prototype._header=function(){if(!this._didHeader){this._didHeader=!0;var e=c.encode(this.props);if(this.props.needExtended&&!this._meta){var a=this;(r=r||t(263))(this.props).on("data",function(e){a.emit("data",e)}).on("error",function(e){a.emit("error",e)}).end()}this.emit("data",e),this.emit("header")}},d.prototype._process=function(){if(this._didHeader||this._meta||this._header(),!this._paused&&!this._processing){this._processing=!0;for(var e=this._buffer,a=0;a<e.length;a++){var t=e[a];if(t===o?this._stream.end():this._stream.write(t),this._paused)return this._processing=!1,void(a<e.length&&(this._needDrain=!0,this._buffer=e.slice(a+1)))}this._buffer.length=0,this._processing=!1,this.emit("drain")}},d.prototype.destroy=function(){}},function(e,a){e.exports=__webpack_require__(87)},function(e,a,t){"use strict";const r=t(6).PassThrough,c=t(279),n=t(671);e.exports=(e=>{if(-1===["gzip","deflate"].indexOf(e.headers["content-encoding"]))return e;const a=c.createUnzip(),t=new r;return n(e,t),a.on("error",e=>{"Z_BUF_ERROR"!==e.code?t.emit("error",e):t.end()}),e.pipe(a).pipe(t),t})},function(e,a,t){"use strict";e.exports=function(e,a){if(e.timeoutTimer)return e;var t=isNaN(a)?a:{socket:a,connect:a},r=e._headers?" to "+e._headers.host:"";function c(){e.timeoutTimer&&(clearTimeout(e.timeoutTimer),e.timeoutTimer=null)}function n(){c(),void 0!==t.socket&&e.setTimeout(t.socket,function(){e.abort();var a=new Error("Socket timed out on request"+r);a.code="ESOCKETTIMEDOUT",e.emit("error",a)})}return void 0!==t.connect&&(e.timeoutTimer=setTimeout(function(){e.abort();var a=new Error("Connection timed out on request"+r);a.code="ETIMEDOUT",e.emit("error",a)},t.connect)),e.on("socket",function(e){e.connecting||e._connecting?e.once("connect",n):n()}),e.on("error",c)}},function(e,a){e.exports=__webpack_require__(85)},function(e,a,t){"use strict";var r=t(13),c=r.maybeWrapAsError,n=t(42).OperationalError,i=t(57);var f=/^(?:name|message|stack|cause)$/;function o(e){var a;if(function(e){return e instanceof Error&&i.getPrototypeOf(e)===Error.prototype}(e)){(a=new n(e)).name=e.name,a.message=e.message,a.stack=e.stack;for(var t=i.keys(e),c=0;c<t.length;++c){var o=t[c];f.test(o)||(a[o]=e[o])}return a}return r.markAsOriginatingFromRejection(e),e}e.exports=function(e,a){return function(t,r){if(null!==e){if(t){var n=o(c(t));e._attachExtraTrace(n),e._reject(n)}else if(a){for(var i=arguments.length,f=new Array(Math.max(i-1,0)),d=1;d<i;++d)f[d-1]=arguments[d];e._fulfill(f)}else e._fulfill(r);e=null}}}},function(e,a,t){"use strict";e.exports=function(e){var a=t(13),r=t(57).keys,c=a.tryCatch,n=a.errorObj;return function(t,i,f){return function(o){var d=f._boundValue();e:for(var s=0;s<t.length;++s){var b=t[s];if(b===Error||null!=b&&b.prototype instanceof Error){if(o instanceof b)return c(i).call(d,o)}else if("function"==typeof b){var u=c(b).call(d,o);if(u===n)return u;if(u)return c(i).call(d,o)}else if(a.isObject(o)){for(var l=r(b),p=0;p<l.length;++p){var h=l[p];if(b[h]!=o[h])continue e}return c(i).call(d,o)}}return e}}}},function(e,a,t){"use strict";const r=t(8),c=t(2),n=t(26),i=t(161);e.exports=function(e,a,t,f){"function"==typeof t&&(f=t,t={});const o=c.dirname(e);r.exists(o,r=>{if(r)return i.writeJson(e,a,t,f);n.mkdirs(o,r=>{if(r)return f(r);i.writeJson(e,a,t,f)})})}},function(e,a,t){"use strict";const r=t(8),c=t(2),n=t(26),i=t(161);e.exports=function(e,a,t){const f=c.dirname(e);r.existsSync(f)||n.mkdirsSync(f),i.writeJsonSync(e,a,t)}},function(e,a,t){e.exports={copySync:t(727)}},function(e,a,t){"use strict";const r=t(2);function c(e){return(e=r.normalize(r.resolve(e)).split(r.sep)).length>0?e[0]:null}const n=/[<>:"|?*]/;e.exports={getRootPath:c,invalidWin32Path:function(e){const a=c(e);return e=e.replace(a,""),n.test(e)}}},function(e,a,t){var r=t(8),c=t(2),n=t(728);e.exports=function(e,a,t,i){i||(i=t,t={});var f=process.cwd(),o=c.resolve(f,e),d=c.resolve(f,a),s=t.filter,b=t.transform,u=t.overwrite;void 0===u&&(u=t.clobber),void 0===u&&(u=!0);var l=t.errorOnExist,p=t.dereference,h=!0===t.preserveTimestamps,m=0,g=0,v=0,y=!1;function _(e){if(m++,s)if(s instanceof RegExp){if(console.warn("Warning: fs-extra: Passing a RegExp filter is deprecated, use a function"),!s.test(e))return T(!0)}else if("function"==typeof s&&!s(e,a))return T(!0);return function(e){var a=p?r.stat:r.lstat;v++,a(e,function(a,t){if(a)return S(a);var n={name:e,mode:t.mode,mtime:t.mtime,atime:t.atime,stats:t};return t.isDirectory()?function(e){var a=e.name.replace(o,d.replace("$","$$$$"));E(a,function(t){if(t)return function(e,a){r.mkdir(a,e.mode,function(t){if(t)return S(t);r.chmod(a,e.mode,function(a){if(a)return S(a);k(e.name)})})}(e,a);k(e.name)})}(n):t.isFile()||t.isCharacterDevice()||t.isBlockDevice()?function(e){var a=e.name.replace(o,d.replace("$","$$$$"));E(a,function(t){t?w(e,a):u?A(a,function(){w(e,a)}):l?S(new Error(a+" already exists")):T()})}(n):t.isSymbolicLink()?function(e){var a=e.replace(o,d);r.readlink(e,function(e,t){if(e)return S(e);!function(e,a){p&&(e=c.resolve(f,e)),E(a,function(t){if(t)return x(e,a);r.readlink(a,function(t,r){return t?S(t):(p&&(r=c.resolve(f,r)),r===e?T():A(a,function(){x(e,a)}))})})}(t,a)})}(e):void 0})}(e)}function w(e,a){var t=r.createReadStream(e.name),c=r.createWriteStream(a,{mode:e.mode});t.on("error",S),c.on("error",S),b?b(t,c,e):c.on("open",function(){t.pipe(c)}),c.once("close",function(){r.chmod(a,e.mode,function(t){if(t)return S(t);h?n.utimesMillis(a,e.atime,e.mtime,function(e){return e?S(e):T()}):T()})})}function A(e,a){r.unlink(e,function(e){return e?S(e):a()})}function k(e){r.readdir(e,function(a,t){return a?S(a):(t.forEach(function(a){_(c.join(e,a))}),T())})}function x(e,a){r.symlink(e,a,function(e){return e?S(e):T()})}function E(e,a){r.lstat(e,function(e){return e&&"ENOENT"===e.code?a(!0):a(!1)})}function S(e){if(!y&&void 0!==i)return y=!0,i(e)}function T(e){if(e||v--,m===++g&&0===v&&void 0!==i)return i(null)}_(o)}},function(e,a,t){var r=t(733);function c(e,a,t){return n(e,a,t,r)}function n(e,a,t,r){return a||(a={},t=Object.keys(e)),Array.isArray(a)&&(t=a,a={}),t||(t=Object.keys(e)),"function"==typeof e&&(a=r(e)),t.forEach(function(t){"function"==typeof e[t]&&(a[t]=r(e[t]))}),Object.keys(e).forEach(function(t){(function(e,a){var t=Object.getOwnPropertyDescriptor(e,a);return!(!t||!t.get)&&"deprecated"===t.get.name})(e,t)||a[t]||(a[t]=e[t])}),a}e.exports=c,c.withCallback=function(e,a,t){return n(e,a,t,r.withCallback)},c.thenify=r},function(e,a,t){"use strict";var r=t(15);e.exports=function(e){if(null===e||"object"!=typeof e)return e;if(e instanceof Object)var a={__proto__:e.__proto__};else var a=Object.create(null);return Object.getOwnPropertyNames(e).forEach(function(t){Object.defineProperty(a,t,Object.getOwnPropertyDescriptor(e,t))}),a}(r)},function(e,a,t){"use strict";var r=t(736),c=t(732),n=(t(82),t(290));Array.prototype.slice;n.withCallback(c,a,["copy","emptyDir","ensureFile","ensureDir","ensureLink","ensureSymlink","mkdirs","move","outputFile","outputJson","readJson","remove","writeJson","createFile","createLink","createSymlink","emptydir","mkdirp","readJSON","outputJSON","writeJSON"]);["rename","ftruncate","chown","fchown","lchown","chmod","fchmod","stat","lstat","fstat","link","symlink","readlink","realpath","unlink","rmdir","mkdir","mkdtemp","readdir","close","open","utimes","futimes","fsync","fdatasync","write","read","readFile","writeFile","appendFile","access","truncate","exists"].forEach(function(e){a[e]=r[e]})},function(e,a,t){var r=t(9),c=t(85);function n(e,a){var t=function(e){var a=i(e);return{blinder:a.toRed(r.mont(e.modulus)).redPow(new r(e.publicExponent)).fromRed(),unblinder:a.invm(e.modulus)}}(a),c=a.modulus.byteLength(),n=(r.mont(a.modulus),new r(e).mul(t.blinder).umod(a.modulus)),f=n.toRed(r.mont(a.prime1)),o=n.toRed(r.mont(a.prime2)),d=a.coefficient,s=a.prime1,b=a.prime2,u=f.redPow(a.exponent1),l=o.redPow(a.exponent2);u=u.fromRed(),l=l.fromRed();var p=u.isub(l).imul(d).umod(s);return p.imul(b),l.iadd(p),new Buffer(l.imul(t.unblinder).umod(a.modulus).toArray(!1,c))}function i(e){for(var a=e.modulus.byteLength(),t=new r(c(a));t.cmp(e.modulus)>=0||!t.umod(e.prime1)||!t.umod(e.prime2);)t=new r(c(a));return t}e.exports=n,n.getr=i},function(e,a,t){var r=t(9);e.exports=function(e,a){return new Buffer(e.toRed(r.mont(a.modulus)).redPow(new r(a.publicExponent)).fromRed().toArray())}},function(e,a){e.exports=function(e,a){for(var t=e.length,r=-1;++r<t;)e[r]^=a[r];return e}},function(e,a,t){var r=t(30);function c(e){var a=new Buffer(4);return a.writeUInt32BE(e,0),a}e.exports=function(e,a){for(var t,n=new Buffer(""),i=0;n.length<a;)t=c(i++),n=Buffer.concat([n,r("sha1").update(e).update(t).digest()]);return n.slice(0,a)}},function(e,a,t){var r=t(10);a.createCipher=a.Cipher=r.createCipher,a.createCipheriv=a.Cipheriv=r.createCipheriv,a.createDecipher=a.Decipher=r.createDecipher,a.createDecipheriv=a.Decipheriv=r.createDecipheriv,a.listCiphers=a.getCiphers=r.getCiphers},function(e,a,t){var r=t(0),c=t(24).Buffer,n=t(81),i=n.base,f=n.constants.der;function o(e){this.enc="der",this.name=e.name,this.entity=e,this.tree=new d,this.tree._init(e.body)}function d(e){i.Node.call(this,"der",e)}function s(e){return e<10?"0"+e:e}e.exports=o,o.prototype.encode=function(e,a){return this.tree._encode(e,a).join()},r(d,i.Node),d.prototype._encodeComposite=function(e,a,t,r){var n,i=function(e,a,t,r){var c;"seqof"===e?e="seq":"setof"===e&&(e="set");if(f.tagByName.hasOwnProperty(e))c=f.tagByName[e];else{if("number"!=typeof e||(0|e)!==e)return r.error("Unknown tag: "+e);c=e}if(c>=31)return r.error("Multi-octet tag encoding unsupported");a||(c|=32);return c|=f.tagClassByName[t||"universal"]<<6}(e,a,t,this.reporter);if(r.length<128)return(n=new c(2))[0]=i,n[1]=r.length,this._createEncoderBuffer([n,r]);for(var o=1,d=r.length;d>=256;d>>=8)o++;(n=new c(2+o))[0]=i,n[1]=128|o;d=1+o;for(var s=r.length;s>0;d--,s>>=8)n[d]=255&s;return this._createEncoderBuffer([n,r])},d.prototype._encodeStr=function(e,a){if("bitstr"===a)return this._createEncoderBuffer([0|e.unused,e.data]);if("bmpstr"===a){for(var t=new c(2*e.length),r=0;r<e.length;r++)t.writeUInt16BE(e.charCodeAt(r),2*r);return this._createEncoderBuffer(t)}return"numstr"===a?this._isNumstr(e)?this._createEncoderBuffer(e):this.reporter.error("Encoding of string type: numstr supports only digits and space"):"printstr"===a?this._isPrintstr(e)?this._createEncoderBuffer(e):this.reporter.error("Encoding of string type: printstr supports only latin upper and lower case letters, digits, space, apostrophe, left and rigth parenthesis, plus sign, comma, hyphen, dot, slash, colon, equal sign, question mark"):/str$/.test(a)?this._createEncoderBuffer(e):"objDesc"===a?this._createEncoderBuffer(e):this.reporter.error("Encoding of string type: "+a+" unsupported")},d.prototype._encodeObjid=function(e,a,t){if("string"==typeof e){if(!a)return this.reporter.error("string objid given, but no values map found");if(!a.hasOwnProperty(e))return this.reporter.error("objid not found in values map");e=a[e].split(/[\s\.]+/g);for(var r=0;r<e.length;r++)e[r]|=0}else if(Array.isArray(e)){e=e.slice();for(r=0;r<e.length;r++)e[r]|=0}if(!Array.isArray(e))return this.reporter.error("objid() should be either array or string, got: "+JSON.stringify(e));if(!t){if(e[1]>=40)return this.reporter.error("Second objid identifier OOB");e.splice(0,2,40*e[0]+e[1])}var n=0;for(r=0;r<e.length;r++){var i=e[r];for(n++;i>=128;i>>=7)n++}var f=new c(n),o=f.length-1;for(r=e.length-1;r>=0;r--){i=e[r];for(f[o--]=127&i;(i>>=7)>0;)f[o--]=128|127&i}return this._createEncoderBuffer(f)},d.prototype._encodeTime=function(e,a){var t,r=new Date(e);return"gentime"===a?t=[s(r.getFullYear()),s(r.getUTCMonth()+1),s(r.getUTCDate()),s(r.getUTCHours()),s(r.getUTCMinutes()),s(r.getUTCSeconds()),"Z"].join(""):"utctime"===a?t=[s(r.getFullYear()%100),s(r.getUTCMonth()+1),s(r.getUTCDate()),s(r.getUTCHours()),s(r.getUTCMinutes()),s(r.getUTCSeconds()),"Z"].join(""):this.reporter.error("Encoding "+a+" time is not supported yet"),this._encodeStr(t,"octstr")},d.prototype._encodeNull=function(){return this._createEncoderBuffer("")},d.prototype._encodeInt=function(e,a){if("string"==typeof e){if(!a)return this.reporter.error("String int or enum given, but no values map");if(!a.hasOwnProperty(e))return this.reporter.error("Values map doesn't contain: "+JSON.stringify(e));e=a[e]}if("number"!=typeof e&&!c.isBuffer(e)){var t=e.toArray();!e.sign&&128&t[0]&&t.unshift(0),e=new c(t)}if(c.isBuffer(e)){var r=e.length;0===e.length&&r++;var n=new c(r);return e.copy(n),0===e.length&&(n[0]=0),this._createEncoderBuffer(n)}if(e<128)return this._createEncoderBuffer(e);if(e<256)return this._createEncoderBuffer([0,e]);r=1;for(var i=e;i>=256;i>>=8)r++;for(i=(n=new Array(r)).length-1;i>=0;i--)n[i]=255&e,e>>=8;return 128&n[0]&&n.unshift(0),this._createEncoderBuffer(new c(n))},d.prototype._encodeBool=function(e){return this._createEncoderBuffer(e?255:0)},d.prototype._use=function(e,a){return"function"==typeof e&&(e=e(a)),e._getEncoder("der").tree},d.prototype._skipDefault=function(e,a,t){var r,c=this._baseState;if(null===c.default)return!1;var n=e.join();if(void 0===c.defaultBuffer&&(c.defaultBuffer=this._encodeValue(c.default,a,t).join()),n.length!==c.defaultBuffer.length)return!1;for(r=0;r<n.length;r++)if(n[r]!==c.defaultBuffer[r])return!1;return!0}},function(e,a,t){var r=t(0),c=t(81),n=c.base,i=c.bignum,f=c.constants.der;function o(e){this.enc="der",this.name=e.name,this.entity=e,this.tree=new d,this.tree._init(e.body)}function d(e){n.Node.call(this,"der",e)}function s(e,a){var t=e.readUInt8(a);if(e.isError(t))return t;var r=f.tagClass[t>>6],c=0==(32&t);if(31==(31&t)){var n=t;for(t=0;128==(128&n);){if(n=e.readUInt8(a),e.isError(n))return n;t<<=7,t|=127&n}}else t&=31;return{cls:r,primitive:c,tag:t,tagStr:f.tag[t]}}function b(e,a,t){var r=e.readUInt8(t);if(e.isError(r))return r;if(!a&&128===r)return null;if(0==(128&r))return r;var c=127&r;if(c>4)return e.error("length octect is too long");r=0;for(var n=0;n<c;n++){r<<=8;var i=e.readUInt8(t);if(e.isError(i))return i;r|=i}return r}e.exports=o,o.prototype.decode=function(e,a){return e instanceof n.DecoderBuffer||(e=new n.DecoderBuffer(e,a)),this.tree._decode(e,a)},r(d,n.Node),d.prototype._peekTag=function(e,a,t){if(e.isEmpty())return!1;var r=e.save(),c=s(e,'Failed to peek tag: "'+a+'"');return e.isError(c)?c:(e.restore(r),c.tag===a||c.tagStr===a||c.tagStr+"of"===a||t)},d.prototype._decodeTag=function(e,a,t){var r=s(e,'Failed to decode tag of "'+a+'"');if(e.isError(r))return r;var c=b(e,r.primitive,'Failed to get length of "'+a+'"');if(e.isError(c))return c;if(!t&&r.tag!==a&&r.tagStr!==a&&r.tagStr+"of"!==a)return e.error('Failed to match tag: "'+a+'"');if(r.primitive||null!==c)return e.skip(c,'Failed to match body of: "'+a+'"');var n=e.save(),i=this._skipUntilEnd(e,'Failed to skip indefinite length body: "'+this.tag+'"');return e.isError(i)?i:(c=e.offset-n.offset,e.restore(n),e.skip(c,'Failed to match body of: "'+a+'"'))},d.prototype._skipUntilEnd=function(e,a){for(;;){var t=s(e,a);if(e.isError(t))return t;var r,c=b(e,t.primitive,a);if(e.isError(c))return c;if(r=t.primitive||null!==c?e.skip(c):this._skipUntilEnd(e,a),e.isError(r))return r;if("end"===t.tagStr)break}},d.prototype._decodeList=function(e,a,t,r){for(var c=[];!e.isEmpty();){var n=this._peekTag(e,"end");if(e.isError(n))return n;var i=t.decode(e,"der",r);if(e.isError(i)&&n)break;c.push(i)}return c},d.prototype._decodeStr=function(e,a){if("bitstr"===a){var t=e.readUInt8();return e.isError(t)?t:{unused:t,data:e.raw()}}if("bmpstr"===a){var r=e.raw();if(r.length%2==1)return e.error("Decoding of string type: bmpstr length mismatch");for(var c="",n=0;n<r.length/2;n++)c+=String.fromCharCode(r.readUInt16BE(2*n));return c}if("numstr"===a){var i=e.raw().toString("ascii");return this._isNumstr(i)?i:e.error("Decoding of string type: numstr unsupported characters")}if("octstr"===a)return e.raw();if("objDesc"===a)return e.raw();if("printstr"===a){var f=e.raw().toString("ascii");return this._isPrintstr(f)?f:e.error("Decoding of string type: printstr unsupported characters")}return/str$/.test(a)?e.raw().toString():e.error("Decoding of string type: "+a+" unsupported")},d.prototype._decodeObjid=function(e,a,t){for(var r,c=[],n=0;!e.isEmpty();){var i=e.readUInt8();n<<=7,n|=127&i,0==(128&i)&&(c.push(n),n=0)}128&i&&c.push(n);var f=c[0]/40|0,o=c[0]%40;if(r=t?c:[f,o].concat(c.slice(1)),a){var d=a[r.join(" ")];void 0===d&&(d=a[r.join(".")]),void 0!==d&&(r=d)}return r},d.prototype._decodeTime=function(e,a){var t=e.raw().toString();if("gentime"===a)var r=0|t.slice(0,4),c=0|t.slice(4,6),n=0|t.slice(6,8),i=0|t.slice(8,10),f=0|t.slice(10,12),o=0|t.slice(12,14);else{if("utctime"!==a)return e.error("Decoding "+a+" time is not supported yet");r=0|t.slice(0,2),c=0|t.slice(2,4),n=0|t.slice(4,6),i=0|t.slice(6,8),f=0|t.slice(8,10),o=0|t.slice(10,12);r=r<70?2e3+r:1900+r}return Date.UTC(r,c-1,n,i,f,o,0)},d.prototype._decodeNull=function(e){return null},d.prototype._decodeBool=function(e){var a=e.readUInt8();return e.isError(a)?a:0!==a},d.prototype._decodeInt=function(e,a){var t=e.raw(),r=new i(t);return a&&(r=a[r.toString(10)]||r),r},d.prototype._use=function(e,a){return"function"==typeof e&&(e=e(a)),e._getDecoder("der").tree}},function(e,a,t){var r=a;r._reverse=function(e){var a={};return Object.keys(e).forEach(function(t){(0|t)==t&&(t|=0);var r=e[t];a[r]=t}),a},r.der=t(756)},function(e,a,t){var r=t(0),c=t(80).Reporter,n=t(24).Buffer;function i(e,a){c.call(this,a),n.isBuffer(e)?(this.base=e,this.offset=0,this.length=e.length):this.error("Input not Buffer")}function f(e,a){if(Array.isArray(e))this.length=0,this.value=e.map(function(e){return e instanceof f||(e=new f(e,a)),this.length+=e.length,e},this);else if("number"==typeof e){if(!(0<=e&&e<=255))return a.error("non-byte EncoderBuffer value");this.value=e,this.length=1}else if("string"==typeof e)this.value=e,this.length=n.byteLength(e);else{if(!n.isBuffer(e))return a.error("Unsupported type: "+typeof e);this.value=e,this.length=e.length}}r(i,c),a.DecoderBuffer=i,i.prototype.save=function(){return{offset:this.offset,reporter:c.prototype.save.call(this)}},i.prototype.restore=function(e){var a=new i(this.base);return a.offset=e.offset,a.length=this.offset,this.offset=e.offset,c.prototype.restore.call(this,e.reporter),a},i.prototype.isEmpty=function(){return this.offset===this.length},i.prototype.readUInt8=function(e){return this.offset+1<=this.length?this.base.readUInt8(this.offset++,!0):this.error(e||"DecoderBuffer overrun")},i.prototype.skip=function(e,a){if(!(this.offset+e<=this.length))return this.error(a||"DecoderBuffer overrun");var t=new i(this.base);return t._reporterState=this._reporterState,t.offset=this.offset,t.length=this.offset+e,this.offset+=e,t},i.prototype.raw=function(e){return this.base.slice(e?e.offset:this.offset,this.length)},a.EncoderBuffer=f,f.prototype.join=function(e,a){return e||(e=new n(this.length)),a||(a=0),0===this.length?e:(Array.isArray(this.value)?this.value.forEach(function(t){t.join(e,a),a+=t.length}):("number"==typeof this.value?e[a]=this.value:"string"==typeof this.value?e.write(this.value,a):n.isBuffer(this.value)&&this.value.copy(e,a),a+=this.length),e)}},function(e,a,t){var r=t(761),c=t(750),n=t(749),i=t(297),f=t(170);function o(e){var a;"object"!=typeof e||Buffer.isBuffer(e)||(a=e.passphrase,e=e.key),"string"==typeof e&&(e=new Buffer(e));var t,o,d=n(e,a),s=d.tag,b=d.data;switch(s){case"CERTIFICATE":o=r.certificate.decode(b,"der").tbsCertificate.subjectPublicKeyInfo;case"PUBLIC KEY":switch(o||(o=r.PublicKey.decode(b,"der")),t=o.algorithm.algorithm.join(".")){case"1.2.840.113549.1.1.1":return r.RSAPublicKey.decode(o.subjectPublicKey.data,"der");case"1.2.840.10045.2.1":return o.subjectPrivateKey=o.subjectPublicKey,{type:"ec",data:o};case"1.2.840.10040.4.1":return o.algorithm.params.pub_key=r.DSAparam.decode(o.subjectPublicKey.data,"der"),{type:"dsa",data:o.algorithm.params};default:throw new Error("unknown key id "+t)}throw new Error("unknown key type "+s);case"ENCRYPTED PRIVATE KEY":b=function(e,a){var t=e.algorithm.decrypt.kde.kdeparams.salt,r=parseInt(e.algorithm.decrypt.kde.kdeparams.iters.toString(),10),n=c[e.algorithm.decrypt.cipher.algo.join(".")],o=e.algorithm.decrypt.cipher.iv,d=e.subjectPrivateKey,s=parseInt(n.split("-")[1],10)/8,b=f.pbkdf2Sync(a,t,r,s),u=i.createDecipheriv(n,b,o),l=[];return l.push(u.update(d)),l.push(u.final()),Buffer.concat(l)}(b=r.EncryptedPrivateKey.decode(b,"der"),a);case"PRIVATE KEY":switch(t=(o=r.PrivateKey.decode(b,"der")).algorithm.algorithm.join(".")){case"1.2.840.113549.1.1.1":return r.RSAPrivateKey.decode(o.subjectPrivateKey,"der");case"1.2.840.10045.2.1":return{curve:o.algorithm.curve,privateKey:r.ECPrivateKey.decode(o.subjectPrivateKey,"der").privateKey};case"1.2.840.10040.4.1":return o.algorithm.params.priv_key=r.DSAparam.decode(o.subjectPrivateKey,"der"),{type:"dsa",params:o.algorithm.params};default:throw new Error("unknown key id "+t)}throw new Error("unknown key type "+s);case"RSA PUBLIC KEY":return r.RSAPublicKey.decode(b,"der");case"RSA PRIVATE KEY":return r.RSAPrivateKey.decode(b,"der");case"DSA PRIVATE KEY":return{type:"dsa",params:r.DSAPrivateKey.decode(b,"der")};case"EC PRIVATE KEY":return{curve:(b=r.ECPrivateKey.decode(b,"der")).parameters.value,privateKey:b.privateKey};default:throw new Error("unknown key type "+s)}}e.exports=o,o.signature=r.signature},function(e,a){var t="0123456789abcdef".split(""),r=[1,256,65536,16777216],c=[0,8,16,24],n=[1,0,32898,0,32906,2147483648,2147516416,2147483648,32907,0,2147483649,0,2147516545,2147483648,32777,2147483648,138,0,136,0,2147516425,0,2147483658,0,2147516555,0,139,2147483648,32905,2147483648,32771,2147483648,32770,2147483648,128,2147483648,32778,0,2147483658,2147483648,2147516545,2147483648,32896,2147483648,2147483649,0,2147516424,2147483648],i=function(e){var a,t,r,c,i,f,o,d,s,b,u,l,p,h,m,g,v,y,_,w,A,k,x,E,S,T,j,C,R,O,B,M,N,I,P,F,L,D,z,q,U,H,V,G,W,Y,K,Q,Z,J,X,$,ee,ae,te,re,ce,ne,ie,fe,oe,de,se;for(r=0;r<48;r+=2)c=e[0]^e[10]^e[20]^e[30]^e[40],i=e[1]^e[11]^e[21]^e[31]^e[41],f=e[2]^e[12]^e[22]^e[32]^e[42],o=e[3]^e[13]^e[23]^e[33]^e[43],d=e[4]^e[14]^e[24]^e[34]^e[44],s=e[5]^e[15]^e[25]^e[35]^e[45],b=e[6]^e[16]^e[26]^e[36]^e[46],u=e[7]^e[17]^e[27]^e[37]^e[47],a=(l=e[8]^e[18]^e[28]^e[38]^e[48])^(f<<1|o>>>31),t=(p=e[9]^e[19]^e[29]^e[39]^e[49])^(o<<1|f>>>31),e[0]^=a,e[1]^=t,e[10]^=a,e[11]^=t,e[20]^=a,e[21]^=t,e[30]^=a,e[31]^=t,e[40]^=a,e[41]^=t,a=c^(d<<1|s>>>31),t=i^(s<<1|d>>>31),e[2]^=a,e[3]^=t,e[12]^=a,e[13]^=t,e[22]^=a,e[23]^=t,e[32]^=a,e[33]^=t,e[42]^=a,e[43]^=t,a=f^(b<<1|u>>>31),t=o^(u<<1|b>>>31),e[4]^=a,e[5]^=t,e[14]^=a,e[15]^=t,e[24]^=a,e[25]^=t,e[34]^=a,e[35]^=t,e[44]^=a,e[45]^=t,a=d^(l<<1|p>>>31),t=s^(p<<1|l>>>31),e[6]^=a,e[7]^=t,e[16]^=a,e[17]^=t,e[26]^=a,e[27]^=t,e[36]^=a,e[37]^=t,e[46]^=a,e[47]^=t,a=b^(c<<1|i>>>31),t=u^(i<<1|c>>>31),e[8]^=a,e[9]^=t,e[18]^=a,e[19]^=t,e[28]^=a,e[29]^=t,e[38]^=a,e[39]^=t,e[48]^=a,e[49]^=t,h=e[0],m=e[1],Y=e[11]<<4|e[10]>>>28,K=e[10]<<4|e[11]>>>28,C=e[20]<<3|e[21]>>>29,R=e[21]<<3|e[20]>>>29,fe=e[31]<<9|e[30]>>>23,oe=e[30]<<9|e[31]>>>23,H=e[40]<<18|e[41]>>>14,V=e[41]<<18|e[40]>>>14,I=e[2]<<1|e[3]>>>31,P=e[3]<<1|e[2]>>>31,g=e[13]<<12|e[12]>>>20,v=e[12]<<12|e[13]>>>20,Q=e[22]<<10|e[23]>>>22,Z=e[23]<<10|e[22]>>>22,O=e[33]<<13|e[32]>>>19,B=e[32]<<13|e[33]>>>19,de=e[42]<<2|e[43]>>>30,se=e[43]<<2|e[42]>>>30,ae=e[5]<<30|e[4]>>>2,te=e[4]<<30|e[5]>>>2,F=e[14]<<6|e[15]>>>26,L=e[15]<<6|e[14]>>>26,y=e[25]<<11|e[24]>>>21,_=e[24]<<11|e[25]>>>21,J=e[34]<<15|e[35]>>>17,X=e[35]<<15|e[34]>>>17,M=e[45]<<29|e[44]>>>3,N=e[44]<<29|e[45]>>>3,E=e[6]<<28|e[7]>>>4,S=e[7]<<28|e[6]>>>4,re=e[17]<<23|e[16]>>>9,ce=e[16]<<23|e[17]>>>9,D=e[26]<<25|e[27]>>>7,z=e[27]<<25|e[26]>>>7,w=e[36]<<21|e[37]>>>11,A=e[37]<<21|e[36]>>>11,$=e[47]<<24|e[46]>>>8,ee=e[46]<<24|e[47]>>>8,G=e[8]<<27|e[9]>>>5,W=e[9]<<27|e[8]>>>5,T=e[18]<<20|e[19]>>>12,j=e[19]<<20|e[18]>>>12,ne=e[29]<<7|e[28]>>>25,ie=e[28]<<7|e[29]>>>25,q=e[38]<<8|e[39]>>>24,U=e[39]<<8|e[38]>>>24,k=e[48]<<14|e[49]>>>18,x=e[49]<<14|e[48]>>>18,e[0]=h^~g&y,e[1]=m^~v&_,e[10]=E^~T&C,e[11]=S^~j&R,e[20]=I^~F&D,e[21]=P^~L&z,e[30]=G^~Y&Q,e[31]=W^~K&Z,e[40]=ae^~re&ne,e[41]=te^~ce&ie,e[2]=g^~y&w,e[3]=v^~_&A,e[12]=T^~C&O,e[13]=j^~R&B,e[22]=F^~D&q,e[23]=L^~z&U,e[32]=Y^~Q&J,e[33]=K^~Z&X,e[42]=re^~ne&fe,e[43]=ce^~ie&oe,e[4]=y^~w&k,e[5]=_^~A&x,e[14]=C^~O&M,e[15]=R^~B&N,e[24]=D^~q&H,e[25]=z^~U&V,e[34]=Q^~J&$,e[35]=Z^~X&ee,e[44]=ne^~fe&de,e[45]=ie^~oe&se,e[6]=w^~k&h,e[7]=A^~x&m,e[16]=O^~M&E,e[17]=B^~N&S,e[26]=q^~H&I,e[27]=U^~V&P,e[36]=J^~$&G,e[37]=X^~ee&W,e[46]=fe^~de&ae,e[47]=oe^~se&te,e[8]=k^~h&g,e[9]=x^~m&v,e[18]=M^~E&T,e[19]=N^~S&j,e[28]=H^~I&F,e[29]=V^~P&L,e[38]=$^~G&Y,e[39]=ee^~W&K,e[48]=de^~ae&re,e[49]=se^~te&ce,e[0]^=n[r],e[1]^=n[r+1]},f=function(e){return function(a){var n;if("0x"===a.slice(0,2)){n=[];for(var f=2,o=a.length;f<o;f+=2)n.push(parseInt(a.slice(f,f+2),16))}else n=a;return function(e,a){for(var n,f=a.length,o=e.blocks,d=e.blockCount<<2,s=e.blockCount,b=e.outputBlocks,u=e.s,l=0;l<f;){if(e.reset)for(e.reset=!1,o[0]=e.block,m=1;m<s+1;++m)o[m]=0;if("string"!=typeof a)for(m=e.start;l<f&&m<d;++l)o[m>>2]|=a[l]<<c[3&m++];else for(m=e.start;l<f&&m<d;++l)(n=a.charCodeAt(l))<128?o[m>>2]|=n<<c[3&m++]:n<2048?(o[m>>2]|=(192|n>>6)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]):n<55296||n>=57344?(o[m>>2]|=(224|n>>12)<<c[3&m++],o[m>>2]|=(128|n>>6&63)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]):(n=65536+((1023&n)<<10|1023&a.charCodeAt(++l)),o[m>>2]|=(240|n>>18)<<c[3&m++],o[m>>2]|=(128|n>>12&63)<<c[3&m++],o[m>>2]|=(128|n>>6&63)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]);if(e.lastByteIndex=m,m>=d){for(e.start=m-d,e.block=o[s],m=0;m<s;++m)u[m]^=o[m];i(u),e.reset=!0}else e.start=m}if(o[(m=e.lastByteIndex)>>2]|=r[3&m],e.lastByteIndex===d)for(o[0]=o[s],m=1;m<s+1;++m)o[m]=0;for(o[s-1]|=2147483648,m=0;m<s;++m)u[m]^=o[m];i(u);for(var p,h="",m=0,g=0;g<b;){for(m=0;m<s&&g<b;++m,++g)p=u[m],h+=t[p>>4&15]+t[15&p]+t[p>>12&15]+t[p>>8&15]+t[p>>20&15]+t[p>>16&15]+t[p>>28&15]+t[p>>24&15];g%s==0&&(i(u),m=0)}return"0x"+h}(function(e){return{blocks:[],reset:!0,block:0,start:0,blockCount:1600-(e<<1)>>5,outputBlocks:e>>5,s:function(e){return[].concat(e,e,e,e,e)}([0,0,0,0,0,0,0,0,0,0])}}(e),n)}};e.exports={keccak256:f(256),keccak512:f(512),keccak256s:f(256),keccak512s:f(512)}},function(e,a){e.exports={encode:function(e){var a=function(e){return function(e){return e.length%2==0?e:"0"+e}(e.toString(16))},t=function(e,t){return e<56?a(t+e):a(t+a(e).length/2+55)+a(e)};return"0x"+function e(a){if("string"==typeof a){var r=a.slice(2);return(2!=r.length||r>="80"?t(r.length/2,128):"")+r}var c=a.map(e).join("");return t(c.length/2,192)+c}(e)},decode:function(e){var a=2,t=function(){if(a>=e.length)throw"";var t=e.slice(a,a+2);return t<"80"?(a+=2,"0x"+t):t<"c0"?c():n()},r=function(){var t=parseInt(e.slice(a,a+=2),16)%64;return t<56?t:parseInt(e.slice(a,a+=2*(t-55)),16)},c=function(){var t=r();return"0x"+e.slice(a,a+=2*t)},n=function(){for(var e=2*r()+a,c=[];a<e;)c.push(t());return c};try{return t()}catch(e){return[]}}}},function(e,a,t){var r=t(9),c=t(165),n=function(e){return new r(e.slice(2),16)},i=function(e){var a="0x"+("0x"===e.slice(0,2)?new r(e.slice(2),16):new r(e,10)).toString("hex");return"0x0"===a?"0x":a},f=function(e){return"string"==typeof e?/^0x/.test(e)?e:"0x"+e:"0x"+new r(e).toString("hex")},o=function(e){return n(e).toNumber()},d=function(e){return function(a,t){return function(e){return"0x"+e.toString("hex")}(n(a)[e](n(t)))}},s=d("add"),b=d("mul"),u=d("div"),l=d("sub");e.exports={toString:function(e){return n(e).toString(10)},fromString:i,toNumber:o,fromNumber:f,toEther:function(e){return o(u(e,i("10000000000")))/1e8},fromEther:function(e){return b(f(Math.floor(1e8*e)),i("10000000000"))},toUint256:function(e){return c.pad(32,e)},add:s,mul:b,div:u,sub:l}},function(e,a,t){var r=t(36),c=function(e,a,t){this.value=e||"",this.offset=a,this.rawValue=t};c.prototype.dynamicPartLength=function(){return this.dynamicPart().length/2},c.prototype.withOffset=function(e){return new c(this.value,e)},c.prototype.combine=function(e){return new c(this.value+e.value)},c.prototype.isDynamic=function(){return void 0!==this.offset},c.prototype.offsetAsBytes=function(){return this.isDynamic()?r.toTwosComplement(this.offset).replace("0x",""):""},c.prototype.staticPart=function(){return this.isDynamic()?this.offsetAsBytes():this.value},c.prototype.dynamicPart=function(){return this.isDynamic()?this.value:""},c.prototype.encode=function(){return this.staticPart()+this.dynamicPart()},c.encodeList=function(e){var a=32*e.length,t=e.map(function(e){if(!e.isDynamic())return e;var t=a;return a+=e.dynamicPartLength(),e.withOffset(t)});return t.reduce(function(e,a){return e+a.dynamicPart()},t.reduce(function(e,a){return e+a.staticPart()},""))},e.exports=c},function(e,a,t){var r=t(20),c=t(27),n=t(36),i=t(781),f=t(780),o=t(779),d=t(778),s=t(777),b=t(776),u=t(775),l=function(e,a){return e.isDynamicType(a)||e.isDynamicArray(a)};function p(){}var h=function(e){this._types=e};h.prototype._requireType=function(e){var a=this._types.filter(function(a){return a.isType(e)})[0];if(!a)throw Error("Invalid solidity type: "+e);return a},h.prototype._getOffsets=function(e,a){for(var t=a.map(function(a,t){return a.staticPartLength(e[t])}),r=1;r<t.length;r++)t[r]+=t[r-1];return t.map(function(t,r){return t-a[r].staticPartLength(e[r])})},h.prototype._getSolidityTypes=function(e){var a=this;return e.map(function(e){return a._requireType(e)})},h.prototype._encodeMultiWithOffset=function(e,a,t,r){var c="",i=this;return e.forEach(function(f,o){if(l(a[o],e[o])){c+=n.formatInputInt(r).encode();var d=i._encodeWithOffset(e[o],a[o],t[o],r);r+=d.length/2}else c+=i._encodeWithOffset(e[o],a[o],t[o],r)}),e.forEach(function(n,f){if(l(a[f],e[f])){var o=i._encodeWithOffset(e[f],a[f],t[f],r);r+=o.length/2,c+=o}}),c},h.prototype._encodeWithOffset=function(e,a,t,r){var c=this;return a.isDynamicArray(e)?function(){var i=a.nestedName(e),f=a.staticPartLength(i),o=t[0];return function(){var e=2;if(a.isDynamicArray(i))for(var c=1;c<t.length;c++)e+=+t[c-1][0]||0,o+=n.formatInputInt(r+c*f+32*e).encode()}(),function(){for(var e=0;e<t.length-1;e++){var n=o/2;o+=c._encodeWithOffset(i,a,t[e+1],r+n)}}(),o}():a.isStaticArray(e)?function(){var i=a.nestedName(e),f=a.staticPartLength(i),o="";return a.isDynamicArray(i)&&function(){for(var e=0,a=0;a<t.length;a++)e+=+(t[a-1]||[])[0]||0,o+=n.formatInputInt(r+a*f+32*e).encode()}(),function(){for(var e=0;e<t.length;e++){var n=o/2;o+=c._encodeWithOffset(i,a,t[e],r+n)}}(),o}():t},h.prototype.encodeFunctionSignature=function(e){return r.isObject(e)&&(e=c._jsonInterfaceMethodToString(e)),c.sha3(e).slice(0,10)},h.prototype.encodeEventSignature=function(e){return r.isObject(e)&&(e=c._jsonInterfaceMethodToString(e)),c.sha3(e)},h.prototype.encodeParameter=function(e,a){return this.encodeParameters([e],[a])},h.prototype.encodeParameters=function(e,a){r.isObject(e)&&e.inputs&&(e=r.map(e.inputs,function(e){return e.type}));var t=this._getSolidityTypes(e),c=t.map(function(t,r){return t.encode(a[r],e[r])}),n=t.reduce(function(a,r,c){var n=r.staticPartLength(e[c]),i=32*Math.floor((n+31)/32);return a+(l(t[c],e[c])?32:i)},0);return"0x"+this._encodeMultiWithOffset(e,t,c,n)},h.prototype.encodeFunctionCall=function(e,a){return this.encodeFunctionSignature(e)+this.encodeParameters(e,a).replace("0x","")},h.prototype.decodeParameter=function(e,a){if(!r.isString(e))throw new Error("Given parameter type is not a string: "+e);return this.decodeParameters([{type:e}],a)[0]},h.prototype.decodeParameters=function(e,a){var t=r.isArray(e)&&r.isString(e[0]),c=t?e:[];t||e.forEach(function(e){c.push(e.type)});var n=this._getSolidityTypes(c),i=this._getOffsets(c,n),f=new p;f.__length__=0;var o=0;return e.forEach(function(e,t){var d=n[o].decode(a.replace(/^0x/i,""),i[o],c[o],o);d="0x"===d?null:d,f[t]=d,r.isObject(e)&&e.name&&(f[e.name]=d),f.__length__++,o++}),f},h.prototype.decodeLog=function(e,a,t){a=a||"";var c=[],n=[];e.forEach(function(e,a){e.indexed?n[a]=e:c[a]=e});var i=a.slice(2),f=r.isArray(t)?t.map(function(e){return e.slice(2)}).join(""):t,o=this.decodeParameters(c,i),d=this.decodeParameters(n,f),s=new p;return s.__length__=0,e.forEach(function(e,a){s[a]="string"===e.type?"":null,o[a]&&(s[a]=o[a]),d[a]&&(s[a]=d[a]),e.name&&(s[e.name]=s[a]),s.__length__++}),s};var m=new h([new i,new f,new o,new d,new s,new u,new b]);e.exports=m},function(e,a,t){"use strict";var r=t(51),c=t(50),n=t(27),i=t(113),f=t(21).formatters,o=function(){var e=this;r.packageInit(this,arguments),this.net=new i(this.currentProvider);var a=null,t="latest";Object.defineProperty(this,"defaultAccount",{get:function(){return a},set:function(e){return e&&(a=n.toChecksumAddress(f.inputAddressFormatter(e))),o.forEach(function(e){e.defaultAccount=a}),e},enumerable:!0}),Object.defineProperty(this,"defaultBlock",{get:function(){return t},set:function(e){return t=e,o.forEach(function(e){e.defaultBlock=t}),e},enumerable:!0});var o=[new c({name:"getAccounts",call:"personal_listAccounts",params:0,outputFormatter:n.toChecksumAddress}),new c({name:"newAccount",call:"personal_newAccount",params:1,inputFormatter:[null],outputFormatter:n.toChecksumAddress}),new c({name:"unlockAccount",call:"personal_unlockAccount",params:3,inputFormatter:[f.inputAddressFormatter,null,null]}),new c({name:"lockAccount",call:"personal_lockAccount",params:1,inputFormatter:[f.inputAddressFormatter]}),new c({name:"importRawKey",call:"personal_importRawKey",params:2}),new c({name:"sendTransaction",call:"personal_sendTransaction",params:2,inputFormatter:[f.inputTransactionFormatter,null]}),new c({name:"signTransaction",call:"personal_signTransaction",params:2,inputFormatter:[f.inputTransactionFormatter,null]}),new c({name:"sign",call:"personal_sign",params:3,inputFormatter:[f.inputSignFormatter,f.inputAddressFormatter,null]}),new c({name:"ecRecover",call:"personal_ecRecover",params:2,inputFormatter:[f.inputSignFormatter,null]})];o.forEach(function(a){a.attachToObject(e),a.setRequestManager(e._requestManager),a.defaultBlock=e.defaultBlock,a.defaultAccount=e.defaultAccount})};r.addProviders(o),e.exports=o},function(e,a,t){"use strict";var r="function"!=typeof Object.create&&"~";function c(e,a,t){this.fn=e,this.context=a,this.once=t||!1}function n(){}n.prototype._events=void 0,n.prototype.listeners=function(e,a){var t=r?r+e:e,c=this._events&&this._events[t];if(a)return!!c;if(!c)return[];if(c.fn)return[c.fn];for(var n=0,i=c.length,f=new Array(i);n<i;n++)f[n]=c[n].fn;return f},n.prototype.emit=function(e,a,t,c,n,i){var f=r?r+e:e;if(!this._events||!this._events[f])return!1;var o,d,s=this._events[f],b=arguments.length;if("function"==typeof s.fn){switch(s.once&&this.removeListener(e,s.fn,void 0,!0),b){case 1:return s.fn.call(s.context),!0;case 2:return s.fn.call(s.context,a),!0;case 3:return s.fn.call(s.context,a,t),!0;case 4:return s.fn.call(s.context,a,t,c),!0;case 5:return s.fn.call(s.context,a,t,c,n),!0;case 6:return s.fn.call(s.context,a,t,c,n,i),!0}for(d=1,o=new Array(b-1);d<b;d++)o[d-1]=arguments[d];s.fn.apply(s.context,o)}else{var u,l=s.length;for(d=0;d<l;d++)switch(s[d].once&&this.removeListener(e,s[d].fn,void 0,!0),b){case 1:s[d].fn.call(s[d].context);break;case 2:s[d].fn.call(s[d].context,a);break;case 3:s[d].fn.call(s[d].context,a,t);break;default:if(!o)for(u=1,o=new Array(b-1);u<b;u++)o[u-1]=arguments[u];s[d].fn.apply(s[d].context,o)}}return!0},n.prototype.on=function(e,a,t){var n=new c(a,t||this),i=r?r+e:e;return this._events||(this._events=r?{}:Object.create(null)),this._events[i]?this._events[i].fn?this._events[i]=[this._events[i],n]:this._events[i].push(n):this._events[i]=n,this},n.prototype.once=function(e,a,t){var n=new c(a,t||this,!0),i=r?r+e:e;return this._events||(this._events=r?{}:Object.create(null)),this._events[i]?this._events[i].fn?this._events[i]=[this._events[i],n]:this._events[i].push(n):this._events[i]=n,this},n.prototype.removeListener=function(e,a,t,c){var n=r?r+e:e;if(!this._events||!this._events[n])return this;var i=this._events[n],f=[];if(a)if(i.fn)(i.fn!==a||c&&!i.once||t&&i.context!==t)&&f.push(i);else for(var o=0,d=i.length;o<d;o++)(i[o].fn!==a||c&&!i[o].once||t&&i[o].context!==t)&&f.push(i[o]);return f.length?this._events[n]=1===f.length?f[0]:f:delete this._events[n],this},n.prototype.removeAllListeners=function(e){return this._events?(e?delete this._events[r?r+e:e]:this._events=r?{}:Object.create(null),this):this},n.prototype.off=n.prototype.removeListener,n.prototype.addListener=n.prototype.on,n.prototype.setMaxListeners=function(){return this},n.prefixed=r,e.exports=n},function(e,a,t){"use strict";var r=t(309),c=t(82),n=function(e){var a,t,n=new c(function(){a=arguments[0],t=arguments[1]});if(e)return{resolve:a,reject:t,eventEmitter:n};var i=new r;return n._events=i._events,n.emit=i.emit,n.on=i.on,n.once=i.once,n.off=i.off,n.listeners=i.listeners,n.addListener=i.addListener,n.removeListener=i.removeListener,n.removeAllListeners=i.removeAllListeners,{resolve:a,reject:t,eventEmitter:n}};n.resolve=function(e){var a=n(!0);return a.resolve(e),a.eventEmitter},e.exports=n},function(e,a,t){e.exports={EventTarget:t(798),Event:t(797)}},function(e,a,t){var r=t(799).strict;e.exports=function(e){if(r(e)){var a=Buffer.from(e.buffer);return e.byteLength!==e.buffer.byteLength&&(a=a.slice(e.byteOffset,e.byteOffset+e.byteLength)),a}return Buffer.from(e)}},function(e,a,t){var r=t(83),c=r.extend,n=t(1),i=t(5).EventEmitter,f=t(43),o=t(59),d=t(32),s=t(10),b=t(166),u=["(",")","<",">","@",",",";",":","\\",'"',"/","[","]","?","=","{","}"," ",String.fromCharCode(9)];function l(e){var a;(i.call(this),this.config={maxReceivedFrameSize:1048576,maxReceivedMessageSize:8388608,fragmentOutgoingMessages:!0,fragmentationThreshold:16384,webSocketVersion:13,assembleFragments:!0,disableNagleAlgorithm:!0,closeTimeout:5e3,tlsOptions:{}},e)&&(e.tlsOptions?(a=e.tlsOptions,delete e.tlsOptions):a={},c(this.config,e),c(this.config.tlsOptions,a));switch(this._req=null,this.config.webSocketVersion){case 8:case 13:break;default:throw new Error("Requested webSocketVersion is not supported. Allowed values are 8 and 13.")}}n.inherits(l,i),l.prototype.connect=function(e,a,t,n,i){var s=this;if("string"==typeof a&&(a=a.length>0?[a]:[]),a instanceof Array||(a=[]),this.protocols=a,this.origin=t,this.url="string"==typeof e?d.parse(e):e,!this.url.protocol)throw new Error("You must specify a full WebSocket URL, including protocol.");if(!this.url.host)throw new Error("You must specify a full WebSocket URL, including hostname. Relative URLs are not supported.");this.secure="wss:"===this.url.protocol,this.protocols.forEach(function(e){for(var a=0;a<e.length;a++){var t=e.charCodeAt(a),r=e.charAt(a);if(t<33||t>126||-1!==u.indexOf(r))throw new Error('Protocol list contains invalid character "'+String.fromCharCode(t)+'"')}});this.url.port||(this.url.port={"ws:":"80","wss:":"443"}[this.url.protocol]);for(var b=new Buffer(16),l=0;l<16;l++)b[l]=Math.round(255*Math.random());this.base64nonce=b.toString("base64");var p=this.url.hostname;("ws:"===this.url.protocol&&"80"!==this.url.port||"wss:"===this.url.protocol&&"443"!==this.url.port)&&(p+=":"+this.url.port);var h,m=n||{};function g(e){s._req=null,s.emit("connectFailed",e)}c(m,{Upgrade:"websocket",Connection:"Upgrade","Sec-WebSocket-Version":this.config.webSocketVersion.toString(10),"Sec-WebSocket-Key":this.base64nonce,Host:m.Host||p}),this.protocols.length>0&&(m["Sec-WebSocket-Protocol"]=this.protocols.join(", ")),this.origin&&(13===this.config.webSocketVersion?m.Origin=this.origin:8===this.config.webSocketVersion&&(m["Sec-WebSocket-Origin"]=this.origin)),h=this.url.pathname?this.url.path:this.url.path?"/"+this.url.path:"/";var v={agent:!1};if(i&&c(v,i),c(v,{hostname:this.url.hostname,port:this.url.port,method:"GET",path:h,headers:m}),this.secure)for(var y in s.config.tlsOptions)s.config.tlsOptions.hasOwnProperty(y)&&(v[y]=s.config.tlsOptions[y]);var _=this._req=(this.secure?o:f).request(v);_.on("upgrade",function(e,a,t){s._req=null,_.removeListener("error",g),s.socket=a,s.response=e,s.firstDataChunk=t,s.validateHandshake()}),_.on("error",g),_.on("response",function(e){if(s._req=null,r.eventEmitterListenerCount(s,"httpResponse")>0)s.emit("httpResponse",e,s),e.socket&&e.socket.end();else{var a=[];for(var t in e.headers)a.push(t+": "+e.headers[t]);s.failHandshake("Server responded with a non-101 status: "+e.statusCode+" "+e.statusMessage+"\nResponse Headers Follow:\n"+a.join("\n")+"\n")}}),_.end()},l.prototype.validateHandshake=function(){var e=this.response.headers;if(this.protocols.length>0){if(this.protocol=e["sec-websocket-protocol"],!this.protocol)return void this.failHandshake("Expected a Sec-WebSocket-Protocol header.");if(-1===this.protocols.indexOf(this.protocol))return void this.failHandshake("Server did not respond with a requested protocol.")}if(e.connection&&"upgrade"===e.connection.toLocaleLowerCase())if(e.upgrade&&"websocket"===e.upgrade.toLocaleLowerCase()){var a=s.createHash("sha1");a.update(this.base64nonce+"258EAFA5-E914-47DA-95CA-C5AB0DC85B11");var t=a.digest("base64");e["sec-websocket-accept"]?e["sec-websocket-accept"]===t?this.succeedHandshake():this.failHandshake("Sec-WebSocket-Accept header from server didn't match expected value of "+t):this.failHandshake("Expected Sec-WebSocket-Accept header from server")}else this.failHandshake("Expected an Upgrade: websocket header from the server");else this.failHandshake("Expected a Connection: Upgrade header from the server")},l.prototype.failHandshake=function(e){this.socket&&this.socket.writable&&this.socket.end(),this.emit("connectFailed",new Error(e))},l.prototype.succeedHandshake=function(){var e=new b(this.socket,[],this.protocol,!0,this.config);e.webSocketVersion=this.config.webSocketVersion,e._addSocketEventListeners(),this.emit("connect",e),this.firstDataChunk.length>0&&e.handleSocketData(this.firstDataChunk),this.firstDataChunk=null},l.prototype.abort=function(){this._req&&this._req.abort()},e.exports=l},function(e,a,t){var r=t(807).BufferUtil;const c=1;function n(e,a,t){this.maskBytes=e,this.frameHeader=a,this.config=t,this.maxReceivedFrameSize=t.maxReceivedFrameSize,this.protocolError=!1,this.frameTooLarge=!1,this.invalidCloseFrameLength=!1,this.parseState=c,this.closeStatus=-1}n.prototype.addData=function(e){if(this.parseState===c&&e.length>=2){e.joinInto(this.frameHeader,0,0,2),e.advance(2);var a=this.frameHeader[0],t=this.frameHeader[1];if(this.fin=Boolean(128&a),this.rsv1=Boolean(64&a),this.rsv2=Boolean(32&a),this.rsv3=Boolean(16&a),this.mask=Boolean(128&t),this.opcode=15&a,this.length=127&t,this.opcode>=8){if(this.length>125)return this.protocolError=!0,this.dropReason="Illegal control frame longer than 125 bytes.",!0;if(!this.fin)return this.protocolError=!0,this.dropReason="Control frames must not be fragmented.",!0}126===this.length?this.parseState=2:127===this.length?this.parseState=3:this.parseState=4}if(2===this.parseState)e.length>=2&&(e.joinInto(this.frameHeader,2,0,2),e.advance(2),this.length=this.frameHeader.readUInt16BE(2),this.parseState=4);else if(3===this.parseState&&e.length>=8){e.joinInto(this.frameHeader,2,0,8),e.advance(8);var n=[this.frameHeader.readUInt32BE(2),this.frameHeader.readUInt32BE(6)];if(0!==n[0])return this.protocolError=!0,this.dropReason="Unsupported 64-bit length frame received",!0;this.length=n[1],this.parseState=4}if(4===this.parseState&&(this.mask?e.length>=4&&(e.joinInto(this.maskBytes,0,0,4),e.advance(4),this.parseState=5):this.parseState=5),5===this.parseState){if(this.length>this.maxReceivedFrameSize)return this.frameTooLarge=!0,this.dropReason="Frame size of "+this.length.toString(10)+" bytes exceeds maximum accepted frame size",!0;if(0===this.length)return this.binaryPayload=new Buffer(0),this.parseState=6,!0;if(e.length>=this.length)return this.binaryPayload=e.take(this.length),e.advance(this.length),this.mask&&r.unmask(this.binaryPayload,this.maskBytes),8===this.opcode&&(1===this.length&&(this.binaryPayload=new Buffer(0),this.invalidCloseFrameLength=!0),this.length>=2&&(this.closeStatus=this.binaryPayload.readUInt16BE(0),this.binaryPayload=this.binaryPayload.slice(2))),this.parseState=6,!0}return!1},n.prototype.throwAwayPayload=function(e){return e.length>=this.length&&(e.advance(this.length),this.parseState=6,!0)},n.prototype.toBuffer=function(e){var a,t,c,n=2,i=0,f=0;this.fin&&(i|=128),this.rsv1&&(i|=64),this.rsv2&&(i|=32),this.rsv3&&(i|=16),this.mask&&(f|=128),i|=15&this.opcode,8===this.opcode?(this.length=2,this.binaryPayload&&(this.length+=this.binaryPayload.length),(t=new Buffer(this.length)).writeUInt16BE(this.closeStatus,0),this.length>2&&this.binaryPayload.copy(t,2)):this.binaryPayload?(t=this.binaryPayload,this.length=t.length):this.length=0,this.length<=125?f|=127&this.length:this.length>125&&this.length<=65535?(f|=126,n+=2):this.length>65535&&(f|=127,n+=8);var o=new Buffer(this.length+n+(this.mask?4:0));return o[0]=i,o[1]=f,c=2,this.length>125&&this.length<=65535?(o.writeUInt16BE(this.length,c),c+=2):this.length>65535&&(o.writeUInt32BE(0,c),o.writeUInt32BE(this.length,c+4),c+=8),this.mask?(a=e?0:4294967295*Math.random()>>>0,this.maskBytes.writeUInt32BE(a,0),this.maskBytes.copy(o,c),c+=4,t&&r.mask(t,this.maskBytes,o,c,this.length)):t&&t.copy(o,c),o},n.prototype.toString=function(){return"Opcode: "+this.opcode+", fin: "+this.fin+", length: "+this.length+", hasPayload: "+Boolean(this.binaryPayload)+", masked: "+this.mask},e.exports=n},function(e,a,t){for(var r=t(10),c=t(1),n=t(32),i=t(5).EventEmitter,f=t(166),o=/,\s*/,d=/;\s*/,s=/[\r\n]/g,b=/,\s*/,u=["(",")","<",">","@",",",";",":","\\",'"',"/","[","]","?","=","{","}"," ",String.fromCharCode(9)],l=[String.fromCharCode(127)],p=0;p<31;p++)l.push(String.fromCharCode(p));var h=/([\x00-\x20\x22\x28\x29\x2c\x2f\x3a-\x3f\x40\x5b-\x5e\x7b\x7d\x7f])/,m=/[^\x21\x23-\x2b\x2d-\x3a\x3c-\x5b\x5d-\x7e]/,g=/^"[^"]*"$/,v=/[\x00-\x20\x3b]/g,y=/[;,] */,_={100:"Continue",101:"Switching Protocols",200:"OK",201:"Created",203:"Non-Authoritative Information",204:"No Content",205:"Reset Content",206:"Partial Content",300:"Multiple Choices",301:"Moved Permanently",302:"Found",303:"See Other",304:"Not Modified",305:"Use Proxy",307:"Temporary Redirect",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",406:"Not Acceptable",407:"Proxy Authorization Required",408:"Request Timeout",409:"Conflict",410:"Gone",411:"Length Required",412:"Precondition Failed",413:"Request Entity Too Long",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Requested Range Not Satisfiable",417:"Expectation Failed",426:"Upgrade Required",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Gateway Timeout",505:"HTTP Version Not Supported"};function w(e,a,t){i.call(this),this.socket=e,this.httpRequest=a,this.resource=a.url,this.remoteAddress=e.remoteAddress,this.remoteAddresses=[this.remoteAddress],this.serverConfig=t,this._socketIsClosing=!1,this._socketCloseHandler=this._handleSocketCloseBeforeAccept.bind(this),this.socket.on("end",this._socketCloseHandler),this.socket.on("close",this._socketCloseHandler),this._resolved=!1}function A(e){process.nextTick(function(){e.drop(1006,"TCP connection lost before handshake completed.",!0)})}c.inherits(w,i),w.prototype.readHandshake=function(){var e=this,a=this.httpRequest;if(this.resourceURL=n.parse(this.resource,!0),this.host=a.headers.host,!this.host)throw new Error("Client must provide a Host header.");if(this.key=a.headers["sec-websocket-key"],!this.key)throw new Error("Client must provide a value for Sec-WebSocket-Key.");if(this.webSocketVersion=parseInt(a.headers["sec-websocket-version"],10),!this.webSocketVersion||isNaN(this.webSocketVersion))throw new Error("Client must provide a value for Sec-WebSocket-Version.");switch(this.webSocketVersion){case 8:case 13:break;default:var t=new Error("Unsupported websocket client version: "+this.webSocketVersion+"Only versions 8 and 13 are supported.");throw t.httpCode=426,t.headers={"Sec-WebSocket-Version":"13"},t}13===this.webSocketVersion?this.origin=a.headers.origin:8===this.webSocketVersion&&(this.origin=a.headers["sec-websocket-origin"]);var r=a.headers["sec-websocket-protocol"];(this.protocolFullCaseMap={},this.requestedProtocols=[],r)&&r.split(o).forEach(function(a){var t=a.toLocaleLowerCase();e.requestedProtocols.push(t),e.protocolFullCaseMap[t]=a});if(!this.serverConfig.ignoreXForwardedFor&&a.headers["x-forwarded-for"]){var c=this.remoteAddress;this.remoteAddresses=a.headers["x-forwarded-for"].split(b),this.remoteAddresses.push(c),this.remoteAddress=this.remoteAddresses[0]}var i=a.headers["sec-websocket-extensions"];this.requestedExtensions=this.parseExtensions(i);var f=a.headers.cookie;this.cookies=this.parseCookies(f)},w.prototype.parseExtensions=function(e){if(!e||0===e.length)return[];var a=e.toLocaleLowerCase().split(o);return a.forEach(function(e,a,t){var r=e.split(d),c=r[0],n=r.slice(1);n.forEach(function(e,a,t){var r=e.split("="),c={name:r[0],value:r[1]};t.splice(a,1,c)});var i={name:c,params:n};t.splice(a,1,i)}),a},w.prototype.parseCookies=function(e){if(!e||"string"!=typeof e)return[];var a=[];return e.split(y).forEach(function(e){var t=e.indexOf("=");if(-1!==t){var r=e.substr(0,t).trim(),c=e.substr(++t,e.length).trim();'"'===c[0]&&(c=c.slice(1,-1)),a.push({name:r,value:decodeURIComponent(c)})}else a.push({name:e,value:null})}),a},w.prototype.accept=function(e,a,t){var c;this._verifyResolution(),e?void 0===(c=this.protocolFullCaseMap[e.toLocaleLowerCase()])&&(c=e):c=e,this.protocolFullCaseMap=null;var n=r.createHash("sha1");n.update(this.key+"258EAFA5-E914-47DA-95CA-C5AB0DC85B11");var i="HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Accept: "+n.digest("base64")+"\r\n";if(c){for(var o=0;o<c.length;o++){var d=c.charCodeAt(o),b=c.charAt(o);if(d<33||d>126||-1!==u.indexOf(b))throw this.reject(500),new Error('Illegal character "'+String.fromCharCode(b)+'" in subprotocol.')}if(-1===this.requestedProtocols.indexOf(e))throw this.reject(500),new Error("Specified protocol was not requested by the client.");c=c.replace(s,""),i+="Sec-WebSocket-Protocol: "+c+"\r\n"}if(this.requestedProtocols=null,a&&(a=a.replace(s,""),13===this.webSocketVersion?i+="Origin: "+a+"\r\n":8===this.webSocketVersion&&(i+="Sec-WebSocket-Origin: "+a+"\r\n")),t){if(!Array.isArray(t))throw this.reject(500),new Error('Value supplied for "cookies" argument must be an array.');var l={};t.forEach(function(e){if(!e.name||!e.value)throw this.reject(500),new Error('Each cookie to set must at least provide a "name" and "value"');if(e.name=e.name.replace(v,""),e.value=e.value.replace(v,""),l[e.name])throw this.reject(500),new Error("You may not specify the same cookie name twice.");l[e.name]=!0;var a=e.name.match(h);if(a)throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie name");if(a=e.value.match(g)?e.value.slice(1,-1).match(m):e.value.match(m))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie value");var t=[e.name+"="+e.value];if(e.path){if(a=e.path.match(v))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie path");t.push("Path="+e.path)}if(e.domain){if("string"!=typeof e.domain)throw this.reject(500),new Error("Domain must be specified and must be a string.");if(a=e.domain.match(v))throw this.reject(500),new Error("Illegal character "+a[0]+" in cookie domain");t.push("Domain="+e.domain.toLowerCase())}if(e.expires){if(!(e.expires instanceof Date))throw this.reject(500),new Error('Value supplied for cookie "expires" must be a vaild date object');t.push("Expires="+e.expires.toGMTString())}if(e.maxage){var r=e.maxage;if("string"==typeof r&&(r=parseInt(r,10)),isNaN(r)||r<=0)throw this.reject(500),new Error('Value supplied for cookie "maxage" must be a non-zero number');r=Math.round(r),t.push("Max-Age="+r.toString(10))}if(e.secure){if("boolean"!=typeof e.secure)throw this.reject(500),new Error('Value supplied for cookie "secure" must be of type boolean');t.push("Secure")}if(e.httponly){if("boolean"!=typeof e.httponly)throw this.reject(500),new Error('Value supplied for cookie "httponly" must be of type boolean');t.push("HttpOnly")}i+="Set-Cookie: "+t.join(";")+"\r\n"}.bind(this))}this._resolved=!0,this.emit("requestResolved",this),i+="\r\n";var p=new f(this.socket,[],e,!1,this.serverConfig);p.webSocketVersion=this.webSocketVersion,p.remoteAddress=this.remoteAddress,p.remoteAddresses=this.remoteAddresses;var y=this;return this._socketIsClosing?A(p):this.socket.write(i,"ascii",function(e){e?A(p):(y._removeSocketCloseListeners(),p._addSocketEventListeners())}),this.emit("requestAccepted",p),p},w.prototype.reject=function(e,a,t){this._verifyResolution(),this._resolved=!0,this.emit("requestResolved",this),"number"!=typeof e&&(e=403);var r="HTTP/1.1 "+e+" "+_[e]+"\r\nConnection: close\r\n";if(a&&(r+="X-WebSocket-Reject-Reason: "+(a=a.replace(s,""))+"\r\n"),t)for(var c in t){var n=t[c].toString().replace(s,"");r+=c.replace(s,"")+": "+n+"\r\n"}r+="\r\n",this.socket.end(r,"ascii"),this.emit("requestRejected",this)},w.prototype._handleSocketCloseBeforeAccept=function(){this._socketIsClosing=!0,this._removeSocketCloseListeners()},w.prototype._removeSocketCloseListeners=function(){this.socket.removeListener("end",this._socketCloseHandler),this.socket.removeListener("close",this._socketCloseHandler)},w.prototype._verifyResolution=function(){if(this._resolved)throw new Error("WebSocketRequest may only be accepted or rejected one time.")},e.exports=w},function(e,a,t){var r;function c(e){function t(){if(t.enabled){var e=t,c=+new Date,n=c-(r||c);e.diff=n,e.prev=r,e.curr=c,r=c;for(var i=new Array(arguments.length),f=0;f<i.length;f++)i[f]=arguments[f];i[0]=a.coerce(i[0]),"string"!=typeof i[0]&&i.unshift("%O");var o=0;i[0]=i[0].replace(/%([a-zA-Z%])/g,function(t,r){if("%%"===t)return t;o++;var c=a.formatters[r];if("function"==typeof c){var n=i[o];t=c.call(e,n),i.splice(o,1),o--}return t}),a.formatArgs.call(e,i),(t.log||a.log||console.log.bind(console)).apply(e,i)}}return t.namespace=e,t.enabled=a.enabled(e),t.useColors=a.useColors(),t.color=function(e){var t,r=0;for(t in e)r=(r<<5)-r+e.charCodeAt(t),r|=0;return a.colors[Math.abs(r)%a.colors.length]}(e),"function"==typeof a.init&&a.init(t),t}(a=e.exports=c.debug=c.default=c).coerce=function(e){return e instanceof Error?e.stack||e.message:e},a.disable=function(){a.enable("")},a.enable=function(e){a.save(e),a.names=[],a.skips=[];for(var t=("string"==typeof e?e:"").split(/[\s,]+/),r=t.length,c=0;c<r;c++)t[c]&&("-"===(e=t[c].replace(/\*/g,".*?"))[0]?a.skips.push(new RegExp("^"+e.substr(1)+"$")):a.names.push(new RegExp("^"+e+"$")))},a.enabled=function(e){var t,r;for(t=0,r=a.skips.length;t<r;t++)if(a.skips[t].test(e))return!1;for(t=0,r=a.names.length;t<r;t++)if(a.names[t].test(e))return!0;return!1},a.humanize=t(811),a.names=[],a.skips=[],a.formatters={}},function(e,a,t){"use strict";var r={messageId:0,toPayload:function(e,a){if(!e)throw new Error('JSONRPC method should be specified for params: "'+JSON.stringify(a)+'"!');return r.messageId++,{jsonrpc:"2.0",id:r.messageId,method:e,params:a||[]}},isValidResponse:function(e){return Array.isArray(e)?e.every(a):a(e);function a(e){return!(!e||e.error||"2.0"!==e.jsonrpc||"number"!=typeof e.id&&"string"!=typeof e.id||void 0===e.result)}},toBatchPayload:function(e){return e.map(function(e){return r.toPayload(e.method,e.params)})}};e.exports=r},function(e,a,t){"use strict";var r=t(27),c=t(9),n=function(e){var a="A".charCodeAt(0),t="Z".charCodeAt(0);return(e=(e=e.toUpperCase()).substr(4)+e.substr(0,4)).split("").map(function(e){var r=e.charCodeAt(0);return r>=a&&r<=t?r-a+10:e}).join("")},i=function(e){for(var a,t=e;t.length>2;)a=t.slice(0,9),t=parseInt(a,10)%97+t.slice(a.length);return parseInt(t,10)%97},f=function(e){this._iban=e};f.toAddress=function(e){if(!(e=new f(e)).isDirect())throw new Error("IBAN is indirect and can't be converted");return e.toAddress()},f.toIban=function(e){return f.fromAddress(e).toString()},f.fromAddress=function(e){if(!r.isAddress(e))throw new Error("Provided address is not a valid address: "+e);e=e.replace("0x","").replace("0X","");var a=function(e,a){for(var t=e;t.length<2*a;)t="0"+t;return t}(new c(e,16).toString(36),15);return f.fromBban(a.toUpperCase())},f.fromBban=function(e){var a=("0"+(98-i(n("XE00"+e)))).slice(-2);return new f("XE"+a+e)},f.createIndirect=function(e){return f.fromBban("ETH"+e.institution+e.identifier)},f.isValid=function(e){return new f(e).isValid()},f.prototype.isValid=function(){return/^XE[0-9]{2}(ETH[0-9A-Z]{13}|[0-9A-Z]{30,31})$/.test(this._iban)&&1===i(n(this._iban))},f.prototype.isDirect=function(){return 34===this._iban.length||35===this._iban.length},f.prototype.isIndirect=function(){return 20===this._iban.length},f.prototype.checksum=function(){return this._iban.substr(2,2)},f.prototype.institution=function(){return this.isIndirect()?this._iban.substr(7,4):""},f.prototype.client=function(){return this.isIndirect()?this._iban.substr(11):""},f.prototype.toAddress=function(){if(this.isDirect()){var e=this._iban.substr(4),a=new c(e,36);return r.toChecksumAddress(a.toString(16,20))}return""},f.prototype.toString=function(){return this._iban},e.exports=f},function(e,a){var t="0123456789abcdef".split(""),r=[1,256,65536,16777216],c=[0,8,16,24],n=[1,0,32898,0,32906,2147483648,2147516416,2147483648,32907,0,2147483649,0,2147516545,2147483648,32777,2147483648,138,0,136,0,2147516425,0,2147483658,0,2147516555,0,139,2147483648,32905,2147483648,32771,2147483648,32770,2147483648,128,2147483648,32778,0,2147483658,2147483648,2147516545,2147483648,32896,2147483648,2147483649,0,2147516424,2147483648],i=function(e){var a,t,r,c,i,f,o,d,s,b,u,l,p,h,m,g,v,y,_,w,A,k,x,E,S,T,j,C,R,O,B,M,N,I,P,F,L,D,z,q,U,H,V,G,W,Y,K,Q,Z,J,X,$,ee,ae,te,re,ce,ne,ie,fe,oe,de,se;for(r=0;r<48;r+=2)c=e[0]^e[10]^e[20]^e[30]^e[40],i=e[1]^e[11]^e[21]^e[31]^e[41],f=e[2]^e[12]^e[22]^e[32]^e[42],o=e[3]^e[13]^e[23]^e[33]^e[43],d=e[4]^e[14]^e[24]^e[34]^e[44],s=e[5]^e[15]^e[25]^e[35]^e[45],b=e[6]^e[16]^e[26]^e[36]^e[46],u=e[7]^e[17]^e[27]^e[37]^e[47],a=(l=e[8]^e[18]^e[28]^e[38]^e[48])^(f<<1|o>>>31),t=(p=e[9]^e[19]^e[29]^e[39]^e[49])^(o<<1|f>>>31),e[0]^=a,e[1]^=t,e[10]^=a,e[11]^=t,e[20]^=a,e[21]^=t,e[30]^=a,e[31]^=t,e[40]^=a,e[41]^=t,a=c^(d<<1|s>>>31),t=i^(s<<1|d>>>31),e[2]^=a,e[3]^=t,e[12]^=a,e[13]^=t,e[22]^=a,e[23]^=t,e[32]^=a,e[33]^=t,e[42]^=a,e[43]^=t,a=f^(b<<1|u>>>31),t=o^(u<<1|b>>>31),e[4]^=a,e[5]^=t,e[14]^=a,e[15]^=t,e[24]^=a,e[25]^=t,e[34]^=a,e[35]^=t,e[44]^=a,e[45]^=t,a=d^(l<<1|p>>>31),t=s^(p<<1|l>>>31),e[6]^=a,e[7]^=t,e[16]^=a,e[17]^=t,e[26]^=a,e[27]^=t,e[36]^=a,e[37]^=t,e[46]^=a,e[47]^=t,a=b^(c<<1|i>>>31),t=u^(i<<1|c>>>31),e[8]^=a,e[9]^=t,e[18]^=a,e[19]^=t,e[28]^=a,e[29]^=t,e[38]^=a,e[39]^=t,e[48]^=a,e[49]^=t,h=e[0],m=e[1],Y=e[11]<<4|e[10]>>>28,K=e[10]<<4|e[11]>>>28,C=e[20]<<3|e[21]>>>29,R=e[21]<<3|e[20]>>>29,fe=e[31]<<9|e[30]>>>23,oe=e[30]<<9|e[31]>>>23,H=e[40]<<18|e[41]>>>14,V=e[41]<<18|e[40]>>>14,I=e[2]<<1|e[3]>>>31,P=e[3]<<1|e[2]>>>31,g=e[13]<<12|e[12]>>>20,v=e[12]<<12|e[13]>>>20,Q=e[22]<<10|e[23]>>>22,Z=e[23]<<10|e[22]>>>22,O=e[33]<<13|e[32]>>>19,B=e[32]<<13|e[33]>>>19,de=e[42]<<2|e[43]>>>30,se=e[43]<<2|e[42]>>>30,ae=e[5]<<30|e[4]>>>2,te=e[4]<<30|e[5]>>>2,F=e[14]<<6|e[15]>>>26,L=e[15]<<6|e[14]>>>26,y=e[25]<<11|e[24]>>>21,_=e[24]<<11|e[25]>>>21,J=e[34]<<15|e[35]>>>17,X=e[35]<<15|e[34]>>>17,M=e[45]<<29|e[44]>>>3,N=e[44]<<29|e[45]>>>3,E=e[6]<<28|e[7]>>>4,S=e[7]<<28|e[6]>>>4,re=e[17]<<23|e[16]>>>9,ce=e[16]<<23|e[17]>>>9,D=e[26]<<25|e[27]>>>7,z=e[27]<<25|e[26]>>>7,w=e[36]<<21|e[37]>>>11,A=e[37]<<21|e[36]>>>11,$=e[47]<<24|e[46]>>>8,ee=e[46]<<24|e[47]>>>8,G=e[8]<<27|e[9]>>>5,W=e[9]<<27|e[8]>>>5,T=e[18]<<20|e[19]>>>12,j=e[19]<<20|e[18]>>>12,ne=e[29]<<7|e[28]>>>25,ie=e[28]<<7|e[29]>>>25,q=e[38]<<8|e[39]>>>24,U=e[39]<<8|e[38]>>>24,k=e[48]<<14|e[49]>>>18,x=e[49]<<14|e[48]>>>18,e[0]=h^~g&y,e[1]=m^~v&_,e[10]=E^~T&C,e[11]=S^~j&R,e[20]=I^~F&D,e[21]=P^~L&z,e[30]=G^~Y&Q,e[31]=W^~K&Z,e[40]=ae^~re&ne,e[41]=te^~ce&ie,e[2]=g^~y&w,e[3]=v^~_&A,e[12]=T^~C&O,e[13]=j^~R&B,e[22]=F^~D&q,e[23]=L^~z&U,e[32]=Y^~Q&J,e[33]=K^~Z&X,e[42]=re^~ne&fe,e[43]=ce^~ie&oe,e[4]=y^~w&k,e[5]=_^~A&x,e[14]=C^~O&M,e[15]=R^~B&N,e[24]=D^~q&H,e[25]=z^~U&V,e[34]=Q^~J&$,e[35]=Z^~X&ee,e[44]=ne^~fe&de,e[45]=ie^~oe&se,e[6]=w^~k&h,e[7]=A^~x&m,e[16]=O^~M&E,e[17]=B^~N&S,e[26]=q^~H&I,e[27]=U^~V&P,e[36]=J^~$&G,e[37]=X^~ee&W,e[46]=fe^~de&ae,e[47]=oe^~se&te,e[8]=k^~h&g,e[9]=x^~m&v,e[18]=M^~E&T,e[19]=N^~S&j,e[28]=H^~I&F,e[29]=V^~P&L,e[38]=$^~G&Y,e[39]=ee^~W&K,e[48]=de^~ae&re,e[49]=se^~te&ce,e[0]^=n[r],e[1]^=n[r+1]},f=function(e){return function(a){var n;if("0x"===a.slice(0,2)){n=[];for(var f=2,o=a.length;f<o;f+=2)n.push(parseInt(a.slice(f,f+2),16))}else n=a;return function(e,a){for(var n,f=a.length,o=e.blocks,d=e.blockCount<<2,s=e.blockCount,b=e.outputBlocks,u=e.s,l=0;l<f;){if(e.reset)for(e.reset=!1,o[0]=e.block,m=1;m<s+1;++m)o[m]=0;if("string"!=typeof a)for(m=e.start;l<f&&m<d;++l)o[m>>2]|=a[l]<<c[3&m++];else for(m=e.start;l<f&&m<d;++l)(n=a.charCodeAt(l))<128?o[m>>2]|=n<<c[3&m++]:n<2048?(o[m>>2]|=(192|n>>6)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]):n<55296||n>=57344?(o[m>>2]|=(224|n>>12)<<c[3&m++],o[m>>2]|=(128|n>>6&63)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]):(n=65536+((1023&n)<<10|1023&a.charCodeAt(++l)),o[m>>2]|=(240|n>>18)<<c[3&m++],o[m>>2]|=(128|n>>12&63)<<c[3&m++],o[m>>2]|=(128|n>>6&63)<<c[3&m++],o[m>>2]|=(128|63&n)<<c[3&m++]);if(e.lastByteIndex=m,m>=d){for(e.start=m-d,e.block=o[s],m=0;m<s;++m)u[m]^=o[m];i(u),e.reset=!0}else e.start=m}if(o[(m=e.lastByteIndex)>>2]|=r[3&m],e.lastByteIndex===d)for(o[0]=o[s],m=1;m<s+1;++m)o[m]=0;for(o[s-1]|=2147483648,m=0;m<s;++m)u[m]^=o[m];i(u);for(var p,h="",m=0,g=0;g<b;){for(m=0;m<s&&g<b;++m,++g)p=u[m],h+=t[p>>4&15]+t[15&p]+t[p>>12&15]+t[p>>8&15]+t[p>>20&15]+t[p>>16&15]+t[p>>28&15]+t[p>>24&15];g%s==0&&(i(u),m=0)}return"0x"+h}(function(e){return{blocks:[],reset:!0,block:0,start:0,blockCount:1600-(e<<1)>>5,outputBlocks:e>>5,s:function(e){return[].concat(e,e,e,e,e)}([0,0,0,0,0,0,0,0,0,0])}}(e),n)}};e.exports={keccak256:f(256),keccak512:f(512),keccak256s:f(256),keccak512s:f(512)}},function(e,a,t){var r=t(20),c=t(9),n=t(321),i=t(822),f=t(319),o=function(e){return e instanceof c||e&&e.constructor&&"BN"===e.constructor.name},d=function(e){return e&&e.constructor&&"BigNumber"===e.constructor.name},s=function(e){try{return n.apply(null,arguments)}catch(a){throw new Error(a+' Given value: "'+e+'"')}},b=function(e){return!!/^(0x)?[0-9a-f]{40}$/i.test(e)&&(!(!/^(0x|0X)?[0-9a-f]{40}$/.test(e)&&!/^(0x|0X)?[0-9A-F]{40}$/.test(e))||u(e))},u=function(e){e=e.replace(/^0x/i,"");for(var a=g(e.toLowerCase()).replace(/^0x/i,""),t=0;t<40;t++)if(parseInt(a[t],16)>7&&e[t].toUpperCase()!==e[t]||parseInt(a[t],16)<=7&&e[t].toLowerCase()!==e[t])return!1;return!0},l=function(e){var a="";e=(e=(e=(e=(e=i.encode(e)).replace(/^(?:\u0000)*/,"")).split("").reverse().join("")).replace(/^(?:\u0000)*/,"")).split("").reverse().join("");for(var t=0;t<e.length;t++){var r=e.charCodeAt(t).toString(16);a+=r.length<2?"0"+r:r}return"0x"+a},p=function(e){if(r.isNull(e)||r.isUndefined(e))return e;if(!isFinite(e)&&!m(e))throw new Error('Given input "'+e+'" is not a number.');var a=s(e),t=a.toString(16);return a.lt(new c(0))?"-0x"+t.substr(1):"0x"+t},h=function(e){if(e=e.toString(16),!m(e))throw new Error('Given value "'+e+'" is not a valid hex string.');e=e.replace(/^0x/i,"");for(var a=[],t=0;t<e.length;t+=2)a.push(parseInt(e.substr(t,2),16));return a},m=function(e){return(r.isString(e)||r.isNumber(e))&&/^(-)?0x[0-9a-f]*$/i.test(e)},g=function(e){m(e)&&/^0x/i.test(e.toString())&&(e=h(e));var a=f.keccak256(e);return"0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470"===a?null:a};g._Hash=f,e.exports={BN:c,isBN:o,isBigNumber:d,toBN:s,isAddress:b,isBloom:function(e){return!(!/^(0x)?[0-9a-f]{512}$/i.test(e)||!/^(0x)?[0-9a-f]{512}$/.test(e)&&!/^(0x)?[0-9A-F]{512}$/.test(e))},isTopic:function(e){return!(!/^(0x)?[0-9a-f]{64}$/i.test(e)||!/^(0x)?[0-9a-f]{64}$/.test(e)&&!/^(0x)?[0-9A-F]{64}$/.test(e))},checkAddressChecksum:u,utf8ToHex:l,hexToUtf8:function(e){if(!m(e))throw new Error('The parameter "'+e+'" must be a valid HEX string.');for(var a="",t=0,r=(e=(e=(e=(e=(e=e.replace(/^0x/i,"")).replace(/^(?:00)*/,"")).split("").reverse().join("")).replace(/^(?:00)*/,"")).split("").reverse().join("")).length,c=0;c<r;c+=2)t=parseInt(e.substr(c,2),16),a+=String.fromCharCode(t);return i.decode(a)},hexToNumber:function(e){return e?s(e).toNumber():e},hexToNumberString:function(e){return e?s(e).toString(10):e},numberToHex:p,toHex:function(e,a){if(b(e))return a?"address":"0x"+e.toLowerCase().replace(/^0x/i,"");if(r.isBoolean(e))return a?"bool":e?"0x01":"0x00";if(r.isObject(e)&&!d(e)&&!o(e))return a?"string":l(JSON.stringify(e));if(r.isString(e)){if(0===e.indexOf("-0x")||0===e.indexOf("-0X"))return a?"int256":p(e);if(0===e.indexOf("0x")||0===e.indexOf("0X"))return a?"bytes":e;if(!isFinite(e))return a?"string":l(e)}return a?e<0?"int256":"uint256":p(e)},hexToBytes:h,bytesToHex:function(e){for(var a=[],t=0;t<e.length;t++)a.push((e[t]>>>4).toString(16)),a.push((15&e[t]).toString(16));return"0x"+a.join("")},isHex:function(e){return(r.isString(e)||r.isNumber(e))&&/^(-0x|0x)?[0-9a-f]*$/i.test(e)},isHexStrict:m,leftPad:function(e,a,t){var r=/^0x/i.test(e)||"number"==typeof e,c=a-(e=e.toString(16).replace(/^0x/i,"")).length+1>=0?a-e.length+1:0;return(r?"0x":"")+new Array(c).join(t||"0")+e},rightPad:function(e,a,t){var r=/^0x/i.test(e)||"number"==typeof e,c=a-(e=e.toString(16).replace(/^0x/i,"")).length+1>=0?a-e.length+1:0;return(r?"0x":"")+e+new Array(c).join(t||"0")},toTwosComplement:function(e){return"0x"+s(e).toTwos(256).toString(16,64)},sha3:g}},function(e,a,t){var r=t(9),c=t(377);e.exports=function(e){if("string"==typeof e||"number"==typeof e){var a=new r(1),t=String(e).toLowerCase().trim(),n="0x"===t.substr(0,2)||"-0x"===t.substr(0,3),i=c(t);if("-"===i.substr(0,1)&&(i=c(i.slice(1)),a=new r(-1,10)),!(i=""===i?"0":i).match(/^-?[0-9]+$/)&&i.match(/^[0-9A-Fa-f]+$/)||i.match(/^[a-fA-F]+$/)||!0===n&&i.match(/^[0-9A-Fa-f]+$/))return new r(i,16).mul(a);if((i.match(/^-?[0-9]+$/)||""===i)&&!1===n)return new r(i,10).mul(a)}else if("object"==typeof e&&e.toString&&!e.pop&&!e.push&&e.toString(10).match(/^-?[0-9]+$/)&&(e.mul||e.dividedToIntegerBy))return new r(e.toString(10),10);throw new Error("[number-to-bn] while converting number "+JSON.stringify(e)+" to BN.js instance, error: invalid number value. Value must be an integer, hex string, BN or BigNumber instance. Note, decimals are not supported.")}},function(e,a,t){var r=t(19),c=t(45),n=t(87),i=t(168),f=t(167),o=t(174),d=t(171),s=t(44),b=(t(116),t(3)),u=t(18),l=t(445),p=t(443),h=t(5),m=t(66);function g(e){if(h.apply(this),this.options=e=this._applyDefaultOptions(e||{}),this.logger=e.logger||console,this.data=new p(e),null!=e.trie&&null!=e.db_path)throw new Error("Can't initialize a TestRPC with a db and a custom trie.");this.pending_transactions=[],this.blockGasLimit=e.gasLimit,this.defaultTransactionGasLimit=e.defaultTransactionGasLimit,this.timeAdjustment=0}const v={gasLimit:"0x6691b7",defaultTransactionGasLimit:"0x15f90",time:null,debug:!1,allowUnlimitedContractSize:!1};g.prototype=Object.create(h.prototype),g.prototype.constructor=g,g.prototype._applyDefaultOptions=function(e){return m.merge(e,v,Object.assign({},e))},g.prototype.initialize=function(e,a){var t=this;this.data.initialize(function(c){if(c)return a(c);t.latestBlock(function(c,n){if(c)return a(c);var i=t.options,f=null;if(n&&(f=n.header.stateRoot),t.stateTrie=t.createStateTrie(t.data.trie_db,f),t.vm=i.vm||new o({state:t.stateTrie,blockchain:{getBlock:function(e,a){try{e=r.number(e)}catch(e){}t.getBlock(e,a)}},enableHomestead:!0,activatePrecompiles:!0,allowUnlimitedContractSize:i.allowUnlimitedContractSize}),1==i.debug&&t.vm.on("step",function(e){var a=e.opcode.name,c=e.opcode.in;if(c){var n=e.stack.slice(-c).map(e=>r.hex(e)).join(" ");t.logger.log(`${a} ${n}`)}else t.logger.log(a)}),i.time&&t.setTime(i.time),n)return t.emit("block",n),a();t.createGenesisBlock(function(r,c){if(r)return a(r);e=e||[],u.eachSeries(e,function(e,a){t.putAccount(e.account,e.address,a)},function(e){if(e)return a(e);t.putBlock(c,[],[],a)})})})})},g.prototype.createStateTrie=function(e,a){return new s(this.data.trie_db,a)},g.prototype.createGenesisBlock=function(e){this.createBlock(e)},g.prototype.latestBlock=function(e){this.data.blocks.last(function(a,t){if(a)return e(a);e(null,t)})},g.prototype.getEffectiveBlockNumber=function(e,a){return"string"!=typeof e&&(e=r.hex(e)),e.indexOf("0x")>=0?a(null,r.number(e)):"latest"==e||"pending"==e?this.getHeight(a):"earliest"==e?a(null,0):void 0},g.prototype.getBlock=function(e,a){var t=this;if("string"!=typeof e&&(e=r.hex(e)),e.indexOf("0x")>=0){var c=e;if(!(c.length>40))return this.data.blocks.get(r.number(c),a);this.data.blockHashes.get(r.hex(c),function(e,r){return e?a(e):t.data.blocks.get(r,a)})}else{if("latest"==e||"pending"==e)return this.latestBlock(a);if("earliest"==e)return this.data.blocks.first(a)}},g.prototype.putBlock=function(e,a,t,c){var n=this;e.header.stateRoot=this.stateTrie.root,this.data.blocks.length(function(i,f){if(i)return c(i);var o=[n.data.blocks.push.bind(n.data.blocks,e),n.data.blockLogs.push.bind(n.data.blockLogs,a),n.data.blockHashes.set.bind(n.data.blockHashes,r.hex(e.hash()),f)];e.transactions.forEach(function(e,a){var c=r.hex(e.hash());o.push(n.data.transactions.set.bind(n.data.transactions,c,e),n.data.transactionReceipts.set.bind(n.data.transactionReceipts,c,t[a]))}),u.parallel(o,(a,t)=>{a||n.emit("block",e),c(a,t)})})},g.prototype.popBlock=function(e){var a=this;this.data.blocks.last(function(t,c){if(t)return e(t);if(null==c)return e(null,null);var n=[],i=r.hex(c.hash());c.transactions.forEach(function(e,t){var c=r.hex(e.hash());n.push(a.data.transactions.del.bind(a.data.transactions,c),a.data.transactionReceipts.del.bind(a.data.transactionReceipts,c))}),n.push(a.data.blockLogs.pop.bind(a.data.blockLogs),a.data.blockHashes.del.bind(a.data.blockHashes,i),a.data.blocks.pop.bind(a.data.blocks)),u.series(n,function(t){if(t)return e(t);a.data.blocks.last(function(t,r){if(t)return e(t);a.stateTrie.root=r.header.stateRoot,e(null,c)})})})},g.prototype.clearPendingTransactions=function(){this.pending_transactions=[]},g.prototype.putAccount=function(e,a,t){var r=this;a=b.toBuffer(a),this.vm.stateManager.putAccount(a,e,function(e){if(e)return t(e);r.vm.stateManager.cache.flush(t)})},g.prototype.createBlock=function(e,a){var t=this;"function"==typeof e&&(a=e,e=null);var c=new n;!function(a){if(e)return a(null,e);t.latestBlock(a)}(function(e,n){if(e)return a(e);var i=null!=n?r.number(n.header.number):-1;c.header.gasLimit=t.blockGasLimit,c.header.number=r.hex(i+1),c.header.timestamp=r.hex(t.currentTime()),null!=n&&(c.header.parentHash=r.hex(n.hash())),a(null,c)})},g.prototype.getQueuedNonce=function(e,a){var t=null;if(this.pending_transactions.forEach(function(a){if(r.hex(a.from)==r.hex(e)){var c=r.number(a.nonce);(null===t||c>t)&&(t=c)}}),null!=t)return a(null,t+1);this.stateTrie.get(e,function(e,t){if(e)return a(e);var r=new c(t);a(null,r.nonce)})},g.prototype.queueTransaction=function(e){this.pending_transactions.push(e)},g.prototype.sortByPriceAndNonce=function(){var e={};this.pending_transactions.forEach(a=>{e[r.hex(a.from)]?e[r.hex(a.from)].push(a):e[r.hex(a.from)]=[a]});var a=function(e,a){return parseInt(r.hex(e.nonce),16)-parseInt(r.hex(a.nonce),16)};Object.keys(e).forEach(t=>{e[t].sort(a)});var t=new l(function(e,a){return parseInt(r.hex(a.gasPrice),16)-parseInt(r.hex(e.gasPrice),16)});Object.keys(e).forEach(a=>{t.push(e[a].shift())});const c=[];for(;t.size()>0;){const a=t.pop();let n=r.hex(a.from);e[n].length>0&&t.push(e[n].shift()),c.push(a)}this.pending_transactions=c},g.prototype.processCall=function(e,a,t){var r,c=this,n=function(e,a,n){c.vm.stateManager.revert(function(i){n&&(c.stateTrie.root=r),t(e||i,a)})},i=function(e,a,i,f){if(i)return t(i);a&&(r=c.stateTrie.root,c.stateTrie.root=f.header.stateRoot),c.createBlock(f,function(t,r){r.transactions.push(e),c.vm.stateManager.checkpoint();var i={tx:e,block:r,skipBalance:!0,skipNonce:!0};c.vm.runTx(i,function(t,r){if(t&&t instanceof Error==0&&(t=new Error("VM error: "+t)),t)return n(t);t=d.fromResults([e],{results:[r]}),n(t,r,a)})})};"latest"===a?c.latestBlock(i.bind(null,e,!1)):c.getBlock(a,i.bind(null,e,!0))},g.prototype.processBlock=function(e,a,t){var c=this;"function"==typeof a&&(t=a,a=!0);c.stateTrie.root;c.vm.stateManager.checkpoint();var n=function(e){c.vm.stateManager.revert(function(a){t(e||a)})};c.vm.runBlock({block:e,generate:!0},function(o,s){if(o&&o instanceof Error==0&&(o=new Error("VM error: "+o)),o)return n(o);o=d.fromResults(e.transactions,s);var u=[],l=[],p=0;s.results.forEach(function(e){p+=r.number(e.gasUsed)}),e.header.gasUsed=b.toBuffer(r.hex(p));for(var h=0;h<s.receipts.length;h++){var m=s.results[h],g=s.receipts[h],v=e.transactions[h],y=v.hash(),_=[];if(1==m.vm.exception)for(var w=0;w<g.logs.length;w++){for(var A=g.logs[w],k=r.hex(A[0]),x=[],E=0;E<A[1].length;E++)x.push(r.hex(A[1][E]));var S=r.hex(A[2]);A=new i({logIndex:r.hex(w),transactionIndex:r.hex(h),transactionHash:y,block:e,address:k,data:S,topics:x,type:"mined"});u.push(A),_.push(A)}l.push(new f(v,e,_,g.gasUsed,m.createdAddress,g.status,r.hex(m.bloom.bitvector)))}!function(t){!0===a?c.vm.stateManager.commit(function(a){if(a)return n(a);c.putBlock(e,u,l,t)}):c.vm.stateManager.revert(t)}(function(a){if(a)return t(a);t(o,e.transactions,s)})})},g.prototype.processNextBlock=function(e,a){var t=this;"function"==typeof e&&(a=e,e=void 0),t.sortByPriceAndNonce();for(var c=[],n=0,i=r.number(t.blockGasLimit);t.pending_transactions.length>0;){var f=t.pending_transactions[0],o=r.number(f.gasLimit);if(!(n+o<=i))break;n+=o,t.pending_transactions.shift(),c.push(f)}if(0==c.length&&t.pending_transactions.length>0)return a("Unexpected error condition: next transaction exceeds block gas limit");this.createBlock(function(n,i){if(n)return a(n);e&&(t.data.blocks.last(function(a,c){c&&r.number(c.header.timestamp)>e&&t.logger.log("Waring: Setting the block timestamp ("+e+") that is earlier than the parent block one.")}),i.header.timestamp=r.hex(e),t.setTime(new Date(1e3*e))),Array.prototype.push.apply(i.transactions,c),t.processBlock(i,!0,a)})},g.prototype.processTransactionTrace=function(e,a,t){var c=this,n=r.hex(e),i="",f=null,o={currentDepth:-1,stack:[]},d={gas:0,returnValue:"",structLogs:[]};function s(e,t){var n=r.number(e.gasLeft),i=r.number(f.gasLimit)-n-d.gas;d.gas+=i;var s=null;if(!a.disableMemory&&(s=(s=Buffer.from(e.memory).toString("hex")).match(/.{1,64}/g)||[]).length>0){var b=s[s.length-1];b.length<64&&(s[s.length-1]=b+new Array(64-b.length+1).join("0"))}var u=a.disableStack?null:e.stack.map(function(e){return r.rpcDataHexString(e,64).replace("0x","")}),l={depth:e.depth,error:"",gas:n,gasCost:i,memory:s,op:e.opcode.name,pc:e.pc,stack:u,storage:null};a.disableStorage?(d.structLogs.push(l),t()):l=c.processStorageTrace(l,o,e,function(e,a){if(e)return t(e);d.structLogs.push(a),t()})}function b(e){f=e,(i=r.hex(e.hash()))==n&&c.vm.on("step",s)}function u(){i==n&&(c.vm.removeListener("step",s),c.vm.removeListener("beforeTx",b),c.vm.removeListener("afterTx",u))}c.vm.on("beforeTx",b),c.vm.on("afterTx",u),this.getTransactionReceipt(n,function(e,a){if(e)return t(e);if(!a)return t(new Error("Unknown transaction "+n));var i=a.block;c.getBlock(i.header.parentHash,function(e,a){if(e)return t(e);var f=c.stateTrie.root;c.stateTrie.root=a.header.stateRoot,c.createBlock(a,function(e,a){if(e)return t(e);for(var o=0;o<i.transactions.length;o++){var l=i.transactions[o];if(a.transactions.push(l),r.hex(l.hash())==n)break}c.processBlock(a,!1,function(e,a,r){e&&0==e.message.indexOf("VM Exception")&&(e=null),c.stateTrie.root=f,c.vm.removeListener("beforeTx",b),c.vm.removeListener("afterTx",u),c.vm.removeListener("step",s),t(e,d)})})})})},g.prototype.processStorageTrace=function(e,a,t,c){var n,i,f=t.opcode.name,o=t.opcode.in,d=t.stack.slice(-o).map(e=>r.hex(e));switch(a.currentDepth>t.depth&&a.stack.pop(),a.currentDepth<t.depth&&a.stack.push({}),a.currentDepth=t.depth,f){case"SSTORE":n=r.rpcDataHexString(d[1],64).replace("0x",""),i=r.rpcDataHexString(d[0],64).replace("0x",""),e.storage=Object.assign({},a.stack[a.currentDepth]),c(null,e),a.stack[a.currentDepth][n]=i;break;case"SLOAD":n=r.rpcDataHexString(d[0],64).replace("0x",""),this.vm.stateManager.getContractStorage(t.address,"0x"+n,function(t,f){if(t)return c(t);i=r.rpcDataHexString(f,64).replace("0x",""),a.stack[a.currentDepth][n]=i,e.storage=Object.assign({},a.stack[a.currentDepth]),c(null,e)});break;default:e.storage=Object.assign({},a.stack[a.currentDepth]),c(null,e)}},g.prototype.getAccount=function(e,a,t){var r=this;this.getBlock(a,function(a,n){if(a)return t(a);var i=r.stateTrie,f=i.root;r.stateTrie.root=n.header.stateRoot,i.get(b.toBuffer(e),function(e,a){if(i.root=f,e)return t(e);var r=new c(a);r.exists=!!a,t(null,r)})})},g.prototype.getNonce=function(e,a,t){this.getAccount(e,a,function(e,a){if(e)return t(e);t(null,a.nonce)})},g.prototype.getBalance=function(e,a,t){this.getAccount(e,a,function(e,a){if(e)return t(e);t(null,a.balance)})},g.prototype.getStorage=function(e,a,t,r){var n=this;this.getBlock(t,function(t,i){if(t)return r(t);var f=n.stateTrie,o=f.root;n.stateTrie.root=i.header.stateRoot,f.get(b.toBuffer(e),function(e,t){if(null!=e)return f.root=o,r(e);var n=new c(t);f.root=n.stateRoot,f.get(b.setLengthLeft(b.toBuffer(a),32),function(e,a){if(f.root=o,null!=e)return r(e);r(null,a)})})})},g.prototype.getCode=function(e,a,t){var r=this;this.getBlock(a,function(a,n){if(a)return t(a);var i=r.stateTrie,f=i.root;r.stateTrie.root=n.header.stateRoot,i.get(b.toBuffer(e),function(e,a){if(null!=e)return i.root=f,t(e);new c(a).getCode(i,function(e,a){if(i.root=f,e)return t(e);t(null,a)})})})},g.prototype.getTransaction=function(e,a){e=r.hex(e),this.data.transactions.get(e,function(e,t){if(e)return e.notFound?a(null,null):a(e);a(null,t)})},g.prototype.getTransactionReceipt=function(e,a){e=r.hex(e),this.data.transactionReceipts.get(e,function(e,t){if(e)return e.notFound?a(null,null):a(e);a(e,t)})},g.prototype.getBlockLogs=function(e,a){var t=this;this.getEffectiveBlockNumber(e,function(e,r){if(e)return a(e);t.data.blockLogs.get(r,a)})},g.prototype.getHeight=function(e){this.data.blocks.length(function(a,t){if(a)return e(a);e(null,t-1)})},g.prototype.currentTime=function(){return((new Date).getTime()/1e3|0)+this.timeAdjustment},g.prototype.increaseTime=function(e){return e<0&&(e=0),this.timeAdjustment+=e,this.timeAdjustment},g.prototype.setTime=function(e){var a=(new Date).getTime()/1e3|0,t=e.getTime()/1e3|0;this.timeAdjustment=t-a},g.prototype.close=function(e){this.data.close(e)},e.exports=g},function(e,a){e.exports=__webpack_require__(39)},function(e,a){function t(e){return"function"==typeof e?Buffer("","utf8"):e instanceof Buffer?e:"string"==typeof e?new Buffer(e,"utf8"):new Buffer(String(e||""),"utf8")}function r(e){return"number"!=typeof e?null:(e=Math.round(e))<1?null:e>256?null:e}e.exports=function(e,a,c,n){return{password:t(e),salt:t(a),options:function(e){return{maxmem:function(e){if("number"!=typeof e)return null;for(var a=4;a<=2048;a*=2){var t=1048576*a;if(t>e)return null;if(t==e)return t}return null}((e=null!==e&&"object"==typeof e?e:{}).maxmem)||33554432,cost:function(e){if("number"!=typeof e)return null;for(var a=8;a<=64;a++){var t=Math.pow(2,a);if(t>e)return null;if(t==e)return t}return null}(e.cost)||Math.pow(2,14),blockSize:r(e.blockSize)||8,parallel:r(e.parallel)||1,size:function(e){return"number"!=typeof e?null:(e=Math.round(e))<1?null:e>2048?null:e}(e.size)||64}}(c),callback:function(e){return"function"==typeof e?e:null}(arguments[arguments.length-1])}}},function(e,a,t){var r=t(841);e.exports=function(e,a,t,c,n,i,f){return r.hashSync(e,{N:t,r:c,p:n},i,a)}},function(e,a,t){var r=t(842),c=t(10),n=t(325),i=t(836),f=t(834);function o(e,a){if(!e)throw new Error(a||"Assertion failed")}function d(e,a){return Buffer.concat([e.update(a),e.final()])}var s=function(e,a){if(e&&a)throw new Error("Cannot supply both a private and a public key to the constructor");if(e&&!r.isValidPrivate(e))throw new Error("Private key does not satisfy the curve requirements (ie. it is invalid)");if(a&&!r.isValidPublic(a))throw new Error("Invalid public key");this._privKey=e,this._pubKey=a};Object.defineProperty(s.prototype,"privKey",{get:function(){return o(this._privKey,"This is a public key only wallet"),this._privKey}}),Object.defineProperty(s.prototype,"pubKey",{get:function(){return this._pubKey||(this._pubKey=r.privateToPublic(this.privKey)),this._pubKey}}),s.generate=function(e){if(!e)return new s(c.randomBytes(32));for(;;){var a=c.randomBytes(32);if(0===r.privateToAddress(a)[0])return new s(a)}},s.prototype.getPrivateKey=function(){return this.privKey},s.prototype.getPrivateKeyString=function(){return r.bufferToHex(this.getPrivateKey())},s.prototype.getPublicKey=function(){return this.pubKey},s.prototype.getPublicKeyString=function(){return r.bufferToHex(this.getPublicKey())},s.prototype.getAddress=function(){return r.publicToAddress(this.pubKey)},s.prototype.getAddressString=function(){return r.bufferToHex(this.getAddress())},s.prototype.getChecksumAddressString=function(){return r.toChecksumAddress(this.getAddressString())},s.prototype.toV3=function(e,a){o(this._privKey,"This is a public key only wallet");var t,f=(a=a||{}).salt||c.randomBytes(32),d=a.iv||c.randomBytes(16),s=a.kdf||"scrypt",b={dklen:a.dklen||32,salt:f.toString("hex")};if("pbkdf2"===s)b.c=a.c||262144,b.prf="hmac-sha256",t=c.pbkdf2Sync(new Buffer(e),f,b.c,b.dklen,"sha256");else{if("scrypt"!==s)throw new Error("Unsupported kdf");b.n=a.n||262144,b.r=a.r||8,b.p=a.p||1,t=n(new Buffer(e),f,b.n,b.r,b.p,b.dklen)}var u=c.createCipheriv(a.cipher||"aes-128-ctr",t.slice(0,16),d);if(!u)throw new Error("Unsupported cipher");var l=Buffer.concat([u.update(this.privKey),u.final()]),p=r.sha3(Buffer.concat([t.slice(16,32),new Buffer(l,"hex")]));return{version:3,id:i.v4({random:a.uuid||c.randomBytes(16)}),address:this.getAddress().toString("hex"),crypto:{ciphertext:l.toString("hex"),cipherparams:{iv:d.toString("hex")},cipher:a.cipher||"aes-128-ctr",kdf:s,kdfparams:b,mac:p.toString("hex")}}},s.prototype.getV3Filename=function(e){return["UTC--",(e?new Date(e):new Date).toJSON().replace(/:/g,"-"),"--",this.getAddress().toString("hex")].join("")},s.prototype.toV3String=function(e,a){return JSON.stringify(this.toV3(e,a))},s.fromPublicKey=function(e,a){return a&&(e=r.importPublic(e)),new s(null,e)},s.fromExtendedPublicKey=function(e){return o("xpub"===e.slice(0,4),"Not an extended public key"),e=f.decode(e).slice(45),s.fromPublicKey(e,!0)},s.fromPrivateKey=function(e){return new s(e)},s.fromExtendedPrivateKey=function(e){o("xprv"===e.slice(0,4),"Not an extended private key");var a=f.decode(e);return o(0===a[45],"Invalid extended private key"),s.fromPrivateKey(a.slice(46))},s.fromV1=function(e,a){o("string"==typeof a);var t="object"==typeof e?e:JSON.parse(e);if("1"!==t.Version)throw new Error("Not a V1 wallet");if("scrypt"!==t.Crypto.KeyHeader.Kdf)throw new Error("Unsupported key derivation scheme");var i=t.Crypto.KeyHeader.KdfParams,f=n(new Buffer(a),new Buffer(t.Crypto.Salt,"hex"),i.N,i.R,i.P,i.DkLen),b=new Buffer(t.Crypto.CipherText,"hex");if(r.sha3(Buffer.concat([f.slice(16,32),b])).toString("hex")!==t.Crypto.MAC)throw new Error("Key derivation failed - possibly wrong passphrase");var u=d(c.createDecipheriv("aes-128-cbc",r.sha3(f.slice(0,16)).slice(0,16),new Buffer(t.Crypto.IV,"hex")),b);return new s(u)},s.fromV3=function(e,a,t){o("string"==typeof a);var i,f,b="object"==typeof e?e:JSON.parse(t?e.toLowerCase():e);if(3!==b.version)throw new Error("Not a V3 wallet");if("scrypt"===b.crypto.kdf)f=b.crypto.kdfparams,i=n(new Buffer(a),new Buffer(f.salt,"hex"),f.n,f.r,f.p,f.dklen);else{if("pbkdf2"!==b.crypto.kdf)throw new Error("Unsupported key derivation scheme");if("hmac-sha256"!==(f=b.crypto.kdfparams).prf)throw new Error("Unsupported parameters to PBKDF2");i=c.pbkdf2Sync(new Buffer(a),new Buffer(f.salt,"hex"),f.c,f.dklen,"sha256")}var u=new Buffer(b.crypto.ciphertext,"hex");if(r.sha3(Buffer.concat([i.slice(16,32),u])).toString("hex")!==b.crypto.mac)throw new Error("Key derivation failed - possibly wrong passphrase");var l=d(c.createDecipheriv(b.crypto.cipher,i.slice(0,16),new Buffer(b.crypto.cipherparams.iv,"hex")),u);return new s(l)},s.fromEthSale=function(e,a){o("string"==typeof a);var t="object"==typeof e?e:JSON.parse(e),n=new Buffer(t.encseed,"hex"),i=c.pbkdf2Sync(a,a,2e3,32,"sha256").slice(0,16),f=d(c.createDecipheriv("aes-128-cbc",i,n.slice(0,16)),n.slice(16)),b=new s(r.sha3(f));if(b.getAddress().toString("hex")!==t.ethaddr)throw new Error("Decoded key mismatch - possibly wrong passphrase");return b},e.exports=s},function(e,a){var t;process.browser?t="utf-8":t=parseInt(process.version.split(".")[0].slice(1),10)>=6?"utf-8":"binary";e.exports=t},function(e,a,t){e.exports=t(10).createHmac},function(e,a,t){var r={md5:16,sha1:20,sha224:28,sha256:32,sha384:48,sha512:64,rmd160:20,ripemd160:20},c=t(328),n=t(169),i=t(327),f=t(7).Buffer;e.exports=function(e,a,t,o,d){n(e,a,t,o),f.isBuffer(e)||(e=f.from(e,i)),f.isBuffer(a)||(a=f.from(a,i)),d=d||"sha1";var s=f.allocUnsafe(o),b=f.allocUnsafe(a.length+4);a.copy(b,0,0,a.length);for(var u=0,l=r[d],p=Math.ceil(o/l),h=1;h<=p;h++){b.writeUInt32BE(h,a.length);for(var m=c(d,e).update(b).digest(),g=m,v=1;v<t;v++){g=c(d,e).update(g).digest();for(var y=0;y<l;y++)m[y]^=g[y]}m.copy(s,u),u+=l}return s}},function(e,a,t){e.exports=t(863)},function(e,a,t){"use strict";var r=t(7).Buffer,c=t(11),n=t(3),i=e.exports=function(e){e?(c(256===e.length,"bitvectors must be 2048 bits long"),this.bitvector=e):this.bitvector=n.zeros(256)};i.prototype.add=function(e){e=n.sha3(e);for(var a=0;a<3;a++){var t=2047&e.readUInt16BE(2*a),r=t>>3,c=1<<t%8;this.bitvector[256-r-1]|=c}},i.prototype.check=function(e){e=n.sha3(e);for(var a=!0,t=0;t<3&&a;t++){var r=511&e.readUInt16BE(2*t),c=r>>3,i=1<<r%8;a=this.bitvector[256-c-1]&i}return Boolean(a)},i.prototype.multiCheck=function(e){var a=this;return e.every(function(e){return r.isBuffer(e)||(e=r.from(e,"hex")),a.check(e)})},i.prototype.or=function(e){if(e)for(var a=0;a<=256;a++)this.bitvector[a]=this.bitvector[a]|e.bitvector[a]}},function(e,a,t){const r=t(3),c=t(361),n=t(44),i=r.BN,f=r.rlp,o=t(18),d=t(874),s=t(173);var b=e.exports=function(e){var a,t;this.transactions=[],this.uncleHeaders=[],this._inBlockChain=!1,this.txTrie=new n,Object.defineProperty(this,"raw",{get:function(){return this.serialize(!1)}}),e||(e=[[],[],[]]),Buffer.isBuffer(e)&&(e=f.decode(e)),Array.isArray(e)?(this.header=new d(e[0]),a=e[1],t=e[2]):(this.header=new d(e.header),a=e.transactions||[],t=e.uncleHeaders||[]);for(var r=0;r<t.length;r++)this.uncleHeaders.push(new d(t[r]));for(r=0;r<a.length;r++){var i=new c(a[r]);i._homestead=!0,this.transactions.push(i)}};function u(e){try{return e.reduce(function(e,a){return e&&(e+=" "),e+a})}catch(e){return""}}b.Header=d,b.prototype.hash=function(){return this.header.hash()},b.prototype.isGenesis=function(){return this.header.isGenesis()},b.prototype.setGenesisParams=function(){this.header.gasLimit=s.genesisGasLimit.v,this.header.difficulty=s.genesisDifficulty.v,this.header.extraData=s.genesisExtraData.v,this.header.nonce=s.genesisNonce.v,this.header.stateRoot=s.genesisStateRoot.v,this.header.number=new Buffer([])},b.prototype.serialize=function(e){var a=[this.header.raw,[],[]];return void 0===e&&(e=!0),this.transactions.forEach(function(e){a[1].push(e.raw)}),this.uncleHeaders.forEach(function(e){a[2].push(e.raw)}),e?f.encode(a):a},b.prototype.genTxTrie=function(e){var a=0,t=this;o.eachSeries(this.transactions,function(e,r){t.txTrie.put(f.encode(a),e.serialize(),r),a++},e)},b.prototype.validateTransactionsTrie=function(){var e=this.header.transactionsTrie.toString("hex");return this.transactions.length?e===this.txTrie.root.toString("hex"):e===r.SHA3_RLP.toString("hex")},b.prototype.validateTransactions=function(e){var a=[];return this.transactions.forEach(function(e,t){var r=e.validate(!0);r&&a.push(r+" at tx "+t)}),void 0===e||!1===e?0===a.length:u(a)},b.prototype.validate=function(e,a){var t=this,r=[];o.parallel([t.validateUncles.bind(t,e),t.header.validate.bind(t.header,e),t.genTxTrie.bind(t)],function(e){e&&r.push(e),t.validateTransactionsTrie()||r.push("invalid transaction true");var c=t.validateTransactions(!0);""!==c&&r.push(c),t.validateUnclesHash()||r.push("invild uncle hash"),a(u(r))})},b.prototype.validateUnclesHash=function(){var e=[];return this.uncleHeaders.forEach(function(a){e.push(a.raw)}),e=f.encode(e),r.sha3(e).toString("hex")===this.header.uncleHash.toString("hex")},b.prototype.validateUncles=function(e,a){if(this.isGenesis())return a();var t=this;if(t.uncleHeaders.length>2)return a("too many uncle headers");var r=t.uncleHeaders.map(function(e){return e.hash().toString("hex")});if(new Set(r).size!==r.length)return a("dublicate unlces");o.each(t.uncleHeaders,function(a,r){var c=new i(t.header.number);o.parallel([a.validate.bind(a,e,c),function(t){e.getDetails(a.hash(),function(e,a){a&&a.isUncle?t(e||"uncle already included"):t()})}],r)},a)},b.prototype.toJSON=function(e){if(e){var a={header:this.header.toJSON(!0),transactions:[],uncleHeaders:[]};return this.transactions.forEach(function(t){a.transactions.push(t.toJSON(e))}),this.uncleHeaders.forEach(function(e){a.uncleHeaders.push(e.toJSON())}),a}return r.baToJSON(this.raw)}},function(e,a,t){var r=t(896);r.genesisState=t(895),r.bootstrapNodes=t(894),e.exports=r},function(e,a,t){e.exports=i;var r=t(175),c=t(17);function n(e,a){this.afterTransform=function(e,t){return function(e,a,t){var r=e._transformState;r.transforming=!1;var c=r.writecb;if(!c)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,null!==t&&void 0!==t&&e.push(t);c&&c(a);var n=e._readableState;n.reading=!1,(n.needReadable||n.length<n.highWaterMark)&&e._read(n.highWaterMark)}(a,e,t)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null}function i(e){if(!(this instanceof i))return new i(e);r.call(this,e);this._transformState=new n(e,this);var a=this;this._readableState.needReadable=!0,this._readableState.sync=!1,this.once("finish",function(){"function"==typeof this._flush?this._flush(function(e){f(a,e)}):f(a)})}function f(e,a){if(a)return e.emit("error",a);var t=e._writableState,r=(e._readableState,e._transformState);if(t.length)throw new Error("calling transform done when ws.length != 0");if(r.transforming)throw new Error("calling transform done when still transforming");return e.push(null)}c.inherits=t(0),c.inherits(i,r),i.prototype.push=function(e,a){return this._transformState.needTransform=!1,r.prototype.push.call(this,e,a)},i.prototype._transform=function(e,a,t){throw new Error("not implemented")},i.prototype._write=function(e,a,t){var r=this._transformState;if(r.writecb=t,r.writechunk=e,r.writeencoding=a,!r.transforming){var c=this._readableState;(r.needTransform||c.needReadable||c.length<c.highWaterMark)&&this._read(c.highWaterMark)}},i.prototype._read=function(e){var a=this._transformState;null!==a.writechunk&&a.writecb&&!a.transforming?(a.transforming=!0,this._transform(a.writechunk,a.writeencoding,a.afterTransform)):a.needTransform=!0}},function(e,a,t){e.exports=f;var r=t(24).Buffer;f.WritableState=i;var c=t(17);c.inherits=t(0);var n=t(6);function i(e,a){var t=(e=e||{}).highWaterMark;this.highWaterMark=t||0===t?t:16384,this.objectMode=!!e.objectMode,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var r=!1===e.decodeStrings;this.decodeStrings=!r,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,a){var t=e._writableState,r=t.sync,c=t.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(t),a)!function(e,a,t,r,c){t?process.nextTick(function(){c(r)}):c(r);e._writableState.errorEmitted=!0,e.emit("error",r)}(e,0,r,a,c);else{var n=s(e,t);n||t.bufferProcessing||!t.buffer.length||function(e,a){a.bufferProcessing=!0;for(var t=0;t<a.buffer.length;t++){var r=a.buffer[t],c=r.chunk,n=r.encoding,i=r.callback,f=a.objectMode?1:c.length;if(o(e,a,f,c,n,i),a.writing){t++;break}}a.bufferProcessing=!1,t<a.buffer.length?a.buffer=a.buffer.slice(t):a.buffer.length=0}(e,t),r?process.nextTick(function(){d(e,t,n,c)}):d(e,t,n,c)}}(a,e)},this.writecb=null,this.writelen=0,this.buffer=[],this.errorEmitted=!1}function f(e){var a=t(175);if(!(this instanceof f||this instanceof a))return new f(e);this._writableState=new i(e,this),this.writable=!0,n.call(this)}function o(e,a,t,r,c,n){a.writelen=t,a.writecb=n,a.writing=!0,a.sync=!0,e._write(r,c,a.onwrite),a.sync=!1}function d(e,a,t,r){t||function(e,a){0===a.length&&a.needDrain&&(a.needDrain=!1,e.emit("drain"))}(e,a),r(),t&&b(e,a)}function s(e,a){return a.ending&&0===a.length&&!a.finished&&!a.writing}function b(e,a){var t=s(0,a);return t&&(a.finished=!0,e.emit("finish")),t}c.inherits(f,n),f.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))},f.prototype.write=function(e,a,t){var c=this._writableState,n=!1;return"function"==typeof a&&(t=a,a=null),r.isBuffer(e)?a="buffer":a||(a=c.defaultEncoding),"function"!=typeof t&&(t=function(){}),c.ended?function(e,a,t){var r=new Error("write after end");e.emit("error",r),process.nextTick(function(){t(r)})}(this,0,t):function(e,a,t,c){var n=!0;if(!r.isBuffer(t)&&"string"!=typeof t&&null!==t&&void 0!==t&&!a.objectMode){var i=new TypeError("Invalid non-string/buffer chunk");e.emit("error",i),process.nextTick(function(){c(i)}),n=!1}return n}(this,c,e,t)&&(n=function(e,a,t,c,n){t=function(e,a,t){return e.objectMode||!1===e.decodeStrings||"string"!=typeof a||(a=new r(a,t)),a}(a,t,c),r.isBuffer(t)&&(c="buffer");var i=a.objectMode?1:t.length;a.length+=i;var f=a.length<a.highWaterMark;f||(a.needDrain=!0);a.writing?a.buffer.push(new function(e,a,t){this.chunk=e,this.encoding=a,this.callback=t}(t,c,n)):o(e,a,i,t,c,n);return f}(this,c,e,a,t)),n},f.prototype._write=function(e,a,t){t(new Error("not implemented"))},f.prototype.end=function(e,a,t){var r=this._writableState;"function"==typeof e?(t=e,e=null,a=null):"function"==typeof a&&(t=a,a=null),void 0!==e&&null!==e&&this.write(e,a),r.ending||r.finished||function(e,a,t){a.ending=!0,b(e,a),t&&(a.finished?process.nextTick(t):e.once("finish",t));a.ended=!0}(this,r,t)}},function(e,a,t){e.exports=s;var r=t(178),c=t(24).Buffer;s.ReadableState=d;var n=t(5).EventEmitter;n.listenerCount||(n.listenerCount=function(e,a){return e.listeners(a).length});var i,f=t(6),o=t(17);function d(e,a){var r=(e=e||{}).highWaterMark;this.highWaterMark=r||0===r?r:16384,this.highWaterMark=~~this.highWaterMark,this.buffer=[],this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=!1,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.calledRead=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.objectMode=!!e.objectMode,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(i||(i=t(63).StringDecoder),this.decoder=new i(e.encoding),this.encoding=e.encoding)}function s(e){if(!(this instanceof s))return new s(e);this._readableState=new d(e,this),this.readable=!0,f.call(this)}function b(e,a,t,r,n){var i=function(e,a){var t=null;c.isBuffer(a)||"string"==typeof a||null===a||void 0===a||e.objectMode||(t=new TypeError("Invalid non-string/buffer chunk"));return t}(a,t);if(i)e.emit("error",i);else if(null===t||void 0===t)a.reading=!1,a.ended||function(e,a){if(a.decoder&&!a.ended){var t=a.decoder.end();t&&t.length&&(a.buffer.push(t),a.length+=a.objectMode?1:t.length)}a.ended=!0,a.length>0?p(e):_(e)}(e,a);else if(a.objectMode||t&&t.length>0)if(a.ended&&!n){var f=new Error("stream.push() after EOF");e.emit("error",f)}else if(a.endEmitted&&n){f=new Error("stream.unshift() after end event");e.emit("error",f)}else!a.decoder||n||r||(t=a.decoder.write(t)),a.length+=a.objectMode?1:t.length,n?a.buffer.unshift(t):(a.reading=!1,a.buffer.push(t)),a.needReadable&&p(e),function(e,a){a.readingMore||(a.readingMore=!0,process.nextTick(function(){!function(e,a){var t=a.length;for(;!a.reading&&!a.flowing&&!a.ended&&a.length<a.highWaterMark&&(e.read(0),t!==a.length);)t=a.length;a.readingMore=!1}(e,a)}))}(e,a);else n||(a.reading=!1);return function(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(a)}o.inherits=t(0),o.inherits(s,f),s.prototype.push=function(e,a){var t=this._readableState;return"string"!=typeof e||t.objectMode||(a=a||t.defaultEncoding)!==t.encoding&&(e=new c(e,a),a=""),b(this,t,e,a,!1)},s.prototype.unshift=function(e){return b(this,this._readableState,e,"",!0)},s.prototype.setEncoding=function(e){i||(i=t(63).StringDecoder),this._readableState.decoder=new i(e),this._readableState.encoding=e};var u=8388608;function l(e,a){return 0===a.length&&a.ended?0:a.objectMode?0===e?0:1:null===e||isNaN(e)?a.flowing&&a.buffer.length?a.buffer[0].length:a.length:e<=0?0:(e>a.highWaterMark&&(a.highWaterMark=function(e){if(e>=u)e=u;else{e--;for(var a=1;a<32;a<<=1)e|=e>>a;e++}return e}(e)),e>a.length?a.ended?a.length:(a.needReadable=!0,0):e)}function p(e){var a=e._readableState;a.needReadable=!1,a.emittedReadable||(a.emittedReadable=!0,a.sync?process.nextTick(function(){h(e)}):h(e))}function h(e){e.emit("readable")}function m(e){var a,t=e._readableState;function r(e,r,c){!1===e.write(a)&&t.awaitDrain++}for(t.awaitDrain=0;t.pipesCount&&null!==(a=e.read());)if(1===t.pipesCount?r(t.pipes):w(t.pipes,r),e.emit("data",a),t.awaitDrain>0)return;if(0===t.pipesCount)return t.flowing=!1,void(n.listenerCount(e,"data")>0&&v(e));t.ranOut=!0}function g(){this._readableState.ranOut&&(this._readableState.ranOut=!1,m(this))}function v(e,a){if(e._readableState.flowing)throw new Error("Cannot switch to old mode now.");var t=a||!1,r=!1;e.readable=!0,e.pipe=f.prototype.pipe,e.on=e.addListener=f.prototype.on,e.on("readable",function(){var a;for(r=!0;!t&&null!==(a=e.read());)e.emit("data",a);null===a&&(r=!1,e._readableState.needReadable=!0)}),e.pause=function(){t=!0,this.emit("pause")},e.resume=function(){t=!1,r?process.nextTick(function(){e.emit("readable")}):this.read(0),this.emit("resume")},e.emit("readable")}function y(e,a){var t,r=a.buffer,n=a.length,i=!!a.decoder,f=!!a.objectMode;if(0===r.length)return null;if(0===n)t=null;else if(f)t=r.shift();else if(!e||e>=n)t=i?r.join(""):c.concat(r,n),r.length=0;else{if(e<r[0].length)t=(b=r[0]).slice(0,e),r[0]=b.slice(e);else if(e===r[0].length)t=r.shift();else{t=i?"":new c(e);for(var o=0,d=0,s=r.length;d<s&&o<e;d++){var b=r[0],u=Math.min(e-o,b.length);i?t+=b.slice(0,u):b.copy(t,o,0,u),u<b.length?r[0]=b.slice(u):r.shift(),o+=u}}}return t}function _(e){var a=e._readableState;if(a.length>0)throw new Error("endReadable called on non-empty stream");!a.endEmitted&&a.calledRead&&(a.ended=!0,process.nextTick(function(){a.endEmitted||0!==a.length||(a.endEmitted=!0,e.readable=!1,e.emit("end"))}))}function w(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}s.prototype.read=function(e){var a=this._readableState;a.calledRead=!0;var t,r=e;if(("number"!=typeof e||e>0)&&(a.emittedReadable=!1),0===e&&a.needReadable&&(a.length>=a.highWaterMark||a.ended))return p(this),null;if(0===(e=l(e,a))&&a.ended)return t=null,a.length>0&&a.decoder&&(t=y(e,a),a.length-=t.length),0===a.length&&_(this),t;var c=a.needReadable;return a.length-e<=a.highWaterMark&&(c=!0),(a.ended||a.reading)&&(c=!1),c&&(a.reading=!0,a.sync=!0,0===a.length&&(a.needReadable=!0),this._read(a.highWaterMark),a.sync=!1),c&&!a.reading&&(e=l(r,a)),null===(t=e>0?y(e,a):null)&&(a.needReadable=!0,e=0),a.length-=e,0!==a.length||a.ended||(a.needReadable=!0),a.ended&&!a.endEmitted&&0===a.length&&_(this),t},s.prototype._read=function(e){this.emit("error",new Error("not implemented"))},s.prototype.pipe=function(e,a){var t=this,c=this._readableState;switch(c.pipesCount){case 0:c.pipes=e;break;case 1:c.pipes=[c.pipes,e];break;default:c.pipes.push(e)}c.pipesCount+=1;var i=(!a||!1!==a.end)&&e!==process.stdout&&e!==process.stderr?o:s;function f(e){e===t&&s()}function o(){e.end()}c.endEmitted?process.nextTick(i):t.once("end",i),e.on("unpipe",f);var d=function(e){return function(){var a=e._readableState;a.awaitDrain--,0===a.awaitDrain&&m(e)}}(t);function s(){e.removeListener("close",u),e.removeListener("finish",l),e.removeListener("drain",d),e.removeListener("error",b),e.removeListener("unpipe",f),t.removeListener("end",o),t.removeListener("end",s),e._writableState&&!e._writableState.needDrain||d()}function b(a){p(),e.removeListener("error",b),0===n.listenerCount(e,"error")&&e.emit("error",a)}function u(){e.removeListener("finish",l),p()}function l(){e.removeListener("close",u),p()}function p(){t.unpipe(e)}return e.on("drain",d),e._events&&e._events.error?r(e._events.error)?e._events.error.unshift(b):e._events.error=[b,e._events.error]:e.on("error",b),e.once("close",u),e.once("finish",l),e.emit("pipe",t),c.flowing||(this.on("readable",g),c.flowing=!0,process.nextTick(function(){m(t)})),e},s.prototype.unpipe=function(e){var a=this._readableState;if(0===a.pipesCount)return this;if(1===a.pipesCount)return e&&e!==a.pipes?this:(e||(e=a.pipes),a.pipes=null,a.pipesCount=0,this.removeListener("readable",g),a.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var t=a.pipes,r=a.pipesCount;a.pipes=null,a.pipesCount=0,this.removeListener("readable",g),a.flowing=!1;for(var c=0;c<r;c++)t[c].emit("unpipe",this);return this}return-1===(c=function(e,a){for(var t=0,r=e.length;t<r;t++)if(e[t]===a)return t;return-1}(a.pipes,e))?this:(a.pipes.splice(c,1),a.pipesCount-=1,1===a.pipesCount&&(a.pipes=a.pipes[0]),e.emit("unpipe",this),this)},s.prototype.on=function(e,a){var t=f.prototype.on.call(this,e,a);if("data"!==e||this._readableState.flowing||v(this),"readable"===e&&this.readable){var r=this._readableState;r.readableListening||(r.readableListening=!0,r.emittedReadable=!1,r.needReadable=!0,r.reading?r.length&&p(this):this.read(0))}return t},s.prototype.addListener=s.prototype.on,s.prototype.resume=function(){v(this),this.read(0),this.emit("resume")},s.prototype.pause=function(){v(this,!0),this.emit("pause")},s.prototype.wrap=function(e){var a=this._readableState,t=!1,r=this;for(var c in e.on("end",function(){if(a.decoder&&!a.ended){var e=a.decoder.end();e&&e.length&&r.push(e)}r.push(null)}),e.on("data",function(c){(a.decoder&&(c=a.decoder.write(c)),!a.objectMode||null!==c&&void 0!==c)&&((a.objectMode||c&&c.length)&&(r.push(c)||(t=!0,e.pause())))}),e)"function"==typeof e[c]&&void 0===this[c]&&(this[c]=function(a){return function(){return e[a].apply(e,arguments)}}(c));return w(["error","close","destroy","pause","resume"],function(a){e.on(a,r.emit.bind(r,a))}),r._read=function(a){t&&(t=!1,e.resume())},r},s._fromList=y},function(e,a,t){"use strict";e.exports=n;var r=t(62),c=t(17);function n(e){if(!(this instanceof n))return new n(e);r.call(this,e),this._transformState={afterTransform:function(e,a){var t=this._transformState;t.transforming=!1;var r=t.writecb;if(!r)return this.emit("error",new Error("write callback called multiple times"));t.writechunk=null,t.writecb=null,null!=a&&this.push(a),r(e);var c=this._readableState;c.reading=!1,(c.needReadable||c.length<c.highWaterMark)&&this._read(c.highWaterMark)}.bind(this),needTransform:!1,transforming:!1,writecb:null,writechunk:null,writeencoding:null},this._readableState.needReadable=!0,this._readableState.sync=!1,e&&("function"==typeof e.transform&&(this._transform=e.transform),"function"==typeof e.flush&&(this._flush=e.flush)),this.on("prefinish",i)}function i(){var e=this;"function"==typeof this._flush?this._flush(function(a,t){f(e,a,t)}):f(this,null,null)}function f(e,a,t){if(a)return e.emit("error",a);if(null!=t&&e.push(t),e._writableState.length)throw new Error("Calling transform done when ws.length != 0");if(e._transformState.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}c.inherits=t(0),c.inherits(n,r),n.prototype.push=function(e,a){return this._transformState.needTransform=!1,r.prototype.push.call(this,e,a)},n.prototype._transform=function(e,a,t){throw new Error("_transform() is not implemented")},n.prototype._write=function(e,a,t){var r=this._transformState;if(r.writecb=t,r.writechunk=e,r.writeencoding=a,!r.transforming){var c=this._readableState;(r.needTransform||c.needReadable||c.length<c.highWaterMark)&&this._read(c.highWaterMark)}},n.prototype._read=function(e){var a=this._transformState;null!==a.writechunk&&a.writecb&&!a.transforming?(a.transforming=!0,this._transform(a.writechunk,a.writeencoding,a.afterTransform)):a.needTransform=!0},n.prototype._destroy=function(e,a){var t=this;r.prototype._destroy.call(this,e,function(e){a(e),t.emit("close")})}},function(e,a,t){"use strict";var r=t(7).Buffer,c=r.isEncoding||function(e){switch((e=""+e)&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};function n(e){var a;switch(this.encoding=function(e){var a=function(e){if(!e)return"utf8";for(var a;;)switch(e){case"utf8":case"utf-8":return"utf8";case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return"utf16le";case"latin1":case"binary":return"latin1";case"base64":case"ascii":case"hex":return e;default:if(a)return;e=(""+e).toLowerCase(),a=!0}}(e);if("string"!=typeof a&&(r.isEncoding===c||!c(e)))throw new Error("Unknown encoding: "+e);return a||e}(e),this.encoding){case"utf16le":this.text=o,this.end=d,a=4;break;case"utf8":this.fillLast=f,a=4;break;case"base64":this.text=s,this.end=b,a=3;break;default:return this.write=u,void(this.end=l)}this.lastNeed=0,this.lastTotal=0,this.lastChar=r.allocUnsafe(a)}function i(e){return e<=127?0:e>>5==6?2:e>>4==14?3:e>>3==30?4:e>>6==2?-1:-2}function f(e){var a=this.lastTotal-this.lastNeed,t=function(e,a,t){if(128!=(192&a[0]))return e.lastNeed=0,"�";if(e.lastNeed>1&&a.length>1){if(128!=(192&a[1]))return e.lastNeed=1,"�";if(e.lastNeed>2&&a.length>2&&128!=(192&a[2]))return e.lastNeed=2,"�"}}(this,e);return void 0!==t?t:this.lastNeed<=e.length?(e.copy(this.lastChar,a,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal)):(e.copy(this.lastChar,a,0,e.length),void(this.lastNeed-=e.length))}function o(e,a){if((e.length-a)%2==0){var t=e.toString("utf16le",a);if(t){var r=t.charCodeAt(t.length-1);if(r>=55296&&r<=56319)return this.lastNeed=2,this.lastTotal=4,this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1],t.slice(0,-1)}return t}return this.lastNeed=1,this.lastTotal=2,this.lastChar[0]=e[e.length-1],e.toString("utf16le",a,e.length-1)}function d(e){var a=e&&e.length?this.write(e):"";if(this.lastNeed){var t=this.lastTotal-this.lastNeed;return a+this.lastChar.toString("utf16le",0,t)}return a}function s(e,a){var t=(e.length-a)%3;return 0===t?e.toString("base64",a):(this.lastNeed=3-t,this.lastTotal=3,1===t?this.lastChar[0]=e[e.length-1]:(this.lastChar[0]=e[e.length-2],this.lastChar[1]=e[e.length-1]),e.toString("base64",a,e.length-t))}function b(e){var a=e&&e.length?this.write(e):"";return this.lastNeed?a+this.lastChar.toString("base64",0,3-this.lastNeed):a}function u(e){return e.toString(this.encoding)}function l(e){return e&&e.length?this.write(e):""}a.StringDecoder=n,n.prototype.write=function(e){if(0===e.length)return"";var a,t;if(this.lastNeed){if(void 0===(a=this.fillLast(e)))return"";t=this.lastNeed,this.lastNeed=0}else t=0;return t<e.length?a?a+this.text(e,t):this.text(e,t):a||""},n.prototype.end=function(e){var a=e&&e.length?this.write(e):"";return this.lastNeed?a+"�":a},n.prototype.text=function(e,a){var t=function(e,a,t){var r=a.length-1;if(r<t)return 0;var c=i(a[r]);if(c>=0)return c>0&&(e.lastNeed=c-1),c;if(--r<t||-2===c)return 0;if((c=i(a[r]))>=0)return c>0&&(e.lastNeed=c-2),c;if(--r<t||-2===c)return 0;if((c=i(a[r]))>=0)return c>0&&(2===c?c=0:e.lastNeed=c-3),c;return 0}(this,e,a);if(!this.lastNeed)return e.toString("utf8",a);this.lastTotal=t;var r=e.length-(t-this.lastNeed);return e.copy(this.lastChar,0,r),e.toString("utf8",a,r)},n.prototype.fillLast=function(e){if(this.lastNeed<=e.length)return e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,this.lastNeed),this.lastChar.toString(this.encoding,0,this.lastTotal);e.copy(this.lastChar,this.lastTotal-this.lastNeed,0,e.length),this.lastNeed-=e.length}},function(e,a,t){"use strict";var r=t(118);function c(e){var a=this;this.next=null,this.entry=null,this.finish=function(){!function(e,a,t){var r=e.entry;e.entry=null;for(;r;){var c=r.callback;a.pendingcb--,c(t),r=r.next}a.corkedRequestsFree?a.corkedRequestsFree.next=e:a.corkedRequestsFree=e}(a,e)}}e.exports=m;var n,i=!process.browser&&["v0.10","v0.9."].indexOf(process.version.slice(0,5))>-1?setImmediate:r.nextTick;m.WritableState=h;var f=t(17);f.inherits=t(0);var o={deprecate:t(912)},d=t(341),s=t(7).Buffer,b=global.Uint8Array||function(){};var u,l=t(340);function p(){}function h(e,a){n=n||t(62),e=e||{};var f=a instanceof n;this.objectMode=!!e.objectMode,f&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var o=e.highWaterMark,d=e.writableHighWaterMark,s=this.objectMode?16:16384;this.highWaterMark=o||0===o?o:f&&(d||0===d)?d:s,this.highWaterMark=Math.floor(this.highWaterMark),this.finalCalled=!1,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1,this.destroyed=!1;var b=!1===e.decodeStrings;this.decodeStrings=!b,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,a){var t=e._writableState,c=t.sync,n=t.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(t),a)!function(e,a,t,c,n){--a.pendingcb,t?(r.nextTick(n,c),r.nextTick(A,e,a),e._writableState.errorEmitted=!0,e.emit("error",c)):(n(c),e._writableState.errorEmitted=!0,e.emit("error",c),A(e,a))}(e,t,c,a,n);else{var f=_(t);f||t.corked||t.bufferProcessing||!t.bufferedRequest||y(e,t),c?i(v,e,t,f,n):v(e,t,f,n)}}(a,e)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new c(this)}function m(e){if(n=n||t(62),!(u.call(m,this)||this instanceof n))return new m(e);this._writableState=new h(e,this),this.writable=!0,e&&("function"==typeof e.write&&(this._write=e.write),"function"==typeof e.writev&&(this._writev=e.writev),"function"==typeof e.destroy&&(this._destroy=e.destroy),"function"==typeof e.final&&(this._final=e.final)),d.call(this)}function g(e,a,t,r,c,n,i){a.writelen=r,a.writecb=i,a.writing=!0,a.sync=!0,t?e._writev(c,a.onwrite):e._write(c,n,a.onwrite),a.sync=!1}function v(e,a,t,r){t||function(e,a){0===a.length&&a.needDrain&&(a.needDrain=!1,e.emit("drain"))}(e,a),a.pendingcb--,r(),A(e,a)}function y(e,a){a.bufferProcessing=!0;var t=a.bufferedRequest;if(e._writev&&t&&t.next){var r=a.bufferedRequestCount,n=new Array(r),i=a.corkedRequestsFree;i.entry=t;for(var f=0,o=!0;t;)n[f]=t,t.isBuf||(o=!1),t=t.next,f+=1;n.allBuffers=o,g(e,a,!0,a.length,n,"",i.finish),a.pendingcb++,a.lastBufferedRequest=null,i.next?(a.corkedRequestsFree=i.next,i.next=null):a.corkedRequestsFree=new c(a),a.bufferedRequestCount=0}else{for(;t;){var d=t.chunk,s=t.encoding,b=t.callback;if(g(e,a,!1,a.objectMode?1:d.length,d,s,b),t=t.next,a.bufferedRequestCount--,a.writing)break}null===t&&(a.lastBufferedRequest=null)}a.bufferedRequest=t,a.bufferProcessing=!1}function _(e){return e.ending&&0===e.length&&null===e.bufferedRequest&&!e.finished&&!e.writing}function w(e,a){e._final(function(t){a.pendingcb--,t&&e.emit("error",t),a.prefinished=!0,e.emit("prefinish"),A(e,a)})}function A(e,a){var t=_(a);return t&&(!function(e,a){a.prefinished||a.finalCalled||("function"==typeof e._final?(a.pendingcb++,a.finalCalled=!0,r.nextTick(w,e,a)):(a.prefinished=!0,e.emit("prefinish")))}(e,a),0===a.pendingcb&&(a.finished=!0,e.emit("finish"))),t}f.inherits(m,d),h.prototype.getBuffer=function(){for(var e=this.bufferedRequest,a=[];e;)a.push(e),e=e.next;return a},function(){try{Object.defineProperty(h.prototype,"buffer",{get:o.deprecate(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.","DEP0003")})}catch(e){}}(),"function"==typeof Symbol&&Symbol.hasInstance&&"function"==typeof Function.prototype[Symbol.hasInstance]?(u=Function.prototype[Symbol.hasInstance],Object.defineProperty(m,Symbol.hasInstance,{value:function(e){return!!u.call(this,e)||this===m&&(e&&e._writableState instanceof h)}})):u=function(e){return e instanceof this},m.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))},m.prototype.write=function(e,a,t){var c=this._writableState,n=!1,i=!c.objectMode&&function(e){return s.isBuffer(e)||e instanceof b}(e);return i&&!s.isBuffer(e)&&(e=function(e){return s.from(e)}(e)),"function"==typeof a&&(t=a,a=null),i?a="buffer":a||(a=c.defaultEncoding),"function"!=typeof t&&(t=p),c.ended?function(e,a){var t=new Error("write after end");e.emit("error",t),r.nextTick(a,t)}(this,t):(i||function(e,a,t,c){var n=!0,i=!1;return null===t?i=new TypeError("May not write null values to stream"):"string"==typeof t||void 0===t||a.objectMode||(i=new TypeError("Invalid non-string/buffer chunk")),i&&(e.emit("error",i),r.nextTick(c,i),n=!1),n}(this,c,e,t))&&(c.pendingcb++,n=function(e,a,t,r,c,n){if(!t){var i=function(e,a,t){e.objectMode||!1===e.decodeStrings||"string"!=typeof a||(a=s.from(a,t));return a}(a,r,c);r!==i&&(t=!0,c="buffer",r=i)}var f=a.objectMode?1:r.length;a.length+=f;var o=a.length<a.highWaterMark;o||(a.needDrain=!0);if(a.writing||a.corked){var d=a.lastBufferedRequest;a.lastBufferedRequest={chunk:r,encoding:c,isBuf:t,callback:n,next:null},d?d.next=a.lastBufferedRequest:a.bufferedRequest=a.lastBufferedRequest,a.bufferedRequestCount+=1}else g(e,a,!1,f,r,c,n);return o}(this,c,i,e,a,t)),n},m.prototype.cork=function(){this._writableState.corked++},m.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.finished||e.bufferProcessing||!e.bufferedRequest||y(this,e))},m.prototype.setDefaultEncoding=function(e){if("string"==typeof e&&(e=e.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((e+"").toLowerCase())>-1))throw new TypeError("Unknown encoding: "+e);return this._writableState.defaultEncoding=e,this},Object.defineProperty(m.prototype,"writableHighWaterMark",{enumerable:!1,get:function(){return this._writableState.highWaterMark}}),m.prototype._write=function(e,a,t){t(new Error("_write() is not implemented"))},m.prototype._writev=null,m.prototype.end=function(e,a,t){var c=this._writableState;"function"==typeof e?(t=e,e=null,a=null):"function"==typeof a&&(t=a,a=null),null!==e&&void 0!==e&&this.write(e,a),c.corked&&(c.corked=1,this.uncork()),c.ending||c.finished||function(e,a,t){a.ending=!0,A(e,a),t&&(a.finished?r.nextTick(t):e.once("finish",t));a.ended=!0,e.writable=!1}(this,c,t)},Object.defineProperty(m.prototype,"destroyed",{get:function(){return void 0!==this._writableState&&this._writableState.destroyed},set:function(e){this._writableState&&(this._writableState.destroyed=e)}}),m.prototype.destroy=l.destroy,m.prototype._undestroy=l.undestroy,m.prototype._destroy=function(e,a){this.end(),a(e)}},function(e,a,t){"use strict";var r=t(118);function c(e,a){e.emit("error",a)}e.exports={destroy:function(e,a){var t=this,n=this._readableState&&this._readableState.destroyed,i=this._writableState&&this._writableState.destroyed;return n||i?(a?a(e):!e||this._writableState&&this._writableState.errorEmitted||r.nextTick(c,this,e),this):(this._readableState&&(this._readableState.destroyed=!0),this._writableState&&(this._writableState.destroyed=!0),this._destroy(e||null,function(e){!a&&e?(r.nextTick(c,t,e),t._writableState&&(t._writableState.errorEmitted=!0)):a&&a(e)}),this)},undestroy:function(){this._readableState&&(this._readableState.destroyed=!1,this._readableState.reading=!1,this._readableState.ended=!1,this._readableState.endEmitted=!1),this._writableState&&(this._writableState.destroyed=!1,this._writableState.ended=!1,this._writableState.ending=!1,this._writableState.finished=!1,this._writableState.errorEmitted=!1)}}},function(e,a,t){e.exports=t(6)},function(e,a,t){"use strict";var r=t(118);e.exports=v;var c,n=t(914);v.ReadableState=g;t(5).EventEmitter;var i=function(e,a){return e.listeners(a).length},f=t(341),o=t(7).Buffer,d=global.Uint8Array||function(){};var s=t(17);s.inherits=t(0);var b=t(1),u=void 0;u=b&&b.debuglog?b.debuglog("stream"):function(){};var l,p=t(913),h=t(340);s.inherits(v,f);var m=["error","close","destroy","pause","resume"];function g(e,a){c=c||t(62),e=e||{};var r=a instanceof c;this.objectMode=!!e.objectMode,r&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,i=e.readableHighWaterMark,f=this.objectMode?16:16384;this.highWaterMark=n||0===n?n:r&&(i||0===i)?i:f,this.highWaterMark=Math.floor(this.highWaterMark),this.buffer=new p,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.destroyed=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(l||(l=t(338).StringDecoder),this.decoder=new l(e.encoding),this.encoding=e.encoding)}function v(e){if(c=c||t(62),!(this instanceof v))return new v(e);this._readableState=new g(e,this),this.readable=!0,e&&("function"==typeof e.read&&(this._read=e.read),"function"==typeof e.destroy&&(this._destroy=e.destroy)),f.call(this)}function y(e,a,t,r,c){var n,i=e._readableState;null===a?(i.reading=!1,function(e,a){if(a.ended)return;if(a.decoder){var t=a.decoder.end();t&&t.length&&(a.buffer.push(t),a.length+=a.objectMode?1:t.length)}a.ended=!0,k(e)}(e,i)):(c||(n=function(e,a){var t;(function(e){return o.isBuffer(e)||e instanceof d})(a)||"string"==typeof a||void 0===a||e.objectMode||(t=new TypeError("Invalid non-string/buffer chunk"));return t}(i,a)),n?e.emit("error",n):i.objectMode||a&&a.length>0?("string"==typeof a||i.objectMode||Object.getPrototypeOf(a)===o.prototype||(a=function(e){return o.from(e)}(a)),r?i.endEmitted?e.emit("error",new Error("stream.unshift() after end event")):_(e,i,a,!0):i.ended?e.emit("error",new Error("stream.push() after EOF")):(i.reading=!1,i.decoder&&!t?(a=i.decoder.write(a),i.objectMode||0!==a.length?_(e,i,a,!1):E(e,i)):_(e,i,a,!1))):r||(i.reading=!1));return function(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(i)}function _(e,a,t,r){a.flowing&&0===a.length&&!a.sync?(e.emit("data",t),e.read(0)):(a.length+=a.objectMode?1:t.length,r?a.buffer.unshift(t):a.buffer.push(t),a.needReadable&&k(e)),E(e,a)}Object.defineProperty(v.prototype,"destroyed",{get:function(){return void 0!==this._readableState&&this._readableState.destroyed},set:function(e){this._readableState&&(this._readableState.destroyed=e)}}),v.prototype.destroy=h.destroy,v.prototype._undestroy=h.undestroy,v.prototype._destroy=function(e,a){this.push(null),a(e)},v.prototype.push=function(e,a){var t,r=this._readableState;return r.objectMode?t=!0:"string"==typeof e&&((a=a||r.defaultEncoding)!==r.encoding&&(e=o.from(e,a),a=""),t=!0),y(this,e,a,!1,t)},v.prototype.unshift=function(e){return y(this,e,null,!0,!1)},v.prototype.isPaused=function(){return!1===this._readableState.flowing},v.prototype.setEncoding=function(e){return l||(l=t(338).StringDecoder),this._readableState.decoder=new l(e),this._readableState.encoding=e,this};var w=8388608;function A(e,a){return e<=0||0===a.length&&a.ended?0:a.objectMode?1:e!=e?a.flowing&&a.length?a.buffer.head.data.length:a.length:(e>a.highWaterMark&&(a.highWaterMark=function(e){return e>=w?e=w:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}(e)),e<=a.length?e:a.ended?a.length:(a.needReadable=!0,0))}function k(e){var a=e._readableState;a.needReadable=!1,a.emittedReadable||(u("emitReadable",a.flowing),a.emittedReadable=!0,a.sync?r.nextTick(x,e):x(e))}function x(e){u("emit readable"),e.emit("readable"),C(e)}function E(e,a){a.readingMore||(a.readingMore=!0,r.nextTick(S,e,a))}function S(e,a){for(var t=a.length;!a.reading&&!a.flowing&&!a.ended&&a.length<a.highWaterMark&&(u("maybeReadMore read 0"),e.read(0),t!==a.length);)t=a.length;a.readingMore=!1}function T(e){u("readable nexttick read 0"),e.read(0)}function j(e,a){a.reading||(u("resume read 0"),e.read(0)),a.resumeScheduled=!1,a.awaitDrain=0,e.emit("resume"),C(e),a.flowing&&!a.reading&&e.read(0)}function C(e){var a=e._readableState;for(u("flow",a.flowing);a.flowing&&null!==e.read(););}function R(e,a){return 0===a.length?null:(a.objectMode?t=a.buffer.shift():!e||e>=a.length?(t=a.decoder?a.buffer.join(""):1===a.buffer.length?a.buffer.head.data:a.buffer.concat(a.length),a.buffer.clear()):t=function(e,a,t){var r;e<a.head.data.length?(r=a.head.data.slice(0,e),a.head.data=a.head.data.slice(e)):r=e===a.head.data.length?a.shift():t?function(e,a){var t=a.head,r=1,c=t.data;e-=c.length;for(;t=t.next;){var n=t.data,i=e>n.length?n.length:e;if(i===n.length?c+=n:c+=n.slice(0,e),0===(e-=i)){i===n.length?(++r,t.next?a.head=t.next:a.head=a.tail=null):(a.head=t,t.data=n.slice(i));break}++r}return a.length-=r,c}(e,a):function(e,a){var t=o.allocUnsafe(e),r=a.head,c=1;r.data.copy(t),e-=r.data.length;for(;r=r.next;){var n=r.data,i=e>n.length?n.length:e;if(n.copy(t,t.length-e,0,i),0===(e-=i)){i===n.length?(++c,r.next?a.head=r.next:a.head=a.tail=null):(a.head=r,r.data=n.slice(i));break}++c}return a.length-=c,t}(e,a);return r}(e,a.buffer,a.decoder),t);var t}function O(e){var a=e._readableState;if(a.length>0)throw new Error('"endReadable()" called on non-empty stream');a.endEmitted||(a.ended=!0,r.nextTick(B,a,e))}function B(e,a){e.endEmitted||0!==e.length||(e.endEmitted=!0,a.readable=!1,a.emit("end"))}function M(e,a){for(var t=0,r=e.length;t<r;t++)if(e[t]===a)return t;return-1}v.prototype.read=function(e){u("read",e),e=parseInt(e,10);var a=this._readableState,t=e;if(0!==e&&(a.emittedReadable=!1),0===e&&a.needReadable&&(a.length>=a.highWaterMark||a.ended))return u("read: emitReadable",a.length,a.ended),0===a.length&&a.ended?O(this):k(this),null;if(0===(e=A(e,a))&&a.ended)return 0===a.length&&O(this),null;var r,c=a.needReadable;return u("need readable",c),(0===a.length||a.length-e<a.highWaterMark)&&u("length less than watermark",c=!0),a.ended||a.reading?u("reading or ended",c=!1):c&&(u("do read"),a.reading=!0,a.sync=!0,0===a.length&&(a.needReadable=!0),this._read(a.highWaterMark),a.sync=!1,a.reading||(e=A(t,a))),null===(r=e>0?R(e,a):null)?(a.needReadable=!0,e=0):a.length-=e,0===a.length&&(a.ended||(a.needReadable=!0),t!==e&&a.ended&&O(this)),null!==r&&this.emit("data",r),r},v.prototype._read=function(e){this.emit("error",new Error("_read() is not implemented"))},v.prototype.pipe=function(e,a){var t=this,c=this._readableState;switch(c.pipesCount){case 0:c.pipes=e;break;case 1:c.pipes=[c.pipes,e];break;default:c.pipes.push(e)}c.pipesCount+=1,u("pipe count=%d opts=%j",c.pipesCount,a);var f=(!a||!1!==a.end)&&e!==process.stdout&&e!==process.stderr?d:v;function o(a,r){u("onunpipe"),a===t&&r&&!1===r.hasUnpiped&&(r.hasUnpiped=!0,u("cleanup"),e.removeListener("close",m),e.removeListener("finish",g),e.removeListener("drain",s),e.removeListener("error",h),e.removeListener("unpipe",o),t.removeListener("end",d),t.removeListener("end",v),t.removeListener("data",p),b=!0,!c.awaitDrain||e._writableState&&!e._writableState.needDrain||s())}function d(){u("onend"),e.end()}c.endEmitted?r.nextTick(f):t.once("end",f),e.on("unpipe",o);var s=function(e){return function(){var a=e._readableState;u("pipeOnDrain",a.awaitDrain),a.awaitDrain&&a.awaitDrain--,0===a.awaitDrain&&i(e,"data")&&(a.flowing=!0,C(e))}}(t);e.on("drain",s);var b=!1;var l=!1;function p(a){u("ondata"),l=!1,!1!==e.write(a)||l||((1===c.pipesCount&&c.pipes===e||c.pipesCount>1&&-1!==M(c.pipes,e))&&!b&&(u("false write response, pause",t._readableState.awaitDrain),t._readableState.awaitDrain++,l=!0),t.pause())}function h(a){u("onerror",a),v(),e.removeListener("error",h),0===i(e,"error")&&e.emit("error",a)}function m(){e.removeListener("finish",g),v()}function g(){u("onfinish"),e.removeListener("close",m),v()}function v(){u("unpipe"),t.unpipe(e)}return t.on("data",p),function(e,a,t){if("function"==typeof e.prependListener)return e.prependListener(a,t);e._events&&e._events[a]?n(e._events[a])?e._events[a].unshift(t):e._events[a]=[t,e._events[a]]:e.on(a,t)}(e,"error",h),e.once("close",m),e.once("finish",g),e.emit("pipe",t),c.flowing||(u("pipe resume"),t.resume()),e},v.prototype.unpipe=function(e){var a=this._readableState,t={hasUnpiped:!1};if(0===a.pipesCount)return this;if(1===a.pipesCount)return e&&e!==a.pipes?this:(e||(e=a.pipes),a.pipes=null,a.pipesCount=0,a.flowing=!1,e&&e.emit("unpipe",this,t),this);if(!e){var r=a.pipes,c=a.pipesCount;a.pipes=null,a.pipesCount=0,a.flowing=!1;for(var n=0;n<c;n++)r[n].emit("unpipe",this,t);return this}var i=M(a.pipes,e);return-1===i?this:(a.pipes.splice(i,1),a.pipesCount-=1,1===a.pipesCount&&(a.pipes=a.pipes[0]),e.emit("unpipe",this,t),this)},v.prototype.on=function(e,a){var t=f.prototype.on.call(this,e,a);if("data"===e)!1!==this._readableState.flowing&&this.resume();else if("readable"===e){var c=this._readableState;c.endEmitted||c.readableListening||(c.readableListening=c.needReadable=!0,c.emittedReadable=!1,c.reading?c.length&&k(this):r.nextTick(T,this))}return t},v.prototype.addListener=v.prototype.on,v.prototype.resume=function(){var e=this._readableState;return e.flowing||(u("resume"),e.flowing=!0,function(e,a){a.resumeScheduled||(a.resumeScheduled=!0,r.nextTick(j,e,a))}(this,e)),this},v.prototype.pause=function(){return u("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(u("pause"),this._readableState.flowing=!1,this.emit("pause")),this},v.prototype.wrap=function(e){var a=this,t=this._readableState,r=!1;for(var c in e.on("end",function(){if(u("wrapped end"),t.decoder&&!t.ended){var e=t.decoder.end();e&&e.length&&a.push(e)}a.push(null)}),e.on("data",function(c){(u("wrapped data"),t.decoder&&(c=t.decoder.write(c)),!t.objectMode||null!==c&&void 0!==c)&&((t.objectMode||c&&c.length)&&(a.push(c)||(r=!0,e.pause())))}),e)void 0===this[c]&&"function"==typeof e[c]&&(this[c]=function(a){return function(){return e[a].apply(e,arguments)}}(c));for(var n=0;n<m.length;n++)e.on(m[n],this.emit.bind(this,m[n]));return this._read=function(a){u("wrapped _read",a),r&&(r=!1,e.resume())},this},Object.defineProperty(v.prototype,"readableHighWaterMark",{enumerable:!1,get:function(){return this._readableState.highWaterMark}}),v._fromList=R},function(e,a,t){var r=t(6);"disable"===process.env.READABLE_STREAM&&r?(e.exports=r,(a=e.exports=r.Readable).Readable=r.Readable,a.Writable=r.Writable,a.Duplex=r.Duplex,a.Transform=r.Transform,a.PassThrough=r.PassThrough,a.Stream=r):((a=e.exports=t(342)).Stream=r||a,a.Readable=a,a.Writable=t(339),a.Duplex=t(62),a.Transform=t(337),a.PassThrough=t(911))},function(e,a,t){"use strict";e.exports=function(e){return new d(e||p,null)};var r=0,c=1;function n(e,a,t,r,c,n){this._color=e,this.key=a,this.value=t,this.left=r,this.right=c,this._count=n}function i(e){return new n(e._color,e.key,e.value,e.left,e.right,e._count)}function f(e,a){return new n(e,a.key,a.value,a.left,a.right,a._count)}function o(e){e._count=1+(e.left?e.left._count:0)+(e.right?e.right._count:0)}function d(e,a){this._compare=e,this.root=a}var s=d.prototype;function b(e,a){this.tree=e,this._stack=a}Object.defineProperty(s,"keys",{get:function(){var e=[];return this.forEach(function(a,t){e.push(a)}),e}}),Object.defineProperty(s,"values",{get:function(){var e=[];return this.forEach(function(a,t){e.push(t)}),e}}),Object.defineProperty(s,"length",{get:function(){return this.root?this.root._count:0}}),s.insert=function(e,a){for(var t=this._compare,i=this.root,s=[],b=[];i;){var u=t(e,i.key);s.push(i),b.push(u),i=u<=0?i.left:i.right}s.push(new n(r,e,a,null,null,1));for(var l=s.length-2;l>=0;--l){i=s[l];b[l]<=0?s[l]=new n(i._color,i.key,i.value,s[l+1],i.right,i._count+1):s[l]=new n(i._color,i.key,i.value,i.left,s[l+1],i._count+1)}for(l=s.length-1;l>1;--l){var p=s[l-1];i=s[l];if(p._color===c||i._color===c)break;var h=s[l-2];if(h.left===p)if(p.left===i){if(!(m=h.right)||m._color!==r){if(h._color=r,h.left=p.right,p._color=c,p.right=h,s[l-2]=p,s[l-1]=i,o(h),o(p),l>=3)(g=s[l-3]).left===h?g.left=p:g.right=p;break}p._color=c,h.right=f(c,m),h._color=r,l-=1}else{if(!(m=h.right)||m._color!==r){if(p.right=i.left,h._color=r,h.left=i.right,i._color=c,i.left=p,i.right=h,s[l-2]=i,s[l-1]=p,o(h),o(p),o(i),l>=3)(g=s[l-3]).left===h?g.left=i:g.right=i;break}p._color=c,h.right=f(c,m),h._color=r,l-=1}else if(p.right===i){if(!(m=h.left)||m._color!==r){if(h._color=r,h.right=p.left,p._color=c,p.left=h,s[l-2]=p,s[l-1]=i,o(h),o(p),l>=3)(g=s[l-3]).right===h?g.right=p:g.left=p;break}p._color=c,h.left=f(c,m),h._color=r,l-=1}else{var m;if(!(m=h.left)||m._color!==r){var g;if(p.left=i.right,h._color=r,h.right=i.left,i._color=c,i.right=p,i.left=h,s[l-2]=i,s[l-1]=p,o(h),o(p),o(i),l>=3)(g=s[l-3]).right===h?g.right=i:g.left=i;break}p._color=c,h.left=f(c,m),h._color=r,l-=1}}return s[0]._color=c,new d(t,s[0])},s.forEach=function(e,a,t){if(this.root)switch(arguments.length){case 1:return function e(a,t){var r;if(t.left&&(r=e(a,t.left)))return r;return(r=a(t.key,t.value))||(t.right?e(a,t.right):void 0)}(e,this.root);case 2:return function e(a,t,r,c){if(t(a,c.key)<=0){var n;if(c.left&&(n=e(a,t,r,c.left)))return n;if(n=r(c.key,c.value))return n}if(c.right)return e(a,t,r,c.right)}(a,this._compare,e,this.root);case 3:if(this._compare(a,t)>=0)return;return function e(a,t,r,c,n){var i,f=r(a,n.key),o=r(t,n.key);if(f<=0){if(n.left&&(i=e(a,t,r,c,n.left)))return i;if(o>0&&(i=c(n.key,n.value)))return i}if(o>0&&n.right)return e(a,t,r,c,n.right)}(a,t,this._compare,e,this.root)}},Object.defineProperty(s,"begin",{get:function(){for(var e=[],a=this.root;a;)e.push(a),a=a.left;return new b(this,e)}}),Object.defineProperty(s,"end",{get:function(){for(var e=[],a=this.root;a;)e.push(a),a=a.right;return new b(this,e)}}),s.at=function(e){if(e<0)return new b(this,[]);for(var a=this.root,t=[];;){if(t.push(a),a.left){if(e<a.left._count){a=a.left;continue}e-=a.left._count}if(!e)return new b(this,t);if(e-=1,!a.right)break;if(e>=a.right._count)break;a=a.right}return new b(this,[])},s.ge=function(e){for(var a=this._compare,t=this.root,r=[],c=0;t;){var n=a(e,t.key);r.push(t),n<=0&&(c=r.length),t=n<=0?t.left:t.right}return r.length=c,new b(this,r)},s.gt=function(e){for(var a=this._compare,t=this.root,r=[],c=0;t;){var n=a(e,t.key);r.push(t),n<0&&(c=r.length),t=n<0?t.left:t.right}return r.length=c,new b(this,r)},s.lt=function(e){for(var a=this._compare,t=this.root,r=[],c=0;t;){var n=a(e,t.key);r.push(t),n>0&&(c=r.length),t=n<=0?t.left:t.right}return r.length=c,new b(this,r)},s.le=function(e){for(var a=this._compare,t=this.root,r=[],c=0;t;){var n=a(e,t.key);r.push(t),n>=0&&(c=r.length),t=n<0?t.left:t.right}return r.length=c,new b(this,r)},s.find=function(e){for(var a=this._compare,t=this.root,r=[];t;){var c=a(e,t.key);if(r.push(t),0===c)return new b(this,r);t=c<=0?t.left:t.right}return new b(this,[])},s.remove=function(e){var a=this.find(e);return a?a.remove():this},s.get=function(e){for(var a=this._compare,t=this.root;t;){var r=a(e,t.key);if(0===r)return t.value;t=r<=0?t.left:t.right}};var u=b.prototype;function l(e,a){e.key=a.key,e.value=a.value,e.left=a.left,e.right=a.right,e._color=a._color,e._count=a._count}function p(e,a){return e<a?-1:e>a?1:0}Object.defineProperty(u,"valid",{get:function(){return this._stack.length>0}}),Object.defineProperty(u,"node",{get:function(){return this._stack.length>0?this._stack[this._stack.length-1]:null},enumerable:!0}),u.clone=function(){return new b(this.tree,this._stack.slice())},u.remove=function(){var e=this._stack;if(0===e.length)return this.tree;var a=new Array(e.length),t=e[e.length-1];a[a.length-1]=new n(t._color,t.key,t.value,t.left,t.right,t._count);for(var s=e.length-2;s>=0;--s){(t=e[s]).left===e[s+1]?a[s]=new n(t._color,t.key,t.value,a[s+1],t.right,t._count):a[s]=new n(t._color,t.key,t.value,t.left,a[s+1],t._count)}if((t=a[a.length-1]).left&&t.right){var b=a.length;for(t=t.left;t.right;)a.push(t),t=t.right;var u=a[b-1];a.push(new n(t._color,u.key,u.value,t.left,t.right,t._count)),a[b-1].key=t.key,a[b-1].value=t.value;for(s=a.length-2;s>=b;--s)t=a[s],a[s]=new n(t._color,t.key,t.value,t.left,a[s+1],t._count);a[b-1].left=a[b]}if((t=a[a.length-1])._color===r){var p=a[a.length-2];p.left===t?p.left=null:p.right===t&&(p.right=null),a.pop();for(s=0;s<a.length;++s)a[s]._count--;return new d(this.tree._compare,a[0])}if(t.left||t.right){t.left?l(t,t.left):t.right&&l(t,t.right),t._color=c;for(s=0;s<a.length-1;++s)a[s]._count--;return new d(this.tree._compare,a[0])}if(1===a.length)return new d(this.tree._compare,null);for(s=0;s<a.length;++s)a[s]._count--;var h=a[a.length-2];return function(e){for(var a,t,n,d,s=e.length-1;s>=0;--s){if(a=e[s],0===s)return void(a._color=c);if((t=e[s-1]).left===a){if((n=t.right).right&&n.right._color===r)return d=(n=t.right=i(n)).right=i(n.right),t.right=n.left,n.left=t,n.right=d,n._color=t._color,a._color=c,t._color=c,d._color=c,o(t),o(n),s>1&&((b=e[s-2]).left===t?b.left=n:b.right=n),void(e[s-1]=n);if(n.left&&n.left._color===r)return d=(n=t.right=i(n)).left=i(n.left),t.right=d.left,n.left=d.right,d.left=t,d.right=n,d._color=t._color,t._color=c,n._color=c,a._color=c,o(t),o(n),o(d),s>1&&((b=e[s-2]).left===t?b.left=d:b.right=d),void(e[s-1]=d);if(n._color===c){if(t._color===r)return t._color=c,void(t.right=f(r,n));t.right=f(r,n);continue}n=i(n),t.right=n.left,n.left=t,n._color=t._color,t._color=r,o(t),o(n),s>1&&((b=e[s-2]).left===t?b.left=n:b.right=n),e[s-1]=n,e[s]=t,s+1<e.length?e[s+1]=a:e.push(a),s+=2}else{if((n=t.left).left&&n.left._color===r)return d=(n=t.left=i(n)).left=i(n.left),t.left=n.right,n.right=t,n.left=d,n._color=t._color,a._color=c,t._color=c,d._color=c,o(t),o(n),s>1&&((b=e[s-2]).right===t?b.right=n:b.left=n),void(e[s-1]=n);if(n.right&&n.right._color===r)return d=(n=t.left=i(n)).right=i(n.right),t.left=d.right,n.right=d.left,d.right=t,d.left=n,d._color=t._color,t._color=c,n._color=c,a._color=c,o(t),o(n),o(d),s>1&&((b=e[s-2]).right===t?b.right=d:b.left=d),void(e[s-1]=d);if(n._color===c){if(t._color===r)return t._color=c,void(t.left=f(r,n));t.left=f(r,n);continue}var b;n=i(n),t.left=n.right,n.right=t,n._color=t._color,t._color=r,o(t),o(n),s>1&&((b=e[s-2]).right===t?b.right=n:b.left=n),e[s-1]=n,e[s]=t,s+1<e.length?e[s+1]=a:e.push(a),s+=2}}}(a),h.left===t?h.left=null:h.right=null,new d(this.tree._compare,a[0])},Object.defineProperty(u,"key",{get:function(){if(this._stack.length>0)return this._stack[this._stack.length-1].key},enumerable:!0}),Object.defineProperty(u,"value",{get:function(){if(this._stack.length>0)return this._stack[this._stack.length-1].value},enumerable:!0}),Object.defineProperty(u,"index",{get:function(){var e=0,a=this._stack;if(0===a.length){var t=this.tree.root;return t?t._count:0}a[a.length-1].left&&(e=a[a.length-1].left._count);for(var r=a.length-2;r>=0;--r)a[r+1]===a[r].right&&(++e,a[r].left&&(e+=a[r].left._count));return e},enumerable:!0}),u.next=function(){var e=this._stack;if(0!==e.length){var a=e[e.length-1];if(a.right)for(a=a.right;a;)e.push(a),a=a.left;else for(e.pop();e.length>0&&e[e.length-1].right===a;)a=e[e.length-1],e.pop()}},Object.defineProperty(u,"hasNext",{get:function(){var e=this._stack;if(0===e.length)return!1;if(e[e.length-1].right)return!0;for(var a=e.length-1;a>0;--a)if(e[a-1].left===e[a])return!0;return!1}}),u.update=function(e){var a=this._stack;if(0===a.length)throw new Error("Can't update empty node!");var t=new Array(a.length),r=a[a.length-1];t[t.length-1]=new n(r._color,r.key,e,r.left,r.right,r._count);for(var c=a.length-2;c>=0;--c)(r=a[c]).left===a[c+1]?t[c]=new n(r._color,r.key,r.value,t[c+1],r.right,r._count):t[c]=new n(r._color,r.key,r.value,r.left,t[c+1],r._count);return new d(this.tree._compare,t[0])},u.prev=function(){var e=this._stack;if(0!==e.length){var a=e[e.length-1];if(a.left)for(a=a.left;a;)e.push(a),a=a.right;else for(e.pop();e.length>0&&e[e.length-1].left===a;)a=e[e.length-1],e.pop()}},Object.defineProperty(u,"hasPrev",{get:function(){var e=this._stack;if(0===e.length)return!1;if(e[e.length-1].left)return!0;for(var a=e.length-1;a>0;--a)if(e[a-1].right===e[a])return!0;return!1}})},function(e,a){function t(e){this._db=e,this._operations=[],this._written=!1}t.prototype._serializeKey=function(e){return this._db._serializeKey(e)},t.prototype._serializeValue=function(e){return this._db._serializeValue(e)},t.prototype._checkWritten=function(){if(this._written)throw new Error("write() already called on this batch")},t.prototype.put=function(e,a){this._checkWritten();var t=this._db._checkKey(e,"key",this._db._isBuffer);if(t)throw t;return e=this._serializeKey(e),a=this._serializeValue(a),"function"==typeof this._put?this._put(e,a):this._operations.push({type:"put",key:e,value:a}),this},t.prototype.del=function(e){this._checkWritten();var a=this._db._checkKey(e,"key",this._db._isBuffer);if(a)throw a;return e=this._serializeKey(e),"function"==typeof this._del?this._del(e):this._operations.push({type:"del",key:e}),this},t.prototype.clear=function(){return this._checkWritten(),this._operations=[],"function"==typeof this._clear&&this._clear(),this},t.prototype.write=function(e,a){if(this._checkWritten(),"function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("write() requires a callback argument");return"object"!=typeof e&&(e={}),this._written=!0,"function"==typeof this._write?this._write(a):"function"==typeof this._db._batch?this._db._batch(this._operations,e,a):void process.nextTick(a)},e.exports=t},function(e,a){function t(e){this.db=e,this._ended=!1,this._nexting=!1}t.prototype.next=function(e){var a=this;if("function"!=typeof e)throw new Error("next() requires a callback argument");return a._ended?e(new Error("cannot call next() after end()")):a._nexting?e(new Error("cannot call next() before previous next() has completed")):(a._nexting=!0,"function"==typeof a._next?a._next(function(){a._nexting=!1,e.apply(null,arguments)}):void process.nextTick(function(){a._nexting=!1,e()}))},t.prototype.end=function(e){if("function"!=typeof e)throw new Error("end() requires a callback argument");return this._ended?e(new Error("end() already called on iterator")):(this._ended=!0,"function"==typeof this._end?this._end(e):void process.nextTick(e))},e.exports=t},function(e,a,t){var r=t(39),c=t(346),n=t(345);function i(e){if(!arguments.length||void 0===e)throw new Error("constructor requires at least a location argument");if("string"!=typeof e)throw new Error("constructor requires a location string argument");this.location=e,this.status="new"}i.prototype.open=function(e,a){var t=this,r=this.status;if("function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("open() requires a callback argument");"object"!=typeof e&&(e={}),e.createIfMissing=0!=e.createIfMissing,e.errorIfExists=!!e.errorIfExists,"function"==typeof this._open?(this.status="opening",this._open(e,function(e){if(e)return t.status=r,a(e);t.status="open",a()})):(this.status="open",process.nextTick(a))},i.prototype.close=function(e){var a=this,t=this.status;if("function"!=typeof e)throw new Error("close() requires a callback argument");"function"==typeof this._close?(this.status="closing",this._close(function(r){if(r)return a.status=t,e(r);a.status="closed",e()})):(this.status="closed",process.nextTick(e))},i.prototype.get=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("get() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),a.asBuffer=0!=a.asBuffer,"function"==typeof this._get?this._get(e,a,t):void process.nextTick(function(){t(new Error("NotFound"))}))},i.prototype.put=function(e,a,t,r){var c;if("function"==typeof t&&(r=t),"function"!=typeof r)throw new Error("put() requires a callback argument");return(c=this._checkKey(e,"key"))?r(c):(e=this._serializeKey(e),a=this._serializeValue(a),"object"!=typeof t&&(t={}),"function"==typeof this._put?this._put(e,a,t,r):void process.nextTick(r))},i.prototype.del=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("del() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),"function"==typeof this._del?this._del(e,a,t):void process.nextTick(t))},i.prototype.batch=function(e,a,t){if(!arguments.length)return this._chainedBatch();if("function"==typeof a&&(t=a),"function"==typeof e&&(t=e),"function"!=typeof t)throw new Error("batch(array) requires a callback argument");if(!Array.isArray(e))return t(new Error("batch(array) requires an array argument"));a&&"object"==typeof a||(a={});for(var r,c,n=0,i=e.length;n<i;n++)if("object"==typeof(r=e[n])){if(c=this._checkKey(r.type,"type"))return t(c);if(c=this._checkKey(r.key,"key"))return t(c)}if("function"==typeof this._batch)return this._batch(e,a,t);process.nextTick(t)},i.prototype.approximateSize=function(e,a,t){if(null==e||null==a||"function"==typeof e||"function"==typeof a)throw new Error("approximateSize() requires valid `start`, `end` and `callback` arguments");if("function"!=typeof t)throw new Error("approximateSize() requires a callback argument");if(e=this._serializeKey(e),a=this._serializeKey(a),"function"==typeof this._approximateSize)return this._approximateSize(e,a,t);process.nextTick(function(){t(null,0)})},i.prototype._setupIteratorOptions=function(e){var a=this;return e=r(e),["start","end","gt","gte","lt","lte"].forEach(function(t){e[t]&&a._isBuffer(e[t])&&0===e[t].length&&delete e[t]}),e.reverse=!!e.reverse,e.keys=0!=e.keys,e.values=0!=e.values,e.limit="limit"in e?e.limit:-1,e.keyAsBuffer=0!=e.keyAsBuffer,e.valueAsBuffer=0!=e.valueAsBuffer,e},i.prototype.iterator=function(e){return"object"!=typeof e&&(e={}),e=this._setupIteratorOptions(e),"function"==typeof this._iterator?this._iterator(e):new c(this)},i.prototype._chainedBatch=function(){return new n(this)},i.prototype._isBuffer=function(e){return Buffer.isBuffer(e)},i.prototype._serializeKey=function(e){return this._isBuffer(e)?e:String(e)},i.prototype._serializeValue=function(e){return null==e?"":this._isBuffer(e)||process.browser?e:String(e)},i.prototype._checkKey=function(e,a){return null===e||void 0===e?new Error(a+" cannot be `null` or `undefined`"):this._isBuffer(e)&&0===e.length?new Error(a+" cannot be an empty Buffer"):""===String(e)?new Error(a+" cannot be an empty String"):void 0},e.exports=i},function(e,a,t){a.AbstractLevelDOWN=t(347),a.AbstractIterator=t(346),a.AbstractChainedBatch=t(345),a.isLevelDOWN=t(919)},function(e,a,t){var r=t(0),c=t(348).AbstractLevelDOWN,n=t(348).AbstractIterator,i=t(918),f=t(344),o=t(7).Buffer,d={},s=t(917);function b(e){return i.compare(e,this._end)>0}function u(e){return i.compare(e,this._end)>=0}function l(e){return i.compare(e,this._end)<0}function p(e){return i.compare(e,this._end)<=0}function h(e,a){n.call(this,e),this._limit=a.limit,-1===this._limit&&(this._limit=1/0);var t=e._store[e._location];this.keyAsBuffer=!1!==a.keyAsBuffer,this.valueAsBuffer=!1!==a.valueAsBuffer,this._reverse=a.reverse,this._options=a,this._done=0,this._reverse?(this._incr="prev",this._start=i.upperBound(a),this._end=i.lowerBound(a),void 0===this._start?this._tree=t.end:i.upperBoundInclusive(a)?this._tree=t.le(this._start):this._tree=t.lt(this._start),this._end&&(i.lowerBoundInclusive(a)?this._test=u:this._test=b)):(this._incr="next",this._start=i.lowerBound(a),this._end=i.upperBound(a),void 0===this._start?this._tree=t.begin:i.lowerBoundInclusive(a)?this._tree=t.ge(this._start):this._tree=t.gt(this._start),this._end&&(i.upperBoundInclusive(a)?this._test=p:this._test=l))}function m(e){if(!(this instanceof m))return new m(e);c.call(this,"string"==typeof e?e:""),this._location=this.location?"$"+this.location:"_tree",this._store=this.location?d:this,this._store[this._location]=this._store[this._location]||f(i.compare)}r(h,n),h.prototype._next=function(e){var a,t;return this._done++>=this._limit?s(e):this._tree.valid?(a=this._tree.key,t=this._tree.value,this._test(a)?(this.keyAsBuffer&&(a=o.from(a)),this.valueAsBuffer&&(t=o.from(t)),this._tree[this._incr](),void s(function(){e(null,a,t)})):s(e)):s(e)},h.prototype._test=function(){return!0},m.clearGlobalStore=function(e){e?Object.keys(d).forEach(function(e){delete d[e]}):d={}},r(m,c),m.prototype._open=function(e,a){var t=this;s(function(){a(null,t)})},m.prototype._put=function(e,a,t,r){void 0!==a&&null!==a||(a="");var c=this._store[this._location].find(e);c.valid?this._store[this._location]=c.update(a):this._store[this._location]=this._store[this._location].insert(e,a),s(r)},m.prototype._get=function(e,a,t){var r=this._store[this._location].get(e);if(void 0===r)return s(function(){t(new Error("NotFound"))});!1===a.asBuffer||this._isBuffer(r)||(r=o.from(String(r))),s(function(){t(null,r)})},m.prototype._del=function(e,a,t){this._store[this._location]=this._store[this._location].remove(e),s(t)},m.prototype._batch=function(e,a,t){for(var r,c,n,i=-1,f=e.length,o=this._store[this._location];++i<f;)e[i]&&(r=this._isBuffer(e[i].key)?e[i].key:String(e[i].key),n=o.find(r),"put"===e[i].type?(c=this._isBuffer(e[i].value)?e[i].value:String(e[i].value),o=n.valid?n.update(c):o.insert(r,c)):o=n.remove());this._store[this._location]=o,s(t)},m.prototype._iterator=function(e){return new h(this,e)},m.prototype._isBuffer=function(e){return o.isBuffer(e)},m.destroy=function(e,a){var t="$"+e;t in d&&delete d[t],s(a)},e.exports=m.default=m},function(e,a){e.exports={defaultOptions:{createIfMissing:!0,errorIfExists:!1,keyEncoding:"utf8",valueEncoding:"utf8",compression:!0},getOptions:function(e){return"string"==typeof e&&(e={valueEncoding:e}),"object"!=typeof e&&(e={}),e},dispatchError:function(e,a,t){"function"==typeof t?t(a):e.emit("error",a)},isDefined:function(e){return void 0!==e}}},function(e,a,t){var r=e.exports.all=[{errno:-2,code:"ENOENT",description:"no such file or directory"},{errno:-1,code:"UNKNOWN",description:"unknown error"},{errno:0,code:"OK",description:"success"},{errno:1,code:"EOF",description:"end of file"},{errno:2,code:"EADDRINFO",description:"getaddrinfo error"},{errno:3,code:"EACCES",description:"permission denied"},{errno:4,code:"EAGAIN",description:"resource temporarily unavailable"},{errno:5,code:"EADDRINUSE",description:"address already in use"},{errno:6,code:"EADDRNOTAVAIL",description:"address not available"},{errno:7,code:"EAFNOSUPPORT",description:"address family not supported"},{errno:8,code:"EALREADY",description:"connection already in progress"},{errno:9,code:"EBADF",description:"bad file descriptor"},{errno:10,code:"EBUSY",description:"resource busy or locked"},{errno:11,code:"ECONNABORTED",description:"software caused connection abort"},{errno:12,code:"ECONNREFUSED",description:"connection refused"},{errno:13,code:"ECONNRESET",description:"connection reset by peer"},{errno:14,code:"EDESTADDRREQ",description:"destination address required"},{errno:15,code:"EFAULT",description:"bad address in system call argument"},{errno:16,code:"EHOSTUNREACH",description:"host is unreachable"},{errno:17,code:"EINTR",description:"interrupted system call"},{errno:18,code:"EINVAL",description:"invalid argument"},{errno:19,code:"EISCONN",description:"socket is already connected"},{errno:20,code:"EMFILE",description:"too many open files"},{errno:21,code:"EMSGSIZE",description:"message too long"},{errno:22,code:"ENETDOWN",description:"network is down"},{errno:23,code:"ENETUNREACH",description:"network is unreachable"},{errno:24,code:"ENFILE",description:"file table overflow"},{errno:25,code:"ENOBUFS",description:"no buffer space available"},{errno:26,code:"ENOMEM",description:"not enough memory"},{errno:27,code:"ENOTDIR",description:"not a directory"},{errno:28,code:"EISDIR",description:"illegal operation on a directory"},{errno:29,code:"ENONET",description:"machine is not on the network"},{errno:31,code:"ENOTCONN",description:"socket is not connected"},{errno:32,code:"ENOTSOCK",description:"socket operation on non-socket"},{errno:33,code:"ENOTSUP",description:"operation not supported on socket"},{errno:34,code:"ENOENT",description:"no such file or directory"},{errno:35,code:"ENOSYS",description:"function not implemented"},{errno:36,code:"EPIPE",description:"broken pipe"},{errno:37,code:"EPROTO",description:"protocol error"},{errno:38,code:"EPROTONOSUPPORT",description:"protocol not supported"},{errno:39,code:"EPROTOTYPE",description:"protocol wrong type for socket"},{errno:40,code:"ETIMEDOUT",description:"connection timed out"},{errno:41,code:"ECHARSET",description:"invalid Unicode character"},{errno:42,code:"EAIFAMNOSUPPORT",description:"address family for hostname not supported"},{errno:44,code:"EAISERVICE",description:"servname not supported for ai_socktype"},{errno:45,code:"EAISOCKTYPE",description:"ai_socktype not supported"},{errno:46,code:"ESHUTDOWN",description:"cannot send after transport endpoint shutdown"},{errno:47,code:"EEXIST",description:"file already exists"},{errno:48,code:"ESRCH",description:"no such process"},{errno:49,code:"ENAMETOOLONG",description:"name too long"},{errno:50,code:"EPERM",description:"operation not permitted"},{errno:51,code:"ELOOP",description:"too many symbolic links encountered"},{errno:52,code:"EXDEV",description:"cross-device link not permitted"},{errno:53,code:"ENOTEMPTY",description:"directory not empty"},{errno:54,code:"ENOSPC",description:"no space left on device"},{errno:55,code:"EIO",description:"i/o error"},{errno:56,code:"EROFS",description:"read-only file system"},{errno:57,code:"ENODEV",description:"no such device"},{errno:58,code:"ESPIPE",description:"invalid seek"},{errno:59,code:"ECANCELED",description:"operation canceled"}];e.exports.errno={},e.exports.code={},r.forEach(function(a){e.exports.errno[a.errno]=a,e.exports.code[a.code]=a}),e.exports.custom=t(926)(e.exports),e.exports.create=e.exports.custom.createError},function(e,a,t){e.exports=i;var r=t(64),c=t(17);function n(e,a){this.afterTransform=function(e,t){return function(e,a,t){var r=e._transformState;r.transforming=!1;var n=r.writecb;if(!n)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,c.isNullOrUndefined(t)||e.push(t);n&&n(a);var i=e._readableState;i.reading=!1,(i.needReadable||i.length<i.highWaterMark)&&e._read(i.highWaterMark)}(a,e,t)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null}function i(e){if(!(this instanceof i))return new i(e);r.call(this,e),this._transformState=new n(e,this);var a=this;this._readableState.needReadable=!0,this._readableState.sync=!1,this.once("prefinish",function(){c.isFunction(this._flush)?this._flush(function(e){f(a,e)}):f(a)})}function f(e,a){if(a)return e.emit("error",a);var t=e._writableState,r=e._transformState;if(t.length)throw new Error("calling transform done when ws.length != 0");if(r.transforming)throw new Error("calling transform done when still transforming");return e.push(null)}c.inherits=t(0),c.inherits(i,r),i.prototype.push=function(e,a){return this._transformState.needTransform=!1,r.prototype.push.call(this,e,a)},i.prototype._transform=function(e,a,t){throw new Error("not implemented")},i.prototype._write=function(e,a,t){var r=this._transformState;if(r.writecb=t,r.writechunk=e,r.writeencoding=a,!r.transforming){var c=this._readableState;(r.needTransform||c.needReadable||c.length<c.highWaterMark)&&this._read(c.highWaterMark)}},i.prototype._read=function(e){var a=this._transformState;c.isNull(a.writechunk)||!a.writecb||a.transforming?a.needTransform=!0:(a.transforming=!0,this._transform(a.writechunk,a.writeencoding,a.afterTransform))}},function(e,a,t){e.exports=f;var r=t(24).Buffer;f.WritableState=i;var c=t(17);c.inherits=t(0);var n=t(6);function i(e,a){var r=t(64),c=(e=e||{}).highWaterMark,n=e.objectMode?16:16384;this.highWaterMark=c||0===c?c:n,this.objectMode=!!e.objectMode,a instanceof r&&(this.objectMode=this.objectMode||!!e.writableObjectMode),this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var i=!1===e.decodeStrings;this.decodeStrings=!i,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(e){!function(e,a){var t=e._writableState,r=t.sync,c=t.writecb;if(function(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}(t),a)!function(e,a,t,r,c){t?process.nextTick(function(){a.pendingcb--,c(r)}):(a.pendingcb--,c(r));e._writableState.errorEmitted=!0,e.emit("error",r)}(e,t,r,a,c);else{var n=b(e,t);n||t.corked||t.bufferProcessing||!t.buffer.length||s(e,t),r?process.nextTick(function(){d(e,t,n,c)}):d(e,t,n,c)}}(a,e)},this.writecb=null,this.writelen=0,this.buffer=[],this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1}function f(e){var a=t(64);if(!(this instanceof f||this instanceof a))return new f(e);this._writableState=new i(e,this),this.writable=!0,n.call(this)}function o(e,a,t,r,c,n,i){a.writelen=r,a.writecb=i,a.writing=!0,a.sync=!0,t?e._writev(c,a.onwrite):e._write(c,n,a.onwrite),a.sync=!1}function d(e,a,t,r){t||function(e,a){0===a.length&&a.needDrain&&(a.needDrain=!1,e.emit("drain"))}(e,a),a.pendingcb--,r(),l(e,a)}function s(e,a){if(a.bufferProcessing=!0,e._writev&&a.buffer.length>1){for(var t=[],r=0;r<a.buffer.length;r++)t.push(a.buffer[r].callback);a.pendingcb++,o(e,a,!0,a.length,a.buffer,"",function(e){for(var r=0;r<t.length;r++)a.pendingcb--,t[r](e)}),a.buffer=[]}else{for(r=0;r<a.buffer.length;r++){var c=a.buffer[r],n=c.chunk,i=c.encoding,f=c.callback,d=a.objectMode?1:n.length;if(o(e,a,!1,d,n,i,f),a.writing){r++;break}}r<a.buffer.length?a.buffer=a.buffer.slice(r):a.buffer.length=0}a.bufferProcessing=!1}function b(e,a){return a.ending&&0===a.length&&!a.finished&&!a.writing}function u(e,a){a.prefinished||(a.prefinished=!0,e.emit("prefinish"))}function l(e,a){var t=b(0,a);return t&&(0===a.pendingcb?(u(e,a),a.finished=!0,e.emit("finish")):u(e,a)),t}c.inherits(f,n),f.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))},f.prototype.write=function(e,a,t){var n=this._writableState,i=!1;return c.isFunction(a)&&(t=a,a=null),c.isBuffer(e)?a="buffer":a||(a=n.defaultEncoding),c.isFunction(t)||(t=function(){}),n.ended?function(e,a,t){var r=new Error("write after end");e.emit("error",r),process.nextTick(function(){t(r)})}(this,0,t):function(e,a,t,r){var n=!0;if(!(c.isBuffer(t)||c.isString(t)||c.isNullOrUndefined(t)||a.objectMode)){var i=new TypeError("Invalid non-string/buffer chunk");e.emit("error",i),process.nextTick(function(){r(i)}),n=!1}return n}(this,n,e,t)&&(n.pendingcb++,i=function(e,a,t,n,i){t=function(e,a,t){return!e.objectMode&&!1!==e.decodeStrings&&c.isString(a)&&(a=new r(a,t)),a}(a,t,n),c.isBuffer(t)&&(n="buffer");var f=a.objectMode?1:t.length;a.length+=f;var d=a.length<a.highWaterMark;d||(a.needDrain=!0);a.writing||a.corked?a.buffer.push(new function(e,a,t){this.chunk=e,this.encoding=a,this.callback=t}(t,n,i)):o(e,a,!1,f,t,n,i);return d}(this,n,e,a,t)),i},f.prototype.cork=function(){this._writableState.corked++},f.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,e.writing||e.corked||e.finished||e.bufferProcessing||!e.buffer.length||s(this,e))},f.prototype._write=function(e,a,t){t(new Error("not implemented"))},f.prototype._writev=null,f.prototype.end=function(e,a,t){var r=this._writableState;c.isFunction(e)?(t=e,e=null,a=null):c.isFunction(a)&&(t=a,a=null),c.isNullOrUndefined(e)||this.write(e,a),r.corked&&(r.corked=1,this.uncork()),r.ending||r.finished||function(e,a,t){a.ending=!0,l(e,a),t&&(a.finished?process.nextTick(t):e.once("finish",t));a.ended=!0}(this,r,t)}},function(e,a,t){e.exports=b;var r=t(178),c=t(24).Buffer;b.ReadableState=s;var n=t(5).EventEmitter;n.listenerCount||(n.listenerCount=function(e,a){return e.listeners(a).length});var i,f=t(6),o=t(17);o.inherits=t(0);var d=t(1);function s(e,a){var r=t(64),c=(e=e||{}).highWaterMark,n=e.objectMode?16:16384;this.highWaterMark=c||0===c?c:n,this.highWaterMark=~~this.highWaterMark,this.buffer=[],this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.objectMode=!!e.objectMode,a instanceof r&&(this.objectMode=this.objectMode||!!e.readableObjectMode),this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(i||(i=t(63).StringDecoder),this.decoder=new i(e.encoding),this.encoding=e.encoding)}function b(e){t(64);if(!(this instanceof b))return new b(e);this._readableState=new s(e,this),this.readable=!0,f.call(this)}function u(e,a,t,r,c){var n=function(e,a){var t=null;o.isBuffer(a)||o.isString(a)||o.isNullOrUndefined(a)||e.objectMode||(t=new TypeError("Invalid non-string/buffer chunk"));return t}(a,t);if(n)e.emit("error",n);else if(o.isNullOrUndefined(t))a.reading=!1,a.ended||function(e,a){if(a.decoder&&!a.ended){var t=a.decoder.end();t&&t.length&&(a.buffer.push(t),a.length+=a.objectMode?1:t.length)}a.ended=!0,h(e)}(e,a);else if(a.objectMode||t&&t.length>0)if(a.ended&&!c){var i=new Error("stream.push() after EOF");e.emit("error",i)}else if(a.endEmitted&&c){i=new Error("stream.unshift() after end event");e.emit("error",i)}else!a.decoder||c||r||(t=a.decoder.write(t)),c||(a.reading=!1),a.flowing&&0===a.length&&!a.sync?(e.emit("data",t),e.read(0)):(a.length+=a.objectMode?1:t.length,c?a.buffer.unshift(t):a.buffer.push(t),a.needReadable&&h(e)),function(e,a){a.readingMore||(a.readingMore=!0,process.nextTick(function(){!function(e,a){var t=a.length;for(;!a.reading&&!a.flowing&&!a.ended&&a.length<a.highWaterMark&&(d("maybeReadMore read 0"),e.read(0),t!==a.length);)t=a.length;a.readingMore=!1}(e,a)}))}(e,a);else c||(a.reading=!1);return function(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||0===e.length)}(a)}d=d&&d.debuglog?d.debuglog("stream"):function(){},o.inherits(b,f),b.prototype.push=function(e,a){var t=this._readableState;return o.isString(e)&&!t.objectMode&&(a=a||t.defaultEncoding)!==t.encoding&&(e=new c(e,a),a=""),u(this,t,e,a,!1)},b.prototype.unshift=function(e){return u(this,this._readableState,e,"",!0)},b.prototype.setEncoding=function(e){return i||(i=t(63).StringDecoder),this._readableState.decoder=new i(e),this._readableState.encoding=e,this};var l=8388608;function p(e,a){return 0===a.length&&a.ended?0:a.objectMode?0===e?0:1:isNaN(e)||o.isNull(e)?a.flowing&&a.buffer.length?a.buffer[0].length:a.length:e<=0?0:(e>a.highWaterMark&&(a.highWaterMark=function(e){if(e>=l)e=l;else{e--;for(var a=1;a<32;a<<=1)e|=e>>a;e++}return e}(e)),e>a.length?a.ended?a.length:(a.needReadable=!0,0):e)}function h(e){var a=e._readableState;a.needReadable=!1,a.emittedReadable||(d("emitReadable",a.flowing),a.emittedReadable=!0,a.sync?process.nextTick(function(){m(e)}):m(e))}function m(e){d("emit readable"),e.emit("readable"),g(e)}function g(e){var a=e._readableState;if(d("flow",a.flowing),a.flowing)do{var t=e.read()}while(null!==t&&a.flowing)}function v(e,a){var t,r=a.buffer,n=a.length,i=!!a.decoder,f=!!a.objectMode;if(0===r.length)return null;if(0===n)t=null;else if(f)t=r.shift();else if(!e||e>=n)t=i?r.join(""):c.concat(r,n),r.length=0;else{if(e<r[0].length)t=(b=r[0]).slice(0,e),r[0]=b.slice(e);else if(e===r[0].length)t=r.shift();else{t=i?"":new c(e);for(var o=0,d=0,s=r.length;d<s&&o<e;d++){var b=r[0],u=Math.min(e-o,b.length);i?t+=b.slice(0,u):b.copy(t,o,0,u),u<b.length?r[0]=b.slice(u):r.shift(),o+=u}}}return t}function y(e){var a=e._readableState;if(a.length>0)throw new Error("endReadable called on non-empty stream");a.endEmitted||(a.ended=!0,process.nextTick(function(){a.endEmitted||0!==a.length||(a.endEmitted=!0,e.readable=!1,e.emit("end"))}))}b.prototype.read=function(e){d("read",e);var a=this._readableState,t=e;if((!o.isNumber(e)||e>0)&&(a.emittedReadable=!1),0===e&&a.needReadable&&(a.length>=a.highWaterMark||a.ended))return d("read: emitReadable",a.length,a.ended),0===a.length&&a.ended?y(this):h(this),null;if(0===(e=p(e,a))&&a.ended)return 0===a.length&&y(this),null;var r,c=a.needReadable;return d("need readable",c),(0===a.length||a.length-e<a.highWaterMark)&&d("length less than watermark",c=!0),(a.ended||a.reading)&&d("reading or ended",c=!1),c&&(d("do read"),a.reading=!0,a.sync=!0,0===a.length&&(a.needReadable=!0),this._read(a.highWaterMark),a.sync=!1),c&&!a.reading&&(e=p(t,a)),r=e>0?v(e,a):null,o.isNull(r)&&(a.needReadable=!0,e=0),a.length-=e,0!==a.length||a.ended||(a.needReadable=!0),t!==e&&a.ended&&0===a.length&&y(this),o.isNull(r)||this.emit("data",r),r},b.prototype._read=function(e){this.emit("error",new Error("not implemented"))},b.prototype.pipe=function(e,a){var t=this,c=this._readableState;switch(c.pipesCount){case 0:c.pipes=e;break;case 1:c.pipes=[c.pipes,e];break;default:c.pipes.push(e)}c.pipesCount+=1,d("pipe count=%d opts=%j",c.pipesCount,a);var i=(!a||!1!==a.end)&&e!==process.stdout&&e!==process.stderr?o:b;function f(e){d("onunpipe"),e===t&&b()}function o(){d("onend"),e.end()}c.endEmitted?process.nextTick(i):t.once("end",i),e.on("unpipe",f);var s=function(e){return function(){var a=e._readableState;d("pipeOnDrain",a.awaitDrain),a.awaitDrain&&a.awaitDrain--,0===a.awaitDrain&&n.listenerCount(e,"data")&&(a.flowing=!0,g(e))}}(t);function b(){d("cleanup"),e.removeListener("close",p),e.removeListener("finish",h),e.removeListener("drain",s),e.removeListener("error",l),e.removeListener("unpipe",f),t.removeListener("end",o),t.removeListener("end",b),t.removeListener("data",u),!c.awaitDrain||e._writableState&&!e._writableState.needDrain||s()}function u(a){d("ondata"),!1===e.write(a)&&(d("false write response, pause",t._readableState.awaitDrain),t._readableState.awaitDrain++,t.pause())}function l(a){d("onerror",a),m(),e.removeListener("error",l),0===n.listenerCount(e,"error")&&e.emit("error",a)}function p(){e.removeListener("finish",h),m()}function h(){d("onfinish"),e.removeListener("close",p),m()}function m(){d("unpipe"),t.unpipe(e)}return e.on("drain",s),t.on("data",u),e._events&&e._events.error?r(e._events.error)?e._events.error.unshift(l):e._events.error=[l,e._events.error]:e.on("error",l),e.once("close",p),e.once("finish",h),e.emit("pipe",t),c.flowing||(d("pipe resume"),t.resume()),e},b.prototype.unpipe=function(e){var a=this._readableState;if(0===a.pipesCount)return this;if(1===a.pipesCount)return e&&e!==a.pipes?this:(e||(e=a.pipes),a.pipes=null,a.pipesCount=0,a.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var t=a.pipes,r=a.pipesCount;a.pipes=null,a.pipesCount=0,a.flowing=!1;for(var c=0;c<r;c++)t[c].emit("unpipe",this);return this}return-1===(c=function(e,a){for(var t=0,r=e.length;t<r;t++)if(e[t]===a)return t;return-1}(a.pipes,e))?this:(a.pipes.splice(c,1),a.pipesCount-=1,1===a.pipesCount&&(a.pipes=a.pipes[0]),e.emit("unpipe",this),this)},b.prototype.on=function(e,a){var t=f.prototype.on.call(this,e,a);if("data"===e&&!1!==this._readableState.flowing&&this.resume(),"readable"===e&&this.readable){var r=this._readableState;if(!r.readableListening)if(r.readableListening=!0,r.emittedReadable=!1,r.needReadable=!0,r.reading)r.length&&h(this);else{var c=this;process.nextTick(function(){d("readable nexttick read 0"),c.read(0)})}}return t},b.prototype.addListener=b.prototype.on,b.prototype.resume=function(){var e=this._readableState;return e.flowing||(d("resume"),e.flowing=!0,e.reading||(d("resume read 0"),this.read(0)),function(e,a){a.resumeScheduled||(a.resumeScheduled=!0,process.nextTick(function(){!function(e,a){a.resumeScheduled=!1,e.emit("resume"),g(e),a.flowing&&!a.reading&&e.read(0)}(e,a)}))}(this,e)),this},b.prototype.pause=function(){return d("call pause flowing=%j",this._readableState.flowing),!1!==this._readableState.flowing&&(d("pause"),this._readableState.flowing=!1,this.emit("pause")),this},b.prototype.wrap=function(e){var a=this._readableState,t=!1,r=this;for(var c in e.on("end",function(){if(d("wrapped end"),a.decoder&&!a.ended){var e=a.decoder.end();e&&e.length&&r.push(e)}r.push(null)}),e.on("data",function(c){(d("wrapped data"),a.decoder&&(c=a.decoder.write(c)),c&&(a.objectMode||c.length))&&(r.push(c)||(t=!0,e.pause()))}),e)o.isFunction(e[c])&&o.isUndefined(this[c])&&(this[c]=function(a){return function(){return e[a].apply(e,arguments)}}(c));return function(e,a){for(var t=0,r=e.length;t<r;t++)a(e[t],t)}(["error","close","destroy","pause","resume"],function(a){e.on(a,r.emit.bind(r,a))}),r._read=function(a){d("wrapped _read",a),t&&(t=!1,e.resume())},r},b._fromList=v},function(e,a){function t(e){this._db=e,this._operations=[],this._written=!1}t.prototype._serializeKey=function(e){return this._db._serializeKey(e)},t.prototype._serializeValue=function(e){return this._db._serializeValue(e)},t.prototype._checkWritten=function(){if(this._written)throw new Error("write() already called on this batch")},t.prototype.put=function(e,a){this._checkWritten();var t=this._db._checkKey(e,"key",this._db._isBuffer);if(t)throw t;return e=this._serializeKey(e),a=this._serializeValue(a),"function"==typeof this._put?this._put(e,a):this._operations.push({type:"put",key:e,value:a}),this},t.prototype.del=function(e){this._checkWritten();var a=this._db._checkKey(e,"key",this._db._isBuffer);if(a)throw a;return e=this._serializeKey(e),"function"==typeof this._del?this._del(e):this._operations.push({type:"del",key:e}),this},t.prototype.clear=function(){return this._checkWritten(),this._operations=[],"function"==typeof this._clear&&this._clear(),this},t.prototype.write=function(e,a){if(this._checkWritten(),"function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("write() requires a callback argument");return"object"!=typeof e&&(e={}),this._written=!0,"function"==typeof this._write?this._write(a):"function"==typeof this._db._batch?this._db._batch(this._operations,e,a):void process.nextTick(a)},e.exports=t},function(e,a){function t(e){this.db=e,this._ended=!1,this._nexting=!1}t.prototype.next=function(e){var a=this;if("function"!=typeof e)throw new Error("next() requires a callback argument");return a._ended?e(new Error("cannot call next() after end()")):a._nexting?e(new Error("cannot call next() before previous next() has completed")):(a._nexting=!0,"function"==typeof a._next?a._next(function(){a._nexting=!1,e.apply(null,arguments)}):void process.nextTick(function(){a._nexting=!1,e()}))},t.prototype.end=function(e){if("function"!=typeof e)throw new Error("end() requires a callback argument");return this._ended?e(new Error("end() already called on iterator")):(this._ended=!0,"function"==typeof this._end?this._end(e):void process.nextTick(e))},e.exports=t},function(e,a,t){var r=t(39),c=t(356),n=t(355);function i(e){if(!arguments.length||void 0===e)throw new Error("constructor requires at least a location argument");if("string"!=typeof e)throw new Error("constructor requires a location string argument");this.location=e,this.status="new"}i.prototype.open=function(e,a){var t=this,r=this.status;if("function"==typeof e&&(a=e),"function"!=typeof a)throw new Error("open() requires a callback argument");"object"!=typeof e&&(e={}),e.createIfMissing=0!=e.createIfMissing,e.errorIfExists=!!e.errorIfExists,"function"==typeof this._open?(this.status="opening",this._open(e,function(e){if(e)return t.status=r,a(e);t.status="open",a()})):(this.status="open",process.nextTick(a))},i.prototype.close=function(e){var a=this,t=this.status;if("function"!=typeof e)throw new Error("close() requires a callback argument");"function"==typeof this._close?(this.status="closing",this._close(function(r){if(r)return a.status=t,e(r);a.status="closed",e()})):(this.status="closed",process.nextTick(e))},i.prototype.get=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("get() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),a.asBuffer=0!=a.asBuffer,"function"==typeof this._get?this._get(e,a,t):void process.nextTick(function(){t(new Error("NotFound"))}))},i.prototype.put=function(e,a,t,r){var c;if("function"==typeof t&&(r=t),"function"!=typeof r)throw new Error("put() requires a callback argument");return(c=this._checkKey(e,"key"))?r(c):(e=this._serializeKey(e),a=this._serializeValue(a),"object"!=typeof t&&(t={}),"function"==typeof this._put?this._put(e,a,t,r):void process.nextTick(r))},i.prototype.del=function(e,a,t){var r;if("function"==typeof a&&(t=a),"function"!=typeof t)throw new Error("del() requires a callback argument");return(r=this._checkKey(e,"key"))?t(r):(e=this._serializeKey(e),"object"!=typeof a&&(a={}),"function"==typeof this._del?this._del(e,a,t):void process.nextTick(t))},i.prototype.batch=function(e,a,t){if(!arguments.length)return this._chainedBatch();if("function"==typeof a&&(t=a),"function"==typeof e&&(t=e),"function"!=typeof t)throw new Error("batch(array) requires a callback argument");if(!Array.isArray(e))return t(new Error("batch(array) requires an array argument"));a&&"object"==typeof a||(a={});for(var r,c,n=0,i=e.length;n<i;n++)if("object"==typeof(r=e[n])){if(c=this._checkKey(r.type,"type"))return t(c);if(c=this._checkKey(r.key,"key"))return t(c)}if("function"==typeof this._batch)return this._batch(e,a,t);process.nextTick(t)},i.prototype.approximateSize=function(e,a,t){if(null==e||null==a||"function"==typeof e||"function"==typeof a)throw new Error("approximateSize() requires valid `start`, `end` and `callback` arguments");if("function"!=typeof t)throw new Error("approximateSize() requires a callback argument");if(e=this._serializeKey(e),a=this._serializeKey(a),"function"==typeof this._approximateSize)return this._approximateSize(e,a,t);process.nextTick(function(){t(null,0)})},i.prototype._setupIteratorOptions=function(e){var a=this;return e=r(e),["start","end","gt","gte","lt","lte"].forEach(function(t){e[t]&&a._isBuffer(e[t])&&0===e[t].length&&delete e[t]}),e.reverse=!!e.reverse,e.keys=0!=e.keys,e.values=0!=e.values,e.limit="limit"in e?e.limit:-1,e.keyAsBuffer=0!=e.keyAsBuffer,e.valueAsBuffer=0!=e.valueAsBuffer,e},i.prototype.iterator=function(e){return"object"!=typeof e&&(e={}),e=this._setupIteratorOptions(e),"function"==typeof this._iterator?this._iterator(e):new c(this)},i.prototype._chainedBatch=function(){return new n(this)},i.prototype._isBuffer=function(e){return Buffer.isBuffer(e)},i.prototype._serializeKey=function(e){return this._isBuffer(e)?e:String(e)},i.prototype._serializeValue=function(e){return null==e?"":this._isBuffer(e)||process.browser?e:String(e)},i.prototype._checkKey=function(e,a){return null===e||void 0===e?new Error(a+" cannot be `null` or `undefined`"):this._isBuffer(e)&&0===e.length?new Error(a+" cannot be an empty Buffer"):""===String(e)?new Error(a+" cannot be an empty String"):void 0},e.exports=i},function(e,a,t){a.AbstractLevelDOWN=t(357),a.AbstractIterator=t(356),a.AbstractChainedBatch=t(355),a.isLevelDOWN=t(931)},function(e,a){
/*!
  * prr
  * (c) 2013 Rod Vagg <rod@vagg.org>
  * https://github.com/rvagg/prr
  * License: MIT
  */
!function(a,t,r){void 0!==e&&e.exports?e.exports=r():t.prr=r()}(0,this,function(){var e="function"==typeof Object.defineProperty?function(e,a,t){return Object.defineProperty(e,a,t),e}:function(e,a,t){return e[a]=t.value,e};return function(a,t,r,c){var n;if(c=function(e,a){var t="object"==typeof a,r=!t&&"string"==typeof a,c=function(e){return t?!!a[e]:!!r&&a.indexOf(e[0])>-1};return{enumerable:c("enumerable"),configurable:c("configurable"),writable:c("writable"),value:e}}(r,c),"object"==typeof t){for(n in t)Object.hasOwnProperty.call(t,n)&&(c.value=t[n],e(a,n,c));return a}return e(a,t,c)}})},function(e){e.exports={genesisGasLimit:{v:5e3,d:"Gas limit of the Genesis block."},genesisDifficulty:{v:17179869184,d:"Difficulty of the Genesis block."},genesisNonce:{v:"0x0000000000000042",d:"the geneis nonce"},genesisExtraData:{v:"0x11bbe8db4e347b4e8c937c1c8370e4b5ed33adb3db69cbdb7a38e1e50b1b82fa",d:"extra data "},genesisHash:{v:"0xd4e56740f876aef8c010b86a40d5f56745a118d0906a34e69aec8c0db1cb8fa3",d:"genesis hash"},genesisStateRoot:{v:"0xd7f8974fb5ac78d9ac099b9ad5018bedc2ce0a72dad1827a1709da30580f0544",d:"the genesis state root"},minGasLimit:{v:5e3,d:"Minimum the gas limit may ever be."},gasLimitBoundDivisor:{v:1024,d:"The bound divisor of the gas limit, used in update calculations."},minimumDifficulty:{v:131072,d:"The minimum that the difficulty may ever be."},difficultyBoundDivisor:{v:2048,d:"The bound divisor of the difficulty, used in the update calculations."},durationLimit:{v:13,d:"The decision boundary on the blocktime duration used to determine whether difficulty should go up or not."},maximumExtraDataSize:{v:32,d:"Maximum size extra data may be after Genesis."},epochDuration:{v:3e4,d:"Duration between proof-of-work epochs."},stackLimit:{v:1024,d:"Maximum size of VM stack allowed."},callCreateDepth:{v:1024,d:"Maximum depth of call/create stack."},tierStepGas:{v:[0,2,3,5,8,10,20],d:"Once per operation, for a selection of them."},expGas:{v:10,d:"Once per EXP instuction."},expByteGas:{v:10,d:"Times ceil(log256(exponent)) for the EXP instruction."},sha3Gas:{v:30,d:"Once per SHA3 operation."},sha3WordGas:{v:6,d:"Once per word of the SHA3 operation's data."},sloadGas:{v:50,d:"Once per SLOAD operation."},sstoreSetGas:{v:2e4,d:"Once per SSTORE operation if the zeroness changes from zero."},sstoreResetGas:{v:5e3,d:"Once per SSTORE operation if the zeroness does not change from zero."},sstoreRefundGas:{v:15e3,d:"Once per SSTORE operation if the zeroness changes to zero."},jumpdestGas:{v:1,d:"Refunded gas, once per SSTORE operation if the zeroness changes to zero."},logGas:{v:375,d:"Per LOG* operation."},logDataGas:{v:8,d:"Per byte in a LOG* operation's data."},logTopicGas:{v:375,d:"Multiplied by the * of the LOG*, per LOG transaction. e.g. LOG0 incurs 0 * c_txLogTopicGas, LOG4 incurs 4 * c_txLogTopicGas."},createGas:{v:32e3,d:"Once per CREATE operation & contract-creation transaction."},callGas:{v:40,d:"Once per CALL operation & message call transaction."},callStipend:{v:2300,d:"Free gas given at beginning of call."},callValueTransferGas:{v:9e3,d:"Paid for CALL when the value transfor is non-zero."},callNewAccountGas:{v:25e3,d:"Paid for CALL when the destination address didn't exist prior."},suicideRefundGas:{v:24e3,d:"Refunded following a suicide operation."},memoryGas:{v:3,d:"Times the address of the (highest referenced byte in memory + 1). NOTE: referencing happens on read, write and in instructions such as RETURN and CALL."},quadCoeffDiv:{v:512,d:"Divisor for the quadratic particle of the memory cost equation."},createDataGas:{v:200,d:""},txGas:{v:21e3,d:"Per transaction. NOTE: Not payable on data of calls between transactions."},txCreation:{v:32e3,d:"the cost of creating a contract via tx"},txDataZeroGas:{v:4,d:"Per byte of data attached to a transaction that equals zero. NOTE: Not payable on data of calls between transactions."},txDataNonZeroGas:{v:68,d:"Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions."},copyGas:{v:3,d:"Multiplied by the number of 32-byte words that are copied (round up) for any *COPY operation and added."},ecrecoverGas:{v:3e3,d:""},sha256Gas:{v:60,d:""},sha256WordGas:{v:12,d:""},ripemd160Gas:{v:600,d:""},ripemd160WordGas:{v:120,d:""},identityGas:{v:15,d:""},identityWordGas:{v:3,d:""},minerReward:{v:"5000000000000000000",d:"the amount a miner get rewarded for mining a block"},ommerReward:{v:"625000000000000000",d:"The amount of wei a miner of an uncle block gets for being inculded in the blockchain"},niblingReward:{v:"156250000000000000",d:"the amount a miner gets for inculding a uncle"},homeSteadForkNumber:{v:115e4,d:"the block that the Homestead fork started at"},homesteadRepriceForkNumber:{v:2463e3,d:"the block that the Homestead Reprice (EIP150) fork started at"},timebombPeriod:{v:1e5,d:"Exponential difficulty timebomb period"},freeBlockPeriod:{v:2}}},function(e,a,t){"use strict";var r=t(3),c=t(360),n=r.BN,i=new n("7fffffffffffffffffffffffffffffff5d576e7357a4501ddfe92f46681b20a0",16),f=function(){function e(a){!function(e,a){if(!(e instanceof a))throw new TypeError("Cannot call a class as a function")}(this,e),a=a||{};var t=[{name:"nonce",length:32,allowLess:!0,default:new Buffer([])},{name:"gasPrice",length:32,allowLess:!0,default:new Buffer([])},{name:"gasLimit",alias:"gas",length:32,allowLess:!0,default:new Buffer([])},{name:"to",allowZero:!0,length:20,default:new Buffer([])},{name:"value",length:32,allowLess:!0,default:new Buffer([])},{name:"data",alias:"input",allowZero:!0,default:new Buffer([])},{name:"v",allowZero:!0,default:new Buffer([28])},{name:"r",length:32,allowZero:!0,allowLess:!0,default:new Buffer([])},{name:"s",length:32,allowZero:!0,allowLess:!0,default:new Buffer([])}];r.defineProperties(this,t,a),Object.defineProperty(this,"from",{enumerable:!0,configurable:!0,get:this.getSenderAddress.bind(this)});var c=r.bufferToInt(this.v),n=Math.floor((c-35)/2);n<0&&(n=0),this._chainId=n||a.chainId||0,this._homestead=!0}return e.prototype.toCreationAddress=function(){return""===this.to.toString("hex")},e.prototype.hash=function(e){void 0===e&&(e=!0);var a=void 0;if(e)a=this.raw;else if(this._chainId>0){var t=this.raw.slice();this.v=this._chainId,this.r=0,this.s=0,a=this.raw,this.raw=t}else a=this.raw.slice(0,6);return r.rlphash(a)},e.prototype.getChainId=function(){return this._chainId},e.prototype.getSenderAddress=function(){if(this._from)return this._from;var e=this.getSenderPublicKey();return this._from=r.publicToAddress(e),this._from},e.prototype.getSenderPublicKey=function(){if(!(this._senderPubKey&&this._senderPubKey.length||this.verifySignature()))throw new Error("Invalid Signature");return this._senderPubKey},e.prototype.verifySignature=function(){var e=this.hash(!1);if(this._homestead&&1===new n(this.s).cmp(i))return!1;try{var a=r.bufferToInt(this.v);this._chainId>0&&(a-=2*this._chainId+8),this._senderPubKey=r.ecrecover(e,a,this.r,this.s)}catch(e){return!1}return!!this._senderPubKey},e.prototype.sign=function(e){var a=this.hash(!1),t=r.ecsign(a,e);this._chainId>0&&(t.v+=2*this._chainId+8),Object.assign(this,t)},e.prototype.getDataFee=function(){for(var e=this.raw[5],a=new n(0),t=0;t<e.length;t++)0===e[t]?a.iaddn(c.txDataZeroGas.v):a.iaddn(c.txDataNonZeroGas.v);return a},e.prototype.getBaseFee=function(){var e=this.getDataFee().iaddn(c.txGas.v);return this._homestead&&this.toCreationAddress()&&e.iaddn(c.txCreation.v),e},e.prototype.getUpfrontCost=function(){return new n(this.gasLimit).imul(new n(this.gasPrice)).iadd(new n(this.value))},e.prototype.validate=function(e){var a=[];return this.verifySignature()||a.push("Invalid Signature"),this.getBaseFee().cmp(new n(this.gasLimit))>0&&a.push(["gas limit is too low. Need at least "+this.getBaseFee()]),void 0===e||!1===e?0===a.length:a.join(" ")},e}();e.exports=f},function(e,a,t){const r=t(180),c=t(91),n=t(11),i=t(52),f=t(9),o=t(30);a.MAX_INTEGER=new f("ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",16),a.TWO_POW256=new f("10000000000000000000000000000000000000000000000000000000000000000",16),a.SHA3_NULL_S="c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",a.SHA3_NULL=new Buffer(a.SHA3_NULL_S,"hex"),a.SHA3_RLP_ARRAY_S="1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",a.SHA3_RLP_ARRAY=new Buffer(a.SHA3_RLP_ARRAY_S,"hex"),a.SHA3_RLP_S="56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",a.SHA3_RLP=new Buffer(a.SHA3_RLP_S,"hex"),a.BN=f,a.rlp=i,a.secp256k1=c,a.zeros=function(e){var a=new Buffer(e);return a.fill(0),a},a.setLengthLeft=a.setLength=function(e,t,r){var c=a.zeros(t);return e=a.toBuffer(e),r?e.length<t?(e.copy(c),c):e.slice(0,t):e.length<t?(e.copy(c,t-e.length),c):e.slice(-t)},a.setLengthRight=function(e,t){return a.setLength(e,t,!0)},a.unpad=a.stripZeros=function(e){for(var t=(e=a.stripHexPrefix(e))[0];e.length>0&&"0"===t.toString();)t=(e=e.slice(1))[0];return e},a.toBuffer=function(e){if(!Buffer.isBuffer(e))if(Array.isArray(e))e=new Buffer(e);else if("string"==typeof e)e=a.isHexPrefixed(e)?new Buffer(a.padToEven(a.stripHexPrefix(e)),"hex"):new Buffer(e);else if("number"==typeof e)e=a.intToBuffer(e);else if(null===e||void 0===e)e=new Buffer([]);else{if(!e.toArray)throw new Error("invalid type");e=new Buffer(e.toArray())}return e},a.intToHex=function(e){n(e%1==0,"number is not a integer"),n(e>=0,"number must be positive");var a=e.toString(16);return a.length%2&&(a="0"+a),"0x"+a},a.intToBuffer=function(e){var t=a.intToHex(e);return new Buffer(t.slice(2),"hex")},a.bufferToInt=function(e){return parseInt(a.bufferToHex(e),16)},a.bufferToHex=function(e){return 0===(e=a.toBuffer(e)).length?0:"0x"+e.toString("hex")},a.fromSigned=function(e){return new f(e).fromTwos(256)},a.toUnsigned=function(e){return new Buffer(e.toTwos(256).toArray())},a.sha3=function(e,t){e=a.toBuffer(e),t||(t=256);var c=new r(t);return e&&c.update(e),new Buffer(c.digest("hex"),"hex")},a.sha256=function(e){return e=a.toBuffer(e),o("sha256").update(e).digest()},a.ripemd160=function(e,t){e=a.toBuffer(e);var r=o("rmd160").update(e).digest();return!0===t?a.setLength(r,32):r},a.rlphash=function(e){return a.sha3(i.encode(e))},a.isValidPrivate=function(e){return c.privateKeyVerify(e)},a.isValidPublic=function(e,a){return 64===e.length?c.publicKeyVerify(Buffer.concat([new Buffer([4]),e])):!!a&&c.publicKeyVerify(e)},a.pubToAddress=a.publicToAddress=function(e,t){return e=a.toBuffer(e),t&&64!==e.length&&(e=c.publicKeyConvert(e,!1).slice(1)),n(64===e.length),a.sha3(e).slice(-20)};var d=a.privateToPublic=function(e){return e=a.toBuffer(e),c.publicKeyCreate(e,!1).slice(1)};a.importPublic=function(e){return 64!==(e=a.toBuffer(e)).length&&(e=c.publicKeyConvert(e,!1).slice(1)),e},a.ecsign=function(e,a){var t=c.sign(e,a),r={};return r.r=t.signature.slice(0,32),r.s=t.signature.slice(32,64),r.v=t.recovery+27,r},a.ecrecover=function(e,t,r,n){var i=Buffer.concat([a.setLength(r,32),a.setLength(n,32)],64),f=a.bufferToInt(t)-27;if(0!==f&&1!==f)throw new Error("Invalid signature v value");var o=c.recover(e,i,f);return c.publicKeyConvert(o,!1).slice(1)},a.toRpcSig=function(e,t,r){return a.bufferToHex(Buffer.concat([t,r,a.toBuffer(e-27)]))},a.fromRpcSig=function(e){var t=(e=a.toBuffer(e))[64];return t<27&&(t+=27),{v:t,r:e.slice(0,32),s:e.slice(32,64)}},a.privateToAddress=function(e){return a.publicToAddress(d(e))},a.isValidAddress=function(e){return/^0x[0-9a-fA-F]{40}$/i.test(e)},a.toChecksumAddress=function(e){e=a.stripHexPrefix(e).toLowerCase();for(var t=a.sha3(e).toString("hex"),r="0x",c=0;c<e.length;c++)parseInt(t[c],16)>=8?r+=e[c].toUpperCase():r+=e[c];return r},a.isValidChecksumAddress=function(e){return a.isValidAddress(e)&&a.toChecksumAddress(e)===e},a.generateAddress=function(e,t){return e=a.toBuffer(e),t=(t=new f(t)).isZero()?null:new Buffer(t.toArray()),a.rlphash([e,t]).slice(-20)},a.isPrecompiled=function(e){var t=a.unpad(e);return 1===t.length&&t[0]>0&&t[0]<5},a.isHexPrefixed=function(e){return"0x"===e.slice(0,2)},a.stripHexPrefix=function(e){return"string"!=typeof e?e:a.isHexPrefixed(e)?e.slice(2):e},a.addHexPrefix=function(e){return"string"!=typeof e?e:a.isHexPrefixed(e)?e:"0x"+e},a.padToEven=function(e){return e.length%2&&(e="0"+e),e},a.baToJSON=function(e){if(Buffer.isBuffer(e))return"0x"+e.toString("hex");if(e instanceof Array){for(var t=[],r=0;r<e.length;r++)t.push(a.baToJSON(e[r]));return t}},a.defineProperties=function(e,t,r){if(e.raw=[],e._fields=[],e.toJSON=function(t){if(t){var r={};return e._fields.forEach(function(a){r[a]="0x"+e[a].toString("hex")}),r}return a.baToJSON(this.raw)},e.serialize=function(){return i.encode(e.raw)},t.forEach(function(t,r){function c(){return e.raw[r]}function i(c){"00"!==(c=a.toBuffer(c)).toString("hex")||t.allowZero||(c=new Buffer([])),t.allowLess&&t.length?(c=a.stripZeros(c),n(t.length>=c.length,"The field "+t.name+" must not have more "+t.length+" bytes")):t.allowZero&&0===c.length||!t.length||n(t.length===c.length,"The field "+t.name+" must have byte length of "+t.length),e.raw[r]=c}e._fields.push(t.name),Object.defineProperty(e,t.name,{enumerable:!0,configurable:!0,get:c,set:i}),t.default&&(e[t.name]=t.default),t.alias&&Object.defineProperty(e,t.alias,{enumerable:!1,configurable:!0,set:i,get:c})}),r)if("string"==typeof r&&(r=new Buffer(a.stripHexPrefix(r),"hex")),Buffer.isBuffer(r)&&(r=i.decode(r)),Array.isArray(r)){if(r.length>e._fields.length)throw new Error("wrong number of fields in data");r.forEach(function(t,r){e[e._fields[r]]=a.toBuffer(t)})}else{if("object"!=typeof r)throw new Error("invalid data");for(var c in r)-1!==e._fields.indexOf(c)&&(e[c]=r[c])}}},function(e,a,t){const r=t(946),c=t(39);e.exports=function(e){return c({id:r(),jsonrpc:"2.0",params:[]},e)}},function(e,a,t){const r=t(5).EventEmitter,c=t(1).inherits;function n(){r.call(this),this.isLocked=!0}e.exports=n,c(n,r),n.prototype.go=function(){this.isLocked=!1,this.emit("unlock")},n.prototype.stop=function(){this.isLocked=!0,this.emit("lock")},n.prototype.await=function(e){const a=this;a.isLocked?a.once("unlock",e):setTimeout(e)}},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0});var r=n(t(953)),c=n(t(366));function n(e){return e&&e.__esModule?e:{default:e}}a.default=(0,c.default)(r.default,1),e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e,a){return function(t,r,c){return e(t,a,r,c)}},e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e,a){a|=0;for(var t=Math.max(e.length-a,0),r=Array(t),c=0;c<t;c++)r[c]=e[a+c];return r},e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(){if(null===e)throw new Error("Callback was already called.");var a=e;e=null,a.apply(this,arguments)}},e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(){if(null!==e){var a=e;e=null,a.apply(this,arguments)}}},e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default=function(e){return function(a,t,o){if(o=(0,c.default)(o||r.default),e<=0||!a)return o(null);var d=(0,n.default)(a),s=!1,b=0,u=!1;function l(e,a){if(b-=1,e)s=!0,o(e);else{if(a===f.default||s&&b<=0)return s=!0,o(null);u||p()}}function p(){for(u=!0;b<e&&!s;){var a=d();if(null===a)return s=!0,void(b<=0&&o(null));b+=1,t(a.value,a.key,(0,i.default)(l))}u=!1}p()}};var r=o(t(182)),c=o(t(369)),n=o(t(976)),i=o(t(368)),f=o(t(371));function o(e){return e&&e.__esModule?e:{default:e}}e.exports=a.default},function(e,a,t){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.default={},e.exports=a.default},function(e,a){var t=9007199254740991;e.exports=function(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=t}},function(e,a){e.exports=function(e){var a=typeof e;return null!=e&&("object"==a||"function"==a)}},function(e,a){var t="object"==typeof global&&global&&global.Object===Object&&global;e.exports=t},function(e,a,t){var r=t(374),c="object"==typeof self&&self&&self.Object===Object&&self,n=r||c||Function("return this")();e.exports=n},function(e,a,t){var r=t(375).Symbol;e.exports=r},function(e,a,t){var r=t(378);e.exports=function(e){return"string"!=typeof e?e:r(e)?e.slice(2):e}},function(e,a){e.exports=function(e){if("string"!=typeof e)throw new Error("[is-hex-prefixed] value must be type 'string', is currently type "+typeof e+", while checking isHexPrefixed.");return"0x"===e.slice(0,2)}},function(e,a,t){"use strict";var r=t(378),c=t(377);function n(e){var a=e;if("string"!=typeof a)throw new Error("[ethjs-util] while padding to even, value must be string, is currently "+typeof a+", while padToEven.");return a.length%2&&(a="0"+a),a}function i(e){return"0x"+n(e.toString(16))}e.exports={arrayContainsArray:function(e,a,t){if(!0!==Array.isArray(e))throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '"+typeof e+"'");if(!0!==Array.isArray(a))throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '"+typeof a+"'");return a[Boolean(t)?"some":"every"](function(a){return e.indexOf(a)>=0})},intToBuffer:function(e){var a=i(e);return new Buffer(a.slice(2),"hex")},getBinarySize:function(e){if("string"!=typeof e)throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '"+typeof e+"'.");return Buffer.byteLength(e,"utf8")},isHexPrefixed:r,stripHexPrefix:c,padToEven:n,intToHex:i,fromAscii:function(e){for(var a="",t=0;t<e.length;t++){var r=e.charCodeAt(t).toString(16);a+=r.length<2?"0"+r:r}return"0x"+a},fromUtf8:function(e){return"0x"+n(new Buffer(e,"utf8").toString("hex")).replace(/^0+|0+$/g,"")},toAscii:function(e){var a="",t=0,r=e.length;for("0x"===e.substring(0,2)&&(t=2);t<r;t+=2){var c=parseInt(e.substr(t,2),16);a+=String.fromCharCode(c)}return a},toUtf8:function(e){return new Buffer(n(c(e).replace(/^0+|0+$/g,"")),"hex").toString("utf8")},getKeys:function(e,a,t){if(!Array.isArray(e))throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '"+typeof e+"'");if("string"!=typeof a)throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '"+typeof a+"'.");for(var r=[],c=0;c<e.length;c++){var n=e[c][a];if(t&&!n)n="";else if("string"!=typeof n)throw new Error("invalid abi");r.push(n)}return r},isHexString:function(e,a){return!("string"!=typeof e||!e.match(/^0x[0-9A-Fa-f]*$/)||a&&e.length!==2+2*a)}}},function(e,a,t){"use strict";var r=t(37),c=t(90),n=t(46),i=r.rotr64_hi,f=r.rotr64_lo,o=r.shr64_hi,d=r.shr64_lo,s=r.sum64,b=r.sum64_hi,u=r.sum64_lo,l=r.sum64_4_hi,p=r.sum64_4_lo,h=r.sum64_5_hi,m=r.sum64_5_lo,g=c.BlockHash,v=[1116352408,3609767458,1899447441,602891725,3049323471,3964484399,3921009573,2173295548,961987163,4081628472,1508970993,3053834265,2453635748,2937671579,2870763221,3664609560,3624381080,2734883394,310598401,1164996542,607225278,1323610764,1426881987,3590304994,1925078388,4068182383,2162078206,991336113,2614888103,633803317,3248222580,3479774868,3835390401,2666613458,4022224774,944711139,264347078,2341262773,604807628,2007800933,770255983,1495990901,1249150122,1856431235,1555081692,3175218132,1996064986,2198950837,2554220882,3999719339,2821834349,766784016,2952996808,2566594879,3210313671,3203337956,3336571891,1034457026,3584528711,2466948901,113926993,3758326383,338241895,168717936,666307205,1188179964,773529912,1546045734,1294757372,1522805485,1396182291,2643833823,1695183700,2343527390,1986661051,1014477480,2177026350,1206759142,2456956037,344077627,2730485921,1290863460,2820302411,3158454273,3259730800,3505952657,3345764771,106217008,3516065817,3606008344,3600352804,1432725776,4094571909,1467031594,275423344,851169720,430227734,3100823752,506948616,1363258195,659060556,3750685593,883997877,3785050280,958139571,3318307427,1322822218,3812723403,1537002063,2003034995,1747873779,3602036899,1955562222,1575990012,2024104815,1125592928,2227730452,2716904306,2361852424,442776044,2428436474,593698344,2756734187,3733110249,3204031479,2999351573,3329325298,3815920427,3391569614,3928383900,3515267271,566280711,3940187606,3454069534,4118630271,4000239992,116418474,1914138554,174292421,2731055270,289380356,3203993006,460393269,320620315,685471733,587496836,852142971,1086792851,1017036298,365543100,1126000580,2618297676,1288033470,3409855158,1501505948,4234509866,1607167915,987167468,1816402316,1246189591];function y(){if(!(this instanceof y))return new y;g.call(this),this.h=[1779033703,4089235720,3144134277,2227873595,1013904242,4271175723,2773480762,1595750129,1359893119,2917565137,2600822924,725511199,528734635,4215389547,1541459225,327033209],this.k=v,this.W=new Array(160)}function _(e,a,t,r,c){var n=e&t^~e&c;return n<0&&(n+=4294967296),n}function w(e,a,t,r,c,n){var i=a&r^~a&n;return i<0&&(i+=4294967296),i}function A(e,a,t,r,c){var n=e&t^e&c^t&c;return n<0&&(n+=4294967296),n}function k(e,a,t,r,c,n){var i=a&r^a&n^r&n;return i<0&&(i+=4294967296),i}function x(e,a){var t=i(e,a,28)^i(a,e,2)^i(a,e,7);return t<0&&(t+=4294967296),t}function E(e,a){var t=f(e,a,28)^f(a,e,2)^f(a,e,7);return t<0&&(t+=4294967296),t}function S(e,a){var t=i(e,a,14)^i(e,a,18)^i(a,e,9);return t<0&&(t+=4294967296),t}function T(e,a){var t=f(e,a,14)^f(e,a,18)^f(a,e,9);return t<0&&(t+=4294967296),t}function j(e,a){var t=i(e,a,1)^i(e,a,8)^o(e,a,7);return t<0&&(t+=4294967296),t}function C(e,a){var t=f(e,a,1)^f(e,a,8)^d(e,a,7);return t<0&&(t+=4294967296),t}function R(e,a){var t=i(e,a,19)^i(a,e,29)^o(e,a,6);return t<0&&(t+=4294967296),t}function O(e,a){var t=f(e,a,19)^f(a,e,29)^d(e,a,6);return t<0&&(t+=4294967296),t}r.inherits(y,g),e.exports=y,y.blockSize=1024,y.outSize=512,y.hmacStrength=192,y.padLength=128,y.prototype._prepareBlock=function(e,a){for(var t=this.W,r=0;r<32;r++)t[r]=e[a+r];for(;r<t.length;r+=2){var c=R(t[r-4],t[r-3]),n=O(t[r-4],t[r-3]),i=t[r-14],f=t[r-13],o=j(t[r-30],t[r-29]),d=C(t[r-30],t[r-29]),s=t[r-32],b=t[r-31];t[r]=l(c,n,i,f,o,d,s,b),t[r+1]=p(c,n,i,f,o,d,s,b)}},y.prototype._update=function(e,a){this._prepareBlock(e,a);var t=this.W,r=this.h[0],c=this.h[1],i=this.h[2],f=this.h[3],o=this.h[4],d=this.h[5],l=this.h[6],p=this.h[7],g=this.h[8],v=this.h[9],y=this.h[10],j=this.h[11],C=this.h[12],R=this.h[13],O=this.h[14],B=this.h[15];n(this.k.length===t.length);for(var M=0;M<t.length;M+=2){var N=O,I=B,P=S(g,v),F=T(g,v),L=_(g,v,y,j,C),D=w(g,v,y,j,C,R),z=this.k[M],q=this.k[M+1],U=t[M],H=t[M+1],V=h(N,I,P,F,L,D,z,q,U,H),G=m(N,I,P,F,L,D,z,q,U,H);N=x(r,c),I=E(r,c),P=A(r,c,i,f,o),F=k(r,c,i,f,o,d);var W=b(N,I,P,F),Y=u(N,I,P,F);O=C,B=R,C=y,R=j,y=g,j=v,g=b(l,p,V,G),v=u(p,p,V,G),l=o,p=d,o=i,d=f,i=r,f=c,r=b(V,G,W,Y),c=u(V,G,W,Y)}s(this.h,0,r,c),s(this.h,2,i,f),s(this.h,4,o,d),s(this.h,6,l,p),s(this.h,8,g,v),s(this.h,10,y,j),s(this.h,12,C,R),s(this.h,14,O,B)},y.prototype._digest=function(e){return"hex"===e?r.toHex32(this.h,"big"):r.split32(this.h,"big")}},function(e,a,t){"use strict";var r=t(37),c=t(90),n=t(382),i=t(46),f=r.sum32,o=r.sum32_4,d=r.sum32_5,s=n.ch32,b=n.maj32,u=n.s0_256,l=n.s1_256,p=n.g0_256,h=n.g1_256,m=c.BlockHash,g=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];function v(){if(!(this instanceof v))return new v;m.call(this),this.h=[1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225],this.k=g,this.W=new Array(64)}r.inherits(v,m),e.exports=v,v.blockSize=512,v.outSize=256,v.hmacStrength=192,v.padLength=64,v.prototype._update=function(e,a){for(var t=this.W,r=0;r<16;r++)t[r]=e[a+r];for(;r<t.length;r++)t[r]=o(h(t[r-2]),t[r-7],p(t[r-15]),t[r-16]);var c=this.h[0],n=this.h[1],m=this.h[2],g=this.h[3],v=this.h[4],y=this.h[5],_=this.h[6],w=this.h[7];for(i(this.k.length===t.length),r=0;r<t.length;r++){var A=d(w,l(v),s(v,y,_),this.k[r],t[r]),k=f(u(c),b(c,n,m));w=_,_=y,y=v,v=f(g,A),g=m,m=n,n=c,c=f(A,k)}this.h[0]=f(this.h[0],c),this.h[1]=f(this.h[1],n),this.h[2]=f(this.h[2],m),this.h[3]=f(this.h[3],g),this.h[4]=f(this.h[4],v),this.h[5]=f(this.h[5],y),this.h[6]=f(this.h[6],_),this.h[7]=f(this.h[7],w)},v.prototype._digest=function(e){return"hex"===e?r.toHex32(this.h,"big"):r.split32(this.h,"big")}},function(e,a,t){"use strict";var r=t(37).rotr32;function c(e,a,t){return e&a^~e&t}function n(e,a,t){return e&a^e&t^a&t}function i(e,a,t){return e^a^t}a.ft_1=function(e,a,t,r){return 0===e?c(a,t,r):1===e||3===e?i(a,t,r):2===e?n(a,t,r):void 0},a.ch32=c,a.maj32=n,a.p32=i,a.s0_256=function(e){return r(e,2)^r(e,13)^r(e,22)},a.s1_256=function(e){return r(e,6)^r(e,11)^r(e,25)},a.g0_256=function(e){return r(e,7)^r(e,18)^e>>>3},a.g1_256=function(e){return r(e,17)^r(e,19)^e>>>10}},function(e,a,t){"use strict";var r=a;function c(e){return 1===e.length?"0"+e:e}function n(e){for(var a="",t=0;t<e.length;t++)a+=c(e[t].toString(16));return a}r.toArray=function(e,a){if(Array.isArray(e))return e.slice();if(!e)return[];var t=[];if("string"!=typeof e){for(var r=0;r<e.length;r++)t[r]=0|e[r];return t}if("hex"===a)for((e=e.replace(/[^a-z0-9]+/gi,"")).length%2!=0&&(e="0"+e),r=0;r<e.length;r+=2)t.push(parseInt(e[r]+e[r+1],16));else for(r=0;r<e.length;r++){var c=e.charCodeAt(r),n=c>>8,i=255&c;n?t.push(n,i):t.push(i)}return t},r.zero2=c,r.toHex=n,r.encode=function(e,a){return"hex"===a?n(e):e}},function(e){e.exports={COMPRESSED_TYPE_INVALID:"compressed should be a boolean",EC_PRIVATE_KEY_TYPE_INVALID:"private key should be a Buffer",EC_PRIVATE_KEY_LENGTH_INVALID:"private key length is invalid",EC_PRIVATE_KEY_RANGE_INVALID:"private key range is invalid",EC_PRIVATE_KEY_TWEAK_ADD_FAIL:"tweak out of range or resulting private key is invalid",EC_PRIVATE_KEY_TWEAK_MUL_FAIL:"tweak out of range",EC_PRIVATE_KEY_EXPORT_DER_FAIL:"couldn't export to DER format",EC_PRIVATE_KEY_IMPORT_DER_FAIL:"couldn't import from DER format",EC_PUBLIC_KEYS_TYPE_INVALID:"public keys should be an Array",EC_PUBLIC_KEYS_LENGTH_INVALID:"public keys Array should have at least 1 element",EC_PUBLIC_KEY_TYPE_INVALID:"public key should be a Buffer",EC_PUBLIC_KEY_LENGTH_INVALID:"public key length is invalid",EC_PUBLIC_KEY_PARSE_FAIL:"the public key could not be parsed or is invalid",EC_PUBLIC_KEY_CREATE_FAIL:"private was invalid, try again",EC_PUBLIC_KEY_TWEAK_ADD_FAIL:"tweak out of range or resulting public key is invalid",EC_PUBLIC_KEY_TWEAK_MUL_FAIL:"tweak out of range",EC_PUBLIC_KEY_COMBINE_FAIL:"the sum of the public keys is not valid",ECDH_FAIL:"scalar was invalid (zero or overflow)",ECDSA_SIGNATURE_TYPE_INVALID:"signature should be a Buffer",ECDSA_SIGNATURE_LENGTH_INVALID:"signature length is invalid",ECDSA_SIGNATURE_PARSE_FAIL:"couldn't parse signature",ECDSA_SIGNATURE_PARSE_DER_FAIL:"couldn't parse DER signature",ECDSA_SIGNATURE_SERIALIZE_DER_FAIL:"couldn't serialize signature to DER format",ECDSA_SIGN_FAIL:"nonce generation function failed or private key is invalid",ECDSA_RECOVER_FAIL:"couldn't recover public key from signature",MSG32_TYPE_INVALID:"message should be a Buffer",MSG32_LENGTH_INVALID:"message length is invalid",OPTIONS_TYPE_INVALID:"options should be an Object",OPTIONS_DATA_TYPE_INVALID:"options.data should be a Buffer",OPTIONS_DATA_LENGTH_INVALID:"options.data length is invalid",OPTIONS_NONCEFN_TYPE_INVALID:"options.noncefn should be a Function",RECOVERY_ID_TYPE_INVALID:"recovery should be a Number",RECOVERY_ID_VALUE_INVALID:"recovery should have value between -1 and 4",TWEAK_TYPE_INVALID:"tweak should be a Buffer",TWEAK_LENGTH_INVALID:"tweak length is invalid"}},function(e,a){function t(e){var a=new Error("Cannot find module '"+e+"'");throw a.code="MODULE_NOT_FOUND",a}t.keys=function(){return[]},t.resolve=t,e.exports=t,t.id=385},function(e,a,t){"use strict";var r=t(1022),c=t(1020);e.exports=function(e){var a=r(e),t=c(e);return function(e,r){switch("string"==typeof e?e.toLowerCase():e){case"keccak224":return new a(1152,448,null,224,r);case"keccak256":return new a(1088,512,null,256,r);case"keccak384":return new a(832,768,null,384,r);case"keccak512":return new a(576,1024,null,512,r);case"sha3-224":return new a(1152,448,6,224,r);case"sha3-256":return new a(1088,512,6,256,r);case"sha3-384":return new a(832,768,6,384,r);case"sha3-512":return new a(576,1024,6,512,r);case"shake128":return new t(1344,256,31,r);case"shake256":return new t(1088,512,31,r);default:throw new Error("Invald algorithm: "+e)}}}},function(e,a,t){let r=t(1025),c=t(945),n=t(941),i=t(940),f=t(939),o=t(938),d=t(408),s=t(171),b=t(5),u=t(66);function l(e){const a=this;b.call(this),this.options=e=a._applyDefaultOptions(e||{});let t=new o(e,this);this.engine=new r({blockTracker:new d({blockchain:t.state.blockchain})});let s=new c;this.engine.manager=t,this.engine.addProvider(new n),this.engine.addProvider(new i),this.engine.addProvider(s),this.engine.addProvider(new f),this.engine.addProvider(t),this.engine.setMaxListeners(100),this.engine.start(),this.manager=t,this.sendAsync=this.send.bind(this),this.send=this.send.bind(this),this.close=this.close.bind(this),this._queueRequest=this._queueRequest.bind(this),this._processRequestQueue=this._processRequestQueue.bind(this),s.on("data",function(e,t){a.emit("data",e,t)})}const p={vmErrorsOnRPCResponse:!0,verbose:!1,asyncRequestProcessing:!1,logger:{log:function(){}}};l.prototype=Object.create(b.prototype),l.prototype.constructor=l,l.prototype._applyDefaultOptions=function(e){return u.merge({},p,e)},l.prototype.send=function(e,a){if("function"!=typeof a)throw new Error("No callback provided to provider's send function. As of web3 1.0, provider.send is no longer synchronous and must be passed a callback as its final argument.");let t=this,r=function(e){return u.cloneDeep(e)};e=Array.isArray(e)?e.map(r):r(e);let c=function(r,c){let n;if(c=u.cloneDeep(c),Array.isArray(c)){n=[];for(let a=0;a<c.length;a++)n.push(t.reportErrorInResponse(e[a],r,c[a]))}else n=t.reportErrorInResponse(e,r,c);t.options.verbose&&t.options.logger.log(" <   "+JSON.stringify(n,null,2).split("\n").join("\n <   ")),a(n.error?r:null,n)};t.options.verbose&&t.options.logger.log("   > "+JSON.stringify(e,null,2).split("\n").join("\n   > ")),t.options.asyncRequestProcessing?t.engine.sendAsync(e,c):t._queueRequest(e,c)},l.prototype.close=function(e){this.manager.state.blockchain.close(e),this.engine.stop()},l.prototype._queueRequest=function(e,a){this._requestQueue||(this._requestQueue=[]),this._requestQueue.push({payload:e,callback:a}),setImmediate(this._processRequestQueue)},l.prototype._processRequestQueue=function(){const e=this;if(e._requestInProgress)return;e._requestInProgress=!0;let a=e._requestQueue.shift();a?e.engine.sendAsync(a.payload,(t,r)=>{e._requestQueue.length>0&&setImmediate(e._processRequestQueue),a.callback(t,r),e._requestInProgress=!1}):(e._requestInProgress=!1,e._requestQueue.length>0&&setImmediate(e._processRequestQueue))},l.prototype.cleanUpErrorObject=function(e,a){if(!e||!a.error)return a;let t={error:{data:{}}};return e.message?(t.error.message=e.message,t.error.data.stack=e.stack,t.error.data.name=e.name):a.error||(t.error={message:e.toString()}),u.merge(a,t)};let h=["eth_sendTransaction","eth_sendRawTransaction","personal_sendTransaction"];l.prototype._isTransactionRequest=function(e){return-1!=h.indexOf(e.method)},l.prototype.reportErrorInResponse=function(e,a,t){const r=this;return a?(r._isTransactionRequest(e)&&a instanceof s&&(t.result=a.hashes[0],r.options.vmErrorsOnRPCResponse?(t.error.data||(t.error.data={}),t.error.data[a.hashes[0]]=a.results[a.hashes[0]]):delete t.error),"eth_call"===e.method&&a instanceof s&&(r.options.vmErrorsOnRPCResponse?(t.error.data||(t.error.data={}),t.error.data[a.hashes[0]]=a.results[a.hashes[0]]):(t.result=a.results[a.hashes[0]].return||"0x",delete t.error)),r.cleanUpErrorObject(a,t)):t},e.exports=l},function(e,a,t){var r=t(92),c=Object.prototype.hasOwnProperty,n="undefined"!=typeof Map;function i(){this._array=[],this._set=n?new Map:Object.create(null)}i.fromArray=function(e,a){for(var t=new i,r=0,c=e.length;r<c;r++)t.add(e[r],a);return t},i.prototype.size=function(){return n?this._set.size:Object.getOwnPropertyNames(this._set).length},i.prototype.add=function(e,a){var t=n?e:r.toSetString(e),i=n?this.has(e):c.call(this._set,t),f=this._array.length;i&&!a||this._array.push(e),i||(n?this._set.set(e,f):this._set[t]=f)},i.prototype.has=function(e){if(n)return this._set.has(e);var a=r.toSetString(e);return c.call(this._set,a)},i.prototype.indexOf=function(e){if(n){var a=this._set.get(e);if(a>=0)return a}else{var t=r.toSetString(e);if(c.call(this._set,t))return this._set[t]}throw new Error('"'+e+'" is not in the set.')},i.prototype.at=function(e){if(e>=0&&e<this._array.length)return this._array[e];throw new Error("No element indexed by "+e)},i.prototype.toArray=function(){return this._array.slice()},a.ArraySet=i},function(e,a,t){var r=t(1033);a.encode=function(e){var a,t="",c=function(e){return e<0?1+(-e<<1):0+(e<<1)}(e);do{a=31&c,(c>>>=5)>0&&(a|=32),t+=r.encode(a)}while(c>0);return t},a.decode=function(e,a,t){var c,n,i=e.length,f=0,o=0;do{if(a>=i)throw new Error("Expected more digits in base 64 VLQ value.");if(-1===(n=r.decode(e.charCodeAt(a++))))throw new Error("Invalid base64 digit: "+e.charAt(a-1));c=!!(32&n),f+=(n&=31)<<o,o+=5}while(c);t.value=function(e){var a=e>>1;return 1==(1&e)?-a:a}(f),t.rest=a}},function(e,a,t){var r=t(389),c=t(92),n=t(388).ArraySet,i=t(1032).MappingList;function f(e){e||(e={}),this._file=c.getArg(e,"file",null),this._sourceRoot=c.getArg(e,"sourceRoot",null),this._skipValidation=c.getArg(e,"skipValidation",!1),this._sources=new n,this._names=new n,this._mappings=new i,this._sourcesContents=null}f.prototype._version=3,f.fromSourceMap=function(e){var a=e.sourceRoot,t=new f({file:e.file,sourceRoot:a});return e.eachMapping(function(e){var r={generated:{line:e.generatedLine,column:e.generatedColumn}};null!=e.source&&(r.source=e.source,null!=a&&(r.source=c.relative(a,r.source)),r.original={line:e.originalLine,column:e.originalColumn},null!=e.name&&(r.name=e.name)),t.addMapping(r)}),e.sources.forEach(function(r){var n=r;null!==a&&(n=c.relative(a,r)),t._sources.has(n)||t._sources.add(n);var i=e.sourceContentFor(r);null!=i&&t.setSourceContent(r,i)}),t},f.prototype.addMapping=function(e){var a=c.getArg(e,"generated"),t=c.getArg(e,"original",null),r=c.getArg(e,"source",null),n=c.getArg(e,"name",null);this._skipValidation||this._validateMapping(a,t,r,n),null!=r&&(r=String(r),this._sources.has(r)||this._sources.add(r)),null!=n&&(n=String(n),this._names.has(n)||this._names.add(n)),this._mappings.add({generatedLine:a.line,generatedColumn:a.column,originalLine:null!=t&&t.line,originalColumn:null!=t&&t.column,source:r,name:n})},f.prototype.setSourceContent=function(e,a){var t=e;null!=this._sourceRoot&&(t=c.relative(this._sourceRoot,t)),null!=a?(this._sourcesContents||(this._sourcesContents=Object.create(null)),this._sourcesContents[c.toSetString(t)]=a):this._sourcesContents&&(delete this._sourcesContents[c.toSetString(t)],0===Object.keys(this._sourcesContents).length&&(this._sourcesContents=null))},f.prototype.applySourceMap=function(e,a,t){var r=a;if(null==a){if(null==e.file)throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map\'s "file" property. Both were omitted.');r=e.file}var i=this._sourceRoot;null!=i&&(r=c.relative(i,r));var f=new n,o=new n;this._mappings.unsortedForEach(function(a){if(a.source===r&&null!=a.originalLine){var n=e.originalPositionFor({line:a.originalLine,column:a.originalColumn});null!=n.source&&(a.source=n.source,null!=t&&(a.source=c.join(t,a.source)),null!=i&&(a.source=c.relative(i,a.source)),a.originalLine=n.line,a.originalColumn=n.column,null!=n.name&&(a.name=n.name))}var d=a.source;null==d||f.has(d)||f.add(d);var s=a.name;null==s||o.has(s)||o.add(s)},this),this._sources=f,this._names=o,e.sources.forEach(function(a){var r=e.sourceContentFor(a);null!=r&&(null!=t&&(a=c.join(t,a)),null!=i&&(a=c.relative(i,a)),this.setSourceContent(a,r))},this)},f.prototype._validateMapping=function(e,a,t,r){if(a&&"number"!=typeof a.line&&"number"!=typeof a.column)throw new Error("original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.");if((!(e&&"line"in e&&"column"in e&&e.line>0&&e.column>=0)||a||t||r)&&!(e&&"line"in e&&"column"in e&&a&&"line"in a&&"column"in a&&e.line>0&&e.column>=0&&a.line>0&&a.column>=0&&t))throw new Error("Invalid mapping: "+JSON.stringify({generated:e,source:t,original:a,name:r}))},f.prototype._serializeMappings=function(){for(var e,a,t,n,i=0,f=1,o=0,d=0,s=0,b=0,u="",l=this._mappings.toArray(),p=0,h=l.length;p<h;p++){if(e="",(a=l[p]).generatedLine!==f)for(i=0;a.generatedLine!==f;)e+=";",f++;else if(p>0){if(!c.compareByGeneratedPositionsInflated(a,l[p-1]))continue;e+=","}e+=r.encode(a.generatedColumn-i),i=a.generatedColumn,null!=a.source&&(n=this._sources.indexOf(a.source),e+=r.encode(n-b),b=n,e+=r.encode(a.originalLine-1-d),d=a.originalLine-1,e+=r.encode(a.originalColumn-o),o=a.originalColumn,null!=a.name&&(t=this._names.indexOf(a.name),e+=r.encode(t-s),s=t)),u+=e}return u},f.prototype._generateSourcesContent=function(e,a){return e.map(function(e){if(!this._sourcesContents)return null;null!=a&&(e=c.relative(a,e));var t=c.toSetString(e);return Object.prototype.hasOwnProperty.call(this._sourcesContents,t)?this._sourcesContents[t]:null},this)},f.prototype.toJSON=function(){var e={version:this._version,sources:this._sources.toArray(),names:this._names.toArray(),mappings:this._serializeMappings()};return null!=this._file&&(e.file=this._file),null!=this._sourceRoot&&(e.sourceRoot=this._sourceRoot),this._sourcesContents&&(e.sourcesContent=this._generateSourcesContent(e.sources,e.sourceRoot)),e},f.prototype.toString=function(){return JSON.stringify(this.toJSON())},a.SourceMapGenerator=f},function(e,a,t){var r=t(43);e.exports=function(e,a){var t=r.createServer(function(t,r){t.headers;var c=t.method,n=(t.url,[]);t.on("error",function(e){}).on("data",function(e){n.push(e)}).on("end",function(){n=Buffer.concat(n).toString();var t={"Access-Control-Allow-Headers":"Origin, X-Requested-With, Content-Type, Accept, User-Agent","Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*"};switch(c){case"OPTIONS":t["Content-Type"]="text/plain",r.writeHead(200,t),r.end("");break;case"POST":var i;try{i=JSON.parse(n)}catch(e){return t["Content-Type"]="text/plain",r.writeHead(400,t),void r.end("400 Bad Request")}if(i instanceof Array)for(var f=0;f<i.length;f++){var o=i[f];a.log(o.method)}else a.log(i.method);e.send(i,function(e,a){t["Content-Type"]="application/json",r.writeHead(200,t),r.end(JSON.stringify(a))});break;default:r.writeHead(400,{"Access-Control-Allow-Headers":"Origin, X-Requested-With, Content-Type, Accept, User-Agent","Access-Control-Allow-Origin":"*","Access-Control-Allow-Methods":"*","Content-Type":"text/plain"}),r.end("400 Bad Request")}})});return t.ganacheProvider=e,t}},function(e){e.exports={_args:[["websocket@1.0.26","/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core"]],_from:"websocket@1.0.26",_id:"websocket@1.0.26",_inBundle:!1,_integrity:"sha512-fjcrYDPIQxpTnqFQ9JjxUQcdvR89MFAOjPBlF+vjOt49w/XW4fJknUoMz/mDIn2eK1AdslVojcaOxOqyZZV8rw==",_location:"/ganache-core/websocket",_phantomChildren:{},_requested:{type:"version",registry:!0,raw:"websocket@1.0.26",name:"websocket",escapedName:"websocket",rawSpec:"1.0.26",saveSpec:null,fetchSpec:"1.0.26"},_requiredBy:["/ganache-core"],_resolved:"https://registry.npmjs.org/websocket/-/websocket-1.0.26.tgz",_spec:"1.0.26",_where:"/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core",author:{name:"Brian McKelvey",email:"brian@worlize.com",url:"https://www.worlize.com/"},browser:"lib/browser.js",bugs:{url:"https://github.com/theturtle32/WebSocket-Node/issues"},config:{verbose:!1},contributors:[{name:"Iñaki Baz Castillo",email:"ibc@aliax.net",url:"http://dev.sipdoc.net"}],dependencies:{debug:"^2.2.0",nan:"^2.3.3","typedarray-to-buffer":"^3.1.2",yaeti:"^0.0.6"},description:"Websocket Client & Server Library implementing the WebSocket protocol as specified in RFC 6455.",devDependencies:{"buffer-equal":"^1.0.0",faucet:"^0.0.1",gulp:"git+https://github.com/gulpjs/gulp.git#4.0","gulp-jshint":"^2.0.4",jshint:"^2.0.0","jshint-stylish":"^2.2.1",tape:"^4.0.1"},directories:{lib:"./lib"},engines:{node:">=0.10.0"},homepage:"https://github.com/theturtle32/WebSocket-Node",keywords:["websocket","websockets","socket","networking","comet","push","RFC-6455","realtime","server","client"],license:"Apache-2.0",main:"index",name:"websocket",repository:{type:"git",url:"git+https://github.com/theturtle32/WebSocket-Node.git"},scripts:{gulp:"gulp",install:"(node-gyp rebuild 2> builderror.log) || (exit 0)",test:"faucet test/unit"},version:"1.0.26"}},function(e,a,t){e.exports=t(392).version},function(e,a){var t={disableWarnings:!1,deprecationWarningMap:{},warn:function(e){!this.disableWarnings&&this.deprecationWarningMap[e]&&(console.warn("DEPRECATION WARNING: "+this.deprecationWarningMap[e]),this.deprecationWarningMap[e]=!1)}};e.exports=t},function(e,a,t){var r=t(186),c=t(312),n=t(311);const i=0,f=1,o=2,d=3;function s(e,a,t,c,o,s){n.EventTarget.call(this),(s=s||{}).assembleFragments=!0;var h=this;this._url=e,this._readyState=i,this._protocol=void 0,this._extensions="",this._bufferedAmount=0,this._binaryType="arraybuffer",this._connection=void 0,this._client=new r(s),this._client.on("connect",function(e){(function(e){var a=this;this._readyState=f,this._connection=e,this._protocol=e.protocol,this._extensions=e.extensions,this._connection.on("close",function(e,t){(function(e,a){p.call(this),this._readyState=d,this.dispatchEvent(b(e,a||""))}).call(a,e,t)}),this._connection.on("message",function(e){(function(e){if(e.utf8Data)this.dispatchEvent(u(e.utf8Data));else if(e.binaryData&&"arraybuffer"===this.binaryType){for(var a=e.binaryData,t=new ArrayBuffer(a.length),r=new Uint8Array(t),c=0,n=a.length;c<n;++c)r[c]=a[c];this.dispatchEvent(u(t))}}).call(a,e)}),this.dispatchEvent(new n.Event("open"))}).call(h,e)}),this._client.on("connectFailed",function(){l.call(h)}),this._client.connect(e,a,t,c,o)}function b(e,a){var t=new n.Event("close");return t.code=e,t.reason=a,t.wasClean=void 0===e||1e3===e,t}function u(e){var a=new n.Event("message");return a.data=e,a}function l(){p.call(this),this._readyState=d;try{this.dispatchEvent(new n.Event("error"))}finally{this.dispatchEvent(b(1006,"connection failed"))}}function p(){this._client.removeAllListeners(),this._connection&&this._connection.removeAllListeners()}e.exports=s,Object.defineProperties(s.prototype,{url:{get:function(){return this._url}},readyState:{get:function(){return this._readyState}},protocol:{get:function(){return this._protocol}},extensions:{get:function(){return this._extensions}},bufferedAmount:{get:function(){return this._bufferedAmount}}}),Object.defineProperties(s.prototype,{binaryType:{get:function(){return this._binaryType},set:function(e){if("arraybuffer"!==e)throw new SyntaxError('just "arraybuffer" type allowed for "binaryType" attribute');this._binaryType=e}}}),[["CONNECTING",i],["OPEN",f],["CLOSING",o],["CLOSED",d]].forEach(function(e){Object.defineProperty(s.prototype,e[0],{get:function(){return e[1]}})}),[["CONNECTING",i],["OPEN",f],["CLOSING",o],["CLOSED",d]].forEach(function(e){Object.defineProperty(s,e[0],{get:function(){return e[1]}})}),s.prototype.send=function(e){if(this._readyState!==f)throw new Error("cannot call send() while not connected");if("string"==typeof e||e instanceof String)this._connection.sendUTF(e);else if(e instanceof Buffer)this._connection.sendBytes(e);else{if(!e.byteLength&&0!==e.byteLength)throw new Error("unknown binary data:",e);e=c(e),this._connection.sendBytes(e)}},s.prototype.close=function(e,a){switch(this._readyState){case i:l.call(this),this._client.on("connect",function(t){e?t.close(e,a):t.close()});break;case f:this._readyState=o,e?this._connection.close(e,a):this._connection.close()}}},function(e,a,t){var r=t(1),c=t(5).EventEmitter;function n(e,a){c.call(this),this.webSocketRequest=e,this.protocol="____no_protocol____"===a?null:a,this.origin=e.origin,this.resource=e.resource,this.resourceURL=e.resourceURL,this.httpRequest=e.httpRequest,this.remoteAddress=e.remoteAddress,this.webSocketVersion=e.webSocketVersion,this.requestedExtensions=e.requestedExtensions,this.cookies=e.cookies}r.inherits(n,c),n.prototype.accept=function(e,a){var t=this.webSocketRequest.accept(this.protocol,e,a);return this.emit("requestAccepted",t),t},n.prototype.reject=function(e,a,t){this.webSocketRequest.reject(e,a,t),this.emit("requestRejected",this)},e.exports=n},function(e,a,t){var r=t(65).extend,c=t(1),n=t(5).EventEmitter,i=t(396);function f(e){n.call(this),this.config={server:null},e&&r(this.config,e),this.handlers=[],this._requestHandler=this.handleRequest.bind(this),this.config.server&&this.attachServer(this.config.server)}c.inherits(f,n),f.prototype.attachServer=function(e){if(!e)throw new Error("You must specify a WebSocketServer instance to attach to.");this.server=e,this.server.on("request",this._requestHandler)},f.prototype.detachServer=function(){if(!this.server)throw new Error("Cannot detach from server: not attached.");this.server.removeListener("request",this._requestHandler),this.server=null},f.prototype.mount=function(e,a,t){if(!e)throw new Error("You must specify a path for this handler.");if(a||(a="____no_protocol____"),!t)throw new Error("You must specify a callback for this handler.");if(!((e=this.pathToRegExp(e))instanceof RegExp))throw new Error("Path must be specified as either a string or a RegExp.");var r=e.toString();if(a=a.toLocaleLowerCase(),-1!==this.findHandlerIndex(r,a))throw new Error("You may only mount one handler per path/protocol combination.");this.handlers.push({path:e,pathString:r,protocol:a,callback:t})},f.prototype.unmount=function(e,a){var t=this.findHandlerIndex(this.pathToRegExp(e).toString(),a);if(-1===t)throw new Error("Unable to find a route matching the specified path and protocol.");this.handlers.splice(t,1)},f.prototype.findHandlerIndex=function(e,a){a=a.toLocaleLowerCase();for(var t=0,r=this.handlers.length;t<r;t++){var c=this.handlers[t];if(c.pathString===e&&c.protocol===a)return t}return-1},f.prototype.pathToRegExp=function(e){return"string"==typeof e&&("*"===e?e=/^.*$/:(e=e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&"),e=new RegExp("^"+e+"$"))),e},f.prototype.handleRequest=function(e){var a=e.requestedProtocols;0===a.length&&(a=["____no_protocol____"]);for(var t=0;t<a.length;t++)for(var r=a[t].toLocaleLowerCase(),c=0,n=this.handlers.length;c<n;c++){var f=this.handlers[c];if(f.path.test(e.resourceURL.pathname)&&(r===f.protocol||"*"===f.protocol)){var o=new i(e,r);return void f.callback(o)}}e.reject(404,"No handler is available for the given request.")},e.exports=f},function(e,a){
/*!
 * UTF-8 Validation Fallback Code originally from:
 * ws: a node.js websocket client
 * Copyright(c) 2011 Einar Otto Stangvik <einaros@gmail.com>
 * MIT Licensed
 */
e.exports.Validation={isValidUTF8:function(){return!0}}},function(e,a,t){
/*!
 * UTF-8 Validation Code originally from:
 * ws: a node.js websocket client
 * Copyright(c) 2011 Einar Otto Stangvik <einaros@gmail.com>
 * MIT Licensed
 */
try{e.exports=t(!function(){var e=new Error("Cannot find module '../build/Release/validation'");throw e.code="MODULE_NOT_FOUND",e}())}catch(a){try{e.exports=t(!function(){var e=new Error("Cannot find module '../build/default/validation'");throw e.code="MODULE_NOT_FOUND",e}())}catch(a){try{e.exports=t(398)}catch(e){throw console.error("validation.node seems not to have been built. Run npm install."),e}}}},function(e,a,t){var r=t(24).Buffer,c=t(5).EventEmitter;function n(e){if(!(this instanceof n))return new n(e);c.call(this);var a=this;void 0===e&&(e={}),a.encoding=e.encoding,a.construct=e.construct||r;var t={next:null,buffer:null},i={next:null,buffer:null},f=0;a.__defineGetter__("length",function(){return f});var o=0;a.write=function(e){return t.buffer?(i.next={next:null,buffer:e},i=i.next):(t.buffer=e,i=t),f+=e.length,a.emit("write",e),!0},a.end=function(e){r.isBuffer(e)&&a.write(e)},a.push=function(){return[].concat.apply([],arguments).forEach(a.write),a},a.forEach=function(e){if(!t.buffer)return new a.construct(0);if(t.buffer.length-o<=0)return a;for(var r={buffer:t.buffer.slice(o),next:t.next};r&&r.buffer;){if(e(r.buffer))break;r=r.next}return a},a.join=function(e,r){if(!t.buffer)return new a.construct(0);void 0==e&&(e=0),void 0==r&&(r=a.length);var c=new a.construct(r-e),n=0;return a.forEach(function(a){if(e<n+a.length&&n<r&&a.copy(c,Math.max(0,n-e),Math.max(0,e-n),Math.min(a.length,r-n)),(n+=a.length)>r)return!0}),c},a.joinInto=function(e,r,c,n){if(!t.buffer)return new a.construct(0);void 0==c&&(c=0),void 0==n&&(n=a.length);var i=e;if(i.length-r<n-c)throw new Error("Insufficient space available in target Buffer.");var f=0;return a.forEach(function(e){if(c<f+e.length&&f<n&&e.copy(i,Math.max(r,r+f-c),Math.max(0,c-f),Math.min(e.length,n-f)),(f+=e.length)>n)return!0}),i},a.advance=function(e){for(o+=e,f-=e;t.buffer&&o>=t.buffer.length;)o-=t.buffer.length,t=t.next?t.next:{buffer:null,next:null};return null===t.buffer&&(i={next:null,buffer:null}),a.emit("advance",e),a},a.take=function(e,t){void 0==e?e=a.length:"number"!=typeof e&&(t=e,e=a.length);if(t||(t=a.encoding),t){var r="";return a.forEach(function(a){if(e<=0)return!0;r+=a.toString(t,0,Math.min(e,a.length)),e-=a.length}),r}return a.join(0,e)},a.toString=function(){return a.take("binary")}}e.exports=n,e.exports.BufferList=n,t(1).inherits(n,c)},function(e,a){
/*!
 * Copied from:
 * ws: a node.js websocket client
 * Copyright(c) 2011 Einar Otto Stangvik <einaros@gmail.com>
 * MIT Licensed
 */
e.exports.BufferUtil={merge:function(e,a){for(var t=0,r=0,c=a.length;r<c;++r){var n=a[r];n.copy(e,t),t+=n.length}},mask:function(e,a,t,r,c){for(var n=a.readUInt32LE(0),i=0;i<c-3;i+=4){var f=n^e.readUInt32LE(i);f<0&&(f=4294967296+f),t.writeUInt32LE(f,r+i)}switch(c%4){case 3:t[r+i+2]=e[i+2]^a[2];case 2:t[r+i+1]=e[i+1]^a[1];case 1:t[r+i]=e[i]^a[0]}},unmask:function(e,a){for(var t=a.readUInt32LE(0),r=e.length,c=0;c<r-3;c+=4){var n=t^e.readUInt32LE(c);n<0&&(n=4294967296+n),e.writeUInt32LE(n,c)}switch(r%4){case 3:e[c+2]=e[c+2]^a[2];case 2:e[c+1]=e[c+1]^a[1];case 1:e[c]=e[c]^a[0]}}}},function(e,a,t){
/*!
 * Copied from:
 * ws: a node.js websocket client
 * Copyright(c) 2011 Einar Otto Stangvik <einaros@gmail.com>
 * MIT Licensed
 */
try{e.exports=t(!function(){var e=new Error("Cannot find module '../build/Release/bufferutil'");throw e.code="MODULE_NOT_FOUND",e}())}catch(a){try{e.exports=t(!function(){var e=new Error("Cannot find module '../build/default/bufferutil'");throw e.code="MODULE_NOT_FOUND",e}())}catch(a){try{e.exports=t(401)}catch(e){throw console.error("bufferutil.node seems to not have been built. Run npm install."),e}}}},function(e,a,t){var r=t(65).extend,c=t(65),n=t(1),i=t(115)("websocket:server"),f=t(5).EventEmitter,o=t(188),d=function(e){f.call(this),this._handlers={upgrade:this.handleUpgrade.bind(this),requestAccepted:this.handleRequestAccepted.bind(this),requestResolved:this.handleRequestResolved.bind(this)},this.connections=[],this.pendingRequests=[],e&&this.mount(e)};n.inherits(d,f),d.prototype.mount=function(e){if(this.config={httpServer:null,maxReceivedFrameSize:65536,maxReceivedMessageSize:1048576,fragmentOutgoingMessages:!0,fragmentationThreshold:16384,keepalive:!0,keepaliveInterval:2e4,dropConnectionOnKeepaliveTimeout:!0,keepaliveGracePeriod:1e4,useNativeKeepalive:!1,assembleFragments:!0,autoAcceptConnections:!1,ignoreXForwardedFor:!1,disableNagleAlgorithm:!0,closeTimeout:5e3},r(this.config,e),!this.config.httpServer)throw new Error("You must specify an httpServer on which to mount the WebSocket server.");Array.isArray(this.config.httpServer)||(this.config.httpServer=[this.config.httpServer]);var a=this._handlers.upgrade;this.config.httpServer.forEach(function(e){e.on("upgrade",a)})},d.prototype.unmount=function(){var e=this._handlers.upgrade;this.config.httpServer.forEach(function(a){a.removeListener("upgrade",e)})},d.prototype.closeAllConnections=function(){this.connections.forEach(function(e){e.close()}),this.pendingRequests.forEach(function(e){process.nextTick(function(){e.reject(503)})})},d.prototype.broadcast=function(e){Buffer.isBuffer(e)?this.broadcastBytes(e):"function"==typeof e.toString&&this.broadcastUTF(e)},d.prototype.broadcastUTF=function(e){this.connections.forEach(function(a){a.sendUTF(e)})},d.prototype.broadcastBytes=function(e){this.connections.forEach(function(a){a.sendBytes(e)})},d.prototype.shutDown=function(){this.unmount(),this.closeAllConnections()},d.prototype.handleUpgrade=function(e,a){var t=new o(a,e,this.config);try{t.readHandshake()}catch(e){return t.reject(e.httpCode?e.httpCode:400,e.message,e.headers),void i("Invalid handshake: %s",e.message)}this.pendingRequests.push(t),t.once("requestAccepted",this._handlers.requestAccepted),t.once("requestResolved",this._handlers.requestResolved),!this.config.autoAcceptConnections&&c.eventEmitterListenerCount(this,"request")>0?this.emit("request",t):this.config.autoAcceptConnections?t.accept(t.requestedProtocols[0],t.origin):t.reject(404,"No handler is configured to accept the connection.")},d.prototype.handleRequestAccepted=function(e){var a=this;e.once("close",function(t,r){a.handleConnectionClose(e,t,r)}),this.connections.push(e),this.emit("connect",e)},d.prototype.handleConnectionClose=function(e,a,t){var r=this.connections.indexOf(e);-1!==r&&this.connections.splice(r,1),this.emit("close",e,a,t)},d.prototype.handleRequestResolved=function(e){var a=this.pendingRequests.indexOf(e);-1!==a&&this.pendingRequests.splice(a,1)},e.exports=d},function(e,a,t){e.exports={server:t(403),client:t(186),router:t(397),frame:t(187),request:t(188),connection:t(120),w3cwebsocket:t(395),deprecation:t(394),version:t(393)}},function(e,a,t){e.exports=t(404)},function(e,a,t){var r=t(405).server;t(19);function c(e,a){const t=this;t.provider=e,t.logger=a,t.connectionsBySubscriptionId={},t.connections={},t.connectionCounter=0,t._updateSubscriptions=t._updateSubscriptions.bind(t),t.manageConnection=t.manageConnection.bind(t),t._logPayload=t._logPayload.bind(t),t._handleRequest=t._handleRequest.bind(t),e.on("data",function(e,a){t._updateSubscriptions.call(t,a)})}e.exports=function(e,a,t){var n=new c(a,t),i=new r({httpServer:e,autoAcceptConnections:!0});return i.on("connect",n.manageConnection),i},c.prototype.manageConnection=function(e){const a=this;e.id=++a.connectionCounter,a.connections[e.id]={connection:e,subscriptions:{}},e.on("message",function(t){try{var r=JSON.parse(t.utf8Data)}catch(a){e.reject(400,"Bad Request")}a._logPayload(r),a._handleRequest(e,r)}),e.on("close",function(){Object.keys(a.connections[e.id].subscriptions).forEach(e=>{a.provider.send({jsonrpc:"2.0",method:"eth_unsubscribe",params:[e],id:(new Date).getTime()},function(t,r){delete a.connectionsBySubscriptionId[e]})}),delete a.connections[e.id]})},c.prototype._handleRequest=function(e,a){const t=this;switch(a.method){case"eth_subscribe":t.provider.send(a,function(a,r){!a&&r.result&&(t.connections[e.id].subscriptions[r.result]=!0,t.connectionsBySubscriptionId[r.result]=t.connections[e.id]),e.send(JSON.stringify(r))});break;case"eth_unsubscribe":t.provider.send(a,function(r,c){r||c.error?e&&e.send&&e.send(JSON.stringify(c)):(e=t.connectionsBySubscriptionId[a.params[0]],delete t.connections[e.id].subscriptions[a.params[0]],delete t.connectionsBySubscriptionId[a.params[0]],e.send(JSON.stringify(c)))});break;default:t.provider.send(a,function(a,t){e.send(JSON.stringify(t))})}},c.prototype._logPayload=function(e){const a=this;if(e instanceof Array)for(var t=0;t<e.length;t++){var r=e[t];a.logger.log(r.method)}else a.logger.log(e.method)},c.prototype._updateSubscriptions=function(e){this.connectionsBySubscriptionId[e.params.subscription].connection.send(JSON.stringify(e))}},function(e,a,t){var r=t(387),c=t(406),n=t(391),i=t(66);e.exports={create:function(e){var a=(e=o(e||{})).logger,t=new r(e),i=n(t,a);let f=0;const d={};i.on("connection",e=>{let a=f++;d[a]=e,e.on("close",()=>delete d[a])});var s=i.listen;i.listen=function(){var e=Array.prototype.slice.call(arguments),a=function(){};e.length>0&&("function"==typeof e[e.length-1]&&(a=e.pop()));e.push(function(e){if(e)return a(e);i.provider.manager.waitForInitialization(a)}),s.apply(i,e)},i.provider=t;e.ws&&c(i,t,a);var b=i.close;return i.close=function(e){var a=Array.prototype.slice.call(arguments);b.apply(i,a),i.provider.close(function(a){if(a)return e(a);Object.keys(d).forEach(e=>{try{d[e].destroy()}catch(e){}})})},i}};const f={logger:{log:function(){}},ws:!0};var o=function(e){return i.merge({},f,e)}},function(e,a,t){const r=t(5);t(190);var c=t(189);t(19);function n(e){if(e=e||{},r.apply(this),!e.blockchain)throw new Error("RpcBlockTracker - no blockchain specified.");if(!e.blockchain.on)throw new Error("RpcBlockTracker - blockchain is not an EventEmitter.");this._blockchain=e.blockchain,this.start=this.start.bind(this),this.stop=this.stop.bind(this),this.getTrackingBlock=this.getTrackingBlock.bind(this),this.awaitCurrentBlock=this.awaitCurrentBlock.bind(this),this._setCurrentBlock=this._setCurrentBlock.bind(this)}n.prototype=Object.create(r.prototype),n.prototype.constructor=n,n.prototype.getTrackingBlock=function(){return this._currentBlock},n.prototype.getCurrentBlock=function(){return this._currentBlock},n.prototype.awaitCurrentBlock=function(){const e=this;return this._currentBlock?this._currentBlock:new Promise(e=>this.once("block",e)).then(()=>e._currentBlock)},n.prototype.start=function(e={}){return this._blockchain.on("block",this._setCurrentBlock),Promise.resolve()},n.prototype.stop=function(){this._isRunning=!1,this._blockchain.removeListener("block",this._setCurrentBlock)},n.prototype._setCurrentBlock=function(e){let a=c.toJSON(e,!0);if(this._currentBlock&&this._currentBlock.hash===a.hash)return;const t=this._currentBlock;this._currentBlock=a,this.emit("latest",a),this.emit("sync",{block:a,oldBlock:t}),this.emit("block",a)},e.exports=n},function(e){e.exports={_from:"ganache-core@2.2.1",_id:"ganache-core@2.2.1",_inBundle:!1,_integrity:"sha512-JMLZj7CKxtC5M0qceQYn8FLOx+CZyfISpSRfGdwnKy3juXO8siSAodjq8hviqUY1J0tEdEGqvNm16wSUxtiRjQ==",_location:"/ganache-core",_phantomChildren:{},_requested:{type:"version",registry:!0,raw:"ganache-core@2.2.1",name:"ganache-core",escapedName:"ganache-core",rawSpec:"2.2.1",saveSpec:null,fetchSpec:"2.2.1"},_requiredBy:["#DEV:/"],_resolved:"https://registry.npmjs.org/ganache-core/-/ganache-core-2.2.1.tgz",_shasum:"c0125d77d3e28d627a812dd002dac21e1d2cc8b7",_shrinkwrap:{name:"ganache-core",version:"2.2.1",lockfileVersion:1,requires:!0,dependencies:{"abstract-leveldown":{version:"3.0.0",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-3.0.0.tgz",integrity:"sha512-KUWx9UWGQD12zsmLNj64/pndaz4iJh/Pj7nopgkfDG6RlCcbMZvT6+9l7dchK4idog2Is8VdC/PvNbFuFmalIQ==",requires:{xtend:"4.0.1"}},accepts:{version:"1.3.5",resolved:"https://registry.npmjs.org/accepts/-/accepts-1.3.5.tgz",integrity:"sha1-63d99gEXI6OxTopywIBcjoZ0a9I=",requires:{"mime-types":"2.1.18",negotiator:"0.6.1"}},"aes-js":{version:"0.2.4",resolved:"https://registry.npmjs.org/aes-js/-/aes-js-0.2.4.tgz",integrity:"sha1-lLiBq3FyhtAV+iGeCPtmcJ3aWj0="},ajv:{version:"5.5.2",resolved:"https://registry.npmjs.org/ajv/-/ajv-5.5.2.tgz",integrity:"sha1-c7Xuyj+rZT49P5Qis0GtQiBdyWU=",requires:{co:"4.6.0","fast-deep-equal":"1.1.0","fast-json-stable-stringify":"2.0.0","json-schema-traverse":"0.3.1"}},"ansi-regex":{version:"2.1.1",resolved:"https://registry.npmjs.org/ansi-regex/-/ansi-regex-2.1.1.tgz",integrity:"sha1-w7M6te42DYbg5ijwRorn7yfWVN8="},"ansi-styles":{version:"2.2.1",resolved:"https://registry.npmjs.org/ansi-styles/-/ansi-styles-2.2.1.tgz",integrity:"sha1-tDLdM1i2NM914eRmQ2gkBTPB3b4="},"any-promise":{version:"1.3.0",resolved:"https://registry.npmjs.org/any-promise/-/any-promise-1.3.0.tgz",integrity:"sha1-q8av7tzqUugJzcA3au0845Y10X8="},argsarray:{version:"0.0.1",resolved:"https://registry.npmjs.org/argsarray/-/argsarray-0.0.1.tgz",integrity:"sha1-bnIHtOzbObCviDA/pa4ivajfYcs="},"array-flatten":{version:"1.1.1",resolved:"https://registry.npmjs.org/array-flatten/-/array-flatten-1.1.1.tgz",integrity:"sha1-ml9pkFGx5wczKPKgCJaLZOopVdI="},asn1:{version:"0.2.3",resolved:"https://registry.npmjs.org/asn1/-/asn1-0.2.3.tgz",integrity:"sha1-2sh4dxPJlmhJ/IGAd36+nB3fO4Y="},"asn1.js":{version:"4.10.1",resolved:"https://registry.npmjs.org/asn1.js/-/asn1.js-4.10.1.tgz",integrity:"sha512-p32cOF5q0Zqs9uBiONKYLm6BClCoBCM5O9JfeUSlnQLBTxYdTK+pW+nXflm8UkKd2UYlEbYz5qEi0JuZR9ckSw==",requires:{"bn.js":"4.11.6",inherits:"2.0.3","minimalistic-assert":"1.0.1"}},assert:{version:"1.4.1",resolved:"https://registry.npmjs.org/assert/-/assert-1.4.1.tgz",integrity:"sha1-mZEtWRg2tab1s0XA8H7vwI/GXZE=",dev:!0,requires:{util:"0.10.3"}},"assert-match":{version:"1.1.1",resolved:"https://registry.npmjs.org/assert-match/-/assert-match-1.1.1.tgz",integrity:"sha512-c0QY2kpYVrH/jis6cCq9Mnt4/bIdGALDh1N8HY9ZARZedsMs5LSbgywxkjd5A1uNVLN0L8evANxBPxKiabVoZw==",dev:!0,requires:{assert:"1.4.1","babel-runtime":"6.26.0","es-to-primitive":"1.1.1","lodash.merge":"4.6.1"}},"assert-plus":{version:"1.0.0",resolved:"https://registry.npmjs.org/assert-plus/-/assert-plus-1.0.0.tgz",integrity:"sha1-8S4PPF13sLHN2RRpQuTpbB5N1SU="},"assertion-error":{version:"1.1.0",resolved:"https://registry.npmjs.org/assertion-error/-/assertion-error-1.1.0.tgz",integrity:"sha512-jgsaNduz+ndvGyFt3uSuWqvy4lCnIJiovtouQN5JZHOKCS2QuhEdbcQHFhVksz2N2U9hXJo8odG7ETyWlEeuDw=="},async:{version:"2.6.1",resolved:"https://registry.npmjs.org/async/-/async-2.6.1.tgz",integrity:"sha512-fNEiL2+AZt6AlAw/29Cr0UDe4sRAHCpEHh54WMz+Bb7QfNcFw4h3loofyJpLeQs4Yx7yuqu/2dLgM5hKOs6HlQ==",requires:{lodash:"4.17.10"}},"async-eventemitter":{version:"0.2.4",resolved:"https://registry.npmjs.org/async-eventemitter/-/async-eventemitter-0.2.4.tgz",integrity:"sha512-pd20BwL7Yt1zwDFy+8MX8F1+WCT8aQeKj0kQnTrH9WaeRETlRamVhD0JtRPmrV4GfOJ2F9CvdQkZeZhnh2TuHw==",requires:{async:"2.6.1"}},"async-limiter":{version:"1.0.0",resolved:"https://registry.npmjs.org/async-limiter/-/async-limiter-1.0.0.tgz",integrity:"sha512-jp/uFnooOiO+L211eZOoSyzpOITMXx1rBITauYykG3BRYPu8h0UcxsPNB04RR5vo4Tyz3+ay17tR6JVf9qzYWg=="},asynckit:{version:"0.4.0",resolved:"https://registry.npmjs.org/asynckit/-/asynckit-0.4.0.tgz",integrity:"sha1-x57Zf380y48robyXkLzDZkdLS3k="},"aws-sign2":{version:"0.7.0",resolved:"https://registry.npmjs.org/aws-sign2/-/aws-sign2-0.7.0.tgz",integrity:"sha1-tG6JCTSpWR8tL2+G1+ap8bP+dqg="},aws4:{version:"1.7.0",resolved:"https://registry.npmjs.org/aws4/-/aws4-1.7.0.tgz",integrity:"sha512-32NDda82rhwD9/JBCCkB+MRYDp0oSvlo2IL6rQWA10PQi7tDUM3eqMSltXmY+Oyl/7N3P3qNtAlv7X0d9bI28w=="},"babel-code-frame":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-code-frame/-/babel-code-frame-6.26.0.tgz",integrity:"sha1-Y/1D99weO7fONZR9uP42mj9Yx0s=",requires:{chalk:"1.1.3",esutils:"2.0.2","js-tokens":"3.0.2"}},"babel-core":{version:"6.26.3",resolved:"https://registry.npmjs.org/babel-core/-/babel-core-6.26.3.tgz",integrity:"sha512-6jyFLuDmeidKmUEb3NM+/yawG0M2bDZ9Z1qbZP59cyHLz8kYGKYwpJP0UwUKKUiTRNvxfLesJnTedqczP7cTDA==",requires:{"babel-code-frame":"6.26.0","babel-generator":"6.26.1","babel-helpers":"6.24.1","babel-messages":"6.23.0","babel-register":"6.26.0","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0",babylon:"6.18.0","convert-source-map":"1.5.1",debug:"2.6.9",json5:"0.5.1",lodash:"4.17.10",minimatch:"3.0.4","path-is-absolute":"1.0.1",private:"0.1.8",slash:"1.0.0","source-map":"0.5.7"}},"babel-generator":{version:"6.26.1",resolved:"https://registry.npmjs.org/babel-generator/-/babel-generator-6.26.1.tgz",integrity:"sha512-HyfwY6ApZj7BYTcJURpM5tznulaBvyio7/0d4zFOeMPUmfxkCjHocCuoLa2SAGzBI8AREcH3eP3758F672DppA==",requires:{"babel-messages":"6.23.0","babel-runtime":"6.26.0","babel-types":"6.26.0","detect-indent":"4.0.0",jsesc:"1.3.0",lodash:"4.17.10","source-map":"0.5.7","trim-right":"1.0.1"},dependencies:{jsesc:{version:"1.3.0",resolved:"https://registry.npmjs.org/jsesc/-/jsesc-1.3.0.tgz",integrity:"sha1-RsP+yMGJKxKwgz25vHYiF226s0s="}}},"babel-helper-builder-binary-assignment-operator-visitor":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-builder-binary-assignment-operator-visitor/-/babel-helper-builder-binary-assignment-operator-visitor-6.24.1.tgz",integrity:"sha1-zORReto1b0IgvK6KAsKzRvmlZmQ=",requires:{"babel-helper-explode-assignable-expression":"6.24.1","babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-helper-call-delegate":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-call-delegate/-/babel-helper-call-delegate-6.24.1.tgz",integrity:"sha1-7Oaqzdx25Bw0YfiL/Fdb0Nqi340=",requires:{"babel-helper-hoist-variables":"6.24.1","babel-runtime":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-helper-define-map":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-helper-define-map/-/babel-helper-define-map-6.26.0.tgz",integrity:"sha1-pfVtq0GiX5fstJjH66ypgZ+Vvl8=",requires:{"babel-helper-function-name":"6.24.1","babel-runtime":"6.26.0","babel-types":"6.26.0",lodash:"4.17.10"}},"babel-helper-explode-assignable-expression":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-explode-assignable-expression/-/babel-helper-explode-assignable-expression-6.24.1.tgz",integrity:"sha1-8luCz33BBDPFX3BZLVdGQArCLKo=",requires:{"babel-runtime":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-helper-function-name":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-function-name/-/babel-helper-function-name-6.24.1.tgz",integrity:"sha1-00dbjAPtmCQqJbSDUasYOZ01gKk=",requires:{"babel-helper-get-function-arity":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-helper-get-function-arity":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-get-function-arity/-/babel-helper-get-function-arity-6.24.1.tgz",integrity:"sha1-j3eCqpNAfEHTqlCQj4mwMbG2hT0=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-helper-hoist-variables":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-hoist-variables/-/babel-helper-hoist-variables-6.24.1.tgz",integrity:"sha1-HssnaJydJVE+rbyZFKc/VAi+enY=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-helper-optimise-call-expression":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-optimise-call-expression/-/babel-helper-optimise-call-expression-6.24.1.tgz",integrity:"sha1-96E0J7qfc/j0+pk8VKl4gtEkQlc=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-helper-regex":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-helper-regex/-/babel-helper-regex-6.26.0.tgz",integrity:"sha1-MlxZ+QL4LyS3T6zu0DY5VPZJXnI=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0",lodash:"4.17.10"}},"babel-helper-remap-async-to-generator":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-remap-async-to-generator/-/babel-helper-remap-async-to-generator-6.24.1.tgz",integrity:"sha1-XsWBgnrXI/7N04HxySg5BnbkVRs=",requires:{"babel-helper-function-name":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-helper-replace-supers":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helper-replace-supers/-/babel-helper-replace-supers-6.24.1.tgz",integrity:"sha1-v22/5Dk40XNpohPKiov3S2qQqxo=",requires:{"babel-helper-optimise-call-expression":"6.24.1","babel-messages":"6.23.0","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-helpers":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-helpers/-/babel-helpers-6.24.1.tgz",integrity:"sha1-NHHenK7DiOXIUOWX5Yom3fN2ArI=",requires:{"babel-runtime":"6.26.0","babel-template":"6.26.0"}},"babel-messages":{version:"6.23.0",resolved:"https://registry.npmjs.org/babel-messages/-/babel-messages-6.23.0.tgz",integrity:"sha1-8830cDhYA1sqKVHG7F7fbGLyYw4=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-check-es2015-constants":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-check-es2015-constants/-/babel-plugin-check-es2015-constants-6.22.0.tgz",integrity:"sha1-NRV7EBQm/S/9PaP3XH0ekYNbv4o=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-syntax-async-functions":{version:"6.13.0",resolved:"https://registry.npmjs.org/babel-plugin-syntax-async-functions/-/babel-plugin-syntax-async-functions-6.13.0.tgz",integrity:"sha1-ytnK0RkbWtY0vzCuCHI5HgZHvpU="},"babel-plugin-syntax-exponentiation-operator":{version:"6.13.0",resolved:"https://registry.npmjs.org/babel-plugin-syntax-exponentiation-operator/-/babel-plugin-syntax-exponentiation-operator-6.13.0.tgz",integrity:"sha1-nufoM3KQ2pUoggGmpX9BcDF4MN4="},"babel-plugin-syntax-trailing-function-commas":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-syntax-trailing-function-commas/-/babel-plugin-syntax-trailing-function-commas-6.22.0.tgz",integrity:"sha1-ugNgk3+NBuQBgKQ/4NVhb/9TLPM="},"babel-plugin-transform-async-to-generator":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-async-to-generator/-/babel-plugin-transform-async-to-generator-6.24.1.tgz",integrity:"sha1-ZTbjeK/2yx1VF6wOQOs+n8jQh2E=",requires:{"babel-helper-remap-async-to-generator":"6.24.1","babel-plugin-syntax-async-functions":"6.13.0","babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-arrow-functions":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-arrow-functions/-/babel-plugin-transform-es2015-arrow-functions-6.22.0.tgz",integrity:"sha1-RSaSy3EdX3ncf4XkQM5BufJE0iE=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-block-scoped-functions":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-block-scoped-functions/-/babel-plugin-transform-es2015-block-scoped-functions-6.22.0.tgz",integrity:"sha1-u8UbSflk1wy42OC5ToICRs46YUE=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-block-scoping":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-block-scoping/-/babel-plugin-transform-es2015-block-scoping-6.26.0.tgz",integrity:"sha1-1w9SmcEwjQXBL0Y4E7CgnnOxiV8=",requires:{"babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0",lodash:"4.17.10"}},"babel-plugin-transform-es2015-classes":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-classes/-/babel-plugin-transform-es2015-classes-6.24.1.tgz",integrity:"sha1-WkxYpQyclGHlZLSyo7+ryXolhNs=",requires:{"babel-helper-define-map":"6.26.0","babel-helper-function-name":"6.24.1","babel-helper-optimise-call-expression":"6.24.1","babel-helper-replace-supers":"6.24.1","babel-messages":"6.23.0","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-computed-properties":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-computed-properties/-/babel-plugin-transform-es2015-computed-properties-6.24.1.tgz",integrity:"sha1-b+Ko0WiV1WNPTNmZttNICjCBWbM=",requires:{"babel-runtime":"6.26.0","babel-template":"6.26.0"}},"babel-plugin-transform-es2015-destructuring":{version:"6.23.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-destructuring/-/babel-plugin-transform-es2015-destructuring-6.23.0.tgz",integrity:"sha1-mXux8auWf2gtKwh2/jWNYOdlxW0=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-duplicate-keys":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-duplicate-keys/-/babel-plugin-transform-es2015-duplicate-keys-6.24.1.tgz",integrity:"sha1-c+s9MQypaePvnskcU3QabxV2Qj4=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-for-of":{version:"6.23.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-for-of/-/babel-plugin-transform-es2015-for-of-6.23.0.tgz",integrity:"sha1-9HyVsrYT3x0+zC/bdXNiPHUkhpE=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-function-name":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-function-name/-/babel-plugin-transform-es2015-function-name-6.24.1.tgz",integrity:"sha1-g0yJhTvDaxrw86TF26qU/Y6sqos=",requires:{"babel-helper-function-name":"6.24.1","babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-literals":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-literals/-/babel-plugin-transform-es2015-literals-6.22.0.tgz",integrity:"sha1-T1SgLWzWbPkVKAAZox0xklN3yi4=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-modules-amd":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-modules-amd/-/babel-plugin-transform-es2015-modules-amd-6.24.1.tgz",integrity:"sha1-Oz5UAXI5hC1tGcMBHEvS8AoA0VQ=",requires:{"babel-plugin-transform-es2015-modules-commonjs":"6.26.2","babel-runtime":"6.26.0","babel-template":"6.26.0"}},"babel-plugin-transform-es2015-modules-commonjs":{version:"6.26.2",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-modules-commonjs/-/babel-plugin-transform-es2015-modules-commonjs-6.26.2.tgz",integrity:"sha512-CV9ROOHEdrjcwhIaJNBGMBCodN+1cfkwtM1SbUHmvyy35KGT7fohbpOxkE2uLz1o6odKK2Ck/tz47z+VqQfi9Q==",requires:{"babel-plugin-transform-strict-mode":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-modules-systemjs":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-modules-systemjs/-/babel-plugin-transform-es2015-modules-systemjs-6.24.1.tgz",integrity:"sha1-/4mhQrkRmpBhlfXxBuzzBdlAfSM=",requires:{"babel-helper-hoist-variables":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0"}},"babel-plugin-transform-es2015-modules-umd":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-modules-umd/-/babel-plugin-transform-es2015-modules-umd-6.24.1.tgz",integrity:"sha1-rJl+YoXNGO1hdq22B9YCNErThGg=",requires:{"babel-plugin-transform-es2015-modules-amd":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0"}},"babel-plugin-transform-es2015-object-super":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-object-super/-/babel-plugin-transform-es2015-object-super-6.24.1.tgz",integrity:"sha1-JM72muIcuDp/hgPa0CH1cusnj40=",requires:{"babel-helper-replace-supers":"6.24.1","babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-parameters":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-parameters/-/babel-plugin-transform-es2015-parameters-6.24.1.tgz",integrity:"sha1-V6w1GrScrxSpfNE7CfZv3wpiXys=",requires:{"babel-helper-call-delegate":"6.24.1","babel-helper-get-function-arity":"6.24.1","babel-runtime":"6.26.0","babel-template":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-shorthand-properties":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-shorthand-properties/-/babel-plugin-transform-es2015-shorthand-properties-6.24.1.tgz",integrity:"sha1-JPh11nIch2YbvZmkYi5R8U3jiqA=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-spread":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-spread/-/babel-plugin-transform-es2015-spread-6.22.0.tgz",integrity:"sha1-1taKmfia7cRTbIGlQujdnxdG+NE=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-sticky-regex":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-sticky-regex/-/babel-plugin-transform-es2015-sticky-regex-6.24.1.tgz",integrity:"sha1-AMHNsaynERLN8M9hJsLta0V8zbw=",requires:{"babel-helper-regex":"6.26.0","babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-plugin-transform-es2015-template-literals":{version:"6.22.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-template-literals/-/babel-plugin-transform-es2015-template-literals-6.22.0.tgz",integrity:"sha1-qEs0UPfp+PH2g51taH2oS7EjbY0=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-typeof-symbol":{version:"6.23.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-typeof-symbol/-/babel-plugin-transform-es2015-typeof-symbol-6.23.0.tgz",integrity:"sha1-3sCfHN3/lLUqxz1QXITfWdzOs3I=",requires:{"babel-runtime":"6.26.0"}},"babel-plugin-transform-es2015-unicode-regex":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-es2015-unicode-regex/-/babel-plugin-transform-es2015-unicode-regex-6.24.1.tgz",integrity:"sha1-04sS9C6nMj9yk4fxinxa4frrNek=",requires:{"babel-helper-regex":"6.26.0","babel-runtime":"6.26.0","regexpu-core":"2.0.0"}},"babel-plugin-transform-exponentiation-operator":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-exponentiation-operator/-/babel-plugin-transform-exponentiation-operator-6.24.1.tgz",integrity:"sha1-KrDJx/MJj6SJB3cruBP+QejeOg4=",requires:{"babel-helper-builder-binary-assignment-operator-visitor":"6.24.1","babel-plugin-syntax-exponentiation-operator":"6.13.0","babel-runtime":"6.26.0"}},"babel-plugin-transform-regenerator":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-plugin-transform-regenerator/-/babel-plugin-transform-regenerator-6.26.0.tgz",integrity:"sha1-4HA2lvveJ/Cj78rPi03KL3s6jy8=",requires:{"regenerator-transform":"0.10.1"}},"babel-plugin-transform-strict-mode":{version:"6.24.1",resolved:"https://registry.npmjs.org/babel-plugin-transform-strict-mode/-/babel-plugin-transform-strict-mode-6.24.1.tgz",integrity:"sha1-1fr3qleKZbvlkc9e2uBKDGcCB1g=",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0"}},"babel-preset-env":{version:"1.7.0",resolved:"https://registry.npmjs.org/babel-preset-env/-/babel-preset-env-1.7.0.tgz",integrity:"sha512-9OR2afuKDneX2/q2EurSftUYM0xGu4O2D9adAhVfADDhrYDaxXV0rBbevVYoY9n6nyX1PmQW/0jtpJvUNr9CHg==",requires:{"babel-plugin-check-es2015-constants":"6.22.0","babel-plugin-syntax-trailing-function-commas":"6.22.0","babel-plugin-transform-async-to-generator":"6.24.1","babel-plugin-transform-es2015-arrow-functions":"6.22.0","babel-plugin-transform-es2015-block-scoped-functions":"6.22.0","babel-plugin-transform-es2015-block-scoping":"6.26.0","babel-plugin-transform-es2015-classes":"6.24.1","babel-plugin-transform-es2015-computed-properties":"6.24.1","babel-plugin-transform-es2015-destructuring":"6.23.0","babel-plugin-transform-es2015-duplicate-keys":"6.24.1","babel-plugin-transform-es2015-for-of":"6.23.0","babel-plugin-transform-es2015-function-name":"6.24.1","babel-plugin-transform-es2015-literals":"6.22.0","babel-plugin-transform-es2015-modules-amd":"6.24.1","babel-plugin-transform-es2015-modules-commonjs":"6.26.2","babel-plugin-transform-es2015-modules-systemjs":"6.24.1","babel-plugin-transform-es2015-modules-umd":"6.24.1","babel-plugin-transform-es2015-object-super":"6.24.1","babel-plugin-transform-es2015-parameters":"6.24.1","babel-plugin-transform-es2015-shorthand-properties":"6.24.1","babel-plugin-transform-es2015-spread":"6.22.0","babel-plugin-transform-es2015-sticky-regex":"6.24.1","babel-plugin-transform-es2015-template-literals":"6.22.0","babel-plugin-transform-es2015-typeof-symbol":"6.23.0","babel-plugin-transform-es2015-unicode-regex":"6.24.1","babel-plugin-transform-exponentiation-operator":"6.24.1","babel-plugin-transform-regenerator":"6.26.0",browserslist:"3.2.8",invariant:"2.2.4",semver:"5.4.1"}},"babel-register":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-register/-/babel-register-6.26.0.tgz",integrity:"sha1-btAhFz4vy0htestFxgCahW9kcHE=",requires:{"babel-core":"6.26.3","babel-runtime":"6.26.0","core-js":"2.5.6","home-or-tmp":"2.0.0",lodash:"4.17.10",mkdirp:"0.5.1","source-map-support":"0.4.18"}},"babel-runtime":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-runtime/-/babel-runtime-6.26.0.tgz",integrity:"sha1-llxwWGaOgrVde/4E/yM3vItWR/4=",requires:{"core-js":"2.5.6","regenerator-runtime":"0.11.1"}},"babel-template":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-template/-/babel-template-6.26.0.tgz",integrity:"sha1-3gPi0WOWsGn0bdn/+FIfsaDjXgI=",requires:{"babel-runtime":"6.26.0","babel-traverse":"6.26.0","babel-types":"6.26.0",babylon:"6.18.0",lodash:"4.17.10"}},"babel-traverse":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-traverse/-/babel-traverse-6.26.0.tgz",integrity:"sha1-RqnL1+3MYsjlwGTi0tjQ9ANXZu4=",requires:{"babel-code-frame":"6.26.0","babel-messages":"6.23.0","babel-runtime":"6.26.0","babel-types":"6.26.0",babylon:"6.18.0",debug:"2.6.9",globals:"9.18.0",invariant:"2.2.4",lodash:"4.17.10"}},"babel-types":{version:"6.26.0",resolved:"https://registry.npmjs.org/babel-types/-/babel-types-6.26.0.tgz",integrity:"sha1-o7Bz+Uq0nrb6Vc1lInozQ4BjJJc=",requires:{"babel-runtime":"6.26.0",esutils:"2.0.2",lodash:"4.17.10","to-fast-properties":"1.0.3"}},babelify:{version:"7.3.0",resolved:"https://registry.npmjs.org/babelify/-/babelify-7.3.0.tgz",integrity:"sha1-qlau3nBn/XvVSWZu4W3ChQh+iOU=",requires:{"babel-core":"6.26.3","object-assign":"4.1.1"}},babylon:{version:"6.18.0",resolved:"https://registry.npmjs.org/babylon/-/babylon-6.18.0.tgz",integrity:"sha512-q/UEjfGJ2Cm3oKV71DJz9d25TPnq5rhBVL2Q4fA5wcC3jcrdn7+SssEybFIxwAvvP+YCsCYNKughoF33GxgycQ=="},backoff:{version:"2.5.0",resolved:"https://registry.npmjs.org/backoff/-/backoff-2.5.0.tgz",integrity:"sha1-9hbtqdPktmuMp/ynn2lXIsX44m8=",requires:{precond:"0.2.3"}},"balanced-match":{version:"1.0.0",resolved:"https://registry.npmjs.org/balanced-match/-/balanced-match-1.0.0.tgz",integrity:"sha1-ibTRmasr7kneFk6gK4nORi1xt2c="},"base-x":{version:"1.1.0",resolved:"https://registry.npmjs.org/base-x/-/base-x-1.1.0.tgz",integrity:"sha1-QtPXF0dPnqAiB/bRqh9CaRPut6w="},"base64-js":{version:"1.3.0",resolved:"https://registry.npmjs.org/base64-js/-/base64-js-1.3.0.tgz",integrity:"sha512-ccav/yGvoa80BQDljCxsmmQ3Xvx60/UpBIij5QN21W3wBi/hhIC9OoO+KLpu9IJTS9j4DRVJ3aDDF9cMSoa2lw=="},"bcrypt-pbkdf":{version:"1.0.1",resolved:"https://registry.npmjs.org/bcrypt-pbkdf/-/bcrypt-pbkdf-1.0.1.tgz",integrity:"sha1-Y7xdy2EzG5K8Bf1SiVPDNGKgb40=",optional:!0,requires:{tweetnacl:"0.14.5"}},bindings:{version:"1.3.0",resolved:"https://registry.npmjs.org/bindings/-/bindings-1.3.0.tgz",integrity:"sha512-DpLh5EzMR2kzvX1KIlVC0VkC3iZtHKTgdtZ0a3pglBZdaQFjt5S9g9xd1lE+YvXyfd6mtCeRnrUfOLYiTMlNSw=="},bip39:{version:"2.4.0",resolved:"https://registry.npmjs.org/bip39/-/bip39-2.4.0.tgz",integrity:"sha512-1++HywqIyPtWDo7gm4v0ylYbwkLvHkuwVSKbBlZBbTCP/mnkyrlARBny906VLAwxJbC5xw9EvuJasHFIZaIFMQ==",requires:{"create-hash":"1.2.0",pbkdf2:"3.0.16",randombytes:"2.0.6","safe-buffer":"5.1.2",unorm:"1.4.1"}},bip66:{version:"1.1.5",resolved:"https://registry.npmjs.org/bip66/-/bip66-1.1.5.tgz",integrity:"sha1-AfqHSHhcpwlV1QESF9GzE5lpyiI=",requires:{"safe-buffer":"5.1.2"}},bl:{version:"0.8.2",resolved:"https://registry.npmjs.org/bl/-/bl-0.8.2.tgz",integrity:"sha1-yba8oI0bwuoA/Ir7Txpf0eHGbk4=",requires:{"readable-stream":"1.0.34"},dependencies:{"readable-stream":{version:"1.0.34",resolved:"https://registry.npmjs.org/readable-stream/-/readable-stream-1.0.34.tgz",integrity:"sha1-Elgg40vIQtLyqq+v5MKRbuMsFXw=",requires:{"core-util-is":"1.0.2",inherits:"2.0.3",isarray:"0.0.1",string_decoder:"0.10.31"}}}},"block-stream":{version:"0.0.9",resolved:"https://registry.npmjs.org/block-stream/-/block-stream-0.0.9.tgz",integrity:"sha1-E+v+d4oDIFz+A3UUgeu0szAMEmo=",requires:{inherits:"2.0.3"}},bluebird:{version:"3.5.1",resolved:"https://registry.npmjs.org/bluebird/-/bluebird-3.5.1.tgz",integrity:"sha512-MKiLiV+I1AA596t9w1sQJ8jkiSr5+ZKi0WKrYGUn6d1Fx+Ij4tIj+m2WMQSGczs5jZVxV339chE8iwk6F64wjA=="},"bn.js":{version:"4.11.6",resolved:"https://registry.npmjs.org/bn.js/-/bn.js-4.11.6.tgz",integrity:"sha1-UzRK2xRhehP26N0s4okF0cC6MhU="},"body-parser":{version:"1.18.3",resolved:"https://registry.npmjs.org/body-parser/-/body-parser-1.18.3.tgz",integrity:"sha1-WykhmP/dVTs6DyDe0FkrlWlVyLQ=",requires:{bytes:"3.0.0","content-type":"1.0.4",debug:"2.6.9",depd:"1.1.2","http-errors":"1.6.3","iconv-lite":"0.4.23","on-finished":"2.3.0",qs:"6.5.2","raw-body":"2.3.3","type-is":"1.6.16"}},"brace-expansion":{version:"1.1.11",resolved:"https://registry.npmjs.org/brace-expansion/-/brace-expansion-1.1.11.tgz",integrity:"sha512-iCuPHDFgrHX7H2vEI/5xpz07zSHB00TpugqhmYtVmMO6518mCuRMoOYFldEBl0g187ufozdaHgWKcYFb61qGiA==",requires:{"balanced-match":"1.0.0","concat-map":"0.0.1"}},brorand:{version:"1.1.0",resolved:"https://registry.npmjs.org/brorand/-/brorand-1.1.0.tgz",integrity:"sha1-EsJe/kCkXjwyPrhnWgoM5XsiNx8="},"browser-stdout":{version:"1.3.1",resolved:"https://registry.npmjs.org/browser-stdout/-/browser-stdout-1.3.1.tgz",integrity:"sha512-qhAVI1+Av2X7qelOfAIYwXONood6XlZE/fXaBSmW/T5SzLAmCgzi+eiWE7fUvbHaeNBQH13UftjpXxsfLkMpgw==",dev:!0},"browserify-aes":{version:"1.2.0",resolved:"https://registry.npmjs.org/browserify-aes/-/browserify-aes-1.2.0.tgz",integrity:"sha512-+7CHXqGuspUn/Sl5aO7Ea0xWGAtETPXNSAjHo48JfLdPWcMng33Xe4znFvQweqc/uzk5zSOI3H52CYnjCfb5hA==",requires:{"buffer-xor":"1.0.3","cipher-base":"1.0.4","create-hash":"1.2.0",evp_bytestokey:"1.0.3",inherits:"2.0.3","safe-buffer":"5.1.2"}},"browserify-cipher":{version:"1.0.1",resolved:"https://registry.npmjs.org/browserify-cipher/-/browserify-cipher-1.0.1.tgz",integrity:"sha512-sPhkz0ARKbf4rRQt2hTpAHqn47X3llLkUGn+xEJzLjwY8LRs2p0v7ljvI5EyoRO/mexrNunNECisZs+gw2zz1w==",requires:{"browserify-aes":"1.2.0","browserify-des":"1.0.1",evp_bytestokey:"1.0.3"}},"browserify-des":{version:"1.0.1",resolved:"https://registry.npmjs.org/browserify-des/-/browserify-des-1.0.1.tgz",integrity:"sha512-zy0Cobe3hhgpiOM32Tj7KQ3Vl91m0njwsjzZQK1L+JDf11dzP9qIvjreVinsvXrgfjhStXwUWAEpB9D7Gwmayw==",requires:{"cipher-base":"1.0.4","des.js":"1.0.0",inherits:"2.0.3"}},"browserify-rsa":{version:"4.0.1",resolved:"https://registry.npmjs.org/browserify-rsa/-/browserify-rsa-4.0.1.tgz",integrity:"sha1-IeCr+vbyApzy+vsTNWenAdQTVSQ=",requires:{"bn.js":"4.11.6",randombytes:"2.0.6"}},"browserify-sha3":{version:"0.0.1",resolved:"https://registry.npmjs.org/browserify-sha3/-/browserify-sha3-0.0.1.tgz",integrity:"sha1-P/NKMAbvFcD7NWflQbkaI0ASPRE=",requires:{"js-sha3":"0.3.1"}},"browserify-sign":{version:"4.0.4",resolved:"https://registry.npmjs.org/browserify-sign/-/browserify-sign-4.0.4.tgz",integrity:"sha1-qk62jl17ZYuqa/alfmMMvXqT0pg=",requires:{"bn.js":"4.11.6","browserify-rsa":"4.0.1","create-hash":"1.2.0","create-hmac":"1.1.7",elliptic:"6.4.0",inherits:"2.0.3","parse-asn1":"5.1.1"}},browserslist:{version:"3.2.8",resolved:"https://registry.npmjs.org/browserslist/-/browserslist-3.2.8.tgz",integrity:"sha512-WHVocJYavUwVgVViC0ORikPHQquXwVh939TaelZ4WDqpWgTX/FsGhl/+P4qBUAGcRvtOgDgC+xftNWWp2RUTAQ==",requires:{"caniuse-lite":"1.0.30000850","electron-to-chromium":"1.3.47"}},bs58:{version:"3.1.0",resolved:"https://registry.npmjs.org/bs58/-/bs58-3.1.0.tgz",integrity:"sha1-1MJjiL9IBMrHFBQbGUWqR+XrJI4=",requires:{"base-x":"1.1.0"}},bs58check:{version:"1.3.4",resolved:"https://registry.npmjs.org/bs58check/-/bs58check-1.3.4.tgz",integrity:"sha1-xSVABzdJEXcU+gQsMEfrj5FRy/g=",requires:{bs58:"3.1.0","create-hash":"1.2.0"}},buffer:{version:"5.1.0",resolved:"https://registry.npmjs.org/buffer/-/buffer-5.1.0.tgz",integrity:"sha512-YkIRgwsZwJWTnyQrsBTWefizHh+8GYj3kbL1BTiAQ/9pwpino0G7B2gp5tx/FUBqUlvtxV85KNR3mwfAtv15Yw==",requires:{"base64-js":"1.3.0",ieee754:"1.1.11"}},"buffer-alloc":{version:"1.1.0",resolved:"https://registry.npmjs.org/buffer-alloc/-/buffer-alloc-1.1.0.tgz",integrity:"sha1-BVFNM78WVtNUDGhPZbEgLpDsowM=",requires:{"buffer-alloc-unsafe":"0.1.1","buffer-fill":"0.1.1"}},"buffer-alloc-unsafe":{version:"0.1.1",resolved:"https://registry.npmjs.org/buffer-alloc-unsafe/-/buffer-alloc-unsafe-0.1.1.tgz",integrity:"sha1-/+H2dVHdBVc33iUzN7/oU9+rGmo="},"buffer-crc32":{version:"0.2.13",resolved:"https://registry.npmjs.org/buffer-crc32/-/buffer-crc32-0.2.13.tgz",integrity:"sha1-DTM+PwDqxQqhRUq9MO+MKl2ackI="},"buffer-fill":{version:"0.1.1",resolved:"https://registry.npmjs.org/buffer-fill/-/buffer-fill-0.1.1.tgz",integrity:"sha512-YgBMBzdRLEfgxJIGu2wrvI2E03tMCFU1p7d1KhB4BOoMN0VxmTFjSyN5JtKt9z8Z9JajMHruI6SE25W96wNv7Q=="},"buffer-from":{version:"0.1.2",resolved:"https://registry.npmjs.org/buffer-from/-/buffer-from-0.1.2.tgz",integrity:"sha512-RiWIenusJsmI2KcvqQABB83tLxCByE3upSP8QU3rJDMVFGPWLvPQJt/O1Su9moRWeH7d+Q2HYb68f6+v+tw2vg=="},"buffer-to-arraybuffer":{version:"0.0.5",resolved:"https://registry.npmjs.org/buffer-to-arraybuffer/-/buffer-to-arraybuffer-0.0.5.tgz",integrity:"sha1-YGSkD6dutDxyOrqe+PbhIW0QURo="},"buffer-xor":{version:"1.0.3",resolved:"https://registry.npmjs.org/buffer-xor/-/buffer-xor-1.0.3.tgz",integrity:"sha1-JuYe0UIvtw3ULm42cp7VHYVf6Nk="},"builtin-modules":{version:"1.1.1",resolved:"https://registry.npmjs.org/builtin-modules/-/builtin-modules-1.1.1.tgz",integrity:"sha1-Jw8HbFpywC9bZaR9+Uxf46J4iS8="},bytes:{version:"3.0.0",resolved:"https://registry.npmjs.org/bytes/-/bytes-3.0.0.tgz",integrity:"sha1-0ygVQE1olpn4Wk6k+odV3ROpYEg="},bytewise:{version:"1.1.0",resolved:"https://registry.npmjs.org/bytewise/-/bytewise-1.1.0.tgz",integrity:"sha1-HRPL/3F65xWAlKqIGzXQgbOHJT4=",requires:{"bytewise-core":"1.2.3",typewise:"1.0.3"}},"bytewise-core":{version:"1.2.3",resolved:"https://registry.npmjs.org/bytewise-core/-/bytewise-core-1.2.3.tgz",integrity:"sha1-P7QQx+kVWOsasiqCg0V3qmvWHUI=",requires:{"typewise-core":"1.2.0"}},cachedown:{version:"1.0.0",resolved:"https://registry.npmjs.org/cachedown/-/cachedown-1.0.0.tgz",integrity:"sha1-1D8DbkUQaWsxJG19sx6/D3rDLRU=",requires:{"abstract-leveldown":"2.7.2","lru-cache":"3.2.0"},dependencies:{"abstract-leveldown":{version:"2.7.2",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-2.7.2.tgz",integrity:"sha512-+OVvxH2rHVEhWLdbudP6p0+dNMXu8JA1CbhP19T8paTYAcX7oJ4OVjT+ZUVpv7mITxXHqDMej+GdqXBmXkw09w==",requires:{xtend:"4.0.1"}}}},camelcase:{version:"3.0.0",resolved:"https://registry.npmjs.org/camelcase/-/camelcase-3.0.0.tgz",integrity:"sha1-MvxLn82vhF/N9+c7uXysImHwqwo="},"caniuse-lite":{version:"1.0.30000850",resolved:"https://registry.npmjs.org/caniuse-lite/-/caniuse-lite-1.0.30000850.tgz",integrity:"sha512-iHK48UR/InydhpPAzgSmsJXRAR925T0kwJhZ1wk0xRatpGMvi2f06LABg6HXfV4WW4P2wChzlcFa/TEmbTyXQA=="},caseless:{version:"0.12.0",resolved:"https://registry.npmjs.org/caseless/-/caseless-0.12.0.tgz",integrity:"sha1-G2gcIf+EAzyCZUMJBolCDRhxUdw="},chai:{version:"3.5.0",resolved:"https://registry.npmjs.org/chai/-/chai-3.5.0.tgz",integrity:"sha1-TQJjewZ/6Vi9v906QOxW/vc3Mkc=",requires:{"assertion-error":"1.1.0","deep-eql":"0.1.3","type-detect":"1.0.0"}},chalk:{version:"1.1.3",resolved:"https://registry.npmjs.org/chalk/-/chalk-1.1.3.tgz",integrity:"sha1-qBFcVeSnAv5NFQq9OHKCKn4J/Jg=",requires:{"ansi-styles":"2.2.1","escape-string-regexp":"1.0.5","has-ansi":"2.0.0","strip-ansi":"3.0.1","supports-color":"2.0.0"}},"checkpoint-store":{version:"1.1.0",resolved:"https://registry.npmjs.org/checkpoint-store/-/checkpoint-store-1.1.0.tgz",integrity:"sha1-BOTLUWuRQziTWB5tRgGnjpVS6gY=",requires:{"functional-red-black-tree":"1.0.1"}},"cipher-base":{version:"1.0.4",resolved:"https://registry.npmjs.org/cipher-base/-/cipher-base-1.0.4.tgz",integrity:"sha512-Kkht5ye6ZGmwv40uUDZztayT2ThLQGfnj/T71N/XzeZeo3nf8foyW7zGTsPYkEya3m5f3cAypH+qe7YOrM1U2Q==",requires:{inherits:"2.0.3","safe-buffer":"5.1.2"}},cliui:{version:"3.2.0",resolved:"https://registry.npmjs.org/cliui/-/cliui-3.2.0.tgz",integrity:"sha1-EgYBU3qRbSmUD5NNo7SNWFo5IT0=",requires:{"string-width":"1.0.2","strip-ansi":"3.0.1","wrap-ansi":"2.1.0"}},clone:{version:"2.1.1",resolved:"https://registry.npmjs.org/clone/-/clone-2.1.1.tgz",integrity:"sha1-0hfR6WERjjrJpLi7oyhVU79kfNs="},co:{version:"4.6.0",resolved:"https://registry.npmjs.org/co/-/co-4.6.0.tgz",integrity:"sha1-bqa989hTrlTMuOR7+gvz+QMfsYQ="},"code-point-at":{version:"1.1.0",resolved:"https://registry.npmjs.org/code-point-at/-/code-point-at-1.1.0.tgz",integrity:"sha1-DQcLTQQ6W+ozovGkDi7bPZpMz3c="},coinstring:{version:"2.3.0",resolved:"https://registry.npmjs.org/coinstring/-/coinstring-2.3.0.tgz",integrity:"sha1-zbYzY6lhUCQEolr7gsLibV/2J6Q=",requires:{bs58:"2.0.1","create-hash":"1.2.0"},dependencies:{bs58:{version:"2.0.1",resolved:"https://registry.npmjs.org/bs58/-/bs58-2.0.1.tgz",integrity:"sha1-VZCNWPGYKrogCPob7Y+RmYopv40="}}},"combined-stream":{version:"1.0.6",resolved:"https://registry.npmjs.org/combined-stream/-/combined-stream-1.0.6.tgz",integrity:"sha1-cj599ugBrFYTETp+RFqbactjKBg=",requires:{"delayed-stream":"1.0.0"}},commander:{version:"2.8.1",resolved:"https://registry.npmjs.org/commander/-/commander-2.8.1.tgz",integrity:"sha1-Br42f+v9oMMwqh4qBy09yXYkJdQ=",requires:{"graceful-readlink":"1.0.1"}},"concat-map":{version:"0.0.1",resolved:"https://registry.npmjs.org/concat-map/-/concat-map-0.0.1.tgz",integrity:"sha1-2Klr13/Wjfd5OnMDajug1UBdR3s="},"concat-stream":{version:"1.6.2",resolved:"https://registry.npmjs.org/concat-stream/-/concat-stream-1.6.2.tgz",integrity:"sha512-27HBghJxjiZtIk3Ycvn/4kbJk/1uZuJFfuPEns6LaEvpvG1f0hTea8lilrouyo9mVc2GWdcEZ8OLoGmSADlrCw==",requires:{"buffer-from":"1.1.0",inherits:"2.0.3","readable-stream":"2.3.6",typedarray:"0.0.6"},dependencies:{"buffer-from":{version:"1.1.0",resolved:"https://registry.npmjs.org/buffer-from/-/buffer-from-1.1.0.tgz",integrity:"sha512-c5mRlguI/Pe2dSZmpER62rSCu0ryKmWddzRYsuXc50U2/g8jMOulc31VZMa4mYx31U5xsmSOpDCgH88Vl9cDGQ=="}}},"content-disposition":{version:"0.5.2",resolved:"https://registry.npmjs.org/content-disposition/-/content-disposition-0.5.2.tgz",integrity:"sha1-DPaLud318r55YcOoUXjLhdunjLQ="},"content-type":{version:"1.0.4",resolved:"https://registry.npmjs.org/content-type/-/content-type-1.0.4.tgz",integrity:"sha512-hIP3EEPs8tB9AT1L+NUqtwOAps4mk2Zob89MWXMHjHWg9milF/j4osnnQLXBCBFBk/tvIG/tUc9mOUJiPBhPXA=="},"convert-source-map":{version:"1.5.1",resolved:"https://registry.npmjs.org/convert-source-map/-/convert-source-map-1.5.1.tgz",integrity:"sha1-uCeAl7m8IpNl3lxiz1/K7YtVmeU="},cookie:{version:"0.3.1",resolved:"https://registry.npmjs.org/cookie/-/cookie-0.3.1.tgz",integrity:"sha1-5+Ch+e9DtMi6klxcWpboBtFoc7s="},"cookie-signature":{version:"1.0.6",resolved:"https://registry.npmjs.org/cookie-signature/-/cookie-signature-1.0.6.tgz",integrity:"sha1-4wOogrNCzD7oylE6eZmXNNqzriw="},"core-js":{version:"2.5.6",resolved:"https://registry.npmjs.org/core-js/-/core-js-2.5.6.tgz",integrity:"sha512-lQUVfQi0aLix2xpyjrrJEvfuYCqPc/HwmTKsC/VNf8q0zsjX7SQZtp4+oRONN5Tsur9GDETPjj+Ub2iDiGZfSQ=="},"core-util-is":{version:"1.0.2",resolved:"https://registry.npmjs.org/core-util-is/-/core-util-is-1.0.2.tgz",integrity:"sha1-tf1UIgqivFq1eqtxQMlAdUUDwac="},cors:{version:"2.8.4",resolved:"https://registry.npmjs.org/cors/-/cors-2.8.4.tgz",integrity:"sha1-K9OB8usgECAQXNUOpZ2mMJBpRoY=",requires:{"object-assign":"4.1.1",vary:"1.1.2"}},"create-ecdh":{version:"4.0.3",resolved:"https://registry.npmjs.org/create-ecdh/-/create-ecdh-4.0.3.tgz",integrity:"sha512-GbEHQPMOswGpKXM9kCWVrremUcBmjteUaQ01T9rkKCPDXfUHX0IoP9LpHYo2NPFampa4e+/pFDc3jQdxrxQLaw==",requires:{"bn.js":"4.11.6",elliptic:"6.4.0"}},"create-hash":{version:"1.2.0",resolved:"https://registry.npmjs.org/create-hash/-/create-hash-1.2.0.tgz",integrity:"sha512-z00bCGNHDG8mHAkP7CtT1qVu+bFQUPjYq/4Iv3C3kWjTFV10zIjfSoeqXo9Asws8gwSHDGj/hl2u4OGIjapeCg==",requires:{"cipher-base":"1.0.4",inherits:"2.0.3","md5.js":"1.3.4",ripemd160:"2.0.2","sha.js":"2.4.11"}},"create-hmac":{version:"1.1.7",resolved:"https://registry.npmjs.org/create-hmac/-/create-hmac-1.1.7.tgz",integrity:"sha512-MJG9liiZ+ogc4TzUwuvbER1JRdgvUFSB5+VR/g5h82fGaIRWMWddtKBHi7/sVhfjQZ6SehlyhvQYrcYkaUIpLg==",requires:{"cipher-base":"1.0.4","create-hash":"1.2.0",inherits:"2.0.3",ripemd160:"2.0.2","safe-buffer":"5.1.2","sha.js":"2.4.11"}},"cross-fetch":{version:"2.2.1",resolved:"https://registry.npmjs.org/cross-fetch/-/cross-fetch-2.2.1.tgz",integrity:"sha1-lshZEE113vyWf7XbYkdOdUJrArA=",requires:{"node-fetch":"2.1.2","whatwg-fetch":"2.0.4"}},"crypto-browserify":{version:"3.12.0",resolved:"https://registry.npmjs.org/crypto-browserify/-/crypto-browserify-3.12.0.tgz",integrity:"sha512-fz4spIh+znjO2VjL+IdhEpRJ3YN6sMzITSBijk6FK2UvTqruSQW+/cCZTSNsMiZNvUeq0CqurF+dAbyiGOY6Wg==",requires:{"browserify-cipher":"1.0.1","browserify-sign":"4.0.4","create-ecdh":"4.0.3","create-hash":"1.2.0","create-hmac":"1.1.7","diffie-hellman":"5.0.3",inherits:"2.0.3",pbkdf2:"3.0.16","public-encrypt":"4.0.2",randombytes:"2.0.6",randomfill:"1.0.4"}},d64:{version:"1.0.0",resolved:"https://registry.npmjs.org/d64/-/d64-1.0.0.tgz",integrity:"sha1-QAKofoUMv8n52XBrYPymE6MzbpA="},dashdash:{version:"1.14.1",resolved:"https://registry.npmjs.org/dashdash/-/dashdash-1.14.1.tgz",integrity:"sha1-hTz6D3y+L+1d4gMmuN1YEDX24vA=",requires:{"assert-plus":"1.0.0"}},debug:{version:"2.6.9",resolved:"https://registry.npmjs.org/debug/-/debug-2.6.9.tgz",integrity:"sha512-bC7ElrdJaJnPbAP+1EotYvqZsb3ecl5wi6Bfi6BJTUcNowp6cvspg0jXznRTKDjm/E7AdgFBVeAPVMNcKGsHMA==",requires:{ms:"2.0.0"}},decamelize:{version:"1.2.0",resolved:"https://registry.npmjs.org/decamelize/-/decamelize-1.2.0.tgz",integrity:"sha1-9lNNFRSCabIDUue+4m9QH5oZEpA="},"decode-uri-component":{version:"0.2.0",resolved:"https://registry.npmjs.org/decode-uri-component/-/decode-uri-component-0.2.0.tgz",integrity:"sha1-6zkTMzRYd1y4TNGh+uBiEGu4dUU="},decompress:{version:"4.2.0",resolved:"https://registry.npmjs.org/decompress/-/decompress-4.2.0.tgz",integrity:"sha1-eu3YVCflqS2s/lVnSnxQXpbQH50=",requires:{"decompress-tar":"4.1.1","decompress-tarbz2":"4.1.1","decompress-targz":"4.1.1","decompress-unzip":"4.0.1","graceful-fs":"4.1.11","make-dir":"1.3.0",pify:"2.3.0","strip-dirs":"2.1.0"},dependencies:{pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="}}},"decompress-response":{version:"3.3.0",resolved:"https://registry.npmjs.org/decompress-response/-/decompress-response-3.3.0.tgz",integrity:"sha1-gKTdMjdIOEv6JICDYirt7Jgq3/M=",requires:{"mimic-response":"1.0.0"}},"decompress-tar":{version:"4.1.1",resolved:"https://registry.npmjs.org/decompress-tar/-/decompress-tar-4.1.1.tgz",integrity:"sha512-JdJMaCrGpB5fESVyxwpCx4Jdj2AagLmv3y58Qy4GE6HMVjWz1FeVQk1Ct4Kye7PftcdOo/7U7UKzYBJgqnGeUQ==",requires:{"file-type":"5.2.0","is-stream":"1.1.0","tar-stream":"1.6.1"}},"decompress-tarbz2":{version:"4.1.1",resolved:"https://registry.npmjs.org/decompress-tarbz2/-/decompress-tarbz2-4.1.1.tgz",integrity:"sha512-s88xLzf1r81ICXLAVQVzaN6ZmX4A6U4z2nMbOwobxkLoIIfjVMBg7TeguTUXkKeXni795B6y5rnvDw7rxhAq9A==",requires:{"decompress-tar":"4.1.1","file-type":"6.2.0","is-stream":"1.1.0","seek-bzip":"1.0.5","unbzip2-stream":"1.2.5"},dependencies:{"file-type":{version:"6.2.0",resolved:"https://registry.npmjs.org/file-type/-/file-type-6.2.0.tgz",integrity:"sha512-YPcTBDV+2Tm0VqjybVd32MHdlEGAtuxS3VAYsumFokDSMG+ROT5wawGlnHDoz7bfMcMDt9hxuXvXwoKUx2fkOg=="}}},"decompress-targz":{version:"4.1.1",resolved:"https://registry.npmjs.org/decompress-targz/-/decompress-targz-4.1.1.tgz",integrity:"sha512-4z81Znfr6chWnRDNfFNqLwPvm4db3WuZkqV+UgXQzSngG3CEKdBkw5jrv3axjjL96glyiiKjsxJG3X6WBZwX3w==",requires:{"decompress-tar":"4.1.1","file-type":"5.2.0","is-stream":"1.1.0"}},"decompress-unzip":{version:"4.0.1",resolved:"https://registry.npmjs.org/decompress-unzip/-/decompress-unzip-4.0.1.tgz",integrity:"sha1-3qrM39FK6vhVePczroIQ+bSEj2k=",requires:{"file-type":"3.9.0","get-stream":"2.3.1",pify:"2.3.0",yauzl:"2.9.1"},dependencies:{"file-type":{version:"3.9.0",resolved:"https://registry.npmjs.org/file-type/-/file-type-3.9.0.tgz",integrity:"sha1-JXoHg4TR24CHvESdEH1SpSZyuek="},"get-stream":{version:"2.3.1",resolved:"https://registry.npmjs.org/get-stream/-/get-stream-2.3.1.tgz",integrity:"sha1-Xzj5PzRgCWZu4BUKBUFn+Rvdld4=",requires:{"object-assign":"4.1.1","pinkie-promise":"2.0.1"}},pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="}}},"deep-eql":{version:"0.1.3",resolved:"https://registry.npmjs.org/deep-eql/-/deep-eql-0.1.3.tgz",integrity:"sha1-71WKyrjeJSBs1xOQbXTlaTDrafI=",requires:{"type-detect":"0.1.1"},dependencies:{"type-detect":{version:"0.1.1",resolved:"https://registry.npmjs.org/type-detect/-/type-detect-0.1.1.tgz",integrity:"sha1-C6XsKohWQORw6k6FBZcZANrFiCI="}}},"deep-equal":{version:"1.0.1",resolved:"https://registry.npmjs.org/deep-equal/-/deep-equal-1.0.1.tgz",integrity:"sha1-9dJgKStmDghO/0zbyfCK0yR0SLU="},"deferred-leveldown":{version:"1.2.2",resolved:"https://registry.npmjs.org/deferred-leveldown/-/deferred-leveldown-1.2.2.tgz",integrity:"sha512-uukrWD2bguRtXilKt6cAWKyoXrTSMo5m7crUdLfWQmu8kIm88w3QZoUL+6nhpfKVmhHANER6Re3sKoNoZ3IKMA==",requires:{"abstract-leveldown":"2.6.3"},dependencies:{"abstract-leveldown":{version:"2.6.3",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-2.6.3.tgz",integrity:"sha512-2++wDf/DYqkPR3o5tbfdhF96EfMApo1GpPfzOsR/ZYXdkSmELlvOOEAl9iKkRsktMPHdGjO4rtkBpf2I7TiTeA==",requires:{xtend:"4.0.1"}}}},"define-properties":{version:"1.1.2",resolved:"https://registry.npmjs.org/define-properties/-/define-properties-1.1.2.tgz",integrity:"sha1-g6c/L+pWmJj7c3GTyPhzyvbUXJQ=",requires:{foreach:"2.0.5","object-keys":"1.0.11"},dependencies:{"object-keys":{version:"1.0.11",resolved:"https://registry.npmjs.org/object-keys/-/object-keys-1.0.11.tgz",integrity:"sha1-xUYBd4rVYPEULODgG8yotW0TQm0="}}},defined:{version:"1.0.0",resolved:"https://registry.npmjs.org/defined/-/defined-1.0.0.tgz",integrity:"sha1-yY2bzvdWdBiOEQlpFRGZ45sfppM="},"delayed-stream":{version:"1.0.0",resolved:"https://registry.npmjs.org/delayed-stream/-/delayed-stream-1.0.0.tgz",integrity:"sha1-3zrhmayt+31ECqrgsp4icrJOxhk="},depd:{version:"1.1.2",resolved:"https://registry.npmjs.org/depd/-/depd-1.1.2.tgz",integrity:"sha1-m81S4UwJd2PnSbJ0xDRu0uVgtak="},"des.js":{version:"1.0.0",resolved:"https://registry.npmjs.org/des.js/-/des.js-1.0.0.tgz",integrity:"sha1-wHTS4qpqipoH29YfmhXCzYPsjsw=",requires:{inherits:"2.0.3","minimalistic-assert":"1.0.1"}},destroy:{version:"1.0.4",resolved:"https://registry.npmjs.org/destroy/-/destroy-1.0.4.tgz",integrity:"sha1-l4hXRCxEdJ5CBmE+N5RiBYJqvYA="},"detect-indent":{version:"4.0.0",resolved:"https://registry.npmjs.org/detect-indent/-/detect-indent-4.0.0.tgz",integrity:"sha1-920GQ1LN9Docts5hnE7jqUdd4gg=",requires:{repeating:"2.0.1"}},diff:{version:"3.5.0",resolved:"https://registry.npmjs.org/diff/-/diff-3.5.0.tgz",integrity:"sha512-A46qtFgd+g7pDZinpnwiRJtxbC1hpgf0uzP3iG89scHk0AUC7A1TGxf5OiiOUv/JMZR8GOt8hL900hV0bOy5xA==",dev:!0},"diffie-hellman":{version:"5.0.3",resolved:"https://registry.npmjs.org/diffie-hellman/-/diffie-hellman-5.0.3.tgz",integrity:"sha512-kqag/Nl+f3GwyK25fhUMYj81BUOrZ9IuJsjIcDE5icNM9FJHAVm3VcUDxdLPoQtTuUylWm6ZIknYJwwaPxsUzg==",requires:{"bn.js":"4.11.6","miller-rabin":"4.0.1",randombytes:"2.0.6"}},"dom-walk":{version:"0.1.1",resolved:"https://registry.npmjs.org/dom-walk/-/dom-walk-0.1.1.tgz",integrity:"sha1-ZyIm3HTI95mtNTB9+TaroRrNYBg="},"drbg.js":{version:"1.0.1",resolved:"https://registry.npmjs.org/drbg.js/-/drbg.js-1.0.1.tgz",integrity:"sha1-Pja2xCs3BDgjzbwzLVjzHiRFSAs=",requires:{"browserify-aes":"1.2.0","create-hash":"1.2.0","create-hmac":"1.1.7"}},duplexer3:{version:"0.1.4",resolved:"https://registry.npmjs.org/duplexer3/-/duplexer3-0.1.4.tgz",integrity:"sha1-7gHdHKwO08vH/b6jfcCo8c4ALOI="},"ecc-jsbn":{version:"0.1.1",resolved:"https://registry.npmjs.org/ecc-jsbn/-/ecc-jsbn-0.1.1.tgz",integrity:"sha1-D8c6ntXw1Tw4GTOYUj735UN3dQU=",optional:!0,requires:{jsbn:"0.1.1"}},"ee-first":{version:"1.1.1",resolved:"https://registry.npmjs.org/ee-first/-/ee-first-1.1.1.tgz",integrity:"sha1-WQxhFWsK4vTwJVcyoViyZrxWsh0="},"electron-to-chromium":{version:"1.3.47",resolved:"https://registry.npmjs.org/electron-to-chromium/-/electron-to-chromium-1.3.47.tgz",integrity:"sha1-dk6IfKkQTQGgrI6r7n38DizhQQQ="},elliptic:{version:"6.4.0",resolved:"https://registry.npmjs.org/elliptic/-/elliptic-6.4.0.tgz",integrity:"sha1-ysmvh2LIWDYYcAPI3+GT5eLq5d8=",requires:{"bn.js":"4.11.6",brorand:"1.1.0","hash.js":"1.1.3","hmac-drbg":"1.0.1",inherits:"2.0.3","minimalistic-assert":"1.0.1","minimalistic-crypto-utils":"1.0.1"}},encodeurl:{version:"1.0.2",resolved:"https://registry.npmjs.org/encodeurl/-/encodeurl-1.0.2.tgz",integrity:"sha1-rT/0yG7C0CkyL1oCw6mmBslbP1k="},encoding:{version:"0.1.12",resolved:"https://registry.npmjs.org/encoding/-/encoding-0.1.12.tgz",integrity:"sha1-U4tm8+5izRq1HsMjgp0flIDHS+s=",requires:{"iconv-lite":"0.4.23"}},"end-of-stream":{version:"1.4.1",resolved:"https://registry.npmjs.org/end-of-stream/-/end-of-stream-1.4.1.tgz",integrity:"sha512-1MkrZNvWTKCaigbn+W15elq2BB/L22nqrSY5DKlo3X6+vclJm8Bb5djXJBmEX6fS3+zCh/F4VBK5Z2KxJt4s2Q==",requires:{once:"1.4.0"}},errno:{version:"0.1.7",resolved:"https://registry.npmjs.org/errno/-/errno-0.1.7.tgz",integrity:"sha512-MfrRBDWzIWifgq6tJj60gkAwtLNb6sQPlcFrSOflcP1aFmmruKQ2wRnze/8V6kgyz7H3FF8Npzv78mZ7XLLflg==",requires:{prr:"1.0.1"}},"error-ex":{version:"1.3.1",resolved:"https://registry.npmjs.org/error-ex/-/error-ex-1.3.1.tgz",integrity:"sha1-+FWobOYa3E6GIcPNoh56dhLDqNw=",requires:{"is-arrayish":"0.2.1"}},"es-abstract":{version:"1.12.0",resolved:"https://registry.npmjs.org/es-abstract/-/es-abstract-1.12.0.tgz",integrity:"sha512-C8Fx/0jFmV5IPoMOFPA9P9G5NtqW+4cOPit3MIuvR2t7Ag2K15EJTpxnHAYTzL+aYQJIESYeXZmDBfOBE1HcpA==",requires:{"es-to-primitive":"1.1.1","function-bind":"1.1.1",has:"1.0.3","is-callable":"1.1.3","is-regex":"1.0.4"}},"es-to-primitive":{version:"1.1.1",resolved:"https://registry.npmjs.org/es-to-primitive/-/es-to-primitive-1.1.1.tgz",integrity:"sha1-RTVSSKiJeQNLZ5Lhm7gfK3l13Q0=",requires:{"is-callable":"1.1.3","is-date-object":"1.0.1","is-symbol":"1.0.1"}},"escape-html":{version:"1.0.3",resolved:"https://registry.npmjs.org/escape-html/-/escape-html-1.0.3.tgz",integrity:"sha1-Aljq5NPQwJdN4cFpGI7wBR0dGYg="},"escape-string-regexp":{version:"1.0.5",resolved:"https://registry.npmjs.org/escape-string-regexp/-/escape-string-regexp-1.0.5.tgz",integrity:"sha1-G2HAViGQqN/2rjuyzwIAyhMLhtQ="},esutils:{version:"2.0.2",resolved:"https://registry.npmjs.org/esutils/-/esutils-2.0.2.tgz",integrity:"sha1-Cr9PHKpbyx96nYrMbepPqqBLrJs="},etag:{version:"1.8.1",resolved:"https://registry.npmjs.org/etag/-/etag-1.8.1.tgz",integrity:"sha1-Qa4u62XvpiJorr/qg6x9eSmbCIc="},"eth-block-tracker":{version:"3.0.1",resolved:"https://registry.npmjs.org/eth-block-tracker/-/eth-block-tracker-3.0.1.tgz",integrity:"sha512-WUVxWLuhMmsfenfZvFO5sbl1qFY2IqUlw/FPVmjjdElpqLsZtSG+wPe9Dz7W/sB6e80HgFKknOmKk2eNlznHug==",requires:{"eth-query":"2.1.2","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethjs-util":"0.1.4","json-rpc-engine":"3.7.3",pify:"2.3.0",tape:"4.9.0"},dependencies:{pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="}}},"eth-json-rpc-infura":{version:"3.1.2",resolved:"https://registry.npmjs.org/eth-json-rpc-infura/-/eth-json-rpc-infura-3.1.2.tgz",integrity:"sha512-IuK5Iowfs6taluA/3Okmu6EfZcFMq6MQuyrUL1PrCoJstuuBr3TvVeSy3keDyxfbrjFB34nCo538I8G+qMtsbw==",requires:{"cross-fetch":"2.2.1","eth-json-rpc-middleware":"1.6.0","json-rpc-engine":"3.7.3","json-rpc-error":"2.0.0",tape:"4.9.0"}},"eth-json-rpc-middleware":{version:"1.6.0",resolved:"https://registry.npmjs.org/eth-json-rpc-middleware/-/eth-json-rpc-middleware-1.6.0.tgz",integrity:"sha512-tDVCTlrUvdqHKqivYMjtFZsdD7TtpNLBCfKAcOpaVs7orBMS/A8HWro6dIzNtTZIR05FAbJ3bioFOnZpuCew9Q==",requires:{async:"2.6.1","eth-query":"2.1.2","eth-tx-summary":"3.2.3","ethereumjs-block":"1.7.1","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethereumjs-vm":"2.3.5","fetch-ponyfill":"4.1.0","json-rpc-engine":"3.7.3","json-rpc-error":"2.0.0","json-stable-stringify":"1.0.1","promise-to-callback":"1.0.0",tape:"4.9.0"},dependencies:{"ethereum-common":{version:"0.2.0",resolved:"https://registry.npmjs.org/ethereum-common/-/ethereum-common-0.2.0.tgz",integrity:"sha512-XOnAR/3rntJgbCdGhqdaLIxDLWKLmsZOGhHdBKadEr6gEnJLH52k93Ou+TUdFaPN3hJc3isBZBal3U/XZ15abA=="},"ethereumjs-block":{version:"1.7.1",resolved:"https://registry.npmjs.org/ethereumjs-block/-/ethereumjs-block-1.7.1.tgz",integrity:"sha512-B+sSdtqm78fmKkBq78/QLKJbu/4Ts4P2KFISdgcuZUPDm9x+N7qgBPIIFUGbaakQh8bzuquiRVbdmvPKqbILRg==",requires:{async:"2.6.1","ethereum-common":"0.2.0","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","merkle-patricia-tree":"2.3.1"}}}},"eth-lib":{version:"0.1.27",resolved:"https://registry.npmjs.org/eth-lib/-/eth-lib-0.1.27.tgz",integrity:"sha512-B8czsfkJYzn2UIEMwjc7Mbj+Cy72V+/OXH/tb44LV8jhrjizQJJ325xMOMyk3+ETa6r6oi0jsUY14+om8mQMWA==",requires:{"bn.js":"4.11.6",elliptic:"6.4.0",keccakjs:"0.2.1","nano-json-stream-parser":"0.1.2",servify:"0.1.12",ws:"3.3.3","xhr-request-promise":"0.1.2"}},"eth-query":{version:"2.1.2",resolved:"https://registry.npmjs.org/eth-query/-/eth-query-2.1.2.tgz",integrity:"sha1-1nQdkAAQa1FRDHLbktY2VFam2l4=",requires:{"json-rpc-random-id":"1.0.1",xtend:"4.0.1"}},"eth-sig-util":{version:"2.0.2",resolved:"https://registry.npmjs.org/eth-sig-util/-/eth-sig-util-2.0.2.tgz",integrity:"sha512-tB6E8jf/aZQ943bo3+iojl8xRe3Jzcl+9OT6v8K7kWis6PdIX19SB2vYvN849cB9G9m/XLjYFK381SgdbsnpTA==",requires:{"ethereumjs-abi":"0.6.5","ethereumjs-util":"5.2.0"}},"eth-tx-summary":{version:"3.2.3",resolved:"https://registry.npmjs.org/eth-tx-summary/-/eth-tx-summary-3.2.3.tgz",integrity:"sha512-1gZpA5fKarJOVSb5OUlPnhDQuIazqAkI61zlVvf5LdG47nEgw+/qhyZnuj3CUdE/TLTKuRzPLeyXLjaB4qWTRQ==",requires:{async:"2.6.1","bn.js":"4.11.8",clone:"2.1.1","concat-stream":"1.6.2","end-of-stream":"1.4.1","eth-query":"2.1.2","ethereumjs-block":"1.7.1","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethereumjs-vm":"2.3.4",through2:"2.0.3",treeify:"1.1.0","web3-provider-engine":"13.8.0"},dependencies:{"async-eventemitter":{version:"github:ahultgren/async-eventemitter#fa06e39e56786ba541c180061dbf2c0a5bbf951c",requires:{async:"2.6.1"}},"bn.js":{version:"4.11.8",resolved:"https://registry.npmjs.org/bn.js/-/bn.js-4.11.8.tgz",integrity:"sha512-ItfYfPLkWHUjckQCk8xC+LwxgK8NYcXywGigJgSwOP8Y2iyWT4f2vsZnoOXTTbo+o5yXmIUJ4gn5538SO5S3gA=="},"eth-block-tracker":{version:"2.3.1",resolved:"https://registry.npmjs.org/eth-block-tracker/-/eth-block-tracker-2.3.1.tgz",integrity:"sha512-NamWuMBIl8kmkJFVj8WzGatySTzQPQag4Xr677yFxdVtIxACFbL/dQowk0MzEqIKk93U1TwY3MjVU6mOcwZnKA==",requires:{"async-eventemitter":"github:ahultgren/async-eventemitter#fa06e39e56786ba541c180061dbf2c0a5bbf951c","eth-query":"2.1.2","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethjs-util":"0.1.4","json-rpc-engine":"3.7.3",pify:"2.3.0",tape:"4.9.0"}},"eth-sig-util":{version:"1.4.2",resolved:"https://registry.npmjs.org/eth-sig-util/-/eth-sig-util-1.4.2.tgz",integrity:"sha1-jZWCAsftuq6Dlwf7pvCf8ydgYhA=",requires:{"ethereumjs-abi":"git+https://github.com/ethereumjs/ethereumjs-abi.git#00ba8463a7f7a67fcad737ff9c2ebd95643427f7","ethereumjs-util":"5.2.0"}},"ethereum-common":{version:"0.2.0",resolved:"https://registry.npmjs.org/ethereum-common/-/ethereum-common-0.2.0.tgz",integrity:"sha512-XOnAR/3rntJgbCdGhqdaLIxDLWKLmsZOGhHdBKadEr6gEnJLH52k93Ou+TUdFaPN3hJc3isBZBal3U/XZ15abA=="},"ethereumjs-abi":{version:"git+https://github.com/ethereumjs/ethereumjs-abi.git#00ba8463a7f7a67fcad737ff9c2ebd95643427f7",requires:{"bn.js":"4.11.8","ethereumjs-util":"5.2.0"}},"ethereumjs-block":{version:"1.7.1",resolved:"https://registry.npmjs.org/ethereumjs-block/-/ethereumjs-block-1.7.1.tgz",integrity:"sha512-B+sSdtqm78fmKkBq78/QLKJbu/4Ts4P2KFISdgcuZUPDm9x+N7qgBPIIFUGbaakQh8bzuquiRVbdmvPKqbILRg==",requires:{async:"2.6.1","ethereum-common":"0.2.0","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","merkle-patricia-tree":"2.3.1"}},"ethereumjs-vm":{version:"2.3.4",resolved:"https://registry.npmjs.org/ethereumjs-vm/-/ethereumjs-vm-2.3.4.tgz",integrity:"sha512-Y4SlzNDqxrCO58jhp98HdnZVdjOqB+HC0hoU+N/DEp1aU+hFkRX/nru5F7/HkQRPIlA6aJlQp/xIA6xZs1kspw==",requires:{async:"2.6.1","async-eventemitter":"github:ahultgren/async-eventemitter#fa06e39e56786ba541c180061dbf2c0a5bbf951c","ethereum-common":"0.2.0","ethereumjs-account":"2.0.5","ethereumjs-block":"1.7.1","ethereumjs-util":"5.2.0","fake-merkle-patricia-tree":"1.0.1","functional-red-black-tree":"1.0.1","merkle-patricia-tree":"2.3.1","rustbn.js":"0.1.2","safe-buffer":"5.1.2"}},pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="},"web3-provider-engine":{version:"13.8.0",resolved:"https://registry.npmjs.org/web3-provider-engine/-/web3-provider-engine-13.8.0.tgz",integrity:"sha512-fZXhX5VWwWpoFfrfocslyg6P7cN3YWPG/ASaevNfeO80R+nzgoPUBXcWQekSGSsNDkeRTis4aMmpmofYf1TNtQ==",requires:{async:"2.6.1",clone:"2.1.1","eth-block-tracker":"2.3.1","eth-sig-util":"1.4.2","ethereumjs-block":"1.7.1","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethereumjs-vm":"2.3.4","fetch-ponyfill":"4.1.0","json-rpc-error":"2.0.0","json-stable-stringify":"1.0.1","promise-to-callback":"1.0.0","readable-stream":"2.3.6",request:"2.87.0",semaphore:"1.1.0",solc:"0.4.24",tape:"4.9.0",xhr:"2.5.0",xtend:"4.0.1"}}}},"ethereum-common":{version:"0.0.16",resolved:"https://registry.npmjs.org/ethereum-common/-/ethereum-common-0.0.16.tgz",integrity:"sha1-mh4Wnq00q3XgifUMpRK/0PvRJlU="},"ethereumjs-abi":{version:"0.6.5",resolved:"https://registry.npmjs.org/ethereumjs-abi/-/ethereumjs-abi-0.6.5.tgz",integrity:"sha1-WmN+8Wq0NHP6cqKa2QhxQFs/UkE=",requires:{"bn.js":"4.11.6","ethereumjs-util":"4.5.0"},dependencies:{"ethereumjs-util":{version:"4.5.0",resolved:"https://registry.npmjs.org/ethereumjs-util/-/ethereumjs-util-4.5.0.tgz",integrity:"sha1-PpQosxfuvaPXJg2FT93alUsfG8Y=",requires:{"bn.js":"4.11.6","create-hash":"1.2.0",keccakjs:"0.2.1",rlp:"2.0.0",secp256k1:"3.5.0"}}}},"ethereumjs-account":{version:"2.0.5",resolved:"https://registry.npmjs.org/ethereumjs-account/-/ethereumjs-account-2.0.5.tgz",integrity:"sha512-bgDojnXGjhMwo6eXQC0bY6UK2liSFUSMwwylOmQvZbSl/D7NXQ3+vrGO46ZeOgjGfxXmgIeVNDIiHw7fNZM4VA==",requires:{"ethereumjs-util":"5.2.0",rlp:"2.0.0","safe-buffer":"5.1.2"}},"ethereumjs-block":{version:"1.2.2",resolved:"https://registry.npmjs.org/ethereumjs-block/-/ethereumjs-block-1.2.2.tgz",integrity:"sha1-LsdTSlkCG47JuDww5JaQxuuu3aE=",requires:{async:"1.5.2","ethereum-common":"0.0.16","ethereumjs-tx":"1.3.4","ethereumjs-util":"4.5.0","merkle-patricia-tree":"2.3.1"},dependencies:{async:{version:"1.5.2",resolved:"https://registry.npmjs.org/async/-/async-1.5.2.tgz",integrity:"sha1-7GphrlZIDAw8skHJVhjiCJL5Zyo="},"ethereumjs-util":{version:"4.5.0",resolved:"https://registry.npmjs.org/ethereumjs-util/-/ethereumjs-util-4.5.0.tgz",integrity:"sha1-PpQosxfuvaPXJg2FT93alUsfG8Y=",requires:{"bn.js":"4.11.6","create-hash":"1.2.0",keccakjs:"0.2.1",rlp:"2.0.0",secp256k1:"3.5.0"}}}},"ethereumjs-tx":{version:"1.3.4",resolved:"https://registry.npmjs.org/ethereumjs-tx/-/ethereumjs-tx-1.3.4.tgz",integrity:"sha512-kOgUd5jC+0tgV7t52UDECMMz9Uf+Lro+6fSpCvzWemtXfMEcwI3EOxf5mVPMRbTFkMMhuERokNNVF3jItAjidg==",requires:{"ethereum-common":"0.0.18","ethereumjs-util":"5.2.0"},dependencies:{"ethereum-common":{version:"0.0.18",resolved:"https://registry.npmjs.org/ethereum-common/-/ethereum-common-0.0.18.tgz",integrity:"sha1-L9w1dvIykDNYl26znaeDIT/5Uj8="}}},"ethereumjs-util":{version:"5.2.0",resolved:"https://registry.npmjs.org/ethereumjs-util/-/ethereumjs-util-5.2.0.tgz",integrity:"sha512-CJAKdI0wgMbQFLlLRtZKGcy/L6pzVRgelIZqRqNbuVFM3K9VEnyfbcvz0ncWMRNCe4kaHWjwRYQcYMucmwsnWA==",requires:{"bn.js":"4.11.6","create-hash":"1.2.0","ethjs-util":"0.1.4",keccak:"1.4.0",rlp:"2.0.0","safe-buffer":"5.1.2",secp256k1:"3.5.0"}},"ethereumjs-vm":{version:"2.3.5",resolved:"https://registry.npmjs.org/ethereumjs-vm/-/ethereumjs-vm-2.3.5.tgz",integrity:"sha512-AJ7x44+xqyE5+UO3Nns19WkTdZfyqFZ+sEjIEpvme7Ipbe3iBU1uwCcHEdiu/yY9bdhr3IfSa/NfIKNeXPaRVQ==",requires:{async:"2.6.1","async-eventemitter":"0.2.4","ethereum-common":"0.2.0","ethereumjs-account":"2.0.5","ethereumjs-block":"1.7.1","ethereumjs-util":"5.2.0","fake-merkle-patricia-tree":"1.0.1","functional-red-black-tree":"1.0.1","merkle-patricia-tree":"2.3.1","rustbn.js":"0.1.2","safe-buffer":"5.1.2"},dependencies:{"ethereum-common":{version:"0.2.0",resolved:"https://registry.npmjs.org/ethereum-common/-/ethereum-common-0.2.0.tgz",integrity:"sha512-XOnAR/3rntJgbCdGhqdaLIxDLWKLmsZOGhHdBKadEr6gEnJLH52k93Ou+TUdFaPN3hJc3isBZBal3U/XZ15abA=="},"ethereumjs-block":{version:"1.7.1",resolved:"https://registry.npmjs.org/ethereumjs-block/-/ethereumjs-block-1.7.1.tgz",integrity:"sha512-B+sSdtqm78fmKkBq78/QLKJbu/4Ts4P2KFISdgcuZUPDm9x+N7qgBPIIFUGbaakQh8bzuquiRVbdmvPKqbILRg==",requires:{async:"2.6.1","ethereum-common":"0.2.0","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","merkle-patricia-tree":"2.3.1"}}}},"ethereumjs-wallet":{version:"0.6.0",resolved:"https://registry.npmjs.org/ethereumjs-wallet/-/ethereumjs-wallet-0.6.0.tgz",integrity:"sha1-gnY7Fpfuenlr5xVdqd+0my+Yz9s=",requires:{"aes-js":"0.2.4",bs58check:"1.3.4","ethereumjs-util":"4.5.0",hdkey:"0.7.1","scrypt.js":"0.2.0",utf8:"2.1.2",uuid:"2.0.3"},dependencies:{"ethereumjs-util":{version:"4.5.0",resolved:"https://registry.npmjs.org/ethereumjs-util/-/ethereumjs-util-4.5.0.tgz",integrity:"sha1-PpQosxfuvaPXJg2FT93alUsfG8Y=",requires:{"bn.js":"4.11.6","create-hash":"1.2.0",keccakjs:"0.2.1",rlp:"2.0.0",secp256k1:"3.5.0"}}}},"ethjs-unit":{version:"0.1.6",resolved:"https://registry.npmjs.org/ethjs-unit/-/ethjs-unit-0.1.6.tgz",integrity:"sha1-xmWSHkduh7ziqdWIpv4EBbLEFpk=",requires:{"bn.js":"4.11.6","number-to-bn":"1.7.0"}},"ethjs-util":{version:"0.1.4",resolved:"https://registry.npmjs.org/ethjs-util/-/ethjs-util-0.1.4.tgz",integrity:"sha1-HItoeSV0RO9NPz+7rC3tEs2ZfZM=",requires:{"is-hex-prefixed":"1.0.0","strip-hex-prefix":"1.0.0"}},eventemitter3:{version:"1.1.1",resolved:"https://registry.npmjs.org/eventemitter3/-/eventemitter3-1.1.1.tgz",integrity:"sha1-R3hr2qCHyvext15zq8XH1UAVjNA="},evp_bytestokey:{version:"1.0.3",resolved:"https://registry.npmjs.org/evp_bytestokey/-/evp_bytestokey-1.0.3.tgz",integrity:"sha512-/f2Go4TognH/KvCISP7OUsHn85hT9nUkxxA9BEWxFn+Oj9o8ZNLm/40hdlgSLyuOimsrTKLUMEorQexp/aPQeA==",requires:{"md5.js":"1.3.4","safe-buffer":"5.1.2"}},express:{version:"4.16.3",resolved:"https://registry.npmjs.org/express/-/express-4.16.3.tgz",integrity:"sha1-avilAjUNsyRuzEvs9rWjTSL37VM=",requires:{accepts:"1.3.5","array-flatten":"1.1.1","body-parser":"1.18.2","content-disposition":"0.5.2","content-type":"1.0.4",cookie:"0.3.1","cookie-signature":"1.0.6",debug:"2.6.9",depd:"1.1.2",encodeurl:"1.0.2","escape-html":"1.0.3",etag:"1.8.1",finalhandler:"1.1.1",fresh:"0.5.2","merge-descriptors":"1.0.1",methods:"1.1.2","on-finished":"2.3.0",parseurl:"1.3.2","path-to-regexp":"0.1.7","proxy-addr":"2.0.3",qs:"6.5.1","range-parser":"1.2.0","safe-buffer":"5.1.1",send:"0.16.2","serve-static":"1.13.2",setprototypeof:"1.1.0",statuses:"1.4.0","type-is":"1.6.16","utils-merge":"1.0.1",vary:"1.1.2"},dependencies:{"body-parser":{version:"1.18.2",resolved:"https://registry.npmjs.org/body-parser/-/body-parser-1.18.2.tgz",integrity:"sha1-h2eKGdhLR9hZuDGZvVm84iKxBFQ=",requires:{bytes:"3.0.0","content-type":"1.0.4",debug:"2.6.9",depd:"1.1.2","http-errors":"1.6.3","iconv-lite":"0.4.19","on-finished":"2.3.0",qs:"6.5.1","raw-body":"2.3.2","type-is":"1.6.16"}},"iconv-lite":{version:"0.4.19",resolved:"https://registry.npmjs.org/iconv-lite/-/iconv-lite-0.4.19.tgz",integrity:"sha512-oTZqweIP51xaGPI4uPa56/Pri/480R+mo7SeU+YETByQNhDG55ycFyNLIgta9vXhILrxXDmF7ZGhqZIcuN0gJQ=="},qs:{version:"6.5.1",resolved:"https://registry.npmjs.org/qs/-/qs-6.5.1.tgz",integrity:"sha512-eRzhrN1WSINYCDCbrz796z37LOe3m5tmW7RQf6oBntukAG1nmovJvhnwHHRMAfeoItc1m2Hk02WER2aQ/iqs+A=="},"raw-body":{version:"2.3.2",resolved:"https://registry.npmjs.org/raw-body/-/raw-body-2.3.2.tgz",integrity:"sha1-vNYMd9Prk83gBQKVw/N5OJvIj4k=",requires:{bytes:"3.0.0","http-errors":"1.6.2","iconv-lite":"0.4.19",unpipe:"1.0.0"},dependencies:{depd:{version:"1.1.1",resolved:"https://registry.npmjs.org/depd/-/depd-1.1.1.tgz",integrity:"sha1-V4O04cRZ8G+lyif5kfPQbnoxA1k="},"http-errors":{version:"1.6.2",resolved:"https://registry.npmjs.org/http-errors/-/http-errors-1.6.2.tgz",integrity:"sha1-CgAsyFcHGSp+eUbO7cERVfYOxzY=",requires:{depd:"1.1.1",inherits:"2.0.3",setprototypeof:"1.0.3",statuses:"1.4.0"}},setprototypeof:{version:"1.0.3",resolved:"https://registry.npmjs.org/setprototypeof/-/setprototypeof-1.0.3.tgz",integrity:"sha1-ZlZ+NwQ+608E2RvWWMDL77VbjgQ="}}},"safe-buffer":{version:"5.1.1",resolved:"https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.1.tgz",integrity:"sha512-kKvNJn6Mm93gAczWVJg7wH+wGYWNrDHdWvpUmHyEsgCtIwwo3bqPtV4tR5tuPaUhTOo/kvhVwd8XwwOllGYkbg=="},statuses:{version:"1.4.0",resolved:"https://registry.npmjs.org/statuses/-/statuses-1.4.0.tgz",integrity:"sha512-zhSCtt8v2NDrRlPQpCNtw/heZLtfUDqxBM1udqikb/Hbk52LK4nQSwr10u77iopCW5LsyHpuXS0GnEc48mLeew=="}}},extend:{version:"3.0.1",resolved:"https://registry.npmjs.org/extend/-/extend-3.0.1.tgz",integrity:"sha1-p1Xqe8Gt/MWjHOfnYtuq3F5jZEQ="},extsprintf:{version:"1.3.0",resolved:"https://registry.npmjs.org/extsprintf/-/extsprintf-1.3.0.tgz",integrity:"sha1-lpGEQOMEGnpBT4xS48V06zw+HgU="},"fake-merkle-patricia-tree":{version:"1.0.1",resolved:"https://registry.npmjs.org/fake-merkle-patricia-tree/-/fake-merkle-patricia-tree-1.0.1.tgz",integrity:"sha1-S4w6z7Ugr635hgsfFM2M40As3dM=",requires:{"checkpoint-store":"1.1.0"}},"fast-deep-equal":{version:"1.1.0",resolved:"https://registry.npmjs.org/fast-deep-equal/-/fast-deep-equal-1.1.0.tgz",integrity:"sha1-wFNHeBfIa1HaqFPIHgWbcz0CNhQ="},"fast-json-stable-stringify":{version:"2.0.0",resolved:"https://registry.npmjs.org/fast-json-stable-stringify/-/fast-json-stable-stringify-2.0.0.tgz",integrity:"sha1-1RQsDK7msRifh9OnYREGT4bIu/I="},"fd-slicer":{version:"1.0.1",resolved:"https://registry.npmjs.org/fd-slicer/-/fd-slicer-1.0.1.tgz",integrity:"sha1-i1vL2ewyfFBBv5qwI/1nUPEXfmU=",requires:{pend:"1.2.0"}},"fetch-ponyfill":{version:"4.1.0",resolved:"https://registry.npmjs.org/fetch-ponyfill/-/fetch-ponyfill-4.1.0.tgz",integrity:"sha1-rjzl9zLGReq4fkroeTQUcJsjmJM=",requires:{"node-fetch":"1.7.3"},dependencies:{"node-fetch":{version:"1.7.3",resolved:"https://registry.npmjs.org/node-fetch/-/node-fetch-1.7.3.tgz",integrity:"sha512-NhZ4CsKx7cYm2vSrBAr2PvFOe6sWDf0UYLRqA6svUYg7+/TSfVAu49jYC4BvQ4Sms9SZgdqGBgroqfDhJdTyKQ==",requires:{encoding:"0.1.12","is-stream":"1.1.0"}}}},"file-type":{version:"5.2.0",resolved:"https://registry.npmjs.org/file-type/-/file-type-5.2.0.tgz",integrity:"sha1-LdvqfHP/42No365J3DOMBYwritY="},finalhandler:{version:"1.1.1",resolved:"https://registry.npmjs.org/finalhandler/-/finalhandler-1.1.1.tgz",integrity:"sha512-Y1GUDo39ez4aHAw7MysnUD5JzYX+WaIj8I57kO3aEPT1fFRL4sr7mjei97FgnwhAyyzRYmQZaTHb2+9uZ1dPtg==",requires:{debug:"2.6.9",encodeurl:"1.0.2","escape-html":"1.0.3","on-finished":"2.3.0",parseurl:"1.3.2",statuses:"1.4.0",unpipe:"1.0.0"},dependencies:{statuses:{version:"1.4.0",resolved:"https://registry.npmjs.org/statuses/-/statuses-1.4.0.tgz",integrity:"sha512-zhSCtt8v2NDrRlPQpCNtw/heZLtfUDqxBM1udqikb/Hbk52LK4nQSwr10u77iopCW5LsyHpuXS0GnEc48mLeew=="}}},"find-up":{version:"1.1.2",resolved:"https://registry.npmjs.org/find-up/-/find-up-1.1.2.tgz",integrity:"sha1-ay6YIrGizgpgq2TWEOzK1TyyTQ8=",requires:{"path-exists":"2.1.0","pinkie-promise":"2.0.1"}},"for-each":{version:"0.3.2",resolved:"https://registry.npmjs.org/for-each/-/for-each-0.3.2.tgz",integrity:"sha1-LEBFC5NI6X8oEyJZO6lnBLmr1NQ=",requires:{"is-function":"1.0.1"}},foreach:{version:"2.0.5",resolved:"https://registry.npmjs.org/foreach/-/foreach-2.0.5.tgz",integrity:"sha1-C+4AUBiusmDQo6865ljdATbsG5k="},"forever-agent":{version:"0.6.1",resolved:"https://registry.npmjs.org/forever-agent/-/forever-agent-0.6.1.tgz",integrity:"sha1-+8cfDEGt6zf5bFd60e1C2P2sypE="},"form-data":{version:"2.3.2",resolved:"https://registry.npmjs.org/form-data/-/form-data-2.3.2.tgz",integrity:"sha1-SXBJi+YEwgwAXU9cI67NIda0kJk=",requires:{asynckit:"0.4.0","combined-stream":"1.0.6","mime-types":"2.1.18"}},forwarded:{version:"0.1.2",resolved:"https://registry.npmjs.org/forwarded/-/forwarded-0.1.2.tgz",integrity:"sha1-mMI9qxF1ZXuMBXPozszZGw/xjIQ="},fresh:{version:"0.5.2",resolved:"https://registry.npmjs.org/fresh/-/fresh-0.5.2.tgz",integrity:"sha1-PYyt2Q2XZWn6g1qx+OSyOhBWBac="},"fs-constants":{version:"1.0.0",resolved:"https://registry.npmjs.org/fs-constants/-/fs-constants-1.0.0.tgz",integrity:"sha512-y6OAwoSIf7FyjMIv94u+b5rdheZEjzR63GTyZJm5qh4Bi+2YgwLCcI/fPFZkL5PSixOt6ZNKm+w+Hfp/Bciwow=="},"fs-extra":{version:"0.30.0",resolved:"https://registry.npmjs.org/fs-extra/-/fs-extra-0.30.0.tgz",integrity:"sha1-8jP/zAjU2n1DLapEl3aYnbHfk/A=",requires:{"graceful-fs":"4.1.11",jsonfile:"2.4.0",klaw:"1.3.1","path-is-absolute":"1.0.1",rimraf:"2.6.2"}},"fs-promise":{version:"2.0.3",resolved:"https://registry.npmjs.org/fs-promise/-/fs-promise-2.0.3.tgz",integrity:"sha1-9k5PhUvPaJqovdy6JokW2z20aFQ=",requires:{"any-promise":"1.3.0","fs-extra":"2.1.2",mz:"2.7.0","thenify-all":"1.6.0"},dependencies:{"fs-extra":{version:"2.1.2",resolved:"https://registry.npmjs.org/fs-extra/-/fs-extra-2.1.2.tgz",integrity:"sha1-BGxwFjzvmq1GsOSn+kZ/si1x3jU=",requires:{"graceful-fs":"4.1.11",jsonfile:"2.4.0"}}}},"fs.realpath":{version:"1.0.0",resolved:"https://registry.npmjs.org/fs.realpath/-/fs.realpath-1.0.0.tgz",integrity:"sha1-FQStJSMVjKpA20onh8sBQRmU6k8="},fstream:{version:"1.0.11",resolved:"https://registry.npmjs.org/fstream/-/fstream-1.0.11.tgz",integrity:"sha1-XB+x8RdHcRTwYyoOtLcbPLD9MXE=",requires:{"graceful-fs":"4.1.11",inherits:"2.0.3",mkdirp:"0.5.1",rimraf:"2.6.2"}},"function-bind":{version:"1.1.1",resolved:"https://registry.npmjs.org/function-bind/-/function-bind-1.1.1.tgz",integrity:"sha512-yIovAzMX49sF8Yl58fSCWJ5svSLuaibPxXQJFLmBObTuCr0Mf1KiPopGM9NiFjiYBCbfaa2Fh6breQ6ANVTI0A=="},"functional-red-black-tree":{version:"1.0.1",resolved:"https://registry.npmjs.org/functional-red-black-tree/-/functional-red-black-tree-1.0.1.tgz",integrity:"sha1-GwqzvVU7Kg1jmdKcDj6gslIHgyc="},"generic-pool":{version:"2.0.4",resolved:"https://registry.npmjs.org/generic-pool/-/generic-pool-2.0.4.tgz",integrity:"sha1-+XGN7agvoSXtXEPjQcmiFadm2aM="},"get-caller-file":{version:"1.0.2",resolved:"https://registry.npmjs.org/get-caller-file/-/get-caller-file-1.0.2.tgz",integrity:"sha1-9wLmMSfn4jHBYKgMFVSstw1QR+U="},"get-stream":{version:"3.0.0",resolved:"https://registry.npmjs.org/get-stream/-/get-stream-3.0.0.tgz",integrity:"sha1-jpQ9E1jcN1VQVOy+LtsFqhdO3hQ="},getpass:{version:"0.1.7",resolved:"https://registry.npmjs.org/getpass/-/getpass-0.1.7.tgz",integrity:"sha1-Xv+OPmhNVprkyysSgmBOi6YhSfo=",requires:{"assert-plus":"1.0.0"}},glob:{version:"7.1.2",resolved:"https://registry.npmjs.org/glob/-/glob-7.1.2.tgz",integrity:"sha512-MJTUg1kjuLeQCJ+ccE4Vpa6kKVXkPYJ2mOCQyUuKLcLQsdrMCpBPUi8qVE6+YuaJkozeA9NusTAw3hLr8Xe5EQ==",requires:{"fs.realpath":"1.0.0",inflight:"1.0.6",inherits:"2.0.3",minimatch:"3.0.4",once:"1.4.0","path-is-absolute":"1.0.1"}},global:{version:"4.3.2",resolved:"https://registry.npmjs.org/global/-/global-4.3.2.tgz",integrity:"sha1-52mJJopsdMOJCLEwWxD8DjlOnQ8=",requires:{"min-document":"2.19.0",process:"0.5.2"}},globals:{version:"9.18.0",resolved:"https://registry.npmjs.org/globals/-/globals-9.18.0.tgz",integrity:"sha512-S0nG3CLEQiY/ILxqtztTWH/3iRRdyBLw6KMDxnKMchrtbj2OFmehVh0WUCfW3DUrIgx/qFrJPICrq4Z4sTR9UQ=="},got:{version:"7.1.0",resolved:"https://registry.npmjs.org/got/-/got-7.1.0.tgz",integrity:"sha512-Y5WMo7xKKq1muPsxD+KmrR8DH5auG7fBdDVueZwETwV6VytKyU9OX/ddpq2/1hp1vIPvVb4T81dKQz3BivkNLw==",requires:{"decompress-response":"3.3.0",duplexer3:"0.1.4","get-stream":"3.0.0","is-plain-obj":"1.1.0","is-retry-allowed":"1.1.0","is-stream":"1.1.0",isurl:"1.0.0","lowercase-keys":"1.0.1","p-cancelable":"0.3.0","p-timeout":"1.2.1","safe-buffer":"5.1.2","timed-out":"4.0.1","url-parse-lax":"1.0.0","url-to-options":"1.0.1"}},"graceful-fs":{version:"4.1.11",resolved:"https://registry.npmjs.org/graceful-fs/-/graceful-fs-4.1.11.tgz",integrity:"sha1-Dovf5NHduIVNZOBOp8AOKgJuVlg="},"graceful-readlink":{version:"1.0.1",resolved:"https://registry.npmjs.org/graceful-readlink/-/graceful-readlink-1.0.1.tgz",integrity:"sha1-TK+tdrxi8C+gObL5Tpo906ORpyU="},growl:{version:"1.10.3",resolved:"https://registry.npmjs.org/growl/-/growl-1.10.3.tgz",integrity:"sha512-hKlsbA5Vu3xsh1Cg3J7jSmX/WaW6A5oBeqzM88oNbCRQFz+zUaXm6yxS4RVytp1scBoJzSYl4YAEOQIt6O8V1Q==",dev:!0},"har-schema":{version:"2.0.0",resolved:"https://registry.npmjs.org/har-schema/-/har-schema-2.0.0.tgz",integrity:"sha1-qUwiJOvKwEeCoNkDVSHyRzW37JI="},"har-validator":{version:"5.0.3",resolved:"https://registry.npmjs.org/har-validator/-/har-validator-5.0.3.tgz",integrity:"sha1-ukAsJmGU8VlW7xXg/PJCmT9qff0=",requires:{ajv:"5.5.2","har-schema":"2.0.0"}},has:{version:"1.0.3",resolved:"https://registry.npmjs.org/has/-/has-1.0.3.tgz",integrity:"sha512-f2dvO0VU6Oej7RkWJGrehjbzMAjFp5/VKPp5tTpWIV4JHHZK1/BxbFRtf/siA2SWTe09caDmVtYYzWEIbBS4zw==",requires:{"function-bind":"1.1.1"}},"has-ansi":{version:"2.0.0",resolved:"https://registry.npmjs.org/has-ansi/-/has-ansi-2.0.0.tgz",integrity:"sha1-NPUEnOHs3ysGSa8+8k5F7TVBbZE=",requires:{"ansi-regex":"2.1.1"}},"has-flag":{version:"2.0.0",resolved:"https://registry.npmjs.org/has-flag/-/has-flag-2.0.0.tgz",integrity:"sha1-6CB68cx7MNRGzHC3NLXovhj4jVE=",dev:!0},"has-localstorage":{version:"1.0.1",resolved:"https://registry.npmjs.org/has-localstorage/-/has-localstorage-1.0.1.tgz",integrity:"sha1-/mJAbEdn+9bXhNrGkFkoEIuClxs="},"has-symbol-support-x":{version:"1.4.2",resolved:"https://registry.npmjs.org/has-symbol-support-x/-/has-symbol-support-x-1.4.2.tgz",integrity:"sha512-3ToOva++HaW+eCpgqZrCfN51IPB+7bJNVT6CUATzueB5Heb8o6Nam0V3HG5dlDvZU1Gn5QLcbahiKw/XVk5JJw=="},"has-to-string-tag-x":{version:"1.4.1",resolved:"https://registry.npmjs.org/has-to-string-tag-x/-/has-to-string-tag-x-1.4.1.tgz",integrity:"sha512-vdbKfmw+3LoOYVr+mtxHaX5a96+0f3DljYd8JOqvOLsf5mw2Otda2qCDT9qRqLAhrjyQ0h7ual5nOiASpsGNFw==",requires:{"has-symbol-support-x":"1.4.2"}},"hash-base":{version:"3.0.4",resolved:"https://registry.npmjs.org/hash-base/-/hash-base-3.0.4.tgz",integrity:"sha1-X8hoaEfs1zSZQDMZprCj8/auSRg=",requires:{inherits:"2.0.3","safe-buffer":"5.1.2"}},"hash.js":{version:"1.1.3",resolved:"https://registry.npmjs.org/hash.js/-/hash.js-1.1.3.tgz",integrity:"sha512-/UETyP0W22QILqS+6HowevwhEFJ3MBJnwTf75Qob9Wz9t0DPuisL8kW8YZMK62dHAKE1c1p+gY1TtOLY+USEHA==",requires:{inherits:"2.0.3","minimalistic-assert":"1.0.1"}},hdkey:{version:"0.7.1",resolved:"https://registry.npmjs.org/hdkey/-/hdkey-0.7.1.tgz",integrity:"sha1-yu5L6BqneSHpCbjSKN0PKayu5jI=",requires:{coinstring:"2.3.0",secp256k1:"3.5.0"}},he:{version:"1.1.1",resolved:"https://registry.npmjs.org/he/-/he-1.1.1.tgz",integrity:"sha1-k0EP0hsAlzUVH4howvJx80J+I/0=",dev:!0},heap:{version:"0.2.6",resolved:"https://registry.npmjs.org/heap/-/heap-0.2.6.tgz",integrity:"sha1-CH4fELBGky/IWU3Z5tN4r8nR5aw="},"hmac-drbg":{version:"1.0.1",resolved:"https://registry.npmjs.org/hmac-drbg/-/hmac-drbg-1.0.1.tgz",integrity:"sha1-0nRXAQJabHdabFRXk+1QL8DGSaE=",requires:{"hash.js":"1.1.3","minimalistic-assert":"1.0.1","minimalistic-crypto-utils":"1.0.1"}},"home-or-tmp":{version:"2.0.0",resolved:"https://registry.npmjs.org/home-or-tmp/-/home-or-tmp-2.0.0.tgz",integrity:"sha1-42w/LSyufXRqhX440Y1fMqeILbg=",requires:{"os-homedir":"1.0.2","os-tmpdir":"1.0.2"}},"hosted-git-info":{version:"2.6.0",resolved:"https://registry.npmjs.org/hosted-git-info/-/hosted-git-info-2.6.0.tgz",integrity:"sha512-lIbgIIQA3lz5XaB6vxakj6sDHADJiZadYEJB+FgA+C4nubM1NwcuvUr9EJPmnH1skZqpqUzWborWo8EIUi0Sdw=="},"http-errors":{version:"1.6.3",resolved:"https://registry.npmjs.org/http-errors/-/http-errors-1.6.3.tgz",integrity:"sha1-i1VoC7S+KDoLW/TqLjhYC+HZMg0=",requires:{depd:"1.1.2",inherits:"2.0.3",setprototypeof:"1.1.0",statuses:"1.5.0"}},"http-https":{version:"1.0.0",resolved:"https://registry.npmjs.org/http-https/-/http-https-1.0.0.tgz",integrity:"sha1-L5CN1fHbQGjAWM1ubUzjkskTOJs="},"http-signature":{version:"1.2.0",resolved:"https://registry.npmjs.org/http-signature/-/http-signature-1.2.0.tgz",integrity:"sha1-muzZJRFHcvPZW2WmCruPfBj7rOE=",requires:{"assert-plus":"1.0.0",jsprim:"1.4.1",sshpk:"1.14.2"}},"humble-localstorage":{version:"1.4.2",resolved:"https://registry.npmjs.org/humble-localstorage/-/humble-localstorage-1.4.2.tgz",integrity:"sha1-0Fqw1SbE7b3b98amDfb/WAUoNGk=",requires:{"has-localstorage":"1.0.1","localstorage-memory":"1.0.2"}},"iconv-lite":{version:"0.4.23",resolved:"https://registry.npmjs.org/iconv-lite/-/iconv-lite-0.4.23.tgz",integrity:"sha512-neyTUVFtahjf0mB3dZT77u+8O0QB89jFdnBkd5P1JgYPbPaia3gXXOVL2fq8VyU2gMMD7SaN7QukTB/pmXYvDA==",requires:{"safer-buffer":"2.1.2"}},ieee754:{version:"1.1.11",resolved:"https://registry.npmjs.org/ieee754/-/ieee754-1.1.11.tgz",integrity:"sha512-VhDzCKN7K8ufStx/CLj5/PDTMgph+qwN5Pkd5i0sGnVwk56zJ0lkT8Qzi1xqWLS0Wp29DgDtNeS7v8/wMoZeHg=="},immediate:{version:"3.2.3",resolved:"https://registry.npmjs.org/immediate/-/immediate-3.2.3.tgz",integrity:"sha1-0UD6j2FGWb1lQSMwl92qwlzdmRw="},inflight:{version:"1.0.6",resolved:"https://registry.npmjs.org/inflight/-/inflight-1.0.6.tgz",integrity:"sha1-Sb1jMdfQLQwJvJEKEHW6gWW1bfk=",requires:{once:"1.4.0",wrappy:"1.0.2"}},inherits:{version:"2.0.3",resolved:"https://registry.npmjs.org/inherits/-/inherits-2.0.3.tgz",integrity:"sha1-Yzwsg+PaQqUC9SRmAiSA9CCCYd4="},invariant:{version:"2.2.4",resolved:"https://registry.npmjs.org/invariant/-/invariant-2.2.4.tgz",integrity:"sha512-phJfQVBuaJM5raOpJjSfkiD6BpbCE4Ns//LaXl6wGYtUBY83nWS6Rf9tXm2e8VaK60JEjYldbPif/A2B1C2gNA==",requires:{"loose-envify":"1.3.1"}},"invert-kv":{version:"1.0.0",resolved:"https://registry.npmjs.org/invert-kv/-/invert-kv-1.0.0.tgz",integrity:"sha1-EEqOSqym09jNFXqO+L+rLXo//bY="},"ipaddr.js":{version:"1.6.0",resolved:"https://registry.npmjs.org/ipaddr.js/-/ipaddr.js-1.6.0.tgz",integrity:"sha1-4/o1e3c9phnybpXwSdBVxyeW+Gs="},"is-arrayish":{version:"0.2.1",resolved:"https://registry.npmjs.org/is-arrayish/-/is-arrayish-0.2.1.tgz",integrity:"sha1-d8mYQFJ6qOyxqLppe4BkWnqSap0="},"is-builtin-module":{version:"1.0.0",resolved:"https://registry.npmjs.org/is-builtin-module/-/is-builtin-module-1.0.0.tgz",integrity:"sha1-VAVy0096wxGfj3bDDLwbHgN6/74=",requires:{"builtin-modules":"1.1.1"}},"is-callable":{version:"1.1.3",resolved:"https://registry.npmjs.org/is-callable/-/is-callable-1.1.3.tgz",integrity:"sha1-hut1OSgF3cM69xySoO7fdO52BLI="},"is-date-object":{version:"1.0.1",resolved:"https://registry.npmjs.org/is-date-object/-/is-date-object-1.0.1.tgz",integrity:"sha1-mqIOtq7rv/d/vTPnTKAbM1gdOhY="},"is-finite":{version:"1.0.2",resolved:"https://registry.npmjs.org/is-finite/-/is-finite-1.0.2.tgz",integrity:"sha1-zGZ3aVYCvlUO8R6LSqYwU0K20Ko=",requires:{"number-is-nan":"1.0.1"}},"is-fn":{version:"1.0.0",resolved:"https://registry.npmjs.org/is-fn/-/is-fn-1.0.0.tgz",integrity:"sha1-lUPV3nvPWwiiLsiiC65uKG1RDYw="},"is-fullwidth-code-point":{version:"1.0.0",resolved:"https://registry.npmjs.org/is-fullwidth-code-point/-/is-fullwidth-code-point-1.0.0.tgz",integrity:"sha1-754xOG8DGn8NZDr4L95QxFfvAMs=",requires:{"number-is-nan":"1.0.1"}},"is-function":{version:"1.0.1",resolved:"https://registry.npmjs.org/is-function/-/is-function-1.0.1.tgz",integrity:"sha1-Es+5i2W1fdPRk6MSH19uL0N2ArU="},"is-hex-prefixed":{version:"1.0.0",resolved:"https://registry.npmjs.org/is-hex-prefixed/-/is-hex-prefixed-1.0.0.tgz",integrity:"sha1-fY035q135dEnFIkTxXPggtd39VQ="},"is-natural-number":{version:"4.0.1",resolved:"https://registry.npmjs.org/is-natural-number/-/is-natural-number-4.0.1.tgz",integrity:"sha1-q5124dtM7VHjXeDHLr7PCfc0zeg="},"is-object":{version:"1.0.1",resolved:"https://registry.npmjs.org/is-object/-/is-object-1.0.1.tgz",integrity:"sha1-iVJojF7C/9awPsyF52ngKQMINHA="},"is-plain-obj":{version:"1.1.0",resolved:"https://registry.npmjs.org/is-plain-obj/-/is-plain-obj-1.1.0.tgz",integrity:"sha1-caUMhCnfync8kqOQpKA7OfzVHT4="},"is-regex":{version:"1.0.4",resolved:"https://registry.npmjs.org/is-regex/-/is-regex-1.0.4.tgz",integrity:"sha1-VRdIm1RwkbCTDglWVM7SXul+lJE=",requires:{has:"1.0.3"}},"is-retry-allowed":{version:"1.1.0",resolved:"https://registry.npmjs.org/is-retry-allowed/-/is-retry-allowed-1.1.0.tgz",integrity:"sha1-EaBgVotnM5REAz0BJaYaINVk+zQ="},"is-stream":{version:"1.1.0",resolved:"https://registry.npmjs.org/is-stream/-/is-stream-1.1.0.tgz",integrity:"sha1-EtSj3U5o4Lec6428hBc66A2RykQ="},"is-symbol":{version:"1.0.1",resolved:"https://registry.npmjs.org/is-symbol/-/is-symbol-1.0.1.tgz",integrity:"sha1-PMWfAAJRlLarLjjbrmaJJWtmBXI="},"is-typedarray":{version:"1.0.0",resolved:"https://registry.npmjs.org/is-typedarray/-/is-typedarray-1.0.0.tgz",integrity:"sha1-5HnICFjfDBsR3dppQPlgEfzaSpo="},"is-utf8":{version:"0.2.1",resolved:"https://registry.npmjs.org/is-utf8/-/is-utf8-0.2.1.tgz",integrity:"sha1-Sw2hRCEE0bM2NA6AeX6GXPOffXI="},isarray:{version:"0.0.1",resolved:"https://registry.npmjs.org/isarray/-/isarray-0.0.1.tgz",integrity:"sha1-ihis/Kmo9Bd+Cav8YDiTmwXR7t8="},isstream:{version:"0.1.2",resolved:"https://registry.npmjs.org/isstream/-/isstream-0.1.2.tgz",integrity:"sha1-R+Y/evVa+m+S4VAOaQ64uFKcCZo="},isurl:{version:"1.0.0",resolved:"https://registry.npmjs.org/isurl/-/isurl-1.0.0.tgz",integrity:"sha512-1P/yWsxPlDtn7QeRD+ULKQPaIaN6yF368GZ2vDfv0AL0NwpStafjWCDDdn0k8wgFMWpVAqG7oJhxHnlud42i9w==",requires:{"has-to-string-tag-x":"1.4.1","is-object":"1.0.1"}},"js-scrypt":{version:"0.2.0",resolved:"https://registry.npmjs.org/js-scrypt/-/js-scrypt-0.2.0.tgz",integrity:"sha1-emK3AbRhbnCtDN5URiequ5nX/jk=",requires:{"generic-pool":"2.0.4"}},"js-sha3":{version:"0.3.1",resolved:"https://registry.npmjs.org/js-sha3/-/js-sha3-0.3.1.tgz",integrity:"sha1-hhIoAhQvCChQKg0d7h2V4lO7AkM="},"js-tokens":{version:"3.0.2",resolved:"https://registry.npmjs.org/js-tokens/-/js-tokens-3.0.2.tgz",integrity:"sha1-mGbfOVECEw449/mWvOtlRDIJwls="},jsbn:{version:"0.1.1",resolved:"https://registry.npmjs.org/jsbn/-/jsbn-0.1.1.tgz",integrity:"sha1-peZUwuWi3rXyAdls77yoDA7y9RM=",optional:!0},jsesc:{version:"0.5.0",resolved:"https://registry.npmjs.org/jsesc/-/jsesc-0.5.0.tgz",integrity:"sha1-597mbjXW/Bb3EP6R1c9p9w8IkR0="},"json-rpc-engine":{version:"3.7.3",resolved:"https://registry.npmjs.org/json-rpc-engine/-/json-rpc-engine-3.7.3.tgz",integrity:"sha512-+FO3UWu/wafh/+MZ6BXy0HZU+f5plwUn82FgxpC0scJkEh5snOjFrAAtqCITPDfvfLHRUFOG5pQDUx2pspfERQ==",requires:{async:"2.6.1","babel-preset-env":"1.7.0",babelify:"7.3.0",clone:"2.1.1","json-rpc-error":"2.0.0","promise-to-callback":"1.0.0"}},"json-rpc-error":{version:"2.0.0",resolved:"https://registry.npmjs.org/json-rpc-error/-/json-rpc-error-2.0.0.tgz",integrity:"sha1-p6+cICg4tekFxyUOVH8a/3cligI=",requires:{inherits:"2.0.3"}},"json-rpc-random-id":{version:"1.0.1",resolved:"https://registry.npmjs.org/json-rpc-random-id/-/json-rpc-random-id-1.0.1.tgz",integrity:"sha1-uknZat7RRE27jaPSA3SKy7zeyMg="},"json-schema":{version:"0.2.3",resolved:"https://registry.npmjs.org/json-schema/-/json-schema-0.2.3.tgz",integrity:"sha1-tIDIkuWaLwWVTOcnvT8qTogvnhM="},"json-schema-traverse":{version:"0.3.1",resolved:"https://registry.npmjs.org/json-schema-traverse/-/json-schema-traverse-0.3.1.tgz",integrity:"sha1-NJptRMU6Ud6JtAgFxdXlm0F9M0A="},"json-stable-stringify":{version:"1.0.1",resolved:"https://registry.npmjs.org/json-stable-stringify/-/json-stable-stringify-1.0.1.tgz",integrity:"sha1-mnWdOcXy/1A/1TAGRu1EX4jE+a8=",requires:{jsonify:"0.0.0"}},"json-stringify-safe":{version:"5.0.1",resolved:"https://registry.npmjs.org/json-stringify-safe/-/json-stringify-safe-5.0.1.tgz",integrity:"sha1-Epai1Y/UXxmg9s4B1lcB4sc1tus="},json5:{version:"0.5.1",resolved:"https://registry.npmjs.org/json5/-/json5-0.5.1.tgz",integrity:"sha1-Hq3nrMASA0rYTiOWdn6tn6VJWCE="},jsonfile:{version:"2.4.0",resolved:"https://registry.npmjs.org/jsonfile/-/jsonfile-2.4.0.tgz",integrity:"sha1-NzaitCi4e72gzIO1P6PWM6NcKug=",requires:{"graceful-fs":"4.1.11"}},jsonify:{version:"0.0.0",resolved:"https://registry.npmjs.org/jsonify/-/jsonify-0.0.0.tgz",integrity:"sha1-LHS27kHZPKUbe1qu6PUDYx0lKnM="},jsprim:{version:"1.4.1",resolved:"https://registry.npmjs.org/jsprim/-/jsprim-1.4.1.tgz",integrity:"sha1-MT5mvB5cwG5Di8G3SZwuXFastqI=",requires:{"assert-plus":"1.0.0",extsprintf:"1.3.0","json-schema":"0.2.3",verror:"1.10.0"}},keccak:{version:"1.4.0",resolved:"https://registry.npmjs.org/keccak/-/keccak-1.4.0.tgz",integrity:"sha512-eZVaCpblK5formjPjeTBik7TAg+pqnDrMHIffSvi9Lh7PQgM1+hSzakUeZFCk9DVVG0dacZJuaz2ntwlzZUIBw==",requires:{bindings:"1.3.0",inherits:"2.0.3",nan:"2.10.0","safe-buffer":"5.1.2"}},keccakjs:{version:"0.2.1",resolved:"https://registry.npmjs.org/keccakjs/-/keccakjs-0.2.1.tgz",integrity:"sha1-HWM6+QfvMFu/ny+mFtVsRFYd+k0=",requires:{"browserify-sha3":"0.0.1",sha3:"1.2.2"}},klaw:{version:"1.3.1",resolved:"https://registry.npmjs.org/klaw/-/klaw-1.3.1.tgz",integrity:"sha1-QIhDO0azsbolnXh4XY6W9zugJDk=",requires:{"graceful-fs":"4.1.11"}},lcid:{version:"1.0.0",resolved:"https://registry.npmjs.org/lcid/-/lcid-1.0.0.tgz",integrity:"sha1-MIrMr6C8SDo4Z7S28rlQYlHRuDU=",requires:{"invert-kv":"1.0.0"}},"level-codec":{version:"7.0.1",resolved:"https://registry.npmjs.org/level-codec/-/level-codec-7.0.1.tgz",integrity:"sha512-Ua/R9B9r3RasXdRmOtd+t9TCOEIIlts+TN/7XTT2unhDaL6sJn83S3rUyljbr6lVtw49N3/yA0HHjpV6Kzb2aQ=="},"level-errors":{version:"1.0.5",resolved:"https://registry.npmjs.org/level-errors/-/level-errors-1.0.5.tgz",integrity:"sha512-/cLUpQduF6bNrWuAC4pwtUKA5t669pCsCi2XbmojG2tFeOr9j6ShtdDCtFFQO1DRt+EVZhx9gPzP9G2bUaG4ig==",requires:{errno:"0.1.7"}},"level-iterator-stream":{version:"1.3.1",resolved:"https://registry.npmjs.org/level-iterator-stream/-/level-iterator-stream-1.3.1.tgz",integrity:"sha1-5Dt4sagUPm+pek9IXrjqUwNS8u0=",requires:{inherits:"2.0.3","level-errors":"1.0.5","readable-stream":"1.1.14",xtend:"4.0.1"},dependencies:{"readable-stream":{version:"1.1.14",resolved:"https://registry.npmjs.org/readable-stream/-/readable-stream-1.1.14.tgz",integrity:"sha1-fPTFTvZI44EwhMY23SB54WbAgdk=",requires:{"core-util-is":"1.0.2",inherits:"2.0.3",isarray:"0.0.1",string_decoder:"0.10.31"}}}},"level-post":{version:"1.0.7",resolved:"https://registry.npmjs.org/level-post/-/level-post-1.0.7.tgz",integrity:"sha512-PWYqG4Q00asOrLhX7BejSajByB4EmG2GaKHfj3h5UmmZ2duciXLPGYWIjBzLECFWUGOZWlm5B20h/n3Gs3HKew==",requires:{ltgt:"2.2.1"}},"level-sublevel":{version:"6.6.2",resolved:"https://registry.npmjs.org/level-sublevel/-/level-sublevel-6.6.2.tgz",integrity:"sha512-+hptqmFYPKFju9QG4F6scvx3ZXkhrSmmhYui+hPzRn/jiC3DJ6VNZRKsIhGMpeajVBWfRV7XiysUThrJ/7PgXQ==",requires:{bytewise:"1.1.0",levelup:"0.19.1",ltgt:"2.1.3","pull-defer":"0.2.2","pull-level":"2.0.4","pull-stream":"3.6.8",typewiselite:"1.0.0",xtend:"4.0.1"},dependencies:{"abstract-leveldown":{version:"0.12.4",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-0.12.4.tgz",integrity:"sha1-KeGOYy5g5OIh1YECR4UqY9ey5BA=",requires:{xtend:"3.0.0"},dependencies:{xtend:{version:"3.0.0",resolved:"https://registry.npmjs.org/xtend/-/xtend-3.0.0.tgz",integrity:"sha1-XM50B7r2Qsunvs2laBEcST9ZZlo="}}},"deferred-leveldown":{version:"0.2.0",resolved:"https://registry.npmjs.org/deferred-leveldown/-/deferred-leveldown-0.2.0.tgz",integrity:"sha1-LO8fER4cV4cNi7uK8mUOWHzS9bQ=",requires:{"abstract-leveldown":"0.12.4"}},levelup:{version:"0.19.1",resolved:"https://registry.npmjs.org/levelup/-/levelup-0.19.1.tgz",integrity:"sha1-86anIFJyxLXzXkEv8ASgOgrt9Qs=",requires:{bl:"0.8.2","deferred-leveldown":"0.2.0",errno:"0.1.7",prr:"0.0.0","readable-stream":"1.0.34",semver:"5.1.1",xtend:"3.0.0"},dependencies:{xtend:{version:"3.0.0",resolved:"https://registry.npmjs.org/xtend/-/xtend-3.0.0.tgz",integrity:"sha1-XM50B7r2Qsunvs2laBEcST9ZZlo="}}},ltgt:{version:"2.1.3",resolved:"https://registry.npmjs.org/ltgt/-/ltgt-2.1.3.tgz",integrity:"sha1-EIUaBtmWS5cReEQcI8nlJpjuzjQ="},prr:{version:"0.0.0",resolved:"https://registry.npmjs.org/prr/-/prr-0.0.0.tgz",integrity:"sha1-GoS4WQgyVQFBGFPQCB7j+obikmo="},"readable-stream":{version:"1.0.34",resolved:"https://registry.npmjs.org/readable-stream/-/readable-stream-1.0.34.tgz",integrity:"sha1-Elgg40vIQtLyqq+v5MKRbuMsFXw=",requires:{"core-util-is":"1.0.2",inherits:"2.0.3",isarray:"0.0.1",string_decoder:"0.10.31"}},semver:{version:"5.1.1",resolved:"https://registry.npmjs.org/semver/-/semver-5.1.1.tgz",integrity:"sha1-oykqNz5vPgeY2gsgZBuanFvEfhk="}}},"level-ws":{version:"0.0.0",resolved:"https://registry.npmjs.org/level-ws/-/level-ws-0.0.0.tgz",integrity:"sha1-Ny5RIXeSSgBCSwtDrvK7QkltIos=",requires:{"readable-stream":"1.0.34",xtend:"2.1.2"},dependencies:{"readable-stream":{version:"1.0.34",resolved:"https://registry.npmjs.org/readable-stream/-/readable-stream-1.0.34.tgz",integrity:"sha1-Elgg40vIQtLyqq+v5MKRbuMsFXw=",requires:{"core-util-is":"1.0.2",inherits:"2.0.3",isarray:"0.0.1",string_decoder:"0.10.31"}},xtend:{version:"2.1.2",resolved:"https://registry.npmjs.org/xtend/-/xtend-2.1.2.tgz",integrity:"sha1-bv7MKk2tjmlixJAbM3znuoe10os=",requires:{"object-keys":"0.4.0"}}}},levelup:{version:"1.3.9",resolved:"https://registry.npmjs.org/levelup/-/levelup-1.3.9.tgz",integrity:"sha512-VVGHfKIlmw8w1XqpGOAGwq6sZm2WwWLmlDcULkKWQXEA5EopA8OBNJ2Ck2v6bdk8HeEZSbCSEgzXadyQFm76sQ==",requires:{"deferred-leveldown":"1.2.2","level-codec":"7.0.1","level-errors":"1.0.5","level-iterator-stream":"1.3.1",prr:"1.0.1",semver:"5.4.1",xtend:"4.0.1"}},"load-json-file":{version:"1.1.0",resolved:"https://registry.npmjs.org/load-json-file/-/load-json-file-1.1.0.tgz",integrity:"sha1-lWkFcI1YtLq0wiYbBPWfMcmTdMA=",requires:{"graceful-fs":"4.1.11","parse-json":"2.2.0",pify:"2.3.0","pinkie-promise":"2.0.1","strip-bom":"2.0.0"},dependencies:{pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="}}},"localstorage-down":{version:"0.6.7",resolved:"https://registry.npmjs.org/localstorage-down/-/localstorage-down-0.6.7.tgz",integrity:"sha1-0Hmak7MebF+lGI7AYkLrHM6dbRU=",requires:{"abstract-leveldown":"0.12.3",argsarray:"0.0.1","buffer-from":"0.1.2",d64:"1.0.0","humble-localstorage":"1.4.2",inherits:"2.0.3","tiny-queue":"0.2.0"},dependencies:{"abstract-leveldown":{version:"0.12.3",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-0.12.3.tgz",integrity:"sha1-EWsexcdxDvei1XBnaLvbREC+EHA=",requires:{xtend:"3.0.0"}},xtend:{version:"3.0.0",resolved:"https://registry.npmjs.org/xtend/-/xtend-3.0.0.tgz",integrity:"sha1-XM50B7r2Qsunvs2laBEcST9ZZlo="}}},"localstorage-memory":{version:"1.0.2",resolved:"https://registry.npmjs.org/localstorage-memory/-/localstorage-memory-1.0.2.tgz",integrity:"sha1-zUqPIQ5V3VGckp9LTMgoKbWPmlE="},lodash:{version:"4.17.10",resolved:"https://registry.npmjs.org/lodash/-/lodash-4.17.10.tgz",integrity:"sha512-UejweD1pDoXu+AD825lWwp4ZGtSwgnpZxb3JDViD7StjQz+Nb/6l093lx4OQ0foGWNRoc19mWy7BzL+UAK2iVg=="},"lodash.assign":{version:"4.2.0",resolved:"https://registry.npmjs.org/lodash.assign/-/lodash.assign-4.2.0.tgz",integrity:"sha1-DZnzzNem0mHRm9rrkkUAXShYCOc="},"lodash.merge":{version:"4.6.1",resolved:"https://registry.npmjs.org/lodash.merge/-/lodash.merge-4.6.1.tgz",integrity:"sha512-AOYza4+Hf5z1/0Hztxpm2/xiPZgi/cjMqdnKTUWTBSKchJlxXXuUSxCCl8rJlf4g6yww/j6mA8nC8Hw/EZWxKQ==",dev:!0},looper:{version:"2.0.0",resolved:"https://registry.npmjs.org/looper/-/looper-2.0.0.tgz",integrity:"sha1-Zs0Md0rz1P7axTeU90LbVtqPCew="},"loose-envify":{version:"1.3.1",resolved:"https://registry.npmjs.org/loose-envify/-/loose-envify-1.3.1.tgz",integrity:"sha1-0aitM/qc4OcT1l/dCsi3SNR4yEg=",requires:{"js-tokens":"3.0.2"}},"lowercase-keys":{version:"1.0.1",resolved:"https://registry.npmjs.org/lowercase-keys/-/lowercase-keys-1.0.1.tgz",integrity:"sha512-G2Lj61tXDnVFFOi8VZds+SoQjtQC3dgokKdDG2mTm1tx4m50NUHBOZSBwQQHyy0V12A0JTG4icfZQH+xPyh8VA=="},"lru-cache":{version:"3.2.0",resolved:"https://registry.npmjs.org/lru-cache/-/lru-cache-3.2.0.tgz",integrity:"sha1-cXibO39Tmb7IVl3aOKow0qCX7+4=",requires:{pseudomap:"1.0.2"}},ltgt:{version:"2.2.1",resolved:"https://registry.npmjs.org/ltgt/-/ltgt-2.2.1.tgz",integrity:"sha1-81ypHEk/e3PaDgdJUwTxezH4fuU="},"make-dir":{version:"1.3.0",resolved:"https://registry.npmjs.org/make-dir/-/make-dir-1.3.0.tgz",integrity:"sha512-2w31R7SJtieJJnQtGc7RVL2StM2vGYVfqUOvUDxH6bC6aJTxPxTF0GnIgCyu7tjockiUWAYQRbxa7vKn34s5sQ==",requires:{pify:"3.0.0"}},"md5.js":{version:"1.3.4",resolved:"https://registry.npmjs.org/md5.js/-/md5.js-1.3.4.tgz",integrity:"sha1-6b296UogpawYsENA/Fdk1bCdkB0=",requires:{"hash-base":"3.0.4",inherits:"2.0.3"}},"media-typer":{version:"0.3.0",resolved:"https://registry.npmjs.org/media-typer/-/media-typer-0.3.0.tgz",integrity:"sha1-hxDXrwqmJvj/+hzgAWhUUmMlV0g="},memdown:{version:"1.4.1",resolved:"https://registry.npmjs.org/memdown/-/memdown-1.4.1.tgz",integrity:"sha1-tOThkhdGZP+65BNhqlAPMRnv4hU=",requires:{"abstract-leveldown":"2.7.2","functional-red-black-tree":"1.0.1",immediate:"3.2.3",inherits:"2.0.3",ltgt:"2.2.1","safe-buffer":"5.1.2"},dependencies:{"abstract-leveldown":{version:"2.7.2",resolved:"https://registry.npmjs.org/abstract-leveldown/-/abstract-leveldown-2.7.2.tgz",integrity:"sha512-+OVvxH2rHVEhWLdbudP6p0+dNMXu8JA1CbhP19T8paTYAcX7oJ4OVjT+ZUVpv7mITxXHqDMej+GdqXBmXkw09w==",requires:{xtend:"4.0.1"}}}},memorystream:{version:"0.3.1",resolved:"https://registry.npmjs.org/memorystream/-/memorystream-0.3.1.tgz",integrity:"sha1-htcJCzDORV1j+64S3aUaR93K+bI="},"merge-descriptors":{version:"1.0.1",resolved:"https://registry.npmjs.org/merge-descriptors/-/merge-descriptors-1.0.1.tgz",integrity:"sha1-sAqqVW3YtEVoFQ7J0blT8/kMu2E="},"merkle-patricia-tree":{version:"2.3.1",resolved:"https://registry.npmjs.org/merkle-patricia-tree/-/merkle-patricia-tree-2.3.1.tgz",integrity:"sha512-Qp9Mpb3xazznXzzGQBqHbqCpT2AR9joUOHYYPiQjYCarrdCPCnLWXo4BFv77y4xN26KR224xoU1n/qYY7RYYgw==",requires:{async:"1.5.2","ethereumjs-util":"5.2.0","level-ws":"0.0.0",levelup:"1.3.9",memdown:"1.4.1","readable-stream":"2.3.6",rlp:"2.0.0",semaphore:"1.1.0"},dependencies:{async:{version:"1.5.2",resolved:"https://registry.npmjs.org/async/-/async-1.5.2.tgz",integrity:"sha1-7GphrlZIDAw8skHJVhjiCJL5Zyo="}}},methods:{version:"1.1.2",resolved:"https://registry.npmjs.org/methods/-/methods-1.1.2.tgz",integrity:"sha1-VSmk1nZUE07cxSZmVoNbD4Ua/O4="},"miller-rabin":{version:"4.0.1",resolved:"https://registry.npmjs.org/miller-rabin/-/miller-rabin-4.0.1.tgz",integrity:"sha512-115fLhvZVqWwHPbClyntxEVfVDfl9DLLTuJvq3g2O/Oxi8AiNouAHvDSzHS0viUJc+V5vm3eq91Xwqn9dp4jRA==",requires:{"bn.js":"4.11.6",brorand:"1.1.0"}},mime:{version:"1.4.1",resolved:"https://registry.npmjs.org/mime/-/mime-1.4.1.tgz",integrity:"sha512-KI1+qOZu5DcW6wayYHSzR/tXKCDC5Om4s1z2QJjDULzLcmf3DvzS7oluY4HCTrc+9FiKmWUgeNLg7W3uIQvxtQ=="},"mime-db":{version:"1.33.0",resolved:"https://registry.npmjs.org/mime-db/-/mime-db-1.33.0.tgz",integrity:"sha512-BHJ/EKruNIqJf/QahvxwQZXKygOQ256myeN/Ew+THcAa5q+PjyTTMMeNQC4DZw5AwfvelsUrA6B67NKMqXDbzQ=="},"mime-types":{version:"2.1.18",resolved:"https://registry.npmjs.org/mime-types/-/mime-types-2.1.18.tgz",integrity:"sha512-lc/aahn+t4/SWV/qcmumYjymLsWfN3ELhpmVuUFjgsORruuZPVSwAQryq+HHGvO/SI2KVX26bx+En+zhM8g8hQ==",requires:{"mime-db":"1.33.0"}},"mimic-response":{version:"1.0.0",resolved:"https://registry.npmjs.org/mimic-response/-/mimic-response-1.0.0.tgz",integrity:"sha1-3z02Uqc/3ta5sLJBRub9BSNTRY4="},"min-document":{version:"2.19.0",resolved:"https://registry.npmjs.org/min-document/-/min-document-2.19.0.tgz",integrity:"sha1-e9KC4/WELtKVu3SM3Z8f+iyCRoU=",requires:{"dom-walk":"0.1.1"}},"minimalistic-assert":{version:"1.0.1",resolved:"https://registry.npmjs.org/minimalistic-assert/-/minimalistic-assert-1.0.1.tgz",integrity:"sha512-UtJcAD4yEaGtjPezWuO9wC4nwUnVH/8/Im3yEHQP4b67cXlD/Qr9hdITCU1xDbSEXg2XKNaP8jsReV7vQd00/A=="},"minimalistic-crypto-utils":{version:"1.0.1",resolved:"https://registry.npmjs.org/minimalistic-crypto-utils/-/minimalistic-crypto-utils-1.0.1.tgz",integrity:"sha1-9sAMHAsIIkblxNmd+4x8CDsrWCo="},minimatch:{version:"3.0.4",resolved:"https://registry.npmjs.org/minimatch/-/minimatch-3.0.4.tgz",integrity:"sha512-yJHVQEhyqPLUTgt9B83PXu6W3rx4MvvHvSUvToogpwoGDOUQ+yDrR0HRot+yOCdCO7u4hX3pWft6kWBBcqh0UA==",requires:{"brace-expansion":"1.1.11"}},minimist:{version:"0.0.8",resolved:"https://registry.npmjs.org/minimist/-/minimist-0.0.8.tgz",integrity:"sha1-hX/Kv8M5fSYluCKCYuhqp6ARsF0="},mkdirp:{version:"0.5.1",resolved:"https://registry.npmjs.org/mkdirp/-/mkdirp-0.5.1.tgz",integrity:"sha1-MAV0OOrGz3+MR2fzhkjWaX11yQM=",requires:{minimist:"0.0.8"}},"mkdirp-promise":{version:"5.0.1",resolved:"https://registry.npmjs.org/mkdirp-promise/-/mkdirp-promise-5.0.1.tgz",integrity:"sha1-6bj2jlUsaKnBcTuEiD96HdA5uKE=",requires:{mkdirp:"0.5.1"}},mocha:{version:"5.1.1",resolved:"https://registry.npmjs.org/mocha/-/mocha-5.1.1.tgz",integrity:"sha512-kKKs/H1KrMMQIEsWNxGmb4/BGsmj0dkeyotEvbrAuQ01FcWRLssUNXCEUZk6SZtyJBi6EE7SL0zDDtItw1rGhw==",dev:!0,requires:{"browser-stdout":"1.3.1",commander:"2.11.0",debug:"3.1.0",diff:"3.5.0","escape-string-regexp":"1.0.5",glob:"7.1.2",growl:"1.10.3",he:"1.1.1",minimatch:"3.0.4",mkdirp:"0.5.1","supports-color":"4.4.0"},dependencies:{commander:{version:"2.11.0",resolved:"https://registry.npmjs.org/commander/-/commander-2.11.0.tgz",integrity:"sha512-b0553uYA5YAEGgyYIGYROzKQ7X5RAqedkfjiZxwi0kL1g3bOaBNNZfYkzt/CL0umgD5wc9Jec2FbB98CjkMRvQ==",dev:!0},debug:{version:"3.1.0",resolved:"https://registry.npmjs.org/debug/-/debug-3.1.0.tgz",integrity:"sha512-OX8XqP7/1a9cqkxYw2yXss15f26NKWBpDXQd0/uK/KPqdQhxbPa994hnzjcE2VqQpDslf55723cKPUOGSmMY3g==",dev:!0,requires:{ms:"2.0.0"}},"supports-color":{version:"4.4.0",resolved:"https://registry.npmjs.org/supports-color/-/supports-color-4.4.0.tgz",integrity:"sha512-rKC3+DyXWgK0ZLKwmRsrkyHVZAjNkfzeehuFWdGGcqGDTZFH73+RH6S/RDAAxl9GusSjZSUWYLmT9N5pzXFOXQ==",dev:!0,requires:{"has-flag":"2.0.0"}}}},"mock-fs":{version:"4.5.0",resolved:"https://registry.npmjs.org/mock-fs/-/mock-fs-4.5.0.tgz",integrity:"sha512-qqudNfOX7ZmX9vm1WIAU+gWlmxVNAnwY6UG3RkFutNywmRCUGP83tujP6IxX2DS1TmcaEZBOhYwDuYEmJYE+3w=="},mout:{version:"0.11.1",resolved:"https://registry.npmjs.org/mout/-/mout-0.11.1.tgz",integrity:"sha1-ujYR318OWx/7/QEWa48C0fX6K5k="},ms:{version:"2.0.0",resolved:"https://registry.npmjs.org/ms/-/ms-2.0.0.tgz",integrity:"sha1-VgiurfwAvmwpAd9fmGF4jeDVl8g="},mz:{version:"2.7.0",resolved:"https://registry.npmjs.org/mz/-/mz-2.7.0.tgz",integrity:"sha512-z81GNO7nnYMEhrGh9LeymoE4+Yr0Wn5McHIZMK5cfQCl+NDX08sCZgUc9/6MHni9IWuFLm1Z3HTCXu2z9fN62Q==",requires:{"any-promise":"1.3.0","object-assign":"4.1.1","thenify-all":"1.6.0"}},nan:{version:"2.10.0",resolved:"https://registry.npmjs.org/nan/-/nan-2.10.0.tgz",integrity:"sha512-bAdJv7fBLhWC+/Bls0Oza+mvTaNQtP+1RyhhhvD95pgUJz6XM5IzgmxOkItJ9tkoCiplvAnXI1tNmmUD/eScyA=="},"nano-json-stream-parser":{version:"0.1.2",resolved:"https://registry.npmjs.org/nano-json-stream-parser/-/nano-json-stream-parser-0.1.2.tgz",integrity:"sha1-DMj20OK2IrR5xA1JnEbWS3Vcb18="},negotiator:{version:"0.6.1",resolved:"https://registry.npmjs.org/negotiator/-/negotiator-0.6.1.tgz",integrity:"sha1-KzJxhOiZIQEXeyhWP7XnECrNDKk="},"node-fetch":{version:"2.1.2",resolved:"https://registry.npmjs.org/node-fetch/-/node-fetch-2.1.2.tgz",integrity:"sha1-q4hOjn5X44qUR1POxwb3iNF2i7U="},"normalize-package-data":{version:"2.4.0",resolved:"https://registry.npmjs.org/normalize-package-data/-/normalize-package-data-2.4.0.tgz",integrity:"sha512-9jjUFbTPfEy3R/ad/2oNbKtW9Hgovl5O1FvFWKkKblNXoN/Oou6+9+KKohPK13Yc3/TyunyWhJp6gvRNR/PPAw==",requires:{"hosted-git-info":"2.6.0","is-builtin-module":"1.0.0",semver:"5.4.1","validate-npm-package-license":"3.0.3"}},"number-is-nan":{version:"1.0.1",resolved:"https://registry.npmjs.org/number-is-nan/-/number-is-nan-1.0.1.tgz",integrity:"sha1-CXtgK1NCKlIsGvuHkDGDNpQaAR0="},"number-to-bn":{version:"1.7.0",resolved:"https://registry.npmjs.org/number-to-bn/-/number-to-bn-1.7.0.tgz",integrity:"sha1-uzYjWS9+X54AMLGXe9QaDFP+HqA=",requires:{"bn.js":"4.11.6","strip-hex-prefix":"1.0.0"}},"oauth-sign":{version:"0.8.2",resolved:"https://registry.npmjs.org/oauth-sign/-/oauth-sign-0.8.2.tgz",integrity:"sha1-Rqarfwrq2N6unsBWV4C31O/rnUM="},"object-assign":{version:"4.1.1",resolved:"https://registry.npmjs.org/object-assign/-/object-assign-4.1.1.tgz",integrity:"sha1-IQmtx5ZYh8/AXLvUQsrIv7s2CGM="},"object-inspect":{version:"1.5.0",resolved:"https://registry.npmjs.org/object-inspect/-/object-inspect-1.5.0.tgz",integrity:"sha512-UmOFbHbwvv+XHj7BerrhVq+knjceBdkvU5AriwLMvhv2qi+e7DJzxfBeFpILEjVzCp+xA+W/pIf06RGPWlZNfw=="},"object-keys":{version:"0.4.0",resolved:"https://registry.npmjs.org/object-keys/-/object-keys-0.4.0.tgz",integrity:"sha1-KKaq50KN0sOpLz2V8hM13SBOAzY="},oboe:{version:"2.1.3",resolved:"https://registry.npmjs.org/oboe/-/oboe-2.1.3.tgz",integrity:"sha1-K0hl29Rr6BIlcT9Om/5Lz09oCk8=",requires:{"http-https":"1.0.0"}},"on-finished":{version:"2.3.0",resolved:"https://registry.npmjs.org/on-finished/-/on-finished-2.3.0.tgz",integrity:"sha1-IPEzZIGwg811M3mSoWlxqi2QaUc=",requires:{"ee-first":"1.1.1"}},once:{version:"1.4.0",resolved:"https://registry.npmjs.org/once/-/once-1.4.0.tgz",integrity:"sha1-WDsap3WWHUsROsF9nFC6753Xa9E=",requires:{wrappy:"1.0.2"}},"os-homedir":{version:"1.0.2",resolved:"https://registry.npmjs.org/os-homedir/-/os-homedir-1.0.2.tgz",integrity:"sha1-/7xJiDNuDoM94MFox+8VISGqf7M="},"os-locale":{version:"1.4.0",resolved:"https://registry.npmjs.org/os-locale/-/os-locale-1.4.0.tgz",integrity:"sha1-IPnxeuKe00XoveWDsT0gCYA8FNk=",requires:{lcid:"1.0.0"}},"os-tmpdir":{version:"1.0.2",resolved:"https://registry.npmjs.org/os-tmpdir/-/os-tmpdir-1.0.2.tgz",integrity:"sha1-u+Z0BseaqFxc/sdm/lc0VV36EnQ="},"p-cancelable":{version:"0.3.0",resolved:"https://registry.npmjs.org/p-cancelable/-/p-cancelable-0.3.0.tgz",integrity:"sha512-RVbZPLso8+jFeq1MfNvgXtCRED2raz/dKpacfTNxsx6pLEpEomM7gah6VeHSYV3+vo0OAi4MkArtQcWWXuQoyw=="},"p-finally":{version:"1.0.0",resolved:"https://registry.npmjs.org/p-finally/-/p-finally-1.0.0.tgz",integrity:"sha1-P7z7FbiZpEEjs0ttzBi3JDNqLK4="},"p-timeout":{version:"1.2.1",resolved:"https://registry.npmjs.org/p-timeout/-/p-timeout-1.2.1.tgz",integrity:"sha1-XrOzU7f86Z8QGhA4iAuwVOu+o4Y=",requires:{"p-finally":"1.0.0"}},"parse-asn1":{version:"5.1.1",resolved:"https://registry.npmjs.org/parse-asn1/-/parse-asn1-5.1.1.tgz",integrity:"sha512-KPx7flKXg775zZpnp9SxJlz00gTd4BmJ2yJufSc44gMCRrRQ7NSzAcSJQfifuOLgW6bEi+ftrALtsgALeB2Adw==",requires:{"asn1.js":"4.10.1","browserify-aes":"1.2.0","create-hash":"1.2.0",evp_bytestokey:"1.0.3",pbkdf2:"3.0.16"}},"parse-headers":{version:"2.0.1",resolved:"https://registry.npmjs.org/parse-headers/-/parse-headers-2.0.1.tgz",integrity:"sha1-aug6eqJanZtwCswoaYzR8e1+lTY=",requires:{"for-each":"0.3.2",trim:"0.0.1"}},"parse-json":{version:"2.2.0",resolved:"https://registry.npmjs.org/parse-json/-/parse-json-2.2.0.tgz",integrity:"sha1-9ID0BDTvgHQfhGkJn43qGPVaTck=",requires:{"error-ex":"1.3.1"}},parseurl:{version:"1.3.2",resolved:"https://registry.npmjs.org/parseurl/-/parseurl-1.3.2.tgz",integrity:"sha1-/CidTtiZMRlGDBViUyYs3I3mW/M="},"path-exists":{version:"2.1.0",resolved:"https://registry.npmjs.org/path-exists/-/path-exists-2.1.0.tgz",integrity:"sha1-D+tsZPD8UY2adU3V77YscCJ2H0s=",requires:{"pinkie-promise":"2.0.1"}},"path-is-absolute":{version:"1.0.1",resolved:"https://registry.npmjs.org/path-is-absolute/-/path-is-absolute-1.0.1.tgz",integrity:"sha1-F0uSaHNVNP+8es5r9TpanhtcX18="},"path-parse":{version:"1.0.5",resolved:"https://registry.npmjs.org/path-parse/-/path-parse-1.0.5.tgz",integrity:"sha1-PBrfhx6pzWyUMbbqK9dKD/BVxME="},"path-to-regexp":{version:"0.1.7",resolved:"https://registry.npmjs.org/path-to-regexp/-/path-to-regexp-0.1.7.tgz",integrity:"sha1-32BBeABfUi8V60SQ5yR6G/qmf4w="},"path-type":{version:"1.1.0",resolved:"https://registry.npmjs.org/path-type/-/path-type-1.1.0.tgz",integrity:"sha1-WcRPfuSR2nBNpBXaWkBwuk+P5EE=",requires:{"graceful-fs":"4.1.11",pify:"2.3.0","pinkie-promise":"2.0.1"},dependencies:{pify:{version:"2.3.0",resolved:"https://registry.npmjs.org/pify/-/pify-2.3.0.tgz",integrity:"sha1-7RQaasBDqEnqWISY59yosVMw6Qw="}}},pbkdf2:{version:"3.0.16",resolved:"https://registry.npmjs.org/pbkdf2/-/pbkdf2-3.0.16.tgz",integrity:"sha512-y4CXP3thSxqf7c0qmOF+9UeOTrifiVTIM+u7NWlq+PRsHbr7r7dpCmvzrZxa96JJUNi0Y5w9VqG5ZNeCVMoDcA==",requires:{"create-hash":"1.2.0","create-hmac":"1.1.7",ripemd160:"2.0.2","safe-buffer":"5.1.2","sha.js":"2.4.11"}},pend:{version:"1.2.0",resolved:"https://registry.npmjs.org/pend/-/pend-1.2.0.tgz",integrity:"sha1-elfrVQpng/kRUzH89GY9XI4AelA="},"performance-now":{version:"2.1.0",resolved:"https://registry.npmjs.org/performance-now/-/performance-now-2.1.0.tgz",integrity:"sha1-Ywn04OX6kT7BxpMHrjZLSzd8nns="},pify:{version:"3.0.0",resolved:"https://registry.npmjs.org/pify/-/pify-3.0.0.tgz",integrity:"sha1-5aSs0sEB/fPZpNB/DbxNtJ3SgXY="},pinkie:{version:"2.0.4",resolved:"https://registry.npmjs.org/pinkie/-/pinkie-2.0.4.tgz",integrity:"sha1-clVrgM+g1IqXToDnckjoDtT3+HA="},"pinkie-promise":{version:"2.0.1",resolved:"https://registry.npmjs.org/pinkie-promise/-/pinkie-promise-2.0.1.tgz",integrity:"sha1-ITXW36ejWMBprJsXh3YogihFD/o=",requires:{pinkie:"2.0.4"}},precond:{version:"0.2.3",resolved:"https://registry.npmjs.org/precond/-/precond-0.2.3.tgz",integrity:"sha1-qpWRvKokkj8eD0hJ0kD0fvwQdaw="},"prepend-file":{version:"1.3.1",resolved:"https://registry.npmjs.org/prepend-file/-/prepend-file-1.3.1.tgz",integrity:"sha1-g7FuC0rBkB/OiNvZRaIvTMgd9Xk=",requires:{tmp:"0.0.31"}},"prepend-http":{version:"1.0.4",resolved:"https://registry.npmjs.org/prepend-http/-/prepend-http-1.0.4.tgz",integrity:"sha1-1PRWKwzjaW5BrFLQ4ALlemNdxtw="},private:{version:"0.1.8",resolved:"https://registry.npmjs.org/private/-/private-0.1.8.tgz",integrity:"sha512-VvivMrbvd2nKkiG38qjULzlc+4Vx4wm/whI9pQD35YrARNnhxeiRktSOhSukRLFNlzg6Br/cJPet5J/u19r/mg=="},process:{version:"0.5.2",resolved:"https://registry.npmjs.org/process/-/process-0.5.2.tgz",integrity:"sha1-FjjYqONML0QKkduVq5rrZ3/Bhc8="},"process-nextick-args":{version:"2.0.0",resolved:"https://registry.npmjs.org/process-nextick-args/-/process-nextick-args-2.0.0.tgz",integrity:"sha512-MtEC1TqN0EU5nephaJ4rAtThHtC86dNN9qCuEhtshvpVBkAW5ZO7BASN9REnF9eoXGcRub+pFuKEpOHE+HbEMw=="},"promise-to-callback":{version:"1.0.0",resolved:"https://registry.npmjs.org/promise-to-callback/-/promise-to-callback-1.0.0.tgz",integrity:"sha1-XSp0kBC/tn2WNZj805YHRqaP7vc=",requires:{"is-fn":"1.0.0","set-immediate-shim":"1.0.1"}},"proxy-addr":{version:"2.0.3",resolved:"https://registry.npmjs.org/proxy-addr/-/proxy-addr-2.0.3.tgz",integrity:"sha512-jQTChiCJteusULxjBp8+jftSQE5Obdl3k4cnmLA6WXtK6XFuWRnvVL7aCiBqaLPM8c4ph0S4tKna8XvmIwEnXQ==",requires:{forwarded:"0.1.2","ipaddr.js":"1.6.0"}},prr:{version:"1.0.1",resolved:"https://registry.npmjs.org/prr/-/prr-1.0.1.tgz",integrity:"sha1-0/wRS6BplaRexok/SEzrHXj19HY="},pseudomap:{version:"1.0.2",resolved:"https://registry.npmjs.org/pseudomap/-/pseudomap-1.0.2.tgz",integrity:"sha1-8FKijacOYYkX7wqKw0wa5aaChrM="},"public-encrypt":{version:"4.0.2",resolved:"https://registry.npmjs.org/public-encrypt/-/public-encrypt-4.0.2.tgz",integrity:"sha512-4kJ5Esocg8X3h8YgJsKAuoesBgB7mqH3eowiDzMUPKiRDDE7E/BqqZD1hnTByIaAFiwAw246YEltSq7tdrOH0Q==",requires:{"bn.js":"4.11.6","browserify-rsa":"4.0.1","create-hash":"1.2.0","parse-asn1":"5.1.1",randombytes:"2.0.6"}},"pull-cat":{version:"1.1.11",resolved:"https://registry.npmjs.org/pull-cat/-/pull-cat-1.1.11.tgz",integrity:"sha1-tkLdElXaN2pwa220+pYvX9t0wxs="},"pull-defer":{version:"0.2.2",resolved:"https://registry.npmjs.org/pull-defer/-/pull-defer-0.2.2.tgz",integrity:"sha1-CIew/7MK8ypW2+z6csFnInHwexM="},"pull-level":{version:"2.0.4",resolved:"https://registry.npmjs.org/pull-level/-/pull-level-2.0.4.tgz",integrity:"sha512-fW6pljDeUThpq5KXwKbRG3X7Ogk3vc75d5OQU/TvXXui65ykm+Bn+fiktg+MOx2jJ85cd+sheufPL+rw9QSVZg==",requires:{"level-post":"1.0.7","pull-cat":"1.1.11","pull-live":"1.0.1","pull-pushable":"2.2.0","pull-stream":"3.6.8","pull-window":"2.1.4","stream-to-pull-stream":"1.7.2"}},"pull-live":{version:"1.0.1",resolved:"https://registry.npmjs.org/pull-live/-/pull-live-1.0.1.tgz",integrity:"sha1-pOzuAeMwFV6RJLu89HYfIbOPUfU=",requires:{"pull-cat":"1.1.11","pull-stream":"3.6.8"}},"pull-pushable":{version:"2.2.0",resolved:"https://registry.npmjs.org/pull-pushable/-/pull-pushable-2.2.0.tgz",integrity:"sha1-Xy867UethpGfAbEqLpnW8b13ZYE="},"pull-stream":{version:"3.6.8",resolved:"https://registry.npmjs.org/pull-stream/-/pull-stream-3.6.8.tgz",integrity:"sha512-wQUIptQBcM0rFsUhZoEpOT3vUn73DtTGVq3NQ86c4T7iMOSprDzeKWYq2ksXnbwiuExTKvt+8G9fzNLFQuiO+A=="},"pull-window":{version:"2.1.4",resolved:"https://registry.npmjs.org/pull-window/-/pull-window-2.1.4.tgz",integrity:"sha1-/DuG/uvRkgx64pdpHiP3BfiFUvA=",requires:{looper:"2.0.0"}},punycode:{version:"1.4.1",resolved:"https://registry.npmjs.org/punycode/-/punycode-1.4.1.tgz",integrity:"sha1-wNWmOycYgArY4esPpSachN1BhF4="},qs:{version:"6.5.2",resolved:"https://registry.npmjs.org/qs/-/qs-6.5.2.tgz",integrity:"sha512-N5ZAX4/LxJmF+7wN74pUD6qAh9/wnvdQcjq9TZjevvXzSUo7bfmw91saqMjzGS2xq91/odN2dW/WOl7qQHNDGA=="},"query-string":{version:"5.1.1",resolved:"https://registry.npmjs.org/query-string/-/query-string-5.1.1.tgz",integrity:"sha512-gjWOsm2SoGlgLEdAGt7a6slVOk9mGiXmPFMqrEhLQ68rhQuBnpfs3+EmlvqKyxnCo9/PPlF+9MtY02S1aFg+Jw==",requires:{"decode-uri-component":"0.2.0","object-assign":"4.1.1","strict-uri-encode":"1.1.0"}},randombytes:{version:"2.0.6",resolved:"https://registry.npmjs.org/randombytes/-/randombytes-2.0.6.tgz",integrity:"sha512-CIQ5OFxf4Jou6uOKe9t1AOgqpeU5fd70A8NPdHSGeYXqXsPe6peOwI0cUl88RWZ6sP1vPMV3avd/R6cZ5/sP1A==",requires:{"safe-buffer":"5.1.2"}},randomfill:{version:"1.0.4",resolved:"https://registry.npmjs.org/randomfill/-/randomfill-1.0.4.tgz",integrity:"sha512-87lcbR8+MhcWcUiQ+9e+Rwx8MyR2P7qnt15ynUlbm3TU/fjbgz4GsvfSUDTemtCCtVCqb4ZcEFlyPNTh9bBTLw==",requires:{randombytes:"2.0.6","safe-buffer":"5.1.2"}},randomhex:{version:"0.1.5",resolved:"https://registry.npmjs.org/randomhex/-/randomhex-0.1.5.tgz",integrity:"sha1-us7vmCMpCRQA8qKRLGzQLxCU9YU="},"range-parser":{version:"1.2.0",resolved:"https://registry.npmjs.org/range-parser/-/range-parser-1.2.0.tgz",integrity:"sha1-9JvmtIeJTdxA3MlKMi9hEJLgDV4="},"raw-body":{version:"2.3.3",resolved:"https://registry.npmjs.org/raw-body/-/raw-body-2.3.3.tgz",integrity:"sha512-9esiElv1BrZoI3rCDuOuKCBRbuApGGaDPQfjSflGxdy4oyzqghxu6klEkkVIvBje+FF0BX9coEv8KqW6X/7njw==",requires:{bytes:"3.0.0","http-errors":"1.6.3","iconv-lite":"0.4.23",unpipe:"1.0.0"}},"read-pkg":{version:"1.1.0",resolved:"https://registry.npmjs.org/read-pkg/-/read-pkg-1.1.0.tgz",integrity:"sha1-9f+qXs0pyzHAR0vKfXVra7KePyg=",requires:{"load-json-file":"1.1.0","normalize-package-data":"2.4.0","path-type":"1.1.0"}},"read-pkg-up":{version:"1.0.1",resolved:"https://registry.npmjs.org/read-pkg-up/-/read-pkg-up-1.0.1.tgz",integrity:"sha1-nWPBMnbAZZGNV/ACpX9AobZD+wI=",requires:{"find-up":"1.1.2","read-pkg":"1.1.0"}},"readable-stream":{version:"2.3.6",resolved:"https://registry.npmjs.org/readable-stream/-/readable-stream-2.3.6.tgz",integrity:"sha512-tQtKA9WIAhBF3+VLAseyMqZeBjW0AHJoxOtYqSUZNJxauErmLbVm2FW1y+J/YA9dUrAC39ITejlZWhVIwawkKw==",requires:{"core-util-is":"1.0.2",inherits:"2.0.3",isarray:"1.0.0","process-nextick-args":"2.0.0","safe-buffer":"5.1.2",string_decoder:"1.1.1","util-deprecate":"1.0.2"},dependencies:{isarray:{version:"1.0.0",resolved:"https://registry.npmjs.org/isarray/-/isarray-1.0.0.tgz",integrity:"sha1-u5NdSFgsuhaMBoNJV6VKPgcSTxE="},string_decoder:{version:"1.1.1",resolved:"https://registry.npmjs.org/string_decoder/-/string_decoder-1.1.1.tgz",integrity:"sha512-n/ShnvDi6FHbbVfviro+WojiFzv+s8MPMHBczVePfUpDJLwoLT0ht1l4YwBCbi8pJAveEEdnkHyPyTP/mzRfwg==",requires:{"safe-buffer":"5.1.2"}}}},regenerate:{version:"1.4.0",resolved:"https://registry.npmjs.org/regenerate/-/regenerate-1.4.0.tgz",integrity:"sha512-1G6jJVDWrt0rK99kBjvEtziZNCICAuvIPkSiUFIQxVP06RCVpq3dmDo2oi6ABpYaDYaTRr67BEhL8r1wgEZZKg=="},"regenerator-runtime":{version:"0.11.1",resolved:"https://registry.npmjs.org/regenerator-runtime/-/regenerator-runtime-0.11.1.tgz",integrity:"sha512-MguG95oij0fC3QV3URf4V2SDYGJhJnJGqvIIgdECeODCT98wSWDAJ94SSuVpYQUoTcGUIL6L4yNB7j1DFFHSBg=="},"regenerator-transform":{version:"0.10.1",resolved:"https://registry.npmjs.org/regenerator-transform/-/regenerator-transform-0.10.1.tgz",integrity:"sha512-PJepbvDbuK1xgIgnau7Y90cwaAmO/LCLMI2mPvaXq2heGMR3aWW5/BQvYrhJ8jgmQjXewXvBjzfqKcVOmhjZ6Q==",requires:{"babel-runtime":"6.26.0","babel-types":"6.26.0",private:"0.1.8"}},"regexpu-core":{version:"2.0.0",resolved:"https://registry.npmjs.org/regexpu-core/-/regexpu-core-2.0.0.tgz",integrity:"sha1-SdA4g3uNz4v6W5pCE5k45uoq4kA=",requires:{regenerate:"1.4.0",regjsgen:"0.2.0",regjsparser:"0.1.5"}},regjsgen:{version:"0.2.0",resolved:"https://registry.npmjs.org/regjsgen/-/regjsgen-0.2.0.tgz",integrity:"sha1-bAFq3qxVT3WCP+N6wFuS1aTtsfc="},regjsparser:{version:"0.1.5",resolved:"https://registry.npmjs.org/regjsparser/-/regjsparser-0.1.5.tgz",integrity:"sha1-fuj4Tcb6eS0/0K4ijSS9lJ6tIFw=",requires:{jsesc:"0.5.0"}},repeating:{version:"2.0.1",resolved:"https://registry.npmjs.org/repeating/-/repeating-2.0.1.tgz",integrity:"sha1-UhTFOpJtNVJwdSf7q0FdvAjQbdo=",requires:{"is-finite":"1.0.2"}},request:{version:"2.87.0",resolved:"https://registry.npmjs.org/request/-/request-2.87.0.tgz",integrity:"sha512-fcogkm7Az5bsS6Sl0sibkbhcKsnyon/jV1kF3ajGmF0c8HrttdKTPRT9hieOaQHA5HEq6r8OyWOo/o781C1tNw==",requires:{"aws-sign2":"0.7.0",aws4:"1.7.0",caseless:"0.12.0","combined-stream":"1.0.6",extend:"3.0.1","forever-agent":"0.6.1","form-data":"2.3.2","har-validator":"5.0.3","http-signature":"1.2.0","is-typedarray":"1.0.0",isstream:"0.1.2","json-stringify-safe":"5.0.1","mime-types":"2.1.18","oauth-sign":"0.8.2","performance-now":"2.1.0",qs:"6.5.2","safe-buffer":"5.1.2","tough-cookie":"2.3.4","tunnel-agent":"0.6.0",uuid:"3.2.1"},dependencies:{uuid:{version:"3.2.1",resolved:"https://registry.npmjs.org/uuid/-/uuid-3.2.1.tgz",integrity:"sha512-jZnMwlb9Iku/O3smGWvZhauCf6cvvpKi4BKRiliS3cxnI+Gz9j5MEpTz2UFuXiKPJocb7gnsLHwiS05ige5BEA=="}}},"require-directory":{version:"2.1.1",resolved:"https://registry.npmjs.org/require-directory/-/require-directory-2.1.1.tgz",integrity:"sha1-jGStX9MNqxyXbiNE/+f3kqam30I="},"require-from-string":{version:"1.2.1",resolved:"https://registry.npmjs.org/require-from-string/-/require-from-string-1.2.1.tgz",integrity:"sha1-UpyczvJzgK3+yaL5ZbZJu+5jZBg="},"require-main-filename":{version:"1.0.1",resolved:"https://registry.npmjs.org/require-main-filename/-/require-main-filename-1.0.1.tgz",integrity:"sha1-l/cXtp1IeE9fUmpsWqj/3aBVpNE="},resolve:{version:"1.5.0",resolved:"https://registry.npmjs.org/resolve/-/resolve-1.5.0.tgz",integrity:"sha512-hgoSGrc3pjzAPHNBg+KnFcK2HwlHTs/YrAGUr6qgTVUZmXv1UEXXl0bZNBKMA9fud6lRYFdPGz0xXxycPzmmiw==",requires:{"path-parse":"1.0.5"}},resumer:{version:"0.0.0",resolved:"https://registry.npmjs.org/resumer/-/resumer-0.0.0.tgz",integrity:"sha1-8ej0YeQGS6Oegq883CqMiT0HZ1k=",requires:{through:"2.3.8"}},rimraf:{version:"2.6.2",resolved:"https://registry.npmjs.org/rimraf/-/rimraf-2.6.2.tgz",integrity:"sha512-lreewLK/BlghmxtfH36YYVg1i8IAce4TI7oao75I1g245+6BctqTVQiBP3YUJ9C6DQOXJmkYR9X9fCLtCOJc5w==",requires:{glob:"7.1.2"}},ripemd160:{version:"2.0.2",resolved:"https://registry.npmjs.org/ripemd160/-/ripemd160-2.0.2.tgz",integrity:"sha512-ii4iagi25WusVoiC4B4lq7pbXfAp3D9v5CwfkY33vffw2+pkDjY1D8GaN7spsxvCSx8dkPqOZCEZyfxcmJG2IA==",requires:{"hash-base":"3.0.4",inherits:"2.0.3"}},rlp:{version:"2.0.0",resolved:"https://registry.npmjs.org/rlp/-/rlp-2.0.0.tgz",integrity:"sha1-nbOE/0uJqPYVY9kjldhiWxjzr7A="},"rustbn.js":{version:"0.1.2",resolved:"https://registry.npmjs.org/rustbn.js/-/rustbn.js-0.1.2.tgz",integrity:"sha512-bAkNqSHYdJdFsBC7Z11JgzYktL31HIpB2o70jZcGiL1U1TVtPyvaVhDrGWwS8uZtaqwW2k6NOPGZCqW/Dgh5Lg=="},"safe-buffer":{version:"5.1.2",resolved:"https://registry.npmjs.org/safe-buffer/-/safe-buffer-5.1.2.tgz",integrity:"sha512-Gd2UZBJDkXlY7GbJxfsE8/nvKkUEU1G38c1siN6QP6a9PT9MmHB8GnpscSmMJSoF8LOIrt8ud/wPtojys4G6+g=="},"safer-buffer":{version:"2.1.2",resolved:"https://registry.npmjs.org/safer-buffer/-/safer-buffer-2.1.2.tgz",integrity:"sha512-YZo3K82SD7Riyi0E1EQPojLz7kpepnSQI9IyPbHHg1XXXevb5dJI7tpyN2ADxGcQbHG7vcyRHk0cbwqcQriUtg=="},scrypt:{version:"6.0.3",resolved:"https://registry.npmjs.org/scrypt/-/scrypt-6.0.3.tgz",integrity:"sha1-BOAUpWgrU/pQwtXM4WfXGcBthw0=",requires:{nan:"2.10.0"}},"scrypt.js":{version:"0.2.0",resolved:"https://registry.npmjs.org/scrypt.js/-/scrypt.js-0.2.0.tgz",integrity:"sha1-r40UZbcemZARC+38WTuUeeA6ito=",requires:{scrypt:"6.0.3",scryptsy:"1.2.1"}},scryptsy:{version:"1.2.1",resolved:"https://registry.npmjs.org/scryptsy/-/scryptsy-1.2.1.tgz",integrity:"sha1-oyJfpLJST4AnAHYeKFW987LZIWM=",requires:{pbkdf2:"3.0.16"}},secp256k1:{version:"3.5.0",resolved:"https://registry.npmjs.org/secp256k1/-/secp256k1-3.5.0.tgz",integrity:"sha512-e5QIJl8W7Y4tT6LHffVcZAxJjvpgE5Owawv6/XCYPQljE9aP2NFFddQ8OYMKhdLshNu88FfL3qCN3/xYkXGRsA==",requires:{bindings:"1.3.0",bip66:"1.1.5","bn.js":"4.11.6","create-hash":"1.2.0","drbg.js":"1.0.1",elliptic:"6.4.0",nan:"2.10.0","safe-buffer":"5.1.2"}},seedrandom:{version:"2.4.3",resolved:"https://registry.npmjs.org/seedrandom/-/seedrandom-2.4.3.tgz",integrity:"sha1-JDhQTa0zkXMUv/GKxNeU8W1qrsw="},"seek-bzip":{version:"1.0.5",resolved:"https://registry.npmjs.org/seek-bzip/-/seek-bzip-1.0.5.tgz",integrity:"sha1-z+kXyz0nS8/6x5J1ivUxc+sfq9w=",requires:{commander:"2.8.1"}},semaphore:{version:"1.1.0",resolved:"https://registry.npmjs.org/semaphore/-/semaphore-1.1.0.tgz",integrity:"sha512-O4OZEaNtkMd/K0i6js9SL+gqy0ZCBMgUvlSqHKi4IBdjhe7wB8pwztUk1BbZ1fmrvpwFrPbHzqd2w5pTcJH6LA=="},semver:{version:"5.4.1",resolved:"https://registry.npmjs.org/semver/-/semver-5.4.1.tgz",integrity:"sha512-WfG/X9+oATh81XtllIo/I8gOiY9EXRdv1cQdyykeXK17YcUW3EXUAi2To4pcH6nZtJPr7ZOpM5OMyWJZm+8Rsg=="},send:{version:"0.16.2",resolved:"https://registry.npmjs.org/send/-/send-0.16.2.tgz",integrity:"sha512-E64YFPUssFHEFBvpbbjr44NCLtI1AohxQ8ZSiJjQLskAdKuriYEP6VyGEsRDH8ScozGpkaX1BGvhanqCwkcEZw==",requires:{debug:"2.6.9",depd:"1.1.2",destroy:"1.0.4",encodeurl:"1.0.2","escape-html":"1.0.3",etag:"1.8.1",fresh:"0.5.2","http-errors":"1.6.3",mime:"1.4.1",ms:"2.0.0","on-finished":"2.3.0","range-parser":"1.2.0",statuses:"1.4.0"},dependencies:{statuses:{version:"1.4.0",resolved:"https://registry.npmjs.org/statuses/-/statuses-1.4.0.tgz",integrity:"sha512-zhSCtt8v2NDrRlPQpCNtw/heZLtfUDqxBM1udqikb/Hbk52LK4nQSwr10u77iopCW5LsyHpuXS0GnEc48mLeew=="}}},"serve-static":{version:"1.13.2",resolved:"https://registry.npmjs.org/serve-static/-/serve-static-1.13.2.tgz",integrity:"sha512-p/tdJrO4U387R9oMjb1oj7qSMaMfmOyd4j9hOFoxZe2baQszgHcSWjuya/CiT5kgZZKRudHNOA0pYXOl8rQ5nw==",requires:{encodeurl:"1.0.2","escape-html":"1.0.3",parseurl:"1.3.2",send:"0.16.2"}},servify:{version:"0.1.12",resolved:"https://registry.npmjs.org/servify/-/servify-0.1.12.tgz",integrity:"sha512-/xE6GvsKKqyo1BAY+KxOWXcLpPsUUyji7Qg3bVD7hh1eRze5bR1uYiuDA/k3Gof1s9BTzQZEJK8sNcNGFIzeWw==",requires:{"body-parser":"1.18.3",cors:"2.8.4",express:"4.16.3",request:"2.87.0",xhr:"2.5.0"}},"set-blocking":{version:"2.0.0",resolved:"https://registry.npmjs.org/set-blocking/-/set-blocking-2.0.0.tgz",integrity:"sha1-BF+XgtARrppoA93TgrJDkrPYkPc="},"set-immediate-shim":{version:"1.0.1",resolved:"https://registry.npmjs.org/set-immediate-shim/-/set-immediate-shim-1.0.1.tgz",integrity:"sha1-SysbJ+uAip+NzEgaWOXlb1mfP2E="},setimmediate:{version:"1.0.5",resolved:"https://registry.npmjs.org/setimmediate/-/setimmediate-1.0.5.tgz",integrity:"sha1-KQy7Iy4waULX1+qbg3Mqt4VvgoU="},setprototypeof:{version:"1.1.0",resolved:"https://registry.npmjs.org/setprototypeof/-/setprototypeof-1.1.0.tgz",integrity:"sha512-BvE/TwpZX4FXExxOxZyRGQQv651MSwmWKZGqvmPcRIjDqWub67kTKuIMx43cZZrS/cBBzwBcNDWoFxt2XEFIpQ=="},"sha.js":{version:"2.4.11",resolved:"https://registry.npmjs.org/sha.js/-/sha.js-2.4.11.tgz",integrity:"sha512-QMEp5B7cftE7APOjk5Y6xgrbWu+WkLVQwk8JNjZ8nKRciZaByEW6MubieAiToS7+dwvrjGhH8jRXz3MVd0AYqQ==",requires:{inherits:"2.0.3","safe-buffer":"5.1.2"}},sha3:{version:"1.2.2",resolved:"https://registry.npmjs.org/sha3/-/sha3-1.2.2.tgz",integrity:"sha1-pmxQmN5MJbyIM27ItIF9AFvKe6k=",requires:{nan:"2.10.0"}},"shebang-loader":{version:"0.0.1",resolved:"https://registry.npmjs.org/shebang-loader/-/shebang-loader-0.0.1.tgz",integrity:"sha1-pAAEldRMzu++xjQ157FphWn6Uuw="},"simple-concat":{version:"1.0.0",resolved:"https://registry.npmjs.org/simple-concat/-/simple-concat-1.0.0.tgz",integrity:"sha1-c0TLuLbib7J9ZrL8hvn21Zl1IcY="},"simple-get":{version:"2.8.1",resolved:"https://registry.npmjs.org/simple-get/-/simple-get-2.8.1.tgz",integrity:"sha512-lSSHRSw3mQNUGPAYRqo7xy9dhKmxFXIjLjp4KHpf99GEH2VH7C3AM+Qfx6du6jhfUi6Vm7XnbEVEf7Wb6N8jRw==",requires:{"decompress-response":"3.3.0",once:"1.4.0","simple-concat":"1.0.0"}},slash:{version:"1.0.0",resolved:"https://registry.npmjs.org/slash/-/slash-1.0.0.tgz",integrity:"sha1-xB8vbDn8FtHNF61LXYlhFK5HDVU="},solc:{version:"0.4.24",resolved:"https://registry.npmjs.org/solc/-/solc-0.4.24.tgz",integrity:"sha512-2xd7Cf1HeVwrIb6Bu1cwY2/TaLRodrppCq3l7rhLimFQgmxptXhTC3+/wesVLpB09F1A2kZgvbMOgH7wvhFnBQ==",requires:{"fs-extra":"0.30.0",memorystream:"0.3.1","require-from-string":"1.2.1",semver:"5.4.1",yargs:"4.8.1"},dependencies:{yargs:{version:"4.8.1",resolved:"https://registry.npmjs.org/yargs/-/yargs-4.8.1.tgz",integrity:"sha1-wMQpJMpKqmsObaFznfshZDn53cA=",requires:{cliui:"3.2.0",decamelize:"1.2.0","get-caller-file":"1.0.2","lodash.assign":"4.2.0","os-locale":"1.4.0","read-pkg-up":"1.0.1","require-directory":"2.1.1","require-main-filename":"1.0.1","set-blocking":"2.0.0","string-width":"1.0.2","which-module":"1.0.0","window-size":"0.2.0",y18n:"3.2.1","yargs-parser":"2.4.1"}}}},"source-map":{version:"0.5.7",resolved:"https://registry.npmjs.org/source-map/-/source-map-0.5.7.tgz",integrity:"sha1-igOdLRAh0i0eoUyA2OpGi6LvP8w="},"source-map-support":{version:"0.4.18",resolved:"https://registry.npmjs.org/source-map-support/-/source-map-support-0.4.18.tgz",integrity:"sha512-try0/JqxPLF9nOjvSta7tVondkP5dwgyLDjVoyMDlmjugT2lRZ1OfsrYTkCd2hkDnJTKRbO/Rl3orm8vlsUzbA==",requires:{"source-map":"0.5.7"}},"spdx-correct":{version:"3.0.0",resolved:"https://registry.npmjs.org/spdx-correct/-/spdx-correct-3.0.0.tgz",integrity:"sha512-N19o9z5cEyc8yQQPukRCZ9EUmb4HUpnrmaL/fxS2pBo2jbfcFRVuFZ/oFC+vZz0MNNk0h80iMn5/S6qGZOL5+g==",requires:{"spdx-expression-parse":"3.0.0","spdx-license-ids":"3.0.0"}},"spdx-exceptions":{version:"2.1.0",resolved:"https://registry.npmjs.org/spdx-exceptions/-/spdx-exceptions-2.1.0.tgz",integrity:"sha512-4K1NsmrlCU1JJgUrtgEeTVyfx8VaYea9J9LvARxhbHtVtohPs/gFGG5yy49beySjlIMhhXZ4QqujIZEfS4l6Cg=="},"spdx-expression-parse":{version:"3.0.0",resolved:"https://registry.npmjs.org/spdx-expression-parse/-/spdx-expression-parse-3.0.0.tgz",integrity:"sha512-Yg6D3XpRD4kkOmTpdgbUiEJFKghJH03fiC1OPll5h/0sO6neh2jqRDVHOQ4o/LMea0tgCkbMgea5ip/e+MkWyg==",requires:{"spdx-exceptions":"2.1.0","spdx-license-ids":"3.0.0"}},"spdx-license-ids":{version:"3.0.0",resolved:"https://registry.npmjs.org/spdx-license-ids/-/spdx-license-ids-3.0.0.tgz",integrity:"sha512-2+EPwgbnmOIl8HjGBXXMd9NAu02vLjOO1nWw4kmeRDFyHn+M/ETfHxQUK0oXg8ctgVnl9t3rosNVsZ1jG61nDA=="},sshpk:{version:"1.14.2",resolved:"https://registry.npmjs.org/sshpk/-/sshpk-1.14.2.tgz",integrity:"sha1-xvxhZIo9nE52T9P8306hBeSSupg=",requires:{asn1:"0.2.3","assert-plus":"1.0.0","bcrypt-pbkdf":"1.0.1",dashdash:"1.14.1","ecc-jsbn":"0.1.1",getpass:"0.1.7",jsbn:"0.1.1","safer-buffer":"2.1.2",tweetnacl:"0.14.5"}},statuses:{version:"1.5.0",resolved:"https://registry.npmjs.org/statuses/-/statuses-1.5.0.tgz",integrity:"sha1-Fhx9rBd2Wf2YEfQ3cfqZOBR4Yow="},"stream-to-pull-stream":{version:"1.7.2",resolved:"https://registry.npmjs.org/stream-to-pull-stream/-/stream-to-pull-stream-1.7.2.tgz",integrity:"sha1-dXYJrhzr0zx0MtSvvjH/eGULnd4=",requires:{looper:"3.0.0","pull-stream":"3.6.8"},dependencies:{looper:{version:"3.0.0",resolved:"https://registry.npmjs.org/looper/-/looper-3.0.0.tgz",integrity:"sha1-LvpUw7HLq6m5Su4uWRSwvlf7t0k="}}},"strict-uri-encode":{version:"1.1.0",resolved:"https://registry.npmjs.org/strict-uri-encode/-/strict-uri-encode-1.1.0.tgz",integrity:"sha1-J5siXfHVgrH1TmWt3UNS4Y+qBxM="},"string-width":{version:"1.0.2",resolved:"https://registry.npmjs.org/string-width/-/string-width-1.0.2.tgz",integrity:"sha1-EYvfW4zcUaKn5w0hHgfisLmxB9M=",requires:{"code-point-at":"1.1.0","is-fullwidth-code-point":"1.0.0","strip-ansi":"3.0.1"}},"string.prototype.trim":{version:"1.1.2",resolved:"https://registry.npmjs.org/string.prototype.trim/-/string.prototype.trim-1.1.2.tgz",integrity:"sha1-0E3iyJ4Tf019IG8Ia17S+ua+jOo=",requires:{"define-properties":"1.1.2","es-abstract":"1.12.0","function-bind":"1.1.1"}},string_decoder:{version:"0.10.31",resolved:"https://registry.npmjs.org/string_decoder/-/string_decoder-0.10.31.tgz",integrity:"sha1-YuIDvEF2bGwoyfyEMB2rHFMQ+pQ="},"strip-ansi":{version:"3.0.1",resolved:"https://registry.npmjs.org/strip-ansi/-/strip-ansi-3.0.1.tgz",integrity:"sha1-ajhfuIU9lS1f8F0Oiq+UJ43GPc8=",requires:{"ansi-regex":"2.1.1"}},"strip-bom":{version:"2.0.0",resolved:"https://registry.npmjs.org/strip-bom/-/strip-bom-2.0.0.tgz",integrity:"sha1-YhmoVhZSBJHzV4i9vxRHqZx+aw4=",requires:{"is-utf8":"0.2.1"}},"strip-dirs":{version:"2.1.0",resolved:"https://registry.npmjs.org/strip-dirs/-/strip-dirs-2.1.0.tgz",integrity:"sha512-JOCxOeKLm2CAS73y/U4ZeZPTkE+gNVCzKt7Eox84Iej1LT/2pTWYpZKJuxwQpvX1LiZb1xokNR7RLfuBAa7T3g==",requires:{"is-natural-number":"4.0.1"}},"strip-hex-prefix":{version:"1.0.0",resolved:"https://registry.npmjs.org/strip-hex-prefix/-/strip-hex-prefix-1.0.0.tgz",integrity:"sha1-DF8VX+8RUTczd96du1iNoFUA428=",requires:{"is-hex-prefixed":"1.0.0"}},"supports-color":{version:"2.0.0",resolved:"https://registry.npmjs.org/supports-color/-/supports-color-2.0.0.tgz",integrity:"sha1-U10EXOa2Nj+kARcIRimZXp3zJMc="},"swarm-js":{version:"0.1.37",resolved:"https://registry.npmjs.org/swarm-js/-/swarm-js-0.1.37.tgz",integrity:"sha512-G8gi5fcXP/2upwiuOShJ258sIufBVztekgobr3cVgYXObZwJ5AXLqZn52AI+/ffft29pJexF9WNdUxjlkVehoQ==",requires:{bluebird:"3.5.1",buffer:"5.1.0",decompress:"4.2.0","eth-lib":"0.1.27","fs-extra":"2.1.2","fs-promise":"2.0.3",got:"7.1.0","mime-types":"2.1.18","mkdirp-promise":"5.0.1","mock-fs":"4.5.0",setimmediate:"1.0.5","tar.gz":"1.0.7","xhr-request-promise":"0.1.2"},dependencies:{"fs-extra":{version:"2.1.2",resolved:"https://registry.npmjs.org/fs-extra/-/fs-extra-2.1.2.tgz",integrity:"sha1-BGxwFjzvmq1GsOSn+kZ/si1x3jU=",requires:{"graceful-fs":"4.1.11",jsonfile:"2.4.0"}}}},tape:{version:"4.9.0",resolved:"https://registry.npmjs.org/tape/-/tape-4.9.0.tgz",integrity:"sha512-j0jO9BiScfqtPBb9QmPLL0qvxXMz98xjkMb7x8lKipFlJZwNJkqkWPou+NU4V6T9RnVh1kuSthLE8gLrN8bBfw==",requires:{"deep-equal":"1.0.1",defined:"1.0.0","for-each":"0.3.2","function-bind":"1.1.1",glob:"7.1.2",has:"1.0.3",inherits:"2.0.3",minimist:"1.2.0","object-inspect":"1.5.0",resolve:"1.5.0",resumer:"0.0.0","string.prototype.trim":"1.1.2",through:"2.3.8"},dependencies:{minimist:{version:"1.2.0",resolved:"https://registry.npmjs.org/minimist/-/minimist-1.2.0.tgz",integrity:"sha1-o1AIsg9BOD7sH7kU9M1d95omQoQ="}}},tar:{version:"2.2.1",resolved:"https://registry.npmjs.org/tar/-/tar-2.2.1.tgz",integrity:"sha1-jk0qJWwOIYXGsYrWlK7JaLg8sdE=",requires:{"block-stream":"0.0.9",fstream:"1.0.11",inherits:"2.0.3"}},"tar-stream":{version:"1.6.1",resolved:"https://registry.npmjs.org/tar-stream/-/tar-stream-1.6.1.tgz",integrity:"sha512-IFLM5wp3QrJODQFPm6/to3LJZrONdBY/otxcvDIQzu217zKye6yVR3hhi9lAjrC2Z+m/j5oDxMPb1qcd8cIvpA==",requires:{bl:"1.2.2","buffer-alloc":"1.1.0","end-of-stream":"1.4.1","fs-constants":"1.0.0","readable-stream":"2.3.6","to-buffer":"1.1.1",xtend:"4.0.1"},dependencies:{bl:{version:"1.2.2",resolved:"https://registry.npmjs.org/bl/-/bl-1.2.2.tgz",integrity:"sha512-e8tQYnZodmebYDWGH7KMRvtzKXaJHx3BbilrgZCfvyLUYdKpK1t5PSPmpkny/SgiTSCnjfLW7v5rlONXVFkQEA==",requires:{"readable-stream":"2.3.6","safe-buffer":"5.1.2"}}}},"tar.gz":{version:"1.0.7",resolved:"https://registry.npmjs.org/tar.gz/-/tar.gz-1.0.7.tgz",integrity:"sha512-uhGatJvds/3diZrETqMj4RxBR779LKlIE74SsMcn5JProZsfs9j0QBwWO1RW+IWNJxS2x8Zzra1+AW6OQHWphg==",requires:{bluebird:"2.11.0",commander:"2.8.1",fstream:"1.0.11",mout:"0.11.1",tar:"2.2.1"},dependencies:{bluebird:{version:"2.11.0",resolved:"https://registry.npmjs.org/bluebird/-/bluebird-2.11.0.tgz",integrity:"sha1-U0uQM8AiyVecVro7Plpcqvu2UOE="}}},temp:{version:"0.8.3",resolved:"https://registry.npmjs.org/temp/-/temp-0.8.3.tgz",integrity:"sha1-4Ma8TSa5AxJEEOT+2BEDAU38H1k=",requires:{"os-tmpdir":"1.0.2",rimraf:"2.2.8"},dependencies:{rimraf:{version:"2.2.8",resolved:"https://registry.npmjs.org/rimraf/-/rimraf-2.2.8.tgz",integrity:"sha1-5Dm+Kq7jJzIZUnMPmaiSnk/FBYI="}}},thenify:{version:"3.3.0",resolved:"https://registry.npmjs.org/thenify/-/thenify-3.3.0.tgz",integrity:"sha1-5p44obq+lpsBCCB5eLn2K4hgSDk=",requires:{"any-promise":"1.3.0"}},"thenify-all":{version:"1.6.0",resolved:"https://registry.npmjs.org/thenify-all/-/thenify-all-1.6.0.tgz",integrity:"sha1-GhkY1ALY/D+Y+/I02wvMjMEOlyY=",requires:{thenify:"3.3.0"}},through:{version:"2.3.8",resolved:"https://registry.npmjs.org/through/-/through-2.3.8.tgz",integrity:"sha1-DdTJ/6q8NXlgsbckEV1+Doai4fU="},through2:{version:"2.0.3",resolved:"https://registry.npmjs.org/through2/-/through2-2.0.3.tgz",integrity:"sha1-AARWmzfHx0ujnEPzzteNGtlBQL4=",requires:{"readable-stream":"2.3.6",xtend:"4.0.1"}},"timed-out":{version:"4.0.1",resolved:"https://registry.npmjs.org/timed-out/-/timed-out-4.0.1.tgz",integrity:"sha1-8y6srFoXW+ol1/q1Zas+2HQe9W8="},"tiny-queue":{version:"0.2.0",resolved:"https://registry.npmjs.org/tiny-queue/-/tiny-queue-0.2.0.tgz",integrity:"sha1-xJ/LXIdVW+G0pd9+uHEB1beLydw="},tmp:{version:"0.0.31",resolved:"https://registry.npmjs.org/tmp/-/tmp-0.0.31.tgz",integrity:"sha1-jzirlDjhcxXl29izZX6L+yd65Kc=",requires:{"os-tmpdir":"1.0.2"}},"to-buffer":{version:"1.1.1",resolved:"https://registry.npmjs.org/to-buffer/-/to-buffer-1.1.1.tgz",integrity:"sha512-lx9B5iv7msuFYE3dytT+KE5tap+rNYw+K4jVkb9R/asAb+pbBSM17jtunHplhBe6RRJdZx3Pn2Jph24O32mOVg=="},"to-fast-properties":{version:"1.0.3",resolved:"https://registry.npmjs.org/to-fast-properties/-/to-fast-properties-1.0.3.tgz",integrity:"sha1-uDVx+k2MJbguIxsG46MFXeTKGkc="},"tough-cookie":{version:"2.3.4",resolved:"https://registry.npmjs.org/tough-cookie/-/tough-cookie-2.3.4.tgz",integrity:"sha512-TZ6TTfI5NtZnuyy/Kecv+CnoROnyXn2DN97LontgQpCwsX2XyLYCC0ENhYkehSOwAp8rTQKc/NUIF7BkQ5rKLA==",requires:{punycode:"1.4.1"}},treeify:{version:"1.1.0",resolved:"https://registry.npmjs.org/treeify/-/treeify-1.1.0.tgz",integrity:"sha512-1m4RA7xVAJrSGrrXGs0L3YTwyvBs2S8PbRHaLZAkFw7JR8oIFwYtysxlBZhYIa7xSyiYJKZ3iGrrk55cGA3i9A=="},trim:{version:"0.0.1",resolved:"https://registry.npmjs.org/trim/-/trim-0.0.1.tgz",integrity:"sha1-WFhUf2spB1fulczMZm+1AITEYN0="},"trim-right":{version:"1.0.1",resolved:"https://registry.npmjs.org/trim-right/-/trim-right-1.0.1.tgz",integrity:"sha1-yy4SAwZ+DI3h9hQJS5/kVwTqYAM="},"tunnel-agent":{version:"0.6.0",resolved:"https://registry.npmjs.org/tunnel-agent/-/tunnel-agent-0.6.0.tgz",integrity:"sha1-J6XeoGs2sEoKmWZ3SykIaPD8QP0=",requires:{"safe-buffer":"5.1.2"}},tweetnacl:{version:"0.14.5",resolved:"https://registry.npmjs.org/tweetnacl/-/tweetnacl-0.14.5.tgz",integrity:"sha1-WuaBd/GS1EViadEIr6k/+HQ/T2Q=",optional:!0},"type-detect":{version:"1.0.0",resolved:"https://registry.npmjs.org/type-detect/-/type-detect-1.0.0.tgz",integrity:"sha1-diIXzAbbJY7EiQihKY6LlRIejqI="},"type-is":{version:"1.6.16",resolved:"https://registry.npmjs.org/type-is/-/type-is-1.6.16.tgz",integrity:"sha512-HRkVv/5qY2G6I8iab9cI7v1bOIdhm94dVjQCPFElW9W+3GeDOSHmy2EBYe4VTApuzolPcmgFTN3ftVJRKR2J9Q==",requires:{"media-typer":"0.3.0","mime-types":"2.1.18"}},typedarray:{version:"0.0.6",resolved:"https://registry.npmjs.org/typedarray/-/typedarray-0.0.6.tgz",integrity:"sha1-hnrHTjhkGHsdPUfZlqeOxciDB3c="},"typedarray-to-buffer":{version:"3.1.5",resolved:"https://registry.npmjs.org/typedarray-to-buffer/-/typedarray-to-buffer-3.1.5.tgz",integrity:"sha512-zdu8XMNEDepKKR+XYOXAVPtWui0ly0NtohUscw+UmaHiAWT8hrV1rr//H6V+0DvJ3OQ19S979M0laLfX8rm82Q==",requires:{"is-typedarray":"1.0.0"}},typewise:{version:"1.0.3",resolved:"https://registry.npmjs.org/typewise/-/typewise-1.0.3.tgz",integrity:"sha1-EGeTZUCvl5N8xdz5kiSG6fooRlE=",requires:{"typewise-core":"1.2.0"}},"typewise-core":{version:"1.2.0",resolved:"https://registry.npmjs.org/typewise-core/-/typewise-core-1.2.0.tgz",integrity:"sha1-l+uRgFx/VdL5QXSPpQ0xXZke8ZU="},typewiselite:{version:"1.0.0",resolved:"https://registry.npmjs.org/typewiselite/-/typewiselite-1.0.0.tgz",integrity:"sha1-yIgvobsQksBgBal/NO9chQjjZk4="},ultron:{version:"1.1.1",resolved:"https://registry.npmjs.org/ultron/-/ultron-1.1.1.tgz",integrity:"sha512-UIEXBNeYmKptWH6z8ZnqTeS8fV74zG0/eRU9VGkpzz+LIJNs8W/zM/L+7ctCkRrgbNnnR0xxw4bKOr0cW0N0Og=="},"unbzip2-stream":{version:"1.2.5",resolved:"https://registry.npmjs.org/unbzip2-stream/-/unbzip2-stream-1.2.5.tgz",integrity:"sha512-izD3jxT8xkzwtXRUZjtmRwKnZoeECrfZ8ra/ketwOcusbZEp4mjULMnJOCfTDZBgGQAAY1AJ/IgxcwkavcX9Og==",requires:{buffer:"3.6.0",through:"2.3.8"},dependencies:{"base64-js":{version:"0.0.8",resolved:"https://registry.npmjs.org/base64-js/-/base64-js-0.0.8.tgz",integrity:"sha1-EQHpVE9KdrG8OybUUsqW16NeeXg="},buffer:{version:"3.6.0",resolved:"https://registry.npmjs.org/buffer/-/buffer-3.6.0.tgz",integrity:"sha1-pyyTb3e5a/UvX357RnGAYoVR3vs=",requires:{"base64-js":"0.0.8",ieee754:"1.1.11",isarray:"1.0.0"}},isarray:{version:"1.0.0",resolved:"https://registry.npmjs.org/isarray/-/isarray-1.0.0.tgz",integrity:"sha1-u5NdSFgsuhaMBoNJV6VKPgcSTxE="}}},underscore:{version:"1.8.3",resolved:"https://registry.npmjs.org/underscore/-/underscore-1.8.3.tgz",integrity:"sha1-Tz+1OxBuYJf8+ctBCfKl6b36UCI="},unorm:{version:"1.4.1",resolved:"https://registry.npmjs.org/unorm/-/unorm-1.4.1.tgz",integrity:"sha1-NkIA1fE2RsqLzURJAnEzVhR5IwA="},unpipe:{version:"1.0.0",resolved:"https://registry.npmjs.org/unpipe/-/unpipe-1.0.0.tgz",integrity:"sha1-sr9O6FFKrmFltIF4KdIbLvSZBOw="},"url-parse-lax":{version:"1.0.0",resolved:"https://registry.npmjs.org/url-parse-lax/-/url-parse-lax-1.0.0.tgz",integrity:"sha1-evjzA2Rem9eaJy56FKxovAYJ2nM=",requires:{"prepend-http":"1.0.4"}},"url-set-query":{version:"1.0.0",resolved:"https://registry.npmjs.org/url-set-query/-/url-set-query-1.0.0.tgz",integrity:"sha1-AW6M/Xwg7gXK/neV6JK9BwL6ozk="},"url-to-options":{version:"1.0.1",resolved:"https://registry.npmjs.org/url-to-options/-/url-to-options-1.0.1.tgz",integrity:"sha1-FQWgOiiaSMvXpDTvuu7FBV9WM6k="},utf8:{version:"2.1.2",resolved:"https://registry.npmjs.org/utf8/-/utf8-2.1.2.tgz",integrity:"sha1-H6DZJw6b6FDZsFAn9jUZv0ZFfZY="},util:{version:"0.10.3",resolved:"https://registry.npmjs.org/util/-/util-0.10.3.tgz",integrity:"sha1-evsa/lCAUkZInj23/g7TeTNqwPk=",dev:!0,requires:{inherits:"2.0.1"},dependencies:{inherits:{version:"2.0.1",resolved:"https://registry.npmjs.org/inherits/-/inherits-2.0.1.tgz",integrity:"sha1-sX0I0ya0Qj5Wjv9xn5GwscvfafE=",dev:!0}}},"util-deprecate":{version:"1.0.2",resolved:"https://registry.npmjs.org/util-deprecate/-/util-deprecate-1.0.2.tgz",integrity:"sha1-RQ1Nyfpw3nMnYvvS1KKJgUGaDM8="},"utils-merge":{version:"1.0.1",resolved:"https://registry.npmjs.org/utils-merge/-/utils-merge-1.0.1.tgz",integrity:"sha1-n5VxD1CiZ5R7LMwSR0HBAoQn5xM="},uuid:{version:"2.0.3",resolved:"https://registry.npmjs.org/uuid/-/uuid-2.0.3.tgz",integrity:"sha1-Z+LoY3lyFVMN/zGOW/nc6/1Hsho="},"validate-npm-package-license":{version:"3.0.3",resolved:"https://registry.npmjs.org/validate-npm-package-license/-/validate-npm-package-license-3.0.3.tgz",integrity:"sha512-63ZOUnL4SIXj4L0NixR3L1lcjO38crAbgrTpl28t8jjrfuiOBL5Iygm+60qPs/KsZGzPNg6Smnc/oY16QTjF0g==",requires:{"spdx-correct":"3.0.0","spdx-expression-parse":"3.0.0"}},vary:{version:"1.1.2",resolved:"https://registry.npmjs.org/vary/-/vary-1.1.2.tgz",integrity:"sha1-IpnwLG3tMNSllhsLn3RSShj2NPw="},verror:{version:"1.10.0",resolved:"https://registry.npmjs.org/verror/-/verror-1.10.0.tgz",integrity:"sha1-OhBcoXBTr1XW4nDB+CiGguGNpAA=",requires:{"assert-plus":"1.0.0","core-util-is":"1.0.2",extsprintf:"1.3.0"}},web3:{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3/-/web3-1.0.0-beta.34.tgz",integrity:"sha1-NH5WG3hAmMtVYzFfSQR5odkfKrE=",requires:{"web3-bzz":"1.0.0-beta.34","web3-core":"1.0.0-beta.34","web3-eth":"1.0.0-beta.34","web3-eth-personal":"1.0.0-beta.34","web3-net":"1.0.0-beta.34","web3-shh":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-bzz":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-bzz/-/web3-bzz-1.0.0-beta.34.tgz",integrity:"sha1-Bo03d3q2Xlxg+OyLmlDP5FJ3kpw=",requires:{got:"7.1.0","swarm-js":"0.1.37",underscore:"1.8.3"}},"web3-core":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core/-/web3-core-1.0.0-beta.34.tgz",integrity:"sha1-EhvoVV6fsA0sXQXd0zgdDJ5GmH4=",requires:{"web3-core-helpers":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-core-requestmanager":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-core-helpers":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core-helpers/-/web3-core-helpers-1.0.0-beta.34.tgz",integrity:"sha1-sWjaANPhnhVrwVriAyA91N/uLQM=",requires:{underscore:"1.8.3","web3-eth-iban":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-core-method":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core-method/-/web3-core-method-1.0.0-beta.34.tgz",integrity:"sha1-7BY8iixJD6AqfsFVWfpzB/x8xt0=",requires:{underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34","web3-core-promievent":"1.0.0-beta.34","web3-core-subscriptions":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-core-promievent":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core-promievent/-/web3-core-promievent-1.0.0-beta.34.tgz",integrity:"sha1-pPT6Z4S7KT6CxglgrltWqUzQPtw=",requires:{"any-promise":"1.3.0",eventemitter3:"1.1.1"}},"web3-core-requestmanager":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core-requestmanager/-/web3-core-requestmanager-1.0.0-beta.34.tgz",integrity:"sha1-Afj2zyrmtvC3DDi64e90G1urIVw=",requires:{underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34","web3-providers-http":"1.0.0-beta.34","web3-providers-ipc":"1.0.0-beta.34","web3-providers-ws":"1.0.0-beta.34"}},"web3-core-subscriptions":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-core-subscriptions/-/web3-core-subscriptions-1.0.0-beta.34.tgz",integrity:"sha1-n+0UQDPyIcPPIQYDAv/a9e8t4t4=",requires:{eventemitter3:"1.1.1",underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34"}},"web3-eth":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth/-/web3-eth-1.0.0-beta.34.tgz",integrity:"sha1-dAhgAIUMb+b1Ne9Jg31tS7YRMmg=",requires:{underscore:"1.8.3","web3-core":"1.0.0-beta.34","web3-core-helpers":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-core-subscriptions":"1.0.0-beta.34","web3-eth-abi":"1.0.0-beta.34","web3-eth-accounts":"1.0.0-beta.34","web3-eth-contract":"1.0.0-beta.34","web3-eth-iban":"1.0.0-beta.34","web3-eth-personal":"1.0.0-beta.34","web3-net":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-eth-abi":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth-abi/-/web3-eth-abi-1.0.0-beta.34.tgz",integrity:"sha1-A0Uz46ovfln/MXk+rqaFwO1a9no=",requires:{"bn.js":"4.11.6",underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-eth-accounts":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth-accounts/-/web3-eth-accounts-1.0.0-beta.34.tgz",integrity:"sha1-4JFC7uzHl6w0WbdemyOUbTaV8zM=",requires:{"any-promise":"1.3.0","crypto-browserify":"3.12.0","eth-lib":"0.2.7","scrypt.js":"0.2.0",underscore:"1.8.3",uuid:"2.0.1","web3-core":"1.0.0-beta.34","web3-core-helpers":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"},dependencies:{"eth-lib":{version:"0.2.7",resolved:"https://registry.npmjs.org/eth-lib/-/eth-lib-0.2.7.tgz",integrity:"sha1-L5Pxex4jrsN1nNSj/iDBKGo/wco=",requires:{"bn.js":"4.11.6",elliptic:"6.4.0","xhr-request-promise":"0.1.2"}},uuid:{version:"2.0.1",resolved:"https://registry.npmjs.org/uuid/-/uuid-2.0.1.tgz",integrity:"sha1-wqMN7bPlNdcsz4LjQ5QaULqFM6w="}}},"web3-eth-contract":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth-contract/-/web3-eth-contract-1.0.0-beta.34.tgz",integrity:"sha1-nbs4+udkOoCEJ6IBgEcOx0FckeY=",requires:{underscore:"1.8.3","web3-core":"1.0.0-beta.34","web3-core-helpers":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-core-promievent":"1.0.0-beta.34","web3-core-subscriptions":"1.0.0-beta.34","web3-eth-abi":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-eth-iban":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth-iban/-/web3-eth-iban-1.0.0-beta.34.tgz",integrity:"sha1-mvRYYFhnzPdOqXmq8yazi6alugw=",requires:{"bn.js":"4.11.6","web3-utils":"1.0.0-beta.34"}},"web3-eth-personal":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-eth-personal/-/web3-eth-personal-1.0.0-beta.34.tgz",integrity:"sha1-mvuhZzQuveVCC81YlcP2w0OI8gU=",requires:{"web3-core":"1.0.0-beta.34","web3-core-helpers":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-net":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-net":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-net/-/web3-net-1.0.0-beta.34.tgz",integrity:"sha1-QnzqL0MYgUScjjjVIykPFz+f9j0=",requires:{"web3-core":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-utils":"1.0.0-beta.34"}},"web3-provider-engine":{version:"14.0.6",resolved:"https://registry.npmjs.org/web3-provider-engine/-/web3-provider-engine-14.0.6.tgz",integrity:"sha512-tr5cGSyxfSC/JqiUpBlJtfZpwQf1yAA8L/zy1C6fDFm0ntR974pobJ4v4676atpZne4Ze5VFy3kPPahHe9gQiQ==",requires:{async:"2.6.1",backoff:"2.5.0",clone:"2.1.1","cross-fetch":"2.2.1","eth-block-tracker":"3.0.1","eth-json-rpc-infura":"3.1.2","eth-sig-util":"1.4.2","ethereumjs-block":"1.2.2","ethereumjs-tx":"1.3.4","ethereumjs-util":"5.2.0","ethereumjs-vm":"2.3.5","json-rpc-error":"2.0.0","json-stable-stringify":"1.0.1","promise-to-callback":"1.0.0","readable-stream":"2.3.6",request:"2.87.0",semaphore:"1.1.0",tape:"4.9.0",ws:"5.2.0",xhr:"2.5.0",xtend:"4.0.1"},dependencies:{"eth-sig-util":{version:"1.4.2",resolved:"https://registry.npmjs.org/eth-sig-util/-/eth-sig-util-1.4.2.tgz",integrity:"sha1-jZWCAsftuq6Dlwf7pvCf8ydgYhA=",requires:{"ethereumjs-abi":"git+https://github.com/ethereumjs/ethereumjs-abi.git#00ba8463a7f7a67fcad737ff9c2ebd95643427f7","ethereumjs-util":"5.2.0"}},"ethereumjs-abi":{version:"git+https://github.com/ethereumjs/ethereumjs-abi.git#00ba8463a7f7a67fcad737ff9c2ebd95643427f7",requires:{"bn.js":"4.11.6","ethereumjs-util":"5.2.0"}},ws:{version:"5.2.0",resolved:"https://registry.npmjs.org/ws/-/ws-5.2.0.tgz",integrity:"sha512-c18dMeW+PEQdDFzkhDsnBAlS4Z8KGStBQQUcQ5mf7Nf689jyGk0594L+i9RaQuf4gog6SvWLJorz2NfSaqxZ7w==",requires:{"async-limiter":"1.0.0"}}}},"web3-providers-http":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-providers-http/-/web3-providers-http-1.0.0-beta.34.tgz",integrity:"sha1-5WG1K7tDdmKCAH1AKFv+NVDCfno=",requires:{"web3-core-helpers":"1.0.0-beta.34",xhr2:"0.1.4"}},"web3-providers-ipc":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-providers-ipc/-/web3-providers-ipc-1.0.0-beta.34.tgz",integrity:"sha1-obd/GjBtc2SanAOQUuQMtxMo0Ao=",requires:{oboe:"2.1.3",underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34"}},"web3-providers-ws":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-providers-ws/-/web3-providers-ws-1.0.0-beta.34.tgz",integrity:"sha1-fecPG4Py3jZHZ3IVa+z+9uNRbrM=",requires:{underscore:"1.8.3","web3-core-helpers":"1.0.0-beta.34",websocket:"git://github.com/frozeman/WebSocket-Node.git#6c72925e3f8aaaea8dc8450f97627e85263999f2"},dependencies:{websocket:{version:"git://github.com/frozeman/WebSocket-Node.git#6c72925e3f8aaaea8dc8450f97627e85263999f2",requires:{debug:"2.6.9",nan:"2.10.0","typedarray-to-buffer":"3.1.5",yaeti:"0.0.6"}}}},"web3-shh":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-shh/-/web3-shh-1.0.0-beta.34.tgz",integrity:"sha1-l1Bh1x6uxCzO5Xb3vY9w8DhEr+A=",requires:{"web3-core":"1.0.0-beta.34","web3-core-method":"1.0.0-beta.34","web3-core-subscriptions":"1.0.0-beta.34","web3-net":"1.0.0-beta.34"}},"web3-utils":{version:"1.0.0-beta.34",resolved:"https://registry.npmjs.org/web3-utils/-/web3-utils-1.0.0-beta.34.tgz",integrity:"sha1-lBH8OarvOcpOBhafdiKX2f8CCXA=",requires:{"bn.js":"4.11.6","eth-lib":"0.1.27","ethjs-unit":"0.1.6","number-to-bn":"1.7.0",randomhex:"0.1.5",underscore:"1.8.3",utf8:"2.1.1"},dependencies:{utf8:{version:"2.1.1",resolved:"https://registry.npmjs.org/utf8/-/utf8-2.1.1.tgz",integrity:"sha1-LgHbAvfY0JRPdxBPFgnrDDBM92g="}}},websocket:{version:"1.0.26",resolved:"https://registry.npmjs.org/websocket/-/websocket-1.0.26.tgz",integrity:"sha512-fjcrYDPIQxpTnqFQ9JjxUQcdvR89MFAOjPBlF+vjOt49w/XW4fJknUoMz/mDIn2eK1AdslVojcaOxOqyZZV8rw==",requires:{debug:"2.6.9",nan:"2.10.0","typedarray-to-buffer":"3.1.5",yaeti:"0.0.6"}},"whatwg-fetch":{version:"2.0.4",resolved:"https://registry.npmjs.org/whatwg-fetch/-/whatwg-fetch-2.0.4.tgz",integrity:"sha512-dcQ1GWpOD/eEQ97k66aiEVpNnapVj90/+R+SXTPYGHpYBBypfKJEQjLrvMZ7YXbKm21gXd4NcuxUTjiv1YtLng=="},"which-module":{version:"1.0.0",resolved:"https://registry.npmjs.org/which-module/-/which-module-1.0.0.tgz",integrity:"sha1-u6Y8qGGUiZT/MHc2CJ47lgJsKk8="},"window-size":{version:"0.2.0",resolved:"https://registry.npmjs.org/window-size/-/window-size-0.2.0.tgz",integrity:"sha1-tDFbtCFKPXBY6+7okuE/ok2YsHU="},"wrap-ansi":{version:"2.1.0",resolved:"https://registry.npmjs.org/wrap-ansi/-/wrap-ansi-2.1.0.tgz",integrity:"sha1-2Pw9KE3QV5T+hJc8rs3Rz4JP3YU=",requires:{"string-width":"1.0.2","strip-ansi":"3.0.1"}},wrappy:{version:"1.0.2",resolved:"https://registry.npmjs.org/wrappy/-/wrappy-1.0.2.tgz",integrity:"sha1-tSQ9jz7BqjXxNkYFvA0QNuMKtp8="},ws:{version:"3.3.3",resolved:"https://registry.npmjs.org/ws/-/ws-3.3.3.tgz",integrity:"sha512-nnWLa/NwZSt4KQJu51MYlCcSQ5g7INpOrOMt4XV8j4dqTXdmlUmSHQ8/oLC069ckre0fRsgfvsKwbTdtKLCDkA==",requires:{"async-limiter":"1.0.0","safe-buffer":"5.1.2",ultron:"1.1.1"}},xhr:{version:"2.5.0",resolved:"https://registry.npmjs.org/xhr/-/xhr-2.5.0.tgz",integrity:"sha512-4nlO/14t3BNUZRXIXfXe+3N6w3s1KoxcJUUURctd64BLRe67E4gRwp4PjywtDY72fXpZ1y6Ch0VZQRY/gMPzzQ==",requires:{global:"4.3.2","is-function":"1.0.1","parse-headers":"2.0.1",xtend:"4.0.1"}},"xhr-request":{version:"1.1.0",resolved:"https://registry.npmjs.org/xhr-request/-/xhr-request-1.1.0.tgz",integrity:"sha512-Y7qzEaR3FDtL3fP30k9wO/e+FBnBByZeybKOhASsGP30NIkRAAkKD/sCnLvgEfAIEC1rcmK7YG8f4oEnIrrWzA==",requires:{"buffer-to-arraybuffer":"0.0.5","object-assign":"4.1.1","query-string":"5.1.1","simple-get":"2.8.1","timed-out":"4.0.1","url-set-query":"1.0.0",xhr:"2.5.0"}},"xhr-request-promise":{version:"0.1.2",resolved:"https://registry.npmjs.org/xhr-request-promise/-/xhr-request-promise-0.1.2.tgz",integrity:"sha1-NDxE0e53JrhkgGloLQ+EDIO0Jh0=",requires:{"xhr-request":"1.1.0"}},xhr2:{version:"0.1.4",resolved:"https://registry.npmjs.org/xhr2/-/xhr2-0.1.4.tgz",integrity:"sha1-f4dliEdxbbUCYyOBL4GMras4el8="},xtend:{version:"4.0.1",resolved:"https://registry.npmjs.org/xtend/-/xtend-4.0.1.tgz",integrity:"sha1-pcbVMr5lbiPbgg77lDofBJmNY68="},y18n:{version:"3.2.1",resolved:"https://registry.npmjs.org/y18n/-/y18n-3.2.1.tgz",integrity:"sha1-bRX7qITAhnnA136I53WegR4H+kE="},yaeti:{version:"0.0.6",resolved:"https://registry.npmjs.org/yaeti/-/yaeti-0.0.6.tgz",integrity:"sha1-8m9ITXJoTPQr7ft2lwqhYI+/lXc="},yargs:{version:"7.1.0",resolved:"https://registry.npmjs.org/yargs/-/yargs-7.1.0.tgz",integrity:"sha1-a6MY6xaWFyf10oT46gA+jWFU0Mg=",requires:{camelcase:"3.0.0",cliui:"3.2.0",decamelize:"1.2.0","get-caller-file":"1.0.2","os-locale":"1.4.0","read-pkg-up":"1.0.1","require-directory":"2.1.1","require-main-filename":"1.0.1","set-blocking":"2.0.0","string-width":"1.0.2","which-module":"1.0.0",y18n:"3.2.1","yargs-parser":"5.0.0"},dependencies:{"yargs-parser":{version:"5.0.0",resolved:"https://registry.npmjs.org/yargs-parser/-/yargs-parser-5.0.0.tgz",integrity:"sha1-J17PDX/+Bcd+ZOfIbkzZS/DhIoo=",requires:{camelcase:"3.0.0"}}}},"yargs-parser":{version:"2.4.1",resolved:"https://registry.npmjs.org/yargs-parser/-/yargs-parser-2.4.1.tgz",integrity:"sha1-hVaN488VD/SfpRgl8DqMiA3cxcQ=",requires:{camelcase:"3.0.0","lodash.assign":"4.2.0"}},yauzl:{version:"2.9.1",resolved:"https://registry.npmjs.org/yauzl/-/yauzl-2.9.1.tgz",integrity:"sha1-qBmB6nCleUYTOIPwKcWCGok1mn8=",requires:{"buffer-crc32":"0.2.13","fd-slicer":"1.0.1"}}}},_spec:"ganache-core@2.2.1",_where:"/home/benjamincburns/projects/consensys/ganache-cli",bugs:{url:"https://github.com/trufflesuite/ganache-core/issues"},bundleDependencies:!1,dependencies:{"abstract-leveldown":"^3.0.0",async:"^2.5.0",bip39:"~2.4.0","bn.js":"4.11.6",cachedown:"^1.0.0",chai:"^3.5.0",clone:"^2.1.1","eth-sig-util":"^2.0.2","ethereumjs-abi":"^0.6.5","ethereumjs-account":"~2.0.4","ethereumjs-block":"~1.2.2","ethereumjs-tx":"1.3.4","ethereumjs-util":"^5.2.0","ethereumjs-vm":"2.3.5","ethereumjs-wallet":"0.6.0","fake-merkle-patricia-tree":"~1.0.1",heap:"~0.2.6","js-scrypt":"^0.2.0","level-sublevel":"^6.6.1",levelup:"^1.1.0","localstorage-down":"^0.6.7",lodash:"^4.17.5","merkle-patricia-tree":"^2.2.0",pify:"^3.0.0","prepend-file":"^1.3.1",request:"^2.87.0",seedrandom:"~2.4.2","shebang-loader":"0.0.1",solc:"0.4.24",temp:"^0.8.3",tmp:"0.0.31",web3:"^1.0.0-beta.34","web3-provider-engine":"^14.0.6",websocket:"^1.0.24",yargs:"^7.0.2"},deprecated:!1,description:"[![npm](https://img.shields.io/npm/v/ganache-core.svg)]() [![npm](https://img.shields.io/npm/dm/ganache-core.svg)]() [![Build Status](https://travis-ci.org/trufflesuite/ganache-core.svg?branch=master)](https://travis-ci.org/trufflesuite/ganache-core) # Ganache Core",devDependencies:{"assert-match":"^1.1.1",memdown:"^1.3.1",mocha:"~5.1.1"},directories:{lib:"./lib"},engines:{node:">=8.9.0"},homepage:"https://github.com/trufflesuite/ganache-core#readme",license:"MIT",main:"./index.js",name:"ganache-core",repository:{type:"git",url:"git+https://github.com/trufflesuite/ganache-core.git"},scripts:{test:"mocha --check-leaks --globals _scratch,sanitizedData"},version:"2.2.1"}},function(e,a,t){function r(e){Error.captureStackTrace(this,this.constructor),this.name=this.constructor.name,this.message=e}(0,t(1).inherits)(r,Error),e.exports=r},function(e,a){e.exports={randomBytes:function(e,a){for(var t=[],r=0;r<e;r++)t.push(255*a());return Buffer.from(t)},randomAlphaNumericString:function(e,a){const t="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";let r="";for(var c=0;c<e;c++)r+=t.charAt(Math.floor((a||Math.random)()*t.length));return r}}},function(e,a,t){const r=t(3),c=t(330),n={type:"object",properties:{types:{type:"object",additionalProperties:{type:"array",items:{type:"object",properties:{name:{type:"string"},type:{type:"string"}},required:["name","type"]}}},primaryType:{type:"string"},domain:{type:"object"},message:{type:"object"}},required:["types","primaryType","domain","message"]},i={encodeData(e,a,t){const n=["bytes32"],i=[this.hashType(e,t)];for(const c of t[e]){let e=a[c.name];if(void 0!==e)if("string"===c.type||"bytes"===c.type)n.push("bytes32"),e=r.sha3(e),i.push(e);else if(void 0!==t[c.type])n.push("bytes32"),e=r.sha3(this.encodeData(c.type,e,t)),i.push(e);else{if(c.type.lastIndexOf("]")===c.type.length-1)throw new Error("Arrays currently unimplemented in encodeData");n.push(c.type),i.push(e)}}return c.rawEncode(n,i)},encodeType(e,a){let t="",r=this.findTypeDependencies(e,a).filter(a=>a!==e);r=[e].concat(r.sort());for(const e of r){if(!a[e])throw new Error(`No type definition specified: ${e}`);t+=`${e}(${a[e].map(({name:e,type:a})=>`${a} ${e}`).join(",")})`}return t},findTypeDependencies(e,a,t=[]){if(t.includes(e)||void 0===a[e])return t;t.push(e);for(const r of a[e])for(const e of this.findTypeDependencies(r.type,a,t))!t.includes(e)&&t.push(e);return t},hashStruct(e,a,t){return r.sha3(this.encodeData(e,a,t))},hashType(e,a){return r.sha3(this.encodeType(e,a))},sanitizeData(e){const a={};for(const t in n.properties)e[t]&&(a[t]=e[t]);return a},sign(e){sanitizedData=this.sanitizeData(e);const a=[Buffer.from("1901","hex")];return a.push(this.hashStruct("EIP712Domain",sanitizedData.domain,sanitizedData.types)),a.push(this.hashStruct(sanitizedData.primaryType,sanitizedData.message,sanitizedData.types)),r.sha3(Buffer.concat(a))}};function f(e){const a=new Error("Expect argument to be non-empty array");if("object"!=typeof e||!e.length)throw a;const t=e.map(function(e){return"bytes"===e.type?r.toBuffer(e.value):e.value}),n=e.map(function(e){return e.type}),i=e.map(function(e){if(!e.name)throw a;return e.type+" "+e.name});return c.soliditySHA3(["bytes32","bytes32"],[c.soliditySHA3(new Array(e.length).fill("string"),i),c.soliditySHA3(n,t)])}function o(e,a){const t=r.toBuffer(a),c=r.fromRpcSig(t);return r.ecrecover(e,c.v,c.r,c.s)}function d(e){const a=r.toBuffer(e.data);return o(r.hashPersonalMessage(a),e.sig)}function s(e,a){for(var t=""+e;t.length<a;)t="0"+t;return t}e.exports={TYPED_MESSAGE_SCHEMA:n,TypedDataUtils:i,concatSig:function(e,a,t){const c=r.fromSigned(a),n=r.fromSigned(t),i=r.bufferToInt(e),f=s(r.toUnsigned(c).toString("hex"),64),o=s(r.toUnsigned(n).toString("hex"),64),d=r.stripHexPrefix(r.intToHex(i));return r.addHexPrefix(f.concat(o,d)).toString("hex")},normalize:function(e){if(e){if("number"==typeof e){const a=r.toBuffer(e);e=r.bufferToHex(a)}if("string"!=typeof e){var a="eth-sig-util.normalize() requires hex string or integer input.";throw new Error(a+=" received "+typeof e+": "+e)}return r.addHexPrefix(e.toLowerCase())}},personalSign:function(e,a){var t=r.toBuffer(a.data),c=r.hashPersonalMessage(t),n=r.ecsign(c,e);return r.bufferToHex(this.concatSig(n.v,n.r,n.s))},recoverPersonalSignature:function(e){const a=d(e),t=r.publicToAddress(a);return r.bufferToHex(t)},extractPublicKey:function(e){return"0x"+d(e).toString("hex")},typedSignatureHash:function(e){const a=f(e);return r.bufferToHex(a)},signTypedDataLegacy:function(e,a){const t=f(a.data),c=r.ecsign(t,e);return r.bufferToHex(this.concatSig(c.v,c.r,c.s))},recoverTypedSignatureLegacy:function(e){const a=o(f(e.data),e.sig),t=r.publicToAddress(a);return r.bufferToHex(t)},signTypedData:function(e,a){const t=i.sign(a.data),c=r.ecsign(t,e);return r.bufferToHex(this.concatSig(c.v,c.r,c.s))},recoverTypedSignature:function(e){const a=o(i.sign(e.data),e.sig),t=r.publicToAddress(a);return r.bufferToHex(t)}}},function(e,a,t){var r=t(44),c=(t(45),t(3)),n=t(1).inherits,i=t(116),f=t(19);t(18);function o(e,a,t){r.call(this,e,a),this.address=t.address,this.fork=t.fork,this.fork_block_number=t.fork_block_number,this.blockchain=t.blockchain,this.web3=new i,this.web3.setProvider(this.fork),this.checkpoints=[]}n(o,r),o.prototype.keyExists=function(e,a){e=c.toBuffer(e),this.findPath(e,function(e,t,r,c){var n=!1;t&&0===r.length&&(n=!0),a(e,n)})},o.prototype.get=function(e,a,t){var n=this;"function"==typeof a&&(t=a,a=n.fork_block_number),a=f.rpcQuantityHexString(a),e=c.toBuffer(e),this.keyExists(e,function(i,o){if(i)return t(i);o?r.prototype.get.call(n,e,function(e,a){t(e,a)}):null==n.address?n.blockchain.fetchAccountFromFallback(e,a,function(e,a){if(e)return t(e);t(null,a.serialize())}):n.web3.eth.getStorageAt(f.hex(n.address),f.hex(e),a,function(e,a){if(e)return t(e);a=c.toBuffer(a),a=c.rlp.encode(a),t(null,a)})})},o.prototype.customCheckpoint=function(){this.checkpoints.push(this.root)},o.prototype.customRevert=function(){this.root=this.checkpoints.pop()},e.exports=o},function(e,a,t){var r=t(322),c=(t(174),t(45)),n=t(87),i=t(168),f=t(167),o=t(3),d=t(413),s=t(116),b=t(19),u=t(18),l=t(93),p=t(9);function h(e){if(this.options=e||{},null==e.fork)throw new Error("ForkedBlockchain must be passed a fork parameter.");if(this.fork=e.fork,this.fork_block_number=e.fork_block_number,this.fork_version=null,"string"==typeof this.fork){if(this.fork.indexOf("@")>=0){var a=this.fork.split("@");this.fork=a[0],this.fork_block_number=parseInt(a[1])}this.fork=new s.providers.HttpProvider(this.fork)}this.time=e.time,this.storageTrieCache={},r.call(this,e),this.web3=new s(this.fork)}(0,t(1).inherits)(h,r),h.prototype.initialize=function(e,a){var t=this;this.web3.eth.net.getId(function(c,n){if(c)return a(c);t.fork_version=n,r.prototype.initialize.call(t,e,function(e){if(e)return a(e);t.vm.stateManager._lookupStorageTrie=t.lookupStorageTrie.bind(t),t.vm.stateManager.cache._lookupAccount=t.getAccount.bind(t),t.vm.stateManager.getContractCode=t.getCode.bind(t),t.vm.stateManager.putContractCode=t.putCode.bind(t),a()})})},h.prototype.createStateTrie=function(e,a){return new d(e,a,{fork:this.fork,fork_block_number:this.fork_block_number,blockchain:this})},h.prototype.createGenesisBlock=function(e){var a=this,t=this.fork_block_number||"latest";a.web3.eth.getBlock(t,function(r,c){if(r)return e(r);!a.time&&a.fork_block_number&&(a.time=a.options.time=new Date(1e3*b.number(c.timestamp)),a.setTime(a.time)),t=b.hex(c.number),a.fork_block_number=a.options.fork_block_number=t,a.stateTrie.fork_block_number=t,a.createBlock(function(a,t){if(a)return e(a);t.header.number=o.toBuffer(b.number(c.number)+1),t.header.parentHash=o.toBuffer(c.hash),e(null,t)})})},h.prototype.createForkedStorageTrie=function(e){e=b.hex(e);var a=new d(this.data.trie_db,null,{address:e,stateTrie:this.stateTrie,blockchain:this,fork:this.fork,fork_block_number:this.fork_block_number});return this.storageTrieCache[e]=a,a},h.prototype.lookupStorageTrie=function(e,a){if(e=b.hex(e),null!=this.storageTrieCache[e])return a(null,this.storageTrieCache[e]);a(null,this.createForkedStorageTrie(e))},h.prototype.isFallbackBlock=function(e,a){var t=this;t.getEffectiveBlockNumber(e,function(e,r){if(e)return a(e);a(null,r<=b.number(t.fork_block_number))})},h.prototype.isBlockHash=function(e){return"string"==typeof e&&0==e.indexOf("0x")&&e.length>42},h.prototype.isFallbackBlockHash=function(e,a){if(!this.isBlockHash(e))return a(null,!1);this.data.blockHashes.get(e,function(e,t){if(e)return e.notFound?a(null,!0):a(e);a(null,!1)})},h.prototype.getFallbackBlock=function(e,a){"string"==typeof e&&e.length<66&&(e=this.web3.utils.toBN(e)),this.web3.eth.getBlock(e,!0,function(e,t){if(e)return a(e);if(null==t)return a();var r=new n;r.header.parentHash=o.toBuffer(t.parentHash),r.header.uncleHash=o.toBuffer(t.sha3Uncles),r.header.coinbase=o.toBuffer(t.miner),r.header.stateRoot=o.toBuffer(t.stateRoot),r.header.transactionTrie=o.toBuffer(t.transactionsRoot),r.header.receiptTrie=o.toBuffer(t.receiptsRoot),r.header.bloom=o.toBuffer(t.logsBloom),r.header.difficulty=o.toBuffer("0x"+t.totalDifficulty.toString(16)),r.header.number=o.toBuffer(t.number),r.header.gasLimit=o.toBuffer(t.gasLimit),r.header.gasUsed=o.toBuffer(t.gasUsed),r.header.timestamp=o.toBuffer(t.timestamp),r.header.extraData=o.toBuffer(t.extraData),(t.transactions||[]).forEach(function(e,a){r.transactions.push(l.fromJSON(e))}),r.hash=function(){return o.toBuffer(t.hash)},a(null,r)})},h.prototype.getBlock=function(e,a){var t=this;this.isFallbackBlockHash(e,function(c,n){return c?a(c):n?t.getFallbackBlock(e,a):void t.isFallbackBlock(e,function(c,n){if(c)return a(c);if(n)return t.getFallbackBlock(e,a);!function(e,a){t.isBlockHash(e)?a(null,e):t.getRelativeBlockNumber(e,a)}(e,function(e,c){if(e)return a(e);r.prototype.getBlock.call(t,c,a)})})})},h.prototype.getStorage=function(e,a,t,r){this.lookupStorageTrie(e,function(e,t){if(e)return r(e);t.get(a,r)})},h.prototype.getCode=function(e,a,t){var c=this;"function"==typeof a&&(t=a,a="latest"),a||(a="latest"),this.getEffectiveBlockNumber(a,function(n,i){a=i,c.stateTrie.keyExists(e,function(n,i){i&&a>b.number(c.fork_block_number)?r.prototype.getCode.call(c,e,a,t):(a>b.number(c.fork_block_number)&&(a="latest"),c.fetchCodeFromFallback(e,a,function(e,a){a&&(a=o.toBuffer(a)),t(e,a)}))})})},h.prototype.putCode=function(e,a,t){var r=this;r.vm.stateManager.cache.flush(()=>{e=o.toBuffer(e),this.stateTrie.get(e,function(n,i){if(n)return t(n);var f=new c(i);f.setCode(r.stateTrie,a,function(a,c){if(a)return t(a);r.stateTrie.put(e,f.serialize(),function(a){if(a)return t(a);r.vm.stateManager.putAccount(e,f,t)})})})})},h.prototype.getAccount=function(e,a,t){var c=this;"function"==typeof a&&(t=a,a="latest"),this.getEffectiveBlockNumber(a,function(n,i){if(n)return t(n);a=i,c.stateTrie.keyExists(e,function(n,i){if(n)return t(n);i&&a>b.number(c.fork_block_number)?r.prototype.getAccount.call(c,e,a,function(e,a){if(e)return t(e);t(null,a)}):c.fetchAccountFromFallback(e,a,t)})})},h.prototype.getTransaction=function(e,a){var t=this;r.prototype.getTransaction.call(this,e,function(r,c){return r?a(r):null!=c?a(null,c):void t.web3.eth.getTransaction(e,function(e,t){if(e)return a(e);t&&(t=l.fromJSON(t)),a(null,t)})})},h.prototype.getTransactionReceipt=function(e,a){var t=this;r.prototype.getTransactionReceipt.call(this,e,function(r,c){return r?a(r):c?a(null,c):void t.web3.eth.getTransactionReceipt(e,function(r,c){return r?a(r):c?void u.parallel({tx:t.getTransaction.bind(t,e),block:t.getBlock.bind(t,c.blockNumber)},function(e,t){if(e)return a(e);var r=c.logs.map(function(e){return new i(e)}),n=new f(t.tx,t.block,r,c.cumulativeGasUsed,c.contractAddress,c.status,b.hex(c.logsBloom));a(null,n)}):a()})})},h.prototype.fetchAccountFromFallback=function(e,a,t){var r=this;e=b.hex(e),u.parallel({code:this.fetchCodeFromFallback.bind(this,e,a),balance:this.fetchBalanceFromFallback.bind(this,e,a),nonce:this.fetchNonceFromFallback.bind(this,e,a)},function(e,a){if(e)return t(e);var n=a.code,i=a.balance,f=a.nonce,d=new c({nonce:f,balance:i});d.exists="0x0"!=n||"0x0"!=i||"0x0"!=f,d.setCode(r.stateTrie,o.toBuffer(n),function(e){if(e)return t(e);t(null,d)})})},h.prototype.fetchCodeFromFallback=function(e,a,t){var r=this;e=b.hex(e),"function"==typeof a&&(t=a,a=this.fork_block_number),this.getSafeFallbackBlockNumber(a,function(a,c){if(a)return t(a);r.web3.eth.getCode(e,c,function(e,a){if(e)return t(e);a="0x"+o.toBuffer(a).toString("hex"),t(null,a)})})},h.prototype.fetchBalanceFromFallback=function(e,a,t){var r=this;e=b.hex(e),"function"==typeof a&&(t=a,a=this.fork_block_number),this.getSafeFallbackBlockNumber(a,function(a,c){if(a)return t(a);r.web3.eth.getBalance(e,c,function(e,a){if(e)return t(e);a="0x"+new p(a).toString(16),t(null,a)})})},h.prototype.fetchNonceFromFallback=function(e,a,t){var r=this;e=b.hex(e),"function"==typeof a&&(t=a,a=this.fork_block_number),this.getSafeFallbackBlockNumber(a,function(a,c){if(a)return t(a);r.web3.eth.getTransactionCount(e,c,function(e,a){if(e)return t(e);a="0x"+r.web3.utils.toBN(a).toString(16),t(null,a)})})},h.prototype.getHeight=function(e){this.latestBlock(function(a,t){if(a)return e(a);e(null,b.number(t.header.number))})},h.prototype.getRelativeBlockNumber=function(e,a){var t=this;this.getEffectiveBlockNumber(e,function(e,r){if(e)return a(e);a(null,r-b.number(t.fork_block_number)-1)})},h.prototype.getSafeFallbackBlockNumber=function(e,a){var t=b.number(this.fork_block_number);if(null==e)return a(null,t);this.getEffectiveBlockNumber(e,function(e,r){r>t&&(r=t),a(null,r)})},h.prototype.getBlockLogs=function(e,a){var t=this;this.getEffectiveBlockNumber(e,function(c,n){if(c)return a(c);t.getRelativeBlockNumber(n,function(c,n){if(c)return a(c);n<0?t.getBlock(e,function(r,c){if(r)return a(r);t.web3.currentProvider.send({jsonrpc:"2.0",method:"eth_getLogs",params:[{fromBlock:b.hex(e),toBlock:b.hex(e)}],id:(new Date).getTime()},function(e,t){if(e)return a(e);var r=t.result.map(function(e){return e.block=c,new i(e)});a(null,r)})}):r.prototype.getBlockLogs.call(t,n,a)})})},h.prototype._checkpointTrie=function(){var e=this;r.prototype._checkpointTrie.call(this),Object.keys(this.storageTrieCache).forEach(function(a){e.storageTrieCache[a].customCheckpoint()})},h.prototype._revertTrie=function(){var e=this;r.prototype._revertTrie.call(this),Object.keys(this.storageTrieCache).forEach(function(a){var t=e.storageTrieCache[a];0==t.checkpoints.length?delete e.storageTrieCache[a]:t.customRevert()})},e.exports=h},function(e,a,t){"use strict";var r="win32"===process.platform,c=r?/[^:]\\$/:/.\/$/;e.exports=function(){var e;return e=r?process.env.TEMP||process.env.TMP||(process.env.SystemRoot||process.env.windir)+"\\temp":process.env.TMPDIR||process.env.TMP||process.env.TEMP||"/tmp",c.test(e)&&(e=e.slice(0,-1)),e}},function(e,a,t){
/*!
 * Tmp
 *
 * Copyright (c) 2011-2015 KARASZI Istvan <github@spam.raszi.hu>
 *
 * MIT Licensed
 */
var r=t(15),c=t(2),n=t(10),i=t(415),f=process.binding("constants"),o=i(),d="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",s=/XXXXXX/,b=3,u=(f.O_CREAT||f.fs.O_CREAT)|(f.O_EXCL||f.fs.O_EXCL)|(f.O_RDWR||f.fs.O_RDWR),l=f.EBADF||f.os.errno.EBADF,p=f.ENOENT||f.os.errno.ENOENT,h=448,m=384,g=[],v=!1,y=!1;function _(e){var a=[],t=null;try{t=n.randomBytes(e)}catch(a){t=n.pseudoRandomBytes(e)}for(var r=0;r<e;r++)a.push(d[t[r]%d.length]);return a.join("")}function w(e,a){if("function"==typeof e){var t=e;e=a||{},a=t}else void 0===e&&(e={});return[e,a]}function A(e){if(e.name)return c.join(e.dir||o,e.name);if(e.template)return e.template.replace(s,_(6));var a=[e.prefix||"tmp-",process.pid,_(12),e.postfix||""].join("");return c.join(e.dir||o,a)}function k(e,a){var t=w(e,a),c=t[0],n=t[1],i=c.tries||b;return isNaN(i)||i<0?n(new Error("Invalid tries")):c.template&&!c.template.match(s)?n(new Error("Invalid template provided")):void function e(){var a=A(c);r.stat(a,function(t){if(!t)return i-- >0?e():n(new Error("Could not get a unique tmp filename, max tries reached "+a));n(null,a)})}()}function x(e){var a=w(e)[0],t=a.tries||b;if(isNaN(t)||t<0)throw new Error("Invalid tries");if(a.template&&!a.template.match(s))throw new Error("Invalid template provided");do{var c=A(a);try{r.statSync(c)}catch(e){return c}}while(t-- >0);throw new Error("Could not get a unique tmp filename, max tries reached")}function E(e){var a=[e];do{for(var t=a.pop(),n=!1,i=r.readdirSync(t),f=0,o=i.length;f<o;f++){var d=c.join(t,i[f]);r.lstatSync(d).isDirectory()?(n||(n=!0,a.push(t)),a.push(d)):r.unlinkSync(d)}n||r.rmdirSync(t)}while(0!==a.length)}function S(e,a,t){var c=j(function(e){try{0<=e[0]&&r.closeSync(e[0])}catch(e){if(e.errno!=-l&&e.errno!=-p)throw e}r.unlinkSync(e[1])},[a,e]);return t.keep||g.unshift(c),c}function T(e,a){var t=j(a.unsafeCleanup?E:r.rmdirSync.bind(r),e);return a.keep||g.unshift(t),t}function j(e,a){var t=!1;return function r(c){if(!t){var n=g.indexOf(r);n>=0&&g.splice(n,1),t=!0,e(a)}c&&c(null)}}function C(){if(!y||v)for(;g.length;)try{g[0].call(null)}catch(e){}}var R=process.versions.node.split(".").map(function(e){return parseInt(e,10)});0===R[0]&&(R[1]<9||9===R[1]&&R[2]<5)&&process.addListener("uncaughtException",function(e){throw y=!0,C(),e}),process.addListener("exit",function(e){e&&(y=!0),C()}),e.exports.tmpdir=o,e.exports.dir=function(e,a){var t=w(e,a),c=t[0],n=t[1];k(c,function(e,a){if(e)return n(e);r.mkdir(a,c.mode||h,function(e){if(e)return n(e);n(null,a,T(a,c))})})},e.exports.dirSync=function(e){var a=w(e)[0],t=x(a);return r.mkdirSync(t,a.mode||h),{name:t,removeCallback:T(t,a)}},e.exports.file=function(e,a){var t=w(e,a),c=t[0],n=t[1];c.postfix=function(e){return void 0===e}(c.postfix)?".tmp":c.postfix,k(c,function(e,a){if(e)return n(e);r.open(a,u,c.mode||m,function(e,t){return e?n(e):c.discardDescriptor?r.close(t,function(e){if(e){try{r.unlinkSync(a)}catch(a){e=a}return n(e)}n(null,a,void 0,S(a,-1,c))}):c.detachDescriptor?n(null,a,t,S(a,-1,c)):void n(null,a,t,S(a,t,c))})})},e.exports.fileSync=function(e){var a=w(e)[0];a.postfix=a.postfix||".tmp";var t=x(a),c=r.openSync(t,u,a.mode||m);return{name:t,fd:c,removeCallback:S(t,c,a)}},e.exports.tmpName=k,e.exports.tmpNameSync=x,e.exports.setGracefulCleanup=function(){v=!0}},function(e,a,t){t(19);var r=t(167),c=t(18);function n(e){this.database=e}n.prototype.encode=function(e,a){a(null,e.toJSON())},n.prototype.decode=function(e,a){var t=this;this.database.transactions.get(e.transactionHash,function(n,i){if(n)return a(n);t.database.blockHashes.get(e.blockHash,function(n,f){if(n)return a(n);c.parallel({block:t.database.blocks.get.bind(t.database.blocks,f),logs:t.database.blockLogs.get.bind(t.database.blockLogs,f)},function(t,c){if(t)return a(t);a(null,new r(i,c.block,c.logs,e.gasUsed,e.contractAddress,e.status,e.logsBloom))})})})},e.exports=n},function(e,a,t){t(19);var r=t(168),c=t(18);function n(e){this.database=e}n.prototype.encode=function(e,a){a(null,e=e.map(function(e){return e.toJSON()}))},n.prototype.decode=function(e,a){var t=this;if(0==e.length)return a(null,[]);this.database.blockHashes.get(e[0].blockHash,function(n,i){if(n)return a(n);t.database.blocks.get(i,function(t,n){if(t)return a(t);c.map(e,function(e,a){a(null,new r({block:n,logIndex:e.logIndex,transactionIndex:e.transactionIndex,transactionHash:e.transactionHash,address:e.address,data:e.data,topics:e.topics,type:e.type}))},function(e,t){if(e)return a(e);a(null,t)})})})},e.exports=n},function(e,a,t){var r=t(3),c=t(19);e.exports={encode:function(e,a){a(null,c.hex(e))},decode:function(e,a){a(null,r.toBuffer(e))}}},function(e,a){var t=Object.prototype.hasOwnProperty;function r(e){if(!(this instanceof r))throw new TypeError("Constructor PseudoMap requires 'new'");if(this.clear(),e)if(e instanceof r||"function"==typeof Map&&e instanceof Map)e.forEach(function(e,a){this.set(a,e)},this);else{if(!Array.isArray(e))throw new TypeError("invalid argument");e.forEach(function(e){this.set(e[0],e[1])},this)}}function c(e,a){return e===a||e!=e&&a!=a}function n(e,a){for(var r=0,n="_"+a,i=n;t.call(e,i);i=n+r++)if(c(e[i].key,a))return e[i]}e.exports=r,r.prototype.forEach=function(e,a){a=a||this,Object.keys(this._data).forEach(function(t){"size"!==t&&e.call(a,this._data[t].value,this._data[t].key)},this)},r.prototype.has=function(e){return!!n(this._data,e)},r.prototype.get=function(e){var a=n(this._data,e);return a&&a.value},r.prototype.set=function(e,a){!function(e,a,r){for(var n=0,i="_"+a,f=i;t.call(e,f);f=i+n++)if(c(e[f].key,a))return void(e[f].value=r);e.size++,e[f]=new function(e,a,t){this.key=e,this.value=a,this._index=t}(a,r,f)}(this._data,e,a)},r.prototype.delete=function(e){var a=n(this._data,e);a&&(delete this._data[a._index],this._data.size--)},r.prototype.clear=function(){var e=Object.create(null);e.size=0,Object.defineProperty(this,"_data",{value:e,enumerable:!1,configurable:!0,writable:!1})},Object.defineProperty(r.prototype,"size",{get:function(){return this._data.size},set:function(e){},enumerable:!0,configurable:!0}),r.prototype.values=r.prototype.keys=r.prototype.entries=function(){throw new Error("iterators are not implemented in this version")}},function(e,a,t){"pseudomap"===process.env.npm_package_name&&"test"===process.env.npm_lifecycle_script&&(process.env.TEST_PSEUDOMAP="true"),"function"!=typeof Map||process.env.TEST_PSEUDOMAP?e.exports=t(420):e.exports=Map},function(e,a,t){e.exports=n;var r=t(421);function c(){return 1}function n(e){if(!(this instanceof n))return new n(e);"number"==typeof e&&(e={max:e}),e||(e={}),this._max=e.max,(!this._max||"number"!=typeof this._max||this._max<=0)&&(this._max=1/0),this._lengthCalculator=e.length||c,"function"!=typeof this._lengthCalculator&&(this._lengthCalculator=c),this._allowStale=e.stale||!1,this._maxAge=e.maxAge||null,this._dispose=e.dispose,this.reset()}function i(e){var a=e.size,t=new Array(a),r=a;return e.forEach(function(e,a){t[--r]=a}),t}function f(e,a,t,r){d(e,t)&&(u(e,t),e._allowStale||(t=void 0)),t&&a.call(r,t.value,t.key,e)}function o(e,a,t){var r=e._cache.get(a);return r&&(d(e,r)?(u(e,r),e._allowStale||(r=void 0)):t&&function(e,a){b(e,a),a.lu=e._mru,h(e),e._lruList.set(a.lu,a)}(e,r),r&&(r=r.value)),r}function d(e,a){if(!a||!a.maxAge&&!e._maxAge)return!1;var t=Date.now()-a.now;return a.maxAge?t>a.maxAge:e._maxAge&&t>e._maxAge}function s(e){if(e._length>e._max)for(var a=i(e._lruList),t=a.length-1;e._length>e._max;t--)e._lru=a[t-1],u(e,e._lruList.get(a[t]))}function b(e,a){e._lruList.delete(a.lu),a.lu===e._lru&&(e._lru=i(e._lruList).pop())}function u(e,a){a&&(e._dispose&&e._dispose(a.key,a.value),e._length-=a.length,e._cache.delete(a.key),b(e,a))}Object.defineProperty(n.prototype,"max",{set:function(e){(!e||"number"!=typeof e||e<=0)&&(e=1/0),this._max=e,this._length>this._max&&s(this)},get:function(){return this._max},enumerable:!0}),Object.defineProperty(n.prototype,"lengthCalculator",{set:function(e){"function"!=typeof e?(this._lengthCalculator=c,this._length=this._lruList.size,this._cache.forEach(function(e,a){e.length=1})):(this._lengthCalculator=e,this._length=0,this._cache.forEach(function(e,a){e.length=this._lengthCalculator(e.value,a),this._length+=e.length},this)),this._length>this._max&&s(this)},get:function(){return this._lengthCalculator},enumerable:!0}),Object.defineProperty(n.prototype,"length",{get:function(){return this._length},enumerable:!0}),Object.defineProperty(n.prototype,"itemCount",{get:function(){return this._lruList.size},enumerable:!0}),n.prototype.rforEach=function(e,a){a=a||this,this._lruList.forEach(function(t){f(this,e,t,a)},this)},n.prototype.forEach=function(e,a){a=a||this;for(var t=i(this._lruList),r=0;r<t.length;r++){f(this,e,this._lruList.get(t[r]),a)}},n.prototype.keys=function(){return i(this._lruList).map(function(e){return this._lruList.get(e).key},this)},n.prototype.values=function(){return i(this._lruList).map(function(e){return this._lruList.get(e).value},this)},n.prototype.reset=function(){this._dispose&&this._cache&&this._cache.forEach(function(e,a){this._dispose(a,e.value)},this),this._cache=new r,this._lruList=new r,this._mru=0,this._lru=0,this._length=0},n.prototype.dump=function(){this._lruList.size;return i(this._lruList).map(function(e){var a=this._lruList.get(e);if(!d(this,a))return{k:a.key,v:a.value,e:a.now+(a.maxAge||0)}},this).filter(function(e){return e})},n.prototype.dumpLru=function(){return this._lruList},n.prototype.set=function(e,a,t){var r=(t=t||this._maxAge)?Date.now():0,c=this._lengthCalculator(a,e);if(this._cache.has(e)){if(c>this._max)return u(this,this._cache.get(e)),!1;var n=this._cache.get(e);return this._dispose&&this._dispose(e,n.value),n.now=r,n.maxAge=t,n.value=a,this._length+=c-n.length,n.length=c,this.get(e),this._length>this._max&&s(this),!0}var i=new function(e,a,t,r,c,n){this.key=e,this.value=a,this.lu=t,this.length=r,this.now=c,n&&(this.maxAge=n)}(e,a,this._mru,c,r,t);return h(this),i.length>this._max?(this._dispose&&this._dispose(e,a),!1):(this._length+=i.length,this._cache.set(e,i),this._lruList.set(i.lu,i),this._length>this._max&&s(this),!0)},n.prototype.has=function(e){return!!this._cache.has(e)&&!d(this,this._cache.get(e))},n.prototype.get=function(e){return o(this,e,!0)},n.prototype.peek=function(e){return o(this,e,!1)},n.prototype.pop=function(){var e=this._lruList.get(this._lru);return u(this,e),e||null},n.prototype.del=function(e){u(this,this._cache.get(e))},n.prototype.load=function(e){this.reset();for(var a=Date.now(),t=e.length-1;t>=0;t--){var r=e[t],c=r.e||0;if(0===c)this.set(r.k,r.v);else{var n=c-a;n>0&&this.set(r.k,r.v,n)}}};var l=Number.MAX_SAFE_INTEGER||9007199254740991;function p(e){return e===l?0:e+1}function h(e){do{e._mru=p(e._mru)}while(e._lruList.has(e._mru))}},function(e,a,t){var r=t(194);e.exports=function(e){return!(!e||"object"!=typeof e)&&Object.keys(r.prototype).filter(function(e){return"_"!=e[0]&&"approximateSize"!=e}).every(function(a){return"function"==typeof e[a]})}},function(e,a,t){a.AbstractLevelDOWN=t(194),a.AbstractIterator=t(193),a.AbstractChainedBatch=t(192),a.isLevelDOWN=t(423)},function(e,a,t){var r,c=t(424).AbstractLevelDOWN,n=t(1).inherits,i=(t(5).EventEmitter,t(422));function f(e,a){var t=this;if(!(this instanceof f))return new f(e,a);"object"==typeof e&&(a=e,e=void 0),a=a||r,this._down=new a(e),this._cache=new i,["_open","_close","_iterator"].forEach(function(e){e in t._down&&(t[e]=t._down[e].bind(t._down))}),void 0===e?c.call(this):c.call(this,e)}n(f,c),f.prototype._put=function(e,a,t,r){return void 0!==a&&null!==a||(a=""),this._cachePut(e,a),this._down._put.apply(this._down,arguments)},f.prototype._get=function(e,a,t){var r=this;if(this._cacheHas(e)){var c=this._cacheGet(e);return!1===a.asBuffer||this._isBuffer(c)||(c=new Buffer(String(c))),process.nextTick(function(){t(null,c)})}return this._down._get(e,a,function(a,c){if(a)return t(a);r._cachePut(e,c),t(a,c)})},f.prototype._del=function(e,a,t){return this._cacheDel(e),this._down._del.apply(this._down,arguments)},f.prototype._batch=function(e,a,t){var r=this;return e.forEach(function(e){"del"===e.type?r._cacheDel(e.key):"put"===e.type&&r._cachePut(e.key,e.value)}),this._down._batch.apply(this._down,arguments)},f.prototype._isBuffer=function(e){return Buffer.isBuffer(e)},f.prototype.clearCache=function(){return this._cache.reset(),this},f.prototype._cachePut=function(e,a){this._cache.set(e,a)},f.prototype._cacheGet=function(e){return this._cache.get(e)},f.prototype._cacheHas=function(e){return this._cache.has(e)},f.prototype._cacheDel=function(e,a){this._cache.del(e)},f.prototype.maxSize=function(e){return this._cache.max=e,this},f.setLeveldown=function(e){r=e},e.exports=f,e.exports.factory=function(){var e=Array.prototype.slice.call(arguments);return function(){return f.apply(null,e)}}},function(e,a,t){var r=t(197);e.exports=function(e){return!(!e||"object"!=typeof e)&&Object.keys(r.prototype).filter(function(e){return"_"!=e[0]&&"approximateSize"!=e}).every(function(a){return"function"==typeof e[a]})}},function(e,a,t){a.AbstractLevelDOWN=t(197),a.AbstractIterator=t(196),a.AbstractChainedBatch=t(195),a.isLevelDOWN=t(426)},function(e,a,t){var r=t(1),c=t(427).AbstractLevelDOWN,n=t(18),i=t(15),f=t(2);function o(e){this.location=e,c.call(this,e)}r.inherits(o,c),o.prototype._open=function(e,a){a(null,this)},o.prototype._put=function(e,a,t,r){i.writeFile(f.join(this.location,e),a,"utf8",r)},o.prototype._get=function(e,a,t){i.readFile(f.join(this.location,e),"utf8",function(e,a){if(e)return t(new Error("NotFound"));t(null,a)})},o.prototype._del=function(e,a,t){i.unlink(f.join(this.location,e),function(e){if(e)return e.message.indexOf("ENOENT")>=0?t():t(e);t()})},o.prototype._batch=function(e,a,t){var r=this;n.each(e,function(e,t){"put"==e.type?r.put(e.key,e.value,a,t):"del"==e.type?r.del(e.key,a,t):t(new Error("Unknown batch type",e.type))},function(e){if(e)return t(e);t()})},e.exports=function(e){return new o(e)}},function(e,a,t){var r=t(123),c=t(18);function n(e,a,t,c,n){this.db=r(a,n),this.db=this.db.sublevel(e),this.name=e,this.valueserializer=t||{encode:function(e,a){a(null,e)},decode:function(e,a){a(null,e)}},this.keyserializer=c||{encode:function(e,a){a(null,e)},decode:function(e,a){a(null,e)}}}n.prototype.get=function(e,a,t){var r=this;"function"==typeof a&&(t=a,a={}),this.keyserializer.encode(e,function(e,a){if(e)return t(e);r.db.get(a,function(e,a){if(e)return t(e);r.valueserializer.decode(a,function(e,a){if(e)return t(e);t(null,a)})})})},n.prototype.put=function(e,a,t,r){var c=this;"function"==typeof t&&(r=t,t={}),this.keyserializer.encode(e,function(e,t){if(e)return r(e);c.valueserializer.encode(a,function(e,a){if(e)return r(e);c.db.put(t,a,r)})})},n.prototype.set=n.prototype.put,n.prototype.del=function(e,a){var t=this;this.keyserializer.encode(e,function(e,r){if(e)return a(e);t.db.del(r,a)})},n.prototype.batch=function(e,a,t){var r=this;c.each(e,function(e,t){"put"==e.type?r.put(e.key,e.value,a,t):"del"==e.type?r.del(e.key,t):t(new Error("Unknown batch type",e.type))},function(e){if(e)return t(e);t()})},n.prototype.isOpen=function(){return!0},e.exports=n},function(e,a){var t;a=e.exports=W,t="object"==typeof process&&process.env&&process.env.NODE_DEBUG&&/\bsemver\b/i.test(process.env.NODE_DEBUG)?function(){var e=Array.prototype.slice.call(arguments,0);e.unshift("SEMVER"),console.log.apply(console,e)}:function(){},a.SEMVER_SPEC_VERSION="2.0.0";var r=256,c=Number.MAX_SAFE_INTEGER||9007199254740991,n=a.re=[],i=a.src=[],f=0,o=f++;i[o]="0|[1-9]\\d*";var d=f++;i[d]="[0-9]+";var s=f++;i[s]="\\d*[a-zA-Z-][a-zA-Z0-9-]*";var b=f++;i[b]="("+i[o]+")\\.("+i[o]+")\\.("+i[o]+")";var u=f++;i[u]="("+i[d]+")\\.("+i[d]+")\\.("+i[d]+")";var l=f++;i[l]="(?:"+i[o]+"|"+i[s]+")";var p=f++;i[p]="(?:"+i[d]+"|"+i[s]+")";var h=f++;i[h]="(?:-("+i[l]+"(?:\\."+i[l]+")*))";var m=f++;i[m]="(?:-?("+i[p]+"(?:\\."+i[p]+")*))";var g=f++;i[g]="[0-9A-Za-z-]+";var v=f++;i[v]="(?:\\+("+i[g]+"(?:\\."+i[g]+")*))";var y=f++,_="v?"+i[b]+i[h]+"?"+i[v]+"?";i[y]="^"+_+"$";var w="[v=\\s]*"+i[u]+i[m]+"?"+i[v]+"?",A=f++;i[A]="^"+w+"$";var k=f++;i[k]="((?:<|>)?=?)";var x=f++;i[x]=i[d]+"|x|X|\\*";var E=f++;i[E]=i[o]+"|x|X|\\*";var S=f++;i[S]="[v=\\s]*("+i[E]+")(?:\\.("+i[E]+")(?:\\.("+i[E]+")(?:"+i[h]+")?"+i[v]+"?)?)?";var T=f++;i[T]="[v=\\s]*("+i[x]+")(?:\\.("+i[x]+")(?:\\.("+i[x]+")(?:"+i[m]+")?"+i[v]+"?)?)?";var j=f++;i[j]="^"+i[k]+"\\s*"+i[S]+"$";var C=f++;i[C]="^"+i[k]+"\\s*"+i[T]+"$";var R=f++;i[R]="(?:~>?)";var O=f++;i[O]="(\\s*)"+i[R]+"\\s+",n[O]=new RegExp(i[O],"g");var B=f++;i[B]="^"+i[R]+i[S]+"$";var M=f++;i[M]="^"+i[R]+i[T]+"$";var N=f++;i[N]="(?:\\^)";var I=f++;i[I]="(\\s*)"+i[N]+"\\s+",n[I]=new RegExp(i[I],"g");var P=f++;i[P]="^"+i[N]+i[S]+"$";var F=f++;i[F]="^"+i[N]+i[T]+"$";var L=f++;i[L]="^"+i[k]+"\\s*("+w+")$|^$";var D=f++;i[D]="^"+i[k]+"\\s*("+_+")$|^$";var z=f++;i[z]="(\\s*)"+i[k]+"\\s*("+w+"|"+i[S]+")",n[z]=new RegExp(i[z],"g");var q=f++;i[q]="^\\s*("+i[S]+")\\s+-\\s+("+i[S]+")\\s*$";var U=f++;i[U]="^\\s*("+i[T]+")\\s+-\\s+("+i[T]+")\\s*$";var H=f++;i[H]="(<|>)?=?\\s*\\*";for(var V=0;V<f;V++)t(V,i[V]),n[V]||(n[V]=new RegExp(i[V]));function G(e,a){if(e instanceof W)return e;if("string"!=typeof e)return null;if(e.length>r)return null;if(!(a?n[A]:n[y]).test(e))return null;try{return new W(e,a)}catch(e){return null}}function W(e,a){if(e instanceof W){if(e.loose===a)return e;e=e.version}else if("string"!=typeof e)throw new TypeError("Invalid Version: "+e);if(e.length>r)throw new TypeError("version is longer than "+r+" characters");if(!(this instanceof W))return new W(e,a);t("SemVer",e,a),this.loose=a;var i=e.trim().match(a?n[A]:n[y]);if(!i)throw new TypeError("Invalid Version: "+e);if(this.raw=e,this.major=+i[1],this.minor=+i[2],this.patch=+i[3],this.major>c||this.major<0)throw new TypeError("Invalid major version");if(this.minor>c||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>c||this.patch<0)throw new TypeError("Invalid patch version");i[4]?this.prerelease=i[4].split(".").map(function(e){if(/^[0-9]+$/.test(e)){var a=+e;if(a>=0&&a<c)return a}return e}):this.prerelease=[],this.build=i[5]?i[5].split("."):[],this.format()}a.parse=G,a.valid=function(e,a){var t=G(e,a);return t?t.version:null},a.clean=function(e,a){var t=G(e.trim().replace(/^[=v]+/,""),a);return t?t.version:null},a.SemVer=W,W.prototype.format=function(){return this.version=this.major+"."+this.minor+"."+this.patch,this.prerelease.length&&(this.version+="-"+this.prerelease.join(".")),this.version},W.prototype.toString=function(){return this.version},W.prototype.compare=function(e){return t("SemVer.compare",this.version,this.loose,e),e instanceof W||(e=new W(e,this.loose)),this.compareMain(e)||this.comparePre(e)},W.prototype.compareMain=function(e){return e instanceof W||(e=new W(e,this.loose)),K(this.major,e.major)||K(this.minor,e.minor)||K(this.patch,e.patch)},W.prototype.comparePre=function(e){if(e instanceof W||(e=new W(e,this.loose)),this.prerelease.length&&!e.prerelease.length)return-1;if(!this.prerelease.length&&e.prerelease.length)return 1;if(!this.prerelease.length&&!e.prerelease.length)return 0;var a=0;do{var r=this.prerelease[a],c=e.prerelease[a];if(t("prerelease compare",a,r,c),void 0===r&&void 0===c)return 0;if(void 0===c)return 1;if(void 0===r)return-1;if(r!==c)return K(r,c)}while(++a)},W.prototype.inc=function(e,a){switch(e){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",a);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",a);break;case"prepatch":this.prerelease.length=0,this.inc("patch",a),this.inc("pre",a);break;case"prerelease":0===this.prerelease.length&&this.inc("patch",a),this.inc("pre",a);break;case"major":0===this.minor&&0===this.patch&&0!==this.prerelease.length||this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":0===this.patch&&0!==this.prerelease.length||this.minor++,this.patch=0,this.prerelease=[];break;case"patch":0===this.prerelease.length&&this.patch++,this.prerelease=[];break;case"pre":if(0===this.prerelease.length)this.prerelease=[0];else{for(var t=this.prerelease.length;--t>=0;)"number"==typeof this.prerelease[t]&&(this.prerelease[t]++,t=-2);-1===t&&this.prerelease.push(0)}a&&(this.prerelease[0]===a?isNaN(this.prerelease[1])&&(this.prerelease=[a,0]):this.prerelease=[a,0]);break;default:throw new Error("invalid increment argument: "+e)}return this.format(),this.raw=this.version,this},a.inc=function(e,a,t,r){"string"==typeof t&&(r=t,t=void 0);try{return new W(e,t).inc(a,r).version}catch(e){return null}},a.diff=function(e,a){if($(e,a))return null;var t=G(e),r=G(a);if(t.prerelease.length||r.prerelease.length){for(var c in t)if(("major"===c||"minor"===c||"patch"===c)&&t[c]!==r[c])return"pre"+c;return"prerelease"}for(var c in t)if(("major"===c||"minor"===c||"patch"===c)&&t[c]!==r[c])return c},a.compareIdentifiers=K;var Y=/^[0-9]+$/;function K(e,a){var t=Y.test(e),r=Y.test(a);return t&&r&&(e=+e,a=+a),t&&!r?-1:r&&!t?1:e<a?-1:e>a?1:0}function Q(e,a,t){return new W(e,t).compare(a)}function Z(e,a,t){return Q(a,e,t)}function J(e,a,t){return Q(e,a,t)>0}function X(e,a,t){return Q(e,a,t)<0}function $(e,a,t){return 0===Q(e,a,t)}function ee(e,a,t){return 0!==Q(e,a,t)}function ae(e,a,t){return Q(e,a,t)>=0}function te(e,a,t){return Q(e,a,t)<=0}function re(e,a,t,r){var c;switch(a){case"===":"object"==typeof e&&(e=e.version),"object"==typeof t&&(t=t.version),c=e===t;break;case"!==":"object"==typeof e&&(e=e.version),"object"==typeof t&&(t=t.version),c=e!==t;break;case"":case"=":case"==":c=$(e,t,r);break;case"!=":c=ee(e,t,r);break;case">":c=J(e,t,r);break;case">=":c=ae(e,t,r);break;case"<":c=X(e,t,r);break;case"<=":c=te(e,t,r);break;default:throw new TypeError("Invalid operator: "+a)}return c}function ce(e,a){if(e instanceof ce){if(e.loose===a)return e;e=e.value}if(!(this instanceof ce))return new ce(e,a);t("comparator",e,a),this.loose=a,this.parse(e),this.semver===ne?this.value="":this.value=this.operator+this.semver.version,t("comp",this)}a.rcompareIdentifiers=function(e,a){return K(a,e)},a.major=function(e,a){return new W(e,a).major},a.minor=function(e,a){return new W(e,a).minor},a.patch=function(e,a){return new W(e,a).patch},a.compare=Q,a.compareLoose=function(e,a){return Q(e,a,!0)},a.rcompare=Z,a.sort=function(e,t){return e.sort(function(e,r){return a.compare(e,r,t)})},a.rsort=function(e,t){return e.sort(function(e,r){return a.rcompare(e,r,t)})},a.gt=J,a.lt=X,a.eq=$,a.neq=ee,a.gte=ae,a.lte=te,a.cmp=re,a.Comparator=ce;var ne={};function ie(e,a){if(e instanceof ie&&e.loose===a)return e;if(!(this instanceof ie))return new ie(e,a);if(this.loose=a,this.raw=e,this.set=e.split(/\s*\|\|\s*/).map(function(e){return this.parseRange(e.trim())},this).filter(function(e){return e.length}),!this.set.length)throw new TypeError("Invalid SemVer Range: "+e);this.format()}function fe(e){return!e||"x"===e.toLowerCase()||"*"===e}function oe(e,a,t,r,c,n,i,f,o,d,s,b,u){return((a=fe(t)?"":fe(r)?">="+t+".0.0":fe(c)?">="+t+"."+r+".0":">="+a)+" "+(f=fe(o)?"":fe(d)?"<"+(+o+1)+".0.0":fe(s)?"<"+o+"."+(+d+1)+".0":b?"<="+o+"."+d+"."+s+"-"+b:"<="+f)).trim()}function de(e,a){for(var r=0;r<e.length;r++)if(!e[r].test(a))return!1;if(a.prerelease.length){for(r=0;r<e.length;r++)if(t(e[r].semver),e[r].semver!==ne&&e[r].semver.prerelease.length>0){var c=e[r].semver;if(c.major===a.major&&c.minor===a.minor&&c.patch===a.patch)return!0}return!1}return!0}function se(e,a,t){try{a=new ie(a,t)}catch(e){return!1}return a.test(e)}function be(e,a,t,r){var c,n,i,f,o;switch(e=new W(e,r),a=new ie(a,r),t){case">":c=J,n=te,i=X,f=">",o=">=";break;case"<":c=X,n=ae,i=J,f="<",o="<=";break;default:throw new TypeError('Must provide a hilo val of "<" or ">"')}if(se(e,a,r))return!1;for(var d=0;d<a.set.length;++d){var s=null,b=null;if(a.set[d].forEach(function(e){e.semver===ne&&(e=new ce(">=0.0.0")),s=s||e,b=b||e,c(e.semver,s.semver,r)?s=e:i(e.semver,b.semver,r)&&(b=e)}),s.operator===f||s.operator===o)return!1;if((!b.operator||b.operator===f)&&n(e,b.semver))return!1;if(b.operator===o&&i(e,b.semver))return!1}return!0}ce.prototype.parse=function(e){var a=this.loose?n[L]:n[D],t=e.match(a);if(!t)throw new TypeError("Invalid comparator: "+e);this.operator=t[1],"="===this.operator&&(this.operator=""),t[2]?this.semver=new W(t[2],this.loose):this.semver=ne},ce.prototype.toString=function(){return this.value},ce.prototype.test=function(e){return t("Comparator.test",e,this.loose),this.semver===ne||("string"==typeof e&&(e=new W(e,this.loose)),re(e,this.operator,this.semver,this.loose))},a.Range=ie,ie.prototype.format=function(){return this.range=this.set.map(function(e){return e.join(" ").trim()}).join("||").trim(),this.range},ie.prototype.toString=function(){return this.range},ie.prototype.parseRange=function(e){var a=this.loose;e=e.trim(),t("range",e,a);var r=a?n[U]:n[q];e=e.replace(r,oe),t("hyphen replace",e),e=e.replace(n[z],"$1$2$3"),t("comparator trim",e,n[z]),e=(e=(e=e.replace(n[O],"$1~")).replace(n[I],"$1^")).split(/\s+/).join(" ");var c=a?n[L]:n[D],i=e.split(" ").map(function(e){return function(e,a){return t("comp",e),e=function(e,a){return e.trim().split(/\s+/).map(function(e){return function(e,a){t("caret",e,a);var r=a?n[F]:n[P];return e.replace(r,function(a,r,c,n,i){var f;return t("caret",e,a,r,c,n,i),fe(r)?f="":fe(c)?f=">="+r+".0.0 <"+(+r+1)+".0.0":fe(n)?f="0"===r?">="+r+"."+c+".0 <"+r+"."+(+c+1)+".0":">="+r+"."+c+".0 <"+(+r+1)+".0.0":i?(t("replaceCaret pr",i),"-"!==i.charAt(0)&&(i="-"+i),f="0"===r?"0"===c?">="+r+"."+c+"."+n+i+" <"+r+"."+c+"."+(+n+1):">="+r+"."+c+"."+n+i+" <"+r+"."+(+c+1)+".0":">="+r+"."+c+"."+n+i+" <"+(+r+1)+".0.0"):(t("no pr"),f="0"===r?"0"===c?">="+r+"."+c+"."+n+" <"+r+"."+c+"."+(+n+1):">="+r+"."+c+"."+n+" <"+r+"."+(+c+1)+".0":">="+r+"."+c+"."+n+" <"+(+r+1)+".0.0"),t("caret return",f),f})}(e,a)}).join(" ")}(e,a),t("caret",e),e=function(e,a){return e.trim().split(/\s+/).map(function(e){return function(e,a){var r=a?n[M]:n[B];return e.replace(r,function(a,r,c,n,i){var f;return t("tilde",e,a,r,c,n,i),fe(r)?f="":fe(c)?f=">="+r+".0.0 <"+(+r+1)+".0.0":fe(n)?f=">="+r+"."+c+".0 <"+r+"."+(+c+1)+".0":i?(t("replaceTilde pr",i),"-"!==i.charAt(0)&&(i="-"+i),f=">="+r+"."+c+"."+n+i+" <"+r+"."+(+c+1)+".0"):f=">="+r+"."+c+"."+n+" <"+r+"."+(+c+1)+".0",t("tilde return",f),f})}(e,a)}).join(" ")}(e,a),t("tildes",e),e=function(e,a){return t("replaceXRanges",e,a),e.split(/\s+/).map(function(e){return function(e,a){e=e.trim();var r=a?n[C]:n[j];return e.replace(r,function(a,r,c,n,i,f){t("xRange",e,a,r,c,n,i,f);var o=fe(c),d=o||fe(n),s=d||fe(i),b=s;return"="===r&&b&&(r=""),o?a=">"===r||"<"===r?"<0.0.0":"*":r&&b?(d&&(n=0),s&&(i=0),">"===r?(r=">=",d?(c=+c+1,n=0,i=0):s&&(n=+n+1,i=0)):"<="===r&&(r="<",d?c=+c+1:n=+n+1),a=r+c+"."+n+"."+i):d?a=">="+c+".0.0 <"+(+c+1)+".0.0":s&&(a=">="+c+"."+n+".0 <"+c+"."+(+n+1)+".0"),t("xRange return",a),a})}(e,a)}).join(" ")}(e,a),t("xrange",e),e=function(e,a){return t("replaceStars",e,a),e.trim().replace(n[H],"")}(e,a),t("stars",e),e}(e,a)}).join(" ").split(/\s+/);return this.loose&&(i=i.filter(function(e){return!!e.match(c)})),i=i.map(function(e){return new ce(e,a)})},a.toComparators=function(e,a){return new ie(e,a).set.map(function(e){return e.map(function(e){return e.value}).join(" ").trim().split(" ")})},ie.prototype.test=function(e){if(!e)return!1;"string"==typeof e&&(e=new W(e,this.loose));for(var a=0;a<this.set.length;a++)if(de(this.set[a],e))return!0;return!1},a.satisfies=se,a.maxSatisfying=function(e,a,t){return e.filter(function(e){return se(e,a,t)}).sort(function(e,a){return Z(e,a,t)})[0]||null},a.validRange=function(e,a){try{return new ie(e,a).range||"*"}catch(e){return null}},a.ltr=function(e,a,t){return be(e,a,"<",t)},a.gtr=function(e,a,t){return be(e,a,">",t)},a.outside=be},function(e){e.exports={_args:[["levelup@0.19.1","/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core"]],_from:"levelup@0.19.1",_id:"levelup@0.19.1",_inBundle:!1,_integrity:"sha1-86anIFJyxLXzXkEv8ASgOgrt9Qs=",_location:"/ganache-core/level-sublevel/levelup",_phantomChildren:{},_requested:{type:"version",registry:!0,raw:"levelup@0.19.1",name:"levelup",escapedName:"levelup",rawSpec:"0.19.1",saveSpec:null,fetchSpec:"0.19.1"},_requiredBy:["/ganache-core/level-sublevel"],_resolved:"https://registry.npmjs.org/levelup/-/levelup-0.19.1.tgz",_spec:"0.19.1",_where:"/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core",browser:{leveldown:!1,"leveldown/package":!1,semver:!1},bugs:{url:"https://github.com/rvagg/node-levelup/issues"},contributors:[{name:"Rod Vagg",email:"r@va.gg",url:"https://github.com/rvagg"},{name:"John Chesley",email:"john@chesl.es",url:"https://github.com/chesles/"},{name:"Jake Verbaten",email:"raynos2@gmail.com",url:"https://github.com/raynos"},{name:"Dominic Tarr",email:"dominic.tarr@gmail.com",url:"https://github.com/dominictarr"},{name:"Max Ogden",email:"max@maxogden.com",url:"https://github.com/maxogden"},{name:"Lars-Magnus Skog",email:"lars.magnus.skog@gmail.com",url:"https://github.com/ralphtheninja"},{name:"David Björklund",email:"david.bjorklund@gmail.com",url:"https://github.com/kesla"},{name:"Julian Gruber",email:"julian@juliangruber.com",url:"https://github.com/juliangruber"},{name:"Paolo Fragomeni",email:"paolo@async.ly",url:"https://github.com/hij1nx"},{name:"Anton Whalley",email:"anton.whalley@nearform.com",url:"https://github.com/No9"},{name:"Matteo Collina",email:"matteo.collina@gmail.com",url:"https://github.com/mcollina"},{name:"Pedro Teixeira",email:"pedro.teixeira@gmail.com",url:"https://github.com/pgte"},{name:"James Halliday",email:"mail@substack.net",url:"https://github.com/substack"}],dependencies:{bl:"~0.8.1","deferred-leveldown":"~0.2.0",errno:"~0.1.1",prr:"~0.0.0","readable-stream":"~1.0.26",semver:"~5.1.0",xtend:"~3.0.0"},description:"Fast & simple storage - a Node.js-style LevelDB wrapper",devDependencies:{async:"*",boganipsum:"*",bustermove:"~1.0.1",delayed:"*",du:"*",fstream:"*",leveldown:"~0.10.0",memdown:"^0.11.0",mkfiletree:"*","msgpack-js":"*",readfiletree:"*",referee:"*",rimraf:"*","slow-stream":">=0.0.4",tap:"2.x.x",tape:"4.x.x",tar:"*"},homepage:"https://github.com/rvagg/node-levelup",keywords:["leveldb","stream","database","db","store","storage","json"],license:"MIT",main:"lib/levelup.js",name:"levelup",repository:{type:"git",url:"git+https://github.com/rvagg/node-levelup.git"},scripts:{alltests:"npm test && npm run-script functionaltests",functionaltests:"node ./test/functional/fstream-test.js && node ./test/functional/binary-data-test.js && node ./test/functional/compat-test.js",test:"tap test/*-test.js"},version:"0.19.1"}},function(e,a,t){var r,c=t(198),n=t(122).LevelUPError,i=t(202),f={createIfMissing:!0,errorIfExists:!1,keyEncoding:"utf8",valueEncoding:"utf8",compression:!0},o=function(){var e={};for(var a in i)e[a]={valueEncoding:i[a]};return e}();e.exports={defaultOptions:f,copy:function(e,a,t){e.readStream().pipe(a.writeStream()).on("close",t||function(){}).on("error",t||function(e){throw e})},getOptions:function(e,a){var t="string"==typeof a;return!t&&a&&a.encoding&&!a.valueEncoding&&(a.valueEncoding=a.encoding),c(e&&e.options||{},t?o[a]||o[f.valueEncoding]:a)},getLevelDOWN:function(){if(r)return r;var e,a=t(431).devDependencies.leveldown;try{e=t(!function(){var e=new Error("Cannot find module 'leveldown/package'");throw e.code="MODULE_NOT_FOUND",e}()).version}catch(e){throw new n("Could not locate LevelDOWN, try `npm install leveldown`")}if(!t(430).satisfies(e,a))throw new n("Installed version of LevelDOWN ("+e+") does not match required version ("+a+")");try{return r=t(!function(){var e=new Error("Cannot find module 'leveldown'");throw e.code="MODULE_NOT_FOUND",e}())}catch(e){throw new n("Could not locate LevelDOWN, try `npm install leveldown`")}},dispatchError:function(e,a,t){return"function"==typeof t?t(a):e.emit("error",a)},isDefined:function(e){return void 0!==e}}},function(e,a,t){e.exports=n;var r=t(199),c=t(17);function n(e){if(!(this instanceof n))return new n(e);r.call(this,e)}c.inherits=t(0),c.inherits(n,r),n.prototype._transform=function(e,a,t){t(null,e)}},function(e,a,t){var r=t(6);(a=e.exports=t(201)).Stream=r,a.Readable=a,a.Writable=t(200),a.Duplex=t(121),a.Transform=t(199),a.PassThrough=t(433),process.browser||"disable"!==process.env.READABLE_STREAM||(e.exports=t(6))},function(e,a,t){var r=t(434).Readable,c=t(1).inherits,n=(t(198),t(122).EncodingError);t(432);function i(e,a){if(!(this instanceof i))return new i(e,a);r.call(this,{objectMode:!0,highWaterMark:e.highWaterMark}),this._waiting=!1,this._options=e,this._makeData=a}c(i,r),i.prototype.setIterator=function(e){return this._iterator=e,this._destroyed?e.end(function(){}):this._waiting?(this._waiting=!1,this._read()):this},i.prototype._read=function(){var e=this;if(!e._destroyed)return e._iterator?void e._iterator.next(function(a,t,r){if(a||void 0===t&&void 0===r)return a||e._destroyed||e.push(null),e._cleanup(a);try{r=e._makeData(t,r)}catch(a){return e._cleanup(new n(a))}e._destroyed||e.push(r)}):this._waiting=!0},i.prototype._cleanup=function(e){if(!this._destroyed){this._destroyed=!0;var a=this;e&&a.emit("error",e),a._iterator?a._iterator.end(function(){a._iterator=null,a.emit("close")}):a.emit("close")}},i.prototype.destroy=function(){this._cleanup()},i.prototype.toString=function(){return"LevelUP.ReadStream"},e.exports=i},function(e,a,t){var r=t(202);function c(e,a){var t=a&&a.keyEncoding||e.keyEncoding||"utf8";return r[t]||t}function n(e,a){var t=a&&(a.valueEncoding||a.encoding)||e.valueEncoding||e.encoding||"utf8";return r[t]||t}e.exports={encodeKey:function(e,a,t){return c(a,t).encode(e)},encodeValue:function(e,a,t){return n(a,t).encode(e)},isValueAsBuffer:function(e,a){return n(e,a).buffer},isKeyAsBuffer:function(e,a){return c(e,a).buffer},decodeValue:function(e,a){return n(a).decode(e)},decodeKey:function(e,a){return c(a).decode(e)}}},function(e,a){a.encode=function(e){return"!"+e[0].join("#")+"!"+e[1]},a.decode=function(e){var a=e.indexOf("!",1);return[e.substring(1,a).split("#").filter(Boolean),e.substring(++a)]},a.buffer=!1,a.lowerBound="\0",a.upperBound="￿"},function(e){e.exports={_args:[["level-sublevel@6.6.2","/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core"]],_from:"level-sublevel@6.6.2",_id:"level-sublevel@6.6.2",_inBundle:!1,_integrity:"sha512-+hptqmFYPKFju9QG4F6scvx3ZXkhrSmmhYui+hPzRn/jiC3DJ6VNZRKsIhGMpeajVBWfRV7XiysUThrJ/7PgXQ==",_location:"/ganache-core/level-sublevel",_phantomChildren:{bl:"0.8.2","core-util-is":"1.0.2",errno:"0.1.7",inherits:"2.0.3",isarray:"0.0.1",string_decoder:"0.10.31"},_requested:{type:"version",registry:!0,raw:"level-sublevel@6.6.2",name:"level-sublevel",escapedName:"level-sublevel",rawSpec:"6.6.2",saveSpec:null,fetchSpec:"6.6.2"},_requiredBy:["/ganache-core"],_resolved:"https://registry.npmjs.org/level-sublevel/-/level-sublevel-6.6.2.tgz",_spec:"6.6.2",_where:"/home/benjamincburns/projects/consensys/ganache-cli/node_modules/ganache-core",author:{name:"Dominic Tarr",email:"dominic.tarr@gmail.com",url:"http://dominictarr.com"},bugs:{url:"https://github.com/dominictarr/level-sublevel/issues"},dependencies:{bytewise:"~1.1.0",levelup:"~0.19.0",ltgt:"~2.1.1","pull-defer":"^0.2.2","pull-level":"^2.0.3","pull-stream":"^3.6.8",typewiselite:"~1.0.0",xtend:"~4.0.0"},description:"partition levelup databases",devDependencies:{level:"^3.0.1","level-test":"^3.0.0","monotonic-timestamp":"0.0.8","pull-level":"~1.1.1",rimraf:"~2.1.4",shasum:"0.0.2","stream-to-pull-stream":"~1.2.0",tape:"~2.14.0",through:"~2.3.4"},homepage:"https://github.com/dominictarr/level-sublevel",license:"MIT",name:"level-sublevel",repository:{type:"git",url:"git://github.com/dominictarr/level-sublevel.git"},scripts:{test:"set -e; for t in test/*.js; do node $t; done"},stability:"unstable",testling:{files:"test/*.js",browsers:["ie/8..latest","firefox/17..latest","firefox/nightly","chrome/22..latest","chrome/canary","opera/12..latest","opera/next","safari/5.1..latest","ipad/6.0..latest","iphone/6.0..latest","android-browser/4.2..latest"]},version:"6.6.2"}},function(e,a,t){var r=t(5).EventEmitter,c=t(204).addPrefix,n=t(122);function i(e){return"function"==typeof e}function f(e){return"string"==typeof e}function o(e){return e&&"object"==typeof e}var d=t(438).version,s=e.exports=function(e,a,t,b){var u=new r;function l(e){e&&u.emit("error",e)}function p(e){var a={};if(b)for(var t in b)void 0!=b[t]&&(a[t]=b[t]);if(e)for(var t in e)void 0!=e[t]&&(a[t]=e[t]);return a}return u.sublevels={},u.options=b,u.version=d,u.methods={},a=a||[],t=t||function(e){return e},u.put=function(t,r,c,n){"function"==typeof c&&(n=c,c={}),n||(n=l),e.apply([{key:t,value:r,prefix:a.slice(),type:"put"}],p(c),function(e){if(e||(u.emit("put",t,r),n(null)),e)return n(e)})},u.prefix=function(){return a.slice()},u.del=function(t,r,c){"function"==typeof r&&(c=r,r={}),c||(c=l),e.apply([{key:t,prefix:a.slice(),type:"del"}],p(r),function(e){if(e||(u.emit("del",t),c(null)),e)return c(e)})},u.batch=function(t,r,c){"function"==typeof r&&(c=r,r={}),c||(c=l),t=t.map(function(e){return{key:e.key,value:e.value,prefix:e.prefix||a,keyEncoding:e.keyEncoding,valueEncoding:e.valueEncoding,type:e.type}}),e.apply(t,p(r),function(e){if(e||(u.emit("batch",t),c(null)),e)return c(e)})},u.get=function(t,r,c){"function"==typeof r&&(c=r,r={}),e.get(t,a,p(r),function(e,a){e?c(new n.NotFoundError("Key not found in database",e)):c(null,a)})},u.clone=function(r){return s(e,a,t,p(r))},u.sublevel=function(r,c){return u.sublevels[r]=u.sublevels[r]||s(e,a.concat(r),t,p(c))},u.pre=function(t,r){if(i(t))return e.pre([a],t);if(f(t))return e.pre([a,t],r);if(o(t))return e.pre(c(a,t),r);throw new Error("not implemented yet")},u.post=function(t,r){if(i(t))return e.post([a],t);if(f(t))return e.post([a,t],r);if(o(t))return e.post(c(a,t),r);throw new Error("not implemented yet")},u.readStream=u.createReadStream=function(r){var c;(r=p(r)).prefix=a;var n=e.iterator(r,function(e,a){c.setIterator(a)});return c=t(r,e.createDecoder(r)),n&&c.setIterator(n),c},u.valueStream=u.createValueStream=function(e){return(e=e||{}).values=!0,e.keys=!1,u.createReadStream(e)},u.keyStream=u.createKeyStream=function(e){return(e=e||{}).values=!1,e.keys=!0,u.createReadStream(e)},u.close=function(t){t=t||function(){},a.length?process.nextTick(t):e.close(t)},u.isOpen=e.isOpen,u.isClosed=e.isClosed,u.location=e.location,u}},function(e,a,t){var r=t(204);e.exports=function(e){var a=[];return{add:function(e,t){var r={range:e,hook:t};return a.push(r),function(){var e=a.indexOf(r);if(~e)return a.splice(e,1)}},removeAll:function(e){throw new Error("not implemented")},trigger:function(t,c){for(var n=0;n<a.length;n++){var i=a[n];r(i.range,t,e)&&i.hook.apply(this,c)}}}}},function(e,a,t){var r=t(440),c=t(203);function n(e){return"function"==typeof e}function i(e){return null==e?e:n(e.prefix)?e.prefix():e}e.exports=function(e,a,t,f){var o=r(f),d=r(f),s=[],b=!1;function u(e,r,c,n){return a.encode([e,t.encodeKey(r,c,n)])}function l(e,a){return a&&a.options&&(e.keyEncoding=e.keyEncoding||a.options.keyEncoding,e.valueEncoding=e.valueEncoding||a.options.valueEncoding),e}function p(){for(b=!0;s.length;)s.shift()()}return n(e.isOpen)&&e.isOpen()?b=!0:e.open(p),{location:e.location,apply:function(a,r,c){for(var n=0;n<a.length;n++){var f=a[n];function s(e){if(!1===e)return delete a[n];a.push(e)}l(f,f.prefix),f.prefix=i(f.prefix),o.trigger([f.prefix,f.key],[f,s,a])}if("object"!=typeof(r=r||{}))throw new Error("opts must be object, was:"+r);"function"==typeof r&&(c=r,r={}),a.length?(e.db||e).batch(a.map(function(e){return{key:u(e.prefix,e.key,r,e),value:"del"!==e.type?t.encodeValue(e.value,r,e):void 0,type:e.type||(void 0===e.value?"del":"put")}}),r,function(e){if(e)return c(e);a.forEach(function(e){d.trigger([e.prefix,e.key],[e])}),c()}):c()},get:function(a,r,c,n){return c.asBuffer=t.isValueAsBuffer(c),(e.db||e).get(u(r,a,c),c,function(e,a){e?n(e):n(null,t.decodeValue(a,c))})},pre:o.add,post:d.add,createDecoder:function(e){return!1!==e.keys&&!1!==e.values?function(r,c){return{key:t.decodeKey(a.decode(r)[1],e),value:t.decodeValue(c,e)}}:!1!==e.values?function(a,r){return t.decodeValue(r,e)}:!1!==e.keys?function(r){return t.decodeKey(a.decode(r)[1],e)}:function(){}},isOpen:function(){return e.db&&n(e.db.isOpen)?e.db.isOpen():e.isOpen()},isClosed:function(){return e.db&&n(e.db.isClosed)?e.db.isClosed():e.isClosed()},close:function(a){return e.close(a)},iterator:function(r,n){var i=function(e){var a={};for(var t in e)a[t]=e[t];return a}(r||{}),f=r.prefix||[];function o(e){return{next:function(a){return e.next(a)},end:function(a){e.end(a)}}}if(c.toLtgt(r,i,function(e){return u(f,e,i,{})},a.lowerBound,a.upperBound),i.prefix=null,i.keyAsBuffer=i.valueAsBuffer=!1,"number"!=typeof i.limit&&(i.limit=-1),i.keyAsBuffer=a.buffer,i.valueAsBuffer=t.isValueAsBuffer(i),b)return o((e.db||e).iterator(i));s.push(function(){n(null,o((e.db||e).iterator(i)))})}}}},function(e,a,t){var r=t(123);function c(e,a,t){this.db=r(a),this.db=this.db.sublevel(e),this.name=e,this.serializer=t||{encode:function(e,a){a(null,e)},decode:function(e,a){a(null,e)}}}c.prototype.length=function(e){this.db.get("length",function(a,t){if(a)return a.notFound?e(null,0):e(a);e(null,t)})},c.prototype._get=function(e,a){var t=this;this.db.get(e,function(e,r){if(e)return a(e);t.serializer.decode(r,a)})},c.prototype._put=function(e,a,t){var r=this;this.serializer.encode(a,function(a,c){if(a)return t(a);r.db.put(e,c,t)})},c.prototype.get=function(e,a){var t=this;this.length(function(r,c){return r?a(r):e>=c?a(new Error("LevelUpArrayAdapter named '"+t.name+"' index out of range: index "+e+"; length: "+c)):void t._get(e,a)})},c.prototype.push=function(e,a){var t=this;this.length(function(r,c){if(r)return a(r);t._put(c+"",e,function(e){if(e)return a(e);t.db.put("length",c+1,a)})})},c.prototype.pop=function(e){var a=this;this.length(function(t,r){if(t)return e(t);var c=r-1;a._get(c+"",function(t,r){if(t)return e(t);a.db.del(c+"",function(t){if(t)return e(t);a.db.put("length",c,function(a){if(a)return e(a);e(null,r)})})})})},c.prototype.last=function(e){var a=this;this.length(function(t,r){return t?e(t):0==r?e(null,null):void a._get(r-1+"",e)})},c.prototype.first=function(e){this._get("0",e)},e.exports=c},function(e,a,t){var r=t(442),c=t(429),n=t(179),i=t(428),f=t(425),o=(t(123),t(87),t(191)),d=t(190),s=t(419),b=t(418),u=t(417),l=(t(19),t(3),t(117),t(416));function p(e){this.options=e}p.prototype.initialize=function(e){var a=this;function t(t,n){if(t)return e(t);a.db=n,a.blocks=new r("blocks",a.db,d),a.blockLogs=new r("blockLogs",a.db,new b(a)),a.blockHashes=new c("blockHashes",a.db),a.transactions=new c("transactions",a.db,o),a.transactionReceipts=new c("transactionReceipts",a.db,new u(a)),a.trie_db=new c("trie_db",a.db,s,s),e()}!function(e){a.options.db_path?e(null,a.options.db_path):l.dir(e)}(function(r,c){if(r)return e(r);n(c,{valueEncoding:"json",db:function(e){return a.options.db?a.options.db:f(e,i).maxSize(100)}},t)})},p.prototype.close=function(e){e()},e.exports=p},function(e,a,t){var r,c,n;(function(){var t,i,f,o,d,s,b,u,l,p,h,m,g,v,y;f=Math.floor,p=Math.min,i=function(e,a){return e<a?-1:e>a?1:0},l=function(e,a,t,r,c){var n;if(null==t&&(t=0),null==c&&(c=i),t<0)throw new Error("lo must be non-negative");for(null==r&&(r=e.length);t<r;)c(a,e[n=f((t+r)/2)])<0?r=n:t=n+1;return[].splice.apply(e,[t,t-t].concat(a)),a},s=function(e,a,t){return null==t&&(t=i),e.push(a),v(e,0,e.length-1,t)},d=function(e,a){var t,r;return null==a&&(a=i),t=e.pop(),e.length?(r=e[0],e[0]=t,y(e,0,a)):r=t,r},u=function(e,a,t){var r;return null==t&&(t=i),r=e[0],e[0]=a,y(e,0,t),r},b=function(e,a,t){var r;return null==t&&(t=i),e.length&&t(e[0],a)<0&&(a=(r=[e[0],a])[0],e[0]=r[1],y(e,0,t)),a},o=function(e,a){var t,r,c,n,o,d;for(null==a&&(a=i),o=[],r=0,c=(n=function(){d=[];for(var a=0,t=f(e.length/2);0<=t?a<t:a>t;0<=t?a++:a--)d.push(a);return d}.apply(this).reverse()).length;r<c;r++)t=n[r],o.push(y(e,t,a));return o},g=function(e,a,t){var r;if(null==t&&(t=i),-1!==(r=e.indexOf(a)))return v(e,0,r,t),y(e,r,t)},h=function(e,a,t){var r,c,n,f,d;if(null==t&&(t=i),!(c=e.slice(0,a)).length)return c;for(o(c,t),n=0,f=(d=e.slice(a)).length;n<f;n++)r=d[n],b(c,r,t);return c.sort(t).reverse()},m=function(e,a,t){var r,c,n,f,s,b,u,h,m;if(null==t&&(t=i),10*a<=e.length){if(!(n=e.slice(0,a).sort(t)).length)return n;for(c=n[n.length-1],f=0,b=(u=e.slice(a)).length;f<b;f++)t(r=u[f],c)<0&&(l(n,r,0,null,t),n.pop(),c=n[n.length-1]);return n}for(o(e,t),m=[],s=0,h=p(a,e.length);0<=h?s<h:s>h;0<=h?++s:--s)m.push(d(e,t));return m},v=function(e,a,t,r){var c,n,f;for(null==r&&(r=i),c=e[t];t>a&&r(c,n=e[f=t-1>>1])<0;)e[t]=n,t=f;return e[t]=c},y=function(e,a,t){var r,c,n,f,o;for(null==t&&(t=i),c=e.length,o=a,n=e[a],r=2*a+1;r<c;)(f=r+1)<c&&!(t(e[r],e[f])<0)&&(r=f),e[a]=e[r],r=2*(a=r)+1;return e[a]=n,v(e,o,a,t)},t=function(){function e(e){this.cmp=null!=e?e:i,this.nodes=[]}return e.push=s,e.pop=d,e.replace=u,e.pushpop=b,e.heapify=o,e.updateItem=g,e.nlargest=h,e.nsmallest=m,e.prototype.push=function(e){return s(this.nodes,e,this.cmp)},e.prototype.pop=function(){return d(this.nodes,this.cmp)},e.prototype.peek=function(){return this.nodes[0]},e.prototype.contains=function(e){return-1!==this.nodes.indexOf(e)},e.prototype.replace=function(e){return u(this.nodes,e,this.cmp)},e.prototype.pushpop=function(e){return b(this.nodes,e,this.cmp)},e.prototype.heapify=function(){return o(this.nodes,this.cmp)},e.prototype.updateItem=function(e){return g(this.nodes,e,this.cmp)},e.prototype.clear=function(){return this.nodes=[]},e.prototype.empty=function(){return 0===this.nodes.length},e.prototype.size=function(){return this.nodes.length},e.prototype.clone=function(){var a;return(a=new e).nodes=this.nodes.slice(0),a},e.prototype.toArray=function(){return this.nodes.slice(0)},e.prototype.insert=e.prototype.push,e.prototype.top=e.prototype.peek,e.prototype.front=e.prototype.peek,e.prototype.has=e.prototype.contains,e.prototype.copy=e.prototype.clone,e}(),c=[],void 0===(n="function"==typeof(r=function(){return t})?r.apply(a,c):r)||(e.exports=n)}).call(this)},function(e,a,t){e.exports=t(444)},function(e,a){e.exports=function(e){var a=e.fsp,t=e.files,r=e.os,c=e.path,n=e.child_process,i=e.mimetype,f=e.defaultArchives,o=e.request,d=e.downloadUrl,s=e.bytes,b=e.hash,u=e.pick,l=function(e){return function(a){for(var t={},r=0,c=e.length;r<c;++r)t[e[r]]=a[r];return t}},p=function(e){return function(a){return e+"/bzzr:/"+a}},h=function(e){return function(a){return o(p(e)(a),{responseType:"arraybuffer"}).then(function(e){var a=new Uint8Array(e);if(function(e){return function(a){if(e.length!==a.length)return!1;var t=0;for(e.length;t<e;++t)if(e[t]!==a[t])return!1;return!0}}(a)([52,48,52,32,112,97,103,101,32,110,111,116,32,102,111,117,110,100,10]))throw"Error 404.";return a})}},m=function(e){return function(a){return function a(t){return function(r){return function(c){var n=function(e){return void 0===e.path?Promise.resolve():"application/bzz-manifest+json"===e.contentType?a(e.hash)(r+e.path)(c):Promise.resolve(function(e){return function(a){return function(t){return t[e]=a,t}}}(r+e.path)(function(e){return{type:e.contentType,hash:e.hash}}(e))(c))};return h(e)(t).then(function(e){return JSON.parse(P(e)).entries}).then(function(e){return Promise.all(e.map(n))}).then(function(){return c})}}}(a)("")({})}},g=function(e){return function(a){return m(e)(a).then(function(e){return l(Object.keys(e))(Object.keys(e).map(function(a){return e[a].hash}))})}},v=function(e){return function(a){return m(e)(a).then(function(a){var t=Object.keys(a),r=t.map(function(e){return a[e].hash}),c=t.map(function(e){return a[e].type}),n=r.map(h(e));return Promise.all(n).then(function(e){return l(t)(function(e){return e.map(function(e,a){return{type:c[a],data:e}})}(e))})})}},y=function(e){return function(a){return function(r){return t.download(p(e)(a))(r)}}},_=function(e){return function(a){return function(t){return g(e)(a).then(function(a){var r=[];for(var n in a)if(n.length>0){var i=c.join(t,n);r.push(y(e)(a[n])(i))}return Promise.all(r).then(function(){return t})})}}},w=function(e){return function(a){return o(e+"/bzzr:/",{body:"string"==typeof a?F(a):a,method:"POST"})}},A=function(e){return function(a){return function(t){return function(r){return function c(n){var i="/"===t[0]?t:"/"+t,f=e+"/bzz:/"+a+i,d={method:"PUT",headers:{"Content-Type":r.type},body:r.data};return o(f,d).then(function(e){if(-1!==e.indexOf("error"))throw e;return e}).catch(function(e){return n>0&&c(n-1)})}(3)}}}},k=function(e){return function(a){return E(e)({"":a})}},x=function(e){return function(t){return a.readFile(t).then(function(a){return k(e)({type:i.lookup(t),data:a})})}},E=function(e){return function(a){return w(e)("{}").then(function(t){return Object.keys(a).reduce(function(t,r){return t.then(function(t){return function(r){return A(e)(r)(t)(a[t])}}(r))},Promise.resolve(t))})}},S=function(e){return function(t){return a.readFile(t).then(w(e))}},T=function(e){return function(r){return function(c){return t.directoryTree(c).then(function(e){return Promise.all(e.map(function(e){return a.readFile(e)})).then(function(a){var t=e.map(function(e){return e.slice(c.length)}),r=e.map(function(e){return i.lookup(e)||"text/plain"});return l(t)(a.map(function(e,a){return{type:r[a],data:e}}))})}).then(function(e){return function(e){return function(a){var t={};for(var r in e)t[r]=e[r];for(var c in a)t[c]=a[c];return t}}(r?{"":e[r]}:{})(e)}).then(E(e))}}},j=function(e){return function(a){if("data"===a.pick)return u.data().then(w(e));if("file"===a.pick)return u.file().then(k(e));if("directory"===a.pick)return u.directory().then(E(e));if(a.path)switch(a.kind){case"data":return S(e)(a.path);case"file":return x(e)(a.path);case"directory":return T(e)(a.defaultFile)(a.path)}else{if(a.length||"string"==typeof a)return w(e)(a);if(a instanceof Object)return E(e)(a)}return Promise.reject(new Error("Bad arguments"))}},C=function(e){return function(a){return function(t){return N(e)(a).then(function(r){return r?t?_(e)(a)(t):v(e)(a):t?y(e)(a)(t):h(e)(a)})}}},R=function(e,a){var c=r.platform().replace("win32","windows")+"-"+("x64"===r.arch()?"amd64":"386"),n=(a||f)[c],i=d+n.archive+".tar.gz",o=n.archiveMD5,s=n.binaryMD5;return t.safeDownloadArchived(i)(o)(s)(e)},O=function(e){return new Promise(function(a,t){var r=n.spawn,c=function(e){return function(a){return-1!==(""+a).indexOf(e)}},i=e.account,f=e.password,o=e.dataDir,d=e.ensApi,s=e.privateKey,b=0,u=r(e.binPath,["--bzzaccount",i||s,"--datadir",o,"--ens-api",d]),l=function(e){0===b&&c("Passphrase")(e)?setTimeout(function(){b=1,u.stdin.write(f+"\n")},500):c("Swarm http proxy started")(e)&&(b=2,clearTimeout(p),a(u))};u.stdout.on("data",l),u.stderr.on("data",l);var p=setTimeout(function(){return t(new Error("Couldn't start swarm process."))},2e4)})},B=function(e){return new Promise(function(a,t){e.stderr.removeAllListeners("data"),e.stdout.removeAllListeners("data"),e.stdin.removeAllListeners("error"),e.removeAllListeners("error"),e.removeAllListeners("exit"),e.kill("SIGINT");var r=setTimeout(function(){return e.kill("SIGKILL")},8e3);e.once("close",function(){clearTimeout(r),a()})})},M=function(e){return w(e)("test").then(function(e){return"c9a99c7d326dcc6316f32fe2625b311f6dc49a175e6877681ded93137d3569e7"===e}).catch(function(){return!1})},N=function(e){return function(a){return h(e)(a).then(function(e){try{return!!JSON.parse(P(e)).entries}catch(e){return!1}})}},I=function(e){return function(a,t,r,c,n){var i;return void 0!==a&&(i=e(a)),void 0!==t&&(i=e(t)),void 0!==r&&(i=e(r)),void 0!==c&&(i=e(c)),void 0!==n&&(i=e(n)),i}},P=function(e){return s.toString(s.fromUint8Array(e))},F=function(e){return s.toUint8Array(s.fromString(e))},L=function(e){return{download:function(a,t){return C(e)(a)(t)},downloadData:I(h(e)),downloadDataToDisk:I(y(e)),downloadDirectory:I(v(e)),downloadDirectoryToDisk:I(_(e)),downloadEntries:I(m(e)),downloadRoutes:I(g(e)),isAvailable:function(){return M(e)},upload:function(a){return j(e)(a)},uploadData:I(w(e)),uploadFile:I(k(e)),uploadFileFromDisk:I(k(e)),uploadDataFromDisk:I(S(e)),uploadDirectory:I(E(e)),uploadDirectoryFromDisk:I(T(e)),uploadToManifest:I(A(e)),pick:u,hash:b,fromString:F,toString:P}};return{at:L,local:function(e){return function(a){return M("http://localhost:8500").then(function(t){return t?a(L("http://localhost:8500")).then(function(){}):R(e.binPath,e.archives).onData(function(a){return(e.onProgress||function(){})(a.length)}).then(function(){return O(e)}).then(function(e){return a(L("http://localhost:8500")).then(function(){return e})}).then(B)})}},download:C,downloadBinary:R,downloadData:h,downloadDataToDisk:y,downloadDirectory:v,downloadDirectoryToDisk:_,downloadEntries:m,downloadRoutes:g,isAvailable:M,startProcess:O,stopProcess:B,upload:j,uploadData:w,uploadDataFromDisk:S,uploadFile:k,uploadFileFromDisk:x,uploadDirectory:E,uploadDirectoryFromDisk:T,uploadToManifest:A,pick:u,hash:b,fromString:F,toString:P}}},function(e,a){var t=function(e){return function(){return new Promise(function(a,t){var r=function(t){var r={},c=t.target.files.length,n=0;[].map.call(t.target.files,function(t){var i=new FileReader;i.onload=function(i){var f=new Uint8Array(i.target.result);if("directory"===e){var o=t.webkitRelativePath;r[o.slice(o.indexOf("/")+1)]={type:"text/plain",data:f},++n===c&&a(r)}else if("file"===e){var d=t.webkitRelativePath;a({type:mimetype.lookup(d),data:f})}else a(f)},i.readAsArrayBuffer(t)})},c=void 0;"directory"===e?((c=document.createElement("input")).addEventListener("change",r),c.type="file",c.webkitdirectory=!0,c.mozdirectory=!0,c.msdirectory=!0,c.odirectory=!0,c.directory=!0):((c=document.createElement("input")).addEventListener("change",r),c.type="file");var n=document.createEvent("MouseEvents");n.initEvent("click",!0,!1),c.dispatchEvent(n)})}};e.exports={data:t("data"),file:t("file"),directory:t("directory")}},function(e,a,t){var r=t(319).keccak256,c=t(205),n=function(e,a){var t=c.reverse(c.pad(6,c.fromNumber(e))),n=c.flatten([t,"0x0000",a]);return r(n).slice(2)};e.exports=function e(a){"string"==typeof a&&"0x"!==a.slice(0,2)?a=c.fromString(a):"string"!=typeof a&&void 0!==a.length&&(a=c.fromUint8Array(a));var t=c.length(a);if(t<=4096)return n(t,a);for(var r=4096;128*r<t;)r*=128;for(var i=[],f=0;f<t;f+=r){var o=r<t-f?r:t-f;i.push(e(c.slice(a,f,f+o)))}return n(t,c.flatten(i))}},function(e,a){var t=function(e,a){for(var t=[],r=0;r<e;++r)t.push(a(r));return t};e.exports={generate:t,replicate:function(e,a){return t(e,function(){return a})},concat:function(e,a){return e.concat(a)},flatten:function(e){for(var a=[],t=0,r=e.length;t<r;++t)for(var c=0,n=e[t].length;c<n;++c)a.push(e[t][c]);return a},chunksOf:function(e,a){for(var t=[],r=0,c=a.length;r<c;r+=e)t.push(a.slice(r,r+e));return t}}},function(e,a){e.exports=function(e,a){return a?{statusCode:a.statusCode,headers:a.headers,method:e.method,url:e.url,rawRequest:a.rawRequest?a.rawRequest:a}:null}},function(e,a,t){!function(t){var r=new Buffer(0).buffer instanceof ArrayBuffer?function(e){return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}:function(e){for(var a=new ArrayBuffer(e.length),t=new Uint8Array(a),r=0;r<e.length;++r)t[r]=e[r];return a};void 0!==e&&e.exports&&(a=e.exports=r),a.bufferToArrayBuffer=r}()},function(e,a){e.exports=function(e,a){var t=[];e.on("data",function(e){t.push(e)}),e.once("end",function(){a&&a(null,Buffer.concat(t)),a=null}),e.once("error",function(e){a&&a(e),a=null})}},function(e,a,t){e.exports=s;var r=t(452),c=t(43),n=t(59),i=t(156),f=t(282),o=t(280),d=t(32);function s(e,a){if(e="string"==typeof e?{url:e}:Object.assign({},e),a=i(a),e.headers=Object.assign({},e.headers),Object.keys(e.headers).forEach(function(a){a.toLowerCase()!==a&&(e.headers[a.toLowerCase()]=e.headers[a],delete e.headers[a])}),e.url){var t=d.parse(e.url);t.hostname&&(e.hostname=t.hostname),t.port&&(e.port=t.port),t.protocol&&(e.protocol=t.protocol),t.auth&&(e.auth=t.auth),e.path=t.path,delete e.url}var r;null==e.maxRedirects&&(e.maxRedirects=10),e.method&&(e.method=e.method.toUpperCase()),e.body?r=e.json&&!b(e.body)?JSON.stringify(e.body):e.body:e.form&&(r="string"==typeof e.form?e.form:f.stringify(e.form),e.headers["content-type"]="application/x-www-form-urlencoded"),delete e.body,delete e.form,r&&(e.method||(e.method="POST"),b(r)||(e.headers["content-length"]=Buffer.byteLength(r)),e.json&&(e.headers["content-type"]="application/json")),e.json&&(e.headers.accept="application/json"),e.headers["accept-encoding"]||(e.headers["accept-encoding"]="gzip, deflate");var u=("https:"===e.protocol?n:c).request(e,function(t){if(t.statusCode>=300&&t.statusCode<400&&"location"in t.headers)return e.url=t.headers.location,delete e.headers.host,t.resume(),301!==t.statusCode&&302!==t.statusCode||"POST"!==e.method||(e.method="GET",delete e.headers["content-length"],delete e.headers["content-type"]),0===e.maxRedirects?a(new Error("too many redirects")):(e.maxRedirects-=1,s(e,a));var r="function"==typeof o&&"HEAD"!==e.method;a(null,r?o(t):t)});return u.on("timeout",function(){u.abort(),a(new Error("Request timed out"))}),u.on("error",a),r&&b(r)?r.on("error",a).pipe(u):u.end(r),u}function b(e){return"function"==typeof e.pipe}s.concat=function(e,a){return s(e,function(t,c){if(t)return a(t);r(c,function(t,r){if(t)return a(t);if(e.json)try{r=JSON.parse(r.toString())}catch(t){return a(t,c,r)}a(null,c,r)})})},["get","post","put","patch","head","delete"].forEach(function(e){s[e]=function(a,t){return"string"==typeof a&&(a={url:a}),a.method=e.toUpperCase(),s(a,t)}})},function(e,a,t){var r=t(453),c=t(451),n=t(450),i=t(281),f=t(206),o=["text","arraybuffer","json"];e.exports=function(e,a){var t=e.responseType;if(t&&-1===o.indexOf(t))throw new TypeError("invalid responseType for node: "+t);f(e.headers,"User-Agent","https://github.com/Jam3/xhr-request");var d=r.concat(e,function(r,i,f){if(!r)if("arraybuffer"===t)f=c(f);else if("json"===t)try{f=JSON.parse(f.toString())}catch(e){r=e}else f=f.toString();i=n(e,i),r?a(r,null,i):a(null,f,i)});"number"==typeof e.timeout&&0!==e.timeout&&i(d,e.timeout);return d}},function(e,a){e.exports=function(e,a){if(a){a=(a=a.trim().replace(/^(\?|#|&)/,""))?"?"+a:a;var t=e.split(/[\?\#]/),r=t[0];a&&/\:\/\/[^\/]*$/.test(r)&&(r+="/");var c=e.match(/(\#.*)$/);e=r+a,c&&(e+=c[0])}return e}},function(e,a,t){"use strict";var r=new RegExp("%[a-f0-9]{2}","gi"),c=new RegExp("(%[a-f0-9]{2})+","gi");function n(e,a){try{return decodeURIComponent(e.join(""))}catch(e){}if(1===e.length)return e;a=a||1;var t=e.slice(0,a),r=e.slice(a);return Array.prototype.concat.call([],n(t),n(r))}function i(e){try{return decodeURIComponent(e)}catch(c){for(var a=e.match(r),t=1;t<a.length;t++)a=(e=n(a,t).join("")).match(r);return e}}e.exports=function(e){if("string"!=typeof e)throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof e+"`");try{return e=e.replace(/\+/g," "),decodeURIComponent(e)}catch(a){return function(e){for(var a={"%FE%FF":"��","%FF%FE":"��"},t=c.exec(e);t;){try{a[t[0]]=decodeURIComponent(t[0])}catch(e){var r=i(t[0]);r!==t[0]&&(a[t[0]]=r)}t=c.exec(e)}a["%C2"]="�";for(var n=Object.keys(a),f=0;f<n.length;f++){var o=n[f];e=e.replace(new RegExp(o,"g"),a[o])}return e}(e)}}},function(e,a,t){"use strict";e.exports=function(e){return encodeURIComponent(e).replace(/[!'()*]/g,function(e){return"%"+e.charCodeAt(0).toString(16).toUpperCase()})}},function(e,a,t){"use strict";var r=t(457),c=t(207),n=t(456);function i(e,a){return a.encode?a.strict?r(e):encodeURIComponent(e):e}function f(e){var a=e.indexOf("?");return-1===a?"":e.slice(a+1)}function o(e,a){var t=function(e){var a;switch(e.arrayFormat){case"index":return function(e,t,r){a=/\[(\d*)\]$/.exec(e),e=e.replace(/\[\d*\]$/,""),a?(void 0===r[e]&&(r[e]={}),r[e][a[1]]=t):r[e]=t};case"bracket":return function(e,t,r){a=/(\[\])$/.exec(e),e=e.replace(/\[\]$/,""),a?void 0!==r[e]?r[e]=[].concat(r[e],t):r[e]=[t]:r[e]=t};default:return function(e,a,t){void 0!==t[e]?t[e]=[].concat(t[e],a):t[e]=a}}}(a=c({arrayFormat:"none"},a)),r=Object.create(null);return"string"!=typeof e?r:(e=e.trim().replace(/^[?#&]/,""))?(e.split("&").forEach(function(e){var a=e.replace(/\+/g," ").split("="),c=a.shift(),i=a.length>0?a.join("="):void 0;i=void 0===i?null:n(i),t(n(c),i,r)}),Object.keys(r).sort().reduce(function(e,a){var t=r[a];return Boolean(t)&&"object"==typeof t&&!Array.isArray(t)?e[a]=function e(a){return Array.isArray(a)?a.sort():"object"==typeof a?e(Object.keys(a)).sort(function(e,a){return Number(e)-Number(a)}).map(function(e){return a[e]}):a}(t):e[a]=t,e},Object.create(null))):r}a.extract=f,a.parse=o,a.stringify=function(e,a){!1===(a=c({encode:!0,strict:!0,arrayFormat:"none"},a)).sort&&(a.sort=function(){});var t=function(e){switch(e.arrayFormat){case"index":return function(a,t,r){return null===t?[i(a,e),"[",r,"]"].join(""):[i(a,e),"[",i(r,e),"]=",i(t,e)].join("")};case"bracket":return function(a,t){return null===t?i(a,e):[i(a,e),"[]=",i(t,e)].join("")};default:return function(a,t){return null===t?i(a,e):[i(a,e),"=",i(t,e)].join("")}}}(a);return e?Object.keys(e).sort(a.sort).map(function(r){var c=e[r];if(void 0===c)return"";if(null===c)return i(r,a);if(Array.isArray(c)){var n=[];return c.slice().forEach(function(e){void 0!==e&&n.push(t(r,e,n.length))}),n.join("&")}return i(r,a)+"="+i(c,a)}).filter(function(e){return e.length>0}).join("&"):""},a.parseUrl=function(e,a){return{url:e.split("?")[0]||"",query:o(f(e),a)}}},function(e,a,t){var r=t(458),c=t(455),n=t(207),i=t(206),f=t(454),o="application/json",d=function(){};e.exports=function(e,a,t){if(!e||"string"!=typeof e)throw new TypeError("must specify a URL");"function"==typeof a&&(t=a,a={});if(t&&"function"!=typeof t)throw new TypeError("expected cb to be undefined or a function");t=t||d;var s=(a=a||{}).json?"json":"text",b=(a=n({responseType:s},a)).headers||{},u=(a.method||"GET").toUpperCase(),l=a.query;l&&("string"!=typeof l&&(l=r.stringify(l)),e=c(e,l));"json"===a.responseType&&i(b,"Accept",o);a.json&&"GET"!==u&&"HEAD"!==u&&(i(b,"Content-Type",o),a.body=JSON.stringify(a.body));return a.method=u,a.url=e,a.headers=b,delete a.query,delete a.json,f(a,t)}},function(e,a,t){var r=t(459);e.exports=function(e,a){return new Promise(function(t,c){r(e,a,function(e,a){e?c(e):t(a)})})}},function(e){e.exports={"windows-amd64":{archive:"swarm-windows-amd64-1.6.7.exe",binaryMD5:"c2d827dc4553d9b91a7d6c1d5a6140fd",archiveMD5:"059196d21548060a18a12e17cc0ee59a"},"linux-amd64":{archive:"swarm-linux-amd64-1.6.7",binaryMD5:"85002d79b8ebc2d2f2f10fb198636a81",archiveMD5:"3e8874299ab8c0e3043d70ebb6673879"},"linux-386":{archive:"swarm-linux-386-1.6.7",binaryMD5:"35bc2ab976f60f96a2cede117e0df19d",archiveMD5:"7868a86c9cbdf8ac7ac2e5682b4ce40f"},"darwin-amd64":{archive:"swarm-darwin-amd64-1.6.7",binaryMD5:"c499b186645229260dd6ab685dd58f07",archiveMD5:"0794d111e5018eac3b657bcb29851121"},"linux-arm5":{archive:"swarm-linux-arm5-1.6.7",binaryMD5:"516fcd85246c905529442cd9b689c12f",archiveMD5:"47312708d417cb196b07ba0af1d3abb4"},"linux-arm6":{archive:"swarm-linux-arm6-1.6.7",binaryMD5:"82ff7bdbe388b4a190f4101c5150d3b4",archiveMD5:"350276de7bb175a15c314cfc4cb7f8fd"},"linux-mips":{archive:"swarm-linux-mips-1.6.7",binaryMD5:"e1e95280441c0ca35633927792ef5317",archiveMD5:"8fb4b64e94cd73aa718db787b9d4c53e"},"linux-arm7":{archive:"swarm-linux-arm7-1.6.7",binaryMD5:"bfc0b4d1c86d8a975af052fc7854bdd3",archiveMD5:"4378641d8e1e1fbb947f941c8fca8613"},"linux-arm64":{archive:"swarm-linux-arm64-1.6.7",binaryMD5:"bbac21a6c6fa8208f67ca4123d3f948a",archiveMD5:"4e503160327c5fbcca0414f17c54e5ee"},"linux-mipsle":{archive:"swarm-linux-mipsle-1.6.7",binaryMD5:"a82f191b2f9d2c470d0273219c820657",archiveMD5:"3016bdb6d237ae654c0cdf36fe85dc7c"},"windows-386":{archive:"swarm-windows-386-1.6.7.exe",binaryMD5:"ce0b34640642e58068ae5a359faef102",archiveMD5:"640aede4da08a3a9d8a6ac0434ba7c0f"},"linux-mips64":{archive:"swarm-linux-mips64-1.6.7",binaryMD5:"9da967664f384817adb5083fd1ffe8f1",archiveMD5:"357a33be470f8f89ba2619957a08deff"},"linux-mips64le":{archive:"swarm-linux-mips64le-1.6.7",binaryMD5:"ec1abcf7b216e87645ec83954d8344cd",archiveMD5:"a81fd0158190d99813c738ffa4f87627"}}},function(e){e.exports={"application/1d-interleaved-parityfec":{source:"iana"},"application/3gpdash-qoe-report+xml":{source:"iana"},"application/3gpp-ims+xml":{source:"iana"},"application/a2l":{source:"iana"},"application/activemessage":{source:"iana"},"application/alto-costmap+json":{source:"iana",compressible:!0},"application/alto-costmapfilter+json":{source:"iana",compressible:!0},"application/alto-directory+json":{source:"iana",compressible:!0},"application/alto-endpointcost+json":{source:"iana",compressible:!0},"application/alto-endpointcostparams+json":{source:"iana",compressible:!0},"application/alto-endpointprop+json":{source:"iana",compressible:!0},"application/alto-endpointpropparams+json":{source:"iana",compressible:!0},"application/alto-error+json":{source:"iana",compressible:!0},"application/alto-networkmap+json":{source:"iana",compressible:!0},"application/alto-networkmapfilter+json":{source:"iana",compressible:!0},"application/aml":{source:"iana"},"application/andrew-inset":{source:"iana",extensions:["ez"]},"application/applefile":{source:"iana"},"application/applixware":{source:"apache",extensions:["aw"]},"application/atf":{source:"iana"},"application/atfx":{source:"iana"},"application/atom+xml":{source:"iana",compressible:!0,extensions:["atom"]},"application/atomcat+xml":{source:"iana",extensions:["atomcat"]},"application/atomdeleted+xml":{source:"iana"},"application/atomicmail":{source:"iana"},"application/atomsvc+xml":{source:"iana",extensions:["atomsvc"]},"application/atxml":{source:"iana"},"application/auth-policy+xml":{source:"iana"},"application/bacnet-xdd+zip":{source:"iana"},"application/batch-smtp":{source:"iana"},"application/bdoc":{compressible:!1,extensions:["bdoc"]},"application/beep+xml":{source:"iana"},"application/calendar+json":{source:"iana",compressible:!0},"application/calendar+xml":{source:"iana"},"application/call-completion":{source:"iana"},"application/cals-1840":{source:"iana"},"application/cbor":{source:"iana"},"application/cccex":{source:"iana"},"application/ccmp+xml":{source:"iana"},"application/ccxml+xml":{source:"iana",extensions:["ccxml"]},"application/cdfx+xml":{source:"iana"},"application/cdmi-capability":{source:"iana",extensions:["cdmia"]},"application/cdmi-container":{source:"iana",extensions:["cdmic"]},"application/cdmi-domain":{source:"iana",extensions:["cdmid"]},"application/cdmi-object":{source:"iana",extensions:["cdmio"]},"application/cdmi-queue":{source:"iana",extensions:["cdmiq"]},"application/cdni":{source:"iana"},"application/cea":{source:"iana"},"application/cea-2018+xml":{source:"iana"},"application/cellml+xml":{source:"iana"},"application/cfw":{source:"iana"},"application/clue_info+xml":{source:"iana"},"application/cms":{source:"iana"},"application/cnrp+xml":{source:"iana"},"application/coap-group+json":{source:"iana",compressible:!0},"application/coap-payload":{source:"iana"},"application/commonground":{source:"iana"},"application/conference-info+xml":{source:"iana"},"application/cose":{source:"iana"},"application/cose-key":{source:"iana"},"application/cose-key-set":{source:"iana"},"application/cpl+xml":{source:"iana"},"application/csrattrs":{source:"iana"},"application/csta+xml":{source:"iana"},"application/cstadata+xml":{source:"iana"},"application/csvm+json":{source:"iana",compressible:!0},"application/cu-seeme":{source:"apache",extensions:["cu"]},"application/cybercash":{source:"iana"},"application/dart":{compressible:!0},"application/dash+xml":{source:"iana",extensions:["mpd"]},"application/dashdelta":{source:"iana"},"application/davmount+xml":{source:"iana",extensions:["davmount"]},"application/dca-rft":{source:"iana"},"application/dcd":{source:"iana"},"application/dec-dx":{source:"iana"},"application/dialog-info+xml":{source:"iana"},"application/dicom":{source:"iana"},"application/dicom+json":{source:"iana",compressible:!0},"application/dicom+xml":{source:"iana"},"application/dii":{source:"iana"},"application/dit":{source:"iana"},"application/dns":{source:"iana"},"application/docbook+xml":{source:"apache",extensions:["dbk"]},"application/dskpp+xml":{source:"iana"},"application/dssc+der":{source:"iana",extensions:["dssc"]},"application/dssc+xml":{source:"iana",extensions:["xdssc"]},"application/dvcs":{source:"iana"},"application/ecmascript":{source:"iana",compressible:!0,extensions:["ecma"]},"application/edi-consent":{source:"iana"},"application/edi-x12":{source:"iana",compressible:!1},"application/edifact":{source:"iana",compressible:!1},"application/efi":{source:"iana"},"application/emergencycalldata.comment+xml":{source:"iana"},"application/emergencycalldata.control+xml":{source:"iana"},"application/emergencycalldata.deviceinfo+xml":{source:"iana"},"application/emergencycalldata.ecall.msd":{source:"iana"},"application/emergencycalldata.providerinfo+xml":{source:"iana"},"application/emergencycalldata.serviceinfo+xml":{source:"iana"},"application/emergencycalldata.subscriberinfo+xml":{source:"iana"},"application/emergencycalldata.veds+xml":{source:"iana"},"application/emma+xml":{source:"iana",extensions:["emma"]},"application/emotionml+xml":{source:"iana"},"application/encaprtp":{source:"iana"},"application/epp+xml":{source:"iana"},"application/epub+zip":{source:"iana",extensions:["epub"]},"application/eshop":{source:"iana"},"application/exi":{source:"iana",extensions:["exi"]},"application/fastinfoset":{source:"iana"},"application/fastsoap":{source:"iana"},"application/fdt+xml":{source:"iana"},"application/fhir+xml":{source:"iana"},"application/fido.trusted-apps+json":{compressible:!0},"application/fits":{source:"iana"},"application/font-sfnt":{source:"iana"},"application/font-tdpfr":{source:"iana",extensions:["pfr"]},"application/font-woff":{source:"iana",compressible:!1,extensions:["woff"]},"application/framework-attributes+xml":{source:"iana"},"application/geo+json":{source:"iana",compressible:!0,extensions:["geojson"]},"application/geo+json-seq":{source:"iana"},"application/geoxacml+xml":{source:"iana"},"application/gml+xml":{source:"iana",extensions:["gml"]},"application/gpx+xml":{source:"apache",extensions:["gpx"]},"application/gxf":{source:"apache",extensions:["gxf"]},"application/gzip":{source:"iana",compressible:!1,extensions:["gz"]},"application/h224":{source:"iana"},"application/held+xml":{source:"iana"},"application/hjson":{extensions:["hjson"]},"application/http":{source:"iana"},"application/hyperstudio":{source:"iana",extensions:["stk"]},"application/ibe-key-request+xml":{source:"iana"},"application/ibe-pkg-reply+xml":{source:"iana"},"application/ibe-pp-data":{source:"iana"},"application/iges":{source:"iana"},"application/im-iscomposing+xml":{source:"iana"},"application/index":{source:"iana"},"application/index.cmd":{source:"iana"},"application/index.obj":{source:"iana"},"application/index.response":{source:"iana"},"application/index.vnd":{source:"iana"},"application/inkml+xml":{source:"iana",extensions:["ink","inkml"]},"application/iotp":{source:"iana"},"application/ipfix":{source:"iana",extensions:["ipfix"]},"application/ipp":{source:"iana"},"application/isup":{source:"iana"},"application/its+xml":{source:"iana"},"application/java-archive":{source:"apache",compressible:!1,extensions:["jar","war","ear"]},"application/java-serialized-object":{source:"apache",compressible:!1,extensions:["ser"]},"application/java-vm":{source:"apache",compressible:!1,extensions:["class"]},"application/javascript":{source:"iana",charset:"UTF-8",compressible:!0,extensions:["js","mjs"]},"application/jf2feed+json":{source:"iana",compressible:!0},"application/jose":{source:"iana"},"application/jose+json":{source:"iana",compressible:!0},"application/jrd+json":{source:"iana",compressible:!0},"application/json":{source:"iana",charset:"UTF-8",compressible:!0,extensions:["json","map"]},"application/json-patch+json":{source:"iana",compressible:!0},"application/json-seq":{source:"iana"},"application/json5":{extensions:["json5"]},"application/jsonml+json":{source:"apache",compressible:!0,extensions:["jsonml"]},"application/jwk+json":{source:"iana",compressible:!0},"application/jwk-set+json":{source:"iana",compressible:!0},"application/jwt":{source:"iana"},"application/kpml-request+xml":{source:"iana"},"application/kpml-response+xml":{source:"iana"},"application/ld+json":{source:"iana",compressible:!0,extensions:["jsonld"]},"application/lgr+xml":{source:"iana"},"application/link-format":{source:"iana"},"application/load-control+xml":{source:"iana"},"application/lost+xml":{source:"iana",extensions:["lostxml"]},"application/lostsync+xml":{source:"iana"},"application/lxf":{source:"iana"},"application/mac-binhex40":{source:"iana",extensions:["hqx"]},"application/mac-compactpro":{source:"apache",extensions:["cpt"]},"application/macwriteii":{source:"iana"},"application/mads+xml":{source:"iana",extensions:["mads"]},"application/manifest+json":{charset:"UTF-8",compressible:!0,extensions:["webmanifest"]},"application/marc":{source:"iana",extensions:["mrc"]},"application/marcxml+xml":{source:"iana",extensions:["mrcx"]},"application/mathematica":{source:"iana",extensions:["ma","nb","mb"]},"application/mathml+xml":{source:"iana",extensions:["mathml"]},"application/mathml-content+xml":{source:"iana"},"application/mathml-presentation+xml":{source:"iana"},"application/mbms-associated-procedure-description+xml":{source:"iana"},"application/mbms-deregister+xml":{source:"iana"},"application/mbms-envelope+xml":{source:"iana"},"application/mbms-msk+xml":{source:"iana"},"application/mbms-msk-response+xml":{source:"iana"},"application/mbms-protection-description+xml":{source:"iana"},"application/mbms-reception-report+xml":{source:"iana"},"application/mbms-register+xml":{source:"iana"},"application/mbms-register-response+xml":{source:"iana"},"application/mbms-schedule+xml":{source:"iana"},"application/mbms-user-service-description+xml":{source:"iana"},"application/mbox":{source:"iana",extensions:["mbox"]},"application/media-policy-dataset+xml":{source:"iana"},"application/media_control+xml":{source:"iana"},"application/mediaservercontrol+xml":{source:"iana",extensions:["mscml"]},"application/merge-patch+json":{source:"iana",compressible:!0},"application/metalink+xml":{source:"apache",extensions:["metalink"]},"application/metalink4+xml":{source:"iana",extensions:["meta4"]},"application/mets+xml":{source:"iana",extensions:["mets"]},"application/mf4":{source:"iana"},"application/mikey":{source:"iana"},"application/mmt-usd+xml":{source:"iana"},"application/mods+xml":{source:"iana",extensions:["mods"]},"application/moss-keys":{source:"iana"},"application/moss-signature":{source:"iana"},"application/mosskey-data":{source:"iana"},"application/mosskey-request":{source:"iana"},"application/mp21":{source:"iana",extensions:["m21","mp21"]},"application/mp4":{source:"iana",extensions:["mp4s","m4p"]},"application/mpeg4-generic":{source:"iana"},"application/mpeg4-iod":{source:"iana"},"application/mpeg4-iod-xmt":{source:"iana"},"application/mrb-consumer+xml":{source:"iana"},"application/mrb-publish+xml":{source:"iana"},"application/msc-ivr+xml":{source:"iana"},"application/msc-mixer+xml":{source:"iana"},"application/msword":{source:"iana",compressible:!1,extensions:["doc","dot"]},"application/mud+json":{source:"iana",compressible:!0},"application/mxf":{source:"iana",extensions:["mxf"]},"application/n-quads":{source:"iana"},"application/n-triples":{source:"iana"},"application/nasdata":{source:"iana"},"application/news-checkgroups":{source:"iana"},"application/news-groupinfo":{source:"iana"},"application/news-transmission":{source:"iana"},"application/nlsml+xml":{source:"iana"},"application/node":{source:"iana"},"application/nss":{source:"iana"},"application/ocsp-request":{source:"iana"},"application/ocsp-response":{source:"iana"},"application/octet-stream":{source:"iana",compressible:!1,extensions:["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"]},"application/oda":{source:"iana",extensions:["oda"]},"application/odx":{source:"iana"},"application/oebps-package+xml":{source:"iana",extensions:["opf"]},"application/ogg":{source:"iana",compressible:!1,extensions:["ogx"]},"application/omdoc+xml":{source:"apache",extensions:["omdoc"]},"application/onenote":{source:"apache",extensions:["onetoc","onetoc2","onetmp","onepkg"]},"application/oxps":{source:"iana",extensions:["oxps"]},"application/p2p-overlay+xml":{source:"iana"},"application/parityfec":{source:"iana"},"application/passport":{source:"iana"},"application/patch-ops-error+xml":{source:"iana",extensions:["xer"]},"application/pdf":{source:"iana",compressible:!1,extensions:["pdf"]},"application/pdx":{source:"iana"},"application/pgp-encrypted":{source:"iana",compressible:!1,extensions:["pgp"]},"application/pgp-keys":{source:"iana"},"application/pgp-signature":{source:"iana",extensions:["asc","sig"]},"application/pics-rules":{source:"apache",extensions:["prf"]},"application/pidf+xml":{source:"iana"},"application/pidf-diff+xml":{source:"iana"},"application/pkcs10":{source:"iana",extensions:["p10"]},"application/pkcs12":{source:"iana"},"application/pkcs7-mime":{source:"iana",extensions:["p7m","p7c"]},"application/pkcs7-signature":{source:"iana",extensions:["p7s"]},"application/pkcs8":{source:"iana",extensions:["p8"]},"application/pkcs8-encrypted":{source:"iana"},"application/pkix-attr-cert":{source:"iana",extensions:["ac"]},"application/pkix-cert":{source:"iana",extensions:["cer"]},"application/pkix-crl":{source:"iana",extensions:["crl"]},"application/pkix-pkipath":{source:"iana",extensions:["pkipath"]},"application/pkixcmp":{source:"iana",extensions:["pki"]},"application/pls+xml":{source:"iana",extensions:["pls"]},"application/poc-settings+xml":{source:"iana"},"application/postscript":{source:"iana",compressible:!0,extensions:["ai","eps","ps"]},"application/ppsp-tracker+json":{source:"iana",compressible:!0},"application/problem+json":{source:"iana",compressible:!0},"application/problem+xml":{source:"iana"},"application/provenance+xml":{source:"iana"},"application/prs.alvestrand.titrax-sheet":{source:"iana"},"application/prs.cww":{source:"iana",extensions:["cww"]},"application/prs.hpub+zip":{source:"iana"},"application/prs.nprend":{source:"iana"},"application/prs.plucker":{source:"iana"},"application/prs.rdf-xml-crypt":{source:"iana"},"application/prs.xsf+xml":{source:"iana"},"application/pskc+xml":{source:"iana",extensions:["pskcxml"]},"application/qsig":{source:"iana"},"application/raml+yaml":{compressible:!0,extensions:["raml"]},"application/raptorfec":{source:"iana"},"application/rdap+json":{source:"iana",compressible:!0},"application/rdf+xml":{source:"iana",compressible:!0,extensions:["rdf"]},"application/reginfo+xml":{source:"iana",extensions:["rif"]},"application/relax-ng-compact-syntax":{source:"iana",extensions:["rnc"]},"application/remote-printing":{source:"iana"},"application/reputon+json":{source:"iana",compressible:!0},"application/resource-lists+xml":{source:"iana",extensions:["rl"]},"application/resource-lists-diff+xml":{source:"iana",extensions:["rld"]},"application/rfc+xml":{source:"iana"},"application/riscos":{source:"iana"},"application/rlmi+xml":{source:"iana"},"application/rls-services+xml":{source:"iana",extensions:["rs"]},"application/route-apd+xml":{source:"iana"},"application/route-s-tsid+xml":{source:"iana"},"application/route-usd+xml":{source:"iana"},"application/rpki-ghostbusters":{source:"iana",extensions:["gbr"]},"application/rpki-manifest":{source:"iana",extensions:["mft"]},"application/rpki-publication":{source:"iana"},"application/rpki-roa":{source:"iana",extensions:["roa"]},"application/rpki-updown":{source:"iana"},"application/rsd+xml":{source:"apache",extensions:["rsd"]},"application/rss+xml":{source:"apache",compressible:!0,extensions:["rss"]},"application/rtf":{source:"iana",compressible:!0,extensions:["rtf"]},"application/rtploopback":{source:"iana"},"application/rtx":{source:"iana"},"application/samlassertion+xml":{source:"iana"},"application/samlmetadata+xml":{source:"iana"},"application/sbml+xml":{source:"iana",extensions:["sbml"]},"application/scaip+xml":{source:"iana"},"application/scim+json":{source:"iana",compressible:!0},"application/scvp-cv-request":{source:"iana",extensions:["scq"]},"application/scvp-cv-response":{source:"iana",extensions:["scs"]},"application/scvp-vp-request":{source:"iana",extensions:["spq"]},"application/scvp-vp-response":{source:"iana",extensions:["spp"]},"application/sdp":{source:"iana",extensions:["sdp"]},"application/sep+xml":{source:"iana"},"application/sep-exi":{source:"iana"},"application/session-info":{source:"iana"},"application/set-payment":{source:"iana"},"application/set-payment-initiation":{source:"iana",extensions:["setpay"]},"application/set-registration":{source:"iana"},"application/set-registration-initiation":{source:"iana",extensions:["setreg"]},"application/sgml":{source:"iana"},"application/sgml-open-catalog":{source:"iana"},"application/shf+xml":{source:"iana",extensions:["shf"]},"application/sieve":{source:"iana"},"application/simple-filter+xml":{source:"iana"},"application/simple-message-summary":{source:"iana"},"application/simplesymbolcontainer":{source:"iana"},"application/slate":{source:"iana"},"application/smil":{source:"iana"},"application/smil+xml":{source:"iana",extensions:["smi","smil"]},"application/smpte336m":{source:"iana"},"application/soap+fastinfoset":{source:"iana"},"application/soap+xml":{source:"iana",compressible:!0},"application/sparql-query":{source:"iana",extensions:["rq"]},"application/sparql-results+xml":{source:"iana",extensions:["srx"]},"application/spirits-event+xml":{source:"iana"},"application/sql":{source:"iana"},"application/srgs":{source:"iana",extensions:["gram"]},"application/srgs+xml":{source:"iana",extensions:["grxml"]},"application/sru+xml":{source:"iana",extensions:["sru"]},"application/ssdl+xml":{source:"apache",extensions:["ssdl"]},"application/ssml+xml":{source:"iana",extensions:["ssml"]},"application/tamp-apex-update":{source:"iana"},"application/tamp-apex-update-confirm":{source:"iana"},"application/tamp-community-update":{source:"iana"},"application/tamp-community-update-confirm":{source:"iana"},"application/tamp-error":{source:"iana"},"application/tamp-sequence-adjust":{source:"iana"},"application/tamp-sequence-adjust-confirm":{source:"iana"},"application/tamp-status-query":{source:"iana"},"application/tamp-status-response":{source:"iana"},"application/tamp-update":{source:"iana"},"application/tamp-update-confirm":{source:"iana"},"application/tar":{compressible:!0},"application/tei+xml":{source:"iana",extensions:["tei","teicorpus"]},"application/thraud+xml":{source:"iana",extensions:["tfi"]},"application/timestamp-query":{source:"iana"},"application/timestamp-reply":{source:"iana"},"application/timestamped-data":{source:"iana",extensions:["tsd"]},"application/tnauthlist":{source:"iana"},"application/trig":{source:"iana"},"application/ttml+xml":{source:"iana"},"application/tve-trigger":{source:"iana"},"application/ulpfec":{source:"iana"},"application/urc-grpsheet+xml":{source:"iana"},"application/urc-ressheet+xml":{source:"iana"},"application/urc-targetdesc+xml":{source:"iana"},"application/urc-uisocketdesc+xml":{source:"iana"},"application/vcard+json":{source:"iana",compressible:!0},"application/vcard+xml":{source:"iana"},"application/vemmi":{source:"iana"},"application/vividence.scriptfile":{source:"apache"},"application/vnd.1000minds.decision-model+xml":{source:"iana"},"application/vnd.3gpp-prose+xml":{source:"iana"},"application/vnd.3gpp-prose-pc3ch+xml":{source:"iana"},"application/vnd.3gpp-v2x-local-service-information":{source:"iana"},"application/vnd.3gpp.access-transfer-events+xml":{source:"iana"},"application/vnd.3gpp.bsf+xml":{source:"iana"},"application/vnd.3gpp.gmop+xml":{source:"iana"},"application/vnd.3gpp.mcptt-affiliation-command+xml":{source:"iana"},"application/vnd.3gpp.mcptt-floor-request+xml":{source:"iana"},"application/vnd.3gpp.mcptt-info+xml":{source:"iana"},"application/vnd.3gpp.mcptt-location-info+xml":{source:"iana"},"application/vnd.3gpp.mcptt-mbms-usage-info+xml":{source:"iana"},"application/vnd.3gpp.mcptt-signed+xml":{source:"iana"},"application/vnd.3gpp.mid-call+xml":{source:"iana"},"application/vnd.3gpp.pic-bw-large":{source:"iana",extensions:["plb"]},"application/vnd.3gpp.pic-bw-small":{source:"iana",extensions:["psb"]},"application/vnd.3gpp.pic-bw-var":{source:"iana",extensions:["pvb"]},"application/vnd.3gpp.sms":{source:"iana"},"application/vnd.3gpp.sms+xml":{source:"iana"},"application/vnd.3gpp.srvcc-ext+xml":{source:"iana"},"application/vnd.3gpp.srvcc-info+xml":{source:"iana"},"application/vnd.3gpp.state-and-event-info+xml":{source:"iana"},"application/vnd.3gpp.ussd+xml":{source:"iana"},"application/vnd.3gpp2.bcmcsinfo+xml":{source:"iana"},"application/vnd.3gpp2.sms":{source:"iana"},"application/vnd.3gpp2.tcap":{source:"iana",extensions:["tcap"]},"application/vnd.3lightssoftware.imagescal":{source:"iana"},"application/vnd.3m.post-it-notes":{source:"iana",extensions:["pwn"]},"application/vnd.accpac.simply.aso":{source:"iana",extensions:["aso"]},"application/vnd.accpac.simply.imp":{source:"iana",extensions:["imp"]},"application/vnd.acucobol":{source:"iana",extensions:["acu"]},"application/vnd.acucorp":{source:"iana",extensions:["atc","acutc"]},"application/vnd.adobe.air-application-installer-package+zip":{source:"apache",extensions:["air"]},"application/vnd.adobe.flash.movie":{source:"iana"},"application/vnd.adobe.formscentral.fcdt":{source:"iana",extensions:["fcdt"]},"application/vnd.adobe.fxp":{source:"iana",extensions:["fxp","fxpl"]},"application/vnd.adobe.partial-upload":{source:"iana"},"application/vnd.adobe.xdp+xml":{source:"iana",extensions:["xdp"]},"application/vnd.adobe.xfdf":{source:"iana",extensions:["xfdf"]},"application/vnd.aether.imp":{source:"iana"},"application/vnd.ah-barcode":{source:"iana"},"application/vnd.ahead.space":{source:"iana",extensions:["ahead"]},"application/vnd.airzip.filesecure.azf":{source:"iana",extensions:["azf"]},"application/vnd.airzip.filesecure.azs":{source:"iana",extensions:["azs"]},"application/vnd.amadeus+json":{source:"iana",compressible:!0},"application/vnd.amazon.ebook":{source:"apache",extensions:["azw"]},"application/vnd.amazon.mobi8-ebook":{source:"iana"},"application/vnd.americandynamics.acc":{source:"iana",extensions:["acc"]},"application/vnd.amiga.ami":{source:"iana",extensions:["ami"]},"application/vnd.amundsen.maze+xml":{source:"iana"},"application/vnd.android.package-archive":{source:"apache",compressible:!1,extensions:["apk"]},"application/vnd.anki":{source:"iana"},"application/vnd.anser-web-certificate-issue-initiation":{source:"iana",extensions:["cii"]},"application/vnd.anser-web-funds-transfer-initiation":{source:"apache",extensions:["fti"]},"application/vnd.antix.game-component":{source:"iana",extensions:["atx"]},"application/vnd.apache.thrift.binary":{source:"iana"},"application/vnd.apache.thrift.compact":{source:"iana"},"application/vnd.apache.thrift.json":{source:"iana"},"application/vnd.api+json":{source:"iana",compressible:!0},"application/vnd.apothekende.reservation+json":{source:"iana",compressible:!0},"application/vnd.apple.installer+xml":{source:"iana",extensions:["mpkg"]},"application/vnd.apple.mpegurl":{source:"iana",extensions:["m3u8"]},"application/vnd.apple.pkpass":{compressible:!1,extensions:["pkpass"]},"application/vnd.arastra.swi":{source:"iana"},"application/vnd.aristanetworks.swi":{source:"iana",extensions:["swi"]},"application/vnd.artsquare":{source:"iana"},"application/vnd.astraea-software.iota":{source:"iana",extensions:["iota"]},"application/vnd.audiograph":{source:"iana",extensions:["aep"]},"application/vnd.autopackage":{source:"iana"},"application/vnd.avalon+json":{source:"iana",compressible:!0},"application/vnd.avistar+xml":{source:"iana"},"application/vnd.balsamiq.bmml+xml":{source:"iana"},"application/vnd.balsamiq.bmpr":{source:"iana"},"application/vnd.bbf.usp.msg":{source:"iana"},"application/vnd.bbf.usp.msg+json":{source:"iana",compressible:!0},"application/vnd.bekitzur-stech+json":{source:"iana",compressible:!0},"application/vnd.bint.med-content":{source:"iana"},"application/vnd.biopax.rdf+xml":{source:"iana"},"application/vnd.blink-idb-value-wrapper":{source:"iana"},"application/vnd.blueice.multipass":{source:"iana",extensions:["mpm"]},"application/vnd.bluetooth.ep.oob":{source:"iana"},"application/vnd.bluetooth.le.oob":{source:"iana"},"application/vnd.bmi":{source:"iana",extensions:["bmi"]},"application/vnd.businessobjects":{source:"iana",extensions:["rep"]},"application/vnd.cab-jscript":{source:"iana"},"application/vnd.canon-cpdl":{source:"iana"},"application/vnd.canon-lips":{source:"iana"},"application/vnd.capasystems-pg+json":{source:"iana",compressible:!0},"application/vnd.cendio.thinlinc.clientconf":{source:"iana"},"application/vnd.century-systems.tcp_stream":{source:"iana"},"application/vnd.chemdraw+xml":{source:"iana",extensions:["cdxml"]},"application/vnd.chess-pgn":{source:"iana"},"application/vnd.chipnuts.karaoke-mmd":{source:"iana",extensions:["mmd"]},"application/vnd.cinderella":{source:"iana",extensions:["cdy"]},"application/vnd.cirpack.isdn-ext":{source:"iana"},"application/vnd.citationstyles.style+xml":{source:"iana"},"application/vnd.claymore":{source:"iana",extensions:["cla"]},"application/vnd.cloanto.rp9":{source:"iana",extensions:["rp9"]},"application/vnd.clonk.c4group":{source:"iana",extensions:["c4g","c4d","c4f","c4p","c4u"]},"application/vnd.cluetrust.cartomobile-config":{source:"iana",extensions:["c11amc"]},"application/vnd.cluetrust.cartomobile-config-pkg":{source:"iana",extensions:["c11amz"]},"application/vnd.coffeescript":{source:"iana"},"application/vnd.collabio.xodocuments.document":{source:"iana"},"application/vnd.collabio.xodocuments.document-template":{source:"iana"},"application/vnd.collabio.xodocuments.presentation":{source:"iana"},"application/vnd.collabio.xodocuments.presentation-template":{source:"iana"},"application/vnd.collabio.xodocuments.spreadsheet":{source:"iana"},"application/vnd.collabio.xodocuments.spreadsheet-template":{source:"iana"},"application/vnd.collection+json":{source:"iana",compressible:!0},"application/vnd.collection.doc+json":{source:"iana",compressible:!0},"application/vnd.collection.next+json":{source:"iana",compressible:!0},"application/vnd.comicbook+zip":{source:"iana"},"application/vnd.comicbook-rar":{source:"iana"},"application/vnd.commerce-battelle":{source:"iana"},"application/vnd.commonspace":{source:"iana",extensions:["csp"]},"application/vnd.contact.cmsg":{source:"iana",extensions:["cdbcmsg"]},"application/vnd.coreos.ignition+json":{source:"iana",compressible:!0},"application/vnd.cosmocaller":{source:"iana",extensions:["cmc"]},"application/vnd.crick.clicker":{source:"iana",extensions:["clkx"]},"application/vnd.crick.clicker.keyboard":{source:"iana",extensions:["clkk"]},"application/vnd.crick.clicker.palette":{source:"iana",extensions:["clkp"]},"application/vnd.crick.clicker.template":{source:"iana",extensions:["clkt"]},"application/vnd.crick.clicker.wordbank":{source:"iana",extensions:["clkw"]},"application/vnd.criticaltools.wbs+xml":{source:"iana",extensions:["wbs"]},"application/vnd.ctc-posml":{source:"iana",extensions:["pml"]},"application/vnd.ctct.ws+xml":{source:"iana"},"application/vnd.cups-pdf":{source:"iana"},"application/vnd.cups-postscript":{source:"iana"},"application/vnd.cups-ppd":{source:"iana",extensions:["ppd"]},"application/vnd.cups-raster":{source:"iana"},"application/vnd.cups-raw":{source:"iana"},"application/vnd.curl":{source:"iana"},"application/vnd.curl.car":{source:"apache",extensions:["car"]},"application/vnd.curl.pcurl":{source:"apache",extensions:["pcurl"]},"application/vnd.cyan.dean.root+xml":{source:"iana"},"application/vnd.cybank":{source:"iana"},"application/vnd.d2l.coursepackage1p0+zip":{source:"iana"},"application/vnd.dart":{source:"iana",compressible:!0,extensions:["dart"]},"application/vnd.data-vision.rdz":{source:"iana",extensions:["rdz"]},"application/vnd.datapackage+json":{source:"iana",compressible:!0},"application/vnd.dataresource+json":{source:"iana",compressible:!0},"application/vnd.debian.binary-package":{source:"iana"},"application/vnd.dece.data":{source:"iana",extensions:["uvf","uvvf","uvd","uvvd"]},"application/vnd.dece.ttml+xml":{source:"iana",extensions:["uvt","uvvt"]},"application/vnd.dece.unspecified":{source:"iana",extensions:["uvx","uvvx"]},"application/vnd.dece.zip":{source:"iana",extensions:["uvz","uvvz"]},"application/vnd.denovo.fcselayout-link":{source:"iana",extensions:["fe_launch"]},"application/vnd.desmume-movie":{source:"iana"},"application/vnd.desmume.movie":{source:"apache"},"application/vnd.dir-bi.plate-dl-nosuffix":{source:"iana"},"application/vnd.dm.delegation+xml":{source:"iana"},"application/vnd.dna":{source:"iana",extensions:["dna"]},"application/vnd.document+json":{source:"iana",compressible:!0},"application/vnd.dolby.mlp":{source:"apache",extensions:["mlp"]},"application/vnd.dolby.mobile.1":{source:"iana"},"application/vnd.dolby.mobile.2":{source:"iana"},"application/vnd.doremir.scorecloud-binary-document":{source:"iana"},"application/vnd.dpgraph":{source:"iana",extensions:["dpg"]},"application/vnd.dreamfactory":{source:"iana",extensions:["dfac"]},"application/vnd.drive+json":{source:"iana",compressible:!0},"application/vnd.ds-keypoint":{source:"apache",extensions:["kpxx"]},"application/vnd.dtg.local":{source:"iana"},"application/vnd.dtg.local.flash":{source:"iana"},"application/vnd.dtg.local.html":{source:"iana"},"application/vnd.dvb.ait":{source:"iana",extensions:["ait"]},"application/vnd.dvb.dvbj":{source:"iana"},"application/vnd.dvb.esgcontainer":{source:"iana"},"application/vnd.dvb.ipdcdftnotifaccess":{source:"iana"},"application/vnd.dvb.ipdcesgaccess":{source:"iana"},"application/vnd.dvb.ipdcesgaccess2":{source:"iana"},"application/vnd.dvb.ipdcesgpdd":{source:"iana"},"application/vnd.dvb.ipdcroaming":{source:"iana"},"application/vnd.dvb.iptv.alfec-base":{source:"iana"},"application/vnd.dvb.iptv.alfec-enhancement":{source:"iana"},"application/vnd.dvb.notif-aggregate-root+xml":{source:"iana"},"application/vnd.dvb.notif-container+xml":{source:"iana"},"application/vnd.dvb.notif-generic+xml":{source:"iana"},"application/vnd.dvb.notif-ia-msglist+xml":{source:"iana"},"application/vnd.dvb.notif-ia-registration-request+xml":{source:"iana"},"application/vnd.dvb.notif-ia-registration-response+xml":{source:"iana"},"application/vnd.dvb.notif-init+xml":{source:"iana"},"application/vnd.dvb.pfr":{source:"iana"},"application/vnd.dvb.service":{source:"iana",extensions:["svc"]},"application/vnd.dxr":{source:"iana"},"application/vnd.dynageo":{source:"iana",extensions:["geo"]},"application/vnd.dzr":{source:"iana"},"application/vnd.easykaraoke.cdgdownload":{source:"iana"},"application/vnd.ecdis-update":{source:"iana"},"application/vnd.ecip.rlp":{source:"iana"},"application/vnd.ecowin.chart":{source:"iana",extensions:["mag"]},"application/vnd.ecowin.filerequest":{source:"iana"},"application/vnd.ecowin.fileupdate":{source:"iana"},"application/vnd.ecowin.series":{source:"iana"},"application/vnd.ecowin.seriesrequest":{source:"iana"},"application/vnd.ecowin.seriesupdate":{source:"iana"},"application/vnd.efi.img":{source:"iana"},"application/vnd.efi.iso":{source:"iana"},"application/vnd.emclient.accessrequest+xml":{source:"iana"},"application/vnd.enliven":{source:"iana",extensions:["nml"]},"application/vnd.enphase.envoy":{source:"iana"},"application/vnd.eprints.data+xml":{source:"iana"},"application/vnd.epson.esf":{source:"iana",extensions:["esf"]},"application/vnd.epson.msf":{source:"iana",extensions:["msf"]},"application/vnd.epson.quickanime":{source:"iana",extensions:["qam"]},"application/vnd.epson.salt":{source:"iana",extensions:["slt"]},"application/vnd.epson.ssf":{source:"iana",extensions:["ssf"]},"application/vnd.ericsson.quickcall":{source:"iana"},"application/vnd.espass-espass+zip":{source:"iana"},"application/vnd.eszigno3+xml":{source:"iana",extensions:["es3","et3"]},"application/vnd.etsi.aoc+xml":{source:"iana"},"application/vnd.etsi.asic-e+zip":{source:"iana"},"application/vnd.etsi.asic-s+zip":{source:"iana"},"application/vnd.etsi.cug+xml":{source:"iana"},"application/vnd.etsi.iptvcommand+xml":{source:"iana"},"application/vnd.etsi.iptvdiscovery+xml":{source:"iana"},"application/vnd.etsi.iptvprofile+xml":{source:"iana"},"application/vnd.etsi.iptvsad-bc+xml":{source:"iana"},"application/vnd.etsi.iptvsad-cod+xml":{source:"iana"},"application/vnd.etsi.iptvsad-npvr+xml":{source:"iana"},"application/vnd.etsi.iptvservice+xml":{source:"iana"},"application/vnd.etsi.iptvsync+xml":{source:"iana"},"application/vnd.etsi.iptvueprofile+xml":{source:"iana"},"application/vnd.etsi.mcid+xml":{source:"iana"},"application/vnd.etsi.mheg5":{source:"iana"},"application/vnd.etsi.overload-control-policy-dataset+xml":{source:"iana"},"application/vnd.etsi.pstn+xml":{source:"iana"},"application/vnd.etsi.sci+xml":{source:"iana"},"application/vnd.etsi.simservs+xml":{source:"iana"},"application/vnd.etsi.timestamp-token":{source:"iana"},"application/vnd.etsi.tsl+xml":{source:"iana"},"application/vnd.etsi.tsl.der":{source:"iana"},"application/vnd.eudora.data":{source:"iana"},"application/vnd.evolv.ecig.profile":{source:"iana"},"application/vnd.evolv.ecig.settings":{source:"iana"},"application/vnd.evolv.ecig.theme":{source:"iana"},"application/vnd.ezpix-album":{source:"iana",extensions:["ez2"]},"application/vnd.ezpix-package":{source:"iana",extensions:["ez3"]},"application/vnd.f-secure.mobile":{source:"iana"},"application/vnd.fastcopy-disk-image":{source:"iana"},"application/vnd.fdf":{source:"iana",extensions:["fdf"]},"application/vnd.fdsn.mseed":{source:"iana",extensions:["mseed"]},"application/vnd.fdsn.seed":{source:"iana",extensions:["seed","dataless"]},"application/vnd.ffsns":{source:"iana"},"application/vnd.filmit.zfc":{source:"iana"},"application/vnd.fints":{source:"iana"},"application/vnd.firemonkeys.cloudcell":{source:"iana"},"application/vnd.flographit":{source:"iana",extensions:["gph"]},"application/vnd.fluxtime.clip":{source:"iana",extensions:["ftc"]},"application/vnd.font-fontforge-sfd":{source:"iana"},"application/vnd.framemaker":{source:"iana",extensions:["fm","frame","maker","book"]},"application/vnd.frogans.fnc":{source:"iana",extensions:["fnc"]},"application/vnd.frogans.ltf":{source:"iana",extensions:["ltf"]},"application/vnd.fsc.weblaunch":{source:"iana",extensions:["fsc"]},"application/vnd.fujitsu.oasys":{source:"iana",extensions:["oas"]},"application/vnd.fujitsu.oasys2":{source:"iana",extensions:["oa2"]},"application/vnd.fujitsu.oasys3":{source:"iana",extensions:["oa3"]},"application/vnd.fujitsu.oasysgp":{source:"iana",extensions:["fg5"]},"application/vnd.fujitsu.oasysprs":{source:"iana",extensions:["bh2"]},"application/vnd.fujixerox.art-ex":{source:"iana"},"application/vnd.fujixerox.art4":{source:"iana"},"application/vnd.fujixerox.ddd":{source:"iana",extensions:["ddd"]},"application/vnd.fujixerox.docuworks":{source:"iana",extensions:["xdw"]},"application/vnd.fujixerox.docuworks.binder":{source:"iana",extensions:["xbd"]},"application/vnd.fujixerox.docuworks.container":{source:"iana"},"application/vnd.fujixerox.hbpl":{source:"iana"},"application/vnd.fut-misnet":{source:"iana"},"application/vnd.fuzzysheet":{source:"iana",extensions:["fzs"]},"application/vnd.genomatix.tuxedo":{source:"iana",extensions:["txd"]},"application/vnd.geo+json":{source:"iana",compressible:!0},"application/vnd.geocube+xml":{source:"iana"},"application/vnd.geogebra.file":{source:"iana",extensions:["ggb"]},"application/vnd.geogebra.tool":{source:"iana",extensions:["ggt"]},"application/vnd.geometry-explorer":{source:"iana",extensions:["gex","gre"]},"application/vnd.geonext":{source:"iana",extensions:["gxt"]},"application/vnd.geoplan":{source:"iana",extensions:["g2w"]},"application/vnd.geospace":{source:"iana",extensions:["g3w"]},"application/vnd.gerber":{source:"iana"},"application/vnd.globalplatform.card-content-mgt":{source:"iana"},"application/vnd.globalplatform.card-content-mgt-response":{source:"iana"},"application/vnd.gmx":{source:"iana",extensions:["gmx"]},"application/vnd.google-apps.document":{compressible:!1,extensions:["gdoc"]},"application/vnd.google-apps.presentation":{compressible:!1,extensions:["gslides"]},"application/vnd.google-apps.spreadsheet":{compressible:!1,extensions:["gsheet"]},"application/vnd.google-earth.kml+xml":{source:"iana",compressible:!0,extensions:["kml"]},"application/vnd.google-earth.kmz":{source:"iana",compressible:!1,extensions:["kmz"]},"application/vnd.gov.sk.e-form+xml":{source:"iana"},"application/vnd.gov.sk.e-form+zip":{source:"iana"},"application/vnd.gov.sk.xmldatacontainer+xml":{source:"iana"},"application/vnd.grafeq":{source:"iana",extensions:["gqf","gqs"]},"application/vnd.gridmp":{source:"iana"},"application/vnd.groove-account":{source:"iana",extensions:["gac"]},"application/vnd.groove-help":{source:"iana",extensions:["ghf"]},"application/vnd.groove-identity-message":{source:"iana",extensions:["gim"]},"application/vnd.groove-injector":{source:"iana",extensions:["grv"]},"application/vnd.groove-tool-message":{source:"iana",extensions:["gtm"]},"application/vnd.groove-tool-template":{source:"iana",extensions:["tpl"]},"application/vnd.groove-vcard":{source:"iana",extensions:["vcg"]},"application/vnd.hal+json":{source:"iana",compressible:!0},"application/vnd.hal+xml":{source:"iana",extensions:["hal"]},"application/vnd.handheld-entertainment+xml":{source:"iana",extensions:["zmm"]},"application/vnd.hbci":{source:"iana",extensions:["hbci"]},"application/vnd.hc+json":{source:"iana",compressible:!0},"application/vnd.hcl-bireports":{source:"iana"},"application/vnd.hdt":{source:"iana"},"application/vnd.heroku+json":{source:"iana",compressible:!0},"application/vnd.hhe.lesson-player":{source:"iana",extensions:["les"]},"application/vnd.hp-hpgl":{source:"iana",extensions:["hpgl"]},"application/vnd.hp-hpid":{source:"iana",extensions:["hpid"]},"application/vnd.hp-hps":{source:"iana",extensions:["hps"]},"application/vnd.hp-jlyt":{source:"iana",extensions:["jlt"]},"application/vnd.hp-pcl":{source:"iana",extensions:["pcl"]},"application/vnd.hp-pclxl":{source:"iana",extensions:["pclxl"]},"application/vnd.httphone":{source:"iana"},"application/vnd.hydrostatix.sof-data":{source:"iana",extensions:["sfd-hdstx"]},"application/vnd.hyper-item+json":{source:"iana",compressible:!0},"application/vnd.hyperdrive+json":{source:"iana",compressible:!0},"application/vnd.hzn-3d-crossword":{source:"iana"},"application/vnd.ibm.afplinedata":{source:"iana"},"application/vnd.ibm.electronic-media":{source:"iana"},"application/vnd.ibm.minipay":{source:"iana",extensions:["mpy"]},"application/vnd.ibm.modcap":{source:"iana",extensions:["afp","listafp","list3820"]},"application/vnd.ibm.rights-management":{source:"iana",extensions:["irm"]},"application/vnd.ibm.secure-container":{source:"iana",extensions:["sc"]},"application/vnd.iccprofile":{source:"iana",extensions:["icc","icm"]},"application/vnd.ieee.1905":{source:"iana"},"application/vnd.igloader":{source:"iana",extensions:["igl"]},"application/vnd.imagemeter.folder+zip":{source:"iana"},"application/vnd.imagemeter.image+zip":{source:"iana"},"application/vnd.immervision-ivp":{source:"iana",extensions:["ivp"]},"application/vnd.immervision-ivu":{source:"iana",extensions:["ivu"]},"application/vnd.ims.imsccv1p1":{source:"iana"},"application/vnd.ims.imsccv1p2":{source:"iana"},"application/vnd.ims.imsccv1p3":{source:"iana"},"application/vnd.ims.lis.v2.result+json":{source:"iana",compressible:!0},"application/vnd.ims.lti.v2.toolconsumerprofile+json":{source:"iana",compressible:!0},"application/vnd.ims.lti.v2.toolproxy+json":{source:"iana",compressible:!0},"application/vnd.ims.lti.v2.toolproxy.id+json":{source:"iana",compressible:!0},"application/vnd.ims.lti.v2.toolsettings+json":{source:"iana",compressible:!0},"application/vnd.ims.lti.v2.toolsettings.simple+json":{source:"iana",compressible:!0},"application/vnd.informedcontrol.rms+xml":{source:"iana"},"application/vnd.informix-visionary":{source:"iana"},"application/vnd.infotech.project":{source:"iana"},"application/vnd.infotech.project+xml":{source:"iana"},"application/vnd.innopath.wamp.notification":{source:"iana"},"application/vnd.insors.igm":{source:"iana",extensions:["igm"]},"application/vnd.intercon.formnet":{source:"iana",extensions:["xpw","xpx"]},"application/vnd.intergeo":{source:"iana",extensions:["i2g"]},"application/vnd.intertrust.digibox":{source:"iana"},"application/vnd.intertrust.nncp":{source:"iana"},"application/vnd.intu.qbo":{source:"iana",extensions:["qbo"]},"application/vnd.intu.qfx":{source:"iana",extensions:["qfx"]},"application/vnd.iptc.g2.catalogitem+xml":{source:"iana"},"application/vnd.iptc.g2.conceptitem+xml":{source:"iana"},"application/vnd.iptc.g2.knowledgeitem+xml":{source:"iana"},"application/vnd.iptc.g2.newsitem+xml":{source:"iana"},"application/vnd.iptc.g2.newsmessage+xml":{source:"iana"},"application/vnd.iptc.g2.packageitem+xml":{source:"iana"},"application/vnd.iptc.g2.planningitem+xml":{source:"iana"},"application/vnd.ipunplugged.rcprofile":{source:"iana",extensions:["rcprofile"]},"application/vnd.irepository.package+xml":{source:"iana",extensions:["irp"]},"application/vnd.is-xpr":{source:"iana",extensions:["xpr"]},"application/vnd.isac.fcs":{source:"iana",extensions:["fcs"]},"application/vnd.jam":{source:"iana",extensions:["jam"]},"application/vnd.japannet-directory-service":{source:"iana"},"application/vnd.japannet-jpnstore-wakeup":{source:"iana"},"application/vnd.japannet-payment-wakeup":{source:"iana"},"application/vnd.japannet-registration":{source:"iana"},"application/vnd.japannet-registration-wakeup":{source:"iana"},"application/vnd.japannet-setstore-wakeup":{source:"iana"},"application/vnd.japannet-verification":{source:"iana"},"application/vnd.japannet-verification-wakeup":{source:"iana"},"application/vnd.jcp.javame.midlet-rms":{source:"iana",extensions:["rms"]},"application/vnd.jisp":{source:"iana",extensions:["jisp"]},"application/vnd.joost.joda-archive":{source:"iana",extensions:["joda"]},"application/vnd.jsk.isdn-ngn":{source:"iana"},"application/vnd.kahootz":{source:"iana",extensions:["ktz","ktr"]},"application/vnd.kde.karbon":{source:"iana",extensions:["karbon"]},"application/vnd.kde.kchart":{source:"iana",extensions:["chrt"]},"application/vnd.kde.kformula":{source:"iana",extensions:["kfo"]},"application/vnd.kde.kivio":{source:"iana",extensions:["flw"]},"application/vnd.kde.kontour":{source:"iana",extensions:["kon"]},"application/vnd.kde.kpresenter":{source:"iana",extensions:["kpr","kpt"]},"application/vnd.kde.kspread":{source:"iana",extensions:["ksp"]},"application/vnd.kde.kword":{source:"iana",extensions:["kwd","kwt"]},"application/vnd.kenameaapp":{source:"iana",extensions:["htke"]},"application/vnd.kidspiration":{source:"iana",extensions:["kia"]},"application/vnd.kinar":{source:"iana",extensions:["kne","knp"]},"application/vnd.koan":{source:"iana",extensions:["skp","skd","skt","skm"]},"application/vnd.kodak-descriptor":{source:"iana",extensions:["sse"]},"application/vnd.las.las+json":{source:"iana",compressible:!0},"application/vnd.las.las+xml":{source:"iana",extensions:["lasxml"]},"application/vnd.liberty-request+xml":{source:"iana"},"application/vnd.llamagraphics.life-balance.desktop":{source:"iana",extensions:["lbd"]},"application/vnd.llamagraphics.life-balance.exchange+xml":{source:"iana",extensions:["lbe"]},"application/vnd.lotus-1-2-3":{source:"iana",extensions:["123"]},"application/vnd.lotus-approach":{source:"iana",extensions:["apr"]},"application/vnd.lotus-freelance":{source:"iana",extensions:["pre"]},"application/vnd.lotus-notes":{source:"iana",extensions:["nsf"]},"application/vnd.lotus-organizer":{source:"iana",extensions:["org"]},"application/vnd.lotus-screencam":{source:"iana",extensions:["scm"]},"application/vnd.lotus-wordpro":{source:"iana",extensions:["lwp"]},"application/vnd.macports.portpkg":{source:"iana",extensions:["portpkg"]},"application/vnd.mapbox-vector-tile":{source:"iana"},"application/vnd.marlin.drm.actiontoken+xml":{source:"iana"},"application/vnd.marlin.drm.conftoken+xml":{source:"iana"},"application/vnd.marlin.drm.license+xml":{source:"iana"},"application/vnd.marlin.drm.mdcf":{source:"iana"},"application/vnd.mason+json":{source:"iana",compressible:!0},"application/vnd.maxmind.maxmind-db":{source:"iana"},"application/vnd.mcd":{source:"iana",extensions:["mcd"]},"application/vnd.medcalcdata":{source:"iana",extensions:["mc1"]},"application/vnd.mediastation.cdkey":{source:"iana",extensions:["cdkey"]},"application/vnd.meridian-slingshot":{source:"iana"},"application/vnd.mfer":{source:"iana",extensions:["mwf"]},"application/vnd.mfmp":{source:"iana",extensions:["mfm"]},"application/vnd.micro+json":{source:"iana",compressible:!0},"application/vnd.micrografx.flo":{source:"iana",extensions:["flo"]},"application/vnd.micrografx.igx":{source:"iana",extensions:["igx"]},"application/vnd.microsoft.portable-executable":{source:"iana"},"application/vnd.microsoft.windows.thumbnail-cache":{source:"iana"},"application/vnd.miele+json":{source:"iana",compressible:!0},"application/vnd.mif":{source:"iana",extensions:["mif"]},"application/vnd.minisoft-hp3000-save":{source:"iana"},"application/vnd.mitsubishi.misty-guard.trustweb":{source:"iana"},"application/vnd.mobius.daf":{source:"iana",extensions:["daf"]},"application/vnd.mobius.dis":{source:"iana",extensions:["dis"]},"application/vnd.mobius.mbk":{source:"iana",extensions:["mbk"]},"application/vnd.mobius.mqy":{source:"iana",extensions:["mqy"]},"application/vnd.mobius.msl":{source:"iana",extensions:["msl"]},"application/vnd.mobius.plc":{source:"iana",extensions:["plc"]},"application/vnd.mobius.txf":{source:"iana",extensions:["txf"]},"application/vnd.mophun.application":{source:"iana",extensions:["mpn"]},"application/vnd.mophun.certificate":{source:"iana",extensions:["mpc"]},"application/vnd.motorola.flexsuite":{source:"iana"},"application/vnd.motorola.flexsuite.adsi":{source:"iana"},"application/vnd.motorola.flexsuite.fis":{source:"iana"},"application/vnd.motorola.flexsuite.gotap":{source:"iana"},"application/vnd.motorola.flexsuite.kmr":{source:"iana"},"application/vnd.motorola.flexsuite.ttc":{source:"iana"},"application/vnd.motorola.flexsuite.wem":{source:"iana"},"application/vnd.motorola.iprm":{source:"iana"},"application/vnd.mozilla.xul+xml":{source:"iana",compressible:!0,extensions:["xul"]},"application/vnd.ms-3mfdocument":{source:"iana"},"application/vnd.ms-artgalry":{source:"iana",extensions:["cil"]},"application/vnd.ms-asf":{source:"iana"},"application/vnd.ms-cab-compressed":{source:"iana",extensions:["cab"]},"application/vnd.ms-color.iccprofile":{source:"apache"},"application/vnd.ms-excel":{source:"iana",compressible:!1,extensions:["xls","xlm","xla","xlc","xlt","xlw"]},"application/vnd.ms-excel.addin.macroenabled.12":{source:"iana",extensions:["xlam"]},"application/vnd.ms-excel.sheet.binary.macroenabled.12":{source:"iana",extensions:["xlsb"]},"application/vnd.ms-excel.sheet.macroenabled.12":{source:"iana",extensions:["xlsm"]},"application/vnd.ms-excel.template.macroenabled.12":{source:"iana",extensions:["xltm"]},"application/vnd.ms-fontobject":{source:"iana",compressible:!0,extensions:["eot"]},"application/vnd.ms-htmlhelp":{source:"iana",extensions:["chm"]},"application/vnd.ms-ims":{source:"iana",extensions:["ims"]},"application/vnd.ms-lrm":{source:"iana",extensions:["lrm"]},"application/vnd.ms-office.activex+xml":{source:"iana"},"application/vnd.ms-officetheme":{source:"iana",extensions:["thmx"]},"application/vnd.ms-opentype":{source:"apache",compressible:!0},"application/vnd.ms-outlook":{compressible:!1,extensions:["msg"]},"application/vnd.ms-package.obfuscated-opentype":{source:"apache"},"application/vnd.ms-pki.seccat":{source:"apache",extensions:["cat"]},"application/vnd.ms-pki.stl":{source:"apache",extensions:["stl"]},"application/vnd.ms-playready.initiator+xml":{source:"iana"},"application/vnd.ms-powerpoint":{source:"iana",compressible:!1,extensions:["ppt","pps","pot"]},"application/vnd.ms-powerpoint.addin.macroenabled.12":{source:"iana",extensions:["ppam"]},"application/vnd.ms-powerpoint.presentation.macroenabled.12":{source:"iana",extensions:["pptm"]},"application/vnd.ms-powerpoint.slide.macroenabled.12":{source:"iana",extensions:["sldm"]},"application/vnd.ms-powerpoint.slideshow.macroenabled.12":{source:"iana",extensions:["ppsm"]},"application/vnd.ms-powerpoint.template.macroenabled.12":{source:"iana",extensions:["potm"]},"application/vnd.ms-printdevicecapabilities+xml":{source:"iana"},"application/vnd.ms-printing.printticket+xml":{source:"apache"},"application/vnd.ms-printschematicket+xml":{source:"iana"},"application/vnd.ms-project":{source:"iana",extensions:["mpp","mpt"]},"application/vnd.ms-tnef":{source:"iana"},"application/vnd.ms-windows.devicepairing":{source:"iana"},"application/vnd.ms-windows.nwprinting.oob":{source:"iana"},"application/vnd.ms-windows.printerpairing":{source:"iana"},"application/vnd.ms-windows.wsd.oob":{source:"iana"},"application/vnd.ms-wmdrm.lic-chlg-req":{source:"iana"},"application/vnd.ms-wmdrm.lic-resp":{source:"iana"},"application/vnd.ms-wmdrm.meter-chlg-req":{source:"iana"},"application/vnd.ms-wmdrm.meter-resp":{source:"iana"},"application/vnd.ms-word.document.macroenabled.12":{source:"iana",extensions:["docm"]},"application/vnd.ms-word.template.macroenabled.12":{source:"iana",extensions:["dotm"]},"application/vnd.ms-works":{source:"iana",extensions:["wps","wks","wcm","wdb"]},"application/vnd.ms-wpl":{source:"iana",extensions:["wpl"]},"application/vnd.ms-xpsdocument":{source:"iana",compressible:!1,extensions:["xps"]},"application/vnd.msa-disk-image":{source:"iana"},"application/vnd.mseq":{source:"iana",extensions:["mseq"]},"application/vnd.msign":{source:"iana"},"application/vnd.multiad.creator":{source:"iana"},"application/vnd.multiad.creator.cif":{source:"iana"},"application/vnd.music-niff":{source:"iana"},"application/vnd.musician":{source:"iana",extensions:["mus"]},"application/vnd.muvee.style":{source:"iana",extensions:["msty"]},"application/vnd.mynfc":{source:"iana",extensions:["taglet"]},"application/vnd.ncd.control":{source:"iana"},"application/vnd.ncd.reference":{source:"iana"},"application/vnd.nearst.inv+json":{source:"iana",compressible:!0},"application/vnd.nervana":{source:"iana"},"application/vnd.netfpx":{source:"iana"},"application/vnd.neurolanguage.nlu":{source:"iana",extensions:["nlu"]},"application/vnd.nintendo.nitro.rom":{source:"iana"},"application/vnd.nintendo.snes.rom":{source:"iana"},"application/vnd.nitf":{source:"iana",extensions:["ntf","nitf"]},"application/vnd.noblenet-directory":{source:"iana",extensions:["nnd"]},"application/vnd.noblenet-sealer":{source:"iana",extensions:["nns"]},"application/vnd.noblenet-web":{source:"iana",extensions:["nnw"]},"application/vnd.nokia.catalogs":{source:"iana"},"application/vnd.nokia.conml+wbxml":{source:"iana"},"application/vnd.nokia.conml+xml":{source:"iana"},"application/vnd.nokia.iptv.config+xml":{source:"iana"},"application/vnd.nokia.isds-radio-presets":{source:"iana"},"application/vnd.nokia.landmark+wbxml":{source:"iana"},"application/vnd.nokia.landmark+xml":{source:"iana"},"application/vnd.nokia.landmarkcollection+xml":{source:"iana"},"application/vnd.nokia.n-gage.ac+xml":{source:"iana"},"application/vnd.nokia.n-gage.data":{source:"iana",extensions:["ngdat"]},"application/vnd.nokia.n-gage.symbian.install":{source:"iana",extensions:["n-gage"]},"application/vnd.nokia.ncd":{source:"iana"},"application/vnd.nokia.pcd+wbxml":{source:"iana"},"application/vnd.nokia.pcd+xml":{source:"iana"},"application/vnd.nokia.radio-preset":{source:"iana",extensions:["rpst"]},"application/vnd.nokia.radio-presets":{source:"iana",extensions:["rpss"]},"application/vnd.novadigm.edm":{source:"iana",extensions:["edm"]},"application/vnd.novadigm.edx":{source:"iana",extensions:["edx"]},"application/vnd.novadigm.ext":{source:"iana",extensions:["ext"]},"application/vnd.ntt-local.content-share":{source:"iana"},"application/vnd.ntt-local.file-transfer":{source:"iana"},"application/vnd.ntt-local.ogw_remote-access":{source:"iana"},"application/vnd.ntt-local.sip-ta_remote":{source:"iana"},"application/vnd.ntt-local.sip-ta_tcp_stream":{source:"iana"},"application/vnd.oasis.opendocument.chart":{source:"iana",extensions:["odc"]},"application/vnd.oasis.opendocument.chart-template":{source:"iana",extensions:["otc"]},"application/vnd.oasis.opendocument.database":{source:"iana",extensions:["odb"]},"application/vnd.oasis.opendocument.formula":{source:"iana",extensions:["odf"]},"application/vnd.oasis.opendocument.formula-template":{source:"iana",extensions:["odft"]},"application/vnd.oasis.opendocument.graphics":{source:"iana",compressible:!1,extensions:["odg"]},"application/vnd.oasis.opendocument.graphics-template":{source:"iana",extensions:["otg"]},"application/vnd.oasis.opendocument.image":{source:"iana",extensions:["odi"]},"application/vnd.oasis.opendocument.image-template":{source:"iana",extensions:["oti"]},"application/vnd.oasis.opendocument.presentation":{source:"iana",compressible:!1,extensions:["odp"]},"application/vnd.oasis.opendocument.presentation-template":{source:"iana",extensions:["otp"]},"application/vnd.oasis.opendocument.spreadsheet":{source:"iana",compressible:!1,extensions:["ods"]},"application/vnd.oasis.opendocument.spreadsheet-template":{source:"iana",extensions:["ots"]},"application/vnd.oasis.opendocument.text":{source:"iana",compressible:!1,extensions:["odt"]},"application/vnd.oasis.opendocument.text-master":{source:"iana",extensions:["odm"]},"application/vnd.oasis.opendocument.text-template":{source:"iana",extensions:["ott"]},"application/vnd.oasis.opendocument.text-web":{source:"iana",extensions:["oth"]},"application/vnd.obn":{source:"iana"},"application/vnd.ocf+cbor":{source:"iana"},"application/vnd.oftn.l10n+json":{source:"iana",compressible:!0},"application/vnd.oipf.contentaccessdownload+xml":{source:"iana"},"application/vnd.oipf.contentaccessstreaming+xml":{source:"iana"},"application/vnd.oipf.cspg-hexbinary":{source:"iana"},"application/vnd.oipf.dae.svg+xml":{source:"iana"},"application/vnd.oipf.dae.xhtml+xml":{source:"iana"},"application/vnd.oipf.mippvcontrolmessage+xml":{source:"iana"},"application/vnd.oipf.pae.gem":{source:"iana"},"application/vnd.oipf.spdiscovery+xml":{source:"iana"},"application/vnd.oipf.spdlist+xml":{source:"iana"},"application/vnd.oipf.ueprofile+xml":{source:"iana"},"application/vnd.oipf.userprofile+xml":{source:"iana"},"application/vnd.olpc-sugar":{source:"iana",extensions:["xo"]},"application/vnd.oma-scws-config":{source:"iana"},"application/vnd.oma-scws-http-request":{source:"iana"},"application/vnd.oma-scws-http-response":{source:"iana"},"application/vnd.oma.bcast.associated-procedure-parameter+xml":{source:"iana"},"application/vnd.oma.bcast.drm-trigger+xml":{source:"iana"},"application/vnd.oma.bcast.imd+xml":{source:"iana"},"application/vnd.oma.bcast.ltkm":{source:"iana"},"application/vnd.oma.bcast.notification+xml":{source:"iana"},"application/vnd.oma.bcast.provisioningtrigger":{source:"iana"},"application/vnd.oma.bcast.sgboot":{source:"iana"},"application/vnd.oma.bcast.sgdd+xml":{source:"iana"},"application/vnd.oma.bcast.sgdu":{source:"iana"},"application/vnd.oma.bcast.simple-symbol-container":{source:"iana"},"application/vnd.oma.bcast.smartcard-trigger+xml":{source:"iana"},"application/vnd.oma.bcast.sprov+xml":{source:"iana"},"application/vnd.oma.bcast.stkm":{source:"iana"},"application/vnd.oma.cab-address-book+xml":{source:"iana"},"application/vnd.oma.cab-feature-handler+xml":{source:"iana"},"application/vnd.oma.cab-pcc+xml":{source:"iana"},"application/vnd.oma.cab-subs-invite+xml":{source:"iana"},"application/vnd.oma.cab-user-prefs+xml":{source:"iana"},"application/vnd.oma.dcd":{source:"iana"},"application/vnd.oma.dcdc":{source:"iana"},"application/vnd.oma.dd2+xml":{source:"iana",extensions:["dd2"]},"application/vnd.oma.drm.risd+xml":{source:"iana"},"application/vnd.oma.group-usage-list+xml":{source:"iana"},"application/vnd.oma.lwm2m+json":{source:"iana",compressible:!0},"application/vnd.oma.lwm2m+tlv":{source:"iana"},"application/vnd.oma.pal+xml":{source:"iana"},"application/vnd.oma.poc.detailed-progress-report+xml":{source:"iana"},"application/vnd.oma.poc.final-report+xml":{source:"iana"},"application/vnd.oma.poc.groups+xml":{source:"iana"},"application/vnd.oma.poc.invocation-descriptor+xml":{source:"iana"},"application/vnd.oma.poc.optimized-progress-report+xml":{source:"iana"},"application/vnd.oma.push":{source:"iana"},"application/vnd.oma.scidm.messages+xml":{source:"iana"},"application/vnd.oma.xcap-directory+xml":{source:"iana"},"application/vnd.omads-email+xml":{source:"iana"},"application/vnd.omads-file+xml":{source:"iana"},"application/vnd.omads-folder+xml":{source:"iana"},"application/vnd.omaloc-supl-init":{source:"iana"},"application/vnd.onepager":{source:"iana"},"application/vnd.onepagertamp":{source:"iana"},"application/vnd.onepagertamx":{source:"iana"},"application/vnd.onepagertat":{source:"iana"},"application/vnd.onepagertatp":{source:"iana"},"application/vnd.onepagertatx":{source:"iana"},"application/vnd.openblox.game+xml":{source:"iana"},"application/vnd.openblox.game-binary":{source:"iana"},"application/vnd.openeye.oeb":{source:"iana"},"application/vnd.openofficeorg.extension":{source:"apache",extensions:["oxt"]},"application/vnd.openstreetmap.data+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.custom-properties+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.customxmlproperties+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawing+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.chart+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.extended-properties+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.comments+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.presentation":{source:"iana",compressible:!1,extensions:["pptx"]},"application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.presprops+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.slide":{source:"iana",extensions:["sldx"]},"application/vnd.openxmlformats-officedocument.presentationml.slide+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.slideshow":{source:"iana",extensions:["ppsx"]},"application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.tags+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.template":{source:"iana",extensions:["potx"]},"application/vnd.openxmlformats-officedocument.presentationml.template.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":{source:"iana",compressible:!1,extensions:["xlsx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.template":{source:"iana",extensions:["xltx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.theme+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.themeoverride+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.vmldrawing":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.document":{source:"iana",compressible:!1,extensions:["docx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.template":{source:"iana",extensions:["dotx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml":{source:"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml":{source:"iana"},"application/vnd.openxmlformats-package.core-properties+xml":{source:"iana"},"application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml":{source:"iana"},"application/vnd.openxmlformats-package.relationships+xml":{source:"iana"},"application/vnd.oracle.resource+json":{source:"iana",compressible:!0},"application/vnd.orange.indata":{source:"iana"},"application/vnd.osa.netdeploy":{source:"iana"},"application/vnd.osgeo.mapguide.package":{source:"iana",extensions:["mgp"]},"application/vnd.osgi.bundle":{source:"iana"},"application/vnd.osgi.dp":{source:"iana",extensions:["dp"]},"application/vnd.osgi.subsystem":{source:"iana",extensions:["esa"]},"application/vnd.otps.ct-kip+xml":{source:"iana"},"application/vnd.oxli.countgraph":{source:"iana"},"application/vnd.pagerduty+json":{source:"iana",compressible:!0},"application/vnd.palm":{source:"iana",extensions:["pdb","pqa","oprc"]},"application/vnd.panoply":{source:"iana"},"application/vnd.paos+xml":{source:"iana"},"application/vnd.paos.xml":{source:"apache"},"application/vnd.patentdive":{source:"iana"},"application/vnd.pawaafile":{source:"iana",extensions:["paw"]},"application/vnd.pcos":{source:"iana"},"application/vnd.pg.format":{source:"iana",extensions:["str"]},"application/vnd.pg.osasli":{source:"iana",extensions:["ei6"]},"application/vnd.piaccess.application-licence":{source:"iana"},"application/vnd.picsel":{source:"iana",extensions:["efif"]},"application/vnd.pmi.widget":{source:"iana",extensions:["wg"]},"application/vnd.poc.group-advertisement+xml":{source:"iana"},"application/vnd.pocketlearn":{source:"iana",extensions:["plf"]},"application/vnd.powerbuilder6":{source:"iana",extensions:["pbd"]},"application/vnd.powerbuilder6-s":{source:"iana"},"application/vnd.powerbuilder7":{source:"iana"},"application/vnd.powerbuilder7-s":{source:"iana"},"application/vnd.powerbuilder75":{source:"iana"},"application/vnd.powerbuilder75-s":{source:"iana"},"application/vnd.preminet":{source:"iana"},"application/vnd.previewsystems.box":{source:"iana",extensions:["box"]},"application/vnd.proteus.magazine":{source:"iana",extensions:["mgz"]},"application/vnd.publishare-delta-tree":{source:"iana",extensions:["qps"]},"application/vnd.pvi.ptid1":{source:"iana",extensions:["ptid"]},"application/vnd.pwg-multiplexed":{source:"iana"},"application/vnd.pwg-xhtml-print+xml":{source:"iana"},"application/vnd.qualcomm.brew-app-res":{source:"iana"},"application/vnd.quarantainenet":{source:"iana"},"application/vnd.quark.quarkxpress":{source:"iana",extensions:["qxd","qxt","qwd","qwt","qxl","qxb"]},"application/vnd.quobject-quoxdocument":{source:"iana"},"application/vnd.radisys.moml+xml":{source:"iana"},"application/vnd.radisys.msml+xml":{source:"iana"},"application/vnd.radisys.msml-audit+xml":{source:"iana"},"application/vnd.radisys.msml-audit-conf+xml":{source:"iana"},"application/vnd.radisys.msml-audit-conn+xml":{source:"iana"},"application/vnd.radisys.msml-audit-dialog+xml":{source:"iana"},"application/vnd.radisys.msml-audit-stream+xml":{source:"iana"},"application/vnd.radisys.msml-conf+xml":{source:"iana"},"application/vnd.radisys.msml-dialog+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-base+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-fax-detect+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-fax-sendrecv+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-group+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-speech+xml":{source:"iana"},"application/vnd.radisys.msml-dialog-transform+xml":{source:"iana"},"application/vnd.rainstor.data":{source:"iana"},"application/vnd.rapid":{source:"iana"},"application/vnd.rar":{source:"iana"},"application/vnd.realvnc.bed":{source:"iana",extensions:["bed"]},"application/vnd.recordare.musicxml":{source:"iana",extensions:["mxl"]},"application/vnd.recordare.musicxml+xml":{source:"iana",extensions:["musicxml"]},"application/vnd.renlearn.rlprint":{source:"iana"},"application/vnd.restful+json":{source:"iana",compressible:!0},"application/vnd.rig.cryptonote":{source:"iana",extensions:["cryptonote"]},"application/vnd.rim.cod":{source:"apache",extensions:["cod"]},"application/vnd.rn-realmedia":{source:"apache",extensions:["rm"]},"application/vnd.rn-realmedia-vbr":{source:"apache",extensions:["rmvb"]},"application/vnd.route66.link66+xml":{source:"iana",extensions:["link66"]},"application/vnd.rs-274x":{source:"iana"},"application/vnd.ruckus.download":{source:"iana"},"application/vnd.s3sms":{source:"iana"},"application/vnd.sailingtracker.track":{source:"iana",extensions:["st"]},"application/vnd.sbm.cid":{source:"iana"},"application/vnd.sbm.mid2":{source:"iana"},"application/vnd.scribus":{source:"iana"},"application/vnd.sealed.3df":{source:"iana"},"application/vnd.sealed.csf":{source:"iana"},"application/vnd.sealed.doc":{source:"iana"},"application/vnd.sealed.eml":{source:"iana"},"application/vnd.sealed.mht":{source:"iana"},"application/vnd.sealed.net":{source:"iana"},"application/vnd.sealed.ppt":{source:"iana"},"application/vnd.sealed.tiff":{source:"iana"},"application/vnd.sealed.xls":{source:"iana"},"application/vnd.sealedmedia.softseal.html":{source:"iana"},"application/vnd.sealedmedia.softseal.pdf":{source:"iana"},"application/vnd.seemail":{source:"iana",extensions:["see"]},"application/vnd.sema":{source:"iana",extensions:["sema"]},"application/vnd.semd":{source:"iana",extensions:["semd"]},"application/vnd.semf":{source:"iana",extensions:["semf"]},"application/vnd.shana.informed.formdata":{source:"iana",extensions:["ifm"]},"application/vnd.shana.informed.formtemplate":{source:"iana",extensions:["itp"]},"application/vnd.shana.informed.interchange":{source:"iana",extensions:["iif"]},"application/vnd.shana.informed.package":{source:"iana",extensions:["ipk"]},"application/vnd.sigrok.session":{source:"iana"},"application/vnd.simtech-mindmapper":{source:"iana",extensions:["twd","twds"]},"application/vnd.siren+json":{source:"iana",compressible:!0},"application/vnd.smaf":{source:"iana",extensions:["mmf"]},"application/vnd.smart.notebook":{source:"iana"},"application/vnd.smart.teacher":{source:"iana",extensions:["teacher"]},"application/vnd.software602.filler.form+xml":{source:"iana"},"application/vnd.software602.filler.form-xml-zip":{source:"iana"},"application/vnd.solent.sdkm+xml":{source:"iana",extensions:["sdkm","sdkd"]},"application/vnd.spotfire.dxp":{source:"iana",extensions:["dxp"]},"application/vnd.spotfire.sfs":{source:"iana",extensions:["sfs"]},"application/vnd.sqlite3":{source:"iana"},"application/vnd.sss-cod":{source:"iana"},"application/vnd.sss-dtf":{source:"iana"},"application/vnd.sss-ntf":{source:"iana"},"application/vnd.stardivision.calc":{source:"apache",extensions:["sdc"]},"application/vnd.stardivision.draw":{source:"apache",extensions:["sda"]},"application/vnd.stardivision.impress":{source:"apache",extensions:["sdd"]},"application/vnd.stardivision.math":{source:"apache",extensions:["smf"]},"application/vnd.stardivision.writer":{source:"apache",extensions:["sdw","vor"]},"application/vnd.stardivision.writer-global":{source:"apache",extensions:["sgl"]},"application/vnd.stepmania.package":{source:"iana",extensions:["smzip"]},"application/vnd.stepmania.stepchart":{source:"iana",extensions:["sm"]},"application/vnd.street-stream":{source:"iana"},"application/vnd.sun.wadl+xml":{source:"iana",compressible:!0,extensions:["wadl"]},"application/vnd.sun.xml.calc":{source:"apache",extensions:["sxc"]},"application/vnd.sun.xml.calc.template":{source:"apache",extensions:["stc"]},"application/vnd.sun.xml.draw":{source:"apache",extensions:["sxd"]},"application/vnd.sun.xml.draw.template":{source:"apache",extensions:["std"]},"application/vnd.sun.xml.impress":{source:"apache",extensions:["sxi"]},"application/vnd.sun.xml.impress.template":{source:"apache",extensions:["sti"]},"application/vnd.sun.xml.math":{source:"apache",extensions:["sxm"]},"application/vnd.sun.xml.writer":{source:"apache",extensions:["sxw"]},"application/vnd.sun.xml.writer.global":{source:"apache",extensions:["sxg"]},"application/vnd.sun.xml.writer.template":{source:"apache",extensions:["stw"]},"application/vnd.sus-calendar":{source:"iana",extensions:["sus","susp"]},"application/vnd.svd":{source:"iana",extensions:["svd"]},"application/vnd.swiftview-ics":{source:"iana"},"application/vnd.symbian.install":{source:"apache",extensions:["sis","sisx"]},"application/vnd.syncml+xml":{source:"iana",extensions:["xsm"]},"application/vnd.syncml.dm+wbxml":{source:"iana",extensions:["bdm"]},"application/vnd.syncml.dm+xml":{source:"iana",extensions:["xdm"]},"application/vnd.syncml.dm.notification":{source:"iana"},"application/vnd.syncml.dmddf+wbxml":{source:"iana"},"application/vnd.syncml.dmddf+xml":{source:"iana"},"application/vnd.syncml.dmtnds+wbxml":{source:"iana"},"application/vnd.syncml.dmtnds+xml":{source:"iana"},"application/vnd.syncml.ds.notification":{source:"iana"},"application/vnd.tableschema+json":{source:"iana",compressible:!0},"application/vnd.tao.intent-module-archive":{source:"iana",extensions:["tao"]},"application/vnd.tcpdump.pcap":{source:"iana",extensions:["pcap","cap","dmp"]},"application/vnd.tmd.mediaflex.api+xml":{source:"iana"},"application/vnd.tml":{source:"iana"},"application/vnd.tmobile-livetv":{source:"iana",extensions:["tmo"]},"application/vnd.tri.onesource":{source:"iana"},"application/vnd.trid.tpt":{source:"iana",extensions:["tpt"]},"application/vnd.triscape.mxs":{source:"iana",extensions:["mxs"]},"application/vnd.trueapp":{source:"iana",extensions:["tra"]},"application/vnd.truedoc":{source:"iana"},"application/vnd.ubisoft.webplayer":{source:"iana"},"application/vnd.ufdl":{source:"iana",extensions:["ufd","ufdl"]},"application/vnd.uiq.theme":{source:"iana",extensions:["utz"]},"application/vnd.umajin":{source:"iana",extensions:["umj"]},"application/vnd.unity":{source:"iana",extensions:["unityweb"]},"application/vnd.uoml+xml":{source:"iana",extensions:["uoml"]},"application/vnd.uplanet.alert":{source:"iana"},"application/vnd.uplanet.alert-wbxml":{source:"iana"},"application/vnd.uplanet.bearer-choice":{source:"iana"},"application/vnd.uplanet.bearer-choice-wbxml":{source:"iana"},"application/vnd.uplanet.cacheop":{source:"iana"},"application/vnd.uplanet.cacheop-wbxml":{source:"iana"},"application/vnd.uplanet.channel":{source:"iana"},"application/vnd.uplanet.channel-wbxml":{source:"iana"},"application/vnd.uplanet.list":{source:"iana"},"application/vnd.uplanet.list-wbxml":{source:"iana"},"application/vnd.uplanet.listcmd":{source:"iana"},"application/vnd.uplanet.listcmd-wbxml":{source:"iana"},"application/vnd.uplanet.signal":{source:"iana"},"application/vnd.uri-map":{source:"iana"},"application/vnd.valve.source.material":{source:"iana"},"application/vnd.vcx":{source:"iana",extensions:["vcx"]},"application/vnd.vd-study":{source:"iana"},"application/vnd.vectorworks":{source:"iana"},"application/vnd.vel+json":{source:"iana",compressible:!0},"application/vnd.verimatrix.vcas":{source:"iana"},"application/vnd.vidsoft.vidconference":{source:"iana"},"application/vnd.visio":{source:"iana",extensions:["vsd","vst","vss","vsw"]},"application/vnd.visionary":{source:"iana",extensions:["vis"]},"application/vnd.vividence.scriptfile":{source:"iana"},"application/vnd.vsf":{source:"iana",extensions:["vsf"]},"application/vnd.wap.sic":{source:"iana"},"application/vnd.wap.slc":{source:"iana"},"application/vnd.wap.wbxml":{source:"iana",extensions:["wbxml"]},"application/vnd.wap.wmlc":{source:"iana",extensions:["wmlc"]},"application/vnd.wap.wmlscriptc":{source:"iana",extensions:["wmlsc"]},"application/vnd.webturbo":{source:"iana",extensions:["wtb"]},"application/vnd.wfa.p2p":{source:"iana"},"application/vnd.wfa.wsc":{source:"iana"},"application/vnd.windows.devicepairing":{source:"iana"},"application/vnd.wmc":{source:"iana"},"application/vnd.wmf.bootstrap":{source:"iana"},"application/vnd.wolfram.mathematica":{source:"iana"},"application/vnd.wolfram.mathematica.package":{source:"iana"},"application/vnd.wolfram.player":{source:"iana",extensions:["nbp"]},"application/vnd.wordperfect":{source:"iana",extensions:["wpd"]},"application/vnd.wqd":{source:"iana",extensions:["wqd"]},"application/vnd.wrq-hp3000-labelled":{source:"iana"},"application/vnd.wt.stf":{source:"iana",extensions:["stf"]},"application/vnd.wv.csp+wbxml":{source:"iana"},"application/vnd.wv.csp+xml":{source:"iana"},"application/vnd.wv.ssp+xml":{source:"iana"},"application/vnd.xacml+json":{source:"iana",compressible:!0},"application/vnd.xara":{source:"iana",extensions:["xar"]},"application/vnd.xfdl":{source:"iana",extensions:["xfdl"]},"application/vnd.xfdl.webform":{source:"iana"},"application/vnd.xmi+xml":{source:"iana"},"application/vnd.xmpie.cpkg":{source:"iana"},"application/vnd.xmpie.dpkg":{source:"iana"},"application/vnd.xmpie.plan":{source:"iana"},"application/vnd.xmpie.ppkg":{source:"iana"},"application/vnd.xmpie.xlim":{source:"iana"},"application/vnd.yamaha.hv-dic":{source:"iana",extensions:["hvd"]},"application/vnd.yamaha.hv-script":{source:"iana",extensions:["hvs"]},"application/vnd.yamaha.hv-voice":{source:"iana",extensions:["hvp"]},"application/vnd.yamaha.openscoreformat":{source:"iana",extensions:["osf"]},"application/vnd.yamaha.openscoreformat.osfpvg+xml":{source:"iana",extensions:["osfpvg"]},"application/vnd.yamaha.remote-setup":{source:"iana"},"application/vnd.yamaha.smaf-audio":{source:"iana",extensions:["saf"]},"application/vnd.yamaha.smaf-phrase":{source:"iana",extensions:["spf"]},"application/vnd.yamaha.through-ngn":{source:"iana"},"application/vnd.yamaha.tunnel-udpencap":{source:"iana"},"application/vnd.yaoweme":{source:"iana"},"application/vnd.yellowriver-custom-menu":{source:"iana",extensions:["cmp"]},"application/vnd.youtube.yt":{source:"iana"},"application/vnd.zul":{source:"iana",extensions:["zir","zirz"]},"application/vnd.zzazz.deck+xml":{source:"iana",extensions:["zaz"]},"application/voicexml+xml":{source:"iana",extensions:["vxml"]},"application/voucher-cms+json":{source:"iana",compressible:!0},"application/vq-rtcpxr":{source:"iana"},"application/wasm":{compressible:!0,extensions:["wasm"]},"application/watcherinfo+xml":{source:"iana"},"application/webpush-options+json":{source:"iana",compressible:!0},"application/whoispp-query":{source:"iana"},"application/whoispp-response":{source:"iana"},"application/widget":{source:"iana",extensions:["wgt"]},"application/winhlp":{source:"apache",extensions:["hlp"]},"application/wita":{source:"iana"},"application/wordperfect5.1":{source:"iana"},"application/wsdl+xml":{source:"iana",extensions:["wsdl"]},"application/wspolicy+xml":{source:"iana",extensions:["wspolicy"]},"application/x-7z-compressed":{source:"apache",compressible:!1,extensions:["7z"]},"application/x-abiword":{source:"apache",extensions:["abw"]},"application/x-ace-compressed":{source:"apache",extensions:["ace"]},"application/x-amf":{source:"apache"},"application/x-apple-diskimage":{source:"apache",extensions:["dmg"]},"application/x-arj":{compressible:!1,extensions:["arj"]},"application/x-authorware-bin":{source:"apache",extensions:["aab","x32","u32","vox"]},"application/x-authorware-map":{source:"apache",extensions:["aam"]},"application/x-authorware-seg":{source:"apache",extensions:["aas"]},"application/x-bcpio":{source:"apache",extensions:["bcpio"]},"application/x-bdoc":{compressible:!1,extensions:["bdoc"]},"application/x-bittorrent":{source:"apache",extensions:["torrent"]},"application/x-blorb":{source:"apache",extensions:["blb","blorb"]},"application/x-bzip":{source:"apache",compressible:!1,extensions:["bz"]},"application/x-bzip2":{source:"apache",compressible:!1,extensions:["bz2","boz"]},"application/x-cbr":{source:"apache",extensions:["cbr","cba","cbt","cbz","cb7"]},"application/x-cdlink":{source:"apache",extensions:["vcd"]},"application/x-cfs-compressed":{source:"apache",extensions:["cfs"]},"application/x-chat":{source:"apache",extensions:["chat"]},"application/x-chess-pgn":{source:"apache",extensions:["pgn"]},"application/x-chrome-extension":{extensions:["crx"]},"application/x-cocoa":{source:"nginx",extensions:["cco"]},"application/x-compress":{source:"apache"},"application/x-conference":{source:"apache",extensions:["nsc"]},"application/x-cpio":{source:"apache",extensions:["cpio"]},"application/x-csh":{source:"apache",extensions:["csh"]},"application/x-deb":{compressible:!1},"application/x-debian-package":{source:"apache",extensions:["deb","udeb"]},"application/x-dgc-compressed":{source:"apache",extensions:["dgc"]},"application/x-director":{source:"apache",extensions:["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"]},"application/x-doom":{source:"apache",extensions:["wad"]},"application/x-dtbncx+xml":{source:"apache",extensions:["ncx"]},"application/x-dtbook+xml":{source:"apache",extensions:["dtb"]},"application/x-dtbresource+xml":{source:"apache",extensions:["res"]},"application/x-dvi":{source:"apache",compressible:!1,extensions:["dvi"]},"application/x-envoy":{source:"apache",extensions:["evy"]},"application/x-eva":{source:"apache",extensions:["eva"]},"application/x-font-bdf":{source:"apache",extensions:["bdf"]},"application/x-font-dos":{source:"apache"},"application/x-font-framemaker":{source:"apache"},"application/x-font-ghostscript":{source:"apache",extensions:["gsf"]},"application/x-font-libgrx":{source:"apache"},"application/x-font-linux-psf":{source:"apache",extensions:["psf"]},"application/x-font-pcf":{source:"apache",extensions:["pcf"]},"application/x-font-snf":{source:"apache",extensions:["snf"]},"application/x-font-speedo":{source:"apache"},"application/x-font-sunos-news":{source:"apache"},"application/x-font-type1":{source:"apache",extensions:["pfa","pfb","pfm","afm"]},"application/x-font-vfont":{source:"apache"},"application/x-freearc":{source:"apache",extensions:["arc"]},"application/x-futuresplash":{source:"apache",extensions:["spl"]},"application/x-gca-compressed":{source:"apache",extensions:["gca"]},"application/x-glulx":{source:"apache",extensions:["ulx"]},"application/x-gnumeric":{source:"apache",extensions:["gnumeric"]},"application/x-gramps-xml":{source:"apache",extensions:["gramps"]},"application/x-gtar":{source:"apache",extensions:["gtar"]},"application/x-gzip":{source:"apache"},"application/x-hdf":{source:"apache",extensions:["hdf"]},"application/x-httpd-php":{compressible:!0,extensions:["php"]},"application/x-install-instructions":{source:"apache",extensions:["install"]},"application/x-iso9660-image":{source:"apache",extensions:["iso"]},"application/x-java-archive-diff":{source:"nginx",extensions:["jardiff"]},"application/x-java-jnlp-file":{source:"apache",compressible:!1,extensions:["jnlp"]},"application/x-javascript":{compressible:!0},"application/x-latex":{source:"apache",compressible:!1,extensions:["latex"]},"application/x-lua-bytecode":{extensions:["luac"]},"application/x-lzh-compressed":{source:"apache",extensions:["lzh","lha"]},"application/x-makeself":{source:"nginx",extensions:["run"]},"application/x-mie":{source:"apache",extensions:["mie"]},"application/x-mobipocket-ebook":{source:"apache",extensions:["prc","mobi"]},"application/x-mpegurl":{compressible:!1},"application/x-ms-application":{source:"apache",extensions:["application"]},"application/x-ms-shortcut":{source:"apache",extensions:["lnk"]},"application/x-ms-wmd":{source:"apache",extensions:["wmd"]},"application/x-ms-wmz":{source:"apache",extensions:["wmz"]},"application/x-ms-xbap":{source:"apache",extensions:["xbap"]},"application/x-msaccess":{source:"apache",extensions:["mdb"]},"application/x-msbinder":{source:"apache",extensions:["obd"]},"application/x-mscardfile":{source:"apache",extensions:["crd"]},"application/x-msclip":{source:"apache",extensions:["clp"]},"application/x-msdos-program":{extensions:["exe"]},"application/x-msdownload":{source:"apache",extensions:["exe","dll","com","bat","msi"]},"application/x-msmediaview":{source:"apache",extensions:["mvb","m13","m14"]},"application/x-msmetafile":{source:"apache",extensions:["wmf","wmz","emf","emz"]},"application/x-msmoney":{source:"apache",extensions:["mny"]},"application/x-mspublisher":{source:"apache",extensions:["pub"]},"application/x-msschedule":{source:"apache",extensions:["scd"]},"application/x-msterminal":{source:"apache",extensions:["trm"]},"application/x-mswrite":{source:"apache",extensions:["wri"]},"application/x-netcdf":{source:"apache",extensions:["nc","cdf"]},"application/x-ns-proxy-autoconfig":{compressible:!0,extensions:["pac"]},"application/x-nzb":{source:"apache",extensions:["nzb"]},"application/x-perl":{source:"nginx",extensions:["pl","pm"]},"application/x-pilot":{source:"nginx",extensions:["prc","pdb"]},"application/x-pkcs12":{source:"apache",compressible:!1,extensions:["p12","pfx"]},"application/x-pkcs7-certificates":{source:"apache",extensions:["p7b","spc"]},"application/x-pkcs7-certreqresp":{source:"apache",extensions:["p7r"]},"application/x-rar-compressed":{source:"apache",compressible:!1,extensions:["rar"]},"application/x-redhat-package-manager":{source:"nginx",extensions:["rpm"]},"application/x-research-info-systems":{source:"apache",extensions:["ris"]},"application/x-sea":{source:"nginx",extensions:["sea"]},"application/x-sh":{source:"apache",compressible:!0,extensions:["sh"]},"application/x-shar":{source:"apache",extensions:["shar"]},"application/x-shockwave-flash":{source:"apache",compressible:!1,extensions:["swf"]},"application/x-silverlight-app":{source:"apache",extensions:["xap"]},"application/x-sql":{source:"apache",extensions:["sql"]},"application/x-stuffit":{source:"apache",compressible:!1,extensions:["sit"]},"application/x-stuffitx":{source:"apache",extensions:["sitx"]},"application/x-subrip":{source:"apache",extensions:["srt"]},"application/x-sv4cpio":{source:"apache",extensions:["sv4cpio"]},"application/x-sv4crc":{source:"apache",extensions:["sv4crc"]},"application/x-t3vm-image":{source:"apache",extensions:["t3"]},"application/x-tads":{source:"apache",extensions:["gam"]},"application/x-tar":{source:"apache",compressible:!0,extens