package org.exoplatform.wallet.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.2.0.
 */
public class ERTTokenV2 extends Contract {
    private static final String BINARY = "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";

    public static final String FUNC_NAME = "name";

    public static final String FUNC_APPROVE = "approve";

    public static final String FUNC_INITIALIZED = "initialized";

    public static final String FUNC_REMOVEADMIN = "removeAdmin";

    public static final String FUNC_TOTALSUPPLY = "totalSupply";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_TRANSFERFROM = "transferFrom";

    public static final String FUNC_DECIMALS = "decimals";

    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";

    public static final String FUNC_VESTINGBALANCEOF = "vestingBalanceOf";

    public static final String FUNC_GETSELLPRICE = "getSellPrice";

    public static final String FUNC_ISADMIN = "isAdmin";

    public static final String FUNC_REWARD = "reward";

    public static final String FUNC_ADDADMIN = "addAdmin";

    public static final String FUNC_INITIALIZEACCOUNT = "initializeAccount";

    public static final String FUNC_VERSION = "version";

    public static final String FUNC_TRANSFORMTOVESTED = "transformToVested";

    public static final String FUNC_PAUSED = "paused";

    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";

    public static final String FUNC_ISINITIALIZEDACCOUNT = "isInitializedAccount";

    public static final String FUNC_UPGRADEDATA = "upgradeData";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_PAUSE = "pause";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_GETDATAADDRESS = "getDataAddress";

    public static final String FUNC_SYMBOL = "symbol";

    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";

    public static final String FUNC_TRANSFER = "transfer";

    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";

    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";

    public static final String FUNC_ISPAUSED = "isPaused";

    public static final String FUNC_SETSYMBOL = "setSymbol";

    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";

    public static final String FUNC_SETNAME = "setName";

    public static final String FUNC_ALLOWANCE = "allowance";

    public static final String FUNC_REWARDBALANCEOF = "rewardBalanceOf";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UNPAUSE = "unPause";

    public static final String FUNC_APPROVEACCOUNT = "approveAccount";

    public static final String FUNC_SETSELLPRICE = "setSellPrice";

    public static final Event VESTING_EVENT = new Event("Vesting", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event VESTINGTRANSFER_EVENT = new Event("VestingTransfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event REWARD_EVENT = new Event("Reward", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event INITIALIZATION_EVENT = new Event("Initialization", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSFER_EVENT = new Event("Transfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVAL_EVENT = new Event("Approval", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint8>() {}));
    ;

    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    @Deprecated
    protected ERTTokenV2(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV2(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV2(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV2(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> name() {
        final Function function = new Function(FUNC_NAME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        final Function function = new Function(
                FUNC_APPROVE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_spender), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> initialized() {
        final Function function = new Function(FUNC_INITIALIZED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> removeAdmin(String _target) {
        final Function function = new Function(
                FUNC_REMOVEADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        final Function function = new Function(FUNC_TOTALSUPPLY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> initialize(BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        final Function function = new Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_initialAmount), 
                new org.web3j.abi.datatypes.Utf8String(_tokenName), 
                new org.web3j.abi.datatypes.generated.Uint8(_decimalUnits), 
                new org.web3j.abi.datatypes.Utf8String(_tokenSymbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_from), 
                new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        final Function function = new Function(FUNC_DECIMALS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADEIMPLEMENTATION, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_proxy), 
                new org.web3j.abi.datatypes.generated.Uint16(_version), 
                new org.web3j.abi.datatypes.Address(_newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> vestingBalanceOf(String _target) {
        final Function function = new Function(FUNC_VESTINGBALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> getSellPrice() {
        final Function function = new Function(FUNC_GETSELLPRICE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isAdmin(String _target, BigInteger _level) {
        final Function function = new Function(FUNC_ISADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> reward(String _to, BigInteger _amount, BigInteger _reward) {
        final Function function = new Function(
                FUNC_REWARD, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.generated.Uint256(_reward)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        final Function function = new Function(
                FUNC_ADDADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> initializeAccount(String _to, BigInteger _tokenAmount, BigInteger weiValue) {
        final Function function = new Function(
                FUNC_INITIALIZEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_tokenAmount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteCall<BigInteger> version() {
        final Function function = new Function(FUNC_VERSION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transformToVested(String _target, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFORMTOVESTED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> paused() {
        final Function function = new Function(FUNC_PAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> disapproveAccount(String _target) {
        final Function function = new Function(
                FUNC_DISAPPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isInitializedAccount(String _target) {
        final Function function = new Function(FUNC_ISINITIALIZEDACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        final Function function = new Function(
                FUNC_UPGRADEDATA, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_dataVersion), 
                new org.web3j.abi.datatypes.Address(_dataAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String _target) {
        final Function function = new Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> pause() {
        final Function function = new Function(
                FUNC_PAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        final Function function = new Function(FUNC_GETDATAADDRESS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_version)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> symbol() {
        final Function function = new Function(FUNC_SYMBOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        final Function function = new Function(
                FUNC_UPGRADEDATAANDIMPLEMENTATION, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_proxy), 
                new org.web3j.abi.datatypes.generated.Uint16(_version), 
                new org.web3j.abi.datatypes.Address(_newImplementation), 
                new org.web3j.abi.datatypes.generated.Uint16(_dataVersion), 
                new org.web3j.abi.datatypes.Address(_dataAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isApprovedAccount(String _target) {
        final Function function = new Function(FUNC_ISAPPROVEDACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<BigInteger> getAdminLevel(String _target) {
        final Function function = new Function(FUNC_GETADMINLEVEL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isPaused() {
        final Function function = new Function(FUNC_ISPAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setSymbol(String _symbol) {
        final Function function = new Function(
                FUNC_SETSYMBOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_symbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        final Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setName(String _name) {
        final Function function = new Function(
                FUNC_SETNAME, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_name)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _target, String _spender) {
        final Function function = new Function(FUNC_ALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.Address(_spender)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> rewardBalanceOf(String _target) {
        final Function function = new Function(FUNC_REWARDBALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> unPause() {
        final Function function = new Function(
                FUNC_UNPAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAccount(String _target) {
        final Function function = new Function(
                FUNC_APPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        final Function function = new Function(
                FUNC_SETSELLPRICE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public List<VestingEventResponse> getVestingEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(VESTING_EVENT, transactionReceipt);
        ArrayList<VestingEventResponse> responses = new ArrayList<VestingEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            VestingEventResponse typedResponse = new VestingEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._target = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<VestingEventResponse> vestingEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, VestingEventResponse>() {
            @Override
            public VestingEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(VESTING_EVENT, log);
                VestingEventResponse typedResponse = new VestingEventResponse();
                typedResponse.log = log;
                typedResponse._target = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<VestingEventResponse> vestingEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(VESTING_EVENT));
        return vestingEventFlowable(filter);
    }

    public List<VestingTransferEventResponse> getVestingTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(VESTINGTRANSFER_EVENT, transactionReceipt);
        ArrayList<VestingTransferEventResponse> responses = new ArrayList<VestingTransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            VestingTransferEventResponse typedResponse = new VestingTransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<VestingTransferEventResponse> vestingTransferEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, VestingTransferEventResponse>() {
            @Override
            public VestingTransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(VESTINGTRANSFER_EVENT, log);
                VestingTransferEventResponse typedResponse = new VestingTransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<VestingTransferEventResponse> vestingTransferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(VESTINGTRANSFER_EVENT));
        return vestingTransferEventFlowable(filter);
    }

    public List<RewardEventResponse> getRewardEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REWARD_EVENT, transactionReceipt);
        ArrayList<RewardEventResponse> responses = new ArrayList<RewardEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RewardEventResponse typedResponse = new RewardEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._rewardAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RewardEventResponse> rewardEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, RewardEventResponse>() {
            @Override
            public RewardEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REWARD_EVENT, log);
                RewardEventResponse typedResponse = new RewardEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._rewardAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RewardEventResponse> rewardEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REWARD_EVENT));
        return rewardEventFlowable(filter);
    }

    public List<InitializationEventResponse> getInitializationEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(INITIALIZATION_EVENT, transactionReceipt);
        ArrayList<InitializationEventResponse> responses = new ArrayList<InitializationEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializationEventResponse typedResponse = new InitializationEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._etherAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<InitializationEventResponse> initializationEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, InitializationEventResponse>() {
            @Override
            public InitializationEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(INITIALIZATION_EVENT, log);
                InitializationEventResponse typedResponse = new InitializationEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._etherAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<InitializationEventResponse> initializationEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(INITIALIZATION_EVENT));
        return initializationEventFlowable(filter);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, UpgradedEventResponse>() {
            @Override
            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventFlowable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.dataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, UpgradedDataEventResponse>() {
            @Override
            public UpgradedDataEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.dataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADEDDATA_EVENT));
        return upgradedDataEventFlowable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TokenPriceChangedEventResponse>() {
            @Override
            public TokenPriceChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TOKENPRICECHANGED_EVENT));
        return tokenPriceChangedEventFlowable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransactionFeeEventResponse>() {
            @Override
            public TransactionFeeEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSACTIONFEE_EVENT));
        return transactionFeeEventFlowable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, NoSufficientFundEventResponse>() {
            @Override
            public NoSufficientFundEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(NOSUFFICIENTFUND_EVENT));
        return noSufficientFundEventFlowable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, DepositReceivedEventResponse>() {
            @Override
            public DepositReceivedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEPOSITRECEIVED_EVENT));
        return depositReceivedEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransferEventResponse>() {
            @Override
            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFER_EVENT));
        return transferEventFlowable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ApprovalEventResponse>() {
            @Override
            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVAL_EVENT));
        return approvalEventFlowable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ApprovedAccountEventResponse>() {
            @Override
            public ApprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVEDACCOUNT_EVENT));
        return approvedAccountEventFlowable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, DisapprovedAccountEventResponse>() {
            @Override
            public DisapprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DISAPPROVEDACCOUNT_EVENT));
        return disapprovedAccountEventFlowable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ContractPausedEventResponse>() {
            @Override
            public ContractPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTPAUSED_EVENT));
        return contractPausedEventFlowable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ContractUnPausedEventResponse>() {
            @Override
            public ContractUnPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTUNPAUSED_EVENT));
        return contractUnPausedEventFlowable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, AddedAdminEventResponse>() {
            @Override
            public AddedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADDEDADMIN_EVENT));
        return addedAdminEventFlowable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, RemovedAdminEventResponse>() {
            @Override
            public RemovedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REMOVEDADMIN_EVENT));
        return removedAdminEventFlowable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransferOwnershipEventResponse>() {
            @Override
            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFEROWNERSHIP_EVENT));
        return transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static ERTTokenV2 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV2(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV2(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV2 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV2(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV2(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(ERTTokenV2.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(ERTTokenV2.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(ERTTokenV2.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(ERTTokenV2.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class VestingEventResponse {
        public Log log;

        public String _target;

        public BigInteger _tokenAmount;
    }

    public static class VestingTransferEventResponse {
        public Log log;

        public String _from;

        public String _to;

        public BigInteger _value;
    }

    public static class RewardEventResponse {
        public Log log;

        public String _from;

        public String _to;

        public BigInteger _tokenAmount;

        public BigInteger _rewardAmount;
    }

    public static class InitializationEventResponse {
        public Log log;

        public String _from;

        public String _to;

        public BigInteger _tokenAmount;

        public BigInteger _etherAmount;
    }

    public static class UpgradedEventResponse {
        public Log log;

        public BigInteger implementationVersion;

        public String implementationAddress;
    }

    public static class UpgradedDataEventResponse {
        public Log log;

        public BigInteger dataVersion;

        public String dataAddress;
    }

    public static class TokenPriceChangedEventResponse {
        public Log log;

        public BigInteger tokenPrice;
    }

    public static class TransactionFeeEventResponse {
        public Log log;

        public String from;

        public BigInteger tokenFee;

        public BigInteger etherFeeRefund;
    }

    public static class NoSufficientFundEventResponse {
        public Log log;

        public BigInteger balance;
    }

    public static class DepositReceivedEventResponse {
        public Log log;

        public String from;

        public BigInteger amount;
    }

    public static class TransferEventResponse {
        public Log log;

        public String _from;

        public String _to;

        public BigInteger _value;
    }

    public static class ApprovalEventResponse {
        public Log log;

        public String _owner;

        public String _spender;

        public BigInteger _value;
    }

    public static class ApprovedAccountEventResponse {
        public Log log;

        public String target;
    }

    public static class DisapprovedAccountEventResponse {
        public Log log;

        public String target;
    }

    public static class ContractPausedEventResponse {
        public Log log;
    }

    public static class ContractUnPausedEventResponse {
        public Log log;
    }

    public static class AddedAdminEventResponse {
        public Log log;

        public String target;

        public BigInteger level;
    }

    public static class RemovedAdminEventResponse {
        public Log log;

        public String target;
    }

    public static class TransferOwnershipEventResponse {
        public Log log;

        public String newOwner;
    }
}
