"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:ast:read");
const Conversion = __importStar(require("../../conversion"));
const Evm = __importStar(require("../../evm"));
const Ast = __importStar(require("../../ast"));
const errors_1 = require("../../errors");
function readDefinition(pointer) {
    const definition = pointer.definition;
    debug("definition %o", definition);
    switch (Ast.Utils.typeClass(definition)) {
        case "rational":
            let numericalValue = Ast.Utils.rationalValue(definition);
            return Conversion.toBytes(numericalValue, Evm.Utils.WORD_SIZE);
        //you may be wondering, why do we not just use definition.value here,
        //like we do below? answer: because if this isn't a literal, that may not
        //exist
        case "stringliteral":
            return Conversion.toBytes(definition.hexValue);
        default:
            //unfortunately, other types of constants are just too complicated to
            //handle right now.  sorry.
            debug("unsupported constant definition type");
            throw new errors_1.DecodingError({
                kind: "UnsupportedConstantError",
                definition
            });
    }
}
exports.readDefinition = readDefinition;
//# sourceMappingURL=index.js.map