"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:memory:allocate");
const Evm = __importStar(require("../../evm"));
function getMemoryAllocations(userDefinedTypes) {
    let allocations = {};
    for (const dataType of Object.values(userDefinedTypes)) {
        if (dataType.typeClass === "struct") {
            allocations[dataType.id] = allocateStruct(dataType);
        }
    }
    return allocations;
}
exports.getMemoryAllocations = getMemoryAllocations;
//unlike in storage and calldata, we'll just return the one allocation, nothing fancy
//that's because allocating one struct can never necessitate allocating another
function allocateStruct(dataType) {
    let memberAllocations = [];
    let position = 0;
    for (const { name, type: memberType } of dataType.memberTypes) {
        const length = memberType.typeClass === "mapping" ? 0 : Evm.Utils.WORD_SIZE;
        memberAllocations.push({
            name,
            type: memberType,
            pointer: {
                location: "memory",
                start: position,
                length
            }
        });
        position += length;
    }
    return {
        members: memberAllocations
    };
}
//# sourceMappingURL=index.js.map