"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const StorageRead = __importStar(require("./storage/read"));
const StackRead = __importStar(require("./stack/read"));
const BytesRead = __importStar(require("./bytes/read"));
const AstConstantRead = __importStar(require("./ast-constant/read"));
const TopicRead = __importStar(require("./topic/read"));
const SpecialRead = __importStar(require("./special/read"));
const errors_1 = require("./errors");
function* read(pointer, state) {
    switch (pointer.location) {
        case "stack":
            return StackRead.readStack(pointer, state);
        case "storage":
            return yield* StorageRead.readStorage(pointer, state);
        case "memory":
        case "calldata":
        case "eventdata":
        case "returndata":
            return BytesRead.readBytes(pointer, state);
        case "code":
            //keeping this separate
            return yield* BytesRead.readCode(pointer, state);
        case "stackliteral":
            return StackRead.readStackLiteral(pointer);
        case "definition":
            return AstConstantRead.readDefinition(pointer);
        case "special":
            return SpecialRead.readSpecial(pointer, state);
        case "eventtopic":
            return TopicRead.readTopic(pointer, state);
        case "nowhere":
            throw new errors_1.DecodingError({
                kind: "UnusedImmutableError"
            });
    }
}
exports.default = read;
//# sourceMappingURL=read.js.map