<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

# Resolver

**Parameters**

-   `ens`  
-   `node`  
-   `contract`  

## resolverAddress

resolverAddress returns the address of the resolver.

Returns **any** A promise for the address of the resolver.

## reverseAddr

reverseAddr looks up the reverse record for the address returned by the resolver's addr()

Returns **any** A promise for the Resolver for the reverse record.

## abi

abi returns the ABI associated with the name. Automatically looks for an ABI on the
    reverse record if none is found on the name itself.

**Parameters**

-   `Optional.null` **bool** If false, do not look up the ABI on the reverse entry.
-   `reverse`  

Returns **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** A promise for the contract ABI.

## contract

contract returns a web3 contract object. The address is that returned by this resolver's
`addr()`, and the ABI is loaded from this resolver's `ABI()` method, or the ABI on the
reverse record if that's not found. Returns null if no address is specified or no ABI
was found. The returned contract object will not be promisifed or otherwise modified.

Returns **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** A promise for the contract instance.

# ENS

Provides an easy-to-use interface to the Ethereum Name Service.

Example usage:

```javascript
var ENS = require('ethereum-ens');
var Web3 = require('web3');

var provider = new Web3.providers.HttpProvider();
var ens = new ENS(provider);

var address = ens.resolver('foo.eth').addr().then(function(addr) { ... });
```
Functions that require communicating with the node return promises, rather than
using callbacks. A promise has a `then` function, which takes a callback and will
call it when the promise is fulfilled; `then` returns another promise, so you can
chain callbacks. For more details, see <http://bluebirdjs.com/>.

Notably, the `resolver` method returns a resolver instance immediately; lookup of
the resolver address is done in the background or when you first call an asynchronous
method on the resolver.

Functions that create transactions also take an optional 'options' argument;
this has the same parameters as web3.

**Parameters**

-   `provider` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** A web3 provider to use to communicate with the blockchain.
-   `address` **address** Optional. The address of the ENS registry. Defaults to the public ENS registry.

**Meta**

-   **author**: Nick Johnson &lt;nick@ethereum.org>
-   **license**: LGPL

## resolver

resolver returns a resolver object for the specified name, throwing
ENS.NameNotFound if the name does not exist in ENS.
Resolver objects are wrappers around web3 contract objects, with the
first argument - always the node ID in an ENS resolver - automatically
supplied. So, to call the `addr(node)` function on a standard resolver,
you only have to call `addr()`. Returned objects are also 'promisified' - they
return a Bluebird Promise object instead of taking a callback.

**Parameters**

-   `name` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The name to look up.
-   `abi` **list** Optional. The JSON ABI definition to use for the resolver.
           if none is supplied, a default definition implementing `has`, `addr`, `name`,
           `setName` and `setAddr` is supplied.

Returns **any** The resolver object.

## reverse

reverse returns a resolver object for the reverse resolution of the specified address,
throwing ENS.NameNotFound if the reverse record does not exist in ENS.
Resolver objects are wrappers around web3 contract objects, with the
first argument - always the node ID in an ENS resolver - automatically
supplied. So, to call the `addr(node)` function on a standard resolver,
you only have to call `addr()`. Returned objects are also 'promisified' - they
return a Bluebird Promise object instead of taking a callback.

**Parameters**

-   `address` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The address to look up.
-   `abi` **list** Optional. The JSON ABI definition to use for the resolver.
           if none is supplied, a default definition implementing `has`, `addr`, `name`,
           `setName` and `setAddr` is supplied.

Returns **any** The resolver object.

## setResolver

setResolver sets the address of the resolver contract for the specified name.
The calling account must be the owner of the name in order for this call to
succeed.

**Parameters**

-   `name` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The name to update
-   `address` **address** The address of the resolver
-   `options` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** An optional dict of parameters to pass to web3.
-   `addr`  
-   `params`  

Returns **any** A promise that returns the transaction ID when the transaction is mined.

## owner

owner returns the address of the owner of the specified name.

**Parameters**

-   `name` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The name to look up.
-   `callback`  

Returns **any** A promise returning the owner address of the specified name.

## setOwner

setOwner sets the owner of the specified name. Only the owner may call
setResolver or setSubnodeOwner. The calling account must be the current
owner of the name in order for this call to succeed.

**Parameters**

-   `name` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The name to update
-   `address` **address** The address of the new owner
-   `options` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** An optional dict of parameters to pass to web3.
-   `addr`  
-   `params`  

Returns **any** A promise returning the transaction ID of the transaction, once mined.

## setSubnodeOwner

setSubnodeOwner sets the owner of the specified name. The calling account
must be the owner of the parent name in order for this call to succeed -
for example, to call setSubnodeOwner on 'foo.bar.eth', the caller must be
the owner of 'bar.eth'.

**Parameters**

-   `name` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The name to update
-   `address` **address** The address of the new owner
-   `options` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** An optional dict of parameters to pass to web3.
-   `addr`  
-   `params`  

Returns **any** A promise returning the transaction ID of the transaction, once mined.
