import * as Ast from "../ast";
import * as Compiler from "../compiler";
import { ContractObject as Artifact } from "@truffle/contract-schema/spec";
import * as Common from "@truffle/compile-common";
import { Compilation, Contract, VyperSourceMap } from "./types";
export declare function shimCompilations(inputCompilations: Common.Compilation[], shimmedCompilationIdPrefix?: string): Compilation[];
export declare function shimCompilation(inputCompilation: Common.Compilation, shimmedCompilationId?: string): Compilation;
/**
 * wrapper around shimContracts that just returns
 * the result in a one-element array (keeping the old name
 * shimArtifacts for compatibility)
 */
export declare function shimArtifacts(artifacts: (Artifact | Common.CompiledContract)[], files?: string[], shimmedCompilationId?: string): Compilation[];
interface CompilationOptions {
    files?: string[];
    sources?: Common.Source[];
    shimmedCompilationId?: string;
    compiler?: Compiler.CompilerVersion;
}
/**
 * shims a bunch of contracts ("artifacts", though not necessarily)
 * to a compilation.  usually used via one of the above functions.
 * Note: if you pass in options.sources, options.files will be ignored.
 * Note: if you pass in options.sources, sources will not have
 * compiler set unless you also pass in options.compiler; in this case
 * you should set that up separately, as in shimCompilation().
 */
export declare function shimContracts(artifacts: (Artifact | Common.CompiledContract)[], options?: CompilationOptions): Compilation;
export declare function getContractNode(contract: Contract, compilation: Compilation): Ast.AstNode;
/**
 * convert Vyper source maps to solidity ones
 * (note we won't bother handling the case where the compressed
 * version doesn't exist; that will have to wait for a later version)
 */
export declare function simpleShimSourceMap(sourceMap: string | VyperSourceMap): string;
export {};
