import * as Common from "../common";
import * as Storage from "../storage/types";
import * as Ast from "../ast";
import { StorageAllocations, StateAllocations } from "../storage/allocate/types";
import { MemoryAllocations } from "../memory/allocate/types";
import { AbiAllocations, CalldataAllocations, EventAllocations } from "../abi-data/allocate/types";
import * as Contexts from "../contexts/types";
import * as Format from "../format";
export interface EvmState {
    storage: WordMapping;
    stack?: Uint8Array[];
    memory?: Uint8Array;
    calldata?: Uint8Array;
    code?: Uint8Array;
    specials?: {
        [builtin: string]: Uint8Array;
    };
    eventdata?: Uint8Array;
    eventtopics?: Uint8Array[];
    returndata?: Uint8Array;
}
export interface WordMapping {
    [slotAddress: string]: Uint8Array;
}
export interface EvmInfo {
    state: EvmState;
    mappingKeys?: Storage.Slot[];
    userDefinedTypes?: Format.Types.TypesById;
    allocations: AllocationInfo;
    contexts?: Contexts.Contexts;
    currentContext?: Contexts.Context;
    internalFunctionsTable?: InternalFunctions;
}
export interface AllocationInfo {
    storage?: StorageAllocations;
    memory?: MemoryAllocations;
    abi?: AbiAllocations;
    calldata?: CalldataAllocations;
    event?: EventAllocations;
    state?: StateAllocations;
}
export interface InternalFunctions {
    [pc: number]: InternalFunction;
}
export interface InternalFunction {
    sourceIndex?: number;
    compilationId?: string;
    pointer?: string;
    node?: Ast.AstNode;
    name?: string;
    id?: number;
    mutability?: Common.Mutability;
    contractPointer?: string;
    contractNode?: Ast.AstNode;
    contractName?: string;
    contractId?: number;
    contractKind?: Common.ContractKind;
    contractPayable?: boolean;
    isDesignatedInvalid: boolean;
}
