'use strict'

const CID = require('cids')
const multiaddr = require('multiaddr')
const toCamel = require('../lib/object-to-camel')
const configure = require('../lib/configure')
const toUrlSearchParams = require('../lib/to-url-search-params')
const multipartRequest = require('../lib/multipart-request')
const { anySignal } = require('any-signal')
const AbortController = require('native-abort-controller')
module.exports = configure(api => {
  /**
   * @type {import('..').ImplementsMethod<'put', import('ipfs-core/src/components/dht')>}
   */
  async function * put (key, value, options = {}) {
    // allow aborting requests on body errors
    const controller = new AbortController()
    const signal = anySignal([controller.signal, options.signal])

    const res = await api.post('dht/put', {
      timeout: options.timeout,
      signal,
      searchParams: toUrlSearchParams({
        arg: key,
        ...options
      }),
      ...(
        await multipartRequest(value, controller, options.headers)
      )
    })

    for await (let message of res.ndjson()) {
      message = toCamel(message)
      message.id = new CID(message.id)
      if (message.responses) {
        message.responses = message.responses.map(({ ID, Addrs }) => ({
          id: ID,
          addrs: (Addrs || []).map(a => multiaddr(a))
        }))
      }
      yield message
    }
  }

  return put
})
