export interface Interval {
    readonly low: number;
    readonly high: number;
}
export declare class Node<T extends Interval> {
    intervalTree: IntervalTree<T>;
    key: number;
    max: number;
    records: T[];
    parent?: Node<T>;
    height: number;
    left?: Node<T>;
    right?: Node<T>;
    constructor(intervalTree: IntervalTree<T>, record: T);
    getNodeHigh(): number;
    updateHeight(): void;
    updateMaxOfParents(): void;
    private _updateMaxAfterRightRotate();
    private _updateMaxAfterLeftRotate();
    private _leftRotate();
    private _rightRotate();
    private _rebalance();
    insert(record: T): void;
    private _getOverlappingRecords(currentNode, low, high);
    search(low: number, high: number): T[];
    searchExisting(low: number): Node<T> | undefined;
    private _minValue();
    remove(node: Node<T>): Node<T> | undefined;
}
export declare class IntervalTree<T extends Interval> {
    root?: Node<T>;
    count: number;
    insert(record: T): boolean;
    search(low: number, high: number): T[];
    remove(record: T): boolean;
    inOrder(): InOrder<T>;
    preOrder(): PreOrder<T>;
}
export interface DataInterval<T> extends Interval {
    data: T;
}
export default class DataIntervalTree<T> {
    private tree;
    insert(low: number, high: number, data: T): boolean;
    remove(low: number, high: number, data: T): boolean;
    search(low: number, high: number): T[];
    inOrder(): InOrder<DataInterval<T>>;
    preOrder(): PreOrder<DataInterval<T>>;
    readonly count: number;
}
export declare class InOrder<T extends Interval> implements IterableIterator<T> {
    private stack;
    private currentNode?;
    private i;
    constructor(startNode?: Node<T>);
    next(): IteratorResult<T>;
    private push(node);
    private pop();
}
export interface InOrder<T extends Interval> {
    [Symbol.iterator](): IterableIterator<T>;
}
export declare class PreOrder<T extends Interval> implements IterableIterator<T> {
    private stack;
    private currentNode?;
    private i;
    constructor(startNode?: Node<T>);
    next(): IteratorResult<T>;
    private push(node);
    private pop();
}
export interface PreOrder<T extends Interval> {
    [Symbol.iterator](): IterableIterator<T>;
}
