"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestLedgerDevice = requestLedgerDevice;
exports.getLedgerDevices = getLedgerDevices;
exports.getFirstLedgerDevice = getFirstLedgerDevice;
exports.isSupported = void 0;

var _devices = require("@ledgerhq/devices");

const ledgerDevices = [{
  vendorId: _devices.ledgerUSBVendorId
}];

async function requestLedgerDevice() {
  // $FlowFixMe
  const device = await navigator.usb.requestDevice({
    filters: ledgerDevices
  });
  return device;
}

async function getLedgerDevices() {
  // $FlowFixMe
  const devices = await navigator.usb.getDevices();
  return devices.filter(d => d.vendorId === _devices.ledgerUSBVendorId);
}

async function getFirstLedgerDevice() {
  const existingDevices = await getLedgerDevices();
  if (existingDevices.length > 0) return existingDevices[0];
  return requestLedgerDevice();
}

const isSupported = () => Promise.resolve(!!navigator && // $FlowFixMe
!!navigator.usb && typeof navigator.usb.getDevices === "function");

exports.isSupported = isSupported;
//# sourceMappingURL=webusb.js.map