import * as Abi from "@truffle/abi-utils";
import * as Compiler from "../../compiler";
import * as Ast from "../../ast";
import * as Contexts from "../../contexts/types";
import * as Pointer from "../../pointer";
import { DecodingMode } from "../../types";
import { ImmutableReferences } from "@truffle/contract-schema/spec";
import * as Format from "../../format";
export interface ContractAllocationInfo {
    abi?: Abi.Abi;
    contractNode: Ast.AstNode;
    deployedContext?: Contexts.Context;
    constructorContext?: Contexts.Context;
    immutableReferences?: ImmutableReferences;
    compiler: Compiler.CompilerVersion;
    compilationId?: string;
}
export interface AbiSizeInfo {
    size: number;
    dynamic: boolean;
}
export interface AbiAllocations {
    [id: string]: AbiAllocation | null;
}
export interface AbiAllocation {
    length: number;
    dynamic: boolean;
    members: AbiMemberAllocation[];
}
export interface AbiMemberAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.GenericAbiPointer;
}
export interface CalldataAllocations {
    constructorAllocations: CalldataConstructorAllocations;
    functionAllocations: CalldataFunctionAllocations;
}
export interface CalldataConstructorAllocations {
    [contextHash: string]: CalldataAndReturndataAllocation;
}
export interface CalldataFunctionAllocations {
    [contextHash: string]: {
        [selector: string]: CalldataAndReturndataAllocation;
    };
}
export interface CalldataAndReturndataAllocation {
    input: CalldataAllocation;
    output: ReturndataAllocation;
}
export interface CalldataAllocation {
    abi: Abi.FunctionEntry | Abi.ConstructorEntry;
    offset: number;
    arguments: CalldataArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface CalldataArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.CalldataPointer;
}
export interface EventAllocations {
    [topics: number]: {
        bySelector: {
            [selector: string]: {
                [contractKind: string]: {
                    [contextHash: string]: EventAllocation[];
                };
            };
        };
        anonymous: {
            [contractKind: string]: {
                [contextHash: string]: EventAllocation[];
            };
        };
    };
}
export interface EventAllocation {
    abi: Abi.EventEntry;
    contextHash: string;
    definedIn?: Format.Types.ContractType;
    anonymous: boolean;
    arguments: EventArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface EventArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.EventDataPointer | Pointer.EventTopicPointer;
}
export declare type ReturndataKind = FunctionReturndataKind | ConstructorReturndataKind;
export declare type FunctionReturndataKind = "return" | "revert" | "failure" | "selfdestruct";
export declare type ConstructorReturndataKind = "bytecode";
export declare type AdditionalReturndataKind = "returnmessage";
export declare type ReturndataAllocation = FunctionReturndataAllocation | ConstructorReturndataAllocation | AdditionalReturndataAllocation;
export interface FunctionReturndataAllocation {
    kind: FunctionReturndataKind;
    selector: Uint8Array;
    abi?: Abi.ErrorEntry;
    arguments: ReturndataArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface ConstructorReturndataAllocation {
    kind: ConstructorReturndataKind;
    selector: Uint8Array;
    immutables?: ReturnImmutableAllocation[];
    delegatecallGuard: boolean;
    allocationMode: DecodingMode;
}
export interface AdditionalReturndataAllocation {
    kind: AdditionalReturndataKind;
    selector: Uint8Array;
    allocationMode: DecodingMode;
}
export interface ReturndataArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.ReturndataPointer;
}
export interface ReturnImmutableAllocation {
    name: string;
    type: Format.Types.Type;
    definedIn: Format.Types.ContractType;
    pointer: Pointer.ReturndataPointer;
}
export interface EventAllocationTemporary {
    selector: string;
    anonymous: boolean;
    topics: number;
    allocation: EventAllocation | undefined;
}
export interface CalldataAllocationTemporary {
    constructorAllocation?: CalldataAndReturndataAllocation;
    functionAllocations: {
        [selector: string]: CalldataAndReturndataAllocation;
    };
}
