import { array } from './ArrayArbitrary.js';
import { constantFrom } from './ConstantArbitrary.js';
import { nat } from './IntegerArbitrary.js';
import { oneof } from './OneOfArbitrary.js';
import { hexaString } from './StringArbitrary.js';
import { tuple } from './TupleArbitrary.js';
function ipV4() {
    return tuple(nat(255), nat(255), nat(255), nat(255)).map(([a, b, c, d]) => `${a}.${b}.${c}.${d}`);
}
function ipV4Extended() {
    const natRepr = (maxValue) => tuple(constantFrom('dec', 'oct', 'hex'), nat(maxValue)).map(([style, v]) => {
        switch (style) {
            case 'oct':
                return `0${Number(v).toString(8)}`;
            case 'hex':
                return `0x${Number(v).toString(16)}`;
            case 'dec':
            default:
                return `${v}`;
        }
    });
    return oneof(tuple(natRepr(255), natRepr(255), natRepr(255), natRepr(255)).map(([a, b, c, d]) => `${a}.${b}.${c}.${d}`), tuple(natRepr(255), natRepr(255), natRepr(65535)).map(([a, b, c]) => `${a}.${b}.${c}`), tuple(natRepr(255), natRepr(16777215)).map(([a, b]) => `${a}.${b}`), natRepr(4294967295));
}
function ipV6() {
    const h16Arb = hexaString({ minLength: 1, maxLength: 4 });
    const ls32Arb = oneof(tuple(h16Arb, h16Arb).map(([a, b]) => `${a}:${b}`), ipV4());
    return oneof(tuple(array(h16Arb, { minLength: 6, maxLength: 6 }), ls32Arb).map(([eh, l]) => `${eh.join(':')}:${l}`), tuple(array(h16Arb, { minLength: 5, maxLength: 5 }), ls32Arb).map(([eh, l]) => `::${eh.join(':')}:${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 1 }), array(h16Arb, { minLength: 4, maxLength: 4 }), ls32Arb).map(([bh, eh, l]) => `${bh.join(':')}::${eh.join(':')}:${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 2 }), array(h16Arb, { minLength: 3, maxLength: 3 }), ls32Arb).map(([bh, eh, l]) => `${bh.join(':')}::${eh.join(':')}:${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 3 }), array(h16Arb, { minLength: 2, maxLength: 2 }), ls32Arb).map(([bh, eh, l]) => `${bh.join(':')}::${eh.join(':')}:${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 4 }), h16Arb, ls32Arb).map(([bh, eh, l]) => `${bh.join(':')}::${eh}:${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 5 }), ls32Arb).map(([bh, l]) => `${bh.join(':')}::${l}`), tuple(array(h16Arb, { minLength: 0, maxLength: 6 }), h16Arb).map(([bh, eh]) => `${bh.join(':')}::${eh}`), tuple(array(h16Arb, { minLength: 0, maxLength: 7 })).map(([bh]) => `${bh.join(':')}::`));
}
export { ipV4, ipV4Extended, ipV6 };
