/**
 * @param {any} obj
 * @returns {obj is ArrayBufferView|ArrayBuffer}
 */
export function isBytes(obj: any): obj is ArrayBufferView | ArrayBuffer;
/**
 * @param {any} obj
 * @returns {obj is Blob}
 */
export function isBlob(obj: any): obj is Blob;
/**
 * An object with a path or content property
 *
 * @param {any} obj
 * @returns {obj is import('ipfs-core-types/src/files').ToEntry}
 */
export function isFileObject(obj: any): obj is import("ipfs-core-types/src/files").ToEntry;
/**
 * @param {any} value
 * @returns {value is ReadableStream}
 */
export function isReadableStream(value: any): value is ReadableStream<any>;
/**
 * @param {any} mtime
 * @returns {{secs:number, nsecs:number}|undefined}
 */
export function mtimeToObject(mtime: any): {
    secs: number;
    nsecs: number;
} | undefined;
/**
 * @param {any} mode
 * @returns {number|undefined}
 */
export function modeToNumber(mode: any): number | undefined;
//# sourceMappingURL=utils.d.ts.map