/// <reference types="node" />
export = configure;
/**
 * @typedef { import("./core").ClientOptions } ClientOptions
 */
/**
 * @template T
 * @typedef {(client: Client, clientOptions: ClientOptions) => T} Fn
 */
/**
 * @template T
 * @typedef {(clientOptions: ClientOptions) => T} Factory
 */
/**
 * @template T
 * @param {Fn<T>} fn
 * @returns {Factory<T>}
 */
declare function configure<T>(fn: (client: import("./core"), clientOptions: ClientOptions) => T): (clientOptions: ClientOptions) => T;
declare namespace configure {
    export { ClientOptions, Fn, Factory };
}
type Fn<T> = (client: import("./core"), clientOptions: ClientOptions) => T;
type ClientOptions = {
    host?: string | undefined;
    port?: number | undefined;
    protocol?: string | undefined;
    /**
     * - Request headers.
     */
    headers?: Headers | Record<string, string> | undefined;
    /**
     * - Amount of time until request should timeout in ms or humand readable. https://www.npmjs.com/package/parse-duration for valid string values.
     */
    timeout?: string | number | undefined;
    /**
     * - Path to the API.
     */
    apiPath?: string | undefined;
    /**
     * - Full API URL.
     */
    url?: string | import("multiaddr") | URL | undefined;
    ipld?: {
        /**
         * - An array of additional [IPLD formats](https://github.com/ipld/interface-ipld-format) to support
         */
        formats?: any[] | undefined;
        /**
         * - an async function that takes the name of an [IPLD format](https://github.com/ipld/interface-ipld-format) as a string and should return the implementation of that codec
         */
        loadFormat?: ((format: string) => Promise<any>) | undefined;
    } | undefined;
    /**
     * - A [http.Agent](https://nodejs.org/api/http.html#http_class_http_agent) used to control connection persistence and reuse for HTTP clients (only supported in node.js)
     */
    agent?: import("http").Agent | import("https").Agent | undefined;
};
type Factory<T> = (clientOptions: ClientOptions) => T;
//# sourceMappingURL=configure.d.ts.map