/// <reference types="node" />
export = Client;
declare const Client_base: any;
/**
 * @typedef {import('http').Agent} HttpAgent
 * @typedef {import('https').Agent} HttpsAgent
 *
 * @typedef {Object} ClientOptions
 * @property {string} [host]
 * @property {number} [port]
 * @property {string} [protocol]
 * @property {Headers|Record<string, string>} [headers] - Request headers.
 * @property {number|string} [timeout] - Amount of time until request should timeout in ms or humand readable. https://www.npmjs.com/package/parse-duration for valid string values.
 * @property {string} [apiPath] - Path to the API.
 * @property {URL|string|Multiaddr} [url] - Full API URL.
 * @property {object} [ipld]
 * @property {any[]} [ipld.formats] - An array of additional [IPLD formats](https://github.com/ipld/interface-ipld-format) to support
 * @property {(format: string) => Promise<any>} [ipld.loadFormat] - an async function that takes the name of an [IPLD format](https://github.com/ipld/interface-ipld-format) as a string and should return the implementation of that codec
 * @property {HttpAgent|HttpsAgent} [agent] - A [http.Agent](https://nodejs.org/api/http.html#http_class_http_agent) used to control connection persistence and reuse for HTTP clients (only supported in node.js)
 */
declare class Client extends Client_base {
    [x: string]: any;
    /**
     * @param {ClientOptions|URL|Multiaddr|string} [options]
     */
    constructor(options?: string | import("multiaddr") | ClientOptions | URL | undefined);
    fetch: (resource: any, options?: {}) => any;
}
declare namespace Client {
    export { errorHandler, HttpAgent, HttpsAgent, ClientOptions };
}
type ClientOptions = {
    host?: string | undefined;
    port?: number | undefined;
    protocol?: string | undefined;
    /**
     * - Request headers.
     */
    headers?: Headers | Record<string, string> | undefined;
    /**
     * - Amount of time until request should timeout in ms or humand readable. https://www.npmjs.com/package/parse-duration for valid string values.
     */
    timeout?: string | number | undefined;
    /**
     * - Path to the API.
     */
    apiPath?: string | undefined;
    /**
     * - Full API URL.
     */
    url?: string | import("multiaddr") | URL | undefined;
    ipld?: {
        /**
         * - An array of additional [IPLD formats](https://github.com/ipld/interface-ipld-format) to support
         */
        formats?: any[] | undefined;
        /**
         * - an async function that takes the name of an [IPLD format](https://github.com/ipld/interface-ipld-format) as a string and should return the implementation of that codec
         */
        loadFormat?: ((format: string) => Promise<any>) | undefined;
    } | undefined;
    /**
     * - A [http.Agent](https://nodejs.org/api/http.html#http_class_http_agent) used to control connection persistence and reuse for HTTP clients (only supported in node.js)
     */
    agent?: import("http").Agent | import("https").Agent | undefined;
};
declare function errorHandler(response: any): Promise<never>;
type HttpAgent = import("http").Agent;
type HttpsAgent = import("https").Agent;
//# sourceMappingURL=core.d.ts.map