# IPLD Block JavaScript Implementation

[![](https://img.shields.io/badge/made%20by-Protocol%20Labs-blue.svg?style=flat-square)](http://ipn.io)
[![](https://img.shields.io/badge/project-IPLD-blue.svg?style=flat-square)](http://ipld.io/)
[![](https://img.shields.io/badge/freenode-%23ipld-blue.svg?style=flat-square)](http://webchat.freenode.net/?channels=%23ipld)
[![standard-readme compliant](https://img.shields.io/badge/standard--readme-OK-green.svg?style=flat-square)](https://github.com/RichardLitt/standard-readme)
[![Travis CI](https://flat.badgen.net/travis/ipld/js-ipld-block)](https://travis-ci.com/ipld/js-ipld-block)
[![Coverage Status](https://coveralls.io/repos/github/ipld/js-ipld-block/badge.svg?branch=master)](https://coveralls.io/github/ipld/js-ipld-block?branch=master)
[![Dependency Status](https://david-dm.org/ipld/js-ipld-block.svg?style=flat-square)](https://david-dm.org/ipld/js-ipld-block)
[![js-standard-style](https://img.shields.io/badge/code%20style-standard-brightgreen.svg?style=flat-square)](https://github.com/feross/standard)
![](https://img.shields.io/badge/npm-%3E%3D3.0.0-orange.svg?style=flat-square)
![](https://img.shields.io/badge/Node.js-%3E%3D4.0.0-orange.svg?style=flat-square)

> [IPLD][ipld] implementation of the Block data structure in JavaScript.

**Block** - A block is a blob of binary data combined with a [CID].

## Lead Maintainer

[Volker Mische](https://github.com/vmx)

## Table of Contents

- [IPLD Block JavaScript Implementation](#ipld-block-javascript-implementation)
  - [Lead Maintainer](#lead-maintainer)
  - [Table of Contents](#table-of-contents)
  - [Install](#install)
    - [npm](#npm)
  - [Usage](#usage)
    - [Node.js](#nodejs)
      - [Example](#example)
    - [Browser: Browserify, Webpack, other bundlers](#browser-browserify-webpack-other-bundlers)
    - [Browser: `<script>` Tag](#browser-script-tag)
  - [API](#api)
    - [Block](#block)
      - [`new Block(data, cid)`](#new-blockdata-cid)
      - [`block.data`](#blockdata)
      - [`block.cid`](#blockcid)
  - [Contribute](#contribute)
  - [License](#license)

## Install

### npm

```sh
> npm install ipld-block
```

## Usage

### Node.js

```js
const Block = require('ipld-block')
```

#### Example

```js
const Block = require('ipld-block')
const encoder = new TextEncoder('utf8')

// create a block
const block = new Block(encoder.encode('hello world'), cid)
console.log(block.data.toString())
```

### Browser: Browserify, Webpack, other bundlers

The code published to npm that gets loaded on require is in fact a ES5
transpiled version with the right shims added. This means that you can require
it and use with your favourite bundler without having to adjust asset management
process.

```js
const Block = require('ipld-block')
```

### Browser: `<script>` Tag

Loading this module through a script tag will make the `IpldBlock` obj available in
the global namespace.

```html
<script src="https://unpkg.com/ipld-block/dist/index.min.js"></script>
<!-- OR -->
<script src="https://unpkg.com/ipld-block/dist/index.js"></script>
```

## API

```js
const Block = require('ipld-block')
```

### Block

#### `new Block(data, cid)`

- `data: Uint8Array`

Creates a new block with raw data `data`.

#### `block.data`

The raw data of the block. Its format matches whatever was provided in its constructor.

#### `block.cid`

The cid of the block.

[ipld]: https://ipld.io/
[multihash]: https://github.com/multiformats/js-multihash
[CID]: https://github.com/multiformats/js-cid

## Contribute

Feel free to join in. All welcome. Open an [issue](https://github.com/ipld/js-ipld-block/issues)!

This repository falls under the IPFS [Code of Conduct](https://github.com/ipfs/community/blob/master/code-of-conduct.md).

[![](https://cdn.rawgit.com/jbenet/contribute-ipfs-gif/master/img/contribute.gif)](https://github.com/ipfs/community/blob/master/contributing.md)

## License

[MIT](LICENSE)
