import { hash } from '../../utils/hash.js';
import { stringify } from '../../utils/stringify.js';
import { cloneMethod, hasCloneMethod } from '../symbols.js';
import { array } from './ArrayArbitrary.js';
import { integer } from './IntegerArbitrary.js';
import { tuple } from './TupleArbitrary.js';
import { escapeForMultilineComments } from './helpers/TextEscaper.js';
export function func(arb) {
    return tuple(array(arb, { minLength: 1 }), integer().noShrink()).map(([outs, seed]) => {
        const producer = () => {
            const recorded = {};
            const f = (...args) => {
                const repr = stringify(args);
                const val = outs[hash(`${seed}${repr}`) % outs.length];
                recorded[repr] = val;
                return hasCloneMethod(val) ? val[cloneMethod]() : val;
            };
            return Object.assign(f, {
                toString: () => {
                    const seenValues = Object.keys(recorded)
                        .sort()
                        .map((k) => `${k} => ${stringify(recorded[k])}`)
                        .map((line) => `/* ${escapeForMultilineComments(line)} */`);
                    return `function(...args) {
  // With hash and stringify coming from fast-check${seenValues.length !== 0 ? `\n  ${seenValues.join('\n  ')}` : ''}
  const outs = ${stringify(outs)};
  return outs[hash('${seed}' + stringify(args)) % outs.length];
}`;
                },
                [cloneMethod]: producer,
            });
        };
        return producer();
    });
}
function compareFuncImplem(cmp) {
    return tuple(integer().noShrink(), integer(1, 0xffffffff).noShrink()).map(([seed, hashEnvSize]) => {
        const producer = () => {
            const recorded = {};
            const f = (a, b) => {
                const reprA = stringify(a);
                const reprB = stringify(b);
                const hA = hash(`${seed}${reprA}`) % hashEnvSize;
                const hB = hash(`${seed}${reprB}`) % hashEnvSize;
                const val = cmp(hA, hB);
                recorded[`[${reprA},${reprB}]`] = val;
                return val;
            };
            return Object.assign(f, {
                toString: () => {
                    const seenValues = Object.keys(recorded)
                        .sort()
                        .map((k) => `${k} => ${stringify(recorded[k])}`)
                        .map((line) => `/* ${escapeForMultilineComments(line)} */`);
                    return `function(a, b) {
  // With hash and stringify coming from fast-check${seenValues.length !== 0 ? `\n  ${seenValues.join('\n  ')}` : ''}
  const cmp = ${cmp};
  const hA = hash('${seed}' + stringify(a)) % ${hashEnvSize};
  const hB = hash('${seed}' + stringify(b)) % ${hashEnvSize};
  return cmp(hA, hB);
}`;
                },
                [cloneMethod]: producer,
            });
        };
        return producer();
    });
}
export function compareFunc() {
    return compareFuncImplem(Object.assign((hA, hB) => hA - hB, {
        toString() {
            return '(hA, hB) => hA - hB';
        },
    }));
}
export function compareBooleanFunc() {
    return compareFuncImplem(Object.assign((hA, hB) => hA < hB, {
        toString() {
            return '(hA, hB) => hA < hB';
        },
    }));
}
