export = Block;
/**
 * Represents an immutable block of data that is uniquely referenced with a cid.
 *
 * @example
 * const block = new Block(Uint8Array.from([0, 1, 2, 3]), new CID('...'))
 */
declare class Block {
    /**
     * Check if the given value is a Block.
     *
     * @param {any} other
     * @returns {other is Block}
     */
    static isBlock(other: any): other is Block;
    /**
     * @param {Uint8Array} data - The data to be stored in the block as a Uint8Array.
     * @param {CID} cid - The cid of the data
     */
    constructor(data: Uint8Array, cid: CID);
    data: Uint8Array;
    cid: CID;
    /**
     * The data of this block.
     *
     * @deprecated
     * @type {Uint8Array}
     */
    get _data(): Uint8Array;
    /**
     * The cid of the data this block represents.
     *
     * @deprecated
     * @type {CID}
     */
    get _cid(): CID;
    get [Symbol.toStringTag](): string;
    get [blockSymbol](): boolean;
}
import CID = require("cids");
declare const blockSymbol: unique symbol;
//# sourceMappingURL=index.d.ts.map